/* CharacterData.c generated by valac 0.20.1, the Vala compiler
 * generated from CharacterData.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* CharacterData.vala
 *
 * Copyright (C) 2011-2013  Richard Schwarting <aquarichy@gmail.com>
 * Copyright (C) 2011  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authors:
 *      Richard Schwarting <aquarichy@gmail.com>
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libxml/tree.h>


#define GXML_TYPE_DOM_NODE (gxml_dom_node_get_type ())
#define GXML_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NODE, GXmlDomNode))
#define GXML_DOM_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_NODE, GXmlDomNodeClass))
#define GXML_IS_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NODE))
#define GXML_IS_DOM_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_NODE))
#define GXML_DOM_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_NODE, GXmlDomNodeClass))

typedef struct _GXmlDomNode GXmlDomNode;
typedef struct _GXmlDomNodeClass GXmlDomNodeClass;
typedef struct _GXmlDomNodePrivate GXmlDomNodePrivate;

#define GXML_TYPE_NODE_LIST (gxml_node_list_get_type ())
#define GXML_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE_LIST, GXmlNodeList))
#define GXML_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE_LIST))
#define GXML_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE_LIST, GXmlNodeListIface))

typedef struct _GXmlNodeList GXmlNodeList;
typedef struct _GXmlNodeListIface GXmlNodeListIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_ATTR (gxml_attr_get_type ())
#define GXML_ATTR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTR, GXmlAttr))
#define GXML_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ATTR, GXmlAttrClass))
#define GXML_IS_ATTR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTR))
#define GXML_IS_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ATTR))
#define GXML_ATTR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ATTR, GXmlAttrClass))

typedef struct _GXmlAttr GXmlAttr;
typedef struct _GXmlAttrClass GXmlAttrClass;

#define GXML_TYPE_BACKED_NODE (gxml_backed_node_get_type ())
#define GXML_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNode))
#define GXML_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))
#define GXML_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_BACKED_NODE))
#define GXML_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_BACKED_NODE))
#define GXML_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))

typedef struct _GXmlBackedNode GXmlBackedNode;
typedef struct _GXmlBackedNodeClass GXmlBackedNodeClass;
typedef struct _GXmlBackedNodePrivate GXmlBackedNodePrivate;

#define GXML_TYPE_CHARACTER_DATA (gxml_character_data_get_type ())
#define GXML_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_CHARACTER_DATA, GXmlCharacterData))
#define GXML_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_CHARACTER_DATA, GXmlCharacterDataClass))
#define GXML_IS_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_CHARACTER_DATA))
#define GXML_IS_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_CHARACTER_DATA))
#define GXML_CHARACTER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_CHARACTER_DATA, GXmlCharacterDataClass))

typedef struct _GXmlCharacterData GXmlCharacterData;
typedef struct _GXmlCharacterDataClass GXmlCharacterDataClass;
typedef struct _GXmlCharacterDataPrivate GXmlCharacterDataPrivate;

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOCUMENT, GXmlDocumentClass))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentClass))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentClass GXmlDocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	GXML_DOM_ERROR_INDEX_SIZE,
	GXML_DOM_ERROR_DOMSTRING_SIZE,
	GXML_DOM_ERROR_HIERARCHY_REQUEST,
	GXML_DOM_ERROR_WRONG_DOCUMENT,
	GXML_DOM_ERROR_INVALID_CHARACTER,
	GXML_DOM_ERROR_NO_DATA_ALLOWED,
	GXML_DOM_ERROR_NO_MODIFICATION_ALLOWED,
	GXML_DOM_ERROR_NOT_FOUND,
	GXML_DOM_ERROR_NOT_SUPPORTED,
	GXML_DOM_ERROR_INUSE_ATTRIBUTE,
	GXML_DOM_ERROR_DOM,
	GXML_DOM_ERROR_INVALID_DOC,
	GXML_DOM_ERROR_INVALID_ROOT
} GXmlDomError;
#define GXML_DOM_ERROR gxml_dom_error_quark ()
struct _GXmlNodeListIface {
	GTypeInterface parent_iface;
	GXmlDomNode* (*item) (GXmlNodeList* self, gulong idx);
	void (*foreach) (GXmlNodeList* self, GFunc func, void* func_target);
	GXmlDomNode* (*first) (GXmlNodeList* self);
	GXmlDomNode* (*last) (GXmlNodeList* self);
	GXmlDomNode* (*nth) (GXmlNodeList* self, gulong n);
	GXmlDomNode* (*nth_data) (GXmlNodeList* self, gulong n);
	GXmlDomNode* (*nth_prev) (GXmlNodeList* self, GXmlDomNode* pivot, gulong n);
	gint (*find) (GXmlNodeList* self, GXmlDomNode* target);
	gint (*find_custom) (GXmlNodeList* self, GXmlDomNode* target, GCompareFunc cmp);
	gint (*position) (GXmlNodeList* self, GXmlDomNode* target);
	gint (*index) (GXmlNodeList* self, GXmlDomNode* target);
	GXmlDomNode* (*insert_before) (GXmlNodeList* self, GXmlDomNode* new_child, GXmlDomNode* ref_child, GError** error);
	GXmlDomNode* (*replace_child) (GXmlNodeList* self, GXmlDomNode* new_child, GXmlDomNode* old_child, GError** error);
	GXmlDomNode* (*remove_child) (GXmlNodeList* self, GXmlDomNode* old_child);
	GXmlDomNode* (*append_child) (GXmlNodeList* self, GXmlDomNode* new_child);
	gchar* (*to_string) (GXmlNodeList* self, gboolean in_line);
	gulong (*get_length) (GXmlNodeList* self);
	void (*set_length) (GXmlNodeList* self, gulong value);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDomNode {
	GObject parent_instance;
	GXmlDomNodePrivate * priv;
};

struct _GXmlDomNodeClass {
	GObjectClass parent_class;
	GXmlDomNode* (*insert_before) (GXmlDomNode* self, GXmlDomNode* new_child, GXmlDomNode* ref_child, GError** error);
	GXmlDomNode* (*replace_child) (GXmlDomNode* self, GXmlDomNode* new_child, GXmlDomNode* old_child, GError** error);
	GXmlDomNode* (*remove_child) (GXmlDomNode* self, GXmlDomNode* old_child, GError** error);
	GXmlDomNode* (*append_child) (GXmlDomNode* self, GXmlDomNode* new_child, GError** error);
	gboolean (*has_child_nodes) (GXmlDomNode* self);
	GXmlDomNode* (*clone_nodes) (GXmlDomNode* self, gboolean deep);
	gchar* (*to_string) (GXmlDomNode* self, gboolean format, gint level);
	GXmlNodeList* (*get_namespace_definitions) (GXmlDomNode* self);
	void (*set_namespace_definitions) (GXmlDomNode* self, GXmlNodeList* value);
	const gchar* (*get_namespace_uri) (GXmlDomNode* self);
	void (*set_namespace_uri) (GXmlDomNode* self, const gchar* value);
	const gchar* (*get_prefix) (GXmlDomNode* self);
	void (*set_prefix) (GXmlDomNode* self, const gchar* value);
	const gchar* (*get_local_name) (GXmlDomNode* self);
	void (*set_local_name) (GXmlDomNode* self, const gchar* value);
	const gchar* (*get_node_name) (GXmlDomNode* self);
	void (*set_node_name) (GXmlDomNode* self, const gchar* value);
	const gchar* (*get_node_value) (GXmlDomNode* self);
	void (*set_node_value) (GXmlDomNode* self, const gchar* value);
	GXmlNodeType (*get_node_type) (GXmlDomNode* self);
	void (*set_node_type) (GXmlDomNode* self, GXmlNodeType value);
	GXmlDomNode* (*get_parent_node) (GXmlDomNode* self);
	void (*set_parent_node) (GXmlDomNode* self, GXmlDomNode* value);
	GXmlNodeList* (*get_child_nodes) (GXmlDomNode* self);
	void (*set_child_nodes) (GXmlDomNode* self, GXmlNodeList* value);
	GXmlDomNode* (*get_first_child) (GXmlDomNode* self);
	void (*set_first_child) (GXmlDomNode* self, GXmlDomNode* value);
	GXmlDomNode* (*get_last_child) (GXmlDomNode* self);
	void (*set_last_child) (GXmlDomNode* self, GXmlDomNode* value);
	GXmlDomNode* (*get_previous_sibling) (GXmlDomNode* self);
	void (*set_previous_sibling) (GXmlDomNode* self, GXmlDomNode* value);
	GXmlDomNode* (*get_next_sibling) (GXmlDomNode* self);
	void (*set_next_sibling) (GXmlDomNode* self, GXmlDomNode* value);
	GHashTable* (*get_attributes) (GXmlDomNode* self);
	void (*set_attributes) (GXmlDomNode* self, GHashTable* value);
};

struct _GXmlBackedNode {
	GXmlDomNode parent_instance;
	GXmlBackedNodePrivate * priv;
	xmlNode* node;
};

struct _GXmlBackedNodeClass {
	GXmlDomNodeClass parent_class;
};

struct _GXmlCharacterData {
	GXmlBackedNode parent_instance;
	GXmlCharacterDataPrivate * priv;
};

struct _GXmlCharacterDataClass {
	GXmlBackedNodeClass parent_class;
};


static gpointer gxml_character_data_parent_class = NULL;

GType gxml_dom_node_get_type (void) G_GNUC_CONST;
GQuark gxml_dom_error_quark (void);
GType gxml_node_list_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_attr_get_type (void) G_GNUC_CONST;
GType gxml_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_character_data_get_type (void) G_GNUC_CONST;
enum  {
	GXML_CHARACTER_DATA_DUMMY_PROPERTY,
	GXML_CHARACTER_DATA_DATA,
	GXML_CHARACTER_DATA_LENGTH
};
GType gxml_document_get_type (void) G_GNUC_CONST;
GXmlCharacterData* gxml_character_data_new (xmlNode* char_node, GXmlDocument* doc);
GXmlCharacterData* gxml_character_data_construct (GType object_type, xmlNode* char_node, GXmlDocument* doc);
GXmlBackedNode* gxml_backed_node_new (xmlNode* node, GXmlDocument* owner);
GXmlBackedNode* gxml_backed_node_construct (GType object_type, xmlNode* node, GXmlDocument* owner);
gchar* gxml_character_data_substring_data (GXmlCharacterData* self, gulong offset, gulong count);
const gchar* gxml_character_data_get_data (GXmlCharacterData* self);
void gxml_character_data_append_data (GXmlCharacterData* self, const gchar* arg);
void gxml_character_data_set_data (GXmlCharacterData* self, const gchar* value);
void gxml_character_data_insert_data (GXmlCharacterData* self, gulong offset, const gchar* arg);
void gxml_character_data_delete_data (GXmlCharacterData* self, gulong offset, gulong count);
void gxml_character_data_replace_data (GXmlCharacterData* self, gulong offset, gulong count, const gchar* arg);
const gchar* gxml_dom_node_get_node_value (GXmlDomNode* self);
void gxml_dom_node_set_node_value (GXmlDomNode* self, const gchar* value);
gulong gxml_character_data_get_length (GXmlCharacterData* self);
static void gxml_character_data_set_length (GXmlCharacterData* self, gulong value);
static void _vala_gxml_character_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gxml_character_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GXmlCharacterData* gxml_character_data_construct (GType object_type, xmlNode* char_node, GXmlDocument* doc) {
	GXmlCharacterData * self = NULL;
	xmlNode* _tmp0_;
	GXmlDocument* _tmp1_;
	g_return_val_if_fail (doc != NULL, NULL);
	_tmp0_ = char_node;
	_tmp1_ = doc;
	self = (GXmlCharacterData*) gxml_backed_node_construct (object_type, _tmp0_, _tmp1_);
	return self;
}


GXmlCharacterData* gxml_character_data_new (xmlNode* char_node, GXmlDocument* doc) {
	return gxml_character_data_construct (GXML_TYPE_CHARACTER_DATA, char_node, doc);
}


/**
 * Retrieves a substring of the character data
 * count-characters long, starting from the character
 * at offset.
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* gxml_character_data_substring_data (GXmlCharacterData* self, gulong offset, gulong count) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gulong _tmp2_;
	gulong _tmp3_;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_character_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = offset;
	_tmp3_ = count;
	_tmp4_ = string_substring (_tmp1_, (glong) _tmp2_, (glong) _tmp3_);
	result = _tmp4_;
	return result;
}


/**
 * Appends arg to the end of the character data.
 */
void gxml_character_data_append_data (GXmlCharacterData* self, const gchar* arg) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = gxml_character_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = arg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	gxml_character_data_set_data (self, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
 * Inserts arg into the character data at offset.
 */
void gxml_character_data_insert_data (GXmlCharacterData* self, gulong offset, const gchar* arg) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gulong _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gulong _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = gxml_character_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = offset;
	_tmp3_ = string_substring (_tmp1_, (glong) 0, (glong) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = arg;
	_tmp6_ = gxml_character_data_get_data (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = offset;
	_tmp9_ = string_substring (_tmp7_, (glong) _tmp8_, (glong) (-1));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp4_, _tmp5_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	gxml_character_data_set_data (self, _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp4_);
}


/**
 * Deletes a range of characters, count-characters long, starting from offset.
 */
void gxml_character_data_delete_data (GXmlCharacterData* self, gulong offset, gulong count) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gulong _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gulong _tmp7_;
	gulong _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gxml_character_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = offset;
	_tmp3_ = string_substring (_tmp1_, (glong) 0, (glong) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gxml_character_data_get_data (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = offset;
	_tmp8_ = count;
	_tmp9_ = string_substring (_tmp6_, (glong) (_tmp7_ + _tmp8_), (glong) (-1));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp4_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	gxml_character_data_set_data (self, _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp4_);
}


/**
 * Replaces a range of characters, count-characters
 * long, starting at offset, with arg.
 */
void gxml_character_data_replace_data (GXmlCharacterData* self, gulong offset, gulong count, const gchar* arg) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gulong _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gulong _tmp8_;
	gulong _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = gxml_character_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = offset;
	_tmp3_ = string_substring (_tmp1_, (glong) 0, (glong) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = arg;
	_tmp6_ = gxml_character_data_get_data (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = offset;
	_tmp9_ = count;
	_tmp10_ = string_substring (_tmp7_, (glong) (_tmp8_ + _tmp9_), (glong) (-1));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp4_, _tmp5_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	gxml_character_data_set_data (self, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp4_);
}


const gchar* gxml_character_data_get_data (GXmlCharacterData* self) {
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_dom_node_get_node_value ((GXmlDomNode*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}


void gxml_character_data_set_data (GXmlCharacterData* self, const gchar* value) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	gxml_dom_node_set_node_value ((GXmlDomNode*) self, _tmp0_);
	g_object_notify ((GObject *) self, "data");
}


gulong gxml_character_data_get_length (GXmlCharacterData* self) {
	gulong result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = gxml_character_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	result = (gulong) _tmp3_;
	return result;
}


static void gxml_character_data_set_length (GXmlCharacterData* self, gulong value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "length");
}


static void gxml_character_data_class_init (GXmlCharacterDataClass * klass) {
	gxml_character_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_character_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_character_data_set_property;
	/**
	 * The character data in string form for the node.
	 * Generally equivalent to node_value.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_CHARACTER_DATA_DATA, g_param_spec_string ("data", "data", "data", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The number of characters.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_CHARACTER_DATA_LENGTH, g_param_spec_ulong ("length", "length", "length", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gxml_character_data_instance_init (GXmlCharacterData * self) {
}


/**
 * CharacterData defines an interface for manipulating XML character data.
 *
 * It is used by the {@link GXml.CDATASection},
 * {@link GXml.Text}, and {@link GXml.Comment} node types. For more,
 * see:
 * [[http://www.w3.org/TR/DOM-Level-1/level-one-core.html#ID-FF21A306]]
 */
GType gxml_character_data_get_type (void) {
	static volatile gsize gxml_character_data_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_character_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlCharacterDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_character_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlCharacterData), 0, (GInstanceInitFunc) gxml_character_data_instance_init, NULL };
		GType gxml_character_data_type_id;
		gxml_character_data_type_id = g_type_register_static (GXML_TYPE_BACKED_NODE, "GXmlCharacterData", &g_define_type_info, 0);
		g_once_init_leave (&gxml_character_data_type_id__volatile, gxml_character_data_type_id);
	}
	return gxml_character_data_type_id__volatile;
}


static void _vala_gxml_character_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlCharacterData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_CHARACTER_DATA, GXmlCharacterData);
	switch (property_id) {
		case GXML_CHARACTER_DATA_DATA:
		g_value_set_string (value, gxml_character_data_get_data (self));
		break;
		case GXML_CHARACTER_DATA_LENGTH:
		g_value_set_ulong (value, gxml_character_data_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_character_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlCharacterData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_CHARACTER_DATA, GXmlCharacterData);
	switch (property_id) {
		case GXML_CHARACTER_DATA_DATA:
		gxml_character_data_set_data (self, g_value_get_string (value));
		break;
		case GXML_CHARACTER_DATA_LENGTH:
		gxml_character_data_set_length (self, g_value_get_ulong (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



