/* Element.c generated by valac 0.20.1, the Vala compiler
 * generated from Element.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* Element.vala
 *
 * Copyright (C) 2011-2013  Richard Schwarting <aquarichy@gmail.com>
 * Copyright (C) 2011  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Richard Schwarting <aquarichy@gmail.com>
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libxml/tree.h>
#include <libxml/parser.h>


#define GXML_TYPE_DOM_NODE (gxml_dom_node_get_type ())
#define GXML_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NODE, GXmlDomNode))
#define GXML_DOM_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_NODE, GXmlDomNodeClass))
#define GXML_IS_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NODE))
#define GXML_IS_DOM_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_NODE))
#define GXML_DOM_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_NODE, GXmlDomNodeClass))

typedef struct _GXmlDomNode GXmlDomNode;
typedef struct _GXmlDomNodeClass GXmlDomNodeClass;
typedef struct _GXmlDomNodePrivate GXmlDomNodePrivate;

#define GXML_TYPE_NODE_LIST (gxml_node_list_get_type ())
#define GXML_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE_LIST, GXmlNodeList))
#define GXML_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE_LIST))
#define GXML_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE_LIST, GXmlNodeListIface))

typedef struct _GXmlNodeList GXmlNodeList;
typedef struct _GXmlNodeListIface GXmlNodeListIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_ATTR (gxml_attr_get_type ())
#define GXML_ATTR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTR, GXmlAttr))
#define GXML_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ATTR, GXmlAttrClass))
#define GXML_IS_ATTR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTR))
#define GXML_IS_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ATTR))
#define GXML_ATTR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ATTR, GXmlAttrClass))

typedef struct _GXmlAttr GXmlAttr;
typedef struct _GXmlAttrClass GXmlAttrClass;

#define GXML_TYPE_BACKED_NODE (gxml_backed_node_get_type ())
#define GXML_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNode))
#define GXML_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))
#define GXML_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_BACKED_NODE))
#define GXML_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_BACKED_NODE))
#define GXML_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))

typedef struct _GXmlBackedNode GXmlBackedNode;
typedef struct _GXmlBackedNodeClass GXmlBackedNodeClass;
typedef struct _GXmlBackedNodePrivate GXmlBackedNodePrivate;

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT, GXmlElementClass))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT, GXmlElementClass))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementClass GXmlElementClass;
typedef struct _GXmlElementPrivate GXmlElementPrivate;

#define GXML_TYPE_GLIST_NODE_LIST (gxml_glist_node_list_get_type ())
#define GXML_GLIST_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_GLIST_NODE_LIST, GXmlGListNodeList))
#define GXML_GLIST_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_GLIST_NODE_LIST, GXmlGListNodeListClass))
#define GXML_IS_GLIST_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_GLIST_NODE_LIST))
#define GXML_IS_GLIST_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_GLIST_NODE_LIST))
#define GXML_GLIST_NODE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_GLIST_NODE_LIST, GXmlGListNodeListClass))

typedef struct _GXmlGListNodeList GXmlGListNodeList;
typedef struct _GXmlGListNodeListClass GXmlGListNodeListClass;

#define GXML_TYPE_TAG_NAME_NODE_LIST (gxml_tag_name_node_list_get_type ())
#define GXML_TAG_NAME_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TAG_NAME_NODE_LIST, GXmlTagNameNodeList))
#define GXML_TAG_NAME_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_TAG_NAME_NODE_LIST, GXmlTagNameNodeListClass))
#define GXML_IS_TAG_NAME_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TAG_NAME_NODE_LIST))
#define GXML_IS_TAG_NAME_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_TAG_NAME_NODE_LIST))
#define GXML_TAG_NAME_NODE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_TAG_NAME_NODE_LIST, GXmlTagNameNodeListClass))

typedef struct _GXmlTagNameNodeList GXmlTagNameNodeList;
typedef struct _GXmlTagNameNodeListClass GXmlTagNameNodeListClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GXmlAttrPrivate GXmlAttrPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOCUMENT, GXmlDocumentClass))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentClass))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentClass GXmlDocumentClass;
typedef struct _GXmlGListNodeListPrivate GXmlGListNodeListPrivate;
typedef struct _GXmlTagNameNodeListPrivate GXmlTagNameNodeListPrivate;
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
typedef struct _GXmlDocumentPrivate GXmlDocumentPrivate;

typedef enum  {
	GXML_DOM_ERROR_INDEX_SIZE,
	GXML_DOM_ERROR_DOMSTRING_SIZE,
	GXML_DOM_ERROR_HIERARCHY_REQUEST,
	GXML_DOM_ERROR_WRONG_DOCUMENT,
	GXML_DOM_ERROR_INVALID_CHARACTER,
	GXML_DOM_ERROR_NO_DATA_ALLOWED,
	GXML_DOM_ERROR_NO_MODIFICATION_ALLOWED,
	GXML_DOM_ERROR_NOT_FOUND,
	GXML_DOM_ERROR_NOT_SUPPORTED,
	GXML_DOM_ERROR_INUSE_ATTRIBUTE,
	GXML_DOM_ERROR_DOM,
	GXML_DOM_ERROR_INVALID_DOC,
	GXML_DOM_ERROR_INVALID_ROOT
} GXmlDomError;
#define GXML_DOM_ERROR gxml_dom_error_quark ()
struct _GXmlNodeListIface {
	GTypeInterface parent_iface;
	GXmlDomNode* (*item) (GXmlNodeList* self, gulong idx);
	void (*foreach) (GXmlNodeList* self, GFunc func, void* func_target);
	GXmlDomNode* (*first) (GXmlNodeList* self);
	GXmlDomNode* (*last) (GXmlNodeList* self);
	GXmlDomNode* (*nth) (GXmlNodeList* self, gulong n);
	GXmlDomNode* (*nth_data) (GXmlNodeList* self, gulong n);
	GXmlDomNode* (*nth_prev) (GXmlNodeList* self, GXmlDomNode* pivot, gulong n);
	gint (*find) (GXmlNodeList* self, GXmlDomNode* target);
	gint (*find_custom) (GXmlNodeList* self, GXmlDomNode* target, GCompareFunc cmp);
	gint (*position) (GXmlNodeList* self, GXmlDomNode* target);
	gint (*index) (GXmlNodeList* self, GXmlDomNode* target);
	GXmlDomNode* (*insert_before) (GXmlNodeList* self, GXmlDomNode* new_child, GXmlDomNode* ref_child, GError** error);
	GXmlDomNode* (*replace_child) (GXmlNodeList* self, GXmlDomNode* new_child, GXmlDomNode* old_child, GError** error);
	GXmlDomNode* (*remove_child) (GXmlNodeList* self, GXmlDomNode* old_child);
	GXmlDomNode* (*append_child) (GXmlNodeList* self, GXmlDomNode* new_child);
	gchar* (*to_string) (GXmlNodeList* self, gboolean in_line);
	gulong (*get_length) (GXmlNodeList* self);
	void (*set_length) (GXmlNodeList* self, gulong value);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDomNode {
	GObject parent_instance;
	GXmlDomNodePrivate * priv;
};

struct _GXmlDomNodeClass {
	GObjectClass parent_class;
	GXmlDomNode* (*insert_before) (GXmlDomNode* self, GXmlDomNode* new_child, GXmlDomNode* ref_child, GError** error);
	GXmlDomNode* (*replace_child) (GXmlDomNode* self, GXmlDomNode* new_child, GXmlDomNode* old_child, GError** error);
	GXmlDomNode* (*remove_child) (GXmlDomNode* self, GXmlDomNode* old_child, GError** error);
	GXmlDomNode* (*append_child) (GXmlDomNode* self, GXmlDomNode* new_child, GError** error);
	gboolean (*has_child_nodes) (GXmlDomNode* self);
	GXmlDomNode* (*clone_nodes) (GXmlDomNode* self, gboolean deep);
	gchar* (*to_string) (GXmlDomNode* self, gboolean format, gint level);
	GXmlNodeList* (*get_namespace_definitions) (GXmlDomNode* self);
	void (*set_namespace_definitions) (GXmlDomNode* self, GXmlNodeList* value);
	const gchar* (*get_namespace_uri) (GXmlDomNode* self);
	void (*set_namespace_uri) (GXmlDomNode* self, const gchar* value);
	const gchar* (*get_prefix) (GXmlDomNode* self);
	void (*set_prefix) (GXmlDomNode* self, const gchar* value);
	const gchar* (*get_local_name) (GXmlDomNode* self);
	void (*set_local_name) (GXmlDomNode* self, const gchar* value);
	const gchar* (*get_node_name) (GXmlDomNode* self);
	void (*set_node_name) (GXmlDomNode* self, const gchar* value);
	const gchar* (*get_node_value) (GXmlDomNode* self);
	void (*set_node_value) (GXmlDomNode* self, const gchar* value);
	GXmlNodeType (*get_node_type) (GXmlDomNode* self);
	void (*set_node_type) (GXmlDomNode* self, GXmlNodeType value);
	GXmlDomNode* (*get_parent_node) (GXmlDomNode* self);
	void (*set_parent_node) (GXmlDomNode* self, GXmlDomNode* value);
	GXmlNodeList* (*get_child_nodes) (GXmlDomNode* self);
	void (*set_child_nodes) (GXmlDomNode* self, GXmlNodeList* value);
	GXmlDomNode* (*get_first_child) (GXmlDomNode* self);
	void (*set_first_child) (GXmlDomNode* self, GXmlDomNode* value);
	GXmlDomNode* (*get_last_child) (GXmlDomNode* self);
	void (*set_last_child) (GXmlDomNode* self, GXmlDomNode* value);
	GXmlDomNode* (*get_previous_sibling) (GXmlDomNode* self);
	void (*set_previous_sibling) (GXmlDomNode* self, GXmlDomNode* value);
	GXmlDomNode* (*get_next_sibling) (GXmlDomNode* self);
	void (*set_next_sibling) (GXmlDomNode* self, GXmlDomNode* value);
	GHashTable* (*get_attributes) (GXmlDomNode* self);
	void (*set_attributes) (GXmlDomNode* self, GHashTable* value);
};

struct _GXmlBackedNode {
	GXmlDomNode parent_instance;
	GXmlBackedNodePrivate * priv;
	xmlNode* node;
};

struct _GXmlBackedNodeClass {
	GXmlDomNodeClass parent_class;
};

struct _GXmlElement {
	GXmlBackedNode parent_instance;
	GXmlElementPrivate * priv;
};

struct _GXmlElementClass {
	GXmlBackedNodeClass parent_class;
};

struct _GXmlElementPrivate {
	GHashTable* _attributes;
	GList* tag_name_lists;
};

struct _GXmlAttr {
	GXmlDomNode parent_instance;
	GXmlAttrPrivate * priv;
	xmlAttr* node;
};

struct _GXmlAttrClass {
	GXmlDomNodeClass parent_class;
};

struct _GXmlGListNodeList {
	GObject parent_instance;
	GXmlGListNodeListPrivate * priv;
	GXmlDomNode* root;
	GList* nodes;
};

struct _GXmlGListNodeListClass {
	GObjectClass parent_class;
};

struct _GXmlTagNameNodeList {
	GXmlGListNodeList parent_instance;
	GXmlTagNameNodeListPrivate * priv;
	gchar* tag_name;
};

struct _GXmlTagNameNodeListClass {
	GXmlGListNodeListClass parent_class;
};

struct _GXmlDocument {
	GXmlDomNode parent_instance;
	GXmlDocumentPrivate * priv;
	GHashTable* node_dict;
	GList* dirty_elements;
	xmlDoc* xmldoc;
};

struct _GXmlDocumentClass {
	GXmlDomNodeClass parent_class;
};


static gpointer gxml_element_parent_class = NULL;

GType gxml_dom_node_get_type (void) G_GNUC_CONST;
GQuark gxml_dom_error_quark (void);
GType gxml_node_list_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_attr_get_type (void) G_GNUC_CONST;
GType gxml_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_element_get_type (void) G_GNUC_CONST;
GType gxml_glist_node_list_get_type (void) G_GNUC_CONST;
GType gxml_tag_name_node_list_get_type (void) G_GNUC_CONST;
#define GXML_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_ELEMENT, GXmlElementPrivate))
enum  {
	GXML_ELEMENT_DUMMY_PROPERTY,
	GXML_ELEMENT_TAG_NAME,
	GXML_ELEMENT_NODE_VALUE,
	GXML_ELEMENT_ATTRIBUTES,
	GXML_ELEMENT_CONTENT
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void gxml_element_save_attributes (GXmlElement* self, xmlNode* tmp_node);
const gchar* gxml_dom_node_get_namespace_uri (GXmlDomNode* self);
const gchar* gxml_dom_node_get_prefix (GXmlDomNode* self);
const gchar* gxml_dom_node_get_node_value (GXmlDomNode* self);
GType gxml_document_get_type (void) G_GNUC_CONST;
GXmlElement* gxml_element_new (xmlNode* node, GXmlDocument* doc);
GXmlElement* gxml_element_construct (GType object_type, xmlNode* node, GXmlDocument* doc);
GXmlBackedNode* gxml_backed_node_new (xmlNode* node, GXmlDocument* owner);
GXmlBackedNode* gxml_backed_node_construct (GType object_type, xmlNode* node, GXmlDocument* owner);
gchar* gxml_element_get_attribute (GXmlElement* self, const gchar* name);
GHashTable* gxml_dom_node_get_attributes (GXmlDomNode* self);
const gchar* gxml_attr_get_value (GXmlAttr* self);
void gxml_element_set_attribute (GXmlElement* self, const gchar* name, const gchar* value, GError** error);
GXmlDocument* gxml_dom_node_get_owner_document (GXmlDomNode* self);
GXmlAttr* gxml_document_create_attribute (GXmlDocument* self, const gchar* name, GError** error);
void gxml_attr_set_value (GXmlAttr* self, const gchar* value);
void gxml_element_remove_attribute (GXmlElement* self, const gchar* name, GError** error);
GXmlAttr* gxml_element_get_attribute_node (GXmlElement* self, const gchar* name);
GXmlAttr* gxml_element_set_attribute_node (GXmlElement* self, GXmlAttr* new_attr, GError** error);
const gchar* gxml_attr_get_name (GXmlAttr* self);
GXmlAttr* gxml_element_remove_attribute_node (GXmlElement* self, GXmlAttr* old_attr, GError** error);
static void gxml_element_check_add_tag_name (GXmlElement* self, GXmlElement* basenode, GXmlDomNode* child);
GXmlNodeType gxml_dom_node_get_node_type (GXmlDomNode* self);
static void gxml_element_on_new_descendant_with_tag_name (GXmlElement* self, GXmlElement* elem);
GXmlNodeList* gxml_dom_node_get_child_nodes (GXmlDomNode* self);
static void gxml_element_check_remove_tag_name (GXmlElement* self, GXmlElement* basenode, GXmlDomNode* child);
static void gxml_element_on_remove_descendant_with_tag_name (GXmlElement* self, GXmlElement* elem);
static GXmlDomNode* gxml_element_real_insert_before (GXmlDomNode* base, GXmlDomNode* new_child, GXmlDomNode* ref_child, GError** error);
GXmlDomNode* gxml_dom_node_insert_before (GXmlDomNode* self, GXmlDomNode* new_child, GXmlDomNode* ref_child, GError** error);
static GXmlDomNode* gxml_element_real_replace_child (GXmlDomNode* base, GXmlDomNode* new_child, GXmlDomNode* old_child, GError** error);
GXmlDomNode* gxml_dom_node_replace_child (GXmlDomNode* self, GXmlDomNode* new_child, GXmlDomNode* old_child, GError** error);
static GXmlDomNode* gxml_element_real_remove_child (GXmlDomNode* base, GXmlDomNode* old_child, GError** error);
GXmlDomNode* gxml_dom_node_remove_child (GXmlDomNode* self, GXmlDomNode* old_child, GError** error);
static GXmlDomNode* gxml_element_real_append_child (GXmlDomNode* base, GXmlDomNode* new_child, GError** error);
GXmlDomNode* gxml_dom_node_append_child (GXmlDomNode* self, GXmlDomNode* new_child, GError** error);
const gchar* gxml_element_get_tag_name (GXmlElement* self);
GXmlDomNode* gxml_node_list_append_child (GXmlNodeList* self, GXmlDomNode* new_child);
GXmlDomNode* gxml_dom_node_get_parent_node (GXmlDomNode* self);
GXmlDomNode* gxml_node_list_remove_child (GXmlNodeList* self, GXmlDomNode* old_child);
GXmlNodeList* gxml_element_get_elements_by_tag_name (GXmlElement* self, const gchar* tag_name);
GXmlTagNameNodeList* gxml_tag_name_node_list_new (const gchar* tag_name, GXmlDomNode* root, GXmlDocument* owner);
GXmlTagNameNodeList* gxml_tag_name_node_list_construct (GType object_type, const gchar* tag_name, GXmlDomNode* root, GXmlDocument* owner);
GXmlDomNode* gxml_document_lookup_node (GXmlDocument* self, xmlNode* xmlnode);
void gxml_element_normalize (GXmlElement* self);
const gchar* gxml_dom_node_get_node_name (GXmlDomNode* self);
static void gxml_element_set_tag_name (GXmlElement* self, const gchar* value);
static void _g_free0_ (gpointer var);
GXmlAttr* gxml_attr_new (xmlAttr* node, GXmlDocument* doc);
GXmlAttr* gxml_attr_construct (GType object_type, xmlAttr* node, GXmlDocument* doc);
gchar* gxml_element_get_content (GXmlElement* self);
void gxml_element_set_content (GXmlElement* self, const gchar* value);
static void gxml_element_finalize (GObject* obj);
static void _vala_gxml_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gxml_dom_node_set_node_value (GXmlDomNode* self, const gchar* value);
void gxml_dom_node_set_attributes (GXmlDomNode* self, GHashTable* value);
static void _vala_gxml_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


/**
 * This should be called before saving a GXml Document
 * to a libxml2 Xml.Doc*, or else any changes made to
 * attributes in the Element will only exist within
 * the hash table proxy and will not be recorded.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gxml_element_save_attributes (GXmlElement* self, xmlNode* tmp_node) {
	GXmlAttr* attr = NULL;
	xmlNs* ns = NULL;
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_attributes;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp22_;
		GList* _tmp23_ = NULL;
		{
			xmlNode* _tmp1_;
			xmlAttr* _tmp2_;
			xmlAttr* xmlattr;
			_tmp1_ = ((GXmlBackedNode*) self)->node;
			_tmp2_ = _tmp1_->properties;
			xmlattr = _tmp2_;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_;
					xmlAttr* _tmp7_;
					GHashTable* _tmp8_;
					xmlAttr* _tmp9_;
					const gchar* _tmp10_;
					gconstpointer _tmp11_ = NULL;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						xmlAttr* _tmp5_;
						xmlAttr* _tmp6_;
						_tmp5_ = xmlattr;
						_tmp6_ = _tmp5_->next;
						xmlattr = _tmp6_;
					}
					_tmp3_ = FALSE;
					_tmp7_ = xmlattr;
					if (!(_tmp7_ != NULL)) {
						break;
					}
					_tmp8_ = self->priv->_attributes;
					_tmp9_ = xmlattr;
					_tmp10_ = _tmp9_->name;
					_tmp11_ = g_hash_table_lookup (_tmp8_, _tmp10_);
					if (((GXmlAttr*) _tmp11_) == NULL) {
						xmlAttr* _tmp12_;
						xmlNs* _tmp13_;
						_tmp12_ = xmlattr;
						_tmp13_ = _tmp12_->ns;
						if (_tmp13_ == NULL) {
							xmlNode* _tmp14_;
							xmlAttr* _tmp15_;
							const gchar* _tmp16_;
							_tmp14_ = ((GXmlBackedNode*) self)->node;
							_tmp15_ = xmlattr;
							_tmp16_ = _tmp15_->name;
							xmlUnsetProp (_tmp14_, (xmlChar*) _tmp16_);
						} else {
							xmlNode* _tmp17_;
							xmlAttr* _tmp18_;
							xmlNs* _tmp19_;
							xmlAttr* _tmp20_;
							const gchar* _tmp21_;
							_tmp17_ = ((GXmlBackedNode*) self)->node;
							_tmp18_ = xmlattr;
							_tmp19_ = _tmp18_->ns;
							_tmp20_ = xmlattr;
							_tmp21_ = _tmp20_->name;
							xmlUnsetNsProp (_tmp17_, _tmp19_, (xmlChar*) _tmp21_);
						}
					}
				}
			}
		}
		_tmp22_ = self->priv->_attributes;
		_tmp23_ = g_hash_table_get_keys (_tmp22_);
		{
			GList* propname_collection = NULL;
			GList* propname_it = NULL;
			propname_collection = _tmp23_;
			for (propname_it = propname_collection; propname_it != NULL; propname_it = propname_it->next) {
				gchar* _tmp24_;
				gchar* propname = NULL;
				_tmp24_ = g_strdup ((const gchar*) propname_it->data);
				propname = _tmp24_;
				{
					GHashTable* _tmp25_;
					const gchar* _tmp26_;
					gconstpointer _tmp27_ = NULL;
					GXmlAttr* _tmp28_;
					xmlAttr* saved_attr = NULL;
					gboolean _tmp29_ = FALSE;
					GXmlAttr* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					gboolean _tmp36_;
					GXmlAttr* _tmp58_;
					xmlAttr* _tmp59_;
					xmlNode* _tmp60_;
					_tmp25_ = self->priv->_attributes;
					_tmp26_ = propname;
					_tmp27_ = g_hash_table_lookup (_tmp25_, _tmp26_);
					_tmp28_ = _g_object_ref0 ((GXmlAttr*) _tmp27_);
					_g_object_unref0 (attr);
					attr = _tmp28_;
					_tmp30_ = attr;
					_tmp31_ = gxml_dom_node_get_namespace_uri ((GXmlDomNode*) _tmp30_);
					_tmp32_ = _tmp31_;
					if (_tmp32_ != NULL) {
						_tmp29_ = TRUE;
					} else {
						GXmlAttr* _tmp33_;
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						_tmp33_ = attr;
						_tmp34_ = gxml_dom_node_get_prefix ((GXmlDomNode*) _tmp33_);
						_tmp35_ = _tmp34_;
						_tmp29_ = _tmp35_ != NULL;
					}
					_tmp36_ = _tmp29_;
					if (_tmp36_) {
						xmlNode* _tmp37_;
						GXmlAttr* _tmp38_;
						const gchar* _tmp39_;
						const gchar* _tmp40_;
						GXmlAttr* _tmp41_;
						const gchar* _tmp42_;
						const gchar* _tmp43_;
						xmlNs* _tmp44_ = NULL;
						xmlNode* _tmp45_;
						xmlNs* _tmp46_;
						const gchar* _tmp47_;
						GXmlAttr* _tmp48_;
						const gchar* _tmp49_;
						const gchar* _tmp50_;
						xmlAttr* _tmp51_ = NULL;
						_tmp37_ = tmp_node;
						_tmp38_ = attr;
						_tmp39_ = gxml_dom_node_get_namespace_uri ((GXmlDomNode*) _tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = attr;
						_tmp42_ = gxml_dom_node_get_prefix ((GXmlDomNode*) _tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = xmlNewNs (_tmp37_, (xmlChar*) _tmp40_, (xmlChar*) _tmp43_);
						ns = _tmp44_;
						_tmp45_ = ((GXmlBackedNode*) self)->node;
						_tmp46_ = ns;
						_tmp47_ = propname;
						_tmp48_ = attr;
						_tmp49_ = gxml_dom_node_get_node_value ((GXmlDomNode*) _tmp48_);
						_tmp50_ = _tmp49_;
						_tmp51_ = xmlSetNsProp (_tmp45_, _tmp46_, (xmlChar*) _tmp47_, (xmlChar*) _tmp50_);
						saved_attr = _tmp51_;
					} else {
						xmlNode* _tmp52_;
						const gchar* _tmp53_;
						GXmlAttr* _tmp54_;
						const gchar* _tmp55_;
						const gchar* _tmp56_;
						xmlAttr* _tmp57_ = NULL;
						_tmp52_ = ((GXmlBackedNode*) self)->node;
						_tmp53_ = propname;
						_tmp54_ = attr;
						_tmp55_ = gxml_dom_node_get_node_value ((GXmlDomNode*) _tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = xmlSetProp (_tmp52_, (xmlChar*) _tmp53_, (xmlChar*) _tmp56_);
						saved_attr = _tmp57_;
					}
					_tmp58_ = attr;
					_tmp59_ = _tmp58_->node;
					_tmp60_ = _tmp59_->parent;
					if (_tmp60_ == NULL) {
						GXmlAttr* _tmp61_;
						xmlAttr* _tmp62_;
						GXmlAttr* _tmp63_;
						xmlAttr* _tmp64_;
						_tmp61_ = attr;
						_tmp62_ = _tmp61_->node;
						xmlFreeProp (_tmp62_);
						_tmp63_ = attr;
						_tmp64_ = saved_attr;
						_tmp63_->node = _tmp64_;
					}
					_g_free0 (propname);
				}
			}
			_g_list_free0 (propname_collection);
		}
	}
	_g_object_unref0 (attr);
}


GXmlElement* gxml_element_construct (GType object_type, xmlNode* node, GXmlDocument* doc) {
	GXmlElement * self = NULL;
	xmlNode* _tmp0_;
	GXmlDocument* _tmp1_;
	g_return_val_if_fail (doc != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = doc;
	self = (GXmlElement*) gxml_backed_node_construct (object_type, _tmp0_, _tmp1_);
	return self;
}


GXmlElement* gxml_element_new (xmlNode* node, GXmlDocument* doc) {
	return gxml_element_construct (GXML_TYPE_ELEMENT, node, doc);
}


/**
 * Retrieve the attribute value, as a string, for an
 * attribute associated with this element with the
 * name name.
 *
 * Version: DOM Level 1 Core
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-666EE0F9]]
 *
 * @param name The name of the attribute whose value to retrieve.
 *
 * @return The value of the named attribute, or "" if
 * no such attribute is set.
 */
gchar* gxml_element_get_attribute (GXmlElement* self, const gchar* name) {
	gchar* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	GXmlAttr* _tmp4_;
	GXmlAttr* attr;
	GXmlAttr* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gxml_dom_node_get_attributes ((GXmlDomNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = name;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((GXmlAttr*) _tmp3_);
	attr = _tmp4_;
	_tmp5_ = attr;
	if (_tmp5_ != NULL) {
		GXmlAttr* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = attr;
		_tmp7_ = gxml_attr_get_value (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		_g_object_unref0 (attr);
		return result;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		result = _tmp10_;
		_g_object_unref0 (attr);
		return result;
	}
	_g_object_unref0 (attr);
}


/**
 * Set the value of this element's attribute named
 * name to the string value.
 *
 * Version: DOM Level 1 Core
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-F68F082]]
 *
 * @param name Name of the attribute whose value to set.
 * @param value The value to set.
 */
void gxml_element_set_attribute (GXmlElement* self, const gchar* name, const gchar* value, GError** error) {
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	GXmlAttr* _tmp4_;
	GXmlAttr* attr;
	GXmlAttr* _tmp5_;
	GXmlAttr* _tmp11_;
	const gchar* _tmp12_;
	GHashTable* _tmp13_;
	GHashTable* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GXmlAttr* _tmp17_;
	GXmlAttr* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = gxml_dom_node_get_attributes ((GXmlDomNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = name;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((GXmlAttr*) _tmp3_);
	attr = _tmp4_;
	_tmp5_ = attr;
	if (_tmp5_ == NULL) {
		GXmlDocument* _tmp6_;
		GXmlDocument* _tmp7_;
		const gchar* _tmp8_;
		GXmlAttr* _tmp9_ = NULL;
		GXmlAttr* _tmp10_;
		_tmp6_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = name;
		_tmp9_ = gxml_document_create_attribute (_tmp7_, _tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GXML_DOM_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (attr);
				return;
			} else {
				_g_object_unref0 (attr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (attr);
		attr = _tmp10_;
	}
	_tmp11_ = attr;
	_tmp12_ = value;
	gxml_attr_set_value (_tmp11_, _tmp12_);
	_tmp13_ = gxml_dom_node_get_attributes ((GXmlDomNode*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = name;
	_tmp16_ = g_strdup (_tmp15_);
	_tmp17_ = attr;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	g_hash_table_replace (_tmp14_, _tmp16_, _tmp18_);
	_g_object_unref0 (attr);
}


/**
 * Remove the attribute named name from this element.
 *
 * Version: DOM Level 1 Core
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-6D6AC0F9]]
 *
 * @param name The name of the attribute to unset.
 */
void gxml_element_remove_attribute (GXmlElement* self, const gchar* name, GError** error) {
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = gxml_dom_node_get_attributes ((GXmlDomNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = name;
	g_hash_table_remove (_tmp1_, _tmp2_);
}


/**
 * Get the Attr node representing this element's attribute named name.
 *
 * Version: DOM Level 1 Core
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-217A91B8]]
 *
 * @param name The name of the Attr node to retrieve.
 *
 * @return The Attr node named by name for this element, or null if none is set.
 */
GXmlAttr* gxml_element_get_attribute_node (GXmlElement* self, const gchar* name) {
	GXmlAttr* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	GXmlAttr* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gxml_dom_node_get_attributes ((GXmlDomNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = name;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((GXmlAttr*) _tmp3_);
	result = _tmp4_;
	return result;
}


/**
 * Set the attribute in Attr for this element.
 *
 * Version: DOM Level 1 Core
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-887236154]]
 *
 * @param new_attr The attribute to set.
 *
 * @return If an Attr with the same name exists, it
 * is replaced and the old Attr is returned.
 * Elsewise, null is returned.
 */
GXmlAttr* gxml_element_set_attribute_node (GXmlElement* self, GXmlAttr* new_attr, GError** error) {
	GXmlAttr* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GXmlAttr* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_ = NULL;
	GXmlAttr* _tmp6_;
	GXmlAttr* old;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GXmlAttr* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GXmlAttr* _tmp13_;
	GXmlAttr* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (new_attr != NULL, NULL);
	_tmp0_ = gxml_dom_node_get_attributes ((GXmlDomNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = new_attr;
	_tmp3_ = gxml_attr_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_lookup (_tmp1_, _tmp4_);
	_tmp6_ = _g_object_ref0 ((GXmlAttr*) _tmp5_);
	old = _tmp6_;
	_tmp7_ = gxml_dom_node_get_attributes ((GXmlDomNode*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = new_attr;
	_tmp10_ = gxml_attr_get_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = new_attr;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	g_hash_table_replace (_tmp8_, _tmp12_, _tmp14_);
	result = old;
	return result;
}


/**
 * Remove Attr old_attr from this element, if it was
 * set.
 *
 * Version: DOM Level 1 Core
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-D589198]]
 *
 * @param old_attr The Attr we are removing.
 *
 * @return The old_attr we wanted to remove, even if
 * it wasn't found.
 */
GXmlAttr* gxml_element_remove_attribute_node (GXmlElement* self, GXmlAttr* old_attr, GError** error) {
	GXmlAttr* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GXmlAttr* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GXmlAttr* _tmp5_;
	GXmlAttr* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old_attr != NULL, NULL);
	_tmp0_ = gxml_dom_node_get_attributes ((GXmlDomNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_attr;
	_tmp3_ = gxml_attr_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	g_hash_table_remove (_tmp1_, _tmp4_);
	_tmp5_ = old_attr;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}


static void gxml_element_check_add_tag_name (GXmlElement* self, GXmlElement* basenode, GXmlDomNode* child) {
	gboolean _tmp0_ = FALSE;
	GXmlDomNode* _tmp1_;
	GXmlNodeType _tmp2_;
	GXmlNodeType _tmp3_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (basenode != NULL);
	g_return_if_fail (child != NULL);
	_tmp1_ = child;
	_tmp2_ = gxml_dom_node_get_node_type (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GXML_NODE_TYPE_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		GXmlDomNode* _tmp4_;
		GXmlNodeType _tmp5_;
		GXmlNodeType _tmp6_;
		_tmp4_ = child;
		_tmp5_ = gxml_dom_node_get_node_type (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == GXML_NODE_TYPE_DOCUMENT_FRAGMENT;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		GXmlDomNode* _tmp8_;
		GXmlNodeType _tmp9_;
		GXmlNodeType _tmp10_;
		_tmp8_ = child;
		_tmp9_ = gxml_dom_node_get_node_type (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == GXML_NODE_TYPE_ELEMENT) {
			GXmlElement* _tmp11_;
			GXmlDomNode* _tmp12_;
			_tmp11_ = basenode;
			_tmp12_ = child;
			gxml_element_on_new_descendant_with_tag_name (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GXML_TYPE_ELEMENT, GXmlElement));
		}
		{
			GXmlDomNode* _tmp13_;
			GXmlNodeList* _tmp14_;
			GXmlNodeList* _tmp15_;
			GXmlNodeList* _tmp16_;
			GeeIterator* _tmp17_ = NULL;
			GeeIterator* _tmp18_;
			GeeIterator* _grand_child_it;
			_tmp13_ = child;
			_tmp14_ = gxml_dom_node_get_child_nodes (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp16_);
			_grand_child_it = _tmp18_;
			while (TRUE) {
				GeeIterator* _tmp19_;
				gboolean _tmp20_ = FALSE;
				GeeIterator* _tmp21_;
				gpointer _tmp22_ = NULL;
				GXmlDomNode* grand_child;
				GXmlElement* _tmp23_;
				GXmlDomNode* _tmp24_;
				_tmp19_ = _grand_child_it;
				_tmp20_ = gee_iterator_next (_tmp19_);
				if (!_tmp20_) {
					break;
				}
				_tmp21_ = _grand_child_it;
				_tmp22_ = gee_iterator_get (_tmp21_);
				grand_child = (GXmlDomNode*) _tmp22_;
				_tmp23_ = basenode;
				_tmp24_ = grand_child;
				gxml_element_check_add_tag_name (self, _tmp23_, _tmp24_);
				_g_object_unref0 (grand_child);
			}
			_g_object_unref0 (_grand_child_it);
		}
	}
}


/**
 * Checks whether a descendant of a node is an Element, or whether its descendants
 * are elements.  If they are, we check the basenode and its ancestors to see
 * whether they're keeping that node in a TagNameNodeList, so we can remove it.
 */
static void gxml_element_check_remove_tag_name (GXmlElement* self, GXmlElement* basenode, GXmlDomNode* child) {
	GXmlDomNode* _tmp0_;
	GXmlNodeType _tmp1_;
	GXmlNodeType _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (basenode != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = child;
	_tmp1_ = gxml_dom_node_get_node_type (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GXML_NODE_TYPE_ELEMENT) {
		GXmlElement* _tmp3_;
		GXmlDomNode* _tmp4_;
		_tmp3_ = basenode;
		_tmp4_ = child;
		gxml_element_on_remove_descendant_with_tag_name (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GXML_TYPE_ELEMENT, GXmlElement));
		{
			GXmlDomNode* _tmp5_;
			GXmlNodeList* _tmp6_;
			GXmlNodeList* _tmp7_;
			GXmlNodeList* _tmp8_;
			GeeIterator* _tmp9_ = NULL;
			GeeIterator* _tmp10_;
			GeeIterator* _grand_child_it;
			_tmp5_ = child;
			_tmp6_ = gxml_dom_node_get_child_nodes (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			_grand_child_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				gboolean _tmp12_ = FALSE;
				GeeIterator* _tmp13_;
				gpointer _tmp14_ = NULL;
				GXmlDomNode* grand_child;
				GXmlElement* _tmp15_;
				GXmlDomNode* _tmp16_;
				_tmp11_ = _grand_child_it;
				_tmp12_ = gee_iterator_next (_tmp11_);
				if (!_tmp12_) {
					break;
				}
				_tmp13_ = _grand_child_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				grand_child = (GXmlDomNode*) _tmp14_;
				_tmp15_ = basenode;
				_tmp16_ = grand_child;
				gxml_element_check_remove_tag_name (self, _tmp15_, _tmp16_);
				_g_object_unref0 (grand_child);
			}
			_g_object_unref0 (_grand_child_it);
		}
	}
}


static GXmlDomNode* gxml_element_real_insert_before (GXmlDomNode* base, GXmlDomNode* new_child, GXmlDomNode* ref_child, GError** error) {
	GXmlElement * self;
	GXmlDomNode* result = NULL;
	GXmlDomNode* _tmp0_;
	GXmlDomNode* _tmp1_;
	GXmlDomNode* _tmp2_ = NULL;
	GXmlDomNode* ret;
	GXmlDomNode* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (GXmlElement*) base;
	g_return_val_if_fail (new_child != NULL, NULL);
	_tmp0_ = new_child;
	_tmp1_ = ref_child;
	_tmp2_ = GXML_DOM_NODE_CLASS (gxml_element_parent_class)->insert_before ((GXmlDomNode*) G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_BACKED_NODE, GXmlBackedNode), _tmp0_, _tmp1_, &_inner_error_);
	ret = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = new_child;
	gxml_element_check_add_tag_name (self, self, _tmp3_);
	result = ret;
	return result;
}


static GXmlDomNode* gxml_element_real_replace_child (GXmlDomNode* base, GXmlDomNode* new_child, GXmlDomNode* old_child, GError** error) {
	GXmlElement * self;
	GXmlDomNode* result = NULL;
	GXmlDomNode* _tmp0_;
	GXmlDomNode* _tmp1_;
	GXmlDomNode* _tmp2_;
	GXmlDomNode* _tmp3_ = NULL;
	GXmlDomNode* ret;
	GXmlDomNode* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (GXmlElement*) base;
	g_return_val_if_fail (new_child != NULL, NULL);
	g_return_val_if_fail (old_child != NULL, NULL);
	_tmp0_ = old_child;
	gxml_element_check_remove_tag_name (self, self, _tmp0_);
	_tmp1_ = new_child;
	_tmp2_ = old_child;
	_tmp3_ = GXML_DOM_NODE_CLASS (gxml_element_parent_class)->replace_child ((GXmlDomNode*) G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_BACKED_NODE, GXmlBackedNode), _tmp1_, _tmp2_, &_inner_error_);
	ret = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = new_child;
	gxml_element_check_add_tag_name (self, self, _tmp4_);
	result = ret;
	return result;
}


static GXmlDomNode* gxml_element_real_remove_child (GXmlDomNode* base, GXmlDomNode* old_child, GError** error) {
	GXmlElement * self;
	GXmlDomNode* result = NULL;
	GXmlDomNode* _tmp0_;
	GXmlDomNode* _tmp1_;
	GXmlDomNode* _tmp2_ = NULL;
	GXmlDomNode* ret;
	GError * _inner_error_ = NULL;
	self = (GXmlElement*) base;
	g_return_val_if_fail (old_child != NULL, NULL);
	_tmp0_ = old_child;
	gxml_element_check_remove_tag_name (self, self, _tmp0_);
	_tmp1_ = old_child;
	_tmp2_ = GXML_DOM_NODE_CLASS (gxml_element_parent_class)->remove_child ((GXmlDomNode*) G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_BACKED_NODE, GXmlBackedNode), _tmp1_, &_inner_error_);
	ret = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = ret;
	return result;
}


static GXmlDomNode* gxml_element_real_append_child (GXmlDomNode* base, GXmlDomNode* new_child, GError** error) {
	GXmlElement * self;
	GXmlDomNode* result = NULL;
	GXmlDomNode* _tmp0_;
	GXmlDomNode* _tmp1_ = NULL;
	GXmlDomNode* ret;
	GXmlDomNode* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (GXmlElement*) base;
	g_return_val_if_fail (new_child != NULL, NULL);
	_tmp0_ = new_child;
	_tmp1_ = GXML_DOM_NODE_CLASS (gxml_element_parent_class)->append_child ((GXmlDomNode*) G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_BACKED_NODE, GXmlBackedNode), _tmp0_, &_inner_error_);
	ret = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = new_child;
	gxml_element_check_add_tag_name (self, self, _tmp2_);
	result = ret;
	return result;
}


static void gxml_element_on_new_descendant_with_tag_name (GXmlElement* self, GXmlElement* elem) {
	GList* _tmp0_;
	gboolean _tmp11_ = FALSE;
	GXmlDomNode* _tmp12_;
	GXmlDomNode* _tmp13_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elem != NULL);
	_tmp0_ = self->priv->tag_name_lists;
	{
		GList* list_collection = NULL;
		GList* list_it = NULL;
		list_collection = _tmp0_;
		for (list_it = list_collection; list_it != NULL; list_it = list_it->next) {
			GXmlTagNameNodeList* _tmp1_;
			GXmlTagNameNodeList* list = NULL;
			_tmp1_ = _g_object_ref0 ((GXmlTagNameNodeList*) list_it->data);
			list = _tmp1_;
			{
				GXmlElement* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				GXmlTagNameNodeList* _tmp5_;
				const gchar* _tmp6_;
				_tmp2_ = elem;
				_tmp3_ = gxml_element_get_tag_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = list;
				_tmp6_ = _tmp5_->tag_name;
				if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
					GXmlTagNameNodeList* _tmp7_;
					GXmlElement* _tmp8_;
					GXmlDomNode* _tmp9_ = NULL;
					GXmlDomNode* _tmp10_;
					_tmp7_ = list;
					_tmp8_ = elem;
					_tmp9_ = gxml_node_list_append_child ((GXmlNodeList*) _tmp7_, (GXmlDomNode*) _tmp8_);
					_tmp10_ = _tmp9_;
					_g_object_unref0 (_tmp10_);
					_g_object_unref0 (list);
					break;
				}
				_g_object_unref0 (list);
			}
		}
	}
	_tmp12_ = gxml_dom_node_get_parent_node ((GXmlDomNode*) self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		GXmlDomNode* _tmp14_;
		GXmlDomNode* _tmp15_;
		GXmlNodeType _tmp16_;
		GXmlNodeType _tmp17_;
		_tmp14_ = gxml_dom_node_get_parent_node ((GXmlDomNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = gxml_dom_node_get_node_type (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp11_ = _tmp17_ == GXML_NODE_TYPE_ELEMENT;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp18_ = _tmp11_;
	if (_tmp18_) {
		GXmlDomNode* _tmp19_;
		GXmlDomNode* _tmp20_;
		GXmlElement* _tmp21_;
		_tmp19_ = gxml_dom_node_get_parent_node ((GXmlDomNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = elem;
		gxml_element_on_new_descendant_with_tag_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GXML_TYPE_ELEMENT, GXmlElement), _tmp21_);
	}
}


/**
 * Checks whether this element has a TagNameNodeList containing this element,
 * and if so, removes it.  It also asks the parents above if they have such
 * a list.
 */
static void gxml_element_on_remove_descendant_with_tag_name (GXmlElement* self, GXmlElement* elem) {
	GList* _tmp0_;
	gboolean _tmp19_ = FALSE;
	GXmlDomNode* _tmp20_;
	GXmlDomNode* _tmp21_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elem != NULL);
	_tmp0_ = self->priv->tag_name_lists;
	{
		GList* list_collection = NULL;
		GList* list_it = NULL;
		list_collection = _tmp0_;
		for (list_it = list_collection; list_it != NULL; list_it = list_it->next) {
			GXmlTagNameNodeList* _tmp1_;
			GXmlTagNameNodeList* list = NULL;
			_tmp1_ = _g_object_ref0 ((GXmlTagNameNodeList*) list_it->data);
			list = _tmp1_;
			{
				GXmlElement* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				GXmlTagNameNodeList* _tmp5_;
				const gchar* _tmp6_;
				_tmp2_ = elem;
				_tmp3_ = gxml_element_get_tag_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = list;
				_tmp6_ = _tmp5_->tag_name;
				if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
					{
						GXmlTagNameNodeList* _tmp7_;
						GeeIterator* _tmp8_ = NULL;
						GeeIterator* _tag_elem_it;
						_tmp7_ = list;
						_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
						_tag_elem_it = _tmp8_;
						while (TRUE) {
							GeeIterator* _tmp9_;
							gboolean _tmp10_ = FALSE;
							GeeIterator* _tmp11_;
							gpointer _tmp12_ = NULL;
							GXmlDomNode* tag_elem;
							GXmlDomNode* _tmp13_;
							GXmlElement* _tmp14_;
							_tmp9_ = _tag_elem_it;
							_tmp10_ = gee_iterator_next (_tmp9_);
							if (!_tmp10_) {
								break;
							}
							_tmp11_ = _tag_elem_it;
							_tmp12_ = gee_iterator_get (_tmp11_);
							tag_elem = (GXmlDomNode*) _tmp12_;
							_tmp13_ = tag_elem;
							_tmp14_ = elem;
							if (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GXML_TYPE_ELEMENT, GXmlElement) == _tmp14_) {
								GXmlTagNameNodeList* _tmp15_;
								GXmlDomNode* _tmp16_;
								GXmlDomNode* _tmp17_ = NULL;
								GXmlDomNode* _tmp18_;
								_tmp15_ = list;
								_tmp16_ = tag_elem;
								_tmp17_ = gxml_node_list_remove_child ((GXmlNodeList*) _tmp15_, _tmp16_);
								_tmp18_ = _tmp17_;
								_g_object_unref0 (_tmp18_);
								_g_object_unref0 (tag_elem);
								break;
							}
							_g_object_unref0 (tag_elem);
						}
						_g_object_unref0 (_tag_elem_it);
					}
					_g_object_unref0 (list);
					break;
				}
				_g_object_unref0 (list);
			}
		}
	}
	_tmp20_ = gxml_dom_node_get_parent_node ((GXmlDomNode*) self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		GXmlDomNode* _tmp22_;
		GXmlDomNode* _tmp23_;
		GXmlNodeType _tmp24_;
		GXmlNodeType _tmp25_;
		_tmp22_ = gxml_dom_node_get_parent_node ((GXmlDomNode*) self);
		_tmp23_ = _tmp22_;
		_tmp24_ = gxml_dom_node_get_node_type (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp19_ = _tmp25_ == GXML_NODE_TYPE_ELEMENT;
	} else {
		_tmp19_ = FALSE;
	}
	_tmp26_ = _tmp19_;
	if (_tmp26_) {
		GXmlDomNode* _tmp27_;
		GXmlDomNode* _tmp28_;
		GXmlElement* _tmp29_;
		_tmp27_ = gxml_dom_node_get_parent_node ((GXmlDomNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = elem;
		gxml_element_on_remove_descendant_with_tag_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GXML_TYPE_ELEMENT, GXmlElement), _tmp29_);
	}
}


/**
 * Obtains a NodeList of Elements with the given
 * tag_name that are descendants of this Element.
 * This will include the current element if it
 * matches. The returned list is updated as necessary
 * as the tree changes.
 *
 * Version: DOM Level 1 Core
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-1938918D]]
 *
 * @param tag_name The tag name to match for.
 *
 * @return A NOdeList containing the matching descendants.
 */
GXmlNodeList* gxml_element_get_elements_by_tag_name (GXmlElement* self, const gchar* tag_name) {
	GXmlNodeList* result = NULL;
	const gchar* _tmp0_;
	GXmlDocument* _tmp1_;
	GXmlDocument* _tmp2_;
	GXmlTagNameNodeList* _tmp3_;
	GXmlTagNameNodeList* tagged;
	GQueue* _tmp4_;
	GQueue* tocheck;
	GQueue* _tmp5_;
	xmlNode* _tmp6_;
	GXmlTagNameNodeList* _tmp30_;
	GXmlTagNameNodeList* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	_tmp0_ = tag_name;
	_tmp1_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gxml_tag_name_node_list_new (_tmp0_, (GXmlDomNode*) self, _tmp2_);
	tagged = _tmp3_;
	_tmp4_ = g_queue_new ();
	tocheck = _tmp4_;
	_tmp5_ = tocheck;
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_BACKED_NODE, GXmlBackedNode)->node;
	g_queue_push_head (_tmp5_, _tmp6_);
	while (TRUE) {
		GQueue* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GQueue* _tmp9_;
		gpointer _tmp10_ = NULL;
		xmlNode* cur;
		xmlNode* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp7_ = tocheck;
		_tmp8_ = g_queue_is_empty (_tmp7_);
		if (!(_tmp8_ == FALSE)) {
			break;
		}
		_tmp9_ = tocheck;
		_tmp10_ = g_queue_pop_head (_tmp9_);
		cur = _tmp10_;
		_tmp11_ = cur;
		_tmp12_ = _tmp11_->name;
		_tmp13_ = tag_name;
		if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
			GXmlTagNameNodeList* _tmp14_;
			GXmlDocument* _tmp15_;
			GXmlDocument* _tmp16_;
			xmlNode* _tmp17_;
			GXmlDomNode* _tmp18_ = NULL;
			GXmlDomNode* _tmp19_ = NULL;
			GXmlDomNode* _tmp20_;
			_tmp14_ = tagged;
			_tmp15_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) self);
			_tmp16_ = _tmp15_;
			_tmp17_ = cur;
			_tmp18_ = gxml_document_lookup_node (_tmp16_, _tmp17_);
			_tmp19_ = gxml_node_list_append_child ((GXmlNodeList*) _tmp14_, _tmp18_);
			_tmp20_ = _tmp19_;
			_g_object_unref0 (_tmp20_);
		}
		{
			xmlNode* _tmp21_;
			xmlNode* _tmp22_;
			xmlNode* child;
			_tmp21_ = cur;
			_tmp22_ = _tmp21_->last;
			child = _tmp22_;
			{
				gboolean _tmp23_;
				_tmp23_ = TRUE;
				while (TRUE) {
					gboolean _tmp24_;
					xmlNode* _tmp27_;
					GQueue* _tmp28_;
					xmlNode* _tmp29_;
					_tmp24_ = _tmp23_;
					if (!_tmp24_) {
						xmlNode* _tmp25_;
						xmlNode* _tmp26_;
						_tmp25_ = child;
						_tmp26_ = _tmp25_->prev;
						child = _tmp26_;
					}
					_tmp23_ = FALSE;
					_tmp27_ = child;
					if (!(_tmp27_ != NULL)) {
						break;
					}
					_tmp28_ = tocheck;
					_tmp29_ = child;
					g_queue_push_head (_tmp28_, _tmp29_);
				}
			}
		}
	}
	_tmp30_ = tagged;
	_tmp31_ = _g_object_ref0 (_tmp30_);
	self->priv->tag_name_lists = g_list_append (self->priv->tag_name_lists, _tmp31_);
	result = (GXmlNodeList*) tagged;
	_g_queue_free0 (tocheck);
	return result;
}


/**
 * This merges all adjacent Text nodes that are
 * descendants of this element. Sibling Text nodes
 * are not distinguishable in XML when stored outside
 * of the DOM.
 *
 * Version: DOM Level 1 Core
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-162CF083]]
 */
void gxml_element_normalize (GXmlElement* self) {
	g_return_if_fail (self != NULL);
	{
		GXmlNodeList* _tmp0_;
		GXmlNodeList* _tmp1_;
		GXmlNodeList* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _child_it;
		_tmp0_ = gxml_dom_node_get_child_nodes ((GXmlDomNode*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_child_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			GXmlDomNode* child;
			GXmlDomNode* _tmp9_;
			GXmlNodeType _tmp10_;
			GXmlNodeType _tmp11_;
			_tmp5_ = _child_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _child_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			child = (GXmlDomNode*) _tmp8_;
			_tmp9_ = child;
			_tmp10_ = gxml_dom_node_get_node_type (_tmp9_);
			_tmp11_ = _tmp10_;
			switch (_tmp11_) {
				case GXML_NODE_TYPE_ELEMENT:
				{
					GXmlDomNode* _tmp12_;
					_tmp12_ = child;
					gxml_element_normalize (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GXML_TYPE_ELEMENT, GXmlElement));
					break;
				}
				case GXML_NODE_TYPE_TEXT:
				{
					break;
				}
				default:
				break;
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}


const gchar* gxml_element_get_tag_name (GXmlElement* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = GXML_DOM_NODE_CLASS (gxml_element_parent_class)->get_node_name ((GXmlDomNode*) G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_BACKED_NODE, GXmlBackedNode));
	result = _tmp0_;
	return result;
}


static void gxml_element_set_tag_name (GXmlElement* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "tag-name");
}


static const gchar* gxml_element_real_get_node_value (GXmlDomNode* base) {
	const gchar* result;
	GXmlElement* self;
	self = (GXmlElement*) base;
	result = NULL;
	return result;
}


static void gxml_element_real_set_node_value (GXmlDomNode* base, const gchar* value) {
	GXmlElement* self;
	self = (GXmlElement*) base;
	g_object_notify ((GObject *) self, "node-value");
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static GHashTable* gxml_element_real_get_attributes (GXmlDomNode* base) {
	GHashTable* result;
	GXmlElement* self;
	GXmlAttr* attr = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp24_;
	self = (GXmlElement*) base;
	_tmp0_ = self->priv->_attributes;
	if (_tmp0_ == NULL) {
		GXmlDocument* _tmp1_;
		GXmlDocument* _tmp2_;
		GXmlElement* _tmp3_;
		GHashFunc _tmp4_;
		GEqualFunc _tmp5_;
		GHashTable* _tmp6_;
		_tmp1_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _g_object_ref0 (self);
		_tmp2_->dirty_elements = g_list_append (_tmp2_->dirty_elements, _tmp3_);
		_tmp4_ = g_str_hash;
		_tmp5_ = g_str_equal;
		_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (self->priv->_attributes);
		self->priv->_attributes = _tmp6_;
		{
			xmlNode* _tmp7_;
			xmlAttr* _tmp8_;
			xmlAttr* prop;
			_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_BACKED_NODE, GXmlBackedNode)->node;
			_tmp8_ = _tmp7_->properties;
			prop = _tmp8_;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					gboolean _tmp10_;
					xmlAttr* _tmp13_;
					xmlAttr* _tmp14_;
					GXmlDocument* _tmp15_;
					GXmlDocument* _tmp16_;
					GXmlAttr* _tmp17_;
					GHashTable* _tmp18_;
					xmlAttr* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					GXmlAttr* _tmp22_;
					GXmlAttr* _tmp23_;
					_tmp10_ = _tmp9_;
					if (!_tmp10_) {
						xmlAttr* _tmp11_;
						xmlAttr* _tmp12_;
						_tmp11_ = prop;
						_tmp12_ = _tmp11_->next;
						prop = _tmp12_;
					}
					_tmp9_ = FALSE;
					_tmp13_ = prop;
					if (!(_tmp13_ != NULL)) {
						break;
					}
					_tmp14_ = prop;
					_tmp15_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) self);
					_tmp16_ = _tmp15_;
					_tmp17_ = gxml_attr_new (_tmp14_, _tmp16_);
					_g_object_unref0 (attr);
					attr = _tmp17_;
					_tmp18_ = self->priv->_attributes;
					_tmp19_ = prop;
					_tmp20_ = _tmp19_->name;
					_tmp21_ = g_strdup (_tmp20_);
					_tmp22_ = attr;
					_tmp23_ = _g_object_ref0 (_tmp22_);
					g_hash_table_replace (_tmp18_, _tmp21_, _tmp23_);
				}
			}
		}
	}
	_tmp24_ = self->priv->_attributes;
	result = _tmp24_;
	_g_object_unref0 (attr);
	return result;
}


static void gxml_element_real_set_attributes (GXmlDomNode* base, GHashTable* value) {
	GXmlElement* self;
	self = (GXmlElement*) base;
	g_object_notify ((GObject *) self, "attributes");
}


gchar* gxml_element_get_content (GXmlElement* self) {
	gchar* result;
	xmlNode* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_BACKED_NODE, GXmlBackedNode)->node;
	_tmp1_ = xmlNodeGetContent (_tmp0_);
	result = _tmp1_;
	return result;
}


void gxml_element_set_content (GXmlElement* self, const gchar* value) {
	xmlNode* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_BACKED_NODE, GXmlBackedNode)->node;
	_tmp1_ = value;
	xmlNodeSetContent (_tmp0_, (xmlChar*) _tmp1_);
	g_object_notify ((GObject *) self, "content");
}


static void gxml_element_class_init (GXmlElementClass * klass) {
	gxml_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlElementPrivate));
	GXML_DOM_NODE_CLASS (klass)->insert_before = gxml_element_real_insert_before;
	GXML_DOM_NODE_CLASS (klass)->replace_child = gxml_element_real_replace_child;
	GXML_DOM_NODE_CLASS (klass)->remove_child = gxml_element_real_remove_child;
	GXML_DOM_NODE_CLASS (klass)->append_child = gxml_element_real_append_child;
	GXML_DOM_NODE_CLASS (klass)->get_node_value = gxml_element_real_get_node_value;
	GXML_DOM_NODE_CLASS (klass)->set_node_value = gxml_element_real_set_node_value;
	GXML_DOM_NODE_CLASS (klass)->get_attributes = gxml_element_real_get_attributes;
	GXML_DOM_NODE_CLASS (klass)->set_attributes = gxml_element_real_set_attributes;
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = gxml_element_finalize;
	/**
	 * The element's tag_name. Multiple elements can have
	 * the same tag name in a document. XML example:
	 * {{{&lt;photos>
	 *   &lt;img src="..." />
	 *   &lt;img src="..." />
	 * &lt;/photos>}}}
	 * In this example, photos and img are tag names.
	 *
	 * Version: DOM Level 1 Core
	 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-104682815]]
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_ELEMENT_TAG_NAME, g_param_spec_string ("tag-name", "tag-name", "tag-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Elements do not have a node_value. Instead, their
	 * contents are stored in Attr attributes and in
	 * child_nodes.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_ELEMENT_NODE_VALUE, g_param_spec_string ("node-value", "node-value", "node-value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Contains a HashTable of Attr attributes associated with this element.
	 *
	 * Attributes in the HashTable are updated live, so
	 * changes in the element's attributes through its
	 * other methods are reflected in the attributes
	 * HashTable.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_ELEMENT_ATTRIBUTES, g_param_spec_boxed ("attributes", "attributes", "attributes", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * This is a convenience property for Elements, useful
	 * when you want to see Text descendents of an
	 * element. With the XML example {{{<shops><shop
	 * id="1">Eeylops Owl Emporium</shop><shop
	 * id="2">Obscurus Books</shop></shops>}}} taking the
	 * node for the shop element with id 1 and using this
	 * method, you would get back "Eeylops Owl Emporiums".
	 * If you used it on the shops element, you'd get
	 * {{{Eeylops Owl EmporiumObscurus Books}}} with the
	 * XML tags omitted.
	 *
	 * Setting content replaces the Element's children
	 * with a Text node containing `value`.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_ELEMENT_CONTENT, g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gxml_element_instance_init (GXmlElement * self) {
	self->priv = GXML_ELEMENT_GET_PRIVATE (self);
	self->priv->_attributes = NULL;
	self->priv->tag_name_lists = NULL;
}


static void gxml_element_finalize (GObject* obj) {
	GXmlElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_ELEMENT, GXmlElement);
	_g_hash_table_unref0 (self->priv->_attributes);
	__g_list_free__g_object_unref0_0 (self->priv->tag_name_lists);
	G_OBJECT_CLASS (gxml_element_parent_class)->finalize (obj);
}


/**
 * Represent an XML Element node, which have attributes and children.
 *
 * To create one, use {@link GXml.Document.create_element}.
 *
 * These can have child nodes
 * of various types including other Elements. Elements can
 * have Attr attributes associated with them. Elements have
 * tag names. In addition to methods inherited from DomNode,
 * Elements have additional methods for manipulating
 * attributes, as an alternative to manipulating the
 * attributes HashMap directly.
 *
 * Version: DOM Level 1 Core
 * URL: [[http://www.w3.org/TR/DOM-Level-1/level-one-core.html#ID-745549614]]
 */
GType gxml_element_get_type (void) {
	static volatile gsize gxml_element_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlElement), 0, (GInstanceInitFunc) gxml_element_instance_init, NULL };
		GType gxml_element_type_id;
		gxml_element_type_id = g_type_register_static (GXML_TYPE_BACKED_NODE, "GXmlElement", &g_define_type_info, 0);
		g_once_init_leave (&gxml_element_type_id__volatile, gxml_element_type_id);
	}
	return gxml_element_type_id__volatile;
}


static void _vala_gxml_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_ELEMENT, GXmlElement);
	switch (property_id) {
		case GXML_ELEMENT_TAG_NAME:
		g_value_set_string (value, gxml_element_get_tag_name (self));
		break;
		case GXML_ELEMENT_NODE_VALUE:
		g_value_set_string (value, gxml_dom_node_get_node_value ((GXmlDomNode*) self));
		break;
		case GXML_ELEMENT_ATTRIBUTES:
		g_value_set_boxed (value, gxml_dom_node_get_attributes ((GXmlDomNode*) self));
		break;
		case GXML_ELEMENT_CONTENT:
		g_value_take_string (value, gxml_element_get_content (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_ELEMENT, GXmlElement);
	switch (property_id) {
		case GXML_ELEMENT_TAG_NAME:
		gxml_element_set_tag_name (self, g_value_get_string (value));
		break;
		case GXML_ELEMENT_NODE_VALUE:
		gxml_dom_node_set_node_value ((GXmlDomNode*) self, g_value_get_string (value));
		break;
		case GXML_ELEMENT_ATTRIBUTES:
		gxml_dom_node_set_attributes ((GXmlDomNode*) self, g_value_get_boxed (value));
		break;
		case GXML_ELEMENT_CONTENT:
		gxml_element_set_content (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



