/* Serialization.c generated by valac 0.20.1, the Vala compiler
 * generated from Serialization.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* Serialization.vala
 *
 * Copyright (C) 2012-2013  Richard Schwarting <aquarichy@gmail.com>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Richard Schwarting <aquarichy@gmail.com>
 */
/* TODO: so it seems we can get property information from GObjectClass
   but that's about it.  Need to definitely use introspection for anything
   tastier */
/* TODO: document memory management for the C side */

#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

#define GXML_TYPE_SERIALIZATION (gxml_serialization_get_type ())
#define GXML_SERIALIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZATION, GXmlSerialization))
#define GXML_SERIALIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZATION, GXmlSerializationClass))
#define GXML_IS_SERIALIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZATION))
#define GXML_IS_SERIALIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZATION))
#define GXML_SERIALIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZATION, GXmlSerializationClass))

typedef struct _GXmlSerialization GXmlSerialization;
typedef struct _GXmlSerializationClass GXmlSerializationClass;
typedef struct _GXmlSerializationPrivate GXmlSerializationPrivate;

#define GXML_TYPE_DOM_NODE (gxml_dom_node_get_type ())
#define GXML_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NODE, GXmlDomNode))
#define GXML_DOM_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_NODE, GXmlDomNodeClass))
#define GXML_IS_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NODE))
#define GXML_IS_DOM_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_NODE))
#define GXML_DOM_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_NODE, GXmlDomNodeClass))

typedef struct _GXmlDomNode GXmlDomNode;
typedef struct _GXmlDomNodeClass GXmlDomNodeClass;

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOCUMENT, GXmlDocumentClass))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentClass))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentClass GXmlDocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GXML_TYPE_BACKED_NODE (gxml_backed_node_get_type ())
#define GXML_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNode))
#define GXML_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))
#define GXML_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_BACKED_NODE))
#define GXML_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_BACKED_NODE))
#define GXML_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))

typedef struct _GXmlBackedNode GXmlBackedNode;
typedef struct _GXmlBackedNodeClass GXmlBackedNodeClass;

#define GXML_TYPE_CHARACTER_DATA (gxml_character_data_get_type ())
#define GXML_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_CHARACTER_DATA, GXmlCharacterData))
#define GXML_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_CHARACTER_DATA, GXmlCharacterDataClass))
#define GXML_IS_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_CHARACTER_DATA))
#define GXML_IS_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_CHARACTER_DATA))
#define GXML_CHARACTER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_CHARACTER_DATA, GXmlCharacterDataClass))

typedef struct _GXmlCharacterData GXmlCharacterData;
typedef struct _GXmlCharacterDataClass GXmlCharacterDataClass;

#define GXML_TYPE_TEXT (gxml_text_get_type ())
#define GXML_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TEXT, GXmlText))
#define GXML_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_TEXT, GXmlTextClass))
#define GXML_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TEXT))
#define GXML_IS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_TEXT))
#define GXML_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_TEXT, GXmlTextClass))

typedef struct _GXmlText GXmlText;
typedef struct _GXmlTextClass GXmlTextClass;

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT, GXmlElementClass))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT, GXmlElementClass))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementClass GXmlElementClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GXML_TYPE_NODE_LIST (gxml_node_list_get_type ())
#define GXML_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE_LIST, GXmlNodeList))
#define GXML_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE_LIST))
#define GXML_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE_LIST, GXmlNodeListIface))

typedef struct _GXmlNodeList GXmlNodeList;
typedef struct _GXmlNodeListIface GXmlNodeListIface;

/**
 * Errors from {@link Serialization}.
 */
typedef enum  {
	GXML_SERIALIZATION_ERROR_UNKNOWN_TYPE,
	GXML_SERIALIZATION_ERROR_UNKNOWN_PROPERTY,
	GXML_SERIALIZATION_ERROR_UNSUPPORTED_TYPE
} GXmlSerializationError;
#define GXML_SERIALIZATION_ERROR gxml_serialization_error_quark ()
struct _GXmlSerialization {
	GObject parent_instance;
	GXmlSerializationPrivate * priv;
};

struct _GXmlSerializationClass {
	GObjectClass parent_class;
};

typedef enum  {
	GXML_DOM_ERROR_INDEX_SIZE,
	GXML_DOM_ERROR_DOMSTRING_SIZE,
	GXML_DOM_ERROR_HIERARCHY_REQUEST,
	GXML_DOM_ERROR_WRONG_DOCUMENT,
	GXML_DOM_ERROR_INVALID_CHARACTER,
	GXML_DOM_ERROR_NO_DATA_ALLOWED,
	GXML_DOM_ERROR_NO_MODIFICATION_ALLOWED,
	GXML_DOM_ERROR_NOT_FOUND,
	GXML_DOM_ERROR_NOT_SUPPORTED,
	GXML_DOM_ERROR_INUSE_ATTRIBUTE,
	GXML_DOM_ERROR_DOM,
	GXML_DOM_ERROR_INVALID_DOC,
	GXML_DOM_ERROR_INVALID_ROOT
} GXmlDomError;
#define GXML_DOM_ERROR gxml_dom_error_quark ()
struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*deserialize_property) (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDomNode* property_node);
	GXmlDomNode* (*serialize_property) (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDocument* doc);
	GParamSpec* (*find_property) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec** (*list_properties) (GXmlSerializable* self, int* result_length1);
	void (*get_property) (GXmlSerializable* self, GParamSpec* spec, GValue* str_value);
	void (*set_property) (GXmlSerializable* self, GParamSpec* spec, GValue* value);
};

struct _GXmlNodeListIface {
	GTypeInterface parent_iface;
	GXmlDomNode* (*item) (GXmlNodeList* self, gulong idx);
	void (*foreach) (GXmlNodeList* self, GFunc func, void* func_target);
	GXmlDomNode* (*first) (GXmlNodeList* self);
	GXmlDomNode* (*last) (GXmlNodeList* self);
	GXmlDomNode* (*nth) (GXmlNodeList* self, gulong n);
	GXmlDomNode* (*nth_data) (GXmlNodeList* self, gulong n);
	GXmlDomNode* (*nth_prev) (GXmlNodeList* self, GXmlDomNode* pivot, gulong n);
	gint (*find) (GXmlNodeList* self, GXmlDomNode* target);
	gint (*find_custom) (GXmlNodeList* self, GXmlDomNode* target, GCompareFunc cmp);
	gint (*position) (GXmlNodeList* self, GXmlDomNode* target);
	gint (*index) (GXmlNodeList* self, GXmlDomNode* target);
	GXmlDomNode* (*insert_before) (GXmlNodeList* self, GXmlDomNode* new_child, GXmlDomNode* ref_child, GError** error);
	GXmlDomNode* (*replace_child) (GXmlNodeList* self, GXmlDomNode* new_child, GXmlDomNode* old_child, GError** error);
	GXmlDomNode* (*remove_child) (GXmlNodeList* self, GXmlDomNode* old_child);
	GXmlDomNode* (*append_child) (GXmlNodeList* self, GXmlDomNode* new_child);
	gchar* (*to_string) (GXmlNodeList* self, gboolean in_line);
	gulong (*get_length) (GXmlNodeList* self);
	void (*set_length) (GXmlNodeList* self, gulong value);
};


static gpointer gxml_serialization_parent_class = NULL;
static GList* gxml_serialization__docs;
static GList* gxml_serialization__docs = NULL;
static GHashTable* gxml_serialization_deserialize_cache;
static GHashTable* gxml_serialization_deserialize_cache = NULL;
static GHashTable* gxml_serialization_serialize_cache;
static GHashTable* gxml_serialization_serialize_cache = NULL;

void gxml_print_object_properties (GObject* obj);
static GParamSpec** _vala_array_dup1 (GParamSpec** self, int length);
GQuark gxml_serialization_error_quark (void);
GType gxml_serialization_get_type (void) G_GNUC_CONST;
enum  {
	GXML_SERIALIZATION_DUMMY_PROPERTY
};
GType gxml_dom_node_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
static void gxml_serialization_print_debug (GXmlDocument* doc, GObject* object);
gchar* gxml_dom_node_to_string (GXmlDomNode* self, gboolean format, gint level);
GQuark gxml_dom_error_quark (void);
static GXmlDomNode* gxml_serialization_serialize_property (GObject* object, GParamSpec* prop_spec, GXmlDocument* doc, GError** error);
GType gxml_serializable_get_type (void) G_GNUC_CONST;
void gxml_serializable_get_property (GXmlSerializable* self, GParamSpec* spec, GValue* str_value);
GType gxml_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_character_data_get_type (void) G_GNUC_CONST;
GType gxml_text_get_type (void) G_GNUC_CONST;
GXmlText* gxml_document_create_text_node (GXmlDocument* self, const gchar* data);
GXmlDomNode* gxml_serialization_serialize_object (GObject* object, GError** error);
GType gxml_element_get_type (void) G_GNUC_CONST;
static void gxml_serialization_init_caches (void);
GXmlDocument* gxml_document_new (GError** error);
GXmlDocument* gxml_document_construct (GType object_type, GError** error);
GXmlElement* gxml_document_create_element (GXmlDocument* self, const gchar* tag_name, GError** error);
GXmlDomNode* gxml_dom_node_append_child (GXmlDomNode* self, GXmlDomNode* new_child, GError** error);
void gxml_element_set_attribute (GXmlElement* self, const gchar* name, const gchar* value, GError** error);
GXmlElement* gxml_document_get_document_element (GXmlDocument* self);
GParamSpec** gxml_serializable_list_properties (GXmlSerializable* self, int* result_length1);
static GParamSpec** _vala_array_dup2 (GParamSpec** self, int length);
static GParamSpec** _vala_array_dup3 (GParamSpec** self, int length);
GXmlDomNode* gxml_serializable_serialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDocument* doc);
static void gxml_serialization_deserialize_property (GParamSpec* spec, GXmlElement* prop_elem, GValue* val, GError** error);
gboolean gxml_serialization_string_to_gvalue (const gchar* str, GValue* dest, GError** error);
gchar* gxml_element_get_content (GXmlElement* self);
GXmlDomNode* gxml_dom_node_get_first_child (GXmlDomNode* self);
GObject* gxml_serialization_deserialize_object (GXmlDomNode* node, GError** error);
void gxml_serialization_clear_cache (void);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
gchar* gxml_element_get_attribute (GXmlElement* self, const gchar* name);
static void g_parameter_destroy (GParameter* self);
static void _vala_GParameter_array_free (GParameter* array, gint array_length);
static GParamSpec** _vala_array_dup4 (GParamSpec** self, int length);
static GParamSpec** _vala_array_dup5 (GParamSpec** self, int length);
GType gxml_node_list_get_type (void) G_GNUC_CONST;
GXmlNodeList* gxml_dom_node_get_child_nodes (GXmlDomNode* self);
const gchar* gxml_dom_node_get_node_name (GXmlDomNode* self);
GParamSpec* gxml_serializable_find_property (GXmlSerializable* self, const gchar* property_name);
gboolean gxml_serializable_deserialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDomNode* property_node);
void gxml_serializable_set_property (GXmlSerializable* self, GParamSpec* spec, GValue* value);
GXmlSerialization* gxml_serialization_new (void);
GXmlSerialization* gxml_serialization_construct (GType object_type);
static void gxml_serialization_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


static GParamSpec** _vala_array_dup1 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void gxml_print_object_properties (GObject* obj) {
	GParamSpec** properties = NULL;
	gint properties_length1 = 0;
	gint _properties_size_ = 0;
	GObject* _tmp0_;
	GObjectClass* _tmp1_ = NULL;
	guint _tmp2_;
	GParamSpec** _tmp3_ = NULL;
	GParamSpec** _tmp4_;
	gint _tmp4__length1;
	FILE* _tmp5_;
	GParamSpec** _tmp6_;
	gint _tmp6__length1;
	GParamSpec** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	_tmp1_ = G_OBJECT_GET_CLASS (_tmp0_);
	_tmp3_ = g_object_class_list_properties (_tmp1_, &_tmp2_);
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp2_) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp2_;
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	properties = _tmp4_;
	properties_length1 = _tmp4__length1;
	_properties_size_ = properties_length1;
	_tmp5_ = stdout;
	_tmp6_ = properties;
	_tmp6__length1 = properties_length1;
	fprintf (_tmp5_, "object has %d properties\n", _tmp6__length1);
	_tmp7_ = properties;
	_tmp7__length1 = properties_length1;
	{
		GParamSpec** prop_spec_collection = NULL;
		gint prop_spec_collection_length1 = 0;
		gint _prop_spec_collection_size_ = 0;
		gint prop_spec_it = 0;
		prop_spec_collection = _tmp7_;
		prop_spec_collection_length1 = _tmp7__length1;
		for (prop_spec_it = 0; prop_spec_it < _tmp7__length1; prop_spec_it = prop_spec_it + 1) {
			GParamSpec* _tmp8_;
			GParamSpec* prop_spec = NULL;
			_tmp8_ = _g_param_spec_ref0 (prop_spec_collection[prop_spec_it]);
			prop_spec = _tmp8_;
			{
				FILE* _tmp9_;
				FILE* _tmp10_;
				GParamSpec* _tmp11_;
				const gchar* _tmp12_;
				FILE* _tmp13_;
				GParamSpec* _tmp14_;
				GType _tmp15_;
				const gchar* _tmp16_ = NULL;
				FILE* _tmp17_;
				GParamSpec* _tmp18_;
				GType _tmp19_;
				const gchar* _tmp20_ = NULL;
				FILE* _tmp21_;
				GParamSpec* _tmp22_;
				const gchar* _tmp23_ = NULL;
				FILE* _tmp24_;
				GParamSpec* _tmp25_;
				const gchar* _tmp26_ = NULL;
				FILE* _tmp27_;
				GParamSpec* _tmp28_;
				const gchar* _tmp29_ = NULL;
				_tmp9_ = stdout;
				fprintf (_tmp9_, "---\n");
				_tmp10_ = stdout;
				_tmp11_ = prop_spec;
				_tmp12_ = _tmp11_->name;
				fprintf (_tmp10_, "name            %s\n", _tmp12_);
				_tmp13_ = stdout;
				_tmp14_ = prop_spec;
				_tmp15_ = _tmp14_->value_type;
				_tmp16_ = g_type_name (_tmp15_);
				fprintf (_tmp13_, "  value_type    %s\n", _tmp16_);
				_tmp17_ = stdout;
				_tmp18_ = prop_spec;
				_tmp19_ = _tmp18_->owner_type;
				_tmp20_ = g_type_name (_tmp19_);
				fprintf (_tmp17_, "  owner_type    %s\n", _tmp20_);
				_tmp21_ = stdout;
				_tmp22_ = prop_spec;
				_tmp23_ = g_param_spec_get_name (_tmp22_);
				fprintf (_tmp21_, "  get_name ()   %s\n", _tmp23_);
				_tmp24_ = stdout;
				_tmp25_ = prop_spec;
				_tmp26_ = g_param_spec_get_blurb (_tmp25_);
				fprintf (_tmp24_, "  get_blurb ()  %s\n", _tmp26_);
				_tmp27_ = stdout;
				_tmp28_ = prop_spec;
				_tmp29_ = g_param_spec_get_nick (_tmp28_);
				fprintf (_tmp27_, "  get_nick ()   %s\n", _tmp29_);
				_g_param_spec_unref0 (prop_spec);
			}
		}
	}
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
}


GQuark gxml_serialization_error_quark (void) {
	return g_quark_from_static_string ("gxml_serialization_error-quark");
}


static void gxml_serialization_print_debug (GXmlDocument* doc, GObject* object) {
	FILE* _tmp0_;
	GXmlDocument* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	GObject* _tmp6_;
	GType _tmp7_ = 0UL;
	const gchar* _tmp8_ = NULL;
	FILE* _tmp9_;
	GObject* _tmp10_;
	GObjectClass* _tmp11_ = NULL;
	GType _tmp12_ = 0UL;
	const gchar* _tmp13_ = NULL;
	GObject* _tmp14_;
	g_return_if_fail (doc != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = stdout;
	_tmp1_ = doc;
	_tmp2_ = gxml_dom_node_to_string ((GXmlDomNode*) _tmp1_, FALSE, 0);
	_tmp3_ = _tmp2_;
	fprintf (_tmp0_, "Object XML\n---\n%s\n", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = stdout;
	fprintf (_tmp4_, "object\n---\n");
	_tmp5_ = stdout;
	_tmp6_ = object;
	_tmp7_ = G_TYPE_FROM_INSTANCE (_tmp6_);
	_tmp8_ = g_type_name (_tmp7_);
	fprintf (_tmp5_, "get_type (): %s\n", _tmp8_);
	_tmp9_ = stdout;
	_tmp10_ = object;
	_tmp11_ = G_OBJECT_GET_CLASS (_tmp10_);
	_tmp12_ = G_TYPE_FROM_CLASS ((GTypeClass*) _tmp11_);
	_tmp13_ = g_type_name (_tmp12_);
	fprintf (_tmp9_, "get_class ().get_type (): %s\n", _tmp13_);
	_tmp14_ = object;
	gxml_print_object_properties (_tmp14_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GXmlDomNode* gxml_serialization_serialize_property (GObject* object, GParamSpec* prop_spec, GXmlDocument* doc, GError** error) {
	GXmlDomNode* result = NULL;
	GType type = 0UL;
	GValue value = {0};
	GXmlDomNode* value_node = NULL;
	GXmlSerializable* serializable;
	GObject* _tmp0_;
	GType _tmp1_ = 0UL;
	gboolean _tmp2_ = FALSE;
	GParamSpec* _tmp5_;
	GType _tmp6_;
	GParamSpec* _tmp7_;
	GType _tmp8_;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (prop_spec != NULL, NULL);
	g_return_val_if_fail (doc != NULL, NULL);
	serializable = NULL;
	_tmp0_ = object;
	_tmp1_ = G_TYPE_FROM_INSTANCE (_tmp0_);
	_tmp2_ = g_type_is_a (_tmp1_, GXML_TYPE_SERIALIZABLE);
	if (_tmp2_) {
		GObject* _tmp3_;
		GXmlSerializable* _tmp4_;
		_tmp3_ = object;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GXML_TYPE_SERIALIZABLE, GXmlSerializable));
		_g_object_unref0 (serializable);
		serializable = _tmp4_;
	}
	_tmp5_ = prop_spec;
	_tmp6_ = _tmp5_->value_type;
	type = _tmp6_;
	_tmp7_ = prop_spec;
	_tmp8_ = _tmp7_->value_type;
	_tmp9_ = G_TYPE_IS_ENUM (_tmp8_);
	if (_tmp9_) {
		GValue _tmp10_ = {0};
		GValue _tmp11_;
		GXmlSerializable* _tmp12_;
		GXmlDocument* _tmp18_;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GXmlText* _tmp22_ = NULL;
		g_value_init (&_tmp10_, G_TYPE_INT);
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		value = _tmp10_;
		_tmp11_ = value;
		_tmp12_ = serializable;
		if (_tmp12_ != NULL) {
			GXmlSerializable* _tmp13_;
			GParamSpec* _tmp14_;
			_tmp13_ = serializable;
			_tmp14_ = prop_spec;
			gxml_serializable_get_property (_tmp13_, _tmp14_, &value);
		} else {
			GObject* _tmp15_;
			GParamSpec* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = object;
			_tmp16_ = prop_spec;
			_tmp17_ = _tmp16_->name;
			g_object_get_property (_tmp15_, _tmp17_, &value);
		}
		_tmp18_ = doc;
		_tmp19_ = g_value_get_int (&value);
		_tmp20_ = g_strdup_printf ("%d", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = gxml_document_create_text_node (_tmp18_, _tmp21_);
		_g_object_unref0 (value_node);
		value_node = (GXmlDomNode*) _tmp22_;
		_g_free0 (_tmp21_);
	} else {
		GParamSpec* _tmp23_;
		GType _tmp24_;
		gboolean _tmp25_ = FALSE;
		_tmp23_ = prop_spec;
		_tmp24_ = _tmp23_->value_type;
		_tmp25_ = g_value_type_transformable (_tmp24_, G_TYPE_STRING);
		if (_tmp25_) {
			GValue _tmp26_ = {0};
			GValue _tmp27_;
			GXmlSerializable* _tmp28_;
			GXmlDocument* _tmp34_;
			const gchar* _tmp35_ = NULL;
			GXmlText* _tmp36_ = NULL;
			g_value_init (&_tmp26_, G_TYPE_STRING);
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			value = _tmp26_;
			_tmp27_ = value;
			_tmp28_ = serializable;
			if (_tmp28_ != NULL) {
				GXmlSerializable* _tmp29_;
				GParamSpec* _tmp30_;
				_tmp29_ = serializable;
				_tmp30_ = prop_spec;
				gxml_serializable_get_property (_tmp29_, _tmp30_, &value);
			} else {
				GObject* _tmp31_;
				GParamSpec* _tmp32_;
				const gchar* _tmp33_;
				_tmp31_ = object;
				_tmp32_ = prop_spec;
				_tmp33_ = _tmp32_->name;
				g_object_get_property (_tmp31_, _tmp33_, &value);
			}
			_tmp34_ = doc;
			_tmp35_ = g_value_get_string (&value);
			_tmp36_ = gxml_document_create_text_node (_tmp34_, _tmp35_);
			_g_object_unref0 (value_node);
			value_node = (GXmlDomNode*) _tmp36_;
		} else {
			GType _tmp37_;
			_tmp37_ = type;
			if (_tmp37_ == G_TYPE_GTYPE) {
				GXmlDocument* _tmp38_;
				GType _tmp39_;
				const gchar* _tmp40_ = NULL;
				GXmlText* _tmp41_ = NULL;
				_tmp38_ = doc;
				_tmp39_ = type;
				_tmp40_ = g_type_name (_tmp39_);
				_tmp41_ = gxml_document_create_text_node (_tmp38_, _tmp40_);
				_g_object_unref0 (value_node);
				value_node = (GXmlDomNode*) _tmp41_;
			} else {
				gboolean _tmp42_ = FALSE;
				GType _tmp43_;
				gboolean _tmp44_ = FALSE;
				gboolean _tmp47_;
				_tmp43_ = type;
				_tmp44_ = g_type_is_a (_tmp43_, G_TYPE_OBJECT);
				if (_tmp44_) {
					GType _tmp45_;
					gboolean _tmp46_ = FALSE;
					_tmp45_ = type;
					_tmp46_ = g_type_is_a (_tmp45_, GEE_TYPE_COLLECTION);
					_tmp42_ = !_tmp46_;
				} else {
					_tmp42_ = FALSE;
				}
				_tmp47_ = _tmp42_;
				if (_tmp47_) {
					GObject* child_object = NULL;
					GValue _tmp48_ = {0};
					GValue _tmp49_;
					GXmlSerializable* _tmp50_;
					GObject* _tmp56_ = NULL;
					GObject* _tmp57_;
					GObject* _tmp58_;
					GXmlDomNode* _tmp59_ = NULL;
					GXmlDomNode* _tmp60_;
					g_value_init (&_tmp48_, G_TYPE_OBJECT);
					G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
					value = _tmp48_;
					_tmp49_ = value;
					_tmp50_ = serializable;
					if (_tmp50_ != NULL) {
						GXmlSerializable* _tmp51_;
						GParamSpec* _tmp52_;
						_tmp51_ = serializable;
						_tmp52_ = prop_spec;
						gxml_serializable_get_property (_tmp51_, _tmp52_, &value);
					} else {
						GObject* _tmp53_;
						GParamSpec* _tmp54_;
						const gchar* _tmp55_;
						_tmp53_ = object;
						_tmp54_ = prop_spec;
						_tmp55_ = _tmp54_->name;
						g_object_get_property (_tmp53_, _tmp55_, &value);
					}
					_tmp56_ = g_value_get_object (&value);
					_tmp57_ = _g_object_ref0 (_tmp56_);
					_g_object_unref0 (child_object);
					child_object = _tmp57_;
					_tmp58_ = child_object;
					_tmp59_ = gxml_serialization_serialize_object (_tmp58_, &_inner_error_);
					_tmp60_ = _tmp59_;
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == GXML_SERIALIZATION_ERROR) || (_inner_error_->domain == GXML_DOM_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (child_object);
							_g_object_unref0 (serializable);
							_g_object_unref0 (value_node);
							G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
							return NULL;
						} else {
							_g_object_unref0 (child_object);
							_g_object_unref0 (serializable);
							_g_object_unref0 (value_node);
							G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_g_object_unref0 (value_node);
					value_node = _tmp60_;
					_g_object_unref0 (child_object);
				} else {
					GType _tmp61_;
					const gchar* _tmp62_ = NULL;
					_tmp61_ = type;
					_tmp62_ = g_type_name (_tmp61_);
					if (g_strcmp0 (_tmp62_, "gpointer") == 0) {
						GParamSpec* _tmp63_;
						const gchar* _tmp64_;
						GObject* _tmp65_;
						GType _tmp66_ = 0UL;
						const gchar* _tmp67_ = NULL;
						GXmlDocument* _tmp68_;
						GParamSpec* _tmp69_;
						const gchar* _tmp70_;
						GXmlText* _tmp71_ = NULL;
						_tmp63_ = prop_spec;
						_tmp64_ = _tmp63_->name;
						_tmp65_ = object;
						_tmp66_ = G_TYPE_FROM_INSTANCE (_tmp65_);
						_tmp67_ = g_type_name (_tmp66_);
						g_warning ("Serialization.vala:174: DEBUG: skipping gpointer with name '%s' of obj" \
"ect '%s'", _tmp64_, _tmp67_);
						_tmp68_ = doc;
						_tmp69_ = prop_spec;
						_tmp70_ = _tmp69_->name;
						_tmp71_ = gxml_document_create_text_node (_tmp68_, _tmp70_);
						_g_object_unref0 (value_node);
						value_node = (GXmlDomNode*) _tmp71_;
					} else {
						GType _tmp72_;
						const gchar* _tmp73_ = NULL;
						GParamSpec* _tmp74_;
						const gchar* _tmp75_;
						GObject* _tmp76_;
						GType _tmp77_ = 0UL;
						const gchar* _tmp78_ = NULL;
						GError* _tmp79_;
						_tmp72_ = type;
						_tmp73_ = g_type_name (_tmp72_);
						_tmp74_ = prop_spec;
						_tmp75_ = _tmp74_->name;
						_tmp76_ = object;
						_tmp77_ = G_TYPE_FROM_INSTANCE (_tmp76_);
						_tmp78_ = g_type_name (_tmp77_);
						_tmp79_ = g_error_new (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNSUPPORTED_TYPE, "Can't currently serialize type '%s' for property '%s' of object '%s'", _tmp73_, _tmp75_, _tmp78_);
						_inner_error_ = _tmp79_;
						if ((_inner_error_->domain == GXML_SERIALIZATION_ERROR) || (_inner_error_->domain == GXML_DOM_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (serializable);
							_g_object_unref0 (value_node);
							G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
							return NULL;
						} else {
							_g_object_unref0 (serializable);
							_g_object_unref0 (value_node);
							G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
		}
	}
	result = value_node;
	_g_object_unref0 (serializable);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	return result;
}


/**
 * Serializes a {@link GLib.Object} into a {@link GXml.DomNode}.
 *
 * This takes a {@link GLib.Object} and serializes it into a
 * {@link GXml.DomNode} which can be saved to disk or
 * transferred over a network.  It handles serialization of
 * primitive properties and some more complex ones like enums,
 * other {@link GLib.Object}s recursively, and some collections.
 *
 * The serialization process can be customised for an object
 * by having the object implement the {@link GXml.Serializable}
 * interface, which allows direct control over the
 * conversation of individual properties into {@link GXml.DomNode}s
 * and the object's list of properties as used by
 * {@link GXml.Serialization}.
 *
 * A {@link GXml.SerializationError} may be thrown if there is
 * a problem serializing a property (e.g. the type is unknown,
 * unsupported, or the property isn't known to the object).
 *
 * @param object A {@link GLib.Object} to serialize
 * @return a {@link GXml.DomNode} representing the serialized `object`
 */
static GParamSpec** _vala_array_dup2 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static GParamSpec** _vala_array_dup3 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


GXmlDomNode* gxml_serialization_serialize_object (GObject* object, GError** error) {
	GXmlDomNode* result = NULL;
	GXmlDocument* doc = NULL;
	GXmlElement* root = NULL;
	GParamSpec** prop_specs = NULL;
	gint prop_specs_length1 = 0;
	gint _prop_specs_size_ = 0;
	GXmlElement* prop = NULL;
	GXmlSerializable* serializable;
	GXmlDomNode* value_prop;
	gchar* oid = NULL;
	GObject* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean debug;
	gboolean _tmp100_;
	GXmlDocument* _tmp103_;
	GXmlElement* _tmp104_;
	GXmlElement* _tmp105_;
	GXmlDomNode* _tmp106_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (object != NULL, NULL);
	serializable = NULL;
	value_prop = NULL;
	_tmp0_ = object;
	_tmp1_ = g_strdup_printf ("%p", _tmp0_);
	_g_free0 (oid);
	oid = _tmp1_;
	gxml_serialization_init_caches ();
	{
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		gboolean _tmp7_;
		GObject* _tmp29_;
		GType _tmp30_ = 0UL;
		gboolean _tmp31_ = FALSE;
		GXmlDocument* _tmp34_;
		GXmlDocument* _tmp35_;
		GXmlDocument* _tmp36_;
		GXmlDocument* _tmp37_;
		GXmlDocument* _tmp38_;
		GXmlElement* _tmp39_ = NULL;
		GXmlElement* _tmp40_;
		GXmlDocument* _tmp41_;
		GXmlElement* _tmp42_;
		GXmlDomNode* _tmp43_ = NULL;
		GXmlDomNode* _tmp44_;
		GXmlElement* _tmp45_;
		GObject* _tmp46_;
		GType _tmp47_ = 0UL;
		const gchar* _tmp48_ = NULL;
		GXmlElement* _tmp49_;
		const gchar* _tmp50_;
		GHashTable* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		GXmlElement* _tmp54_;
		GXmlDomNode* _tmp55_;
		GXmlSerializable* _tmp56_;
		GParamSpec** _tmp66_;
		gint _tmp66__length1;
		_tmp3_ = oid;
		if (g_strcmp0 (_tmp3_, "") != 0) {
			GHashTable* _tmp4_;
			const gchar* _tmp5_;
			gboolean _tmp6_ = FALSE;
			_tmp4_ = gxml_serialization_serialize_cache;
			_tmp5_ = oid;
			_tmp6_ = g_hash_table_contains (_tmp4_, _tmp5_);
			_tmp2_ = _tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			GXmlDocument* _tmp8_;
			GXmlDocument* _tmp9_;
			GXmlDocument* _tmp10_;
			GXmlDocument* _tmp11_;
			GXmlDocument* _tmp12_;
			GXmlElement* _tmp13_ = NULL;
			GXmlElement* _tmp14_;
			GXmlDocument* _tmp15_;
			GXmlElement* _tmp16_;
			GXmlDomNode* _tmp17_ = NULL;
			GXmlDomNode* _tmp18_;
			GXmlElement* _tmp19_;
			GObject* _tmp20_;
			GType _tmp21_ = 0UL;
			const gchar* _tmp22_ = NULL;
			GXmlElement* _tmp23_;
			const gchar* _tmp24_;
			GXmlDocument* _tmp25_;
			GXmlElement* _tmp26_;
			GXmlElement* _tmp27_;
			GXmlDomNode* _tmp28_;
			_tmp8_ = gxml_document_new (&_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GXML_DOM_ERROR) {
					goto __catch6_gxml_dom_error;
				}
				_g_free0 (oid);
				_g_object_unref0 (value_prop);
				_g_object_unref0 (serializable);
				_g_object_unref0 (prop);
				prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
				_g_object_unref0 (root);
				_g_object_unref0 (doc);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (doc);
			doc = _tmp9_;
			_tmp10_ = doc;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			gxml_serialization__docs = g_list_append (gxml_serialization__docs, _tmp11_);
			_tmp12_ = doc;
			_tmp13_ = gxml_document_create_element (_tmp12_, "ObjectRef", &_inner_error_);
			_tmp14_ = _tmp13_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GXML_DOM_ERROR) {
					goto __catch6_gxml_dom_error;
				}
				_g_free0 (oid);
				_g_object_unref0 (value_prop);
				_g_object_unref0 (serializable);
				_g_object_unref0 (prop);
				prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
				_g_object_unref0 (root);
				_g_object_unref0 (doc);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (root);
			root = _tmp14_;
			_tmp15_ = doc;
			_tmp16_ = root;
			_tmp17_ = gxml_dom_node_append_child ((GXmlDomNode*) _tmp15_, (GXmlDomNode*) _tmp16_, &_inner_error_);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp18_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GXML_DOM_ERROR) {
					goto __catch6_gxml_dom_error;
				}
				_g_free0 (oid);
				_g_object_unref0 (value_prop);
				_g_object_unref0 (serializable);
				_g_object_unref0 (prop);
				prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
				_g_object_unref0 (root);
				_g_object_unref0 (doc);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp19_ = root;
			_tmp20_ = object;
			_tmp21_ = G_TYPE_FROM_INSTANCE (_tmp20_);
			_tmp22_ = g_type_name (_tmp21_);
			gxml_element_set_attribute (_tmp19_, "otype", _tmp22_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GXML_DOM_ERROR) {
					goto __catch6_gxml_dom_error;
				}
				_g_free0 (oid);
				_g_object_unref0 (value_prop);
				_g_object_unref0 (serializable);
				_g_object_unref0 (prop);
				prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
				_g_object_unref0 (root);
				_g_object_unref0 (doc);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp23_ = root;
			_tmp24_ = oid;
			gxml_element_set_attribute (_tmp23_, "oid", _tmp24_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GXML_DOM_ERROR) {
					goto __catch6_gxml_dom_error;
				}
				_g_free0 (oid);
				_g_object_unref0 (value_prop);
				_g_object_unref0 (serializable);
				_g_object_unref0 (prop);
				prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
				_g_object_unref0 (root);
				_g_object_unref0 (doc);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp25_ = doc;
			_tmp26_ = gxml_document_get_document_element (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = _g_object_ref0 ((GXmlDomNode*) _tmp27_);
			result = _tmp28_;
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (serializable);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			return result;
		}
		_tmp29_ = object;
		_tmp30_ = G_TYPE_FROM_INSTANCE (_tmp29_);
		_tmp31_ = g_type_is_a (_tmp30_, GXML_TYPE_SERIALIZABLE);
		if (_tmp31_) {
			GObject* _tmp32_;
			GXmlSerializable* _tmp33_;
			_tmp32_ = object;
			_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GXML_TYPE_SERIALIZABLE, GXmlSerializable));
			_g_object_unref0 (serializable);
			serializable = _tmp33_;
		}
		_tmp34_ = gxml_document_new (&_inner_error_);
		_tmp35_ = _tmp34_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GXML_DOM_ERROR) {
				goto __catch6_gxml_dom_error;
			}
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (serializable);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (doc);
		doc = _tmp35_;
		_tmp36_ = doc;
		_tmp37_ = _g_object_ref0 (_tmp36_);
		gxml_serialization__docs = g_list_append (gxml_serialization__docs, _tmp37_);
		_tmp38_ = doc;
		_tmp39_ = gxml_document_create_element (_tmp38_, "Object", &_inner_error_);
		_tmp40_ = _tmp39_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GXML_DOM_ERROR) {
				goto __catch6_gxml_dom_error;
			}
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (serializable);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (root);
		root = _tmp40_;
		_tmp41_ = doc;
		_tmp42_ = root;
		_tmp43_ = gxml_dom_node_append_child ((GXmlDomNode*) _tmp41_, (GXmlDomNode*) _tmp42_, &_inner_error_);
		_tmp44_ = _tmp43_;
		_g_object_unref0 (_tmp44_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GXML_DOM_ERROR) {
				goto __catch6_gxml_dom_error;
			}
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (serializable);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp45_ = root;
		_tmp46_ = object;
		_tmp47_ = G_TYPE_FROM_INSTANCE (_tmp46_);
		_tmp48_ = g_type_name (_tmp47_);
		gxml_element_set_attribute (_tmp45_, "otype", _tmp48_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GXML_DOM_ERROR) {
				goto __catch6_gxml_dom_error;
			}
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (serializable);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp49_ = root;
		_tmp50_ = oid;
		gxml_element_set_attribute (_tmp49_, "oid", _tmp50_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GXML_DOM_ERROR) {
				goto __catch6_gxml_dom_error;
			}
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (serializable);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp51_ = gxml_serialization_serialize_cache;
		_tmp52_ = oid;
		_tmp53_ = g_strdup (_tmp52_);
		_tmp54_ = root;
		_tmp55_ = _g_object_ref0 ((GXmlDomNode*) _tmp54_);
		g_hash_table_insert (_tmp51_, _tmp53_, _tmp55_);
		_tmp56_ = serializable;
		if (_tmp56_ != NULL) {
			GXmlSerializable* _tmp57_;
			gint _tmp58_ = 0;
			GParamSpec** _tmp59_ = NULL;
			GParamSpec** _tmp60_;
			gint _tmp60__length1;
			_tmp57_ = serializable;
			_tmp59_ = gxml_serializable_list_properties (_tmp57_, &_tmp58_);
			_tmp60_ = (_tmp59_ != NULL) ? _vala_array_dup2 (_tmp59_, _tmp58_) : ((gpointer) _tmp59_);
			_tmp60__length1 = _tmp58_;
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			prop_specs = _tmp60_;
			prop_specs_length1 = _tmp60__length1;
			_prop_specs_size_ = prop_specs_length1;
		} else {
			GObject* _tmp61_;
			GObjectClass* _tmp62_ = NULL;
			guint _tmp63_;
			GParamSpec** _tmp64_ = NULL;
			GParamSpec** _tmp65_;
			gint _tmp65__length1;
			_tmp61_ = object;
			_tmp62_ = G_OBJECT_GET_CLASS (_tmp61_);
			_tmp64_ = g_object_class_list_properties (_tmp62_, &_tmp63_);
			_tmp65_ = (_tmp64_ != NULL) ? _vala_array_dup3 (_tmp64_, _tmp63_) : ((gpointer) _tmp64_);
			_tmp65__length1 = _tmp63_;
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			prop_specs = _tmp65_;
			prop_specs_length1 = _tmp65__length1;
			_prop_specs_size_ = prop_specs_length1;
		}
		_tmp66_ = prop_specs;
		_tmp66__length1 = prop_specs_length1;
		{
			GParamSpec** prop_spec_collection = NULL;
			gint prop_spec_collection_length1 = 0;
			gint _prop_spec_collection_size_ = 0;
			gint prop_spec_it = 0;
			prop_spec_collection = _tmp66_;
			prop_spec_collection_length1 = _tmp66__length1;
			for (prop_spec_it = 0; prop_spec_it < _tmp66__length1; prop_spec_it = prop_spec_it + 1) {
				GParamSpec* _tmp67_;
				GParamSpec* prop_spec = NULL;
				_tmp67_ = _g_param_spec_ref0 (prop_spec_collection[prop_spec_it]);
				prop_spec = _tmp67_;
				{
					GXmlDocument* _tmp68_;
					GXmlElement* _tmp69_ = NULL;
					GXmlElement* _tmp70_;
					GXmlElement* _tmp71_;
					GParamSpec* _tmp72_;
					GType _tmp73_;
					const gchar* _tmp74_ = NULL;
					GXmlElement* _tmp75_;
					GParamSpec* _tmp76_;
					const gchar* _tmp77_;
					GXmlSerializable* _tmp78_;
					GXmlDomNode* _tmp85_;
					GXmlElement* _tmp91_;
					GXmlDomNode* _tmp92_;
					GXmlDomNode* _tmp93_ = NULL;
					GXmlDomNode* _tmp94_;
					GXmlElement* _tmp95_;
					GXmlElement* _tmp96_;
					GXmlDomNode* _tmp97_ = NULL;
					GXmlDomNode* _tmp98_;
					_tmp68_ = doc;
					_tmp69_ = gxml_document_create_element (_tmp68_, "Property", &_inner_error_);
					_tmp70_ = _tmp69_;
					if (_inner_error_ != NULL) {
						_g_param_spec_unref0 (prop_spec);
						if (_inner_error_->domain == GXML_DOM_ERROR) {
							goto __catch6_gxml_dom_error;
						}
						_g_param_spec_unref0 (prop_spec);
						_g_free0 (oid);
						_g_object_unref0 (value_prop);
						_g_object_unref0 (serializable);
						_g_object_unref0 (prop);
						prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						_g_object_unref0 (root);
						_g_object_unref0 (doc);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_object_unref0 (prop);
					prop = _tmp70_;
					_tmp71_ = prop;
					_tmp72_ = prop_spec;
					_tmp73_ = _tmp72_->value_type;
					_tmp74_ = g_type_name (_tmp73_);
					gxml_element_set_attribute (_tmp71_, "ptype", _tmp74_, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_param_spec_unref0 (prop_spec);
						if (_inner_error_->domain == GXML_DOM_ERROR) {
							goto __catch6_gxml_dom_error;
						}
						_g_param_spec_unref0 (prop_spec);
						_g_free0 (oid);
						_g_object_unref0 (value_prop);
						_g_object_unref0 (serializable);
						_g_object_unref0 (prop);
						prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						_g_object_unref0 (root);
						_g_object_unref0 (doc);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp75_ = prop;
					_tmp76_ = prop_spec;
					_tmp77_ = _tmp76_->name;
					gxml_element_set_attribute (_tmp75_, "pname", _tmp77_, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_param_spec_unref0 (prop_spec);
						if (_inner_error_->domain == GXML_DOM_ERROR) {
							goto __catch6_gxml_dom_error;
						}
						_g_param_spec_unref0 (prop_spec);
						_g_free0 (oid);
						_g_object_unref0 (value_prop);
						_g_object_unref0 (serializable);
						_g_object_unref0 (prop);
						prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						_g_object_unref0 (root);
						_g_object_unref0 (doc);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_object_unref0 (value_prop);
					value_prop = NULL;
					_tmp78_ = serializable;
					if (_tmp78_ != NULL) {
						GXmlSerializable* _tmp79_;
						GParamSpec* _tmp80_;
						const gchar* _tmp81_;
						GParamSpec* _tmp82_;
						GXmlDocument* _tmp83_;
						GXmlDomNode* _tmp84_ = NULL;
						_tmp79_ = serializable;
						_tmp80_ = prop_spec;
						_tmp81_ = _tmp80_->name;
						_tmp82_ = prop_spec;
						_tmp83_ = doc;
						_tmp84_ = gxml_serializable_serialize_property (_tmp79_, _tmp81_, _tmp82_, _tmp83_);
						_g_object_unref0 (value_prop);
						value_prop = _tmp84_;
					}
					_tmp85_ = value_prop;
					if (_tmp85_ == NULL) {
						GObject* _tmp86_;
						GParamSpec* _tmp87_;
						GXmlDocument* _tmp88_;
						GXmlDomNode* _tmp89_ = NULL;
						GXmlDomNode* _tmp90_;
						_tmp86_ = object;
						_tmp87_ = prop_spec;
						_tmp88_ = doc;
						_tmp89_ = gxml_serialization_serialize_property (_tmp86_, _tmp87_, _tmp88_, &_inner_error_);
						_tmp90_ = _tmp89_;
						if (_inner_error_ != NULL) {
							_g_param_spec_unref0 (prop_spec);
							if (_inner_error_->domain == GXML_DOM_ERROR) {
								goto __catch6_gxml_dom_error;
							}
							goto __finally6;
						}
						_g_object_unref0 (value_prop);
						value_prop = _tmp90_;
					}
					_tmp91_ = prop;
					_tmp92_ = value_prop;
					_tmp93_ = gxml_dom_node_append_child ((GXmlDomNode*) _tmp91_, _tmp92_, &_inner_error_);
					_tmp94_ = _tmp93_;
					_g_object_unref0 (_tmp94_);
					if (_inner_error_ != NULL) {
						_g_param_spec_unref0 (prop_spec);
						if (_inner_error_->domain == GXML_DOM_ERROR) {
							goto __catch6_gxml_dom_error;
						}
						_g_param_spec_unref0 (prop_spec);
						_g_free0 (oid);
						_g_object_unref0 (value_prop);
						_g_object_unref0 (serializable);
						_g_object_unref0 (prop);
						prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						_g_object_unref0 (root);
						_g_object_unref0 (doc);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp95_ = root;
					_tmp96_ = prop;
					_tmp97_ = gxml_dom_node_append_child ((GXmlDomNode*) _tmp95_, (GXmlDomNode*) _tmp96_, &_inner_error_);
					_tmp98_ = _tmp97_;
					_g_object_unref0 (_tmp98_);
					if (_inner_error_ != NULL) {
						_g_param_spec_unref0 (prop_spec);
						if (_inner_error_->domain == GXML_DOM_ERROR) {
							goto __catch6_gxml_dom_error;
						}
						_g_param_spec_unref0 (prop_spec);
						_g_free0 (oid);
						_g_object_unref0 (value_prop);
						_g_object_unref0 (serializable);
						_g_object_unref0 (prop);
						prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						_g_object_unref0 (root);
						_g_object_unref0 (doc);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_param_spec_unref0 (prop_spec);
				}
			}
		}
	}
	goto __finally6;
	__catch6_gxml_dom_error:
	{
		GError* e = NULL;
		const gchar* _tmp99_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp99_ = e->message;
		g_error ("Serialization.vala:285: %s", _tmp99_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (serializable);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			return NULL;
		} else {
			_g_free0 (oid);
			_g_object_unref0 (value_prop);
			_g_object_unref0 (serializable);
			_g_object_unref0 (prop);
			prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (root);
			_g_object_unref0 (doc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	debug = FALSE;
	_tmp100_ = debug;
	if (_tmp100_) {
		GXmlDocument* _tmp101_;
		GObject* _tmp102_;
		_tmp101_ = doc;
		_tmp102_ = object;
		gxml_serialization_print_debug (_tmp101_, _tmp102_);
	}
	_tmp103_ = doc;
	_tmp104_ = gxml_document_get_document_element (_tmp103_);
	_tmp105_ = _tmp104_;
	_tmp106_ = _g_object_ref0 ((GXmlDomNode*) _tmp105_);
	result = _tmp106_;
	_g_free0 (oid);
	_g_object_unref0 (value_prop);
	_g_object_unref0 (serializable);
	_g_object_unref0 (prop);
	prop_specs = (_vala_array_free (prop_specs, prop_specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_object_unref0 (root);
	_g_object_unref0 (doc);
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void gxml_serialization_deserialize_property (GParamSpec* spec, GXmlElement* prop_elem, GValue* val, GError** error) {
	GValue _vala_val = {0};
	GType type = 0UL;
	GParamSpec* _tmp0_;
	GType _tmp1_;
	gboolean transformed;
	GType _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	GType _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (spec != NULL);
	g_return_if_fail (prop_elem != NULL);
	_tmp0_ = spec;
	_tmp1_ = _tmp0_->value_type;
	type = _tmp1_;
	transformed = FALSE;
	_tmp2_ = type;
	g_value_init (&_tmp3_, _tmp2_);
	G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	_vala_val = _tmp3_;
	_tmp4_ = _vala_val;
	_tmp5_ = type;
	_tmp6_ = g_value_type_transformable (_tmp5_, G_TYPE_STRING);
	if (_tmp6_) {
		{
			GXmlElement* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = prop_elem;
			_tmp8_ = gxml_element_get_content (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			gxml_serialization_string_to_gvalue (_tmp10_, &_vala_val, &_inner_error_);
			_g_free0 (_tmp10_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
					goto __catch7_gxml_serialization_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			transformed = TRUE;
		}
		goto __finally7;
		__catch7_gxml_serialization_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = g_error_new_literal (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNSUPPORTED_TYPE, "string_to_gvalue should transform it but failed");
			_inner_error_ = _tmp11_;
			_g_error_free0 (e);
			goto __finally7;
		}
		__finally7:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		GType _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = type;
		_tmp13_ = g_type_is_a (_tmp12_, G_TYPE_OBJECT);
		if (_tmp13_) {
			GXmlDomNode* prop_elem_child = NULL;
			GObject* property_object = NULL;
			GXmlElement* _tmp14_;
			GXmlDomNode* _tmp15_;
			GXmlDomNode* _tmp16_;
			GXmlDomNode* _tmp17_;
			_tmp14_ = prop_elem;
			_tmp15_ = gxml_dom_node_get_first_child ((GXmlDomNode*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _g_object_ref0 (_tmp16_);
			_g_object_unref0 (prop_elem_child);
			prop_elem_child = _tmp17_;
			{
				GXmlDomNode* _tmp18_;
				GObject* _tmp19_ = NULL;
				GObject* _tmp20_;
				GObject* _tmp21_;
				_tmp18_ = prop_elem_child;
				_tmp19_ = gxml_serialization_deserialize_object (_tmp18_, &_inner_error_);
				_tmp20_ = _tmp19_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
						goto __catch8_gxml_serialization_error;
					}
					_g_object_unref0 (property_object);
					_g_object_unref0 (prop_elem_child);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (property_object);
				property_object = _tmp20_;
				_tmp21_ = property_object;
				g_value_set_object (&_vala_val, _tmp21_);
				transformed = TRUE;
			}
			goto __finally8;
			__catch8_gxml_serialization_error:
			{
				GError* e = NULL;
				GError* _tmp22_;
				GError* _tmp23_;
				const gchar* _tmp24_;
				GXmlElement* _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GError* _tmp31_;
				GError* _tmp32_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp22_ = e;
				_tmp23_ = e;
				_tmp24_ = _tmp23_->message;
				_tmp25_ = prop_elem;
				_tmp26_ = gxml_dom_node_to_string ((GXmlDomNode*) _tmp25_, FALSE, 0);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strdup_printf ("\nXML [%s]", _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strconcat (_tmp24_, _tmp29_, NULL);
				_g_free0 (_tmp23_->message);
				_tmp23_->message = _tmp30_;
				_g_free0 (_tmp29_);
				_g_free0 (_tmp27_);
				_tmp31_ = e;
				_tmp32_ = _g_error_copy0 (_tmp31_);
				_inner_error_ = _tmp32_;
				_g_error_free0 (e);
				goto __finally8;
			}
			__finally8:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (property_object);
					_g_object_unref0 (prop_elem_child);
					return;
				} else {
					_g_object_unref0 (property_object);
					_g_object_unref0 (prop_elem_child);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_object_unref0 (property_object);
			_g_object_unref0 (prop_elem_child);
		}
	}
	_tmp33_ = transformed;
	if (_tmp33_ == FALSE) {
		GError* _tmp34_;
		_tmp34_ = g_error_new_literal (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNSUPPORTED_TYPE, "Failed to transform property from string to type.");
		_inner_error_ = _tmp34_;
		if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (val) {
		*val = _vala_val;
	} else {
		G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	}
}


void gxml_serialization_clear_cache (void) {
	GHashTable* _tmp0_;
	GHashTable* _tmp2_;
	_tmp0_ = gxml_serialization_deserialize_cache;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = gxml_serialization_deserialize_cache;
		g_hash_table_remove_all (_tmp1_);
	}
	_tmp2_ = gxml_serialization_serialize_cache;
	if (_tmp2_ != NULL) {
		GHashTable* _tmp3_;
		_tmp3_ = gxml_serialization_serialize_cache;
		g_hash_table_remove_all (_tmp3_);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void gxml_serialization_init_caches (void) {
	GHashTable* _tmp0_;
	GHashTable* _tmp4_;
	_tmp0_ = gxml_serialization_deserialize_cache;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (gxml_serialization_deserialize_cache);
		gxml_serialization_deserialize_cache = _tmp3_;
	}
	_tmp4_ = gxml_serialization_serialize_cache;
	if (_tmp4_ == NULL) {
		GHashFunc _tmp5_;
		GEqualFunc _tmp6_;
		GHashTable* _tmp7_;
		_tmp5_ = g_str_hash;
		_tmp6_ = g_str_equal;
		_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (gxml_serialization_serialize_cache);
		gxml_serialization_serialize_cache = _tmp7_;
	}
}


/**
 * Deserialize a {@link GXml.DomNode} back into a {@link GLib.Object}.
 *
 * This deserializes a {@link GXml.DomNode} back into a {@link GLib.Object}.  The
 * {@link GXml.DomNode} must represented a {@link GLib.Object} as serialized by
 * {@link GXml.Serialization}.  The types of the objects that are
 * being deserialized must be known to the system
 * deserializing them or a {@link GXml.SerializationError} will
 * result.
 *
 * @param node {@link GXml.DomNode} representing a {@link GLib.Object}
 * @return the deserialized {@link GLib.Object}
 */
static void g_parameter_destroy (GParameter* self) {
	G_IS_VALUE (&(*self).value) ? (g_value_unset (&(*self).value), NULL) : NULL;
}


static void _vala_GParameter_array_free (GParameter* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_parameter_destroy (&array[i]);
		}
	}
	g_free (array);
}


static GParamSpec** _vala_array_dup4 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static GParamSpec** _vala_array_dup5 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


GObject* gxml_serialization_deserialize_object (GXmlDomNode* node, GError** error) {
	GObject* result = NULL;
	GXmlElement* obj_elem = NULL;
	gchar* otype = NULL;
	gchar* oid = NULL;
	GType type = 0UL;
	GObject* obj = NULL;
	GObjectClass* obj_class = NULL;
	GParamSpec** specs = NULL;
	gint specs_length1 = 0;
	gint _specs_size_ = 0;
	GXmlSerializable* serializable;
	GXmlDomNode* _tmp0_;
	GXmlElement* _tmp1_;
	GXmlElement* _tmp2_;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp9_;
	GXmlElement* _tmp14_;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	GType _tmp17_ = 0UL;
	GType _tmp18_;
	GType _tmp21_;
	GParameter* _tmp22_ = NULL;
	GParameter* _tmp23_;
	gint _tmp23__length1;
	GObject* _tmp24_ = NULL;
	GObject* _tmp25_;
	GObject* _tmp26_;
	GObjectClass* _tmp27_ = NULL;
	GHashTable* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GObject* _tmp31_;
	GObject* _tmp32_;
	GType _tmp33_;
	gboolean _tmp34_ = FALSE;
	GXmlSerializable* _tmp37_;
	GError* err;
	GError* _tmp113_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	serializable = NULL;
	_tmp0_ = node;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GXML_TYPE_ELEMENT, GXmlElement));
	_g_object_unref0 (obj_elem);
	obj_elem = _tmp1_;
	_tmp2_ = obj_elem;
	_tmp3_ = gxml_element_get_attribute (_tmp2_, "oid");
	_g_free0 (oid);
	oid = _tmp3_;
	gxml_serialization_init_caches ();
	_tmp5_ = oid;
	if (g_strcmp0 (_tmp5_, "") != 0) {
		GHashTable* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = gxml_serialization_deserialize_cache;
		_tmp7_ = oid;
		_tmp8_ = g_hash_table_contains (_tmp6_, _tmp7_);
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		GHashTable* _tmp10_;
		const gchar* _tmp11_;
		gconstpointer _tmp12_ = NULL;
		GObject* _tmp13_;
		_tmp10_ = gxml_serialization_deserialize_cache;
		_tmp11_ = oid;
		_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
		_tmp13_ = _g_object_ref0 ((GObject*) _tmp12_);
		result = _tmp13_;
		_g_object_unref0 (serializable);
		specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		_g_object_unref0 (obj);
		_g_free0 (oid);
		_g_free0 (otype);
		_g_object_unref0 (obj_elem);
		return result;
	}
	_tmp14_ = obj_elem;
	_tmp15_ = gxml_element_get_attribute (_tmp14_, "otype");
	_g_free0 (otype);
	otype = _tmp15_;
	_tmp16_ = otype;
	_tmp17_ = g_type_from_name (_tmp16_);
	type = _tmp17_;
	_tmp18_ = type;
	if (_tmp18_ == ((GType) 0)) {
		const gchar* _tmp19_;
		GError* _tmp20_;
		_tmp19_ = otype;
		_tmp20_ = g_error_new (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNKNOWN_TYPE, "Deserializing object claims unknown type '%s'", _tmp19_);
		_inner_error_ = _tmp20_;
		if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (serializable);
			specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (obj);
			_g_free0 (oid);
			_g_free0 (otype);
			_g_object_unref0 (obj_elem);
			return NULL;
		} else {
			_g_object_unref0 (serializable);
			specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (obj);
			_g_free0 (oid);
			_g_free0 (otype);
			_g_object_unref0 (obj_elem);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp21_ = type;
	_tmp22_ = g_new0 (GParameter, 0);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 0;
	_tmp24_ = g_object_newv (_tmp21_, 0, _tmp23_);
	_tmp25_ = G_IS_INITIALLY_UNOWNED (_tmp24_) ? g_object_ref_sink (_tmp24_) : _tmp24_;
	_g_object_unref0 (obj);
	obj = _tmp25_;
	_tmp23_ = (_vala_GParameter_array_free (_tmp23_, _tmp23__length1), NULL);
	_tmp26_ = obj;
	_tmp27_ = G_OBJECT_GET_CLASS (_tmp26_);
	obj_class = _tmp27_;
	_tmp28_ = gxml_serialization_deserialize_cache;
	_tmp29_ = oid;
	_tmp30_ = g_strdup (_tmp29_);
	_tmp31_ = obj;
	_tmp32_ = _g_object_ref0 (_tmp31_);
	g_hash_table_insert (_tmp28_, _tmp30_, _tmp32_);
	_tmp33_ = type;
	_tmp34_ = g_type_is_a (_tmp33_, GXML_TYPE_SERIALIZABLE);
	if (_tmp34_) {
		GObject* _tmp35_;
		GXmlSerializable* _tmp36_;
		_tmp35_ = obj;
		_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GXML_TYPE_SERIALIZABLE, GXmlSerializable));
		_g_object_unref0 (serializable);
		serializable = _tmp36_;
	}
	_tmp37_ = serializable;
	if (_tmp37_ != NULL) {
		GXmlSerializable* _tmp38_;
		gint _tmp39_ = 0;
		GParamSpec** _tmp40_ = NULL;
		GParamSpec** _tmp41_;
		gint _tmp41__length1;
		_tmp38_ = serializable;
		_tmp40_ = gxml_serializable_list_properties (_tmp38_, &_tmp39_);
		_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup4 (_tmp40_, _tmp39_) : ((gpointer) _tmp40_);
		_tmp41__length1 = _tmp39_;
		specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		specs = _tmp41_;
		specs_length1 = _tmp41__length1;
		_specs_size_ = specs_length1;
	} else {
		GObjectClass* _tmp42_;
		guint _tmp43_;
		GParamSpec** _tmp44_ = NULL;
		GParamSpec** _tmp45_;
		gint _tmp45__length1;
		_tmp42_ = obj_class;
		_tmp44_ = g_object_class_list_properties (_tmp42_, &_tmp43_);
		_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup5 (_tmp44_, _tmp43_) : ((gpointer) _tmp44_);
		_tmp45__length1 = _tmp43_;
		specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		specs = _tmp45_;
		specs_length1 = _tmp45__length1;
		_specs_size_ = specs_length1;
	}
	err = NULL;
	{
		GXmlElement* _tmp46_;
		GXmlNodeList* _tmp47_;
		GXmlNodeList* _tmp48_;
		GXmlNodeList* _tmp49_;
		GeeIterator* _tmp50_ = NULL;
		GeeIterator* _tmp51_;
		GeeIterator* _child_node_it;
		_tmp46_ = obj_elem;
		_tmp47_ = gxml_dom_node_get_child_nodes ((GXmlDomNode*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_;
		_tmp50_ = gee_iterable_iterator ((GeeIterable*) _tmp49_);
		_tmp51_ = _tmp50_;
		_g_object_unref0 (_tmp49_);
		_child_node_it = _tmp51_;
		while (TRUE) {
			GeeIterator* _tmp52_;
			gboolean _tmp53_ = FALSE;
			GeeIterator* _tmp54_;
			gpointer _tmp55_ = NULL;
			GXmlDomNode* child_node;
			GXmlDomNode* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			_tmp52_ = _child_node_it;
			_tmp53_ = gee_iterator_next (_tmp52_);
			if (!_tmp53_) {
				break;
			}
			_tmp54_ = _child_node_it;
			_tmp55_ = gee_iterator_get (_tmp54_);
			child_node = (GXmlDomNode*) _tmp55_;
			_tmp56_ = child_node;
			_tmp57_ = gxml_dom_node_get_node_name (_tmp56_);
			_tmp58_ = _tmp57_;
			if (g_strcmp0 (_tmp58_, "Property") == 0) {
				GXmlElement* prop_elem = NULL;
				gchar* pname = NULL;
				GValue val = {0};
				GXmlDomNode* _tmp59_;
				GXmlElement* _tmp60_;
				GXmlElement* _tmp61_;
				gchar* _tmp62_ = NULL;
				GParamSpec* spec;
				GXmlSerializable* _tmp63_;
				GParamSpec* _tmp72_;
				_tmp59_ = child_node;
				_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GXML_TYPE_ELEMENT, GXmlElement));
				_g_object_unref0 (prop_elem);
				prop_elem = _tmp60_;
				_tmp61_ = prop_elem;
				_tmp62_ = gxml_element_get_attribute (_tmp61_, "pname");
				_g_free0 (pname);
				pname = _tmp62_;
				spec = NULL;
				_tmp63_ = serializable;
				if (_tmp63_ != NULL) {
					GXmlSerializable* _tmp64_;
					const gchar* _tmp65_;
					GParamSpec* _tmp66_ = NULL;
					GParamSpec* _tmp67_;
					_tmp64_ = serializable;
					_tmp65_ = pname;
					_tmp66_ = gxml_serializable_find_property (_tmp64_, _tmp65_);
					_tmp67_ = _g_param_spec_ref0 (_tmp66_);
					_g_param_spec_unref0 (spec);
					spec = _tmp67_;
				} else {
					GObjectClass* _tmp68_;
					const gchar* _tmp69_;
					GParamSpec* _tmp70_ = NULL;
					GParamSpec* _tmp71_;
					_tmp68_ = obj_class;
					_tmp69_ = pname;
					_tmp70_ = g_object_class_find_property (_tmp68_, _tmp69_);
					_tmp71_ = _g_param_spec_ref0 (_tmp70_);
					_g_param_spec_unref0 (spec);
					spec = _tmp71_;
				}
				_tmp72_ = spec;
				if (_tmp72_ == NULL) {
					const gchar* _tmp73_;
					const gchar* _tmp74_;
					GXmlElement* _tmp75_;
					gchar* _tmp76_ = NULL;
					gchar* _tmp77_;
					GError* _tmp78_;
					_tmp73_ = otype;
					_tmp74_ = pname;
					_tmp75_ = obj_elem;
					_tmp76_ = gxml_dom_node_to_string ((GXmlDomNode*) _tmp75_, FALSE, 0);
					_tmp77_ = _tmp76_;
					_tmp78_ = g_error_new (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNKNOWN_PROPERTY, "Deserializing object of type '%s' claimed unknown property named '%s'\n" \
"XML [%s]", _tmp73_, _tmp74_, _tmp77_);
					_g_error_free0 (err);
					err = _tmp78_;
					_g_free0 (_tmp77_);
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					_g_object_unref0 (child_node);
					break;
				}
				{
					gboolean serialized;
					GXmlSerializable* _tmp79_;
					gboolean _tmp86_;
					serialized = FALSE;
					_tmp79_ = serializable;
					if (_tmp79_ != NULL) {
						GXmlSerializable* _tmp80_;
						GParamSpec* _tmp81_;
						const gchar* _tmp82_;
						GParamSpec* _tmp83_;
						GXmlElement* _tmp84_;
						gboolean _tmp85_ = FALSE;
						_tmp80_ = serializable;
						_tmp81_ = spec;
						_tmp82_ = _tmp81_->name;
						_tmp83_ = spec;
						_tmp84_ = prop_elem;
						_tmp85_ = gxml_serializable_deserialize_property (_tmp80_, _tmp82_, _tmp83_, (GXmlDomNode*) _tmp84_);
						serialized = _tmp85_;
					}
					_tmp86_ = serialized;
					if (!_tmp86_) {
						GParamSpec* _tmp87_;
						GXmlElement* _tmp88_;
						GValue _tmp89_ = {0};
						GXmlSerializable* _tmp90_;
						_tmp87_ = spec;
						_tmp88_ = prop_elem;
						gxml_serialization_deserialize_property (_tmp87_, _tmp88_, &_tmp89_, &_inner_error_);
						G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
						val = _tmp89_;
						if (_inner_error_ != NULL) {
							if (g_error_matches (_inner_error_, GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNSUPPORTED_TYPE)) {
								goto __catch9_gxml_serialization_error_unsupported_type;
							}
							goto __finally9;
						}
						_tmp90_ = serializable;
						if (_tmp90_ != NULL) {
							GXmlSerializable* _tmp91_;
							GParamSpec* _tmp92_;
							GValue _tmp93_;
							_tmp91_ = serializable;
							_tmp92_ = spec;
							_tmp93_ = val;
							gxml_serializable_set_property (_tmp91_, _tmp92_, &_tmp93_);
						} else {
							GObject* _tmp94_;
							const gchar* _tmp95_;
							GValue _tmp96_;
							_tmp94_ = obj;
							_tmp95_ = pname;
							_tmp96_ = val;
							g_object_set_property (_tmp94_, _tmp95_, &_tmp96_);
						}
					}
				}
				goto __finally9;
				__catch9_gxml_serialization_error_unsupported_type:
				{
					GError* e = NULL;
					const gchar* _tmp97_;
					GParamSpec* _tmp98_;
					const gchar* _tmp99_;
					GParamSpec* _tmp100_;
					GType _tmp101_;
					const gchar* _tmp102_ = NULL;
					GParamSpec* _tmp103_;
					GType _tmp104_;
					gchar* _tmp105_ = NULL;
					gchar* _tmp106_;
					GError* _tmp107_;
					const gchar* _tmp108_;
					GXmlElement* _tmp109_;
					gchar* _tmp110_ = NULL;
					gchar* _tmp111_;
					GError* _tmp112_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp97_ = otype;
					_tmp98_ = spec;
					_tmp99_ = _tmp98_->name;
					_tmp100_ = spec;
					_tmp101_ = _tmp100_->value_type;
					_tmp102_ = g_type_name (_tmp101_);
					_tmp103_ = spec;
					_tmp104_ = _tmp103_->value_type;
					_tmp105_ = g_strdup_printf ("%lu", (gulong) _tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = e;
					_tmp108_ = _tmp107_->message;
					_tmp109_ = obj_elem;
					_tmp110_ = gxml_dom_node_to_string ((GXmlDomNode*) _tmp109_, FALSE, 0);
					_tmp111_ = _tmp110_;
					_tmp112_ = g_error_new (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNSUPPORTED_TYPE, "Cannot deserialize object '%s's property '%s' with type '%s/%s': %s\n" \
"XML [%s]", _tmp97_, _tmp99_, _tmp102_, _tmp106_, _tmp108_, _tmp111_);
					_g_error_free0 (err);
					err = _tmp112_;
					_g_free0 (_tmp111_);
					_g_free0 (_tmp106_);
					_g_error_free0 (e);
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					_g_object_unref0 (child_node);
					break;
				}
				__finally9:
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_param_spec_unref0 (spec);
						G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
						_g_free0 (pname);
						_g_object_unref0 (prop_elem);
						_g_object_unref0 (child_node);
						_g_object_unref0 (_child_node_it);
						_g_error_free0 (err);
						_g_object_unref0 (serializable);
						specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						_g_object_unref0 (obj);
						_g_free0 (oid);
						_g_free0 (otype);
						_g_object_unref0 (obj_elem);
						return NULL;
					} else {
						_g_param_spec_unref0 (spec);
						G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
						_g_free0 (pname);
						_g_object_unref0 (prop_elem);
						_g_object_unref0 (child_node);
						_g_object_unref0 (_child_node_it);
						_g_error_free0 (err);
						_g_object_unref0 (serializable);
						specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						_g_object_unref0 (obj);
						_g_free0 (oid);
						_g_free0 (otype);
						_g_object_unref0 (obj_elem);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_param_spec_unref0 (spec);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				_g_free0 (pname);
				_g_object_unref0 (prop_elem);
			}
			_g_object_unref0 (child_node);
		}
		_g_object_unref0 (_child_node_it);
	}
	_tmp113_ = err;
	if (_tmp113_ != NULL) {
		GHashTable* _tmp114_;
		const gchar* _tmp115_;
		GError* _tmp116_;
		GError* _tmp117_;
		_tmp114_ = gxml_serialization_deserialize_cache;
		_tmp115_ = oid;
		g_hash_table_remove (_tmp114_, _tmp115_);
		_tmp116_ = err;
		_tmp117_ = _g_error_copy0 (_tmp116_);
		_inner_error_ = _tmp117_;
		if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			_g_object_unref0 (serializable);
			specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (obj);
			_g_free0 (oid);
			_g_free0 (otype);
			_g_object_unref0 (obj_elem);
			return NULL;
		} else {
			_g_error_free0 (err);
			_g_object_unref0 (serializable);
			specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
			_g_object_unref0 (obj);
			_g_free0 (oid);
			_g_free0 (otype);
			_g_object_unref0 (obj_elem);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = obj;
	_g_error_free0 (err);
	_g_object_unref0 (serializable);
	specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_free0 (oid);
	_g_free0 (otype);
	_g_object_unref0 (obj_elem);
	return result;
}


/**
 * Transforms a string into another type hosted by {@link GLib.Value}.
 *
 * A utility function that handles converting a string
 * representation of a value into the type specified by the
 * supplied #GValue dest.  A #GXmlSerializationError will be
 * set if the string cannot be parsed into the desired type.
 *
 * @param str the string to transform into the given #GValue object
 * @param dest the #GValue out parameter that will contain the parsed value from the string
 * @return `true` if parsing succeeded, otherwise `false`
 */
static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean uint64_try_parse (const gchar* str, guint64* _result_) {
	guint64 _vala_result = 0ULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	guint64 _tmp2_ = 0ULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoull (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean bool_try_parse (const gchar* str, gboolean* _result_) {
	gboolean _vala_result = FALSE;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		_vala_result = TRUE;
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = str;
		if (g_strcmp0 (_tmp1_, "false") == 0) {
			_vala_result = FALSE;
			result = TRUE;
			if (_result_) {
				*_result_ = _vala_result;
			}
			return result;
		} else {
			_vala_result = FALSE;
			result = FALSE;
			if (_result_) {
				*_result_ = _vala_result;
			}
			return result;
		}
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean double_try_parse (const gchar* str, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtod (_tmp0_, &_tmp1_);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


gboolean gxml_serialization_string_to_gvalue (const gchar* str, GValue* dest, GError** error) {
	gboolean result = FALSE;
	GType _tmp0_ = 0UL;
	GType t;
	GType _tmp1_;
	GValue _tmp2_ = {0};
	GValue dest2;
	gboolean ret;
	GType _tmp3_;
	gboolean _tmp80_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	_tmp0_ = G_VALUE_TYPE (dest);
	t = _tmp0_;
	_tmp1_ = t;
	g_value_init (&_tmp2_, _tmp1_);
	dest2 = _tmp2_;
	ret = FALSE;
	_tmp3_ = t;
	if (_tmp3_ == G_TYPE_INT64) {
		gint64 val = 0LL;
		const gchar* _tmp4_;
		gint64 _tmp5_ = 0LL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		_tmp4_ = str;
		_tmp6_ = int64_try_parse (_tmp4_, &_tmp5_);
		val = _tmp5_;
		ret = _tmp6_;
		_tmp7_ = ret;
		if (_tmp7_) {
			gint64 _tmp8_;
			_tmp8_ = val;
			g_value_set_int64 (&dest2, _tmp8_);
		}
	} else {
		GType _tmp9_;
		_tmp9_ = t;
		if (_tmp9_ == G_TYPE_INT) {
			gint64 val = 0LL;
			const gchar* _tmp10_;
			gint64 _tmp11_ = 0LL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_;
			_tmp10_ = str;
			_tmp12_ = int64_try_parse (_tmp10_, &_tmp11_);
			val = _tmp11_;
			ret = _tmp12_;
			_tmp13_ = ret;
			if (_tmp13_) {
				gint64 _tmp14_;
				_tmp14_ = val;
				g_value_set_int (&dest2, (gint) _tmp14_);
			}
		} else {
			GType _tmp15_;
			_tmp15_ = t;
			if (_tmp15_ == G_TYPE_LONG) {
				gint64 val = 0LL;
				const gchar* _tmp16_;
				gint64 _tmp17_ = 0LL;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_;
				_tmp16_ = str;
				_tmp18_ = int64_try_parse (_tmp16_, &_tmp17_);
				val = _tmp17_;
				ret = _tmp18_;
				_tmp19_ = ret;
				if (_tmp19_) {
					gint64 _tmp20_;
					_tmp20_ = val;
					g_value_set_long (&dest2, (glong) _tmp20_);
				}
			} else {
				GType _tmp21_;
				_tmp21_ = t;
				if (_tmp21_ == G_TYPE_UINT) {
					guint64 val = 0ULL;
					const gchar* _tmp22_;
					guint64 _tmp23_ = 0ULL;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_;
					_tmp22_ = str;
					_tmp24_ = uint64_try_parse (_tmp22_, &_tmp23_);
					val = _tmp23_;
					ret = _tmp24_;
					_tmp25_ = ret;
					if (_tmp25_) {
						guint64 _tmp26_;
						_tmp26_ = val;
						g_value_set_uint (&dest2, (guint) _tmp26_);
					}
				} else {
					GType _tmp27_;
					_tmp27_ = t;
					if (_tmp27_ == G_TYPE_ULONG) {
						guint64 val = 0ULL;
						const gchar* _tmp28_;
						guint64 _tmp29_ = 0ULL;
						gboolean _tmp30_ = FALSE;
						gboolean _tmp31_;
						_tmp28_ = str;
						_tmp30_ = uint64_try_parse (_tmp28_, &_tmp29_);
						val = _tmp29_;
						ret = _tmp30_;
						_tmp31_ = ret;
						if (_tmp31_) {
							guint64 _tmp32_;
							_tmp32_ = val;
							g_value_set_ulong (&dest2, (gulong) _tmp32_);
						}
					} else {
						GType _tmp33_;
						_tmp33_ = t;
						if (((gint) _tmp33_) == 20) {
							const gchar* _tmp34_;
							gboolean val;
							gboolean _tmp35_;
							_tmp34_ = str;
							val = g_strcmp0 (_tmp34_, "TRUE") == 0;
							_tmp35_ = val;
							g_value_set_boolean (&dest2, _tmp35_);
							ret = TRUE;
						} else {
							GType _tmp36_;
							_tmp36_ = t;
							if (_tmp36_ == G_TYPE_BOOLEAN) {
								gboolean val = FALSE;
								const gchar* _tmp37_;
								gboolean _tmp38_ = FALSE;
								gboolean _tmp39_ = FALSE;
								gboolean _tmp40_;
								_tmp37_ = str;
								_tmp39_ = bool_try_parse (_tmp37_, &_tmp38_);
								val = _tmp38_;
								ret = _tmp39_;
								_tmp40_ = ret;
								if (_tmp40_) {
									gboolean _tmp41_;
									_tmp41_ = val;
									g_value_set_boolean (&dest2, _tmp41_);
								}
							} else {
								GType _tmp42_;
								_tmp42_ = t;
								if (_tmp42_ == G_TYPE_FLOAT) {
									gdouble val = 0.0;
									const gchar* _tmp43_;
									gdouble _tmp44_ = 0.0;
									gboolean _tmp45_ = FALSE;
									gboolean _tmp46_;
									_tmp43_ = str;
									_tmp45_ = double_try_parse (_tmp43_, &_tmp44_);
									val = _tmp44_;
									ret = _tmp45_;
									_tmp46_ = ret;
									if (_tmp46_) {
										gdouble _tmp47_;
										_tmp47_ = val;
										g_value_set_float (&dest2, (gfloat) _tmp47_);
									}
								} else {
									GType _tmp48_;
									_tmp48_ = t;
									if (_tmp48_ == G_TYPE_DOUBLE) {
										gdouble val = 0.0;
										const gchar* _tmp49_;
										gdouble _tmp50_ = 0.0;
										gboolean _tmp51_ = FALSE;
										gboolean _tmp52_;
										_tmp49_ = str;
										_tmp51_ = double_try_parse (_tmp49_, &_tmp50_);
										val = _tmp50_;
										ret = _tmp51_;
										_tmp52_ = ret;
										if (_tmp52_) {
											gdouble _tmp53_;
											_tmp53_ = val;
											g_value_set_double (&dest2, _tmp53_);
										}
									} else {
										GType _tmp54_;
										_tmp54_ = t;
										if (_tmp54_ == G_TYPE_STRING) {
											const gchar* _tmp55_;
											_tmp55_ = str;
											g_value_set_string (&dest2, _tmp55_);
											ret = TRUE;
										} else {
											GType _tmp56_;
											_tmp56_ = t;
											if (_tmp56_ == G_TYPE_CHAR) {
												gint64 val = 0LL;
												const gchar* _tmp57_;
												gint64 _tmp58_ = 0LL;
												gboolean _tmp59_ = FALSE;
												gboolean _tmp60_;
												_tmp57_ = str;
												_tmp59_ = int64_try_parse (_tmp57_, &_tmp58_);
												val = _tmp58_;
												ret = _tmp59_;
												_tmp60_ = ret;
												if (_tmp60_) {
													gint64 _tmp61_;
													_tmp61_ = val;
													g_value_set_schar (&dest2, (gint8) _tmp61_);
												}
											} else {
												GType _tmp62_;
												_tmp62_ = t;
												if (_tmp62_ == G_TYPE_UCHAR) {
													gint64 val = 0LL;
													const gchar* _tmp63_;
													gint64 _tmp64_ = 0LL;
													gboolean _tmp65_ = FALSE;
													gboolean _tmp66_;
													_tmp63_ = str;
													_tmp65_ = int64_try_parse (_tmp63_, &_tmp64_);
													val = _tmp64_;
													ret = _tmp65_;
													_tmp66_ = ret;
													if (_tmp66_) {
														gint64 _tmp67_;
														_tmp67_ = val;
														g_value_set_uchar (&dest2, (guchar) _tmp67_);
													}
												} else {
													GType _tmp68_;
													_tmp68_ = t;
													if (_tmp68_ == G_TYPE_BOXED) {
													} else {
														GType _tmp69_;
														gboolean _tmp70_ = FALSE;
														_tmp69_ = t;
														_tmp70_ = G_TYPE_IS_ENUM (_tmp69_);
														if (_tmp70_) {
															gint64 val = 0LL;
															const gchar* _tmp71_;
															gint64 _tmp72_ = 0LL;
															gboolean _tmp73_ = FALSE;
															gboolean _tmp74_;
															_tmp71_ = str;
															_tmp73_ = int64_try_parse (_tmp71_, &_tmp72_);
															val = _tmp72_;
															ret = _tmp73_;
															_tmp74_ = ret;
															if (_tmp74_) {
																gint64 _tmp75_;
																_tmp75_ = val;
																g_value_set_enum (&dest2, (gint) _tmp75_);
															}
														} else {
															GType _tmp76_;
															gboolean _tmp77_ = FALSE;
															_tmp76_ = t;
															_tmp77_ = G_TYPE_IS_FLAGS (_tmp76_);
															if (_tmp77_) {
															} else {
																GType _tmp78_;
																gboolean _tmp79_ = FALSE;
																_tmp78_ = t;
																_tmp79_ = G_TYPE_IS_OBJECT (_tmp78_);
																if (_tmp79_) {
																} else {
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp80_ = ret;
	if (_tmp80_ == TRUE) {
		GValue _tmp81_;
		GValue _tmp82_ = {0};
		_tmp81_ = dest2;
		if (G_IS_VALUE (&_tmp81_)) {
			g_value_init (&_tmp82_, G_VALUE_TYPE (&_tmp81_));
			g_value_copy (&_tmp81_, &_tmp82_);
		} else {
			_tmp82_ = _tmp81_;
		}
		G_IS_VALUE (dest) ? (g_value_unset (dest), NULL) : NULL;
		*dest = _tmp82_;
		result = TRUE;
		G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
		return result;
	} else {
		GType _tmp83_;
		const gchar* _tmp84_ = NULL;
		GType _tmp85_;
		gchar* _tmp86_ = NULL;
		gchar* _tmp87_;
		GError* _tmp88_;
		GError* _tmp89_;
		_tmp83_ = t;
		_tmp84_ = g_type_name (_tmp83_);
		_tmp85_ = t;
		_tmp86_ = g_strdup_printf ("%lu", (gulong) _tmp85_);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_error_new (GXML_SERIALIZATION_ERROR, GXML_SERIALIZATION_ERROR_UNSUPPORTED_TYPE, "%s/%s", _tmp84_, _tmp87_);
		_tmp89_ = _tmp88_;
		_g_free0 (_tmp87_);
		_inner_error_ = _tmp89_;
		if (_inner_error_->domain == GXML_SERIALIZATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
			return FALSE;
		} else {
			G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
}


GXmlSerialization* gxml_serialization_construct (GType object_type) {
	GXmlSerialization * self = NULL;
	self = (GXmlSerialization*) g_object_new (object_type, NULL);
	return self;
}


GXmlSerialization* gxml_serialization_new (void) {
	return gxml_serialization_construct (GXML_TYPE_SERIALIZATION);
}


static void gxml_serialization_class_init (GXmlSerializationClass * klass) {
	gxml_serialization_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gxml_serialization_finalize;
}


static void gxml_serialization_instance_init (GXmlSerialization * self) {
}


static void gxml_serialization_finalize (GObject* obj) {
	GXmlSerialization * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZATION, GXmlSerialization);
	G_OBJECT_CLASS (gxml_serialization_parent_class)->finalize (obj);
}


/**
 * Serializes and deserializes {@link GLib.Object}s to and from
 * {@link GXml.DomNode}.
 *
 * Serialization can automatically serialize a variety of public
 * properties.  {@link GLib.Object}s can also implement the
 * {@link GXml.Serializable} to partially or completely manage
 * serialization themselves, including non-public properties or
 * data types not automatically supported by {@link GXml.Serialization}.
 */
GType gxml_serialization_get_type (void) {
	static volatile gsize gxml_serialization_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serialization_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serialization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerialization), 0, (GInstanceInitFunc) gxml_serialization_instance_init, NULL };
		GType gxml_serialization_type_id;
		gxml_serialization_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlSerialization", &g_define_type_info, 0);
		g_once_init_leave (&gxml_serialization_type_id__volatile, gxml_serialization_type_id);
	}
	return gxml_serialization_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



