/* Document.c generated by valac 0.26.1, the Vala compiler
 * generated from Document.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 0; tab-width: 2 -*- */
/* ObjectModel.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_XNODE (gxml_xnode_get_type ())
#define GXML_XNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XNODE, GXmlxNode))
#define GXML_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XNODE, GXmlxNodeClass))
#define GXML_IS_XNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XNODE))
#define GXML_IS_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XNODE))
#define GXML_XNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XNODE, GXmlxNodeClass))

typedef struct _GXmlxNode GXmlxNode;
typedef struct _GXmlxNodeClass GXmlxNodeClass;

#define GXML_TYPE_XDOCUMENT (gxml_xdocument_get_type ())
#define GXML_XDOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XDOCUMENT, GXmlxDocument))
#define GXML_XDOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XDOCUMENT, GXmlxDocumentClass))
#define GXML_IS_XDOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XDOCUMENT))
#define GXML_IS_XDOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XDOCUMENT))
#define GXML_XDOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XDOCUMENT, GXmlxDocumentClass))

typedef struct _GXmlxDocument GXmlxDocument;
typedef struct _GXmlxDocumentClass GXmlxDocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	GXML_DOCUMENT_ERROR_INVALID_DOCUMENT_ERROR,
	GXML_DOCUMENT_ERROR_INVALID_FILE
} GXmlDocumentError;
#define GXML_DOCUMENT_ERROR gxml_document_error_quark ()
struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (GXmlNamespace* self);
	const gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_childs) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	const gchar* (*get_name) (GXmlNode* self);
	const gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
};

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

typedef enum  {
	GXML_ERROR_NOT_SUPPORTED,
	GXML_ERROR_PARSER,
	GXML_ERROR_WRITER
} GXmlError;
#define GXML_ERROR gxml_error_quark ()


GQuark gxml_document_error_quark (void);
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_document_create_element (GXmlDocument* self, const gchar* name);
GXmlNode* gxml_document_create_text (GXmlDocument* self, const gchar* text);
GXmlNode* gxml_document_create_comment (GXmlDocument* self, const gchar* text);
GXmlNode* gxml_document_create_cdata (GXmlDocument* self, const gchar* text);
GXmlNode* gxml_document_create_pi (GXmlDocument* self, const gchar* target, const gchar* data);
gboolean gxml_document_save (GXmlDocument* self, GCancellable* cancellable, GError** error);
gboolean gxml_document_save_as (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
static gboolean gxml_document_real_save_as (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
void gxml_document_set_file (GXmlDocument* self, GFile* value);
GXmlDocument* gxml_document_new_default (void);
GXmlxDocument* gxml_xdocument_new (void);
GXmlxDocument* gxml_xdocument_construct (GType object_type);
GType gxml_xnode_get_type (void) G_GNUC_CONST;
GType gxml_xdocument_get_type (void) G_GNUC_CONST;
GXmlDocument* gxml_document_new_default_for_path (const gchar* path, GError** error);
GXmlDocument* gxml_document_new_default_for_file (GFile* f, GError** error);
GQuark gxml_error_quark (void);
GXmlxDocument* gxml_xdocument_new_from_path (const gchar* file_path, GError** error);
GXmlxDocument* gxml_xdocument_construct_from_path (GType object_type, const gchar* file_path, GError** error);
gboolean gxml_document_get_indent (GXmlDocument* self);
void gxml_document_set_indent (GXmlDocument* self, gboolean value);
gboolean gxml_document_get_ns_top (GXmlDocument* self);
void gxml_document_set_ns_top (GXmlDocument* self, gboolean value);
gboolean gxml_document_get_prefix_default_ns (GXmlDocument* self);
void gxml_document_set_prefix_default_ns (GXmlDocument* self, gboolean value);
GXmlNode* gxml_document_get_root (GXmlDocument* self);
GFile* gxml_document_get_file (GXmlDocument* self);


GQuark gxml_document_error_quark (void) {
	return g_quark_from_static_string ("gxml_document_error-quark");
}


/**
   * This method should create a new {@link GXml.Element}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}.
   */
GXmlNode* gxml_document_create_element (GXmlDocument* self, const gchar* name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_element (self, name);
}


/**
   * Creates a new {@link GXml.Text}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}, like a {@link GXml.Element} node.
   */
GXmlNode* gxml_document_create_text (GXmlDocument* self, const gchar* text) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_text (self, text);
}


/**
   * Creates a new {@link GXml.Comment}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}, like a {@link GXml.Element} node.
   */
GXmlNode* gxml_document_create_comment (GXmlDocument* self, const gchar* text) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_comment (self, text);
}


/**
   * Creates a new {@link GXml.CDATA}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}, like a {@link GXml.Element} node.
   */
GXmlNode* gxml_document_create_cdata (GXmlDocument* self, const gchar* text) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_cdata (self, text);
}


/**
   * Creates a new {@link GXml.ProcessingInstruction}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}, like a {@link GXml.Element} node.
   */
GXmlNode* gxml_document_create_pi (GXmlDocument* self, const gchar* target, const gchar* data) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_pi (self, target, data);
}


/**
   * Save this {@link GXml.Document} to {@link GXml.Document.file}
   *
   * If {@link GXml.Document.file} doesn't exists, it creates a new file to save to.
   */
gboolean gxml_document_save (GXmlDocument* self, GCancellable* cancellable, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->save (self, cancellable, error);
}


/**
   * Save this {@link GXml.Document} to given {@link GLib.File}
   *
   * This overrides actual {@link GXml.Document.file}
   */
static gboolean gxml_document_real_save_as (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (f != NULL, FALSE);
	_tmp0_ = f;
	gxml_document_set_file (self, _tmp0_);
	_tmp1_ = cancellable;
	gxml_document_save (self, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


gboolean gxml_document_save_as (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->save_as (self, f, cancellable, error);
}


/**
   * Creates a new {@link GXml.Document} using default implementation class.
   *
   * As an interface you can create your own implementation of it, but if 
   * default one is required use this.
   */
GXmlDocument* gxml_document_new_default (void) {
	GXmlDocument* result = NULL;
	GXmlxDocument* _tmp0_ = NULL;
	_tmp0_ = gxml_xdocument_new ();
	result = (GXmlDocument*) _tmp0_;
	return result;
}


/**
   * Creates a new {@link GXml.Document} from a file path using default implementation class.
   *
   * As an interface you can create your own implementation of it, but if 
   * default one is required use this.
   */
GXmlDocument* gxml_document_new_default_for_path (const gchar* path, GError** error) {
	GXmlDocument* result = NULL;
	GFile* f = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GXmlDocument* _tmp2_ = NULL;
	GXmlDocument* _tmp3_ = NULL;
	GXmlDocument* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	f = _tmp1_;
	_tmp3_ = gxml_document_new_default_for_file (f, &_inner_error_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (f);
		return NULL;
	}
	_tmp4_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (f);
	return result;
}


/**
   * Creates a new {@link GXml.Document} from a {@link GLib.File} using default implementation class.
   *
   * As an interface you can create your own implementation of it, but if 
   * default one is required use this.
   */
GXmlDocument* gxml_document_new_default_for_file (GFile* f, GError** error) {
	GXmlDocument* result = NULL;
	GXmlxDocument* d = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GXmlxDocument* _tmp3_ = NULL;
	GXmlxDocument* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GXmlxDocument* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (f != NULL, NULL);
	_tmp0_ = f;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gxml_xdocument_new_from_path (_tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	d = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp5_ = f;
	_tmp6_ = g_file_query_exists (_tmp5_, NULL);
	if (!_tmp6_) {
		GError* _tmp7_ = NULL;
		_tmp7_ = g_error_new_literal (GXML_DOCUMENT_ERROR, GXML_DOCUMENT_ERROR_INVALID_FILE, "Invalid file");
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (d);
		return NULL;
	}
	_tmp8_ = d;
	_tmp9_ = f;
	gxml_document_set_file ((GXmlDocument*) _tmp8_, _tmp9_);
	result = (GXmlDocument*) d;
	return result;
}


gboolean gxml_document_get_indent (GXmlDocument* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_indent (self);
}


void gxml_document_set_indent (GXmlDocument* self, gboolean value) {
	g_return_if_fail (self != NULL);
	GXML_DOCUMENT_GET_INTERFACE (self)->set_indent (self, value);
}


gboolean gxml_document_get_ns_top (GXmlDocument* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_ns_top (self);
}


void gxml_document_set_ns_top (GXmlDocument* self, gboolean value) {
	g_return_if_fail (self != NULL);
	GXML_DOCUMENT_GET_INTERFACE (self)->set_ns_top (self, value);
}


gboolean gxml_document_get_prefix_default_ns (GXmlDocument* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_prefix_default_ns (self);
}


void gxml_document_set_prefix_default_ns (GXmlDocument* self, gboolean value) {
	g_return_if_fail (self != NULL);
	GXML_DOCUMENT_GET_INTERFACE (self)->set_prefix_default_ns (self, value);
}


GXmlNode* gxml_document_get_root (GXmlDocument* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_root (self);
}


GFile* gxml_document_get_file (GXmlDocument* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_file (self);
}


void gxml_document_set_file (GXmlDocument* self, GFile* value) {
	g_return_if_fail (self != NULL);
	GXML_DOCUMENT_GET_INTERFACE (self)->set_file (self, value);
}


static void gxml_document_base_init (GXmlDocumentIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * Controls if writting this documents should use indent.
		   */
		g_object_interface_install_property (iface, g_param_spec_boolean ("indent", "indent", "indent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * Controls if writting this documentsshould use namespaces
		   * declaration at root {@link GXml.Element}.
		   *
		   * This removes full declaration at childs nodes, because they
		   * are just prefixed if a prefix was defined for namespace apply.
		   */
		g_object_interface_install_property (iface, g_param_spec_boolean ("ns-top", "ns-top", "ns-top", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * Controls if writting this document should use default namespace's prefix
		   * to prefix root's childs {@link GXml.Element}.
		   *
		   * This removes prefix on childs using default namespace. Default namespace
		   * is the first one found in {@link GXml.Node.namespaces} for this document.
		   */
		g_object_interface_install_property (iface, g_param_spec_boolean ("prefix-default-ns", "prefix-default-ns", "prefix-default-ns", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * XML document root node as a {@link GXml.Element}.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("root", "root", "root", GXML_TYPE_NODE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Stores a {@link GLib.File} to save/read XML documents to/from.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("file", "file", "file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->save_as = gxml_document_real_save_as;
	}
}


/**
 * Interface to handle XML documents.
 *
 * Provides basic interfaces to read and create XML documents.
 */
GType gxml_document_get_type (void) {
	static volatile gsize gxml_document_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDocumentIface), (GBaseInitFunc) gxml_document_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_document_type_id;
		gxml_document_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlDocument", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_document_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gxml_document_type_id, GXML_TYPE_NODE);
		g_once_init_leave (&gxml_document_type_id__volatile, gxml_document_type_id);
	}
	return gxml_document_type_id__volatile;
}



