/* libxml-NodeList.c generated by valac 0.26.1, the Vala compiler
 * generated from libxml-NodeList.vala, do not modify */

/* NodeList.vala
 *
 * Copyright (C) 2011-2013  Richard Schwarting <aquarichy@gmail.com>
 * Copyright (C) 2013-2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authors:
 *      Richard Schwarting <aquarichy@gmail.com>
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GXML_TYPE_NODE_LIST (gxml_node_list_get_type ())
#define GXML_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE_LIST, GXmlNodeList))
#define GXML_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE_LIST))
#define GXML_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE_LIST, GXmlNodeListIface))

typedef struct _GXmlNodeList GXmlNodeList;
typedef struct _GXmlNodeListIface GXmlNodeListIface;

#define GXML_TYPE_XNODE (gxml_xnode_get_type ())
#define GXML_XNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XNODE, GXmlxNode))
#define GXML_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XNODE, GXmlxNodeClass))
#define GXML_IS_XNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XNODE))
#define GXML_IS_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XNODE))
#define GXML_XNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XNODE, GXmlxNodeClass))

typedef struct _GXmlxNode GXmlxNode;
typedef struct _GXmlxNodeClass GXmlxNodeClass;

struct _GXmlNodeListIface {
	GTypeInterface parent_iface;
	GXmlxNode* (*item) (GXmlNodeList* self, gulong idx);
	GXmlxNode* (*insert_before) (GXmlNodeList* self, GXmlxNode* new_child, GXmlxNode* ref_child);
	GXmlxNode* (*replace_child) (GXmlNodeList* self, GXmlxNode* new_child, GXmlxNode* old_child);
	GXmlxNode* (*remove_child) (GXmlNodeList* self, GXmlxNode* old_child);
	GXmlxNode* (*append_child) (GXmlNodeList* self, GXmlxNode* new_child);
	gchar* (*to_string) (GXmlNodeList* self, gboolean in_line);
	GXmlxNode* (*first) (GXmlNodeList* self);
	GXmlxNode* (*last) (GXmlNodeList* self);
	GXmlxNode* (*get) (GXmlNodeList* self, gint n);
	gulong (*get_length) (GXmlNodeList* self);
	void (*set_length) (GXmlNodeList* self, gulong value);
};



GType gxml_xnode_get_type (void) G_GNUC_CONST;
GType gxml_node_list_get_type (void) G_GNUC_CONST;
GXmlxNode* gxml_node_list_item (GXmlNodeList* self, gulong idx);
GXmlxNode* gxml_node_list_insert_before (GXmlNodeList* self, GXmlxNode* new_child, GXmlxNode* ref_child);
GXmlxNode* gxml_node_list_replace_child (GXmlNodeList* self, GXmlxNode* new_child, GXmlxNode* old_child);
GXmlxNode* gxml_node_list_remove_child (GXmlNodeList* self, GXmlxNode* old_child);
GXmlxNode* gxml_node_list_append_child (GXmlNodeList* self, GXmlxNode* new_child);
gchar* gxml_node_list_to_string (GXmlNodeList* self, gboolean in_line);
GXmlxNode* gxml_node_list_first (GXmlNodeList* self);
GXmlxNode* gxml_node_list_last (GXmlNodeList* self);
GXmlxNode* gxml_node_list_get (GXmlNodeList* self, gint n);
gulong gxml_node_list_get_length (GXmlNodeList* self);
void gxml_node_list_set_length (GXmlNodeList* self, gulong value);


/**
 * Access the idx'th item in the list.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#method-item]]
 */
GXmlxNode* gxml_node_list_item (GXmlNodeList* self, gulong idx) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->item (self, idx);
}


GXmlxNode* gxml_node_list_insert_before (GXmlNodeList* self, GXmlxNode* new_child, GXmlxNode* ref_child) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->insert_before (self, new_child, ref_child);
}


GXmlxNode* gxml_node_list_replace_child (GXmlNodeList* self, GXmlxNode* new_child, GXmlxNode* old_child) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->replace_child (self, new_child, old_child);
}


GXmlxNode* gxml_node_list_remove_child (GXmlNodeList* self, GXmlxNode* old_child) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->remove_child (self, old_child);
}


GXmlxNode* gxml_node_list_append_child (GXmlNodeList* self, GXmlxNode* new_child) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->append_child (self, new_child);
}


/**
 * Creates an XML string representation of the nodes in the list.
 *
 * #todo: write a test
 *
 * @param in_line Whether to parse and expand entities or not
 *
 * @return The list as an XML string
 */
gchar* gxml_node_list_to_string (GXmlNodeList* self, gboolean in_line) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->to_string (self, in_line);
}


/**
 * Retrieve the first node in the list.  Like {@link GLib.List.first}.
 */
GXmlxNode* gxml_node_list_first (GXmlNodeList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->first (self);
}


/**
 * Retrieve the last node in the list.  Like {@link GLib.List.last}.
 */
GXmlxNode* gxml_node_list_last (GXmlNodeList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->last (self);
}


/**
 * Obtain the n'th item in the list. Like {@link GLib.List.nth}.
 *
 * @param n The index of the item to access
 */
GXmlxNode* gxml_node_list_get (GXmlNodeList* self, gint n) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->get (self, n);
}


gulong gxml_node_list_get_length (GXmlNodeList* self) {
	g_return_val_if_fail (self != NULL, 0UL);
	return GXML_NODE_LIST_GET_INTERFACE (self)->get_length (self);
}


void gxml_node_list_set_length (GXmlNodeList* self, gulong value) {
	g_return_if_fail (self != NULL);
	GXML_NODE_LIST_GET_INTERFACE (self)->set_length (self, value);
}


static void gxml_node_list_base_init (GXmlNodeListIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		 * The number of nodes contained within this list
		 *
		 * Version: DOM Level 1 Core<<BR>>
		 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#attribute-length]]
		 */
		g_object_interface_install_property (iface, g_param_spec_ulong ("length", "length", "length", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * DOM API. Interface to access a list of nodes.
   *
   * A live list used to store {@link GXml.xNode}s.
 *
 * Usually contains the children of a {@link GXml.xNode}, or
 * the results of {@link GXml.Element.get_elements_by_tag_name}.
 * {@link GXml.NodeList} implements both the DOM Level 1 Core API for
 * a NodeList, as well as the {@link GLib.List} API, to make
 * it more accessible and familiar to GLib programmers.
 * Implementing classes also implement {@link Gee.Iterable}, to make
 * iteration in supporting languages (like Vala) nice and
 * easy.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-536297177]]
 */
GType gxml_node_list_get_type (void) {
	static volatile gsize gxml_node_list_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_node_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlNodeListIface), (GBaseInitFunc) gxml_node_list_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_node_list_type_id;
		gxml_node_list_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlNodeList", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_node_list_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gxml_node_list_type_id, GEE_TYPE_ITERABLE);
		g_type_interface_add_prerequisite (gxml_node_list_type_id, GEE_TYPE_COLLECTION);
		g_once_init_leave (&gxml_node_list_type_id__volatile, gxml_node_list_type_id);
	}
	return gxml_node_list_type_id__volatile;
}



