/* SerializableProperty.c generated by valac 0.28.1, the Vala compiler
 * generated from SerializableProperty.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/* SerializableProperty.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_SERIALIZABLE_PROPERTY (gxml_serializable_property_get_type ())
#define GXML_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty))
#define GXML_IS_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY))
#define GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializablePropertyIface))

typedef struct _GXmlSerializableProperty GXmlSerializableProperty;
typedef struct _GXmlSerializablePropertyIface GXmlSerializablePropertyIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;

#define GXML_TYPE_ATTRIBUTE (gxml_attribute_get_type ())
#define GXML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttribute))
#define GXML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTRIBUTE))
#define GXML_ATTRIBUTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttributeIface))

typedef struct _GXmlAttribute GXmlAttribute;
typedef struct _GXmlAttributeIface GXmlAttributeIface;

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (GXmlNamespace* self);
	const gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_childs) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	const gchar* (*get_name) (GXmlNode* self);
	const gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
};

struct _GXmlSerializablePropertyIface {
	GTypeInterface parent_iface;
	gchar* (*get_serializable_property_value) (GXmlSerializableProperty* self);
	void (*set_serializable_property_value) (GXmlSerializableProperty* self, const gchar* val);
	gboolean (*deserialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*finalize_attr) (GXmlElement* self);
	const gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

struct _GXmlAttributeIface {
	GTypeInterface parent_iface;
};



GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_serializable_property_get_type (void) G_GNUC_CONST;
gchar* gxml_serializable_property_get_serializable_property_value (GXmlSerializableProperty* self);
void gxml_serializable_property_set_serializable_property_value (GXmlSerializableProperty* self, const gchar* val);
gboolean gxml_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
static gboolean gxml_serializable_property_real_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
gboolean gxml_serializable_property_default_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
GXmlNode* gxml_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
static GXmlNode* gxml_serializable_property_real_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
GXmlNode* gxml_serializable_property_default_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* element, GParamSpec* prop, gboolean nick, GError** error);
GType gxml_element_get_type (void) G_GNUC_CONST;
void gxml_element_set_attr (GXmlElement* self, const gchar* name, const gchar* value);
GType gxml_attribute_get_type (void) G_GNUC_CONST;
const gchar* gxml_node_get_name (GXmlNode* self);
const gchar* gxml_node_get_value (GXmlNode* self);


/**
  * Value to be set to a {@link GXml.Attribute}, to be added to a {@link GXml.Element}
  */
gchar* gxml_serializable_property_get_serializable_property_value (GXmlSerializableProperty* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->get_serializable_property_value (self);
}


/**
  * Set value to be set to a {@link GXml.Attribute}, to be added to a {@link GXml.Element}
  *
  * If value is set to @null then the property will be ignored by default and no
  * property will be set to given {@link GXml.Element}.
  *
  * Some implementations stores the value without any convertion at all; then if the value,
  * from XML property, makes no sense for the property type, you should take care
  * to use the provided API from them to convert it.
  */
void gxml_serializable_property_set_serializable_property_value (GXmlSerializableProperty* self, const gchar* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->set_serializable_property_value (self, val);
}


/**
   * Tryies to deserialize from a {@link GXml.Node} searching a {@link GXml.Attribute}
   * with the name provided in @param prop or its nick if @nick is true,
   * if not set, then {@link GLib.ParamSpec} name should used. If @param nick is set to true,
   * then {@link GLib.ParamSpec} nick is used as name.
   */
static gboolean gxml_serializable_property_real_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GXmlNode* _tmp1_ = NULL;
	GParamSpec* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (property_node != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	_tmp1_ = property_node;
	_tmp2_ = prop;
	_tmp3_ = nick;
	_tmp4_ = gxml_serializable_property_default_serializable_property_deserialize_property (self, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean gxml_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->deserialize_property (self, property_node, prop, nick, error);
}


/**
   * Serialization method to add a {@link GXml.Attribute} to a {@link GXml.Element}, using {@link GLib.ParamSpec}
   * name or nick, if @param nick is set to true, as the attribute's name.
   *
   * If {@link GXml.SerializableProperty.get_serializable_property_value} returns null
   * given {@link GXml.Node} should not be modified.
   */
static GXmlNode* gxml_serializable_property_real_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	GXmlNode* result = NULL;
	GXmlNode* _tmp0_ = NULL;
	GXmlNode* _tmp1_ = NULL;
	GParamSpec* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GXmlNode* _tmp4_ = NULL;
	GXmlNode* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (property_node != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = property_node;
	_tmp2_ = prop;
	_tmp3_ = nick;
	_tmp4_ = gxml_serializable_property_default_serializable_property_serialize_property (self, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}


GXmlNode* gxml_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->serialize_property (self, property_node, prop, nick, error);
}


/**
   * Default serialization method to add a {@link GXml.Attribute} to a {@link GXml.Element}
   *
   * If {@link GXml.SerializableProperty.get_serializable_property_value} returns null
   * given {@link GXml.Node} is not modified.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


GXmlNode* gxml_serializable_property_default_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* element, GParamSpec* prop, gboolean nick, GError** error) {
	GXmlNode* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* name = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GXmlNode* _tmp33_ = NULL;
	GXmlNode* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	GXmlNode* _tmp41_ = NULL;
	GXmlNode* _tmp42_ = NULL;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = gxml_serializable_property_get_serializable_property_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		GXmlNode* _tmp3_ = NULL;
		GXmlNode* _tmp4_ = NULL;
		_tmp3_ = element;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup ("");
	name = _tmp5_;
	_tmp6_ = nick;
	_tmp7_ = bool_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("Use nick: ", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	g_test_message ("%s", _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp13_ = nick;
	if (_tmp13_) {
		GParamSpec* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = prop;
		_tmp15_ = g_param_spec_get_nick (_tmp14_);
		_tmp12_ = _tmp15_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GParamSpec* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = prop;
		_tmp17_ = g_param_spec_get_nick (_tmp16_);
		_tmp11_ = g_strcmp0 (_tmp17_, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GParamSpec* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp18_ = prop;
		_tmp19_ = g_param_spec_get_nick (_tmp18_);
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (name);
		name = _tmp20_;
	} else {
		GParamSpec* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp21_ = prop;
		_tmp22_ = g_param_spec_get_name (_tmp21_);
		_tmp23_ = g_strdup (_tmp22_);
		_g_free0 (name);
		name = _tmp23_;
	}
	_tmp24_ = name;
	_tmp25_ = g_strconcat ("Property to set:", _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat (_tmp26_, " - with value: ", NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = gxml_serializable_property_get_serializable_property_value (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	g_test_message ("%s", _tmp32_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp33_ = element;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, GXML_TYPE_ELEMENT)) {
		const gchar* _tmp34_ = NULL;
		GXmlNode* _tmp35_ = NULL;
		GXmlNode* _tmp36_ = NULL;
		_tmp34_ = _ ("Trying to serialize to a non GXmlElement!");
		g_warning ("SerializableProperty.vala:93: %s", _tmp34_);
		_tmp35_ = element;
		_tmp36_ = _g_object_ref0 (_tmp35_);
		result = _tmp36_;
		_g_free0 (name);
		return result;
	}
	_tmp37_ = element;
	_tmp38_ = name;
	_tmp39_ = gxml_serializable_property_get_serializable_property_value (self);
	_tmp40_ = _tmp39_;
	gxml_element_set_attr (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GXML_TYPE_ELEMENT, GXmlElement), _tmp38_, _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = element;
	_tmp42_ = _g_object_ref0 (_tmp41_);
	result = _tmp42_;
	_g_free0 (name);
	return result;
}


/**
   * Tryies to deserialize from a {@link GXml.Node} searching a {@link GXml.Attribute}
   * with the name in @param prop or from its nick if @nick is true.
   */
gboolean gxml_serializable_property_default_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	gboolean result = FALSE;
	GXmlAttribute* attr = NULL;
	GXmlNode* _tmp0_ = NULL;
	GXmlAttribute* _tmp3_ = NULL;
	GXmlAttribute* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* name = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	GXmlAttribute* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	g_return_val_if_fail (property_node != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	attr = NULL;
	_tmp0_ = property_node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_ATTRIBUTE)) {
		GXmlNode* _tmp1_ = NULL;
		GXmlAttribute* _tmp2_ = NULL;
		_tmp1_ = property_node;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GXML_TYPE_ATTRIBUTE, GXmlAttribute));
		_g_object_unref0 (attr);
		attr = _tmp2_;
	}
	_tmp3_ = attr;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (attr);
		return result;
	}
	_tmp4_ = attr;
	_tmp5_ = gxml_node_get_name ((GXmlNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		GType _tmp7_ = 0UL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp7_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp8_ = g_type_name (_tmp7_);
		_tmp9_ = g_strconcat ("XML Attribute name is not set, when deserializing to: ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		g_warning ("SerializableProperty.vala:117: %s", _tmp10_);
		_g_free0 (_tmp10_);
		result = FALSE;
		_g_object_unref0 (attr);
		return result;
	}
	_tmp11_ = g_strdup ("");
	name = _tmp11_;
	_tmp14_ = nick;
	if (_tmp14_) {
		GParamSpec* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp15_ = prop;
		_tmp16_ = g_param_spec_get_nick (_tmp15_);
		_tmp13_ = _tmp16_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GParamSpec* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = prop;
		_tmp18_ = g_param_spec_get_nick (_tmp17_);
		_tmp12_ = g_strcmp0 (_tmp18_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GParamSpec* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp19_ = prop;
		_tmp20_ = g_param_spec_get_nick (_tmp19_);
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (name);
		name = _tmp21_;
	} else {
		GParamSpec* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp22_ = prop;
		_tmp23_ = g_param_spec_get_name (_tmp22_);
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (name);
		name = _tmp24_;
	}
	_tmp25_ = attr;
	_tmp26_ = gxml_node_get_name ((GXmlNode*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_utf8_strdown (_tmp27_, (gssize) (-1));
	_tmp29_ = _tmp28_;
	_tmp30_ = name;
	_tmp31_ = g_utf8_strdown (_tmp30_, (gssize) (-1));
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strcmp0 (_tmp29_, _tmp32_) == 0;
	_g_free0 (_tmp32_);
	_g_free0 (_tmp29_);
	if (_tmp33_) {
		GXmlAttribute* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		_tmp34_ = attr;
		_tmp35_ = gxml_node_get_value ((GXmlNode*) _tmp34_);
		_tmp36_ = _tmp35_;
		gxml_serializable_property_set_serializable_property_value (self, _tmp36_);
	}
	result = TRUE;
	_g_free0 (name);
	_g_object_unref0 (attr);
	return result;
}


static void gxml_serializable_property_base_init (GXmlSerializablePropertyIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		iface->deserialize_property = gxml_serializable_property_real_deserialize_property;
		iface->serialize_property = gxml_serializable_property_real_serialize_property;
	}
}


/**
 * Represent any property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}
 *
 * The actual value stored and returned by {@link GXml.SerializableProperty.get_serializable_property_value}
 * is the actual string in the XML property, this means may the value could differ from the spected value
 * on some implementations like {@link GXml.SerializableInt}. Take a look in each implementations about
 * retured values.
 *
 * Implementations of {@link GXml.SerializableProperty}, could be used to provide more flexibility
 * when parsing {@link GXml.Attribute} properties values and to exclude to be serialized if they have not
 * been created in the holding objects.
 */
GType gxml_serializable_property_get_type (void) {
	static volatile gsize gxml_serializable_property_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_property_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializablePropertyIface), (GBaseInitFunc) gxml_serializable_property_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_serializable_property_type_id;
		gxml_serializable_property_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlSerializableProperty", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_serializable_property_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_serializable_property_type_id__volatile, gxml_serializable_property_type_id);
	}
	return gxml_serializable_property_type_id__volatile;
}



