/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003 Richard Hult <richard@imendio.com>
 * Copyright (C) 2003 Johan Dahlin <jdahlin@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PLAY_LIST_VIEW_H__
#define __PLAY_LIST_VIEW_H__

#include "playlist.h"
#include "song-db.h"
#include <gtk/gtktreeview.h>

#define TYPE_PLAY_LIST_VIEW            (play_list_view_get_type ())
#define PLAY_LIST_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAY_LIST_VIEW, PlayListView))
#define PLAY_LIST_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAY_LIST_VIEW, PlayListViewClass))
#define IS_PLAY_LIST_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAY_LIST_VIEW))
#define IS_PLAY_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAY_LIST_VIEW))
#define PLAY_LIST_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAY_LIST_VIEW, PlayListViewClass))

typedef struct _PlayListView      PlayListView;
typedef struct _PlayListViewClass PlayListViewClass;

struct _PlayListView
{
  GtkTreeView parent;
  SongDB           *db;
  GtkCellRenderer  *cell;
  GtkTreeModel     *model;
  GtkTreeSelection *selection;
};

struct _PlayListViewClass
{
  GtkTreeViewClass parent_class;
};

GType           play_list_view_get_type       (void);
GtkWidget *     play_list_view_new            (SongDB       *db);
Playlist *      play_list_view_get_playlist   (PlayListView *view);

/* XXX: Make private */
void            play_list_view_restore_prefs  (PlayListView *view);
void            play_list_view_store_prefs    (PlayListView *view);

#endif /* __PLAY_LIST_VIEW_H__ */
