/*
 * Copyright © 2007-2008  Emmanuel Pacaud
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Emmanuel Pacaud <emmanuel@gnome.org>
 */

#include <lsmmathmlaligngroupelement.h>
#include <lsmmathmlview.h>

static GObjectClass *parent_class;

/* GdomNode implementation */

static const char *
lsm_mathml_align_group_get_node_name (LsmDomNode *node)
{
	return "maligngroup";
}

static gboolean
lsm_mathml_align_group_element_can_append_child (LsmDomNode *self, LsmDomNode *child)
{
	return FALSE;
}

/* LsmMathmlElement implementation */

static void
lsm_mathml_align_group_element_update (LsmMathmlElement *self, LsmMathmlStyle *style)
{
}

static const LsmMathmlBbox *
lsm_mathml_align_group_element_measure (LsmMathmlElement *self, LsmMathmlView *view, const LsmMathmlBbox *bbox)
{
	self->bbox = lsm_mathml_bbox_null;

	return &self->bbox;
}

static void
lsm_mathml_align_group_element_layout (LsmMathmlElement *self, LsmMathmlView *view,
				   double x, double y, const LsmMathmlBbox *bbox)
{
}

static void
lsm_mathml_align_group_element_render (LsmMathmlElement *element, LsmMathmlView *view)
{
}

/* LsmMathmlAlignGroupElement implementation */

LsmDomNode *
lsm_mathml_align_group_element_new (void)
{
	return g_object_new (LSM_TYPE_MATHML_ALIGN_GROUP_ELEMENT, NULL);
}

static void
lsm_mathml_align_group_element_init (LsmMathmlAlignGroupElement *self)
{
}

/* LsmMathmlAlignGroupElement class */

static void
lsm_mathml_align_group_element_class_init (LsmMathmlAlignGroupElementClass *align_group_class)
{
	LsmDomNodeClass *d_node_class = LSM_DOM_NODE_CLASS (align_group_class);
	LsmMathmlElementClass *m_element_class = LSM_MATHML_ELEMENT_CLASS (align_group_class);

	parent_class = g_type_class_peek_parent (align_group_class);

	d_node_class->get_node_name = lsm_mathml_align_group_get_node_name;
	d_node_class->can_append_child = lsm_mathml_align_group_element_can_append_child;

	m_element_class->update = lsm_mathml_align_group_element_update;
	m_element_class->measure = lsm_mathml_align_group_element_measure;
	m_element_class->layout = lsm_mathml_align_group_element_layout;
	m_element_class->render = lsm_mathml_align_group_element_render;
	m_element_class->is_inferred_row = NULL;
}

G_DEFINE_TYPE (LsmMathmlAlignGroupElement, lsm_mathml_align_group_element, LSM_TYPE_MATHML_ELEMENT)
