/* This file is part of memoranda
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2006  Sven Herzberg <herzi@gnome-de.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef MEMORANDA_HASH_MAP_H
#define MEMORANDA_HASH_MAP_H

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _MemorandaHashMap      MemorandaHashMap;
typedef struct _MemorandaHashMapClass MemorandaHashMapClass;
typedef struct _MemorandaHashMap      CcHashMap;

#define MEMORANDA_TYPE_HASH_MAP         (memoranda_hash_map_get_type())
#define MEMORANDA_HASH_MAP(i)           (G_TYPE_CHECK_INSTANCE_CAST((i), MEMORANDA_TYPE_HASH_MAP, MemorandaHashMap))
#define MEMORANDA_HASH_MAP_CLASS(c)     (G_TYPE_CHECK_CLASS_CAST((c), MEMORANDA_TYPE_HASH_MAP, MemorandaHashMapClass))
#define MEMORANDA_IS_HASH_MAP(i)        (G_TYPE_CHECK_INSTANCE_TYPE((i), MEMORANDA_TYPE_HASH_MAP))
#define MEMORANDA_IS_HASH_MAP_CLASS(c)  (G_TYPE_CHECK_CLASS_TYPE((c), MEMORANDA_TYPE_HASH_MAP))
#define MEMORANDA_HASH_MAP_GET_CLASS(i) (G_TYPE_INSTANCE_GET_CLASS((i), MEMORANDA_TYPE_HASH_MAP, MemorandaHashMapClass))
#define CC_IS_HASH_MAP(i)         MEMORANDA_IS_HASH_MAP(i)

GType memoranda_hash_map_get_type(void);

CcHashMap* cc_hash_map_new   (GType content_type);
void              cc_hash_map_insert(MemorandaHashMap* self,
					    gpointer          key,
					    gpointer          data);
gpointer          cc_hash_map_lookup(CcHashMap    * self,
				     gconstpointer  key);
void              cc_hash_map_remove(MemorandaHashMap* self,
					    gconstpointer     key);
void              cc_hash_map_foreach(CcHashMap* self,
				      GHFunc     func,
				      gpointer   user_data);

struct _MemorandaHashMap {
	GObject     base_instance;
	GType       fundamental;
	GType       content;
	GHashTable* hash_table;
};

struct _MemorandaHashMapClass {
	GObjectClass base_class;
};

G_END_DECLS

#endif /* !MEMORANDA_HASH_MAP_H */
