/* libcm - A library with a xlib wrapper and a gl based scene graph
 * Copyright (C) 2005, 2006  Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 * Author: Soren Sandmann (sandmann@redhat.com)
 */
#include "node.h"

#ifndef CM_STACKER_H
#define CM_STACKER_H

#define CM_TYPE_STACKER            (cm_stacker_get_type ())
#define CM_STACKER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), CM_TYPE_STACKER, CmStacker))
#define CM_STACKER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  CM_TYPE_STACKER, CmStackerClass))
#define CM_IS_STACKER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CM_TYPE_STACKER))
#define CM_IS_STACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  CM_TYPE_STACKER))
#define CM_STACKER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  CM_TYPE_STACKER, CmStackerClass))

typedef struct _CmStacker CmStacker;
typedef struct _CmStackerClass CmStackerClass;

struct _CmStacker
{
    CmNode parent_instance;

    GList *	children;
};

struct _CmStackerClass
{
    CmNodeClass parent_class;
};

GType cm_stacker_get_type (void);

CmStacker * cm_stacker_new (void);
void	    cm_stacker_add_child (CmStacker *stacker,
				  CmNode *child);
void	    cm_stacker_remove_child (CmStacker *stacker,
				     CmNode    *child);

void	    cm_stacker_restack_child (CmStacker *stacker,
				      CmNode *child,
				      CmNode *below_this);
void	    cm_stacker_lower_child (CmStacker *stacker,
				    CmNode *child);
void        cm_stacker_raise_child (CmStacker *stacker,
				    CmNode *child);

#endif

