// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_DATASELECTOR_H
#define _LIBGDA_UIMM_DATASELECTOR_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2010 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgda-ui/gdaui-data-selector.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiDataSelector GdauiDataSelector;
typedef struct _GdauiDataSelectorClass GdauiDataSelectorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class DataSelector_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gnome
{

// Gnome::Gda class forward declarations.
namespace Gda
{

class DataModel;
class DataModelIter;

}

namespace GdaUI
{

/** DataSelector - Selecting data in a Gnome::Gda::DataModel.
 * The DataSelector interface is implemented by widgets which allow the user
 * to select some data from a Gnome::Gda::DataModel. Depending on the actual
 * widget, the selection can be a single row or more than one row.
 *
 * This interface allows one to set and get the Gnome::Gda::DataModel from
 * which data is to be selected and offers a few other common behaviours.
 *
 * Please note that any row number in this interface is in reference to the
 * Gnome::Gda::DataModel returned by the get_model() method.
 */

class DataSelector :
  public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataSelector CppObjectType;
  typedef DataSelector_Class CppClassType;
  typedef GdauiDataSelector BaseObjectType;
  typedef GdauiDataSelectorIface BaseClassType;

private:
  friend class DataSelector_Class;
  static CppClassType dataselector_class_;

  // noncopyable
  DataSelector(const DataSelector&);
  DataSelector& operator=(const DataSelector&);

protected:
  DataSelector(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit DataSelector(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit DataSelector(GdauiDataSelector* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataSelector();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdauiDataSelector*       gobj()       { return reinterpret_cast<GdauiDataSelector*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GdauiDataSelector* gobj() const { return reinterpret_cast<GdauiDataSelector*>(gobject_); }

private:


public:
  
  /** Queries the Gda::DataModel from which the data displayed by the widget implementing @a iface
   * are. Beware that the returned data model may be different than the one used when the
   * widget was created in case it uses a Gda::DataProxy.
   * @return The Gda::DataModel
   * 
   * @newin{4,2}.
   */
  Glib::RefPtr<Gnome::Gda::DataModel> get_model();
  
  /** Queries the Gda::DataModel from which the data displayed by the widget implementing @a iface
   * are. Beware that the returned data model may be different than the one used when the
   * widget was created in case it uses a Gda::DataProxy.
   * @return The Gda::DataModel
   * 
   * @newin{4,2}.
   */
  Glib::RefPtr<const Gnome::Gda::DataModel> get_model() const;
  
  /** Sets the data model from which the data being displayed are. Also see get_model()
   * 
   * @newin{4,2}
   * @param model A Gda::DataModel to use.
   */
  void set_model(const Glib::RefPtr<Gnome::Gda::DataModel>& model);

//TODO: Docs say that the GArray* should be freed after use.  Freeing the underlying data is possible with Glib::ArrayHandle<> but how should the GArray* be freed?
//#m4 __CONVERSION(`GArray*', `Glib::ArrayHandle<int>', `$2($3->data, $3->len, Glib::OWNERSHIP_DEEEP)')
  //_WRAP_METHOD(Glib::ArrayHandle<int> get_selected_rows() const, gdaui_data_selector_get_selected_rows)

  
  /** Get the Gda::DataModelIter object represented the current selected row in @a iface. This
   * function may return either <tt>0</tt> or an invalid iterator (see gda_data_model_iter_is_valid()) if
   * the selection cannot be represented by a single selected row.
   * 
   * Note that the returned Gda::DataModelIter is actually an iterator iterating on the Gda::DataModel
   * returned by the get_model() method.
   * @return A pointer to a Gda::DataModelIter object, or <tt>0</tt>
   * 
   * @newin{4,2}.
   */
  Glib::RefPtr<Gnome::Gda::DataModelIter> get_data_set();
  
  /** Get the Gda::DataModelIter object represented the current selected row in @a iface. This
   * function may return either <tt>0</tt> or an invalid iterator (see gda_data_model_iter_is_valid()) if
   * the selection cannot be represented by a single selected row.
   * 
   * Note that the returned Gda::DataModelIter is actually an iterator iterating on the Gda::DataModel
   * returned by the get_model() method.
   * @return A pointer to a Gda::DataModelIter object, or <tt>0</tt>
   * 
   * @newin{4,2}.
   */
  Glib::RefPtr<const Gnome::Gda::DataModelIter> get_data_set() const;
  
  /** Force the selection of a specific row.
   * 
   * Please note that @a row refers to the "visible" row
   * at the time it's being called, which may change if the widget implementing this interface
   * uses a Gda::DataProxy (as is the case for example for the Gdaui::RawForm, Gdaui::Form, Gdaui::RawGrid
   * and Gdaui::Grid).
   * @param row The row to select.
   * @return <tt>true</tt> if the row has been selected
   * 
   * @newin{4,2}.
   */
  bool select_row(int row);
  
  /** Please note that @a row refers to the "visible" row
   * at the time it's being called, which may change if the widget implementing this interface
   * uses a Gda::DataProxy (as is the case for example for the Gdaui::RawForm, Gdaui::Form, Gdaui::RawGrid
   * and Gdaui::Grid).
   * 
   * @newin{4,2}
   * @param row The row to unselect.
   */
  void unselect_row(int row);
  
  /** Shows or hides the data at column @a column
   * 
   * @newin{4,2}
   * @param column A column number, starting at 0.
   * @param visible Required visibility of the data in the @a column column.
   */
  void set_column_visible(int column, bool visible);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%selection_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_selection_changed();


    virtual Glib::RefPtr<Gnome::Gda::DataModel> get_model_vfunc() const;


    virtual void set_model_vfunc(const Glib::RefPtr<Gnome::Gda::DataModel>& model);


  //TODO: Wrapping GArray is difficult.
  //_WRAP_VFUNC(GArray* get_selected_rows() const, "get_selected_rows")

    virtual Glib::RefPtr<Gnome::Gda::DataModelIter> get_data_set_vfunc() const;

    virtual bool select_row_vfunc(int row);

    virtual void unselect_row_vfunc(int row);

    virtual void set_column_visible_vfunc(int column, bool visible);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_selection_changed();


};

} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::DataSelector
   */
  Glib::RefPtr<Gnome::GdaUI::DataSelector> wrap(GdauiDataSelector* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGDA_UIMM_DATASELECTOR_H */

