// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_CLOUD_H
#define _LIBGDA_UIMM_CLOUD_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2010 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/box.h>
#include <gtkmm/enums.h>
#include <libgda-uimm/dataproxy.h>
#include <libgda-uimm/dataselector.h>
#include <memory>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiCloud GdauiCloud;
typedef struct _GdauiCloudClass GdauiCloudClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class Cloud_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gnome
{

// Gnome::Gda class forward declarations.
namespace Gda
{

class DataModel;

}

namespace GdaUI
{

/** Cloud - Cloud widget.
 * The Cloud widget displays a string for each row in a Gnome::Gda::DataModel
 * for which the size is variable (determined either by some data in the data
 * model, or by a function provided by the programmer).
 *
 * Depending on the selection mode of the widget, each string can be selected
 * by the user and the signal_selection_changed() is emitted.
 */

class Cloud :
  public Gtk::Box,
  public DataSelector
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Cloud CppObjectType;
  typedef Cloud_Class CppClassType;
  typedef GdauiCloud BaseObjectType;
  typedef GdauiCloudClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Cloud();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Cloud_Class;
  static CppClassType cloud_class_;

  // noncopyable
  Cloud(const Cloud&);
  Cloud& operator=(const Cloud&);

protected:
  explicit Cloud(const Glib::ConstructParams& construct_params);
  explicit Cloud(GdauiCloud* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GdauiCloud*       gobj()       { return reinterpret_cast<GdauiCloud*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GdauiCloud* gobj() const { return reinterpret_cast<GdauiCloud*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_activate(int column);


private:

  
public:
  
  /** Creates a new Gdaui::Cloud widget suitable to display the data in @a model
   * 
   * @newin{4,2}
   * @param model A Gda::DataModel.
   * @return The new widget.
   */

    explicit Cloud(const Glib::RefPtr<Gnome::Gda::DataModel>& model, int label_column, int weight_column);


public:
/** For example,
 * double on_weight(const Glib::RefPtr<Gnome::Gda::DataModel>& model, int
 * row);.
 */
typedef sigc::slot<double, const Glib::RefPtr<Gnome::Gda::DataModel>&, int> SlotWeight;

  
  /** Sets @a cloud's selection mode
   * 
   * @newin{4,2}
   * @param mode The desired selection mode.
   */
  void set_selection_mode(Gtk::SelectionMode mode);
  
  /** Filters the elements displayed in @a cloud, by altering their color.
   * 
   * @newin{4,2}
   * @param filter The filter to use, or <tt>0</tt> to remove any filter.
   */
  void filter(const Glib::ustring& filter);
  
  /** Creates a search widget linked directly to modify @a cloud's appearance.
   * 
   * @newin{4,2}
   * @return A new widget.
   */
  Gtk::Widget* create_filter_widget();
  
  /** Creates a search widget linked directly to modify @a cloud's appearance.
   * 
   * @newin{4,2}
   * @return A new widget.
   */
  const Gtk::Widget* create_filter_widget() const;

  /** Specifies a slot called to compute each row's respective weight.
   * @param func a slot which computes weights.
   * @newin{4,2}
   */
  void set_weight_slot(const SlotWeight& slot);
  

  /** Unsets a previously set weight computing slot.
   * @newin{4,2}
   */
  void unset_weight_slot();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate(int column)</tt>
   */

  Glib::SignalProxy1< void,int > signal_activate();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Column in the data model which contains the text to display, the column must be a G_TYPE_STRING.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_label_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Column in the data model which contains the text to display, the column must be a G_TYPE_STRING.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_label_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_max_scale() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_max_scale() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_min_scale() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_min_scale() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gnome::Gda::DataModel> > property_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gnome::Gda::DataModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_weight_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_weight_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  // Private variable to save the weight calculating slot until it is not
  // necessary.  If the C API would provide a way for destroy notification,
  // this private member would not be necessary.
  std::auto_ptr<SlotWeight> m_slot;
#endif


};

} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::Cloud
   */
  Gnome::GdaUI::Cloud* wrap(GdauiCloud* object, bool take_copy = false);
} //namespace Glib


#endif /* _LIBGDA_UIMM_CLOUD_H */

