// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_COMBO_H
#define _LIBGDA_UIMM_COMBO_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2009 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/combobox.h>
#include <libgda-uimm/dataselector.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiCombo GdauiCombo;
typedef struct _GdauiComboClass GdauiComboClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class Combo_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gnome
{

// Gnome::Gda class forward declartions.
namespace Gda
{

class DataModel;

}

namespace GdaUI
{

/** Combo - Combo box to choose from the contents of a Gnome::Gda::DataModel.
 */

class Combo :
  public Gtk::ComboBox,
  public DataSelector
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Combo CppObjectType;
  typedef Combo_Class CppClassType;
  typedef GdauiCombo BaseObjectType;
  typedef GdauiComboClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Combo();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Combo_Class;
  static CppClassType combo_class_;

  // noncopyable
  Combo(const Combo&);
  Combo& operator=(const Combo&);

protected:
  explicit Combo(const Glib::ConstructParams& construct_params);
  explicit Combo(GdauiCombo* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GdauiCombo*       gobj()       { return reinterpret_cast<GdauiCombo*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GdauiCombo* gobj() const { return reinterpret_cast<GdauiCombo*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:
  
  /** Create a new GdauiCombo widget.
   * 
   * @newin{4,2}
   * @return The newly-created widget.
   */

  Combo();

 
  /** Create a new GdauiCombo widget with a model. See set_model() for
   * more information about the @a n_cols and @a cols_index usage.
   * 
   * @newin{4,2}
   * @param model A Gda::DataModel object.
   * @param n_cols Number of columns in the model to be shown.
   * @param cols_index An array of columns to be shown, its size must be @a n_cols.
   * @return The newly-created widget.
   */

    explicit Combo(const Glib::RefPtr<Gnome::Gda::DataModel>& model, int n_cols, const Glib::ArrayHandle<int>& cols_index);


  //TODO?: Combo(const Glib::RefPtr<Gnome::Gda::DataModel>& model, const Glib::ArrayHandle<int>& cols_index);

public:
  
  /** Makes @a combo display data stored in @a model (makes the
   * combo widget refresh its list of values and display the values contained
   * in the model). A <tt>0</tt> @a model will make the combo empty
   * and disassociate the previous model, if any.
   * 
   * if @a n_cols is %0, then all the columns of @a model will be displayed in @a combo.
   * 
   * @newin{4,2}
   * @param model A Gda::DataModel object.
   * @param n_cols Number of columns in the model to be shown.
   * @param cols_index An array of columns to be shown, its size must be @a n_cols.
   */
  void set_model(const Glib::RefPtr<Gnome::Gda::DataModel>& model, int n_cols, const Glib::ArrayHandle<int>& cols_index);

  //TODO?: void set_model(const Glib::RefPtr<Gnome::Gda::DataModel>& model, const Glib::ArrayHandle<int>& cols_index);

  
  /** Tells if @a combo should add a special entry representing an "undefined choice", as a <tt>0</tt> entry. The default is
   * that only the available choices in @a combo's model are presented.
   * 
   * @newin{4,2}
   * @param add_null Set to <tt>true</tt> to add a <tt>0</tt> value to the combo box.
   */
  void add_null(bool add_null);
  
  /** Tell if the currently selected entry represents the "undefined choice" entry.
   * 
   * @newin{4,2}
   * @return <tt>true</tt> if the <tt>0</tt> value is selected.
   */
  bool is_null_selected() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_as_list() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_as_list() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gnome::Gda::DataModel> > property_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gnome::Gda::DataModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::Combo
   */
  Gnome::GdaUI::Combo* wrap(GdauiCombo* object, bool take_copy = false);
} //namespace Glib


#endif /* _LIBGDA_UIMM_COMBO_H */

