/* GDA client libary
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gda_error_h__
#define __gda_error_h__ 1

#include <glib.h>

#ifdef HAVE_GOBJECT
#  include <glib-object.h>
#else
#  include <gtk/gtkobject.h>
#endif

#include <orb/orb.h>

#ifdef __cplusplus
extern "C" {
#endif

/* The error object. Holds error messages resulting from CORBA exceptions
 * or server errors. 
 */

typedef struct _GdaError       GdaError;
typedef struct _GdaErrorClass  GdaErrorClass;

#define GDA_TYPE_ERROR            (gda_error_get_type())

#ifdef HAVE_GOBJECT
#  define GDA_ERROR(obj) \
            G_TYPE_CHECK_INSTANCE_CAST (obj, GDA_TYPE_ERROR, GdaError)
#  define GDA_ERROR_CLASS(klass) \
            G_TYPE_CHECK_CLASS_CAST (klass, GDA_TYPE_ERROR, GdaErrorClass)
#  define IS_GDA_ERROR(obj) \
            G_TYPE_CHECK_INSTANCE_TYPE (obj, GDA_TYPE_ERROR)
#  define IS_GDA_ERROR_CLASS(klass) \
            G_TYPE_CHECK_CLASS_TYPE (klass, GDA_TYPE_ERROR)
#else
#  define GDA_ERROR(obj)            GTK_CHECK_CAST(obj, GDA_TYPE_ERROR, GdaError)
#  define GDA_ERROR_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GDA_TYPE_ERROR, GdaErrorClass)
#  define IS_GDA_ERROR(obj)         GTK_CHECK_TYPE(obj, GDA_TYPE_ERROR)
#  define IS_GDA_ERROR_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GDA_TYPE_ERROR))
#endif

struct _GdaError
{
#ifdef HAVE_GOBJECT
  GObject         object;
#else
  GtkObject       object;
#endif
  gchar*          description;
  glong           number;
  gchar*          source;
  gchar*          helpurl;
  gchar*          sqlstate;
  gchar*          nativeMsg;
  gchar*          realcommand;
};

struct _GdaErrorClass
{
#ifdef HAVE_GOBJECT
  GObjectClass parent_class;
#else
  GtkObjectClass parent_class;
#endif
};

#ifdef HAVE_GOBJECT
GType        gda_error_get_type        (void);
#else
guint        gda_error_get_type        (void);
#endif

GdaError*   gda_error_new             (void);
GList*       gda_errors_from_exception (CORBA_Environment* ev);
void         gda_error_free            (GdaError* error);
void         gda_error_list_free       (GList* errors);

const gchar* gda_error_description     (GdaError* error);
const glong  gda_error_number          (GdaError* error);
const gchar* gda_error_source          (GdaError* error);
const gchar* gda_error_helpurl         (GdaError* error);
const gchar* gda_error_sqlstate        (GdaError* error);
const gchar* gda_error_nativeMsg       (GdaError* error);
const gchar* gda_error_realcommand     (GdaError* error);

#ifdef __cplusplus
}
#endif

#endif
