/* 
 * $Id: gda-sybase-command.h,v 1.2 2001/04/07 08:49:31 rodrigo Exp $
 *
 * GNOME DB sybase Provider
 * Copyright (C) 2000 Rodrigo Moya
 * Copyright (C) 2000 Stephan Heinze
 * Copyright (C) 2000 Holger Thon
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gda_sybase_command_h__)
#  define __gda_sybase_command_h__

#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif

#include <gda-server.h>
#include <glib.h>
#include <ctpublic.h>
#include "gda-sybase.h"

/*
 * Per-object specific structures
 */

typedef struct _sybase_Command {
  CS_COMMAND               *cmd;
} sybase_Command;

/*
 * Server implementation prototypes
 */

gboolean gda_sybase_command_new (GdaServerCommand *cmd);
GdaServerRecordset* gda_sybase_command_execute (GdaServerCommand *cmd,
						 GdaServerError *error,
						 const GDA_CmdParameterSeq *params,
						 gulong *affected,
						 gulong options);
void gda_sybase_command_free (GdaServerCommand *cmd);

#endif
