# set the defines below to build support for the selected sql layer(s)
# defaults (and package names) are set for redhat 7.x
# with postgres, mysql and odbc installed
%define           MYSQL    1
%define           POSTGRES 1
%define           ODBC     1
%define           ORACLE   0
%define           SYBASE   0
%define           SQLITE   0
%define           TDS      0

Summary:          Library for writing gnome database programs
Name:             libgda
Version:          @version@
Release:          1
Source:           %{name}-%{version}.tar.gz
Group:            System Environment/Libraries
License:          LGPL
BuildRoot:        %{_tmppath}/%{name}-%{version}-root
BuildRequires:    pkgconfig >= 0.8
Requires:         ORBit2 >= 2.3.91
Requires:         glib2 >= 1.3.10
Requires:         bonobo-activation >= 0.7.0
Requires:         libbonobo
Requires:         libxml2
Requires:         GConf2
Requires:         libxslt >= 1.0.9
Requires:         gnome-vfs2
Prereq:           GConf2
BuildRequires:    ORBit2-devel >= 2.3.91
BuildRequires:    glib2-devel >= 1.3.10
BuildRequires:    bonobo-activation-devel >= 0.7.0
BuildRequires:    libbonobo-devel
BuildRequires:    libxml2-devel
BuildRequires:    GConf2-devel
BuildRequires:    libxslt-devel >= 1.0.9
BuildRequires:    gnome-vfs2-devel

%if %{MYSQL}
Requires:         mysqlclient9
BuildRequires:    mysqlclient9, mysql-devel
%endif

%if %{POSTGRES}
Requires:         postgresql-libs
BuildRequires:    postgresql-libs, postgresql-devel
%endif


%description
libgda is a library that eases the task of writing
gnome database programs.


%package devel
Summary:          Development libraries and header files for libgda.
Group:            Development/Libraries
Requires:         %name = %{version}
Requires:         pkgconfig >= 0.8
Requires:         ORBit2 >= 2.3.91
Requires:         ORBit2-devel >= 2.3.91
Requires:         glib2 >= 1.3.10
Requires:         glib2-devel >= 1.3.10
Requires:         bonobo-activation >= 0.7.0
Requires:         bonobo-activation-devel >= 0.7.0
Requires:         libbonobo
Requires:         libbonobo-devel
Requires:         libxml2
Requires:         libxml2-devel
Requires:         GConf2
Requires:         GConf2-devel
Requires:         libxslt >= 1.0.9
Requires:         libxslt-devel >= 1.0.9
Requires:         gnome-vfs2
Requires:         gnome-vfs2-devel

%description devel
This package contains the header files and libraries needed to write
or compile programs that use libgda.

%prep
%setup -q -n %{name}-%{version}

%build
%if %{MYSQL}
CONFIG="$CONFIG --with-mysql"
%endif

%if %{POSTGRES}
CONFIG="$CONFIG --with-postgres"
%endif

%if %{ODBC}
CONFIG="$CONFIG --with-odbc"
%endif

%if %{ORACLE}
CONFIG="$CONFIG --with-oracle"
%endif

%if %{SYBASE}
CONFIG="$CONFIG --with-sybase"
%endif

%if %{TDS}
CONFIG="$CONFIG --with-tds"
%endif

%if %{SQLITE}
CONFIG="$CONFIG --with-sqlite"
%endif


%configure $CONFIG
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%makeinstall

%find_lang libgda-2

%post -p /sbin/ldconfig
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`

for SCHEMA in %{_sysconfdir}/gconf/schemas/libgda.schemas; do
/usr/bin/gconftool-2 --makefile-install-rule $SCHEMA > /dev/null 2>&1
done

%postun -p /sbin/ldconfig

%clean
rm -rf %{buildroot}

%files -f libgda-2.lang
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog README NEWS
%doc %{_datadir}/gnome/help/libgda
%{_sysconfdir}/gconf/schemas/libgda.schemas
%{_bindir}/*
%{_libdir}/*.so.*
%{_libdir}/bonobo/servers/*
%{_datadir}/idl
%{_datadir}/libgda/dtd/*

%files devel
%defattr(-,root,root)
%doc %{_datadir}/gtk-doc/html/libgda
%{_includedir}/libgda/*
%{_includedir}/libgda-report/*
%{_libdir}/*.so
%{_libdir}/*a
%{_libdir}/pkgconfig/*


%changelog
* Tue Feb 26 2002 Chris Chabot <chabotc@reviewboard.com>
- Added defines and configure flags for all supported DB types

* Mon Feb 25 2002 Chris Chabot <chabotc@reviewboard.com>
- Cleaned up formatting
- Added Requirements
- Added defines for postgres, mysql, odbc support

* Thu Feb 21 2002 Chris Chabot <chabotc@reviewboard.com>
- Initial spec file
