/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 60
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  Expr * yy386;
  struct {int value; int mask;} yy405;
  Token yy410;
  IdList* yy432;
  int yy495;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 586
#define YYNRULE 310
#define YYERRORSYMBOL 139
#define YYERRSYMDT yy495
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   290,   67,  300,   69,  150,  168,  205,  420,   61,   61,
 /*    10 */    61,   61,   66,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,  430,  322,  164,  433,  439,   68,   63,
 /*    30 */    63,   63,   63,   64,   64,   65,   65,   65,   66,   64,
 /*    40 */    64,   65,   65,   65,   66,   60,   58,  296,  443,  444,
 /*    50 */   440,  440,   62,   62,   61,   61,   61,   61,  487,   63,
 /*    60 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  290,
 /*    70 */   318,   67,  420,   69,  150,   79,  160,  114,  240,  341,
 /*    80 */   245,  342,  172,  249,  897,  120,  585,  190,  522,    2,
 /*    90 */   250,  571,  411,   35,  223,  433,  439,  532,   20,   57,
 /*   100 */   388,  385,   63,   63,   63,   63,   64,   64,   65,   65,
 /*   110 */    65,   66,  290,  489,   60,   58,  296,  443,  444,  440,
 /*   120 */   440,   62,   62,   61,   61,   61,   61,  393,   63,   63,
 /*   130 */    63,   63,   64,   64,   65,   65,   65,   66,  433,  439,
 /*   140 */    91,  314,  389,  473,  230,  529,  504,  204,  168,   55,
 /*   150 */   420,  197,  528,  407,  196,  428,  208,   60,   58,  296,
 /*   160 */   443,  444,  440,  440,   62,   62,   61,   61,   61,   61,
 /*   170 */   170,   63,   63,   63,   63,   64,   64,   65,   65,   65,
 /*   180 */    66,  290,  479,  428,  208,  412,  109,   81,  412,  432,
 /*   190 */   406,  284,  394,  395,  430,  521,  164,  318,  517,   67,
 /*   200 */   530,   69,  150,  567,  412,  492,  493,  433,  439,  145,
 /*   210 */   146,  583,  888,  376,  888,  420,  171,  156,  488,  411,
 /*   220 */    40,  337,  415,   19,  290,  140,   60,   58,  296,  443,
 /*   230 */   444,  440,  440,   62,   62,   61,   61,   61,   61,  384,
 /*   240 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   250 */   433,  439,  580,  546,  493,  417,  417,  417,  549,  332,
 /*   260 */   234,   67,  460,   69,  150,  583,  887,  290,  887,   60,
 /*   270 */    58,  296,  443,  444,  440,  440,   62,   62,   61,   61,
 /*   280 */    61,   61,  318,   63,   63,   63,   63,   64,   64,   65,
 /*   290 */    65,   65,   66,  433,  439,  177,  548,  393,  343,  346,
 /*   300 */   347,  515,  490,  271,  411,   40,  580,  473,  432,  224,
 /*   310 */   348,  408,   60,   58,  296,  443,  444,  440,  440,   62,
 /*   320 */    62,   61,   61,   61,   61,  523,   63,   63,   63,   63,
 /*   330 */    64,   64,   65,   65,   65,   66,  303,  488,  300,  290,
 /*   340 */    75,  415,  274,  483,  272,  232,  236,  370,  267,  266,
 /*   350 */   318,   65,   65,   65,   66,  173,  393,  148,  205,  434,
 /*   360 */   435,  231,  394,  395,  177,  433,  439,  343,  346,  347,
 /*   370 */   293,  515,  411,   34,  417,  417,  417,  378,  477,  348,
 /*   380 */   248,  437,  438,   78,   60,   58,  296,  443,  444,  440,
 /*   390 */   440,   62,   62,   61,   61,   61,   61,  205,   63,   63,
 /*   400 */    63,   63,   64,   64,   65,   65,   65,   66,  290,  436,
 /*   410 */   377,  292,  486,  114,  240,  341,  245,  342,  172,  249,
 /*   420 */   318,  394,  395,  273,  318,  177,  250,  456,  343,  346,
 /*   430 */   347,  329,  151,  566,  433,  439,  295,  423,  424,  298,
 /*   440 */   348,  387,  411,   34,    2,  360,  411,   34,  469,  363,
 /*   450 */   247,  568,  569,   60,   58,  296,  443,  444,  440,  440,
 /*   460 */    62,   62,   61,   61,   61,   61,  412,   63,   63,   63,
 /*   470 */    63,   64,   64,   65,   65,   65,   66,  290,  522,  155,
 /*   480 */   515,  503,   21,  452,  318,  299,  420,  404,   20,  297,
 /*   490 */   321,  423,  424,  482,  318,  453,  318,  457,    1,  207,
 /*   500 */   335,  457,  393,  433,  439,    9,  411,   34,  454,  393,
 /*   510 */   494,  147,  531,  207,  543,  216,  411,   48,  411,   48,
 /*   520 */   495,  393,   60,   58,  296,  443,  444,  440,  440,   62,
 /*   530 */    62,   61,   61,   61,   61,  351,   63,   63,   63,   63,
 /*   540 */    64,   64,   65,   65,   65,   66,  290,  318,  447,  334,
 /*   550 */   253,  420,  371,  207,  452,  149,  448,  579,  289,  248,
 /*   560 */   393,  457,  173,  309,  235,  310,  453,  394,  395,  411,
 /*   570 */    27,  420,  433,  439,  394,  395,  405,  520,  367,  454,
 /*   580 */   324,  328,  446,  446,  509,  517,  394,  395,  473,  412,
 /*   590 */   545,   60,   58,  296,  443,  444,  440,  440,   62,   62,
 /*   600 */    61,   61,   61,   61,  510,   63,   63,   63,   63,   64,
 /*   610 */    64,   65,   65,   65,   66,  290,  192,  338,  292,  324,
 /*   620 */    90,  446,  446,  250,  522,  394,  395,  238,  319,  393,
 /*   630 */   822,  477,  318,  576,   20,  324,  420,  446,  446,  411,
 /*   640 */     3,  433,  439,  324,  217,  446,  446,  586,  388,  385,
 /*   650 */   412,  515,  470,  515,  411,   28,  515,  302,  290,  581,
 /*   660 */    60,   58,  296,  443,  444,  440,  440,   62,   62,   61,
 /*   670 */    61,   61,   61,  219,   63,   63,   63,   63,   64,   64,
 /*   680 */    65,   65,   65,   66,  433,  439,  304,  481,  305,  167,
 /*   690 */   156,  307,  358,  392,  394,  395,  396,  397,  398,  582,
 /*   700 */   188,  290,  339,   60,   58,  296,  443,  444,  440,  440,
 /*   710 */    62,   62,   61,   61,   61,   61,  318,   63,   63,   63,
 /*   720 */    63,   64,   64,   65,   65,   65,   66,  433,  439,  410,
 /*   730 */   248,  261,  248,  409,  412,  248,  367,  255,  411,   23,
 /*   740 */   539,  357,  539,  261,  290,  261,   60,   70,  296,  443,
 /*   750 */   444,  440,  440,   62,   62,   61,   61,   61,   61,  368,
 /*   760 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   770 */   433,  439,  381,  541,  115,  261,  259,  540,  257,  261,
 /*   780 */   364,  174,  175,  176,  262,  261,  556,  290,    5,  359,
 /*   790 */    58,  296,  443,  444,  440,  440,   62,   62,   61,   61,
 /*   800 */    61,   61,  218,   63,   63,   63,   63,   64,   64,   65,
 /*   810 */    65,   65,   66,  433,  439,  477,  558,  205,  466,  468,
 /*   820 */   559,  206,  383,  261,  261,  261,  560,  152,   54,  467,
 /*   830 */   369,  312,  119,  124,  296,  443,  444,  440,  440,   62,
 /*   840 */    62,   61,   61,   61,   61,  416,   63,   63,   63,   63,
 /*   850 */    64,   64,   65,   65,   65,   66,   71,  325,  318,    4,
 /*   860 */   318,  412,  318,  294,  275,  375,  277,  318,   74,  318,
 /*   870 */    76,  320,   71,  325,  318,    4,  308,  498,  499,  294,
 /*   880 */   411,   32,  411,   53,  411,   24,  154,  320,  327,  411,
 /*   890 */    51,  411,   96,  161,  410,  318,  411,   93,  409,  432,
 /*   900 */   318,  421,  318,   22,  327,  426,  426,  179,  318,  501,
 /*   910 */   143,  318,  468,  508,  507,  432,  318,  411,   98,   73,
 /*   920 */    72,  182,  411,   99,  411,  110,  323,   71,  316,  317,
 /*   930 */   411,  111,  415,  411,   16,   73,   72,  480,  411,   97,
 /*   940 */   318,  412,  330,   71,  316,  317,   71,  325,  415,    4,
 /*   950 */   318,  205,  318,  294,  318,  412,  455,  318,   12,  537,
 /*   960 */   538,  320,  411,   33,  462,  417,  417,  417,  418,  419,
 /*   970 */    11,  463,  411,   94,  411,   52,  411,  112,  327,  411,
 /*   980 */   113,  417,  417,  417,  418,  419,   11,  620,  241,  432,
 /*   990 */   158,  475,  318,  169,  429,  220,  221,  222,  101,  458,
 /*  1000 */   242,  318,  441,  318,  484,  318,   12,  318,  472,   73,
 /*  1010 */    72,  202,  476,  279,  411,   25,  246,   71,  316,  317,
 /*  1020 */   280,  318,  415,  411,   36,  411,   37,  411,   26,  411,
 /*  1030 */    38,  318,  199,  505,  548,  513,  252,  124,  124,  198,
 /*  1040 */   318,  506,  201,  411,   39,  318,  511,  350,  318,  124,
 /*  1050 */   544,  318,  124,  411,   41,  417,  417,  417,  418,  419,
 /*  1060 */    11,  512,  411,   42,  524,  254,  318,  411,   43,  200,
 /*  1070 */   411,   29,  318,  411,   30,  552,  318,  169,  553,  318,
 /*  1080 */    88,  318,  256,  318,  185,  374,  276,  266,  411,   44,
 /*  1090 */   258,  291,  318,  260,  411,   45,  205,  265,  411,   46,
 /*  1100 */   318,  411,   47,  411,   31,  411,   10,  563,  578,   88,
 /*  1110 */   288,  355,  362,  365,  411,   49,  366,  268,  269,   18,
 /*  1120 */   380,  270,  411,   50,  555,  565,  278,  379,  281,  282,
 /*  1130 */   575,  142,  225,  402,  425,  427,  326,  504,  551,  461,
 /*  1140 */   465,  562,  159,  391,  399,  243,  400,  514,  516,  401,
 /*  1150 */     8,  413,  226,  315,   81,  333,  227,   80,  331,  228,
 /*  1160 */   345,  229,   77,   56,  209,  166,  459,  233,  210,  407,
 /*  1170 */   464,  121,   82,  336,  340,  491,  496,  301,  244,  501,
 /*  1180 */   497,  500,  502,  102,  518,  519,  414,  285,  352,  525,
 /*  1190 */   180,  526,  527,  533,  237,  181,  474,  239,  354,  478,
 /*  1200 */   211,  286,  184,  214,  535,  183,  215,  356,   85,  361,
 /*  1210 */   117,  186,  128,  547,  189,  372,  554,  373,  311,  561,
 /*  1220 */   572,  129,  130,  131,  138,  573,   95,  132,  577,  263,
 /*  1230 */   137,  134,  574,  390,  403,  621,  536,  213,  622,  100,
 /*  1240 */   162,   59,  163,  422,  431,  442,  445,  139,   89,  449,
 /*  1250 */   153,  165,    6,  450,  451,  122,  471,   13,    7,   92,
 /*  1260 */   123,   12,  485,  157,  212,  108,   83,  103,  104,  116,
 /*  1270 */   344,  251,   84,  105,  349,   17,  178,  353,  242,  534,
 /*  1280 */   141,  125,  306,  187,  106,  169,  126,  287,  542,  264,
 /*  1290 */   118,  550,  127,  191,  313,   14,   86,  193,  194,  135,
 /*  1300 */   557,  195,  133,  564,  136,   15,  107,  570,  382,  283,
 /*  1310 */   144,  203,  386,   87,  584,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  218,   16,  220,  221,   21,  111,   23,   70,   71,
 /*    10 */    72,   73,   84,   75,   76,   77,   78,   79,   80,   81,
 /*    20 */    82,   83,   84,  162,  163,  164,   42,   43,   74,   75,
 /*    30 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   79,
 /*    40 */    80,   81,   82,   83,   84,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,   73,  170,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   148,  218,   88,  220,  221,   22,   90,   91,   92,   93,
 /*    80 */    94,   95,   96,   97,  140,  141,  142,   22,  148,  145,
 /*    90 */   104,  238,  170,  171,  154,   42,   43,  157,  158,   46,
 /*   100 */     1,    2,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   110 */    83,   84,   16,  170,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   73,   23,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,  143,  144,  162,  222,  177,  178,  149,   21,   19,
 /*   150 */    23,  156,  184,   23,  156,   79,   80,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   170 */   156,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,  201,   79,   80,  190,   21,  122,  190,   59,
 /*   190 */   169,  159,   88,   89,  162,  163,  164,  148,  177,  218,
 /*   200 */   182,  220,  221,   99,  190,  186,  187,   42,   43,   79,
 /*   210 */    80,   19,   20,  215,   22,   88,  202,  203,   88,  170,
 /*   220 */   171,  207,   92,   19,   16,   21,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  241,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   60,  186,  187,  125,  126,  127,   11,  210,
 /*   260 */   211,  218,  219,  220,  221,   19,   20,   16,   22,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   73,  148,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,   90,   49,   23,   93,   94,
 /*   300 */    95,  148,  161,   14,  170,  171,   60,  162,   59,  191,
 /*   310 */   105,  170,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,   73,  182,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  183,   88,   16,   16,
 /*   340 */   132,   92,   53,   20,   55,  211,  201,  100,  101,  102,
 /*   350 */   148,   81,   82,   83,   84,   43,   23,   22,  111,   42,
 /*   360 */    43,  148,   88,   89,   90,   42,   43,   93,   94,   95,
 /*   370 */   151,  148,  170,  171,  125,  126,  127,   91,  148,  105,
 /*   380 */   227,   64,   65,  132,   61,   62,   63,   64,   65,   66,
 /*   390 */    67,   68,   69,   70,   71,   72,   73,  111,   75,   76,
 /*   400 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   92,
 /*   410 */   124,   99,   20,   91,   92,   93,   94,   95,   96,   97,
 /*   420 */   148,   88,   89,  134,  148,   90,  104,  225,   93,   94,
 /*   430 */    95,  187,  156,  148,   42,   43,  165,  166,  167,  209,
 /*   440 */   105,  142,  170,  171,  145,  226,  170,  171,  115,  230,
 /*   450 */   227,  166,  167,   61,   62,   63,   64,   65,   66,   67,
 /*   460 */    68,   69,   70,   71,   72,   73,  190,   75,   76,   77,
 /*   470 */    78,   79,   80,   81,   82,   83,   84,   16,  148,  148,
 /*   480 */   148,   20,   19,   12,  148,  213,   23,  157,  158,  213,
 /*   490 */   165,  166,  167,   20,  148,   24,  148,  225,   19,  228,
 /*   500 */   148,  225,   23,   42,   43,   19,  170,  171,   37,   23,
 /*   510 */    39,  181,  182,  228,   18,  183,  170,  171,  170,  171,
 /*   520 */    49,   23,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   530 */    69,   70,   71,   72,   73,   16,   75,   76,   77,   78,
 /*   540 */    79,   80,   81,   82,   83,   84,   16,  148,   20,  213,
 /*   550 */    20,   88,   56,  228,   12,  156,   20,  244,  245,  227,
 /*   560 */    23,  225,   43,  217,  148,  217,   24,   88,   89,  170,
 /*   570 */   171,   23,   42,   43,   88,   89,  168,  169,  148,   37,
 /*   580 */   107,   39,  109,  110,   30,  177,   88,   89,  162,  190,
 /*   590 */    94,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   600 */    70,   71,   72,   73,   50,   75,   76,   77,   78,   79,
 /*   610 */    80,   81,   82,   83,   84,   16,  156,  148,   99,  107,
 /*   620 */    21,  109,  110,  104,  148,   88,   89,  201,  148,   23,
 /*   630 */   134,  148,  148,  157,  158,  107,   88,  109,  110,  170,
 /*   640 */   171,   42,   43,  107,  214,  109,  110,    0,    1,    2,
 /*   650 */   190,  148,  115,  148,  170,  171,  148,  103,   16,   20,
 /*   660 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   670 */    71,   72,   73,  146,   75,   76,   77,   78,   79,   80,
 /*   680 */    81,   82,   83,   84,   42,   43,  183,   81,  183,  202,
 /*   690 */   203,  183,  209,  148,   88,   89,    7,    8,    9,   60,
 /*   700 */   156,   16,   81,   61,   62,   63,   64,   65,   66,   67,
 /*   710 */    68,   69,   70,   71,   72,   73,  148,   75,   76,   77,
 /*   720 */    78,   79,   80,   81,   82,   83,   84,   42,   43,  108,
 /*   730 */   227,  148,  227,  112,  190,  227,  148,   14,  170,  171,
 /*   740 */   100,  101,  102,  148,   16,  148,   61,   62,   63,   64,
 /*   750 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  215,
 /*   760 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   770 */    42,   43,  189,   25,  148,  148,   53,   29,   55,  148,
 /*   780 */   236,  100,  101,  102,  189,  148,  189,   16,  192,   41,
 /*   790 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   800 */    72,   73,  214,   75,   76,   77,   78,   79,   80,   81,
 /*   810 */    82,   83,   84,   42,   43,  148,  189,  111,   22,   22,
 /*   820 */   189,  193,  239,  148,  148,  148,  189,  156,  200,  204,
 /*   830 */   124,  242,  243,   22,   63,   64,   65,   66,   67,   68,
 /*   840 */    69,   70,   71,   72,   73,  148,   75,   76,   77,   78,
 /*   850 */    79,   80,   81,   82,   83,   84,   16,   17,  148,   19,
 /*   860 */   148,  190,  148,   23,  189,  189,  189,  148,  131,  148,
 /*   870 */   133,   31,   16,   17,  148,   19,  209,    7,    8,   23,
 /*   880 */   170,  171,  170,  171,  170,  171,   89,   31,   48,  170,
 /*   890 */   171,  170,  171,   19,  108,  148,  170,  171,  112,   59,
 /*   900 */   148,   20,  148,   22,   48,  125,  126,  156,  148,   98,
 /*   910 */   114,  148,  115,   91,   92,   59,  148,  170,  171,   79,
 /*   920 */    80,  156,  170,  171,  170,  171,   16,   87,   88,   89,
 /*   930 */   170,  171,   92,  170,  171,   79,   80,   81,  170,  171,
 /*   940 */   148,  190,  148,   87,   88,   89,   16,   17,   92,   19,
 /*   950 */   148,  111,  148,   23,  148,  190,   20,  148,   22,   51,
 /*   960 */    52,   31,  170,  171,   27,  125,  126,  127,  128,  129,
 /*   970 */   130,   34,  170,  171,  170,  171,  170,  171,   48,  170,
 /*   980 */   171,  125,  126,  127,  128,  129,  130,  113,   92,   59,
 /*   990 */     5,   20,  148,   22,  162,   10,   11,   12,   13,  148,
 /*  1000 */   104,  148,   92,  148,   20,  148,   22,  148,  148,   79,
 /*  1010 */    80,   26,  148,   28,  170,  171,  148,   87,   88,   89,
 /*  1020 */    35,  148,   92,  170,  171,  170,  171,  170,  171,  170,
 /*  1030 */   171,  148,   47,  148,   49,   20,   20,   22,   22,   54,
 /*  1040 */   148,  179,   57,  170,  171,  148,  179,   20,  148,   22,
 /*  1050 */    20,  148,   22,  170,  171,  125,  126,  127,  128,  129,
 /*  1060 */   130,  179,  170,  171,  148,  148,  148,  170,  171,   19,
 /*  1070 */   170,  171,  148,  170,  171,   20,  148,   22,   20,  148,
 /*  1080 */    22,  148,  148,  148,  232,  100,  101,  102,  170,  171,
 /*  1090 */   148,  106,  148,  148,  170,  171,  111,  148,  170,  171,
 /*  1100 */   148,  170,  171,  170,  171,  170,  171,   20,   20,   22,
 /*  1110 */    22,  233,  148,  148,  170,  171,  148,  148,  148,   69,
 /*  1120 */   135,  148,  170,  171,  148,  148,  148,  148,  148,  148,
 /*  1130 */   148,  192,  194,  150,  229,  229,  224,  178,  195,  173,
 /*  1140 */   173,  195,    6,  147,  147,  173,  147,  173,  173,  147,
 /*  1150 */    22,  190,  195,  155,  122,  119,  196,  120,  117,  197,
 /*  1160 */   174,  198,  131,  121,  223,  113,  153,   97,  212,   23,
 /*  1170 */   161,  153,   99,  116,   99,  172,  172,   40,  172,   98,
 /*  1180 */   180,  174,  172,   19,  161,  180,  199,  175,   15,  172,
 /*  1190 */   152,  172,  172,  153,  205,  152,  206,  205,  153,  206,
 /*  1200 */   212,  175,  153,  212,  153,  152,  212,   38,  131,  153,
 /*  1210 */    61,  152,   19,  185,  185,  153,  195,   15,  153,  195,
 /*  1220 */    33,  188,  188,  188,  216,  153,  160,  188,  138,  234,
 /*  1230 */   216,  185,  153,    1,   20,  113,  235,  176,  113,  176,
 /*  1240 */   113,   19,  113,   20,   20,   92,  108,   19,  237,   11,
 /*  1250 */    19,   22,  118,   20,   20,   19,  115,   22,  118,  237,
 /*  1260 */    20,   22,   20,  113,   44,  240,   19,   19,   19,   32,
 /*  1270 */    44,   20,   19,   19,   44,  231,   96,   16,  104,   17,
 /*  1280 */    21,   99,   36,   99,   19,   22,   45,    5,   45,  134,
 /*  1290 */   243,    1,  103,  123,  246,   19,   69,  114,   14,  103,
 /*  1300 */    17,  116,  114,  124,  123,   19,   14,   20,   58,  137,
 /*  1310 */    19,  136,    3,   69,    4,
};
#define YY_SHIFT_USE_DFLT (-106)
#define YY_SHIFT_MAX 386
static const short yy_shift_ofst[] = {
 /*     0 */    99,  840,  985,  -16,  840,  930,  930,  930,  274, -105,
 /*    10 */    96,  930,  930,  930,  930,  930,  -46,  247,  104,  498,
 /*    20 */   548,   76,   76,   53,  165,  208,  251,  323,  392,  461,
 /*    30 */   530,  599,  642,  685,  642,  642,  642,  642,  642,  642,
 /*    40 */   642,  642,  642,  642,  642,  642,  642,  642,  642,  642,
 /*    50 */   642,  728,  771,  771,  856,  930,  930,  930,  930,  930,
 /*    60 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    70 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    80 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    90 */   930,  930,  930,  -62,  -62,  -14,   27,   27,  -40,  270,
 /*   100 */   519,  496,  498,  498,  498,  498,  498,  498,  498,  548,
 /*   110 */   -72, -106, -106, -106,  130,  322,  471,  471,  192,  246,
 /*   120 */   647,  127,  498,  127,  498,  498,  498,  498,  498,  498,
 /*   130 */   498,  498,  498,  498,  498,  498,  498,  286,  706, -105,
 /*   140 */  -105, -105, -106, -106, -106,  249,  249,  335,  205,  473,
 /*   150 */   479,  528,  536,  542,  333,  537,  486,  606,  689,  498,
 /*   160 */   498,  621,  498,  498,  463,  498,  498,  797,  498,  498,
 /*   170 */   512,  797,  498,  498,  554,  554,  554,  498,  498,  512,
 /*   180 */   498,  498,  512,  498,  748,  640,  498,  498,  512,  498,
 /*   190 */   498,  498,  512,  498,  498,  498,  512,  512,  498,  498,
 /*   200 */   498,  498,  498,  498,  204,  786,  796,  780,  780,  737,
 /*   210 */   937,  937,  937,  312,  937,  937,  811,   65,   65, 1136,
 /*   220 */  1136, 1136, 1136, 1128, -105, 1032, 1036, 1037, 1041, 1042,
 /*   230 */  1031, 1052, 1070, 1146, 1070, 1052, 1073, 1057, 1073, 1057,
 /*   240 */  1075, 1075, 1137, 1075, 1081, 1075, 1164, 1070, 1070, 1146,
 /*   250 */  1137, 1075, 1075, 1075, 1164, 1173, 1052, 1173, 1052, 1173,
 /*   260 */  1052, 1052, 1169, 1077, 1173, 1052, 1149, 1149, 1193, 1032,
 /*   270 */  1052, 1202, 1202, 1202, 1202, 1032, 1149, 1193, 1052, 1187,
 /*   280 */  1187, 1052, 1052, 1090, -106, -106, -106, -106, -106, -106,
 /*   290 */   317,  289,  681,  723,  874,  881,  910,  936,  971,  984,
 /*   300 */   896,  870,  822, 1015, 1016, 1027,  908, 1030, 1055, 1058,
 /*   310 */  1087, 1050, 1088,  639, 1232, 1214, 1122, 1125, 1127, 1129,
 /*   320 */  1222, 1223, 1224, 1153, 1138, 1228, 1238, 1231, 1233, 1229,
 /*   330 */  1234, 1134, 1235, 1140, 1239, 1141, 1236, 1240, 1150, 1242,
 /*   340 */  1237, 1220, 1247, 1226, 1248, 1251, 1249, 1253, 1230, 1254,
 /*   350 */  1180, 1174, 1261, 1262, 1259, 1182, 1246, 1241, 1263, 1243,
 /*   360 */  1155, 1184, 1265, 1282, 1290, 1189, 1227, 1244, 1170, 1276,
 /*   370 */  1183, 1284, 1185, 1283, 1188, 1196, 1181, 1286, 1179, 1287,
 /*   380 */  1292, 1250, 1175, 1172, 1291, 1309, 1310,
};
#define YY_REDUCE_USE_DFLT (-218)
#define YY_REDUCE_MAX 289
static const short yy_reduce_ofst[] = {
 /*     0 */   -56,  276,   -2,  -19,  399,  272,   49,  336,  330,   14,
 /*    10 */  -147,  -78,  202,  134,  346,  348,   43,  544,  285,  -60,
 /*    20 */    32,  271,  325, -217, -217, -217, -217, -217, -217, -217,
 /*    30 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    40 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    50 */  -217, -217, -217, -217,  469,  484,  568,  710,  712,  714,
 /*    60 */   719,  721,  726,  747,  752,  754,  760,  763,  768,  792,
 /*    70 */   802,  804,  806,  809,  844,  853,  855,  857,  859,  873,
 /*    80 */   883,  892,  897,  900,  903,  918,  924,  928,  931,  933,
 /*    90 */   935,  944,  952, -217, -217,  408, -217, -217, -217, -217,
 /*   100 */   -32,  219,  153,  332,  503,  505,  508,  583,  476, -139,
 /*   110 */  -217, -217, -217, -217,  141,   21,   19,   67,  313,  313,
 /*   120 */   299,  145,  230,  426,  223,  595,  483,  430,  667,  597,
 /*   130 */   627,  631,  637,  675,  676,  588,  677,   -5,  460,  671,
 /*   140 */   751,  765,  628,  487,  589, -112,  -57,   18,  143,  118,
 /*   150 */   213,  118,  118,  244,  331,  352,  416,  480,  527,  545,
 /*   160 */   626,  596,  480,  697,  832,  794,  851,  625,  860,  864,
 /*   170 */   118,  625,  868,  885,  862,  867,  882,  916,  917,  118,
 /*   180 */   934,  942,  118,  945,  852,  878,  949,  964,  118,  965,
 /*   190 */   968,  969,  118,  970,  973,  976,  118,  118,  977,  978,
 /*   200 */   979,  980,  981,  982,  983,  939,  938,  905,  906,  912,
 /*   210 */   966,  967,  972,  959,  974,  975,  986,  943,  946,  996,
 /*   220 */   997,  999, 1002,  998,  961,  957,  960,  962,  963,  987,
 /*   230 */   941, 1013,  956, 1009,  988, 1018,  989,  990,  992,  993,
 /*   240 */  1003, 1004, 1000, 1006, 1007, 1010, 1012,  991,  994, 1023,
 /*   250 */  1005, 1017, 1019, 1020, 1026, 1038, 1040, 1043, 1045, 1053,
 /*   260 */  1049, 1051,  995, 1001, 1059, 1056, 1028, 1029, 1008, 1021,
 /*   270 */  1062, 1033, 1034, 1035, 1039, 1024, 1046, 1014, 1065, 1011,
 /*   280 */  1022, 1072, 1079, 1025, 1066, 1061, 1063, 1044, 1047, 1048,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   592,  819,  896,  707,  896,  819,  896,  819,  896,  711,
 /*    10 */   870,  815,  819,  896,  896,  896,  790,  896,  841,  896,
 /*    20 */   623,  841,  841,  742,  896,  896,  896,  896,  896,  896,
 /*    30 */   896,  896,  743,  896,  818,  814,  810,  812,  811,  744,
 /*    40 */   731,  740,  747,  723,  855,  749,  750,  756,  757,  871,
 /*    50 */   874,  778,  796,  777,  896,  896,  896,  896,  896,  896,
 /*    60 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*    70 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*    80 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*    90 */   896,  896,  896,  780,  801,  616,  779,  789,  781,  782,
 /*   100 */   676,  611,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   110 */   783,  784,  797,  798,  896,  896,  896,  896,  896,  896,
 /*   120 */   592,  707,  896,  707,  896,  896,  896,  896,  896,  896,
 /*   130 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   140 */   896,  896,  701,  711,  889,  896,  896,  667,  896,  896,
 /*   150 */   896,  896,  896,  896,  896,  896,  896,  896,  599,  597,
 /*   160 */   896,  699,  896,  896,  625,  896,  896,  709,  896,  896,
 /*   170 */   714,  715,  896,  896,  896,  896,  896,  896,  896,  613,
 /*   180 */   896,  896,  688,  896,  847,  896,  896,  896,  862,  896,
 /*   190 */   896,  896,  860,  896,  896,  896,  690,  752,  829,  896,
 /*   200 */   896,  875,  877,  896,  896,  699,  708,  896,  896,  813,
 /*   210 */   734,  734,  734,  646,  734,  734,  649,  746,  746,  596,
 /*   220 */   596,  596,  596,  666,  896,  746,  737,  739,  727,  741,
 /*   230 */   896,  716,  735,  896,  735,  716,  724,  726,  724,  726,
 /*   240 */   678,  678,  663,  678,  649,  678,  823,  735,  735,  896,
 /*   250 */   663,  678,  678,  678,  823,  608,  716,  608,  716,  608,
 /*   260 */   716,  716,  851,  854,  608,  716,  680,  680,  758,  746,
 /*   270 */   716,  687,  687,  687,  687,  746,  680,  758,  716,  873,
 /*   280 */   873,  716,  716,  882,  633,  651,  651,  857,  889,  894,
 /*   290 */   896,  896,  896,  896,  765,  896,  896,  896,  896,  896,
 /*   300 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   310 */   896,  836,  896,  896,  896,  896,  770,  766,  896,  767,
 /*   320 */   896,  896,  896,  896,  693,  896,  896,  896,  896,  896,
 /*   330 */   896,  896,  728,  896,  738,  896,  896,  896,  896,  896,
 /*   340 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   350 */   896,  896,  896,  896,  896,  896,  896,  849,  850,  896,
 /*   360 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   370 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   380 */   896,  881,  896,  896,  884,  593,  896,  587,  590,  589,
 /*   390 */   591,  595,  598,  620,  621,  622,  600,  601,  602,  603,
 /*   400 */   604,  605,  606,  612,  614,  632,  634,  618,  636,  697,
 /*   410 */   698,  762,  691,  692,  696,  764,  768,  769,  771,  772,
 /*   420 */   619,  626,  627,  630,  631,  837,  839,  838,  840,  629,
 /*   430 */   628,  773,  776,  785,  786,  788,  794,  800,  803,  787,
 /*   440 */   792,  793,  795,  799,  802,  694,  695,  806,  808,  809,
 /*   450 */   863,  864,  865,  866,  867,  804,  816,  817,  717,  807,
 /*   460 */   791,  729,  732,  733,  736,  730,  700,  710,  719,  720,
 /*   470 */   721,  722,  705,  706,  712,  725,  760,  761,  713,  702,
 /*   480 */   703,  704,  805,  763,  774,  775,  637,  638,  770,  639,
 /*   490 */   640,  641,  679,  682,  683,  684,  642,  661,  664,  665,
 /*   500 */   643,  650,  644,  645,  652,  653,  654,  657,  658,  659,
 /*   510 */   660,  655,  656,  824,  825,  827,  826,  647,  648,  662,
 /*   520 */   635,  624,  617,  668,  671,  672,  673,  674,  675,  677,
 /*   530 */   669,  670,  615,  607,  609,  718,  843,  852,  853,  848,
 /*   540 */   844,  845,  846,  610,  820,  821,  681,  754,  755,  842,
 /*   550 */   856,  858,  759,  859,  861,  886,  685,  686,  689,  828,
 /*   560 */   868,  745,  748,  751,  753,  830,  831,  832,  833,  834,
 /*   570 */   835,  869,  872,  876,  878,  879,  880,  883,  885,  890,
 /*   580 */   891,  892,  895,  893,  594,  588,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "VIRTUAL",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "ANY",           "OR",            "AND",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "cmdx",        
  "cmd",           "explain",       "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "on_opt",        "using_opt",     "seltablist_paren",
  "joinop2",       "inscollist",    "sortlist",      "sortitem",    
  "collate",       "exprlist",      "setlist",       "insert_cmd",  
  "inscollist_opt",  "itemlist",      "likeop",        "escape",      
  "between_op",    "in_op",         "case_operand",  "case_exprlist",
  "case_else",     "expritem",      "uniqueflag",    "idxitem",     
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 144 */ "sortlist ::= sortitem collate sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "collate ::=",
 /* 150 */ "collate ::= COLLATE id",
 /* 151 */ "groupby_opt ::=",
 /* 152 */ "groupby_opt ::= GROUP BY exprlist",
 /* 153 */ "having_opt ::=",
 /* 154 */ "having_opt ::= HAVING expr",
 /* 155 */ "limit_opt ::=",
 /* 156 */ "limit_opt ::= LIMIT expr",
 /* 157 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 158 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 159 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 160 */ "where_opt ::=",
 /* 161 */ "where_opt ::= WHERE expr",
 /* 162 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 163 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 164 */ "setlist ::= nm EQ expr",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 167 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 168 */ "insert_cmd ::= INSERT orconf",
 /* 169 */ "insert_cmd ::= REPLACE",
 /* 170 */ "itemlist ::= itemlist COMMA expr",
 /* 171 */ "itemlist ::= expr",
 /* 172 */ "inscollist_opt ::=",
 /* 173 */ "inscollist_opt ::= LP inscollist RP",
 /* 174 */ "inscollist ::= inscollist COMMA nm",
 /* 175 */ "inscollist ::= nm",
 /* 176 */ "expr ::= term",
 /* 177 */ "expr ::= LP expr RP",
 /* 178 */ "term ::= NULL",
 /* 179 */ "expr ::= ID",
 /* 180 */ "expr ::= JOIN_KW",
 /* 181 */ "expr ::= nm DOT nm",
 /* 182 */ "expr ::= nm DOT nm DOT nm",
 /* 183 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 184 */ "term ::= STRING",
 /* 185 */ "expr ::= REGISTER",
 /* 186 */ "expr ::= VARIABLE",
 /* 187 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 188 */ "expr ::= ID LP distinct exprlist RP",
 /* 189 */ "expr ::= ID LP STAR RP",
 /* 190 */ "term ::= CTIME_KW",
 /* 191 */ "expr ::= expr AND expr",
 /* 192 */ "expr ::= expr OR expr",
 /* 193 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 194 */ "expr ::= expr EQ|NE expr",
 /* 195 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 196 */ "expr ::= expr PLUS|MINUS expr",
 /* 197 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 198 */ "expr ::= expr CONCAT expr",
 /* 199 */ "likeop ::= LIKE_KW",
 /* 200 */ "likeop ::= NOT LIKE_KW",
 /* 201 */ "likeop ::= MATCH",
 /* 202 */ "likeop ::= NOT MATCH",
 /* 203 */ "escape ::= ESCAPE expr",
 /* 204 */ "escape ::=",
 /* 205 */ "expr ::= expr likeop expr escape",
 /* 206 */ "expr ::= expr ISNULL|NOTNULL",
 /* 207 */ "expr ::= expr IS NULL",
 /* 208 */ "expr ::= expr NOT NULL",
 /* 209 */ "expr ::= expr IS NOT NULL",
 /* 210 */ "expr ::= NOT|BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= exprlist COMMA expritem",
 /* 231 */ "exprlist ::= expritem",
 /* 232 */ "expritem ::= expr",
 /* 233 */ "expritem ::=",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 243 */ "cmd ::= VACUUM",
 /* 244 */ "cmd ::= VACUUM nm",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 249 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 250 */ "cmd ::= PRAGMA nm dbnm",
 /* 251 */ "plus_num ::= plus_opt number",
 /* 252 */ "minus_num ::= MINUS number",
 /* 253 */ "number ::= INTEGER|FLOAT",
 /* 254 */ "plus_opt ::= PLUS",
 /* 255 */ "plus_opt ::=",
 /* 256 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 257 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 258 */ "trigger_time ::= BEFORE",
 /* 259 */ "trigger_time ::= AFTER",
 /* 260 */ "trigger_time ::= INSTEAD OF",
 /* 261 */ "trigger_time ::=",
 /* 262 */ "trigger_event ::= DELETE|INSERT",
 /* 263 */ "trigger_event ::= UPDATE",
 /* 264 */ "trigger_event ::= UPDATE OF inscollist",
 /* 265 */ "foreach_clause ::=",
 /* 266 */ "foreach_clause ::= FOR EACH ROW",
 /* 267 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 268 */ "when_clause ::=",
 /* 269 */ "when_clause ::= WHEN expr",
 /* 270 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 271 */ "trigger_cmd_list ::=",
 /* 272 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 273 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 274 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 275 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 276 */ "trigger_cmd ::= select",
 /* 277 */ "expr ::= RAISE LP IGNORE RP",
 /* 278 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 279 */ "raisetype ::= ROLLBACK",
 /* 280 */ "raisetype ::= ABORT",
 /* 281 */ "raisetype ::= FAIL",
 /* 282 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 283 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 284 */ "key_opt ::=",
 /* 285 */ "key_opt ::= KEY expr",
 /* 286 */ "database_kw_opt ::= DATABASE",
 /* 287 */ "database_kw_opt ::=",
 /* 288 */ "cmd ::= DETACH database_kw_opt expr",
 /* 289 */ "cmd ::= REINDEX",
 /* 290 */ "cmd ::= REINDEX nm dbnm",
 /* 291 */ "cmd ::= ANALYZE",
 /* 292 */ "cmd ::= ANALYZE nm dbnm",
 /* 293 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 294 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 295 */ "add_column_fullname ::= fullname",
 /* 296 */ "kwcolumn_opt ::=",
 /* 297 */ "kwcolumn_opt ::= COLUMNKW",
 /* 298 */ "cmd ::= create_vtab",
 /* 299 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 300 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 301 */ "vtabarglist ::= vtabarg",
 /* 302 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 303 */ "vtabarg ::=",
 /* 304 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 305 */ "vtabargtoken ::= ANY",
 /* 306 */ "vtabargtoken ::= lp anylist RP",
 /* 307 */ "lp ::= LP",
 /* 308 */ "anylist ::=",
 /* 309 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 156:
    case 190:
    case 207:
#line 374 "parse.y"
{sqlite3SelectDelete((yypminor->yy219));}
#line 1249 "parse.c"
      break;
    case 170:
    case 171:
    case 195:
    case 197:
    case 205:
    case 211:
    case 219:
    case 222:
    case 224:
    case 225:
    case 235:
#line 618 "parse.y"
{sqlite3ExprDelete((yypminor->yy172));}
#line 1264 "parse.c"
      break;
    case 175:
    case 183:
    case 193:
    case 196:
    case 198:
    case 200:
    case 210:
    case 213:
    case 214:
    case 217:
    case 223:
#line 855 "parse.y"
{sqlite3ExprListDelete((yypminor->yy174));}
#line 1279 "parse.c"
      break;
    case 189:
    case 194:
    case 202:
    case 203:
#line 487 "parse.y"
{sqlite3SrcListDelete((yypminor->yy373));}
#line 1287 "parse.c"
      break;
    case 199:
#line 548 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy234).pLimit);
  sqlite3ExprDelete((yypminor->yy234).pOffset);
}
#line 1295 "parse.c"
      break;
    case 206:
    case 209:
    case 216:
#line 504 "parse.y"
{sqlite3IdListDelete((yypminor->yy432));}
#line 1302 "parse.c"
      break;
    case 231:
    case 236:
#line 951 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy243));}
#line 1308 "parse.c"
      break;
    case 233:
#line 935 "parse.y"
{sqlite3IdListDelete((yypminor->yy370).b);}
#line 1313 "parse.c"
      break;
    case 238:
#line 1019 "parse.y"
{sqlite3ExprDelete((yypminor->yy386));}
#line 1318 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1487 "parse.c"
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 140, 1 },
  { 141, 2 },
  { 141, 1 },
  { 143, 1 },
  { 142, 1 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 146, 0 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 149, 6 },
  { 152, 0 },
  { 152, 3 },
  { 151, 1 },
  { 151, 0 },
  { 150, 4 },
  { 150, 2 },
  { 154, 3 },
  { 154, 1 },
  { 157, 3 },
  { 158, 1 },
  { 161, 1 },
  { 162, 1 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 159, 0 },
  { 159, 1 },
  { 163, 1 },
  { 163, 4 },
  { 163, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 160, 2 },
  { 160, 0 },
  { 168, 3 },
  { 168, 1 },
  { 169, 2 },
  { 169, 4 },
  { 169, 3 },
  { 169, 3 },
  { 169, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 4 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 174, 0 },
  { 174, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 155, 0 },
  { 155, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 5 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 172, 0 },
  { 172, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 144, 4 },
  { 188, 2 },
  { 188, 0 },
  { 144, 8 },
  { 144, 4 },
  { 144, 1 },
  { 156, 1 },
  { 156, 3 },
  { 191, 1 },
  { 191, 2 },
  { 191, 1 },
  { 190, 9 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 200, 2 },
  { 200, 0 },
  { 193, 3 },
  { 193, 2 },
  { 193, 4 },
  { 201, 2 },
  { 201, 1 },
  { 201, 0 },
  { 194, 0 },
  { 194, 2 },
  { 203, 2 },
  { 203, 0 },
  { 202, 6 },
  { 202, 7 },
  { 207, 1 },
  { 207, 1 },
  { 153, 0 },
  { 153, 2 },
  { 189, 2 },
  { 204, 1 },
  { 204, 2 },
  { 204, 3 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 206, 4 },
  { 206, 0 },
  { 198, 0 },
  { 198, 3 },
  { 210, 5 },
  { 210, 3 },
  { 211, 1 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 212, 0 },
  { 212, 2 },
  { 196, 0 },
  { 196, 3 },
  { 197, 0 },
  { 197, 2 },
  { 199, 0 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 144, 4 },
  { 195, 0 },
  { 195, 2 },
  { 144, 6 },
  { 214, 5 },
  { 214, 3 },
  { 144, 8 },
  { 144, 5 },
  { 144, 6 },
  { 215, 2 },
  { 215, 1 },
  { 217, 3 },
  { 217, 1 },
  { 216, 0 },
  { 216, 3 },
  { 209, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 3 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
  { 170, 1 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 6 },
  { 171, 5 },
  { 171, 4 },
  { 170, 1 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 218, 1 },
  { 218, 2 },
  { 218, 1 },
  { 218, 2 },
  { 219, 2 },
  { 219, 0 },
  { 171, 4 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 220, 1 },
  { 220, 2 },
  { 171, 5 },
  { 221, 1 },
  { 221, 2 },
  { 171, 5 },
  { 171, 3 },
  { 171, 5 },
  { 171, 4 },
  { 171, 4 },
  { 171, 5 },
  { 223, 5 },
  { 223, 4 },
  { 224, 2 },
  { 224, 0 },
  { 222, 1 },
  { 222, 0 },
  { 213, 3 },
  { 213, 1 },
  { 225, 1 },
  { 225, 0 },
  { 144, 11 },
  { 226, 1 },
  { 226, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 227, 1 },
  { 144, 4 },
  { 144, 1 },
  { 144, 2 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 6 },
  { 144, 3 },
  { 166, 2 },
  { 167, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 144, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 171, 4 },
  { 171, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 144, 4 },
  { 144, 6 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 6 },
  { 144, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 144, 1 },
  { 144, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1875 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1880 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1885 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1890 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 1895 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy46 = TK_DEFERRED;}
#line 1900 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 1909 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1915 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1920 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 1927 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 213:
      case 216:
#line 132 "parse.y"
{yygotominor.yy46 = 0;}
#line 1942 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 214:
      case 217:
#line 133 "parse.y"
{yygotominor.yy46 = 1;}
#line 1954 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy0,0);
}
#line 1961 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 1969 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy410.z = yymsp[-2].minor.yy410.z;
  yygotominor.yy410.n = (pParse->sLastToken.z-yymsp[-2].minor.yy410.z) + pParse->sLastToken.n;
}
#line 1977 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy410);
  yygotominor.yy410 = yymsp[0].minor.yy410;
}
#line 1985 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 253:
#line 168 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy0;}
#line 1995 "parse.c"
        break;
      case 38:
#line 228 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy410);}
#line 2000 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 150:
      case 241:
      case 251:
      case 252:
#line 229 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy410;}
#line 2013 "parse.c"
        break;
      case 40:
#line 230 "parse.y"
{
  yygotominor.yy410.z = yymsp[-3].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy410.z;
}
#line 2021 "parse.c"
        break;
      case 41:
#line 234 "parse.y"
{
  yygotominor.yy410.z = yymsp[-5].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy410.z;
}
#line 2029 "parse.c"
        break;
      case 43:
#line 240 "parse.y"
{yygotominor.yy410.z=yymsp[-1].minor.yy410.z; yygotominor.yy410.n=yymsp[0].minor.yy410.n+(yymsp[0].minor.yy410.z-yymsp[-1].minor.yy410.z);}
#line 2034 "parse.c"
        break;
      case 44:
#line 242 "parse.y"
{ yygotominor.yy46 = atoi((char*)yymsp[0].minor.yy410.z); }
#line 2039 "parse.c"
        break;
      case 45:
#line 243 "parse.y"
{ yygotominor.yy46 = -atoi((char*)yymsp[0].minor.yy410.z); }
#line 2044 "parse.c"
        break;
      case 50:
      case 52:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2050 "parse.c"
        break;
      case 51:
#line 253 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2055 "parse.c"
        break;
      case 53:
#line 255 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2063 "parse.c"
        break;
      case 54:
#line 259 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy410);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2071 "parse.c"
        break;
      case 56:
#line 268 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2076 "parse.c"
        break;
      case 57:
#line 270 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2081 "parse.c"
        break;
      case 58:
#line 271 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2086 "parse.c"
        break;
      case 59:
#line 272 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2091 "parse.c"
        break;
      case 60:
#line 274 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy410,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2096 "parse.c"
        break;
      case 61:
#line 275 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2101 "parse.c"
        break;
      case 62:
#line 276 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy410.z, yymsp[0].minor.yy410.n);}
#line 2106 "parse.c"
        break;
      case 65:
#line 289 "parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2111 "parse.c"
        break;
      case 66:
#line 290 "parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2116 "parse.c"
        break;
      case 67:
#line 292 "parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2121 "parse.c"
        break;
      case 68:
#line 293 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2126 "parse.c"
        break;
      case 69:
#line 294 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2131 "parse.c"
        break;
      case 70:
#line 295 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2136 "parse.c"
        break;
      case 71:
#line 297 "parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2141 "parse.c"
        break;
      case 72:
#line 298 "parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2146 "parse.c"
        break;
      case 73:
#line 299 "parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2151 "parse.c"
        break;
      case 74:
#line 300 "parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2156 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 168:
#line 302 "parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2167 "parse.c"
        break;
      case 80:
#line 312 "parse.y"
{yygotominor.yy410.n = 0; yygotominor.yy410.z = 0;}
#line 2172 "parse.c"
        break;
      case 81:
#line 313 "parse.y"
{yygotominor.yy410 = yymsp[-1].minor.yy0;}
#line 2177 "parse.c"
        break;
      case 86:
#line 319 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2182 "parse.c"
        break;
      case 87:
#line 321 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2187 "parse.c"
        break;
      case 88:
#line 322 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2192 "parse.c"
        break;
      case 89:
#line 324 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy410, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2200 "parse.c"
        break;
      case 92:
      case 94:
#line 338 "parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2206 "parse.c"
        break;
      case 97:
#line 343 "parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2211 "parse.c"
        break;
      case 98:
      case 169:
#line 344 "parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2217 "parse.c"
        break;
      case 99:
#line 348 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2224 "parse.c"
        break;
      case 102:
#line 358 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, yymsp[0].minor.yy219, yymsp[-6].minor.yy46, yymsp[-4].minor.yy46);
}
#line 2231 "parse.c"
        break;
      case 103:
#line 361 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2238 "parse.c"
        break;
      case 104:
#line 368 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy219, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2246 "parse.c"
        break;
      case 105:
      case 128:
#line 378 "parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2252 "parse.c"
        break;
      case 106:
#line 380 "parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2263 "parse.c"
        break;
      case 108:
#line 389 "parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2268 "parse.c"
        break;
      case 110:
#line 393 "parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2275 "parse.c"
        break;
      case 114:
      case 238:
#line 414 "parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2281 "parse.c"
        break;
      case 115:
      case 141:
      case 151:
      case 237:
#line 415 "parse.y"
{yygotominor.yy174 = 0;}
#line 2289 "parse.c"
        break;
      case 116:
#line 416 "parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy410.n?&yymsp[0].minor.yy410:0);
}
#line 2296 "parse.c"
        break;
      case 117:
#line 419 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-1].minor.yy174, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2303 "parse.c"
        break;
      case 118:
#line 422 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-3].minor.yy174, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2312 "parse.c"
        break;
      case 121:
#line 434 "parse.y"
{yygotominor.yy410.n = 0;}
#line 2317 "parse.c"
        break;
      case 122:
#line 446 "parse.y"
{yygotominor.yy373 = sqliteMalloc(sizeof(*yygotominor.yy373));}
#line 2322 "parse.c"
        break;
      case 123:
#line 447 "parse.y"
{
  yygotominor.yy373 = yymsp[0].minor.yy373;
  sqlite3SrcListShiftJoinType(yygotominor.yy373);
}
#line 2330 "parse.c"
        break;
      case 124:
#line 455 "parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2338 "parse.c"
        break;
      case 125:
#line 459 "parse.y"
{yygotominor.yy373 = 0;}
#line 2343 "parse.c"
        break;
      case 126:
#line 460 "parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppendFromTerm(yymsp[-5].minor.yy373,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,0,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
}
#line 2350 "parse.c"
        break;
      case 127:
#line 465 "parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppendFromTerm(yymsp[-6].minor.yy373,0,0,&yymsp[-2].minor.yy410,yymsp[-4].minor.yy219,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
  }
#line 2357 "parse.c"
        break;
      case 129:
#line 476 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy373);
     yygotominor.yy219 = sqlite3SelectNew(0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2365 "parse.c"
        break;
      case 130:
#line 483 "parse.y"
{yygotominor.yy410.z=0; yygotominor.yy410.n=0;}
#line 2370 "parse.c"
        break;
      case 132:
#line 488 "parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);}
#line 2375 "parse.c"
        break;
      case 133:
#line 492 "parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2380 "parse.c"
        break;
      case 134:
#line 493 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2385 "parse.c"
        break;
      case 135:
#line 494 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy410,0); }
#line 2390 "parse.c"
        break;
      case 136:
#line 496 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy410,&yymsp[-1].minor.yy410); }
#line 2395 "parse.c"
        break;
      case 137:
      case 145:
      case 154:
      case 161:
      case 176:
      case 203:
      case 226:
      case 228:
      case 232:
#line 500 "parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2408 "parse.c"
        break;
      case 138:
      case 153:
      case 160:
      case 204:
      case 227:
      case 229:
      case 233:
#line 501 "parse.y"
{yygotominor.yy172 = 0;}
#line 2419 "parse.c"
        break;
      case 139:
      case 173:
#line 505 "parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2425 "parse.c"
        break;
      case 140:
      case 172:
#line 506 "parse.y"
{yygotominor.yy432 = 0;}
#line 2431 "parse.c"
        break;
      case 142:
      case 152:
#line 517 "parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2437 "parse.c"
        break;
      case 143:
#line 518 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy410.n>0?&yymsp[-1].minor.yy410:0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2445 "parse.c"
        break;
      case 144:
#line 522 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy172,yymsp[-1].minor.yy410.n>0?&yymsp[-1].minor.yy410:0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2453 "parse.c"
        break;
      case 146:
      case 148:
#line 531 "parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2459 "parse.c"
        break;
      case 147:
#line 532 "parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2464 "parse.c"
        break;
      case 149:
#line 534 "parse.y"
{yygotominor.yy410.z = 0; yygotominor.yy410.n = 0;}
#line 2469 "parse.c"
        break;
      case 155:
#line 552 "parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2474 "parse.c"
        break;
      case 156:
#line 553 "parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2479 "parse.c"
        break;
      case 157:
#line 555 "parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2484 "parse.c"
        break;
      case 158:
#line 557 "parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2489 "parse.c"
        break;
      case 159:
#line 561 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2494 "parse.c"
        break;
      case 162:
#line 572 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);}
#line 2499 "parse.c"
        break;
      case 163:
#line 578 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2504 "parse.c"
        break;
      case 164:
#line 579 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2509 "parse.c"
        break;
      case 165:
#line 585 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2514 "parse.c"
        break;
      case 166:
#line 587 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2519 "parse.c"
        break;
      case 167:
#line 589 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy373, 0, 0, yymsp[-2].minor.yy432, yymsp[-5].minor.yy46);}
#line 2524 "parse.c"
        break;
      case 170:
      case 230:
#line 599 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2530 "parse.c"
        break;
      case 171:
      case 231:
#line 600 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,0);}
#line 2536 "parse.c"
        break;
      case 174:
#line 609 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(yymsp[-2].minor.yy432,&yymsp[0].minor.yy410);}
#line 2541 "parse.c"
        break;
      case 175:
#line 610 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(0,&yymsp[0].minor.yy410);}
#line 2546 "parse.c"
        break;
      case 177:
#line 621 "parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2551 "parse.c"
        break;
      case 178:
      case 183:
      case 184:
#line 622 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2558 "parse.c"
        break;
      case 179:
      case 180:
#line 623 "parse.y"
{yygotominor.yy172 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2564 "parse.c"
        break;
      case 181:
#line 625 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2573 "parse.c"
        break;
      case 182:
#line 630 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2584 "parse.c"
        break;
      case 185:
#line 639 "parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2589 "parse.c"
        break;
      case 186:
#line 640 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2598 "parse.c"
        break;
      case 187:
#line 646 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy410);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2606 "parse.c"
        break;
      case 188:
#line 651 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2617 "parse.c"
        break;
      case 189:
#line 658 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2625 "parse.c"
        break;
      case 190:
#line 662 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->op = TK_CONST_FUNC;  
    yygotominor.yy172->span = yymsp[0].minor.yy0;
  }
}
#line 2638 "parse.c"
        break;
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
#line 671 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy172, yymsp[0].minor.yy172, 0);}
#line 2650 "parse.c"
        break;
      case 199:
      case 201:
#line 681 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 0;}
#line 2656 "parse.c"
        break;
      case 200:
      case 202:
#line 682 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 1;}
#line 2662 "parse.c"
        break;
      case 205:
#line 689 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.not ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2678 "parse.c"
        break;
      case 206:
#line 702 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2686 "parse.c"
        break;
      case 207:
#line 706 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2694 "parse.c"
        break;
      case 208:
#line 710 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2702 "parse.c"
        break;
      case 209:
#line 714 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2710 "parse.c"
        break;
      case 210:
#line 718 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2718 "parse.c"
        break;
      case 211:
#line 722 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2726 "parse.c"
        break;
      case 212:
#line 726 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2734 "parse.c"
        break;
      case 215:
#line 733 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 2750 "parse.c"
        break;
      case 218:
#line 749 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2764 "parse.c"
        break;
      case 219:
#line 759 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2777 "parse.c"
        break;
      case 220:
#line 768 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2791 "parse.c"
        break;
      case 221:
#line 778 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy410.z?&yymsp[0].minor.yy410:&yymsp[-1].minor.yy410);
  }
#line 2806 "parse.c"
        break;
      case 222:
#line 789 "parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
  }
#line 2819 "parse.c"
        break;
      case 223:
#line 801 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2832 "parse.c"
        break;
      case 224:
#line 812 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2840 "parse.c"
        break;
      case 225:
#line 816 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2848 "parse.c"
        break;
      case 234:
#line 843 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy410, &yymsp[-5].minor.yy410, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy410,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 2856 "parse.c"
        break;
      case 235:
      case 280:
#line 849 "parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 2862 "parse.c"
        break;
      case 236:
#line 850 "parse.y"
{yygotominor.yy46 = OE_None;}
#line 2867 "parse.c"
        break;
      case 239:
#line 860 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy410);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2880 "parse.c"
        break;
      case 240:
#line 869 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy410);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2893 "parse.c"
        break;
      case 242:
#line 883 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 2898 "parse.c"
        break;
      case 243:
      case 244:
#line 888 "parse.y"
{sqlite3Vacuum(pParse);}
#line 2904 "parse.c"
        break;
      case 245:
      case 247:
#line 895 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,0);}
#line 2910 "parse.c"
        break;
      case 246:
#line 896 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy0,0);}
#line 2915 "parse.c"
        break;
      case 248:
#line 898 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,1);
}
#line 2922 "parse.c"
        break;
      case 249:
#line 901 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-1].minor.yy410,0);}
#line 2927 "parse.c"
        break;
      case 250:
#line 902 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,0,0);}
#line 2932 "parse.c"
        break;
      case 256:
#line 914 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy410.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy410.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 2942 "parse.c"
        break;
      case 257:
#line 923 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy410, &yymsp[-6].minor.yy410, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[-1].minor.yy46, yymsp[0].minor.yy172, yymsp[-10].minor.yy46, yymsp[-8].minor.yy46);
  yygotominor.yy410 = (yymsp[-6].minor.yy410.n==0?yymsp[-7].minor.yy410:yymsp[-6].minor.yy410);
}
#line 2950 "parse.c"
        break;
      case 258:
      case 261:
#line 929 "parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 2956 "parse.c"
        break;
      case 259:
#line 930 "parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 2961 "parse.c"
        break;
      case 260:
#line 931 "parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 2966 "parse.c"
        break;
      case 262:
      case 263:
#line 936 "parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 2972 "parse.c"
        break;
      case 264:
#line 938 "parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 2977 "parse.c"
        break;
      case 265:
      case 266:
#line 941 "parse.y"
{ yygotominor.yy46 = TK_ROW; }
#line 2983 "parse.c"
        break;
      case 267:
#line 943 "parse.y"
{ yygotominor.yy46 = TK_STATEMENT; }
#line 2988 "parse.c"
        break;
      case 268:
#line 947 "parse.y"
{ yygotominor.yy172 = 0; }
#line 2993 "parse.c"
        break;
      case 269:
#line 948 "parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 2998 "parse.c"
        break;
      case 270:
#line 952 "parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3011 "parse.c"
        break;
      case 271:
#line 961 "parse.y"
{ yygotominor.yy243 = 0; }
#line 3016 "parse.c"
        break;
      case 272:
#line 967 "parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy410, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3021 "parse.c"
        break;
      case 273:
#line 972 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy410, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3026 "parse.c"
        break;
      case 274:
#line 975 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy410, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3031 "parse.c"
        break;
      case 275:
#line 979 "parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy410, yymsp[0].minor.yy172);}
#line 3036 "parse.c"
        break;
      case 276:
#line 982 "parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(yymsp[0].minor.yy219); }
#line 3041 "parse.c"
        break;
      case 277:
#line 985 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3052 "parse.c"
        break;
      case 278:
#line 992 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy410); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3063 "parse.c"
        break;
      case 279:
#line 1002 "parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3068 "parse.c"
        break;
      case 281:
#line 1004 "parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3073 "parse.c"
        break;
      case 282:
#line 1009 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373,yymsp[-1].minor.yy46);
}
#line 3080 "parse.c"
        break;
      case 283:
#line 1015 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy386);
}
#line 3087 "parse.c"
        break;
      case 284:
#line 1020 "parse.y"
{ yygotominor.yy386 = 0; }
#line 3092 "parse.c"
        break;
      case 285:
#line 1021 "parse.y"
{ yygotominor.yy386 = yymsp[0].minor.yy172; }
#line 3097 "parse.c"
        break;
      case 288:
#line 1027 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3104 "parse.c"
        break;
      case 289:
#line 1033 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3109 "parse.c"
        break;
      case 290:
#line 1034 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3114 "parse.c"
        break;
      case 291:
#line 1039 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3119 "parse.c"
        break;
      case 292:
#line 1040 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3124 "parse.c"
        break;
      case 293:
#line 1045 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy410);
}
#line 3131 "parse.c"
        break;
      case 294:
#line 1048 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy410);
}
#line 3138 "parse.c"
        break;
      case 295:
#line 1051 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3145 "parse.c"
        break;
      case 298:
#line 1060 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3150 "parse.c"
        break;
      case 299:
#line 1061 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3155 "parse.c"
        break;
      case 300:
#line 1062 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, &yymsp[0].minor.yy410);
}
#line 3162 "parse.c"
        break;
      case 303:
#line 1067 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3167 "parse.c"
        break;
      case 305:
      case 306:
      case 307:
      case 309:
#line 1069 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3175 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3243 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
