#line 2 "lexer.c"

#line 4 "lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE gda_delimiterrestart(gda_delimiterin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int gda_delimiterleng;

extern FILE *gda_delimiterin, *gda_delimiterout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE gda_delimiterlex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-gda_delimiterlineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < gda_delimiterleng; ++yyl )\
                    if ( gda_delimitertext[yyl] == '\n' )\
                        --gda_delimiterlineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up gda_delimitertext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up gda_delimitertext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via gda_delimiterrestart()), so that the user can continue scanning by
	 * just pointing gda_delimiterin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when gda_delimitertext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int gda_delimiterleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow gda_delimiterwrap()'s to do buffer switches
 * instead of setting up a fresh gda_delimiterin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void gda_delimiterrestart (FILE *input_file  );
void gda_delimiter_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE gda_delimiter_create_buffer (FILE *file,int size  );
void gda_delimiter_delete_buffer (YY_BUFFER_STATE b  );
void gda_delimiter_flush_buffer (YY_BUFFER_STATE b  );
void gda_delimiterpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void gda_delimiterpop_buffer_state (void );

static void gda_delimiterensure_buffer_stack (void );
static void gda_delimiter_load_buffer_state (void );
static void gda_delimiter_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER gda_delimiter_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE gda_delimiter_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE gda_delimiter_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE gda_delimiter_scan_bytes (yyconst char *bytes,int len  );

void *gda_delimiteralloc (yy_size_t  );
void *gda_delimiterrealloc (void *,yy_size_t  );
void gda_delimiterfree (void *  );

#define yy_new_buffer gda_delimiter_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        gda_delimiterensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            gda_delimiter_create_buffer(gda_delimiterin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        gda_delimiterensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            gda_delimiter_create_buffer(gda_delimiterin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define gda_delimiterwrap() 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *gda_delimiterin = (FILE *) 0, *gda_delimiterout = (FILE *) 0;

typedef int yy_state_type;

extern int gda_delimiterlineno;

int gda_delimiterlineno = 1;

extern char *gda_delimitertext;
#define yytext_ptr gda_delimitertext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up gda_delimitertext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	gda_delimiterleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 38
#define YY_END_OF_BUFFER 39
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_acclist[119] =
    {   0,
       39,   37,   38,   35,   37,   38,   34,   38,   36,   37,
       38,   29,   37,   38,   37,   38,   37,   38,   22,   37,
       38,   37,   38,   37,   38,    1,   37,   38,   37,   38,
       37,   38,   37,   38,   37,   38,   28,   38,   27,   38,
       28,   38,   24,   28,   38,   28,   38,   33,   38,   32,
       38,   30,   33,   38,   38,   18,   38,   20,   38,   19,
       38,   38,   17,   38,   17,   38,   17,   38,   17,   38,
       17,   38,   26,   28,   38,   31,   33,   38,    2,   21,
        3,    7,   25,   23,   11,   17,   17,   17,   17,   17,
       17,   10,   17,   17,   17,   17,   17,    9,   17,   17,

       17,   17,   17,    8,   17,   17,   12,   17,   14,   13,
       17,   17,    4,    6,   17,   16,   15,    5
    } ;

static yyconst flex_int16_t yy_accept[118] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    2,    4,    7,    9,   12,   15,   17,
       19,   22,   24,   26,   29,   31,   33,   35,   37,   39,
       41,   43,   46,   48,   50,   52,   55,   56,   58,   60,
       62,   63,   65,   67,   69,   71,   73,   76,   79,   79,
       79,   79,   80,   81,   81,   81,   82,   82,   82,   82,
       83,   84,   84,   85,   86,   87,   88,   89,   90,   91,
       92,   92,   93,   93,   93,   93,   93,   94,   95,   96,
       97,   98,   98,   98,   99,   99,  100,  101,  102,  103,
      104,  105,  105,  105,  105,  106,  107,  108,  109,  110,

      110,  110,  110,  111,  112,  113,  114,  114,  115,  116,
      117,  117,  118,  118,  118,  119,  119
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    1,    6,    7,    8,    1,    1,    9,    1,
        1,   10,   11,    1,   12,    1,   13,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   15,   16,    1,
        1,    1,    1,    1,   18,   19,   20,   21,   22,   14,
       23,   14,   24,   14,   25,   26,   27,   28,   29,   30,
       14,   31,   32,   33,   34,   14,   14,   14,   35,   14,
        1,   17,    1,    1,   14,    1,   18,   19,   20,   21,

       22,   14,   23,   14,   24,   14,   25,   26,   27,   28,
       29,   30,   14,   31,   32,   33,   34,   14,   14,   14,
       35,   14,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[36] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    2,    1,    1,
        3,    4,    1,    4,    1,    1,    1,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4
    } ;

static yyconst flex_int16_t yy_base[124] =
    {   0,
        0,   23,   40,   43,    8,   12,   60,    0,   24,   93,
       14,   31,  189,  190,  190,  190,   92,  190,  181,  179,
      190,  174,  175,  190,  162,  161,  154,  149,  190,  190,
      172,  190,  170,  190,  190,  190,  190,  190,  190,  190,
      165,    0,  155,  144,   20,  140,  190,  190,   93,  167,
      163,  190,  190,  164,  168,  190,  147,  149,  147,   48,
      190,  159,  190,  190,    0,  134,  135,  137,  137,  132,
      158,  190,  136,  126,  133,   99,  114,  115,  110,  105,
      108,  101,  110,  190,   74,   95,   94,  109,   94,  107,
      190,   90,   87,   93,  103,   99,  190,   91,  190,   93,

       53,   88,  190,   86,   96,  190,  107,  190,   92,  190,
       25,  190,   30,   14,  190,  190,  135,  139,  143,  146,
      149,  151,  155
    } ;

static yyconst flex_int16_t yy_def[124] =
    {   0,
      117,  117,  118,  118,  119,  119,  116,    7,  118,  118,
      119,  119,  116,  116,  116,  116,  116,  116,  116,  120,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      121,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  122,  122,  122,  122,  122,  116,  116,  116,  116,
      116,  116,  116,  120,  123,  116,  116,  116,  116,  116,
      116,  121,  116,  116,  122,  122,  122,  122,  122,  122,
      123,  116,  116,  116,  116,  116,  122,  122,  122,  122,
      122,  116,  116,  116,  116,  122,  122,  122,  122,  122,
      116,  116,  116,  116,  122,  122,  116,  122,  116,  116,

      116,  116,  116,  122,  122,  116,  116,  116,  122,  116,
      116,  116,  116,  116,  116,    0,  116,  116,  116,  116,
      116,  116,  116
    } ;

static yyconst flex_int16_t yy_nxt[226] =
    {   0,
      116,   15,   16,  116,   17,   18,   19,   20,   21,  116,
       35,   22,   23,   36,   35,   24,   35,   36,   25,   48,
       26,   27,  116,   28,   15,   16,   30,   17,   18,   19,
       20,   21,   47,   35,   22,   23,   48,   68,   24,  115,
       33,   25,   30,   26,   27,   30,   28,   31,   32,   76,
       31,   32,   76,   69,  107,  114,   33,  107,  113,   33,
       37,   38,   38,   38,   38,   39,   37,   37,   40,   41,
       42,   42,   37,   42,   37,   37,   37,   42,   42,   42,
       43,   42,   42,   44,   42,   42,   42,   45,   42,   42,
       42,   42,   46,   42,   42,   30,   49,   49,   50,   50,

       76,   47,   93,   76,   51,   51,  112,   94,  107,   33,
      110,  107,  109,  108,  106,  105,  104,  103,  102,  101,
      100,   99,   98,   97,   96,   95,   85,   92,   91,   90,
       89,   88,   87,   86,  111,   14,   14,   14,   14,   29,
       29,   29,   29,   34,   34,   34,   34,   54,   84,   54,
       62,   83,   62,   65,   65,   71,   71,   71,   71,   82,
       72,   81,   80,   79,   78,   77,   61,   75,   74,   73,
       72,   53,   56,   52,   70,   67,   66,   64,   63,   61,
       60,   59,   58,   57,   56,   55,   53,   52,  116,   13,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,

      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116
    } ;

static yyconst flex_int16_t yy_chk[226] =
    {   0,
        0,    1,    1,    0,    1,    1,    1,    1,    1,    0,
        5,    1,    1,    5,    6,    1,   11,    6,    1,   11,
        1,    1,    0,    1,    2,    2,    9,    2,    2,    2,
        2,    2,    9,   12,    2,    2,   12,   45,    2,  114,
        9,    2,    3,    2,    2,    4,    2,    3,    3,   60,
        4,    4,   60,   45,  101,  113,    3,  101,  111,    4,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,   10,   17,   49,   17,   49,

       76,   10,   85,   76,   17,   49,  109,   85,  107,   10,
      105,  107,  104,  102,  100,   98,   96,   95,   94,   93,
       92,   90,   89,   88,   87,   86,   76,   83,   82,   81,
       80,   79,   78,   77,  107,  117,  117,  117,  117,  118,
      118,  118,  118,  119,  119,  119,  119,  120,   75,  120,
      121,   74,  121,  122,  122,  123,  123,  123,  123,   73,
       71,   70,   69,   68,   67,   66,   62,   59,   58,   57,
       55,   54,   51,   50,   46,   44,   43,   41,   33,   31,
       28,   27,   26,   25,   23,   22,   20,   19,   13,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,

      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[39] =
    {   0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0,     };

extern int gda_delimiter_flex_debug;
int gda_delimiter_flex_debug = 0;

static yy_state_type *yy_state_buf=0, *yy_state_ptr=0;
static char *yy_full_match;
static int yy_lp;
#define REJECT \
{ \
*yy_cp = (yy_hold_char); /* undo effects of setting up gda_delimitertext */ \
yy_cp = (yy_full_match); /* restore poss. backed-over text */ \
++(yy_lp); \
goto find_rule; \
}

#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *gda_delimitertext;
#line 1 "lexer.l"
#line 2 "lexer.l"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <glib.h>
#include <glib/gi18n-lib.h>

#include "gda-sql-delimiter.h"

/* can conflict with L_SET defined in /usr/include/unistd.h */
#ifdef L_SET
#undef L_SET
#endif

#include "parser.h"

static GString *gstring;
static gint gda_delimiter_bloc_level;
static gboolean is_start = TRUE;
static gboolean ignore_next = FALSE;
static gchar *string_delim;
static gboolean can_use_is = TRUE;

void 
gda_delimiter_lex_reset ()
{
	is_start = TRUE;
	ignore_next = FALSE;
	gda_delimiter_bloc_level = 0;
	can_use_is = TRUE;
}






#line 624 "lexer.c"

#define INITIAL 0
#define STRING 1
#define TEXTUAL 2
#define PSPEC 3
#define PSTRING 4
#define PTEXTUAL 5

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int gda_delimiterwrap (void );
#else
extern int gda_delimiterwrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( gda_delimitertext, gda_delimiterleng, 1, gda_delimiterout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( gda_delimiterin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( gda_delimiterin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, gda_delimiterin))==0 && ferror(gda_delimiterin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(gda_delimiterin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int gda_delimiterlex (void);

#define YY_DECL int gda_delimiterlex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after gda_delimitertext and gda_delimiterleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 45 "lexer.l"


#line 785 "lexer.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

        /* Create the reject buffer large enough to save one state per allowed character. */
        if ( ! (yy_state_buf) )
            (yy_state_buf) = (yy_state_type *)gda_delimiteralloc(YY_STATE_BUF_SIZE  );

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! gda_delimiterin )
			gda_delimiterin = stdin;

		if ( ! gda_delimiterout )
			gda_delimiterout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			gda_delimiterensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				gda_delimiter_create_buffer(gda_delimiterin,YY_BUF_SIZE );
		}

		gda_delimiter_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of gda_delimitertext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);

		(yy_state_ptr) = (yy_state_buf);
		*(yy_state_ptr)++ = yy_current_state;

yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 117 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			*(yy_state_ptr)++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 190 );

yy_find_action:
		yy_current_state = *--(yy_state_ptr);
		(yy_lp) = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( (yy_lp) && (yy_lp) < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[(yy_lp)];
					{
					(yy_full_match) = yy_cp;
					break;
					}
				}
			--yy_cp;
			yy_current_state = *--(yy_state_ptr);
			(yy_lp) = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < gda_delimiterleng; ++yyl )
				if ( gda_delimitertext[yyl] == '\n' )
					   
    gda_delimiterlineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
YY_RULE_SETUP
#line 47 "lexer.l"
{if ((gda_delimiter_bloc_level == 0) && !ignore_next) {
				is_start = TRUE; 
				return L_SC;
			 } 
			 REJECT;
			}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 53 "lexer.l"
{return L_UNSPECVAL;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 54 "lexer.l"
{BEGIN(PSPEC); return L_LSBRACKET;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 55 "lexer.l"
{if (!is_start && (gda_delimiter_bloc_level == 0)) ignore_next = TRUE; REJECT;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 56 "lexer.l"
{can_use_is = FALSE; REJECT;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 57 "lexer.l"
{can_use_is = FALSE; REJECT;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 58 "lexer.l"
{if (!is_start && (gda_delimiter_bloc_level == 0) && can_use_is) ignore_next = TRUE; can_use_is = TRUE; REJECT;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 59 "lexer.l"
{ignore_next = FALSE; 
			 if (!is_start)
				gda_delimiter_bloc_level ++; 
			 REJECT;
			}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 64 "lexer.l"
{if (gda_delimiter_bloc_level > 0)
				gda_delimiter_bloc_level --;
			 REJECT;
			}
	YY_BREAK
case 10:
*yy_cp = (yy_hold_char); /* undo effects of setting up gda_delimitertext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up gda_delimitertext again */
YY_RULE_SETUP
#line 68 "lexer.l"
{/* Eat the comments up to the EOL */;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 69 "lexer.l"
{BEGIN(INITIAL); return L_RSBRACKET;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 70 "lexer.l"
{return L_PNAME;}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 71 "lexer.l"
{return L_PDESCR;}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 72 "lexer.l"
{return L_PTYPE;}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 73 "lexer.l"
{return L_PISPARAM;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 74 "lexer.l"
{return L_PNULLOK;}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 75 "lexer.l"
{gda_delimiterlval.str = g_strdup (gda_delimitertext); return L_WORD;}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 76 "lexer.l"
{;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 77 "lexer.l"
{gstring = g_string_new (""); BEGIN(PSTRING);}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 78 "lexer.l"
{gstring = g_string_new (""); BEGIN(PTEXTUAL);}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 80 "lexer.l"
{string_delim = g_strdup (gda_delimitertext); gstring = g_string_new (""); BEGIN(STRING);}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 81 "lexer.l"
{gstring = g_string_new (""); BEGIN(STRING);}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 82 "lexer.l"
{if (string_delim)
                                REJECT;
			 g_string_append (gstring, "\\'");
			}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 86 "lexer.l"
{
			 if (string_delim)
				REJECT;
			 BEGIN(INITIAL);
		 	 g_string_prepend_c (gstring, '\'');
		 	 g_string_append_c (gstring, '\'');
		 	 gda_delimiterlval.str = gstring->str;
		 	 g_string_free (gstring, FALSE);
		  	 return L_STRING;
			}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 96 "lexer.l"
{
			 if (!string_delim || strcmp (string_delim, gda_delimitertext))
				REJECT;
			 BEGIN(INITIAL);
                         g_string_prepend (gstring, string_delim);
                         g_string_append (gstring, string_delim);
                         gda_delimiterlval.str = gstring->str;
                         g_string_free (gstring, FALSE);
			 g_free (string_delim);
			 string_delim = NULL;
                         return L_STRING;
			}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 108 "lexer.l"
{BEGIN(PSPEC);
		 g_string_prepend_c (gstring, '\'');
                 g_string_append_c (gstring, '\'');
                 gda_delimiterlval.str = gstring->str;
		 g_string_free (gstring, FALSE);
                 return L_STRING;
                }
	YY_BREAK
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 115 "lexer.l"
{g_string_append_c (gstring, '\n');}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 116 "lexer.l"
{g_string_append_c (gstring, gda_delimitertext[0]);}
	YY_BREAK
case YY_STATE_EOF(STRING):
case YY_STATE_EOF(PSTRING):
#line 117 "lexer.l"
{
         		gda_delimitererror (_("unterminated string"));
			BEGIN(INITIAL);
         		yyterminate();
         		}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 123 "lexer.l"
{gstring = g_string_new (""); BEGIN(TEXTUAL);}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 124 "lexer.l"
{BEGIN(INITIAL);
		 gda_delimiterlval.str = gstring->str;
		 g_string_free (gstring, FALSE);
                 return L_TEXTUAL;
                }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 129 "lexer.l"
{BEGIN(PSPEC);
		 gda_delimiterlval.str = gstring->str;
                 g_string_free (gstring, FALSE);
                 return L_TEXTUAL;
                }
	YY_BREAK
case 32:
/* rule 32 can match eol */
YY_RULE_SETUP
#line 134 "lexer.l"
{g_string_append_c (gstring, '\n');}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 135 "lexer.l"
{g_string_append_c (gstring, gda_delimitertext[0]);}
	YY_BREAK
case YY_STATE_EOF(TEXTUAL):
case YY_STATE_EOF(PTEXTUAL):
#line 136 "lexer.l"
{
			gda_delimitererror (_("unterminated textual expression"));
			BEGIN(INITIAL);
                        yyterminate();
                        }
	YY_BREAK
case 34:
/* rule 34 can match eol */
YY_RULE_SETUP
#line 142 "lexer.l"
{gda_delimiterlval.str = g_strdup ("\n"); return L_CHAR;}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 143 "lexer.l"
{gda_delimiterlval.str = g_strdup ("\t"); return L_CHAR;}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 144 "lexer.l"
{gda_delimiterlval.str = g_strdup (" "); return L_CHAR;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 145 "lexer.l"
{gda_delimiterlval.str = g_strdup (gda_delimitertext); is_start = FALSE; return L_CHAR;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 147 "lexer.l"
ECHO;
	YY_BREAK
#line 1149 "lexer.c"
			case YY_STATE_EOF(INITIAL):
			case YY_STATE_EOF(PSPEC):
				yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed gda_delimiterin at a new source and called
			 * gda_delimiterlex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = gda_delimiterin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( gda_delimiterwrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * gda_delimitertext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of gda_delimiterlex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			gda_delimiterrestart(gda_delimiterin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	(yy_state_ptr) = (yy_state_buf);
	*(yy_state_ptr)++ = yy_current_state;

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 117 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		*(yy_state_ptr)++ = yy_current_state;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    
	register YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 117 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 116);
	if ( ! yy_is_jam )
		*(yy_state_ptr)++ = yy_current_state;

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up gda_delimitertext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --gda_delimiterlineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					gda_delimiterrestart(gda_delimiterin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( gda_delimiterwrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve gda_delimitertext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		   
    gda_delimiterlineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void gda_delimiterrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        gda_delimiterensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            gda_delimiter_create_buffer(gda_delimiterin,YY_BUF_SIZE );
	}

	gda_delimiter_init_buffer(YY_CURRENT_BUFFER,input_file );
	gda_delimiter_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void gda_delimiter_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		gda_delimiterpop_buffer_state();
	 *		gda_delimiterpush_buffer_state(new_buffer);
     */
	gda_delimiterensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	gda_delimiter_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (gda_delimiterwrap()) processing, but the only time this flag
	 * is looked at is after gda_delimiterwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void gda_delimiter_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	gda_delimiterin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE gda_delimiter_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) gda_delimiteralloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in gda_delimiter_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) gda_delimiteralloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in gda_delimiter_create_buffer()" );

	b->yy_is_our_buffer = 1;

	gda_delimiter_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with gda_delimiter_create_buffer()
 * 
 */
    void gda_delimiter_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		gda_delimiterfree((void *) b->yy_ch_buf  );

	gda_delimiterfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a gda_delimiterrestart() or at EOF.
 */
    static void gda_delimiter_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	gda_delimiter_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then gda_delimiter_init_buffer was _probably_
     * called from gda_delimiterrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void gda_delimiter_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		gda_delimiter_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void gda_delimiterpush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	gda_delimiterensure_buffer_stack();

	/* This block is copied from gda_delimiter_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from gda_delimiter_switch_to_buffer. */
	gda_delimiter_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void gda_delimiterpop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	gda_delimiter_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		gda_delimiter_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void gda_delimiterensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)gda_delimiteralloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)gda_delimiterrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE gda_delimiter_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) gda_delimiteralloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in gda_delimiter_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	gda_delimiter_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to gda_delimiterlex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       gda_delimiter_scan_bytes() instead.
 */
YY_BUFFER_STATE gda_delimiter_scan_string (yyconst char * yystr )
{
    
	return gda_delimiter_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to gda_delimiterlex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE gda_delimiter_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) gda_delimiteralloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in gda_delimiter_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = gda_delimiter_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in gda_delimiter_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up gda_delimitertext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		gda_delimitertext[gda_delimiterleng] = (yy_hold_char); \
		(yy_c_buf_p) = gda_delimitertext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		gda_delimiterleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int gda_delimiterget_lineno  (void)
{
        
    return gda_delimiterlineno;
}

/** Get the input stream.
 * 
 */
FILE *gda_delimiterget_in  (void)
{
        return gda_delimiterin;
}

/** Get the output stream.
 * 
 */
FILE *gda_delimiterget_out  (void)
{
        return gda_delimiterout;
}

/** Get the length of the current token.
 * 
 */
int gda_delimiterget_leng  (void)
{
        return gda_delimiterleng;
}

/** Get the current token.
 * 
 */

char *gda_delimiterget_text  (void)
{
        return gda_delimitertext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void gda_delimiterset_lineno (int  line_number )
{
    
    gda_delimiterlineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see gda_delimiter_switch_to_buffer
 */
void gda_delimiterset_in (FILE *  in_str )
{
        gda_delimiterin = in_str ;
}

void gda_delimiterset_out (FILE *  out_str )
{
        gda_delimiterout = out_str ;
}

int gda_delimiterget_debug  (void)
{
        return gda_delimiter_flex_debug;
}

void gda_delimiterset_debug (int  bdebug )
{
        gda_delimiter_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from gda_delimiterlex_destroy(), so don't allocate here.
     */

    /* We do not touch gda_delimiterlineno unless the option is enabled. */
    gda_delimiterlineno =  1;
    
    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

    (yy_state_buf) = 0;
    (yy_state_ptr) = 0;
    (yy_full_match) = 0;
    (yy_lp) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    gda_delimiterin = stdin;
    gda_delimiterout = stdout;
#else
    gda_delimiterin = (FILE *) 0;
    gda_delimiterout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * gda_delimiterlex_init()
     */
    return 0;
}

/* gda_delimiterlex_destroy is for both reentrant and non-reentrant scanners. */
int gda_delimiterlex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		gda_delimiter_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		gda_delimiterpop_buffer_state();
	}

	/* Destroy the stack itself. */
	gda_delimiterfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    gda_delimiterfree ( (yy_state_buf) );
    (yy_state_buf)  = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * gda_delimiterlex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *gda_delimiteralloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *gda_delimiterrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void gda_delimiterfree (void * ptr )
{
	free( (char *) ptr );	/* see gda_delimiterrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 147 "lexer.l"



