/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 34 "parser.y"

#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libgda/sql-parser/gda-sql-parser-private.h>
#include <libgda/sql-parser/gda-statement-struct-util.h>
#include <libgda/sql-parser/gda-statement-struct-trans.h>
#include <libgda/sql-parser/gda-statement-struct-insert.h>
#include <libgda/sql-parser/gda-statement-struct-update.h>
#include <libgda/sql-parser/gda-statement-struct-delete.h>
#include <libgda/sql-parser/gda-statement-struct-select.h>
#include <libgda/sql-parser/gda-statement-struct-compound.h>
#include <libgda/sql-parser/gda-statement-struct-parts.h>

#ifdef GDA_DEBUG_NO
#define DEBUG(format, ...) g_print ("___" format "\n", __VA_ARGS__)
#else
#define DEBUG(format, ...)
#endif

typedef struct {
	GValue *fname;
	GdaSqlExpr *expr;
} UpdateSet;

typedef struct {
	gboolean    distinct;
	GdaSqlExpr *expr;
} Distinct;

typedef struct {
	GdaSqlExpr *count;
	GdaSqlExpr *offset;
} Limit;

typedef struct {
	GSList *when_list;
	GSList *then_list;
} CaseBody;

static GdaSqlOperator
sql_operation_string_to_operator (const gchar *op)
{
	switch (g_ascii_toupper (*op)) {
	case 'A':
		return GDA_SQL_OPERATOR_AND;
	case 'O':
		return GDA_SQL_OPERATOR_OR;
	case 'N':
		return GDA_SQL_OPERATOR_NOT;
	case '=':
		return GDA_SQL_OPERATOR_EQ;
	case 'I':
		if (op[1] == 'S')
			return GDA_SQL_OPERATOR_IS;
		else if (op[1] == 'N')
			return GDA_SQL_OPERATOR_IN;
		break;
	case 'L':
		return GDA_SQL_OPERATOR_LIKE;
	case 'B':
		return GDA_SQL_OPERATOR_BETWEEN;
	case '>':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_GEQ;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_GT;
		break;
	case '<':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_LEQ;
		else if (op[1] == '>')
			return GDA_SQL_OPERATOR_DIFF;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_LT;
		break;
	case '!':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_DIFF;
		else if (op[1] == '~') {
			if (op[2] == 0)
				return GDA_SQL_OPERATOR_NOT_REGEXP;
			else if (op[2] == '*')
				return GDA_SQL_OPERATOR_NOT_REGEXP_CI;
		}
		break;
	case '~':
		if (op[1] == '*')
			return GDA_SQL_OPERATOR_REGEXP_CI;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_REGEXP;
		break;
	case 'S':
		return GDA_SQL_OPERATOR_SIMILAR;
	case '|':
		if (op[1] == '|')
			return GDA_SQL_OPERATOR_CONCAT;
		else
			return GDA_SQL_OPERATOR_BITOR;
	case '+':
		return GDA_SQL_OPERATOR_PLUS;
	case '-':
		return GDA_SQL_OPERATOR_MINUS;
	case '*':
		return GDA_SQL_OPERATOR_STAR;
	case '/':
		return GDA_SQL_OPERATOR_DIV;
	case '%':
		return GDA_SQL_OPERATOR_REM;
	case '&':
		return GDA_SQL_OPERATOR_BITAND;
	}
	g_error ("Unhandled operator named '%s'\n", op);
	return 0;
}

static GdaSqlOperator
string_to_op_type (GValue *value)
{
	GdaSqlOperator op;
	op = sql_operation_string_to_operator (g_value_get_string (value));
	g_value_reset (value);
	g_free (value);
	return op;
}

static GdaSqlExpr *
compose_multiple_expr (GdaSqlOperator op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	if (left->cond && (left->cond->operator == op)) {
		ret = left;
		ret->cond->operands = g_slist_append (ret->cond->operands, right);
	}
	else {
		GdaSqlOperation *cond;
		ret = gda_sql_expr_new (NULL);
		cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
		ret->cond = cond;
		cond->operator = op;
		cond->operands = g_slist_prepend (NULL, right);
		GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
		cond->operands = g_slist_prepend (cond->operands, left);
		GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	}
	return ret;
}

static GdaSqlExpr *
create_two_expr (GdaSqlOperator op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator = op;
	cond->operands = g_slist_prepend (NULL, right);
	GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
	cond->operands = g_slist_prepend (cond->operands, left);
	GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlExpr *
create_uni_expr (GdaSqlOperator op, GdaSqlExpr *expr) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator = op;
	cond->operands = g_slist_prepend (NULL, expr);
	GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlStatement *
compose_multiple_compounds (GdaSqlStatementCompoundType ctype, GdaSqlStatement *left, GdaSqlStatement *right) {
	GdaSqlStatement *ret;
	GdaSqlStatementCompound *lc = (GdaSqlStatementCompound*) left->contents;
	if (lc->compound_type == ctype) {
		GdaSqlStatementCompound *rc = (GdaSqlStatementCompound*) right->contents;
		if (!rc->stmt_list->next || rc->compound_type == ctype) {
			GSList *list;
			for (list = rc->stmt_list; list; list = list->next)
				GDA_SQL_ANY_PART (((GdaSqlStatement*)list->data)->contents)->parent = GDA_SQL_ANY_PART (lc);

			ret = left;
			lc->stmt_list = g_slist_concat (lc->stmt_list, rc->stmt_list);
			rc->stmt_list = NULL;
			gda_sql_statement_free (right);
		}
	}
	else {
		ret = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
		gda_sql_statement_compound_set_type (ret, ctype);
		gda_sql_statement_compound_take_stmt (ret, left);
		gda_sql_statement_compound_take_stmt (ret, right);
	}
	return ret;
}

#line 212 "parser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    gda_sql_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is gda_sql_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    gda_sql_parserARG_SDECL     A static variable declaration for the %extra_argument
**    gda_sql_parserARG_PDECL     A parameter declaration for the %extra_argument
**    gda_sql_parserARG_STORE     Code to store %extra_argument into yypParser
**    gda_sql_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 208
#define YYACTIONTYPE unsigned short int
#define gda_sql_parserTOKENTYPE GValue *
typedef union {
  gda_sql_parserTOKENTYPE yy0;
  Limit yy20;
  GdaSqlSelectFrom * yy59;
  GdaSqlOperator yy119;
  GdaSqlExpr* yy122;
  Distinct * yy189;
  gboolean yy216;
  GdaSqlSelectTarget * yy224;
  GSList * yy247;
  CaseBody yy263;
  GdaTransactionIsolation yy307;
  GdaSqlStatement * yy308;
  GdaSqlSelectJoinType yy317;
  GdaSqlExpr * yy328;
  GValue * yy361;
  GSList* yy393;
  GdaSqlParamSpec * yy405;
  int yy415;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define gda_sql_parserARG_SDECL GdaSqlParserIface *pdata;
#define gda_sql_parserARG_PDECL ,GdaSqlParserIface *pdata
#define gda_sql_parserARG_FETCH GdaSqlParserIface *pdata = yypParser->pdata
#define gda_sql_parserARG_STORE yypParser->pdata = pdata
#define YYNSTATE 359
#define YYNRULE 195
#define YYERRORSYMBOL 158
#define YYERRSYMDT yy415
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   287,   63,   15,   15,   16,   18,   18,   23,  267,  288,
 /*    10 */   160,   28,   24,   24,   24,   24,   27,   27,   27,   27,
 /*    20 */    27,   26,   20,   20,   70,  370,   15,   15,   16,   18,
 /*    30 */    18,   23,  292,  222,  223,  190,  191,  192,  221,  370,
 /*    40 */   370,   54,  162,  325,  142,  143,  144,  286,   70,  291,
 /*    50 */   245,  246,  139,  127,  256,  307,  257,  258,  259,  260,
 /*    60 */   267,   22,   21,  187,   13,  212,  270,  289,   25,   25,
 /*    70 */    28,   24,   24,   24,   24,   27,   27,   27,   27,   27,
 /*    80 */   267,   20,   20,  290,  253,   15,   15,   16,   18,   18,
 /*    90 */    23,   26,  204,   52,  136,  253,  253,   42,   27,   27,
 /*   100 */    27,   27,   27,  203,   20,   20,   67,   70,   15,   15,
 /*   110 */    16,   18,   18,   23,  336,  163,  155,  312,  241,  346,
 /*   120 */   329,  167,  267,  277,  129,  257,  258,  259,  260,  121,
 /*   130 */    70,   22,   21,  187,   13,  212,  270,  129,   25,   25,
 /*   140 */    28,   24,   24,   24,   24,   27,   27,   27,   27,   27,
 /*   150 */   253,   20,   20,  319,  138,   15,   15,   16,   18,   18,
 /*   160 */    23,   26,   55,  122,   24,   24,   24,   24,   27,   27,
 /*   170 */    27,   27,   27,  123,   20,   20,  333,   70,   15,   15,
 /*   180 */    16,   18,   18,   23,   43,  252,  264,  555,  128,  204,
 /*   190 */   118,  308,  318,  137,  120,   53,  252,  252,  329,  395,
 /*   200 */    70,   22,   21,  187,   13,  212,  270,  248,   25,   25,
 /*   210 */    28,   24,   24,   24,   24,   27,   27,   27,   27,   27,
 /*   220 */   309,   20,   20,  196,  296,   15,   15,   16,   18,   18,
 /*   230 */    23,  229,   27,  174,   20,   20,  253,   26,   15,   15,
 /*   240 */    16,   18,   18,   23,  369,  327,  195,   70,  395,  231,
 /*   250 */   248,  252,   16,   18,   18,   23,  245,  246,  369,  369,
 /*   260 */    70,  224,  325,  344,  345,  197,   74,  204,  325,  305,
 /*   270 */   116,   56,   70,  193,  323,  324,   53,   22,   21,  187,
 /*   280 */    13,  212,  270,  130,   25,   25,   28,   24,   24,   24,
 /*   290 */    24,   27,   27,   27,   27,   27,  209,   20,   20,    6,
 /*   300 */   379,   15,   15,   16,   18,   18,   23,   26,  208,  253,
 /*   310 */   207,  204,  261,  207,  379,  379,   62,  325,  233,   93,
 /*   320 */   247,  347,  254,   70,  176,  348,  320,  329,  142,  143,
 /*   330 */   144,  322,  142,  143,  144,   73,  321,  252,  313,  206,
 /*   340 */   255,  352,  206,  255,  204,  150,  244,   22,   21,  187,
 /*   350 */    13,  212,  270,  141,   25,   25,   28,   24,   24,   24,
 /*   360 */    24,   27,   27,   27,   27,   27,  194,   20,   20,  314,
 /*   370 */   202,   15,   15,   16,   18,   18,   23,  177,   67,  331,
 /*   380 */   178,  228,  159,   26,  208,  329,  207,  204,  186,  207,
 /*   390 */   362,  188,   92,   70,  248,   92,  262,  248,  362,  362,
 /*   400 */   362,  330,  236,  268,  142,  143,  144,  329,  253,  129,
 /*   410 */   252,  142,  143,  144,  216,  206,  255,   81,  206,  255,
 /*   420 */   145,  253,   71,   22,   21,  187,   13,  212,  270,  126,
 /*   430 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   440 */    27,   27,  185,   20,   20,  253,  205,   15,   15,   16,
 /*   450 */    18,   18,   23,  179,  316,  204,  213,  305,  180,  248,
 /*   460 */   204,  201,  207,   26,  189,  204,  140,  207,   92,   70,
 /*   470 */   248,  248,  204,   84,  251,  248,  280,  183,  204,  284,
 /*   480 */   211,  234,  232,  282,  142,  143,  144,  142,  143,  144,
 /*   490 */   157,  206,  255,  142,  143,  144,  206,  255,  142,  143,
 /*   500 */   144,   17,   37,   22,   21,  187,   13,  212,  270,  252,
 /*   510 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   520 */    27,   27,  252,   20,   20,  174,  306,   15,   15,   16,
 /*   530 */    18,   18,   23,  204,  398,  207,  265,   76,  175,  398,
 /*   540 */   158,   61,  248,   26,  398,  204,  252,  207,  349,   70,
 /*   550 */   249,   23,  218,   84,  250,  248,  204,  334,  303,  350,
 /*   560 */   337,  181,  311,  329,  206,  255,  329,  248,   70,   82,
 /*   570 */   204,  248,  164,  204,  398,  166,  206,  255,  248,  204,
 /*   580 */   351,  242,   40,   22,   21,  187,   13,  212,  270,  358,
 /*   590 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   600 */    27,   27,  298,   20,   20,  300,  269,   15,   15,   16,
 /*   610 */    18,   18,   23,   26,  204,   80,  243,  204,   36,  207,
 /*   620 */    38,  215,  398,   14,   17,  101,   30,  281,  315,   70,
 /*   630 */   328,  171,  304,  340,  341,   66,  398,  398,  220,  225,
 /*   640 */   398,  165,  226,  342,  343,   17,   68,   69,  206,  255,
 /*   650 */    72,   14,  151,   22,   29,  187,   13,  212,  270,   17,
 /*   660 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   670 */    27,   27,  353,   20,   20,  354,  355,   15,   15,   16,
 /*   680 */    18,   18,   23,   26,  204,   70,  207,  204,  198,  207,
 /*   690 */    17,  199,   92,   17,   72,   92,   39,  133,  219,   70,
 /*   700 */   152,   45,  217,   47,  153,  156,  154,  302,   53,   41,
 /*   710 */   285,  310,  230,  326,  332,  206,  255,  335,  206,  255,
 /*   720 */   227,   75,  183,   22,   31,  187,   13,  212,  270,  339,
 /*   730 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   740 */    27,   27,  240,   20,   20,   64,   58,   15,   15,   16,
 /*   750 */    18,   18,   23,   26,  204,  239,  207,  204,  200,  207,
 /*   760 */   235,   65,   92,   79,  172,  112,  237,  357,  359,   70,
 /*   770 */   173,  360,  131,  132,  168,    1,  271,  124,  125,   19,
 /*   780 */   169,  266,    2,    3,    8,  206,  255,  283,  206,  255,
 /*   790 */    44,   46,    9,  293,   21,  187,   13,  212,  270,  294,
 /*   800 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   810 */    27,   27,  295,   20,   20,  253,  297,   15,   15,   16,
 /*   820 */    18,   18,   23,   26,  210,  204,  299,  207,  204,  317,
 /*   830 */   207,  301,  204,   88,  207,   57,  119,   48,  184,   70,
 /*   840 */   135,  253,  170,  338,  182,   77,   10,   11,  161,   12,
 /*   850 */   210,  238,  356,   49,   50,  556,  206,  255,  556,  206,
 /*   860 */   255,  556,   78,  206,  255,  187,   13,  212,  270,   59,
 /*   870 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   880 */    27,   27,   34,   20,   20,  556,  556,   15,   15,   16,
 /*   890 */    18,   18,   23,  253,  204,  556,  207,  556,  556,  556,
 /*   900 */   556,  556,   89,  556,   33,   32,  263,  556,   34,   70,
 /*   910 */   253,  556,  556,   35,    5,  556,  252,  556,  556,  210,
 /*   920 */   556,  204,  556,  207,  556,  206,  255,  556,  400,  134,
 /*   930 */    33,   32,  273,  400,  275,  556,  556,  556,  400,   35,
 /*   940 */     5,  556,  252,  556,  556,  129,  556,  253,  556,  556,
 /*   950 */   556,  556,  206,  255,  556,  556,  210,    7,  273,  556,
 /*   960 */   275,  272,  274,  276,  214,  556,  556,  278,  400,  556,
 /*   970 */   556,  129,  204,  556,  207,  556,  556,   34,  556,  556,
 /*   980 */    85,  556,  556,    7,  556,  556,  556,  272,  274,  276,
 /*   990 */   214,  556,  556,  278,  252,  556,  556,  556,  556,   33,
 /*  1000 */    32,  263,  556,  206,  255,  556,  556,  556,   35,    4,
 /*  1010 */   273,  252,  275,  253,   34,  556,  400,  556,  279,  556,
 /*  1020 */   556,  556,  210,  320,  556,  556,  556,  273,  322,  275,
 /*  1030 */   400,  400,  253,  321,  400,  556,   33,   32,  556,  272,
 /*  1040 */   274,  276,  556,  556,  320,   35,    4,  556,  252,  322,
 /*  1050 */   556,  556,    7,  556,  321,  556,  272,  274,  276,  214,
 /*  1060 */   230,  556,  278,  194,  273,  556,  275,  556,  556,  556,
 /*  1070 */   556,  556,  556,  556,  204,  556,  207,  556,  556,  556,
 /*  1080 */    34,  230,  117,  556,  194,  556,  556,  556,  556,    7,
 /*  1090 */   556,  556,  556,  272,  274,  276,  214,  556,  556,  278,
 /*  1100 */   556,  556,   33,   32,  556,  206,  255,  556,  204,  556,
 /*  1110 */   207,   35,    4,  556,  252,  556,  107,  204,  556,  207,
 /*  1120 */   556,  556,  556,  556,  556,  106,  204,   51,  207,  556,
 /*  1130 */   273,  556,  275,  252,  146,  556,  556,  556,  556,  206,
 /*  1140 */   255,  556,  204,  556,  207,  556,  556,  556,  206,  255,
 /*  1150 */   114,  556,  556,  556,  556,    7,  556,  206,  255,  272,
 /*  1160 */   274,  276,  214,  556,  204,  278,  207,  556,  556,  204,
 /*  1170 */   556,  207,  110,  206,  255,  556,  556,  111,  204,  556,
 /*  1180 */   207,  556,  204,  556,  207,  556,  115,  556,  556,  556,
 /*  1190 */    90,  556,  556,  556,  556,  206,  255,  204,  556,  207,
 /*  1200 */   206,  255,  556,  556,  204,  113,  207,  556,  556,  206,
 /*  1210 */   255,  556,   91,  206,  255,  204,  556,  207,  204,  556,
 /*  1220 */   207,  556,  204,  108,  207,  556,  147,  556,  206,  255,
 /*  1230 */   148,  556,  204,  556,  207,  206,  255,  556,  556,  556,
 /*  1240 */   109,  556,  556,  556,  556,  556,  206,  255,  556,  206,
 /*  1250 */   255,  556,  556,  206,  255,  556,  556,  556,  556,  204,
 /*  1260 */   556,  207,  556,  206,  255,  556,  204,  149,  207,  204,
 /*  1270 */   556,  207,  556,  204,   86,  207,  204,   94,  207,  556,
 /*  1280 */   204,   95,  207,  556,   87,  556,  556,  204,   96,  207,
 /*  1290 */   206,  255,  556,  556,  556,   83,  556,  206,  255,  556,
 /*  1300 */   206,  255,  556,  556,  206,  255,  556,  206,  255,  556,
 /*  1310 */   556,  206,  255,  556,  204,  556,  207,  556,  206,  255,
 /*  1320 */   556,  556,   97,  556,  556,  204,  556,  207,  204,  556,
 /*  1330 */   207,  556,  204,   98,  207,  204,   60,  207,  556,  204,
 /*  1340 */    99,  207,  204,  100,  207,  206,  255,  102,  556,  556,
 /*  1350 */   103,  556,  556,  556,  556,  556,  206,  255,  556,  206,
 /*  1360 */   255,  556,  556,  206,  255,  556,  206,  255,  556,  556,
 /*  1370 */   206,  255,  556,  206,  255,  204,  556,  207,  556,  204,
 /*  1380 */   556,  207,  556,  104,  556,  556,  556,  105,  556,  556,
 /*  1390 */   556,  556,  556,  556,  556,  556,  556,  556,  556,  556,
 /*  1400 */   556,  556,  556,  556,  556,  556,  206,  255,  556,  556,
 /*  1410 */   206,  255,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     5,    8,   90,   91,   92,   93,   94,   95,  202,   14,
 /*    10 */    17,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    20 */    84,   26,   86,   87,  112,  101,   90,   91,   92,   93,
 /*    30 */    94,   95,  102,  103,  104,  105,  106,  107,  108,  115,
 /*    40 */   116,   48,   49,  119,  109,  110,  111,  189,  112,  119,
 /*    50 */   115,  116,   59,   60,  152,    1,  154,  155,  156,  157,
 /*    60 */   202,   66,   67,   68,   69,   70,   71,  189,   73,   74,
 /*    70 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    80 */   202,   86,   87,  196,    1,   90,   91,   92,   93,   94,
 /*    90 */    95,   26,  169,  100,  171,    1,    1,   32,   80,   81,
 /*   100 */    82,   83,   84,  161,   86,   87,  100,  112,   90,   91,
 /*   110 */    92,   93,   94,   95,  163,  122,  193,  197,  125,  168,
 /*   120 */   169,  128,  202,  152,  131,  154,  155,  156,  157,  166,
 /*   130 */   112,   66,   67,   68,   69,   70,   71,  131,   73,   74,
 /*   140 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   150 */     1,   86,   87,  164,   59,   90,   91,   92,   93,   94,
 /*   160 */    95,   26,  164,  165,   76,   77,   78,   79,   80,   81,
 /*   170 */    82,   83,   84,  166,   86,   87,  164,  112,   90,   91,
 /*   180 */    92,   93,   94,   95,  119,  102,   92,  159,  160,  169,
 /*   190 */   162,  171,  163,  164,  165,  141,  102,  102,  169,   50,
 /*   200 */   112,   66,   67,   68,   69,   70,   71,  179,   73,   74,
 /*   210 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   220 */   200,   86,   87,   23,  102,   90,   91,   92,   93,   94,
 /*   230 */    95,  160,   84,  162,   86,   87,    1,   26,   90,   91,
 /*   240 */    92,   93,   94,   95,  101,   52,   53,  112,   50,   56,
 /*   250 */   179,  102,   92,   93,   94,   95,  115,  116,  115,  116,
 /*   260 */   112,  139,  119,   63,   64,   65,  117,  169,  119,  171,
 /*   270 */   191,  192,  112,  175,   57,   58,  141,   66,   67,   68,
 /*   280 */    69,   70,   71,  182,   73,   74,   75,   76,   77,   78,
 /*   290 */    79,   80,   81,   82,   83,   84,  169,   86,   87,  198,
 /*   300 */   101,   90,   91,   92,   93,   94,   95,   26,  169,    1,
 /*   310 */   171,  169,  101,  171,  115,  116,  177,  119,  119,  177,
 /*   320 */   101,  163,  169,  112,  101,  169,   13,  169,  109,  110,
 /*   330 */   111,   18,  109,  110,  111,  100,   23,  102,  199,  200,
 /*   340 */   201,  169,  200,  201,  169,  203,  171,   66,   67,   68,
 /*   350 */    69,   70,   71,  178,   73,   74,   75,   76,   77,   78,
 /*   360 */    79,   80,   81,   82,   83,   84,   53,   86,   87,  130,
 /*   370 */   161,   90,   91,   92,   93,   94,   95,  162,  100,  163,
 /*   380 */   162,  142,  166,   26,  169,  169,  171,  169,  173,  171,
 /*   390 */   101,  173,  177,  112,  179,  177,  101,  179,  109,  110,
 /*   400 */   111,  163,  124,  101,  109,  110,  111,  169,    1,  131,
 /*   410 */   102,  109,  110,  111,  199,  200,  201,  181,  200,  201,
 /*   420 */   183,    1,  141,   66,   67,   68,   69,   70,   71,  121,
 /*   430 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   440 */    83,   84,  162,   86,   87,    1,  169,   90,   91,   92,
 /*   450 */    93,   94,   95,  162,  162,  169,  205,  171,  162,  179,
 /*   460 */   169,  175,  171,   26,  173,  169,   59,  171,  177,  112,
 /*   470 */   179,  179,  169,  177,  171,  179,  101,   57,  169,  101,
 /*   480 */   171,   61,   62,  101,  109,  110,  111,  109,  110,  111,
 /*   490 */   101,  200,  201,  109,  110,  111,  200,  201,  109,  110,
 /*   500 */   111,  119,  145,   66,   67,   68,   69,   70,   71,  102,
 /*   510 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   520 */    83,   84,  102,   86,   87,  162,  197,   90,   91,   92,
 /*   530 */    93,   94,   95,  169,   13,  171,   92,  117,  162,   18,
 /*   540 */   166,  177,  179,   26,   23,  169,  102,  171,  169,  112,
 /*   550 */   162,   95,  188,  177,  162,  179,  169,  163,  171,  169,
 /*   560 */   163,  162,  119,  169,  200,  201,  169,  179,  112,  126,
 /*   570 */   169,  179,  171,  169,   53,  171,  200,  201,  179,  169,
 /*   580 */   169,  171,  145,   66,   67,   68,   69,   70,   71,  176,
 /*   590 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   600 */    83,   84,  102,   86,   87,  102,  101,   90,   91,   92,
 /*   610 */    93,   94,   95,   26,  169,  119,  171,  169,  144,  171,
 /*   620 */   146,   70,  101,  127,  119,  177,   75,  101,  130,  112,
 /*   630 */    54,   55,  101,   63,   64,  180,  115,  116,  190,  139,
 /*   640 */   119,  101,  139,   63,   64,  119,  180,  180,  200,  201,
 /*   650 */   119,  127,  176,   66,   67,   68,   69,   70,   71,  119,
 /*   660 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   670 */    83,   84,  101,   86,   87,  101,  101,   90,   91,   92,
 /*   680 */    93,   94,   95,   26,  169,  112,  171,  169,  173,  171,
 /*   690 */   119,  173,  177,  119,  119,  177,  144,  204,  136,  112,
 /*   700 */   184,  135,  133,  138,  185,  194,  186,  195,  141,  132,
 /*   710 */   187,  197,   50,  165,  165,  200,  201,  117,  200,  201,
 /*   720 */   137,  167,   57,   66,   67,   68,   69,   70,   71,  168,
 /*   730 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   740 */    83,   84,   66,   86,   87,  167,  100,   90,   91,   92,
 /*   750 */    93,   94,   95,   26,  169,  119,  171,  169,  173,  171,
 /*   760 */   170,  172,  177,  170,  206,  177,  174,  176,    0,  112,
 /*   770 */   206,    0,  140,  140,  151,  100,   17,  140,  140,  100,
 /*   780 */   151,  101,  100,  100,  134,  200,  201,  101,  200,  201,
 /*   790 */   119,  119,  134,  102,   67,   68,   69,   70,   71,  102,
 /*   800 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   810 */    83,   84,  102,   86,   87,    1,  102,   90,   91,   92,
 /*   820 */    93,   94,   95,   26,   10,  169,  102,  171,  169,  101,
 /*   830 */   171,  102,  169,  177,  171,  100,  177,  138,   51,  112,
 /*   840 */   177,    1,   53,  120,  118,  123,  100,  100,  118,  100,
 /*   850 */    10,  119,    1,   74,   74,  207,  200,  201,  207,  200,
 /*   860 */   201,  207,  126,  200,  201,   68,   69,   70,   71,  129,
 /*   870 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   880 */    83,   84,   68,   86,   87,  207,  207,   90,   91,   92,
 /*   890 */    93,   94,   95,    1,  169,  207,  171,  207,  207,  207,
 /*   900 */   207,  207,  177,  207,   90,   91,   92,  207,   68,  112,
 /*   910 */     1,  207,  207,   99,  100,  207,  102,  207,  207,   10,
 /*   920 */   207,  169,  207,  171,  207,  200,  201,  207,   13,  177,
 /*   930 */    90,   91,  118,   18,  120,  207,  207,  207,   23,   99,
 /*   940 */   100,  207,  102,  207,  207,  131,  207,    1,  207,  207,
 /*   950 */   207,  207,  200,  201,  207,  207,   10,  143,  118,  207,
 /*   960 */   120,  147,  148,  149,  150,  207,  207,  153,   53,  207,
 /*   970 */   207,  131,  169,  207,  171,  207,  207,   68,  207,  207,
 /*   980 */   177,  207,  207,  143,  207,  207,  207,  147,  148,  149,
 /*   990 */   150,  207,  207,  153,  102,  207,  207,  207,  207,   90,
 /*  1000 */    91,   92,  207,  200,  201,  207,  207,  207,   99,  100,
 /*  1010 */   118,  102,  120,    1,   68,  207,  101,  207,   72,  207,
 /*  1020 */   207,  207,   10,   13,  207,  207,  207,  118,   18,  120,
 /*  1030 */   115,  116,    1,   23,  119,  207,   90,   91,  207,  147,
 /*  1040 */   148,  149,  207,  207,   13,   99,  100,  207,  102,   18,
 /*  1050 */   207,  207,  143,  207,   23,  207,  147,  148,  149,  150,
 /*  1060 */    50,  207,  153,   53,  118,  207,  120,  207,  207,  207,
 /*  1070 */   207,  207,  207,  207,  169,  207,  171,  207,  207,  207,
 /*  1080 */    68,   50,  177,  207,   53,  207,  207,  207,  207,  143,
 /*  1090 */   207,  207,  207,  147,  148,  149,  150,  207,  207,  153,
 /*  1100 */   207,  207,   90,   91,  207,  200,  201,  207,  169,  207,
 /*  1110 */   171,   99,  100,  207,  102,  207,  177,  169,  207,  171,
 /*  1120 */   207,  207,  207,  207,  207,  177,  169,  117,  171,  207,
 /*  1130 */   118,  207,  120,  102,  177,  207,  207,  207,  207,  200,
 /*  1140 */   201,  207,  169,  207,  171,  207,  207,  207,  200,  201,
 /*  1150 */   177,  207,  207,  207,  207,  143,  207,  200,  201,  147,
 /*  1160 */   148,  149,  150,  207,  169,  153,  171,  207,  207,  169,
 /*  1170 */   207,  171,  177,  200,  201,  207,  207,  177,  169,  207,
 /*  1180 */   171,  207,  169,  207,  171,  207,  177,  207,  207,  207,
 /*  1190 */   177,  207,  207,  207,  207,  200,  201,  169,  207,  171,
 /*  1200 */   200,  201,  207,  207,  169,  177,  171,  207,  207,  200,
 /*  1210 */   201,  207,  177,  200,  201,  169,  207,  171,  169,  207,
 /*  1220 */   171,  207,  169,  177,  171,  207,  177,  207,  200,  201,
 /*  1230 */   177,  207,  169,  207,  171,  200,  201,  207,  207,  207,
 /*  1240 */   177,  207,  207,  207,  207,  207,  200,  201,  207,  200,
 /*  1250 */   201,  207,  207,  200,  201,  207,  207,  207,  207,  169,
 /*  1260 */   207,  171,  207,  200,  201,  207,  169,  177,  171,  169,
 /*  1270 */   207,  171,  207,  169,  177,  171,  169,  177,  171,  207,
 /*  1280 */   169,  177,  171,  207,  177,  207,  207,  169,  177,  171,
 /*  1290 */   200,  201,  207,  207,  207,  177,  207,  200,  201,  207,
 /*  1300 */   200,  201,  207,  207,  200,  201,  207,  200,  201,  207,
 /*  1310 */   207,  200,  201,  207,  169,  207,  171,  207,  200,  201,
 /*  1320 */   207,  207,  177,  207,  207,  169,  207,  171,  169,  207,
 /*  1330 */   171,  207,  169,  177,  171,  169,  177,  171,  207,  169,
 /*  1340 */   177,  171,  169,  177,  171,  200,  201,  177,  207,  207,
 /*  1350 */   177,  207,  207,  207,  207,  207,  200,  201,  207,  200,
 /*  1360 */   201,  207,  207,  200,  201,  207,  200,  201,  207,  207,
 /*  1370 */   200,  201,  207,  200,  201,  169,  207,  171,  207,  169,
 /*  1380 */   207,  171,  207,  177,  207,  207,  207,  177,  207,  207,
 /*  1390 */   207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
 /*  1400 */   207,  207,  207,  207,  207,  207,  200,  201,  207,  207,
 /*  1410 */   200,  201,
};
#define YY_SHIFT_USE_DFLT (-99)
#define YY_SHIFT_MAX 244
static const short yy_shift_ofst[] = {
 /*     0 */    -7,  814,  840,  840,  840,  840,  909, 1012, 1012, 1012,
 /*    10 */  1012, 1012, 1012,  946, 1012, 1012, 1012, 1012, 1012, 1012,
 /*    20 */  1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
 /*    30 */  1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
 /*    40 */  1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
 /*    50 */  1012, 1031,   -7,  892,  420,  149,  235,   83,   83,   83,
 /*    60 */    -5,   -5,  135, 1010,  308,  278,    6,    6,    6,    6,
 /*    70 */    83,   83,   83,    6,   83,   83,   83,   83,   83,   83,
 /*    80 */    83,  -99,  -99,   65,  211,  281,  357,  437,  517,  517,
 /*    90 */   587,  657,  517,  517,  517,  517,  517,  517,  517,  517,
 /*   100 */   517,  517,  517,  517,  517,  517,  727,  797,  797,  797,
 /*   110 */   -64,  -64,  -64,   88,   18,  148,  -70,  -88,  -65,  160,
 /*   120 */   -76,  313,  143,  313,   94,  444,   95,  407,  141,  239,
 /*   130 */   443,   83,   83,  474,  456,  456,   54,  198,   83,   83,
 /*   140 */    83,  496,  498,  498,  498,  524,  573,  573,  573,  573,
 /*   150 */   552,  562,  566,  569,  577,  565,  583,  567,  662,  662,
 /*   160 */   600,  665,  600,  676,  646,  636,  524,  676,  -99,  -99,
 /*   170 */   521,  915,  -98,  -29,  219,  223,  289,  295,  302,  375,
 /*   180 */   378,  389,  199,  200,  193,  384,  382,  551,  505,  526,
 /*   190 */   122,  500,  503,  531,  217,  576,  570,  580,  540,  571,
 /*   200 */   574,  575,  768,  771,  632,  633,  623,  675,  637,  638,
 /*   210 */   679,  680,  682,  759,  629,  683,  686,  650,  671,  658,
 /*   220 */   672,  691,  697,  710,  714,  724,  729,  735,  699,  728,
 /*   230 */   787,  789,  726,  723,  730,  722,  746,  732,  747,  749,
 /*   240 */   851,  736,  740,  779,  780,
};
#define YY_REDUCE_USE_DFLT (-195)
#define YY_REDUCE_MAX 169
static const short yy_reduce_ofst[] = {
 /*     0 */    28,  215,  218,  291,  296,  376,  139,  142,  364,  448,
 /*    10 */   515,  518,  585,  588,  656,  659,  663,  725,  752,  803,
 /*    20 */   905,  939,  948,  957,  973,  995, 1000, 1009, 1013, 1028,
 /*    30 */  1035, 1046, 1049, 1053, 1063, 1090, 1097, 1100, 1104, 1107,
 /*    40 */  1111, 1118, 1145, 1156, 1159, 1163, 1166, 1170, 1173, 1206,
 /*    50 */  1210,   29,   71,   20,  -49,  216,  -77,   98,  286,  175,
 /*    60 */  -142, -122,  -80,   -2,  158,  280,  292,  363,  388,  392,
 /*    70 */   303,  309,  387,  399,  238,  394,  397,  401,  404,  410,
 /*    80 */   445,  101,   79, -194, -194, -194, -194, -194, -194, -194,
 /*    90 */  -194, -194, -194, -194, -194, -194, -194, -194, -194, -194,
 /*   100 */  -194, -194, -194, -194, -194, -194, -194, -194, -194, -194,
 /*   110 */  -194, -194, -194, -194, -194, -194, -113, -194,  -58, -194,
 /*   120 */   -37,  -11,    7,   12,  127,  153,  156,  172,  209,  236,
 /*   130 */   237,  277,  153,  251, -194, -194,  329,  374,  379,  390,
 /*   140 */   411,  413,  455,  466,  467,  476, -194, -194, -194, -194,
 /*   150 */   493,  516,  519,  520,  523,  511,  512,  514,  548,  549,
 /*   160 */   554,  561,  578,  590,  589,  592,  591,  593,  558,  564,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   554,  491,  491,  491,  554,  554,  554,  529,  554,  554,
 /*    10 */   491,  491,  491,  554,  554,  554,  554,  554,  554,  554,
 /*    20 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    30 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    40 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    50 */   554,  401,  554,  554,  401,  401,  554,  554,  554,  554,
 /*    60 */   447,  447,  484,  365,  401,  554,  554,  554,  554,  554,
 /*    70 */   554,  554,  554,  554,  401,  401,  401,  554,  554,  554,
 /*    80 */   554,  476,  457,  438,  554,  554,  554,  554,  426,  492,
 /*    90 */   554,  554,  493,  528,  530,  532,  531,  439,  440,  449,
 /*   100 */   489,  490,  459,  488,  428,  429,  510,  509,  517,  518,
 /*   110 */   513,  514,  521,  516,  512,  515,  453,  506,  554,  503,
 /*   120 */   395,  554,  395,  554,  554,  554,  554,  554,  554,  485,
 /*   130 */   452,  554,  554,  533,  505,  504,  484,  371,  554,  554,
 /*   140 */   554,  425,  434,  434,  434,  425,  511,  507,  508,  519,
 /*   150 */   554,  450,  448,  441,  437,  460,  456,  484,  554,  554,
 /*   160 */   393,  381,  393,  416,  420,  413,  425,  416,  544,  544,
 /*   170 */   554,  554,  554,  554,  554,  554,  522,  554,  554,  554,
 /*   180 */   554,  554,  554,  554,  554,  415,  554,  554,  554,  554,
 /*   190 */   554,  554,  554,  554,  554,  554,  385,  386,  554,  554,
 /*   200 */   554,  554,  554,  554,  551,  552,  495,  497,  551,  552,
 /*   210 */   554,  554,  554,  554,  554,  554,  554,  554,  442,  554,
 /*   220 */   451,  554,  554,  554,  554,  554,  554,  554,  487,  554,
 /*   230 */   554,  554,  554,  554,  554,  554,  554,  414,  554,  554,
 /*   240 */   554,  554,  554,  554,  554,  363,  364,  362,  430,  432,
 /*   250 */   433,  502,  549,  550,  553,  494,  542,  545,  546,  547,
 /*   260 */   548,  496,  499,  479,  480,  481,  501,  520,  524,  523,
 /*   270 */   534,  527,  536,  537,  538,  539,  540,  541,  543,  535,
 /*   280 */   526,  525,  498,  500,  522,  436,  443,  445,  446,  444,
 /*   290 */   458,  461,  462,  463,  464,  465,  466,  467,  468,  469,
 /*   300 */   470,  471,  454,  422,  455,  423,  472,  473,  482,  483,
 /*   310 */   474,  475,  477,  478,  486,  435,  431,  361,  366,  373,
 /*   320 */   403,  404,  405,  406,  407,  396,  372,  397,  399,  402,
 /*   330 */   367,  368,  374,  375,  376,  394,  377,  378,  380,  382,
 /*   340 */   389,  390,  391,  392,  387,  388,  383,  384,  411,  412,
 /*   350 */   408,  409,  410,  418,  419,  421,  417,  424,  427,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         ID => nothing */
    1,  /*      ABORT => ID */
    1,  /*      AFTER => ID */
    1,  /*    ANALYZE => ID */
    1,  /*        ASC => ID */
    1,  /*     ATTACH => ID */
    1,  /*     BEFORE => ID */
    1,  /*      BEGIN => ID */
    1,  /*    CASCADE => ID */
    1,  /*       CAST => ID */
    1,  /*   CONFLICT => ID */
    1,  /*   DATABASE => ID */
    1,  /*   DEFERRED => ID */
    1,  /*       DESC => ID */
    1,  /*     DETACH => ID */
    1,  /*       EACH => ID */
    1,  /*        END => ID */
    1,  /*  EXCLUSIVE => ID */
    1,  /*    EXPLAIN => ID */
    1,  /*       FAIL => ID */
    1,  /*        FOR => ID */
    1,  /*     IGNORE => ID */
    1,  /*  IMMEDIATE => ID */
    1,  /*  INITIALLY => ID */
    1,  /*    INSTEAD => ID */
    1,  /*       LIKE => ID */
    1,  /*      MATCH => ID */
    1,  /*       PLAN => ID */
    1,  /*      QUERY => ID */
    1,  /*        KEY => ID */
    1,  /*         OF => ID */
    1,  /*     OFFSET => ID */
    1,  /*     PRAGMA => ID */
    1,  /*      RAISE => ID */
    1,  /*    REPLACE => ID */
    1,  /*   RESTRICT => ID */
    1,  /*        ROW => ID */
    1,  /*       TEMP => ID */
    1,  /*    TRIGGER => ID */
    1,  /*     VACUUM => ID */
    1,  /*       VIEW => ID */
    1,  /*    VIRTUAL => ID */
    1,  /*    REINDEX => ID */
    1,  /*     RENAME => ID */
    1,  /*   CTIME_KW => ID */
    1,  /*         IF => ID */
    1,  /*  DELIMITER => ID */
    1,  /*     COMMIT => ID */
    1,  /*   ROLLBACK => ID */
    1,  /*  ISOLATION => ID */
    1,  /*      LEVEL => ID */
    1,  /* SERIALIZABLE => ID */
    1,  /*       READ => ID */
    1,  /*  COMMITTED => ID */
    1,  /* UNCOMMITTED => ID */
    1,  /* REPEATABLE => ID */
    1,  /*      WRITE => ID */
    1,  /*       ONLY => ID */
    1,  /*  SAVEPOINT => ID */
    1,  /*    RELEASE => ID */
    1,  /*    COMMENT => ID */
    1,  /*      FORCE => ID */
    1,  /*       WAIT => ID */
    1,  /*     NOWAIT => ID */
    1,  /*      BATCH => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*       DIFF => nothing */
    0,  /*         EQ => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         GT => nothing */
    0,  /*        LEQ => nothing */
    0,  /*         LT => nothing */
    0,  /*        GEQ => nothing */
    0,  /*     REGEXP => nothing */
    0,  /*  REGEXP_CI => nothing */
    0,  /* NOT_REGEXP => nothing */
    0,  /* NOT_REGEXP_CI => nothing */
    0,  /*    SIMILAR => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*    NATURAL => nothing */
    0,  /*       LEFT => nothing */
    0,  /*      RIGHT => nothing */
    0,  /*       FULL => nothing */
    0,  /*      CROSS => nothing */
    0,  /*      UNION => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     PGCAST => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /* SQLCOMMENT => nothing */
    0,  /*       SEMI => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*     STRING => nothing */
    0,  /*      COMMA => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*         TO => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       FROM => nothing */
    0,  /*      WHERE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*        SET => nothing */
    0,  /*        ALL => nothing */
    0,  /*     SELECT => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      GROUP => nothing */
    0,  /*      USING => nothing */
    0,  /*         ON => nothing */
    0,  /*      OUTER => nothing */
    0,  /*        DOT => nothing */
    0,  /*         AS => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*       NULL => nothing */
    0,  /*    TEXTUAL => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*  UNSPECVAL => nothing */
    0,  /*  LSBRACKET => nothing */
    0,  /*  RSBRACKET => nothing */
    0,  /* SIMPLEPARAM => nothing */
    0,  /*      PNAME => nothing */
    0,  /*     PDESCR => nothing */
    0,  /*      PTYPE => nothing */
    0,  /*    PNULLOK => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  gda_sql_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void gda_sql_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "ID",            "ABORT",         "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "END",           "EXCLUSIVE",     "EXPLAIN",     
  "FAIL",          "FOR",           "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "MATCH",       
  "PLAN",          "QUERY",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "TEMP",          "TRIGGER",     
  "VACUUM",        "VIEW",          "VIRTUAL",       "REINDEX",     
  "RENAME",        "CTIME_KW",      "IF",            "DELIMITER",   
  "COMMIT",        "ROLLBACK",      "ISOLATION",     "LEVEL",       
  "SERIALIZABLE",  "READ",          "COMMITTED",     "UNCOMMITTED", 
  "REPEATABLE",    "WRITE",         "ONLY",          "SAVEPOINT",   
  "RELEASE",       "COMMENT",       "FORCE",         "WAIT",        
  "NOWAIT",        "BATCH",         "OR",            "AND",         
  "NOT",           "IS",            "IN",            "ISNULL",      
  "NOTNULL",       "DIFF",          "EQ",            "BETWEEN",     
  "GT",            "LEQ",           "LT",            "GEQ",         
  "REGEXP",        "REGEXP_CI",     "NOT_REGEXP",    "NOT_REGEXP_CI",
  "SIMILAR",       "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "LP",            "RP",            "JOIN",          "INNER",       
  "NATURAL",       "LEFT",          "RIGHT",         "FULL",        
  "CROSS",         "UNION",         "EXCEPT",        "INTERSECT",   
  "PGCAST",        "ILLEGAL",       "SQLCOMMENT",    "SEMI",        
  "END_OF_FILE",   "TRANSACTION",   "STRING",        "COMMA",       
  "INTEGER",       "TO",            "INSERT",        "INTO",        
  "VALUES",        "DELETE",        "FROM",          "WHERE",       
  "UPDATE",        "SET",           "ALL",           "SELECT",      
  "LIMIT",         "ORDER",         "BY",            "HAVING",      
  "GROUP",         "USING",         "ON",            "OUTER",       
  "DOT",           "AS",            "DISTINCT",      "CASE",        
  "WHEN",          "THEN",          "ELSE",          "NULL",        
  "TEXTUAL",       "FLOAT",         "UNSPECVAL",     "LSBRACKET",   
  "RSBRACKET",     "SIMPLEPARAM",   "PNAME",         "PDESCR",      
  "PTYPE",         "PNULLOK",       "error",         "stmt",        
  "cmd",           "eos",           "compound",      "nm_opt",      
  "transtype",     "transilev",     "opt_comma",     "trans_opt_kw",
  "ora_commit_write",  "nm",            "opt_on_conflict",  "fullname",    
  "inscollist_opt",  "exprlist",      "ins_extra_values",  "inscollist",  
  "where_opt",     "expr",          "setlist",       "selectcmd",   
  "opt_compound_all",  "distinct",      "selcollist",    "from",        
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sortlist",      "sortorder",     "nexprlist",     "seltablist",  
  "stl_prefix",    "seltarget",     "on_cond",       "using_opt",   
  "jointype",      "as",            "sclp",          "starname",    
  "value",         "pvalue",        "uni_op",        "case_operand",
  "case_exprlist",  "case_else",     "paramspec",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "stmt ::= cmd eos",
 /*   1 */ "stmt ::= compound eos",
 /*   2 */ "cmd ::= LP cmd RP",
 /*   3 */ "compound ::= LP compound RP",
 /*   4 */ "eos ::= SEMI",
 /*   5 */ "eos ::= END_OF_FILE",
 /*   6 */ "cmd ::= BEGIN",
 /*   7 */ "cmd ::= BEGIN TRANSACTION nm_opt",
 /*   8 */ "cmd ::= BEGIN transtype TRANSACTION nm_opt",
 /*   9 */ "cmd ::= BEGIN transtype nm_opt",
 /*  10 */ "cmd ::= BEGIN transilev",
 /*  11 */ "cmd ::= BEGIN TRANSACTION transilev",
 /*  12 */ "cmd ::= BEGIN TRANSACTION transtype",
 /*  13 */ "cmd ::= BEGIN TRANSACTION transtype opt_comma transilev",
 /*  14 */ "cmd ::= BEGIN TRANSACTION transilev opt_comma transtype",
 /*  15 */ "cmd ::= BEGIN transtype opt_comma transilev",
 /*  16 */ "cmd ::= BEGIN transilev opt_comma transtype",
 /*  17 */ "cmd ::= END trans_opt_kw nm_opt",
 /*  18 */ "cmd ::= COMMIT nm_opt",
 /*  19 */ "cmd ::= COMMIT TRANSACTION nm_opt",
 /*  20 */ "cmd ::= COMMIT FORCE STRING",
 /*  21 */ "cmd ::= COMMIT FORCE STRING COMMA INTEGER",
 /*  22 */ "cmd ::= COMMIT COMMENT STRING",
 /*  23 */ "cmd ::= COMMIT COMMENT STRING ora_commit_write",
 /*  24 */ "cmd ::= COMMIT ora_commit_write",
 /*  25 */ "cmd ::= ROLLBACK trans_opt_kw nm_opt",
 /*  26 */ "ora_commit_write ::= WRITE IMMEDIATE",
 /*  27 */ "ora_commit_write ::= WRITE BATCH",
 /*  28 */ "ora_commit_write ::= WRITE WAIT",
 /*  29 */ "ora_commit_write ::= WRITE NOWAIT",
 /*  30 */ "ora_commit_write ::= WRITE IMMEDIATE WAIT",
 /*  31 */ "ora_commit_write ::= WRITE IMMEDIATE NOWAIT",
 /*  32 */ "ora_commit_write ::= WRITE BATCH WAIT",
 /*  33 */ "ora_commit_write ::= WRITE BATCH NOWAIT",
 /*  34 */ "trans_opt_kw ::=",
 /*  35 */ "trans_opt_kw ::= TRANSACTION",
 /*  36 */ "opt_comma ::=",
 /*  37 */ "opt_comma ::= COMMA",
 /*  38 */ "transilev ::= ISOLATION LEVEL SERIALIZABLE",
 /*  39 */ "transilev ::= ISOLATION LEVEL REPEATABLE READ",
 /*  40 */ "transilev ::= ISOLATION LEVEL READ COMMITTED",
 /*  41 */ "transilev ::= ISOLATION LEVEL READ UNCOMMITTED",
 /*  42 */ "nm_opt ::=",
 /*  43 */ "nm_opt ::= nm",
 /*  44 */ "transtype ::= DEFERRED",
 /*  45 */ "transtype ::= IMMEDIATE",
 /*  46 */ "transtype ::= EXCLUSIVE",
 /*  47 */ "transtype ::= READ WRITE",
 /*  48 */ "transtype ::= READ ONLY",
 /*  49 */ "cmd ::= SAVEPOINT nm",
 /*  50 */ "cmd ::= RELEASE SAVEPOINT nm",
 /*  51 */ "cmd ::= RELEASE nm",
 /*  52 */ "cmd ::= ROLLBACK trans_opt_kw TO nm",
 /*  53 */ "cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm",
 /*  54 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP",
 /*  55 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values",
 /*  56 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound",
 /*  57 */ "opt_on_conflict ::=",
 /*  58 */ "opt_on_conflict ::= OR ID",
 /*  59 */ "ins_extra_values ::= ins_extra_values COMMA LP exprlist RP",
 /*  60 */ "ins_extra_values ::= COMMA LP exprlist RP",
 /*  61 */ "inscollist_opt ::=",
 /*  62 */ "inscollist_opt ::= LP inscollist RP",
 /*  63 */ "inscollist ::= inscollist COMMA fullname",
 /*  64 */ "inscollist ::= fullname",
 /*  65 */ "cmd ::= DELETE FROM fullname where_opt",
 /*  66 */ "where_opt ::=",
 /*  67 */ "where_opt ::= WHERE expr",
 /*  68 */ "cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt",
 /*  69 */ "setlist ::= setlist COMMA fullname EQ expr",
 /*  70 */ "setlist ::= fullname EQ expr",
 /*  71 */ "compound ::= selectcmd",
 /*  72 */ "compound ::= compound UNION opt_compound_all compound",
 /*  73 */ "compound ::= compound EXCEPT opt_compound_all compound",
 /*  74 */ "compound ::= compound INTERSECT opt_compound_all compound",
 /*  75 */ "opt_compound_all ::=",
 /*  76 */ "opt_compound_all ::= ALL",
 /*  77 */ "selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /*  78 */ "limit_opt ::=",
 /*  79 */ "limit_opt ::= LIMIT expr",
 /*  80 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /*  81 */ "limit_opt ::= LIMIT expr COMMA expr",
 /*  82 */ "orderby_opt ::=",
 /*  83 */ "orderby_opt ::= ORDER BY sortlist",
 /*  84 */ "sortlist ::= sortlist COMMA expr sortorder",
 /*  85 */ "sortlist ::= expr sortorder",
 /*  86 */ "sortorder ::= ASC",
 /*  87 */ "sortorder ::= DESC",
 /*  88 */ "sortorder ::=",
 /*  89 */ "having_opt ::=",
 /*  90 */ "having_opt ::= HAVING expr",
 /*  91 */ "groupby_opt ::=",
 /*  92 */ "groupby_opt ::= GROUP BY nexprlist",
 /*  93 */ "from ::=",
 /*  94 */ "from ::= FROM seltablist",
 /*  95 */ "seltablist ::= stl_prefix seltarget on_cond using_opt",
 /*  96 */ "using_opt ::= USING LP inscollist RP",
 /*  97 */ "using_opt ::=",
 /*  98 */ "stl_prefix ::=",
 /*  99 */ "stl_prefix ::= seltablist jointype",
 /* 100 */ "on_cond ::= ON expr",
 /* 101 */ "on_cond ::=",
 /* 102 */ "jointype ::= COMMA",
 /* 103 */ "jointype ::= JOIN",
 /* 104 */ "jointype ::= CROSS JOIN",
 /* 105 */ "jointype ::= INNER JOIN",
 /* 106 */ "jointype ::= NATURAL JOIN",
 /* 107 */ "jointype ::= LEFT JOIN",
 /* 108 */ "jointype ::= LEFT OUTER JOIN",
 /* 109 */ "jointype ::= RIGHT JOIN",
 /* 110 */ "jointype ::= RIGHT OUTER JOIN",
 /* 111 */ "jointype ::= FULL JOIN",
 /* 112 */ "jointype ::= FULL OUTER JOIN",
 /* 113 */ "seltarget ::= fullname as",
 /* 114 */ "seltarget ::= fullname ID",
 /* 115 */ "seltarget ::= LP compound RP as",
 /* 116 */ "sclp ::= selcollist COMMA",
 /* 117 */ "sclp ::=",
 /* 118 */ "selcollist ::= sclp expr as",
 /* 119 */ "selcollist ::= sclp starname",
 /* 120 */ "starname ::= STAR",
 /* 121 */ "starname ::= nm DOT STAR",
 /* 122 */ "starname ::= nm DOT nm DOT STAR",
 /* 123 */ "as ::= AS fullname",
 /* 124 */ "as ::= AS value",
 /* 125 */ "as ::=",
 /* 126 */ "distinct ::=",
 /* 127 */ "distinct ::= ALL",
 /* 128 */ "distinct ::= DISTINCT",
 /* 129 */ "distinct ::= DISTINCT ON expr",
 /* 130 */ "nexprlist ::= nexprlist COMMA expr",
 /* 131 */ "nexprlist ::= expr",
 /* 132 */ "exprlist ::=",
 /* 133 */ "exprlist ::= exprlist COMMA expr",
 /* 134 */ "exprlist ::= expr",
 /* 135 */ "expr ::= pvalue",
 /* 136 */ "expr ::= value",
 /* 137 */ "expr ::= LP expr RP",
 /* 138 */ "expr ::= fullname",
 /* 139 */ "expr ::= fullname LP exprlist RP",
 /* 140 */ "expr ::= fullname LP compound RP",
 /* 141 */ "expr ::= fullname LP starname RP",
 /* 142 */ "expr ::= CAST LP expr AS fullname RP",
 /* 143 */ "expr ::= expr PGCAST fullname",
 /* 144 */ "expr ::= expr PLUS|MINUS expr",
 /* 145 */ "expr ::= expr STAR expr",
 /* 146 */ "expr ::= expr SLASH|REM expr",
 /* 147 */ "expr ::= expr BITAND|BITOR expr",
 /* 148 */ "expr ::= MINUS expr",
 /* 149 */ "expr ::= PLUS expr",
 /* 150 */ "expr ::= expr AND expr",
 /* 151 */ "expr ::= expr OR expr",
 /* 152 */ "expr ::= expr CONCAT expr",
 /* 153 */ "expr ::= expr GT|LEQ|GEQ|LT expr",
 /* 154 */ "expr ::= expr DIFF|EQ expr",
 /* 155 */ "expr ::= expr LIKE expr",
 /* 156 */ "expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr",
 /* 157 */ "expr ::= expr BETWEEN expr AND expr",
 /* 158 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 159 */ "expr ::= NOT expr",
 /* 160 */ "expr ::= BITNOT expr",
 /* 161 */ "expr ::= expr uni_op",
 /* 162 */ "expr ::= expr IS expr",
 /* 163 */ "expr ::= LP compound RP",
 /* 164 */ "expr ::= expr IN LP exprlist RP",
 /* 165 */ "expr ::= expr IN LP compound RP",
 /* 166 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 167 */ "expr ::= expr NOT IN LP compound RP",
 /* 168 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 169 */ "case_operand ::= expr",
 /* 170 */ "case_operand ::=",
 /* 171 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 172 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 173 */ "case_else ::= ELSE expr",
 /* 174 */ "case_else ::=",
 /* 175 */ "uni_op ::= ISNULL",
 /* 176 */ "uni_op ::= IS NOTNULL",
 /* 177 */ "value ::= NULL",
 /* 178 */ "value ::= STRING",
 /* 179 */ "value ::= TEXTUAL",
 /* 180 */ "value ::= INTEGER",
 /* 181 */ "value ::= FLOAT",
 /* 182 */ "pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET",
 /* 183 */ "pvalue ::= value LSBRACKET paramspec RSBRACKET",
 /* 184 */ "pvalue ::= SIMPLEPARAM",
 /* 185 */ "paramspec ::=",
 /* 186 */ "paramspec ::= paramspec PNAME",
 /* 187 */ "paramspec ::= paramspec PDESCR",
 /* 188 */ "paramspec ::= paramspec PTYPE",
 /* 189 */ "paramspec ::= paramspec PNULLOK",
 /* 190 */ "nm ::= JOIN",
 /* 191 */ "nm ::= ID",
 /* 192 */ "fullname ::= nm",
 /* 193 */ "fullname ::= nm DOT nm",
 /* 194 */ "fullname ::= nm DOT nm DOT nm",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to gda_sql_parser and gda_sql_parserFree.
*/
void *gda_sql_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:
    case 77:
    case 78:
    case 79:
    case 80:
    case 81:
    case 82:
    case 83:
    case 84:
    case 85:
    case 86:
    case 87:
    case 88:
    case 89:
    case 90:
    case 91:
    case 92:
    case 93:
    case 94:
    case 95:
    case 96:
    case 97:
    case 98:
    case 99:
    case 100:
    case 101:
    case 102:
    case 103:
    case 104:
    case 105:
    case 106:
    case 107:
    case 108:
    case 109:
    case 110:
    case 111:
    case 112:
    case 113:
    case 114:
    case 115:
    case 116:
    case 117:
    case 118:
    case 119:
    case 120:
    case 121:
    case 122:
    case 123:
    case 124:
    case 125:
    case 126:
    case 127:
    case 128:
    case 129:
    case 130:
    case 131:
    case 132:
    case 133:
    case 134:
    case 135:
    case 136:
    case 137:
    case 138:
    case 139:
    case 140:
    case 141:
    case 142:
    case 143:
    case 144:
    case 145:
    case 146:
    case 147:
    case 148:
    case 149:
    case 150:
    case 151:
    case 152:
    case 153:
    case 154:
    case 155:
    case 156:
    case 157:
#line 9 "parser.y"
{if ((yypminor->yy0)) {
		 gchar *str = gda_sql_value_stringify ((yypminor->yy0));
		 DEBUG ("token destructor /%s/", str);
		 g_free (str);
		 g_value_unset ((yypminor->yy0)); g_free ((yypminor->yy0));}}
#line 1457 "parser.c"
      break;
    case 159:
#line 280 "parser.y"
{g_print ("Statement destroyed by parser: %p\n", (yypminor->yy308)); gda_sql_statement_free ((yypminor->yy308));}
#line 1462 "parser.c"
      break;
    case 160:
    case 162:
    case 179:
#line 303 "parser.y"
{gda_sql_statement_free ((yypminor->yy308));}
#line 1469 "parser.c"
      break;
    case 172:
    case 175:
    case 195:
#line 480 "parser.y"
{if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_field_free, NULL); g_slist_free ((yypminor->yy393));}}
#line 1476 "parser.c"
      break;
    case 173:
    case 190:
#line 766 "parser.y"
{if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy247));}}
#line 1482 "parser.c"
      break;
    case 174:
#line 469 "parser.y"
{GSList *list;
		for (list = (yypminor->yy393); list; list = list->next) {
			g_slist_foreach ((GSList*) list->data, (GFunc) gda_sql_field_free, NULL); 
			g_slist_free ((GSList*) list->data);
		}
		g_slist_free ((yypminor->yy393));
}
#line 1493 "parser.c"
      break;
    case 176:
    case 177:
    case 185:
    case 194:
    case 201:
#line 502 "parser.y"
{gda_sql_expr_free ((yypminor->yy328));}
#line 1502 "parser.c"
      break;
    case 178:
#line 522 "parser.y"
{GSList *list;
	for (list = (yypminor->yy393); list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		g_value_reset (set->fname); g_free (set->fname);
		gda_sql_expr_free (set->expr);
		g_free (set);
	}
	g_slist_free ((yypminor->yy393));
}
#line 1515 "parser.c"
      break;
    case 181:
#line 752 "parser.y"
{if ((yypminor->yy189)) {if ((yypminor->yy189)->expr) gda_sql_expr_free ((yypminor->yy189)->expr); g_free ((yypminor->yy189));}}
#line 1520 "parser.c"
      break;
    case 182:
    case 198:
#line 709 "parser.y"
{g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_field_free, NULL); g_slist_free ((yypminor->yy247));}
#line 1526 "parser.c"
      break;
    case 183:
    case 191:
    case 192:
#line 635 "parser.y"
{gda_sql_select_from_free ((yypminor->yy59));}
#line 1533 "parser.c"
      break;
    case 184:
#line 630 "parser.y"
{if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy393));}}
#line 1538 "parser.c"
      break;
    case 186:
    case 188:
#line 599 "parser.y"
{if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_order_free, NULL); g_slist_free ((yypminor->yy247));}}
#line 1544 "parser.c"
      break;
    case 187:
#line 592 "parser.y"
{gda_sql_expr_free ((yypminor->yy20).count); gda_sql_expr_free ((yypminor->yy20).offset);}
#line 1549 "parser.c"
      break;
    case 193:
#line 694 "parser.y"
{gda_sql_select_target_free ((yypminor->yy224));}
#line 1554 "parser.c"
      break;
    case 203:
    case 205:
#line 930 "parser.y"
{gda_sql_expr_free ((yypminor->yy122));}
#line 1560 "parser.c"
      break;
    case 204:
#line 935 "parser.y"
{g_slist_foreach ((yypminor->yy263).when_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).when_list);
	g_slist_foreach ((yypminor->yy263).then_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).then_list);}
#line 1566 "parser.c"
      break;
    case 206:
#line 973 "parser.y"
{gda_sql_param_spec_free ((yypminor->yy405));}
#line 1571 "parser.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from gda_sql_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void gda_sql_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   gda_sql_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 23 "parser.y"

	gda_sql_parser_set_overflow_error (pdata->parser);
#line 1734 "parser.c"
   gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 159, 2 },
  { 159, 2 },
  { 160, 3 },
  { 162, 3 },
  { 161, 1 },
  { 161, 1 },
  { 160, 1 },
  { 160, 3 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 5 },
  { 160, 4 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 3 },
  { 160, 4 },
  { 160, 2 },
  { 160, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 167, 0 },
  { 167, 1 },
  { 166, 0 },
  { 166, 1 },
  { 165, 3 },
  { 165, 4 },
  { 165, 4 },
  { 165, 4 },
  { 163, 0 },
  { 163, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 2 },
  { 164, 2 },
  { 160, 2 },
  { 160, 3 },
  { 160, 2 },
  { 160, 4 },
  { 160, 5 },
  { 160, 9 },
  { 160, 10 },
  { 160, 6 },
  { 170, 0 },
  { 170, 2 },
  { 174, 5 },
  { 174, 4 },
  { 172, 0 },
  { 172, 3 },
  { 175, 3 },
  { 175, 1 },
  { 160, 4 },
  { 176, 0 },
  { 176, 2 },
  { 160, 6 },
  { 178, 5 },
  { 178, 3 },
  { 162, 1 },
  { 162, 4 },
  { 162, 4 },
  { 162, 4 },
  { 180, 0 },
  { 180, 1 },
  { 179, 9 },
  { 187, 0 },
  { 187, 2 },
  { 187, 4 },
  { 187, 4 },
  { 186, 0 },
  { 186, 3 },
  { 188, 4 },
  { 188, 2 },
  { 189, 1 },
  { 189, 1 },
  { 189, 0 },
  { 185, 0 },
  { 185, 2 },
  { 184, 0 },
  { 184, 3 },
  { 183, 0 },
  { 183, 2 },
  { 191, 4 },
  { 195, 4 },
  { 195, 0 },
  { 192, 0 },
  { 192, 2 },
  { 194, 2 },
  { 194, 0 },
  { 196, 1 },
  { 196, 1 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 193, 2 },
  { 193, 2 },
  { 193, 4 },
  { 198, 2 },
  { 198, 0 },
  { 182, 3 },
  { 182, 2 },
  { 199, 1 },
  { 199, 3 },
  { 199, 5 },
  { 197, 2 },
  { 197, 2 },
  { 197, 0 },
  { 181, 0 },
  { 181, 1 },
  { 181, 1 },
  { 181, 3 },
  { 190, 3 },
  { 190, 1 },
  { 173, 0 },
  { 173, 3 },
  { 173, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 3 },
  { 177, 1 },
  { 177, 4 },
  { 177, 4 },
  { 177, 4 },
  { 177, 6 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 6 },
  { 177, 2 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 5 },
  { 177, 6 },
  { 177, 6 },
  { 177, 5 },
  { 203, 1 },
  { 203, 0 },
  { 204, 5 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 202, 1 },
  { 202, 2 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 201, 4 },
  { 201, 4 },
  { 201, 1 },
  { 206, 0 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 169, 1 },
  { 169, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  gda_sql_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
#line 281 "parser.y"
{pdata->parsed_statement = yymsp[-1].minor.yy308;}
#line 2037 "parser.c"
        break;
      case 1:
#line 282 "parser.y"
{
	GdaSqlStatementCompound *scompound = (GdaSqlStatementCompound *) yymsp[-1].minor.yy308->contents;
	if (scompound->stmt_list->next)
		/* real compound (multiple statements) */
		pdata->parsed_statement = yymsp[-1].minor.yy308;
	else {
		/* false compound (only 1 select) */
		pdata->parsed_statement = (GdaSqlStatement*) scompound->stmt_list->data;
		GDA_SQL_ANY_PART (pdata->parsed_statement->contents)->parent = NULL;
		g_slist_free (scompound->stmt_list);
		scompound->stmt_list = NULL;
		gda_sql_statement_free (yymsp[-1].minor.yy308);
	}
}
#line 2055 "parser.c"
        break;
      case 2:
      case 3:
#line 296 "parser.y"
{yygotominor.yy308 = yymsp[-1].minor.yy308;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2063 "parser.c"
        break;
      case 4:
#line 299 "parser.y"
{
  yy_destructor(115,&yymsp[0].minor);
}
#line 2070 "parser.c"
        break;
      case 5:
#line 300 "parser.y"
{
  yy_destructor(116,&yymsp[0].minor);
}
#line 2077 "parser.c"
        break;
      case 6:
#line 308 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);  yy_destructor(8,&yymsp[0].minor);
}
#line 2083 "parser.c"
        break;
      case 7:
#line 309 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					 gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2092 "parser.c"
        break;
      case 8:
#line 313 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						      gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy361);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-3].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2102 "parser.c"
        break;
      case 9:
#line 318 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					  gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-1].minor.yy361);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-2].minor);
}
#line 2111 "parser.c"
        break;
      case 10:
#line 323 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
				gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-1].minor);
}
#line 2119 "parser.c"
        break;
      case 11:
#line 327 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2128 "parser.c"
        break;
      case 12:
#line 331 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2137 "parser.c"
        break;
      case 13:
#line 335 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy361);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-4].minor);
  yy_destructor(117,&yymsp[-3].minor);
}
#line 2147 "parser.c"
        break;
      case 14:
#line 340 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy361);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(8,&yymsp[-4].minor);
  yy_destructor(117,&yymsp[-3].minor);
}
#line 2157 "parser.c"
        break;
      case 15:
#line 345 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy361);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-3].minor);
}
#line 2166 "parser.c"
        break;
      case 16:
#line 350 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy361);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(8,&yymsp[-3].minor);
}
#line 2175 "parser.c"
        break;
      case 17:
#line 355 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(17,&yymsp[-2].minor);
}
#line 2183 "parser.c"
        break;
      case 18:
#line 359 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
			      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(48,&yymsp[-1].minor);
}
#line 2191 "parser.c"
        break;
      case 19:
#line 363 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(48,&yymsp[-2].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2200 "parser.c"
        break;
      case 20:
#line 367 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-2].minor);
  yy_destructor(62,&yymsp[-1].minor);
  yy_destructor(118,&yymsp[0].minor);
}
#line 2208 "parser.c"
        break;
      case 21:
#line 368 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-4].minor);
  yy_destructor(62,&yymsp[-3].minor);
  yy_destructor(118,&yymsp[-2].minor);
  yy_destructor(119,&yymsp[-1].minor);
  yy_destructor(120,&yymsp[0].minor);
}
#line 2218 "parser.c"
        break;
      case 22:
#line 369 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-2].minor);
  yy_destructor(61,&yymsp[-1].minor);
  yy_destructor(118,&yymsp[0].minor);
}
#line 2226 "parser.c"
        break;
      case 23:
#line 370 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-3].minor);
  yy_destructor(61,&yymsp[-2].minor);
  yy_destructor(118,&yymsp[-1].minor);
}
#line 2234 "parser.c"
        break;
      case 24:
#line 371 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-1].minor);
}
#line 2240 "parser.c"
        break;
      case 25:
#line 373 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK);
					     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(49,&yymsp[-2].minor);
}
#line 2248 "parser.c"
        break;
      case 26:
#line 377 "parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(23,&yymsp[0].minor);
}
#line 2256 "parser.c"
        break;
      case 27:
#line 378 "parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(65,&yymsp[0].minor);
}
#line 2264 "parser.c"
        break;
      case 28:
#line 379 "parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2272 "parser.c"
        break;
      case 29:
#line 380 "parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(64,&yymsp[0].minor);
}
#line 2280 "parser.c"
        break;
      case 30:
#line 381 "parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(23,&yymsp[-1].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2289 "parser.c"
        break;
      case 31:
#line 382 "parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(23,&yymsp[-1].minor);
  yy_destructor(64,&yymsp[0].minor);
}
#line 2298 "parser.c"
        break;
      case 32:
#line 383 "parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2307 "parser.c"
        break;
      case 33:
#line 384 "parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(64,&yymsp[0].minor);
}
#line 2316 "parser.c"
        break;
      case 34:
      case 36:
#line 386 "parser.y"
{
}
#line 2323 "parser.c"
        break;
      case 35:
#line 387 "parser.y"
{
  yy_destructor(117,&yymsp[0].minor);
}
#line 2330 "parser.c"
        break;
      case 37:
#line 390 "parser.y"
{
  yy_destructor(119,&yymsp[0].minor);
}
#line 2337 "parser.c"
        break;
      case 38:
#line 393 "parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_SERIALIZABLE;  yy_destructor(50,&yymsp[-2].minor);
  yy_destructor(51,&yymsp[-1].minor);
  yy_destructor(52,&yymsp[0].minor);
}
#line 2345 "parser.c"
        break;
      case 39:
#line 394 "parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_REPEATABLE_READ;  yy_destructor(50,&yymsp[-3].minor);
  yy_destructor(51,&yymsp[-2].minor);
  yy_destructor(56,&yymsp[-1].minor);
  yy_destructor(53,&yymsp[0].minor);
}
#line 2354 "parser.c"
        break;
      case 40:
#line 395 "parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_COMMITTED;  yy_destructor(50,&yymsp[-3].minor);
  yy_destructor(51,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(54,&yymsp[0].minor);
}
#line 2363 "parser.c"
        break;
      case 41:
#line 396 "parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED;  yy_destructor(50,&yymsp[-3].minor);
  yy_destructor(51,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(55,&yymsp[0].minor);
}
#line 2372 "parser.c"
        break;
      case 42:
      case 57:
      case 125:
#line 398 "parser.y"
{yygotominor.yy361 = NULL;}
#line 2379 "parser.c"
        break;
      case 43:
      case 192:
#line 399 "parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy361;}
#line 2385 "parser.c"
        break;
      case 44:
      case 45:
      case 46:
      case 120:
      case 178:
      case 179:
      case 180:
      case 181:
      case 190:
      case 191:
#line 401 "parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy0;}
#line 2399 "parser.c"
        break;
      case 47:
#line 404 "parser.y"
{yygotominor.yy361 = g_new0 (GValue, 1);
			      g_value_init (yygotominor.yy361, G_TYPE_STRING);
			      g_value_set_string (yygotominor.yy361, "READ_WRITE");
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(57,&yymsp[0].minor);
}
#line 2409 "parser.c"
        break;
      case 48:
#line 408 "parser.y"
{yygotominor.yy361 = g_new0 (GValue, 1);
			     g_value_init (yygotominor.yy361, G_TYPE_STRING);
			     g_value_set_string (yygotominor.yy361, "READ_ONLY");
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(58,&yymsp[0].minor);
}
#line 2419 "parser.c"
        break;
      case 49:
#line 416 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SAVEPOINT);
				    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(59,&yymsp[-1].minor);
}
#line 2427 "parser.c"
        break;
      case 50:
#line 420 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
				     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(60,&yymsp[-2].minor);
  yy_destructor(59,&yymsp[-1].minor);
}
#line 2436 "parser.c"
        break;
      case 51:
#line 424 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
			   gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(60,&yymsp[-1].minor);
}
#line 2444 "parser.c"
        break;
      case 52:
#line 428 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
					    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(49,&yymsp[-3].minor);
  yy_destructor(121,&yymsp[-1].minor);
}
#line 2453 "parser.c"
        break;
      case 53:
#line 432 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(49,&yymsp[-4].minor);
  yy_destructor(121,&yymsp[-2].minor);
  yy_destructor(59,&yymsp[-1].minor);
}
#line 2463 "parser.c"
        break;
      case 54:
#line 439 "parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-5].minor.yy361);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-4].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-7].minor.yy361);
  yy_destructor(122,&yymsp[-8].minor);
  yy_destructor(123,&yymsp[-6].minor);
  yy_destructor(124,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2479 "parser.c"
        break;
      case 55:
#line 447 "parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-6].minor.yy361);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-5].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-2].minor.yy247);
	gda_sql_statement_insert_take_extra_values_list (yygotominor.yy308, yymsp[0].minor.yy393);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-8].minor.yy361);
  yy_destructor(122,&yymsp[-9].minor);
  yy_destructor(123,&yymsp[-7].minor);
  yy_destructor(124,&yymsp[-4].minor);
  yy_destructor(100,&yymsp[-3].minor);
  yy_destructor(101,&yymsp[-1].minor);
}
#line 2496 "parser.c"
        break;
      case 56:
#line 456 "parser.y"
{
        yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
        gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-2].minor.yy361);
        gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-1].minor.yy393);
        gda_sql_statement_insert_take_select (yygotominor.yy308, yymsp[0].minor.yy308);
        gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy361);
  yy_destructor(122,&yymsp[-5].minor);
  yy_destructor(123,&yymsp[-3].minor);
}
#line 2509 "parser.c"
        break;
      case 58:
#line 466 "parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy0;  yy_destructor(66,&yymsp[-1].minor);
}
#line 2515 "parser.c"
        break;
      case 59:
#line 476 "parser.y"
{yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, yymsp[-1].minor.yy247);  yy_destructor(119,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2523 "parser.c"
        break;
      case 60:
#line 477 "parser.y"
{yygotominor.yy393 = g_slist_append (NULL, yymsp[-1].minor.yy247);  yy_destructor(119,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2531 "parser.c"
        break;
      case 61:
      case 97:
#line 481 "parser.y"
{yygotominor.yy393 = NULL;}
#line 2537 "parser.c"
        break;
      case 62:
#line 482 "parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2544 "parser.c"
        break;
      case 63:
#line 486 "parser.y"
{GdaSqlField *field;
						    field = gda_sql_field_new (NULL);
						    gda_sql_field_take_name (field, yymsp[0].minor.yy361);
						    yygotominor.yy393 = g_slist_append (yymsp[-2].minor.yy393, field);
  yy_destructor(119,&yymsp[-1].minor);
}
#line 2554 "parser.c"
        break;
      case 64:
#line 491 "parser.y"
{GdaSqlField *field = gda_sql_field_new (NULL);
				gda_sql_field_take_name (field, yymsp[0].minor.yy361);
				yygotominor.yy393 = g_slist_prepend (NULL, field);
}
#line 2562 "parser.c"
        break;
      case 65:
#line 497 "parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE); 
						  gda_sql_statement_delete_take_table_name (yygotominor.yy308, yymsp[-1].minor.yy361);
						  gda_sql_statement_delete_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);  yy_destructor(125,&yymsp[-3].minor);
  yy_destructor(126,&yymsp[-2].minor);
}
#line 2571 "parser.c"
        break;
      case 66:
      case 89:
      case 101:
#line 503 "parser.y"
{yygotominor.yy328 = NULL;}
#line 2578 "parser.c"
        break;
      case 67:
#line 504 "parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(127,&yymsp[-1].minor);
}
#line 2584 "parser.c"
        break;
      case 68:
#line 507 "parser.y"
{
	GSList *list;
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_UPDATE);
	gda_sql_statement_update_take_table_name (yygotominor.yy308, yymsp[-3].minor.yy361);
	gda_sql_statement_update_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy361);
	gda_sql_statement_update_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);
	for (list = yymsp[-1].minor.yy393; list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		gda_sql_statement_update_take_set_value (yygotominor.yy308, set->fname, set->expr);
		g_free (set);
	}
	g_slist_free (yymsp[-1].minor.yy393);
  yy_destructor(128,&yymsp[-5].minor);
  yy_destructor(129,&yymsp[-2].minor);
}
#line 2603 "parser.c"
        break;
      case 69:
#line 531 "parser.y"
{UpdateSet *set;
							 set = g_new (UpdateSet, 1);
							 set->fname = yymsp[-2].minor.yy361;
							 set->expr = yymsp[0].minor.yy328;
							 yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, set);
  yy_destructor(119,&yymsp[-3].minor);
  yy_destructor(74,&yymsp[-1].minor);
}
#line 2615 "parser.c"
        break;
      case 70:
#line 537 "parser.y"
{UpdateSet *set;
					set = g_new (UpdateSet, 1);
					set->fname = yymsp[-2].minor.yy361;
					set->expr = yymsp[0].minor.yy328;
					yygotominor.yy393 = g_slist_append (NULL, set);
  yy_destructor(74,&yymsp[-1].minor);
}
#line 2626 "parser.c"
        break;
      case 71:
#line 548 "parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
	gda_sql_statement_compound_take_stmt (yygotominor.yy308, yymsp[0].minor.yy308);
}
#line 2634 "parser.c"
        break;
      case 72:
#line 552 "parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_UNION_ALL : GDA_SQL_STATEMENT_COMPOUND_UNION,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(109,&yymsp[-2].minor);
}
#line 2643 "parser.c"
        break;
      case 73:
#line 557 "parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL : GDA_SQL_STATEMENT_COMPOUND_EXCEPT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(110,&yymsp[-2].minor);
}
#line 2652 "parser.c"
        break;
      case 74:
#line 562 "parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL : GDA_SQL_STATEMENT_COMPOUND_INTERSECT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(111,&yymsp[-2].minor);
}
#line 2661 "parser.c"
        break;
      case 75:
#line 568 "parser.y"
{yygotominor.yy216 = FALSE;}
#line 2666 "parser.c"
        break;
      case 76:
#line 569 "parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(130,&yymsp[0].minor);
}
#line 2672 "parser.c"
        break;
      case 77:
#line 576 "parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SELECT);
	if (yymsp[-7].minor.yy189) {
		gda_sql_statement_select_take_distinct (yygotominor.yy308, yymsp[-7].minor.yy189->distinct, yymsp[-7].minor.yy189->expr);
		g_free (yymsp[-7].minor.yy189);
	}
	gda_sql_statement_select_take_expr_list (yygotominor.yy308, yymsp[-6].minor.yy247);
	gda_sql_statement_select_take_from (yygotominor.yy308, yymsp[-5].minor.yy59);
	gda_sql_statement_select_take_where_cond (yygotominor.yy308, yymsp[-4].minor.yy328);
	gda_sql_statement_select_take_group_by (yygotominor.yy308, yymsp[-3].minor.yy393);
	gda_sql_statement_select_take_having_cond (yygotominor.yy308, yymsp[-2].minor.yy328);
	gda_sql_statement_select_take_order_by (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_select_take_limits (yygotominor.yy308, yymsp[0].minor.yy20.count, yymsp[0].minor.yy20.offset);
  yy_destructor(131,&yymsp[-8].minor);
}
#line 2691 "parser.c"
        break;
      case 78:
#line 593 "parser.y"
{yygotominor.yy20.count = NULL; yygotominor.yy20.offset = NULL;}
#line 2696 "parser.c"
        break;
      case 79:
#line 594 "parser.y"
{yygotominor.yy20.count = yymsp[0].minor.yy328; yygotominor.yy20.offset = NULL;  yy_destructor(132,&yymsp[-1].minor);
}
#line 2702 "parser.c"
        break;
      case 80:
#line 595 "parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(132,&yymsp[-3].minor);
  yy_destructor(32,&yymsp[-1].minor);
}
#line 2709 "parser.c"
        break;
      case 81:
#line 596 "parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(132,&yymsp[-3].minor);
  yy_destructor(119,&yymsp[-1].minor);
}
#line 2716 "parser.c"
        break;
      case 82:
#line 600 "parser.y"
{yygotominor.yy247 = 0;}
#line 2721 "parser.c"
        break;
      case 83:
#line 601 "parser.y"
{yygotominor.yy247 = yymsp[0].minor.yy247;  yy_destructor(133,&yymsp[-2].minor);
  yy_destructor(134,&yymsp[-1].minor);
}
#line 2728 "parser.c"
        break;
      case 84:
#line 605 "parser.y"
{GdaSqlSelectOrder *order;
							 order = gda_sql_select_order_new (NULL);
							 order->expr = yymsp[-1].minor.yy328;
							 order->asc = yymsp[0].minor.yy216;
							 yygotominor.yy247 = g_slist_append (yymsp[-3].minor.yy247, order);
  yy_destructor(119,&yymsp[-2].minor);
}
#line 2739 "parser.c"
        break;
      case 85:
#line 611 "parser.y"
{GdaSqlSelectOrder *order;
				       order = gda_sql_select_order_new (NULL);
				       order->expr = yymsp[-1].minor.yy328;
				       order->asc = yymsp[0].minor.yy216;
				       yygotominor.yy247 = g_slist_prepend (NULL, order);
}
#line 2749 "parser.c"
        break;
      case 86:
#line 619 "parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(5,&yymsp[0].minor);
}
#line 2755 "parser.c"
        break;
      case 87:
#line 620 "parser.y"
{yygotominor.yy216 = FALSE;  yy_destructor(14,&yymsp[0].minor);
}
#line 2761 "parser.c"
        break;
      case 88:
#line 621 "parser.y"
{yygotominor.yy216 = TRUE;}
#line 2766 "parser.c"
        break;
      case 90:
#line 627 "parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(135,&yymsp[-1].minor);
}
#line 2772 "parser.c"
        break;
      case 91:
#line 631 "parser.y"
{yygotominor.yy393 = 0;}
#line 2777 "parser.c"
        break;
      case 92:
#line 632 "parser.y"
{yygotominor.yy393 = yymsp[0].minor.yy247;  yy_destructor(136,&yymsp[-2].minor);
  yy_destructor(134,&yymsp[-1].minor);
}
#line 2784 "parser.c"
        break;
      case 93:
      case 98:
#line 636 "parser.y"
{yygotominor.yy59 = NULL;}
#line 2790 "parser.c"
        break;
      case 94:
#line 637 "parser.y"
{yygotominor.yy59 = yymsp[0].minor.yy59;  yy_destructor(126,&yymsp[-1].minor);
}
#line 2796 "parser.c"
        break;
      case 95:
#line 644 "parser.y"
{
	GSList *last;
	if (yymsp[-3].minor.yy59)
		yygotominor.yy59 = yymsp[-3].minor.yy59;
	else 
		yygotominor.yy59 = gda_sql_select_from_new (NULL);
	gda_sql_select_from_take_new_target (yygotominor.yy59, yymsp[-2].minor.yy224);
	last = g_slist_last (yygotominor.yy59->joins);
	if (last) {
		GdaSqlSelectJoin *join = (GdaSqlSelectJoin *) (last->data);
		join->expr = yymsp[-1].minor.yy328;
		join->position = g_slist_length (yygotominor.yy59->targets) - 1;
		join->using = yymsp[0].minor.yy393;
	}
}
#line 2815 "parser.c"
        break;
      case 96:
#line 662 "parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(137,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2823 "parser.c"
        break;
      case 99:
#line 666 "parser.y"
{GdaSqlSelectJoin *join;
					      yygotominor.yy59 = yymsp[-1].minor.yy59;
					      join = gda_sql_select_join_new (GDA_SQL_ANY_PART (yygotominor.yy59));
					      join->type = yymsp[0].minor.yy317;
					      gda_sql_select_from_take_new_join (yygotominor.yy59, join);
}
#line 2833 "parser.c"
        break;
      case 100:
#line 676 "parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(138,&yymsp[-1].minor);
}
#line 2839 "parser.c"
        break;
      case 102:
#line 680 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(119,&yymsp[0].minor);
}
#line 2845 "parser.c"
        break;
      case 103:
#line 681 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(102,&yymsp[0].minor);
}
#line 2851 "parser.c"
        break;
      case 104:
#line 682 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(108,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2858 "parser.c"
        break;
      case 105:
#line 683 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(103,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2865 "parser.c"
        break;
      case 106:
#line 684 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_NATURAL;  yy_destructor(104,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2872 "parser.c"
        break;
      case 107:
#line 685 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(105,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2879 "parser.c"
        break;
      case 108:
#line 686 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(105,&yymsp[-2].minor);
  yy_destructor(139,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2887 "parser.c"
        break;
      case 109:
#line 687 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(106,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2894 "parser.c"
        break;
      case 110:
#line 688 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(106,&yymsp[-2].minor);
  yy_destructor(139,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2902 "parser.c"
        break;
      case 111:
#line 689 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(107,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2909 "parser.c"
        break;
      case 112:
#line 690 "parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(107,&yymsp[-2].minor);
  yy_destructor(139,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2917 "parser.c"
        break;
      case 113:
#line 695 "parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
				     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy361);
				     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy361);
}
#line 2925 "parser.c"
        break;
      case 114:
#line 699 "parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
                                     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy0);
                                     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy361);
}
#line 2933 "parser.c"
        break;
      case 115:
#line 703 "parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
					     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy361);
					     gda_sql_select_target_take_select (yygotominor.yy224, yymsp[-2].minor.yy308);
  yy_destructor(100,&yymsp[-3].minor);
  yy_destructor(101,&yymsp[-1].minor);
}
#line 2943 "parser.c"
        break;
      case 116:
#line 713 "parser.y"
{yygotominor.yy247 = yymsp[-1].minor.yy247;  yy_destructor(119,&yymsp[0].minor);
}
#line 2949 "parser.c"
        break;
      case 117:
      case 132:
#line 714 "parser.y"
{yygotominor.yy247 = NULL;}
#line 2955 "parser.c"
        break;
      case 118:
#line 716 "parser.y"
{GdaSqlSelectField *field;
					  field = gda_sql_select_field_new (NULL);
					  gda_sql_select_field_take_expr (field, yymsp[-1].minor.yy328);
					  gda_sql_select_field_take_alias (field, yymsp[0].minor.yy361); 
					  yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, field);}
#line 2964 "parser.c"
        break;
      case 119:
#line 721 "parser.y"
{GdaSqlSelectField *field;
					field = gda_sql_select_field_new (NULL);
					gda_sql_select_field_take_star_value (field, yymsp[0].minor.yy361);
					yygotominor.yy247 = g_slist_append (yymsp[-1].minor.yy247, field);}
#line 2972 "parser.c"
        break;
      case 121:
#line 727 "parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(140,&yymsp[-1].minor);
}
#line 2985 "parser.c"
        break;
      case 122:
#line 736 "parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy361), 
							 g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-4].minor.yy361); g_free (yymsp[-4].minor.yy361);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(140,&yymsp[-3].minor);
  yy_destructor(140,&yymsp[-1].minor);
}
#line 3001 "parser.c"
        break;
      case 123:
      case 124:
#line 747 "parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy361;  yy_destructor(141,&yymsp[-1].minor);
}
#line 3008 "parser.c"
        break;
      case 126:
#line 753 "parser.y"
{yygotominor.yy189 = NULL;}
#line 3013 "parser.c"
        break;
      case 127:
#line 754 "parser.y"
{yygotominor.yy189 = NULL;  yy_destructor(130,&yymsp[0].minor);
}
#line 3019 "parser.c"
        break;
      case 128:
#line 755 "parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE;  yy_destructor(142,&yymsp[0].minor);
}
#line 3025 "parser.c"
        break;
      case 129:
#line 756 "parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE; yygotominor.yy189->expr = yymsp[0].minor.yy328;  yy_destructor(142,&yymsp[-2].minor);
  yy_destructor(138,&yymsp[-1].minor);
}
#line 3032 "parser.c"
        break;
      case 130:
      case 133:
#line 761 "parser.y"
{yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, yymsp[0].minor.yy328);  yy_destructor(119,&yymsp[-1].minor);
}
#line 3039 "parser.c"
        break;
      case 131:
      case 134:
#line 762 "parser.y"
{yygotominor.yy247 = g_slist_append (NULL, yymsp[0].minor.yy328);}
#line 3045 "parser.c"
        break;
      case 135:
#line 774 "parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;}
#line 3050 "parser.c"
        break;
      case 136:
      case 138:
#line 775 "parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[0].minor.yy361;}
#line 3056 "parser.c"
        break;
      case 137:
#line 776 "parser.y"
{yygotominor.yy328 = yymsp[-1].minor.yy328;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3063 "parser.c"
        break;
      case 139:
#line 778 "parser.y"
{GdaSqlFunction *func;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy361);
					    gda_sql_function_take_args_list (func, yymsp[-1].minor.yy247);
					    yygotominor.yy328->func = func;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3075 "parser.c"
        break;
      case 140:
#line 784 "parser.y"
{GdaSqlFunction *func;
					     GdaSqlExpr *expr;
					     yygotominor.yy328 = gda_sql_expr_new (NULL); 
					     func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					     gda_sql_function_take_name (func, yymsp[-3].minor.yy361);
					     expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					     gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					     gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					     yygotominor.yy328->func = func;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3090 "parser.c"
        break;
      case 141:
#line 793 "parser.y"
{GdaSqlFunction *func;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy361);
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					    expr->value = yymsp[-1].minor.yy361;
					    gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					    yygotominor.yy328->func = func;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3105 "parser.c"
        break;
      case 142:
#line 802 "parser.y"
{yygotominor.yy328 = yymsp[-3].minor.yy328;
						yymsp[-3].minor.yy328->cast_as = g_value_dup_string (yymsp[-1].minor.yy361);
						g_value_reset (yymsp[-1].minor.yy361);
						g_free (yymsp[-1].minor.yy361);  yy_destructor(10,&yymsp[-5].minor);
  yy_destructor(100,&yymsp[-4].minor);
  yy_destructor(141,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3117 "parser.c"
        break;
      case 143:
#line 806 "parser.y"
{yygotominor.yy328 = yymsp[-2].minor.yy328;
					 yymsp[-2].minor.yy328->cast_as = g_value_dup_string (yymsp[0].minor.yy361);
					 g_value_reset (yymsp[0].minor.yy361);
					 g_free (yymsp[0].minor.yy361);  yy_destructor(112,&yymsp[-1].minor);
}
#line 3126 "parser.c"
        break;
      case 144:
#line 811 "parser.y"
{yygotominor.yy328 = compose_multiple_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3131 "parser.c"
        break;
      case 145:
#line 812 "parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_STAR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(92,&yymsp[-1].minor);
}
#line 3137 "parser.c"
        break;
      case 146:
      case 147:
      case 153:
      case 154:
      case 156:
#line 813 "parser.y"
{yygotominor.yy328 = create_two_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3146 "parser.c"
        break;
      case 148:
#line 816 "parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_MINUS, yymsp[0].minor.yy328);  yy_destructor(91,&yymsp[-1].minor);
}
#line 3152 "parser.c"
        break;
      case 149:
#line 817 "parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_PLUS, yymsp[0].minor.yy328);  yy_destructor(90,&yymsp[-1].minor);
}
#line 3158 "parser.c"
        break;
      case 150:
#line 819 "parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_AND, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(67,&yymsp[-1].minor);
}
#line 3164 "parser.c"
        break;
      case 151:
#line 820 "parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_OR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(66,&yymsp[-1].minor);
}
#line 3170 "parser.c"
        break;
      case 152:
#line 821 "parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_CONCAT, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(95,&yymsp[-1].minor);
}
#line 3176 "parser.c"
        break;
      case 155:
#line 825 "parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_LIKE, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(26,&yymsp[-1].minor);
}
#line 3182 "parser.c"
        break;
      case 157:
#line 827 "parser.y"
{GdaSqlOperation *cond;
						  yygotominor.yy328 = gda_sql_expr_new (NULL);
						  cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						  yygotominor.yy328->cond = cond;
						  cond->operator = GDA_SQL_OPERATOR_BETWEEN;
						  cond->operands = g_slist_append (NULL, yymsp[-4].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(75,&yymsp[-3].minor);
  yy_destructor(67,&yymsp[-1].minor);
}
#line 3200 "parser.c"
        break;
      case 158:
#line 840 "parser.y"
{GdaSqlOperation *cond;
						      GdaSqlExpr *expr;
						      expr = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (expr));
						      expr->cond = cond;
						      cond->operator = GDA_SQL_OPERATOR_BETWEEN;
						      cond->operands = g_slist_append (NULL, yymsp[-5].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);

						      yygotominor.yy328 = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						      yygotominor.yy328->cond = cond;
						      cond->operator = GDA_SQL_OPERATOR_NOT;
						      cond->operands = g_slist_prepend (NULL, expr);
						      GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(68,&yymsp[-4].minor);
  yy_destructor(75,&yymsp[-3].minor);
  yy_destructor(67,&yymsp[-1].minor);
}
#line 3227 "parser.c"
        break;
      case 159:
#line 861 "parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_NOT, yymsp[0].minor.yy328);  yy_destructor(68,&yymsp[-1].minor);
}
#line 3233 "parser.c"
        break;
      case 160:
#line 862 "parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_BITNOT, yymsp[0].minor.yy328);  yy_destructor(99,&yymsp[-1].minor);
}
#line 3239 "parser.c"
        break;
      case 161:
#line 863 "parser.y"
{yygotominor.yy328 = create_uni_expr (yymsp[0].minor.yy119, yymsp[-1].minor.yy328);}
#line 3244 "parser.c"
        break;
      case 162:
#line 865 "parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_IS, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(69,&yymsp[-1].minor);
}
#line 3250 "parser.c"
        break;
      case 163:
#line 866 "parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); gda_sql_expr_take_select (yygotominor.yy328, yymsp[-1].minor.yy308);  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3257 "parser.c"
        break;
      case 164:
#line 867 "parser.y"
{GdaSqlOperation *cond;
					   GSList *list;
					   yygotominor.yy328 = gda_sql_expr_new (NULL);
					   cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					   yygotominor.yy328->cond = cond;
					   cond->operator = GDA_SQL_OPERATOR_IN;
					   cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-4].minor.yy328);
					   for (list = cond->operands; list; list = list->next)
						   GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(70,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3274 "parser.c"
        break;
      case 165:
#line 877 "parser.y"
{GdaSqlOperation *cond;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL);
					    cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    yygotominor.yy328->cond = cond;
					    cond->operator = GDA_SQL_OPERATOR_IN;
					    
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					    gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					    cond->operands = g_slist_prepend (NULL, expr);
					    cond->operands = g_slist_prepend (cond->operands, yymsp[-4].minor.yy328);
					    GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(70,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3294 "parser.c"
        break;
      case 166:
#line 890 "parser.y"
{GdaSqlOperation *cond;
					       GSList *list;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator = GDA_SQL_OPERATOR_NOTIN;
					       cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-5].minor.yy328);
					       for (list = cond->operands; list; list = list->next)
						       GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(68,&yymsp[-4].minor);
  yy_destructor(70,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3312 "parser.c"
        break;
      case 167:
#line 900 "parser.y"
{GdaSqlOperation *cond;
					       GdaSqlExpr *expr;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator = GDA_SQL_OPERATOR_NOTIN;
					       
					       expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					       gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					       cond->operands = g_slist_prepend (NULL, expr);
					       cond->operands = g_slist_prepend (cond->operands, yymsp[-5].minor.yy328);
					       GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(68,&yymsp[-4].minor);
  yy_destructor(70,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3333 "parser.c"
        break;
      case 168:
#line 913 "parser.y"
{
	GdaSqlCase *sc;
	GSList *list;
	yygotominor.yy328 = gda_sql_expr_new (NULL);
	sc = gda_sql_case_new (GDA_SQL_ANY_PART (yygotominor.yy328));
	sc->base_expr = yymsp[-3].minor.yy122;
	sc->else_expr = yymsp[-1].minor.yy122;
	sc->when_expr_list = yymsp[-2].minor.yy263.when_list;
	sc->then_expr_list = yymsp[-2].minor.yy263.then_list;
	yygotominor.yy328->case_s = sc;
	for (list = sc->when_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
	for (list = sc->then_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
  yy_destructor(143,&yymsp[-4].minor);
  yy_destructor(17,&yymsp[0].minor);
}
#line 3354 "parser.c"
        break;
      case 169:
#line 931 "parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;}
#line 3359 "parser.c"
        break;
      case 170:
      case 174:
#line 932 "parser.y"
{yygotominor.yy122 = NULL;}
#line 3365 "parser.c"
        break;
      case 171:
#line 938 "parser.y"
{
	yygotominor.yy263.when_list = g_slist_append (yymsp[-4].minor.yy263.when_list, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_append (yymsp[-4].minor.yy263.then_list, yymsp[0].minor.yy328);
  yy_destructor(144,&yymsp[-3].minor);
  yy_destructor(145,&yymsp[-1].minor);
}
#line 3375 "parser.c"
        break;
      case 172:
#line 942 "parser.y"
{
	yygotominor.yy263.when_list = g_slist_prepend (NULL, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_prepend (NULL, yymsp[0].minor.yy328);
  yy_destructor(144,&yymsp[-3].minor);
  yy_destructor(145,&yymsp[-1].minor);
}
#line 3385 "parser.c"
        break;
      case 173:
#line 949 "parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;  yy_destructor(146,&yymsp[-1].minor);
}
#line 3391 "parser.c"
        break;
      case 175:
#line 953 "parser.y"
{yygotominor.yy119 = GDA_SQL_OPERATOR_ISNULL;  yy_destructor(71,&yymsp[0].minor);
}
#line 3397 "parser.c"
        break;
      case 176:
#line 954 "parser.y"
{yygotominor.yy119 = GDA_SQL_OPERATOR_ISNOTNULL;  yy_destructor(69,&yymsp[-1].minor);
  yy_destructor(72,&yymsp[0].minor);
}
#line 3404 "parser.c"
        break;
      case 177:
#line 958 "parser.y"
{yygotominor.yy361 = NULL;  yy_destructor(147,&yymsp[0].minor);
}
#line 3410 "parser.c"
        break;
      case 182:
#line 967 "parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(150,&yymsp[-3].minor);
  yy_destructor(151,&yymsp[-2].minor);
  yy_destructor(152,&yymsp[0].minor);
}
#line 3418 "parser.c"
        break;
      case 183:
#line 968 "parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[-3].minor.yy361; yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(151,&yymsp[-2].minor);
  yy_destructor(152,&yymsp[0].minor);
}
#line 3425 "parser.c"
        break;
      case 184:
#line 969 "parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = gda_sql_param_spec_new (yymsp[0].minor.yy0);}
#line 3430 "parser.c"
        break;
      case 185:
#line 974 "parser.y"
{yygotominor.yy405 = NULL;}
#line 3435 "parser.c"
        break;
      case 186:
#line 975 "parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_name (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3441 "parser.c"
        break;
      case 187:
#line 977 "parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_descr (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3447 "parser.c"
        break;
      case 188:
#line 979 "parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_type (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3453 "parser.c"
        break;
      case 189:
#line 981 "parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					   gda_sql_param_spec_take_nullok (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3459 "parser.c"
        break;
      case 193:
#line 991 "parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy361));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy361); g_free (yymsp[0].minor.yy361);
  yy_destructor(140,&yymsp[-1].minor);
}
#line 3472 "parser.c"
        break;
      case 194:
#line 1000 "parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy361), 
							 g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy361));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-4].minor.yy361); g_free (yymsp[-4].minor.yy361);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy361); g_free (yymsp[0].minor.yy361);
  yy_destructor(140,&yymsp[-3].minor);
  yy_destructor(140,&yymsp[-1].minor);
}
#line 3488 "parser.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  gda_sql_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 20 "parser.y"

	gda_sql_parser_set_syntax_error (pdata->parser);
#line 3549 "parser.c"
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "gda_sql_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void gda_sql_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  gda_sql_parserTOKENTYPE yyminor       /* The value for the token */
  gda_sql_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  gda_sql_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
