/* Record.c generated by valac 0.15.2.9-69beb, the Vala compiler
 * generated from Record.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdavala
 * Copyright (C) Daniel Espinosa Ortiz 2012 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define GDA_DATA_TYPE_DB_OBJECT (gda_data_db_object_get_type ())
#define GDA_DATA_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObject))
#define GDA_DATA_IS_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_OBJECT))
#define GDA_DATA_DB_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObjectIface))

typedef struct _GdaDataDbObject GdaDataDbObject;
typedef struct _GdaDataDbObjectIface GdaDataDbObjectIface;

#define GDA_DATA_TYPE_DB_RECORD (gda_data_db_record_get_type ())
#define GDA_DATA_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecord))
#define GDA_DATA_IS_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD))
#define GDA_DATA_DB_RECORD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecordIface))

typedef struct _GdaDataDbRecord GdaDataDbRecord;
typedef struct _GdaDataDbRecordIface GdaDataDbRecordIface;

#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())

#define GDA_DATA_TYPE_DB_NAMED_OBJECT (gda_data_db_named_object_get_type ())
#define GDA_DATA_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObject))
#define GDA_DATA_IS_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT))
#define GDA_DATA_DB_NAMED_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObjectIface))

typedef struct _GdaDataDbNamedObject GdaDataDbNamedObject;
typedef struct _GdaDataDbNamedObjectIface GdaDataDbNamedObjectIface;

#define GDA_DATA_TYPE_DB_TABLE (gda_data_db_table_get_type ())
#define GDA_DATA_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTable))
#define GDA_DATA_IS_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_TABLE))
#define GDA_DATA_DB_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTableIface))

typedef struct _GdaDataDbTable GdaDataDbTable;
typedef struct _GdaDataDbTableIface GdaDataDbTableIface;

#define GDA_DATA_TYPE_DB_FIELD_INFO (gda_data_db_field_info_get_type ())
#define GDA_DATA_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfo))
#define GDA_DATA_IS_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO))
#define GDA_DATA_DB_FIELD_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfoIface))

typedef struct _GdaDataDbFieldInfo GdaDataDbFieldInfo;
typedef struct _GdaDataDbFieldInfoIface GdaDataDbFieldInfoIface;

#define GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE (gda_data_db_field_info_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY (gda_data_db_field_info_foreign_key_get_type ())
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))

typedef struct _GdaDataDbFieldInfoForeignKey GdaDataDbFieldInfoForeignKey;
typedef struct _GdaDataDbFieldInfoForeignKeyClass GdaDataDbFieldInfoForeignKeyClass;

#define GDA_DATA_TYPE_DB_CATALOG (gda_data_db_catalog_get_type ())
#define GDA_DATA_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalog))
#define GDA_DATA_IS_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_CATALOG))
#define GDA_DATA_DB_CATALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalogIface))

typedef struct _GdaDataDbCatalog GdaDataDbCatalog;
typedef struct _GdaDataDbCatalogIface GdaDataDbCatalogIface;

#define GDA_DATA_TYPE_DB_SCHEMA (gda_data_db_schema_get_type ())
#define GDA_DATA_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema))
#define GDA_DATA_IS_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_SCHEMA))
#define GDA_DATA_DB_SCHEMA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchemaIface))

typedef struct _GdaDataDbSchema GdaDataDbSchema;
typedef struct _GdaDataDbSchemaIface GdaDataDbSchemaIface;

#define GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE (gda_data_db_table_table_type_get_type ())

#define GDA_DATA_TYPE_RECORD (gda_data_record_get_type ())
#define GDA_DATA_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_RECORD, GdaDataRecord))
#define GDA_DATA_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_RECORD, GdaDataRecordClass))
#define GDA_DATA_IS_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_RECORD))
#define GDA_DATA_IS_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_RECORD))
#define GDA_DATA_RECORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_RECORD, GdaDataRecordClass))

typedef struct _GdaDataRecord GdaDataRecord;
typedef struct _GdaDataRecordClass GdaDataRecordClass;
typedef struct _GdaDataRecordPrivate GdaDataRecordPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GDA_DATA_TYPE_FIELD (gda_data_field_get_type ())
#define GDA_DATA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_FIELD, GdaDataField))
#define GDA_DATA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_FIELD, GdaDataFieldClass))
#define GDA_DATA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_FIELD))
#define GDA_DATA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_FIELD))
#define GDA_DATA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_FIELD, GdaDataFieldClass))

typedef struct _GdaDataField GdaDataField;
typedef struct _GdaDataFieldClass GdaDataFieldClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GdaDataDbObjectIface {
	GTypeInterface parent_iface;
	void (*append) (GdaDataDbObject* self, GError** error);
	void (*update) (GdaDataDbObject* self, GError** error);
	void (*save) (GdaDataDbObject* self, GError** error);
	void (*drop) (GdaDataDbObject* self, gboolean cascade, GError** error);
	GdaConnection* (*get_connection) (GdaDataDbObject* self);
	void (*set_connection) (GdaDataDbObject* self, GdaConnection* value);
	gboolean (*get_update_meta) (GdaDataDbObject* self);
	void (*set_update_meta) (GdaDataDbObject* self, gboolean value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};

struct _GdaDataDbNamedObjectIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GdaDataDbNamedObject* self);
	void (*set_name) (GdaDataDbNamedObject* self, const gchar* value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY = 1 << 1,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE = 1 << 2,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY = 1 << 3,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK = 1 << 4,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT = 1 << 5,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL = 1 << 6,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT = 1 << 7
} GdaDataDbFieldInfoAttribute;

struct _GdaDataDbFieldInfoIface {
	GTypeInterface parent_iface;
	gint (*get_ordinal) (GdaDataDbFieldInfo* self);
	void (*set_ordinal) (GdaDataDbFieldInfo* self, gint value);
	GType (*get_value_type) (GdaDataDbFieldInfo* self);
	void (*set_value_type) (GdaDataDbFieldInfo* self, GType value);
	GdaDataDbFieldInfoAttribute (*get_attributes) (GdaDataDbFieldInfo* self);
	void (*set_attributes) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
	GValue* (*get_default_value) (GdaDataDbFieldInfo* self);
	void (*set_default_value) (GdaDataDbFieldInfo* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbFieldInfo* self);
	void (*set_name) (GdaDataDbFieldInfo* self, const gchar* value);
	const gchar* (*get_desc) (GdaDataDbFieldInfo* self);
	void (*set_desc) (GdaDataDbFieldInfo* self, const gchar* value);
	gint (*get_precision) (GdaDataDbFieldInfo* self);
	void (*set_precision) (GdaDataDbFieldInfo* self, gint value);
	gint (*get_scale) (GdaDataDbFieldInfo* self);
	void (*set_scale) (GdaDataDbFieldInfo* self, gint value);
	GdaDataDbFieldInfoForeignKey* (*get_fkey) (GdaDataDbFieldInfo* self);
	void (*set_fkey) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
};

struct _GdaDataDbSchemaIface {
	GTypeInterface parent_iface;
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbSchema* self);
	void (*set_catalog) (GdaDataDbSchema* self, GdaDataDbCatalog* value);
	GeeCollection* (*get_tables) (GdaDataDbSchema* self);
};

struct _GdaDataDbCatalogIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_shemas) (GdaDataDbCatalog* self);
	void (*set_shemas) (GdaDataDbCatalog* self, GeeCollection* value);
};

typedef enum  {
	GDA_DATA_DB_TABLE_TABLE_TYPE_NONE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW,
	GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM
} GdaDataDbTableTableType;

struct _GdaDataDbTableIface {
	GTypeInterface parent_iface;
	void (*set_field) (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
	GdaDataDbFieldInfo* (*get_field) (GdaDataDbTable* self, const gchar* name, GError** error);
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbTable* self);
	void (*set_catalog) (GdaDataDbTable* self, GdaDataDbCatalog* value);
	GdaDataDbSchema* (*get_schema) (GdaDataDbTable* self);
	void (*set_schema) (GdaDataDbTable* self, GdaDataDbSchema* value);
	GdaDataDbTableTableType (*get_table_type) (GdaDataDbTable* self);
	void (*set_table_type) (GdaDataDbTable* self, GdaDataDbTableTableType value);
	GeeCollection* (*get_records) (GdaDataDbTable* self);
	GeeCollection* (*get_depends) (GdaDataDbTable* self);
	GeeCollection* (*get_referenced) (GdaDataDbTable* self);
	GeeCollection* (*get_fields) (GdaDataDbTable* self);
	GeeCollection* (*get_primary_keys) (GdaDataDbTable* self);
};

struct _GdaDataDbRecordIface {
	GTypeInterface parent_iface;
	GValue* (*get_value) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_field) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_field_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_field) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_key) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_key_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_key) (GdaDataDbRecord* self, const gchar* name, GError** error);
	gchar* (*to_string) (GdaDataDbRecord* self);
	GdaDataDbTable* (*get_table) (GdaDataDbRecord* self);
	void (*set_table) (GdaDataDbRecord* self, GdaDataDbTable* value);
	GeeCollection* (*get_fields) (GdaDataDbRecord* self);
	GeeCollection* (*get_keys) (GdaDataDbRecord* self);
};

struct _GdaDataRecord {
	GObject parent_instance;
	GdaDataRecordPrivate * priv;
	GeeHashMap* _fields;
	GeeHashMap* _keys;
};

struct _GdaDataRecordClass {
	GObjectClass parent_class;
};

struct _GdaDataRecordPrivate {
	gboolean _update_meta;
	GdaDataDbTable* _table;
	GdaConnection* _connection;
};

typedef enum  {
	GDA_DATA_DB_OBJECT_ERROR_APPEND,
	GDA_DATA_DB_OBJECT_ERROR_UPDATE,
	GDA_DATA_DB_OBJECT_ERROR_SAVE,
	GDA_DATA_DB_OBJECT_ERROR_DROP
} GdaDataDbObjectError;
#define GDA_DATA_DB_OBJECT_ERROR gda_data_db_object_error_quark ()

static gpointer gda_data_record_parent_class = NULL;
static GdaDataDbObjectIface* gda_data_record_gda_data_db_object_parent_iface = NULL;
static GeeComparableIface* gda_data_record_gee_comparable_parent_iface = NULL;
static GdaDataDbRecordIface* gda_data_record_gda_data_db_record_parent_iface = NULL;

GType gda_data_db_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GType gda_data_db_named_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_attribute_get_type (void) G_GNUC_CONST;
gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance);
void gda_data_db_field_info_foreign_key_unref (gpointer instance);
GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gda_data_db_field_info_value_set_foreign_key (GValue* value, gpointer v_object);
void gda_data_db_field_info_value_take_foreign_key (GValue* value, gpointer v_object);
gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value);
GType gda_data_db_field_info_foreign_key_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_get_type (void) G_GNUC_CONST;
GType gda_data_db_schema_get_type (void) G_GNUC_CONST;
GType gda_data_db_catalog_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_table_type_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_get_type (void) G_GNUC_CONST;
GType gda_data_record_get_type (void) G_GNUC_CONST;
#define GDA_DATA_RECORD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GDA_DATA_TYPE_RECORD, GdaDataRecordPrivate))
enum  {
	GDA_DATA_RECORD_DUMMY_PROPERTY,
	GDA_DATA_RECORD_TABLE,
	GDA_DATA_RECORD_FIELDS,
	GDA_DATA_RECORD_KEYS,
	GDA_DATA_RECORD_CONNECTION,
	GDA_DATA_RECORD_UPDATE_META
};
static GValue* gda_data_record_real_get_value (GdaDataDbRecord* base, const gchar* field, GError** error);
GValue* gda_data_db_field_get_value (GdaDataDbField* self);
static GValue* _g_value_dup (GValue* self);
static void gda_data_record_real_set_field (GdaDataDbRecord* base, GdaDataDbField* field, GError** error);
const gchar* gda_data_db_field_get_name (GdaDataDbField* self);
void gda_data_db_field_set_value (GdaDataDbField* self, GValue* value);
GdaDataField* gda_data_field_new (const gchar* col_name, GdaDataDbFieldAttribute attr);
GdaDataField* gda_data_field_construct (GType object_type, const gchar* col_name, GdaDataDbFieldAttribute attr);
GType gda_data_field_get_type (void) G_GNUC_CONST;
static void gda_data_record_real_set_field_value (GdaDataDbRecord* base, const gchar* field, GValue* val, GError** error);
void gda_data_db_record_set_field (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
static GdaDataDbField* gda_data_record_real_get_field (GdaDataDbRecord* base, const gchar* name, GError** error);
static void gda_data_record_real_set_key (GdaDataDbRecord* base, GdaDataDbField* field, GError** error);
static void gda_data_record_real_set_key_value (GdaDataDbRecord* base, const gchar* key, GValue* val, GError** error);
void gda_data_db_record_set_key (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
static GdaDataDbField* gda_data_record_real_get_key (GdaDataDbRecord* base, const gchar* name, GError** error);
static void gda_data_record_real_save (GdaDataDbObject* base, GError** error);
GeeCollection* gda_data_db_record_get_fields (GdaDataDbRecord* self);
GQuark gda_data_db_object_error_quark (void);
GeeCollection* gda_data_db_record_get_keys (GdaDataDbRecord* self);
GdaDataDbTable* gda_data_db_record_get_table (GdaDataDbRecord* self);
const gchar* gda_data_db_named_object_get_name (GdaDataDbNamedObject* self);
const gchar* gda_data_db_field_get_column_name (GdaDataDbField* self);
GdaConnection* gda_data_db_object_get_connection (GdaDataDbObject* self);
static void gda_data_record_real_update (GdaDataDbObject* base, GError** error);
gboolean gda_data_db_object_get_update_meta (GdaDataDbObject* self);
void gda_data_db_object_set_update_meta (GdaDataDbObject* self, gboolean value);
static void gda_data_record_real_append (GdaDataDbObject* base, GError** error);
static void gda_data_record_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error);
static gchar* gda_data_record_real_to_string (GdaDataDbRecord* base);
static gint gda_data_record_real_compare_to (GeeComparable* base, GdaDataDbRecord* object);
GdaDataDbField* gda_data_db_record_get_field (GdaDataDbRecord* self, const gchar* name, GError** error);
GdaDataRecord* gda_data_record_new (void);
GdaDataRecord* gda_data_record_construct (GType object_type);
static void gda_data_record_finalize (GObject* obj);
static void _vala_gda_data_record_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gda_data_db_record_set_table (GdaDataDbRecord* self, GdaDataDbTable* value);
void gda_data_db_object_set_connection (GdaDataDbObject* self, GdaConnection* value);
static void _vala_gda_data_record_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
         * Returns a GLib.Value containing the value stored in the given field.
         */
static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static GValue* gda_data_record_real_get_value (GdaDataDbRecord* base, const gchar* field, GError** error) {
	GdaDataRecord * self;
	GValue* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	GdaDataDbField* f;
	GValue* _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_;
	self = (GdaDataRecord*) base;
	g_return_val_if_fail (field != NULL, NULL);
	_tmp0_ = self->_fields;
	_tmp1_ = field;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	f = (GdaDataDbField*) _tmp2_;
	_tmp3_ = gda_data_db_field_get_value (f);
	_tmp4_ = _tmp3_;
	_tmp5_ = __g_value_dup0 (_tmp4_);
	result = _tmp5_;
	_g_object_unref0 (f);
	return result;
}


/**
         * Set the value to a field with the given @name.
         */
static void gda_data_record_real_set_field (GdaDataDbRecord* base, GdaDataDbField* field, GError** error) {
	GdaDataRecord * self;
	GeeHashMap* _tmp0_;
	GdaDataDbField* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = (GdaDataRecord*) base;
	g_return_if_fail (field != NULL);
	_tmp0_ = self->_fields;
	_tmp1_ = field;
	_tmp2_ = gda_data_db_field_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_) {
		GeeHashMap* _tmp5_;
		GdaDataDbField* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gpointer _tmp9_ = NULL;
		GdaDataDbField* f;
		GdaDataDbField* _tmp10_;
		GdaDataDbField* _tmp11_;
		GValue* _tmp12_;
		GValue* _tmp13_;
		GeeHashMap* _tmp14_;
		GdaDataDbField* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GdaDataDbField* _tmp18_;
		_tmp5_ = self->_fields;
		_tmp6_ = field;
		_tmp7_ = gda_data_db_field_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp8_);
		f = (GdaDataDbField*) _tmp9_;
		_tmp10_ = f;
		_tmp11_ = field;
		_tmp12_ = gda_data_db_field_get_value (_tmp11_);
		_tmp13_ = _tmp12_;
		gda_data_db_field_set_value (_tmp10_, _tmp13_);
		_tmp14_ = self->_fields;
		_tmp15_ = field;
		_tmp16_ = gda_data_db_field_get_name (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = f;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp17_, _tmp18_);
		_g_object_unref0 (f);
	} else {
		GdaDataDbField* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GdaDataField* _tmp22_;
		GdaDataField* n;
		GdaDataField* _tmp23_;
		GdaDataDbField* _tmp24_;
		GValue* _tmp25_;
		GValue* _tmp26_;
		GeeHashMap* _tmp27_;
		GdaDataDbField* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		GdaDataField* _tmp31_;
		_tmp19_ = field;
		_tmp20_ = gda_data_db_field_get_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = gda_data_field_new (_tmp21_, GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
		n = _tmp22_;
		_tmp23_ = n;
		_tmp24_ = field;
		_tmp25_ = gda_data_db_field_get_value (_tmp24_);
		_tmp26_ = _tmp25_;
		gda_data_db_field_set_value ((GdaDataDbField*) _tmp23_, _tmp26_);
		_tmp27_ = self->_fields;
		_tmp28_ = field;
		_tmp29_ = gda_data_db_field_get_name (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = n;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp30_, (GdaDataDbField*) _tmp31_);
		_g_object_unref0 (n);
	}
}


static void gda_data_record_real_set_field_value (GdaDataDbRecord* base, const gchar* field, GValue* val, GError** error) {
	GdaDataRecord * self;
	const gchar* _tmp0_;
	GdaDataField* _tmp1_;
	GdaDataField* n;
	GValue* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	g_return_if_fail (field != NULL);
	_tmp0_ = field;
	_tmp1_ = gda_data_field_new (_tmp0_, GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
	n = _tmp1_;
	_tmp2_ = val;
	gda_data_db_field_set_value ((GdaDataDbField*) n, _tmp2_);
	gda_data_db_record_set_field ((GdaDataDbRecord*) self, (GdaDataDbField*) n, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (n);
		return;
	}
	_g_object_unref0 (n);
}


static GdaDataDbField* gda_data_record_real_get_field (GdaDataDbRecord* base, const gchar* name, GError** error) {
	GdaDataRecord * self;
	GdaDataDbField* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	self = (GdaDataRecord*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->_fields;
	_tmp1_ = name;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	result = (GdaDataDbField*) _tmp2_;
	return result;
}


static void gda_data_record_real_set_key (GdaDataDbRecord* base, GdaDataDbField* field, GError** error) {
	GdaDataRecord * self;
	GeeHashMap* _tmp0_;
	GdaDataDbField* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = (GdaDataRecord*) base;
	g_return_if_fail (field != NULL);
	_tmp0_ = self->_keys;
	_tmp1_ = field;
	_tmp2_ = gda_data_db_field_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_) {
		GeeHashMap* _tmp5_;
		GdaDataDbField* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gpointer _tmp9_ = NULL;
		GdaDataDbField* f;
		GdaDataDbField* _tmp10_;
		GdaDataDbField* _tmp11_;
		GValue* _tmp12_;
		GValue* _tmp13_;
		GeeHashMap* _tmp14_;
		GdaDataDbField* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GdaDataDbField* _tmp18_;
		_tmp5_ = self->_keys;
		_tmp6_ = field;
		_tmp7_ = gda_data_db_field_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp8_);
		f = (GdaDataDbField*) _tmp9_;
		_tmp10_ = f;
		_tmp11_ = field;
		_tmp12_ = gda_data_db_field_get_value (_tmp11_);
		_tmp13_ = _tmp12_;
		gda_data_db_field_set_value (_tmp10_, _tmp13_);
		_tmp14_ = self->_keys;
		_tmp15_ = field;
		_tmp16_ = gda_data_db_field_get_name (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = f;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp17_, _tmp18_);
		_g_object_unref0 (f);
	} else {
		GdaDataDbField* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GdaDataField* _tmp22_;
		GdaDataField* n;
		GdaDataField* _tmp23_;
		GdaDataDbField* _tmp24_;
		GValue* _tmp25_;
		GValue* _tmp26_;
		GeeHashMap* _tmp27_;
		GdaDataDbField* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		GdaDataField* _tmp31_;
		_tmp19_ = field;
		_tmp20_ = gda_data_db_field_get_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = gda_data_field_new (_tmp21_, GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
		n = _tmp22_;
		_tmp23_ = n;
		_tmp24_ = field;
		_tmp25_ = gda_data_db_field_get_value (_tmp24_);
		_tmp26_ = _tmp25_;
		gda_data_db_field_set_value ((GdaDataDbField*) _tmp23_, _tmp26_);
		_tmp27_ = self->_keys;
		_tmp28_ = field;
		_tmp29_ = gda_data_db_field_get_name (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = n;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp30_, (GdaDataDbField*) _tmp31_);
		_g_object_unref0 (n);
	}
}


static void gda_data_record_real_set_key_value (GdaDataDbRecord* base, const gchar* key, GValue* val, GError** error) {
	GdaDataRecord * self;
	const gchar* _tmp0_;
	GdaDataField* _tmp1_;
	GdaDataField* n;
	GValue* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp1_ = gda_data_field_new (_tmp0_, GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
	n = _tmp1_;
	_tmp2_ = val;
	gda_data_db_field_set_value ((GdaDataDbField*) n, _tmp2_);
	gda_data_db_record_set_key ((GdaDataDbRecord*) self, (GdaDataDbField*) n, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (n);
		return;
	}
	_g_object_unref0 (n);
}


static GdaDataDbField* gda_data_record_real_get_key (GdaDataDbRecord* base, const gchar* name, GError** error) {
	GdaDataRecord * self;
	GdaDataDbField* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	self = (GdaDataRecord*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->_keys;
	_tmp1_ = name;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	result = (GdaDataDbField*) _tmp2_;
	return result;
}


/**
         * Saves any modficiation made to in memory representation of the data directly to
         * the database.
         */
static void gda_data_record_real_save (GdaDataDbObject* base, GError** error) {
	GdaDataRecord * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_;
	GdaSqlBuilder* _tmp14_;
	GdaSqlBuilder* q;
	GdaSqlBuilder* _tmp15_;
	GdaDataDbTable* _tmp16_;
	GdaDataDbTable* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GdaSqlBuilderId cond;
	GdaSqlBuilder* _tmp65_;
	GdaSqlBuilderId _tmp66_;
	GdaSqlBuilder* _tmp67_;
	GdaStatement* _tmp68_ = NULL;
	GdaStatement* _tmp69_;
	GdaConnection* _tmp70_;
	GdaConnection* _tmp71_;
	GdaStatement* _tmp72_;
	gint _tmp73_ = 0;
	gint _tmp74_;
	gint i;
	gint _tmp75_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	_tmp0_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ <= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_SAVE, "No fields has been set");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_collection_get_size (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ <= 0;
	_g_object_unref0 (_tmp9_);
	if (_tmp12_) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_SAVE, "No Keys has been set");
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp14_ = gda_sql_builder_new (GDA_SQL_STATEMENT_UPDATE);
	q = _tmp14_;
	_tmp15_ = q;
	_tmp16_ = gda_data_db_record_get_table ((GdaDataDbRecord*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp17_);
	_tmp19_ = _tmp18_;
	gda_sql_builder_set_table (_tmp15_, _tmp19_);
	{
		GeeCollection* _tmp20_;
		GeeCollection* _tmp21_;
		GeeCollection* _tmp22_;
		GeeIterator* _tmp23_ = NULL;
		GeeIterator* _tmp24_;
		GeeIterator* _f_it;
		_tmp20_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		_f_it = _tmp24_;
		while (TRUE) {
			GeeIterator* _tmp25_;
			gboolean _tmp26_ = FALSE;
			GeeIterator* _tmp27_;
			gpointer _tmp28_ = NULL;
			GdaDataDbField* f;
			GdaSqlBuilder* _tmp29_;
			GdaDataDbField* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			GdaDataDbField* _tmp33_;
			GValue* _tmp34_;
			GValue* _tmp35_;
			_tmp25_ = _f_it;
			_tmp26_ = gee_iterator_next (_tmp25_);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = _f_it;
			_tmp28_ = gee_iterator_get (_tmp27_);
			f = (GdaDataDbField*) _tmp28_;
			_tmp29_ = q;
			_tmp30_ = f;
			_tmp31_ = gda_data_db_field_get_column_name (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = f;
			_tmp34_ = gda_data_db_field_get_value (_tmp33_);
			_tmp35_ = _tmp34_;
			gda_sql_builder_add_field_value_as_gvalue (_tmp29_, _tmp32_, _tmp35_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	cond = (GdaSqlBuilderId) (-1);
	{
		GeeCollection* _tmp36_;
		GeeCollection* _tmp37_;
		GeeCollection* _tmp38_;
		GeeIterator* _tmp39_ = NULL;
		GeeIterator* _tmp40_;
		GeeIterator* _f_it;
		_tmp36_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = _tmp37_;
		_tmp39_ = gee_iterable_iterator ((GeeIterable*) _tmp38_);
		_tmp40_ = _tmp39_;
		_g_object_unref0 (_tmp38_);
		_f_it = _tmp40_;
		while (TRUE) {
			GeeIterator* _tmp41_;
			gboolean _tmp42_ = FALSE;
			GeeIterator* _tmp43_;
			gpointer _tmp44_ = NULL;
			GdaDataDbField* f;
			GdaSqlBuilder* _tmp45_;
			GdaDataDbField* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			GdaSqlBuilderId _tmp49_ = 0U;
			GdaSqlBuilderId f_id;
			GdaSqlBuilder* _tmp50_;
			GdaDataDbField* _tmp51_;
			GValue* _tmp52_;
			GValue* _tmp53_;
			GdaSqlBuilderId _tmp54_ = 0U;
			GdaSqlBuilderId e_id;
			GdaSqlBuilder* _tmp55_;
			GdaSqlBuilderId _tmp56_;
			GdaSqlBuilderId _tmp57_;
			GdaSqlBuilderId _tmp58_ = 0U;
			GdaSqlBuilderId c_id;
			GdaSqlBuilderId _tmp59_;
			_tmp41_ = _f_it;
			_tmp42_ = gee_iterator_next (_tmp41_);
			if (!_tmp42_) {
				break;
			}
			_tmp43_ = _f_it;
			_tmp44_ = gee_iterator_get (_tmp43_);
			f = (GdaDataDbField*) _tmp44_;
			_tmp45_ = q;
			_tmp46_ = f;
			_tmp47_ = gda_data_db_field_get_name (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = gda_sql_builder_add_id (_tmp45_, _tmp48_);
			f_id = _tmp49_;
			_tmp50_ = q;
			_tmp51_ = f;
			_tmp52_ = gda_data_db_field_get_value (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = gda_sql_builder_add_expr_value (_tmp50_, NULL, _tmp53_);
			e_id = _tmp54_;
			_tmp55_ = q;
			_tmp56_ = f_id;
			_tmp57_ = e_id;
			_tmp58_ = gda_sql_builder_add_cond (_tmp55_, GDA_SQL_OPERATOR_TYPE_EQ, _tmp56_, _tmp57_, (GdaSqlBuilderId) 0);
			c_id = _tmp58_;
			_tmp59_ = cond;
			if (_tmp59_ == ((GdaSqlBuilderId) (-1))) {
				GdaSqlBuilderId _tmp60_;
				_tmp60_ = c_id;
				cond = _tmp60_;
			} else {
				GdaSqlBuilder* _tmp61_;
				GdaSqlBuilderId _tmp62_;
				GdaSqlBuilderId _tmp63_;
				GdaSqlBuilderId _tmp64_ = 0U;
				_tmp61_ = q;
				_tmp62_ = cond;
				_tmp63_ = c_id;
				_tmp64_ = gda_sql_builder_add_cond (_tmp61_, GDA_SQL_OPERATOR_TYPE_AND, _tmp62_, _tmp63_, (GdaSqlBuilderId) 0);
				cond = _tmp64_;
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp65_ = q;
	_tmp66_ = cond;
	gda_sql_builder_set_where (_tmp65_, _tmp66_);
	_tmp67_ = q;
	_tmp68_ = gda_sql_builder_get_statement (_tmp67_, &_inner_error_);
	_tmp69_ = _tmp68_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (q);
		return;
	}
	_tmp70_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp71_ = _tmp70_;
	_tmp72_ = _tmp69_;
	_tmp73_ = gda_connection_statement_execute_non_select (_tmp71_, _tmp72_, NULL, NULL, &_inner_error_);
	_tmp74_ = _tmp73_;
	_g_object_unref0 (_tmp72_);
	i = _tmp74_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (q);
		return;
	}
	_tmp75_ = i;
	if (_tmp75_ != 1) {
		GError* _tmp76_;
		_tmp76_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_SAVE, "Have been saved more or less rows than expected");
		_inner_error_ = _tmp76_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (q);
		return;
	}
	_g_object_unref0 (q);
}


/**
         * Updates values stored in database.
         */
static void gda_data_record_real_update (GdaDataDbObject* base, GError** error) {
	GdaDataRecord * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	GdaSqlBuilder* _tmp11_;
	GdaSqlBuilder* q;
	GdaSqlBuilder* _tmp12_;
	GdaDataDbTable* _tmp13_;
	GdaDataDbTable* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GdaSqlBuilder* _tmp17_;
	GdaSqlBuilderId cond;
	GdaSqlBuilder* _tmp47_;
	GdaSqlBuilderId _tmp48_;
	GdaSqlBuilder* _tmp49_;
	GdaStatement* _tmp50_ = NULL;
	GdaStatement* _tmp51_;
	GdaConnection* _tmp52_;
	GdaConnection* _tmp53_;
	GdaStatement* _tmp54_;
	GdaDataModel* _tmp55_ = NULL;
	GdaDataModel* _tmp56_;
	GdaDataModel* m;
	GdaDataModel* _tmp57_;
	gint _tmp58_ = 0;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	_tmp0_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GdaConnection* _tmp2_;
		GdaConnection* _tmp3_;
		_tmp2_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
		_tmp3_ = _tmp2_;
		gda_connection_update_meta_store (_tmp3_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, FALSE);
	}
	_tmp4_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_get_size (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ <= 0;
	_g_object_unref0 (_tmp6_);
	if (_tmp9_) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_UPDATE, "No Keys has been set");
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp11_ = gda_sql_builder_new (GDA_SQL_STATEMENT_SELECT);
	q = _tmp11_;
	_tmp12_ = q;
	_tmp13_ = gda_data_db_record_get_table ((GdaDataDbRecord*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp14_);
	_tmp16_ = _tmp15_;
	gda_sql_builder_select_add_target (_tmp12_, _tmp16_, NULL);
	_tmp17_ = q;
	gda_sql_builder_select_add_field (_tmp17_, "*", NULL, NULL);
	cond = (GdaSqlBuilderId) (-1);
	{
		GeeCollection* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		GeeIterator* _tmp21_ = NULL;
		GeeIterator* _tmp22_;
		GeeIterator* _f_it;
		_tmp18_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_f_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			gboolean _tmp24_ = FALSE;
			GeeIterator* _tmp25_;
			gpointer _tmp26_ = NULL;
			GdaDataDbField* f;
			GdaSqlBuilder* _tmp27_;
			GdaDataDbField* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			GdaSqlBuilderId _tmp31_ = 0U;
			GdaSqlBuilderId f_id;
			GdaSqlBuilder* _tmp32_;
			GdaDataDbField* _tmp33_;
			GValue* _tmp34_;
			GValue* _tmp35_;
			GdaSqlBuilderId _tmp36_ = 0U;
			GdaSqlBuilderId e_id;
			GdaSqlBuilder* _tmp37_;
			GdaSqlBuilderId _tmp38_;
			GdaSqlBuilderId _tmp39_;
			GdaSqlBuilderId _tmp40_ = 0U;
			GdaSqlBuilderId c_id;
			GdaSqlBuilderId _tmp41_;
			_tmp23_ = _f_it;
			_tmp24_ = gee_iterator_next (_tmp23_);
			if (!_tmp24_) {
				break;
			}
			_tmp25_ = _f_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			f = (GdaDataDbField*) _tmp26_;
			_tmp27_ = q;
			_tmp28_ = f;
			_tmp29_ = gda_data_db_field_get_name (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = gda_sql_builder_add_id (_tmp27_, _tmp30_);
			f_id = _tmp31_;
			_tmp32_ = q;
			_tmp33_ = f;
			_tmp34_ = gda_data_db_field_get_value (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = gda_sql_builder_add_expr_value (_tmp32_, NULL, _tmp35_);
			e_id = _tmp36_;
			_tmp37_ = q;
			_tmp38_ = f_id;
			_tmp39_ = e_id;
			_tmp40_ = gda_sql_builder_add_cond (_tmp37_, GDA_SQL_OPERATOR_TYPE_EQ, _tmp38_, _tmp39_, (GdaSqlBuilderId) 0);
			c_id = _tmp40_;
			_tmp41_ = cond;
			if (_tmp41_ == ((GdaSqlBuilderId) (-1))) {
				GdaSqlBuilderId _tmp42_;
				_tmp42_ = c_id;
				cond = _tmp42_;
			} else {
				GdaSqlBuilder* _tmp43_;
				GdaSqlBuilderId _tmp44_;
				GdaSqlBuilderId _tmp45_;
				GdaSqlBuilderId _tmp46_ = 0U;
				_tmp43_ = q;
				_tmp44_ = cond;
				_tmp45_ = c_id;
				_tmp46_ = gda_sql_builder_add_cond (_tmp43_, GDA_SQL_OPERATOR_TYPE_AND, _tmp44_, _tmp45_, (GdaSqlBuilderId) 0);
				cond = _tmp46_;
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp47_ = q;
	_tmp48_ = cond;
	gda_sql_builder_set_where (_tmp47_, _tmp48_);
	_tmp49_ = q;
	_tmp50_ = gda_sql_builder_get_statement (_tmp49_, &_inner_error_);
	_tmp51_ = _tmp50_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (q);
		return;
	}
	_tmp52_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = _tmp51_;
	_tmp55_ = gda_connection_statement_execute_select (_tmp53_, _tmp54_, NULL, &_inner_error_);
	_tmp56_ = _tmp55_;
	_g_object_unref0 (_tmp54_);
	m = _tmp56_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (q);
		return;
	}
	_tmp57_ = m;
	_tmp58_ = gda_data_model_get_n_rows (_tmp57_);
	if (_tmp58_ != 1) {
		GError* _tmp59_;
		_tmp59_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_UPDATE, "Returning number of rows are more than 1");
		_inner_error_ = _tmp59_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (m);
		_g_object_unref0 (q);
		return;
	}
	{
		gint c;
		c = 0;
		{
			gboolean _tmp60_;
			_tmp60_ = TRUE;
			while (TRUE) {
				gboolean _tmp61_;
				gint _tmp63_;
				GdaDataModel* _tmp64_;
				gint _tmp65_ = 0;
				GdaDataModel* _tmp66_;
				gint _tmp67_;
				const gchar* _tmp68_ = NULL;
				GdaDataModel* _tmp69_;
				gint _tmp70_;
				GdaValueAttribute _tmp71_ = 0;
				GdaDataField* _tmp72_;
				GdaDataField* f;
				GdaDataModel* _tmp73_;
				gint _tmp74_;
				GValue* _tmp75_ = NULL;
				GValue* _tmp76_;
				GdaDataField* _tmp77_;
				GdaDataField* _tmp78_;
				_tmp61_ = _tmp60_;
				if (!_tmp61_) {
					gint _tmp62_;
					_tmp62_ = c;
					c = _tmp62_ + 1;
				}
				_tmp60_ = FALSE;
				_tmp63_ = c;
				_tmp64_ = m;
				_tmp65_ = gda_data_model_get_n_columns (_tmp64_);
				if (!(_tmp63_ < _tmp65_)) {
					break;
				}
				_tmp66_ = m;
				_tmp67_ = c;
				_tmp68_ = gda_data_model_get_column_name (_tmp66_, _tmp67_);
				_tmp69_ = m;
				_tmp70_ = c;
				_tmp71_ = gda_data_model_get_attributes_at (_tmp69_, _tmp70_, 0);
				_tmp72_ = gda_data_field_new (_tmp68_, (GdaDataDbFieldAttribute) _tmp71_);
				f = _tmp72_;
				_tmp73_ = m;
				_tmp74_ = c;
				_tmp75_ = gda_data_model_get_value_at (_tmp73_, _tmp74_, 0, &_inner_error_);
				_tmp76_ = _tmp75_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (m);
					_g_object_unref0 (q);
					return;
				}
				_tmp77_ = f;
				gda_data_db_field_set_value ((GdaDataDbField*) _tmp77_, _tmp76_);
				_tmp78_ = f;
				gda_data_db_record_set_field ((GdaDataDbRecord*) self, (GdaDataDbField*) _tmp78_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (m);
					_g_object_unref0 (q);
					return;
				}
				_g_object_unref0 (f);
			}
		}
	}
	_g_object_unref0 (m);
	_g_object_unref0 (q);
}


/**
         * Append a new row to the defined table and returns its ID. If defaults is set to true,
         * default value for each field is set.
         */
static void gda_data_record_real_append (GdaDataDbObject* base, GError** error) {
	GdaDataRecord * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GdaSqlBuilder* _tmp7_;
	GdaSqlBuilder* sql;
	GdaSqlBuilder* _tmp8_;
	GdaDataDbTable* _tmp9_;
	GdaDataDbTable* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GdaSqlBuilder* _tmp30_;
	GdaStatement* _tmp31_ = NULL;
	GdaStatement* _tmp32_;
	GdaConnection* _tmp33_;
	GdaConnection* _tmp34_;
	GdaStatement* _tmp35_;
	gint _tmp36_ = 0;
	gint _tmp37_;
	gint i;
	gint _tmp38_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	_tmp0_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ <= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_APPEND, "No fields has been set");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = gda_sql_builder_new (GDA_SQL_STATEMENT_INSERT);
	sql = _tmp7_;
	_tmp8_ = sql;
	_tmp9_ = gda_data_db_record_get_table ((GdaDataDbRecord*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp10_);
	_tmp12_ = _tmp11_;
	gda_sql_builder_set_table (_tmp8_, _tmp12_);
	{
		GeeHashMap* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeIterator* _tmp17_ = NULL;
		GeeIterator* _tmp18_;
		GeeIterator* _f_it;
		_tmp13_ = self->_fields;
		_tmp14_ = gee_abstract_map_get_values ((GeeMap*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_f_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			gboolean _tmp20_ = FALSE;
			GeeIterator* _tmp21_;
			gpointer _tmp22_ = NULL;
			GdaDataDbField* f;
			GdaSqlBuilder* _tmp23_;
			GdaDataDbField* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			GdaDataDbField* _tmp27_;
			GValue* _tmp28_;
			GValue* _tmp29_;
			_tmp19_ = _f_it;
			_tmp20_ = gee_iterator_next (_tmp19_);
			if (!_tmp20_) {
				break;
			}
			_tmp21_ = _f_it;
			_tmp22_ = gee_iterator_get (_tmp21_);
			f = (GdaDataDbField*) _tmp22_;
			_tmp23_ = sql;
			_tmp24_ = f;
			_tmp25_ = gda_data_db_field_get_column_name (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = f;
			_tmp28_ = gda_data_db_field_get_value (_tmp27_);
			_tmp29_ = _tmp28_;
			gda_sql_builder_add_field_value_as_gvalue (_tmp23_, _tmp26_, _tmp29_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp30_ = sql;
	_tmp31_ = gda_sql_builder_get_statement (_tmp30_, &_inner_error_);
	_tmp32_ = _tmp31_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp33_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = _tmp32_;
	_tmp36_ = gda_connection_statement_execute_non_select (_tmp34_, _tmp35_, NULL, NULL, &_inner_error_);
	_tmp37_ = _tmp36_;
	_g_object_unref0 (_tmp35_);
	i = _tmp37_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp38_ = i;
	if (_tmp38_ != 1) {
		GError* _tmp39_;
		_tmp39_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_UPDATE, "Have been updated more or less rows than expected");
		_inner_error_ = _tmp39_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_g_object_unref0 (sql);
}


static void gda_data_record_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error) {
	GdaDataRecord * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	GdaSqlBuilder* _tmp7_;
	GdaSqlBuilder* sql;
	GdaSqlBuilder* _tmp8_;
	GdaDataDbTable* _tmp9_;
	GdaDataDbTable* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GdaSqlBuilderId cond;
	gint pn;
	GdaSqlBuilder* _tmp42_;
	GdaSqlBuilderId _tmp43_;
	GdaSqlBuilder* _tmp44_;
	GdaStatement* _tmp45_ = NULL;
	GdaStatement* _tmp46_;
	GdaStatement* _tmp47_;
	GdaConnection* _tmp48_;
	GdaConnection* _tmp49_;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_;
	gchar* _tmp52_;
	FILE* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	GdaSqlBuilder* _tmp59_;
	GdaStatement* _tmp60_ = NULL;
	GdaStatement* _tmp61_;
	GdaConnection* _tmp62_;
	GdaConnection* _tmp63_;
	GdaStatement* _tmp64_;
	gint _tmp65_ = 0;
	gint _tmp66_;
	gint i;
	gint _tmp67_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	_tmp0_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ <= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_DROP, "No keys has been set");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = gda_sql_builder_new (GDA_SQL_STATEMENT_DELETE);
	sql = _tmp7_;
	_tmp8_ = sql;
	_tmp9_ = gda_data_db_record_get_table ((GdaDataDbRecord*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp10_);
	_tmp12_ = _tmp11_;
	gda_sql_builder_set_table (_tmp8_, _tmp12_);
	cond = (GdaSqlBuilderId) (-1);
	pn = 0;
	{
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeIterator* _tmp16_ = NULL;
		GeeIterator* _tmp17_;
		GeeIterator* _f_it;
		_tmp13_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_f_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			GdaDataDbField* f;
			GdaSqlBuilder* _tmp22_;
			GdaDataDbField* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			GdaSqlBuilderId _tmp26_ = 0U;
			GdaSqlBuilderId fid;
			GdaSqlBuilder* _tmp27_;
			GdaDataDbField* _tmp28_;
			GValue* _tmp29_;
			GValue* _tmp30_;
			GdaSqlBuilderId _tmp31_ = 0U;
			GdaSqlBuilderId vid;
			GdaSqlBuilder* _tmp32_;
			GdaSqlBuilderId _tmp33_;
			GdaSqlBuilderId _tmp34_;
			GdaSqlBuilderId _tmp35_ = 0U;
			GdaSqlBuilderId c_id;
			GdaSqlBuilderId _tmp36_;
			_tmp18_ = _f_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _f_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			f = (GdaDataDbField*) _tmp21_;
			_tmp22_ = sql;
			_tmp23_ = f;
			_tmp24_ = gda_data_db_field_get_column_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = gda_sql_builder_add_id (_tmp22_, _tmp25_);
			fid = _tmp26_;
			_tmp27_ = sql;
			_tmp28_ = f;
			_tmp29_ = gda_data_db_field_get_value (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = gda_sql_builder_add_expr_value (_tmp27_, NULL, _tmp30_);
			vid = _tmp31_;
			_tmp32_ = sql;
			_tmp33_ = fid;
			_tmp34_ = vid;
			_tmp35_ = gda_sql_builder_add_cond (_tmp32_, GDA_SQL_OPERATOR_TYPE_EQ, _tmp33_, _tmp34_, (GdaSqlBuilderId) 0);
			c_id = _tmp35_;
			_tmp36_ = cond;
			if (_tmp36_ == ((GdaSqlBuilderId) (-1))) {
				GdaSqlBuilderId _tmp37_;
				_tmp37_ = c_id;
				cond = _tmp37_;
			} else {
				GdaSqlBuilder* _tmp38_;
				GdaSqlBuilderId _tmp39_;
				GdaSqlBuilderId _tmp40_;
				GdaSqlBuilderId _tmp41_ = 0U;
				_tmp38_ = sql;
				_tmp39_ = cond;
				_tmp40_ = c_id;
				_tmp41_ = gda_sql_builder_add_cond (_tmp38_, GDA_SQL_OPERATOR_TYPE_AND, _tmp39_, _tmp40_, (GdaSqlBuilderId) 0);
				cond = _tmp41_;
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp42_ = sql;
	_tmp43_ = cond;
	gda_sql_builder_set_where (_tmp42_, _tmp43_);
	_tmp44_ = sql;
	_tmp45_ = gda_sql_builder_get_statement (_tmp44_, &_inner_error_);
	_tmp46_ = _tmp45_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp47_ = _tmp46_;
	_tmp48_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = gda_statement_to_sql_extended (_tmp47_, _tmp49_, NULL, GDA_STATEMENT_SQL_PRETTY, NULL, &_inner_error_);
	_tmp51_ = _tmp50_;
	_g_object_unref0 (_tmp47_);
	_tmp52_ = _tmp51_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp53_ = stdout;
	_tmp54_ = _tmp52_;
	_tmp55_ = g_strconcat ("DEBUG: DELETE statement to execute: \n", _tmp54_, NULL);
	_tmp56_ = _tmp55_;
	_tmp57_ = g_strconcat (_tmp56_, "\n", NULL);
	_tmp58_ = _tmp57_;
	fprintf (_tmp53_, "%s", _tmp58_);
	_g_free0 (_tmp58_);
	_g_free0 (_tmp56_);
	_g_free0 (_tmp54_);
	_tmp59_ = sql;
	_tmp60_ = gda_sql_builder_get_statement (_tmp59_, &_inner_error_);
	_tmp61_ = _tmp60_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp62_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp63_ = _tmp62_;
	_tmp64_ = _tmp61_;
	_tmp65_ = gda_connection_statement_execute_non_select (_tmp63_, _tmp64_, NULL, NULL, &_inner_error_);
	_tmp66_ = _tmp65_;
	_g_object_unref0 (_tmp64_);
	i = _tmp66_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_tmp67_ = i;
	if (_tmp67_ != 1) {
		GError* _tmp68_;
		_tmp68_ = g_error_new_literal (GDA_DATA_DB_OBJECT_ERROR, GDA_DATA_DB_OBJECT_ERROR_DROP, "Have been dropped more or less rows than expected");
		_inner_error_ = _tmp68_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sql);
		return;
	}
	_g_object_unref0 (sql);
}


static gchar* gda_data_record_real_to_string (GdaDataDbRecord* base) {
	GdaDataRecord * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* r;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	self = (GdaDataRecord*) base;
	_tmp0_ = g_strdup ("");
	r = _tmp0_;
	{
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _f_it;
		_tmp1_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_f_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			GdaDataDbField* f;
			const gchar* _tmp10_;
			GdaDataDbField* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp6_ = _f_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _f_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			f = (GdaDataDbField*) _tmp9_;
			_tmp10_ = r;
			_tmp11_ = f;
			_tmp12_ = gda_data_db_field_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat ("|", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp10_, _tmp15_, NULL);
			_g_free0 (r);
			r = _tmp16_;
			_g_free0 (_tmp15_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp17_ = r;
	_tmp18_ = g_strconcat (_tmp17_, "\n", NULL);
	_g_free0 (r);
	r = _tmp18_;
	{
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		GeeCollection* _tmp21_;
		GeeIterator* _tmp22_ = NULL;
		GeeIterator* _tmp23_;
		GeeIterator* _f_it;
		_tmp19_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp21_);
		_f_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_;
			gboolean _tmp25_ = FALSE;
			GeeIterator* _tmp26_;
			gpointer _tmp27_ = NULL;
			GdaDataDbField* f;
			const gchar* _tmp28_;
			GdaDataDbField* _tmp29_;
			GValue* _tmp30_;
			GValue* _tmp31_;
			GValue _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp24_ = _f_it;
			_tmp25_ = gee_iterator_next (_tmp24_);
			if (!_tmp25_) {
				break;
			}
			_tmp26_ = _f_it;
			_tmp27_ = gee_iterator_get (_tmp26_);
			f = (GdaDataDbField*) _tmp27_;
			_tmp28_ = r;
			_tmp29_ = f;
			_tmp30_ = gda_data_db_field_get_value (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = *_tmp31_;
			_tmp33_ = gda_value_stringify (&_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat ("|", _tmp34_, NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strconcat (_tmp28_, _tmp36_, NULL);
			_g_free0 (r);
			r = _tmp37_;
			_g_free0 (_tmp36_);
			_g_free0 (_tmp34_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	result = r;
	return result;
}


/**
         * Compare two DbRecord keys. If record have more than one key allways return -1.
         *
         * @Returns: 0 if keys are equal or -1 if they are different.
         */
static gint gda_data_record_real_compare_to (GeeComparable* base, GdaDataDbRecord* object) {
	GdaDataRecord * self;
	gint result = 0;
	gint r;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecord*) base;
	g_return_val_if_fail (object != NULL, 0);
	r = 0;
	{
		{
			GeeCollection* _tmp0_;
			GeeCollection* _tmp1_;
			GeeCollection* _tmp2_;
			GeeIterator* _tmp3_ = NULL;
			GeeIterator* _tmp4_;
			GeeIterator* _f_it;
			_tmp0_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) self);
			_tmp1_ = _tmp0_;
			_tmp2_ = _tmp1_;
			_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp2_);
			_f_it = _tmp4_;
			while (TRUE) {
				GeeIterator* _tmp5_;
				gboolean _tmp6_ = FALSE;
				GeeIterator* _tmp7_;
				gpointer _tmp8_ = NULL;
				GdaDataDbField* f;
				GdaDataDbRecord* _tmp9_;
				GdaDataDbField* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				GdaDataDbField* _tmp13_ = NULL;
				GdaDataDbField* fl;
				GdaDataDbField* _tmp14_;
				GValue* _tmp15_;
				GValue* _tmp16_;
				GdaDataDbField* _tmp17_;
				GValue* _tmp18_;
				GValue* _tmp19_;
				GValue _tmp20_;
				GValue _tmp21_;
				gint _tmp22_ = 0;
				_tmp5_ = _f_it;
				_tmp6_ = gee_iterator_next (_tmp5_);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = _f_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				f = (GdaDataDbField*) _tmp8_;
				_tmp9_ = object;
				_tmp10_ = f;
				_tmp11_ = gda_data_db_field_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = gda_data_db_record_get_field (_tmp9_, _tmp12_, &_inner_error_);
				fl = _tmp13_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					goto __catch7_g_error;
				}
				_tmp14_ = f;
				_tmp15_ = gda_data_db_field_get_value (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = fl;
				_tmp18_ = gda_data_db_field_get_value (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = *_tmp16_;
				_tmp21_ = *_tmp19_;
				_tmp22_ = gda_value_compare (&_tmp20_, &_tmp21_);
				if (_tmp22_ != 0) {
					result = -1;
					_g_object_unref0 (fl);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					return result;
				}
				_g_object_unref0 (fl);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("Record.vala:281: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = r;
	return result;
}


GdaDataRecord* gda_data_record_construct (GType object_type) {
	GdaDataRecord * self = NULL;
	self = (GdaDataRecord*) g_object_new (object_type, NULL);
	return self;
}


GdaDataRecord* gda_data_record_new (void) {
	return gda_data_record_construct (GDA_DATA_TYPE_RECORD);
}


static GdaDataDbTable* gda_data_record_real_get_table (GdaDataDbRecord* base) {
	GdaDataDbTable* result;
	GdaDataRecord* self;
	GdaDataDbTable* _tmp0_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->priv->_table;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gda_data_record_real_set_table (GdaDataDbRecord* base, GdaDataDbTable* value) {
	GdaDataRecord* self;
	GdaDataDbTable* _tmp0_;
	GdaDataDbTable* _tmp1_;
	self = (GdaDataRecord*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_table);
	self->priv->_table = _tmp1_;
	g_object_notify ((GObject *) self, "table");
}


static GeeCollection* gda_data_record_real_get_fields (GdaDataDbRecord* base) {
	GeeCollection* result;
	GdaDataRecord* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->_fields;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GeeCollection* gda_data_record_real_get_keys (GdaDataDbRecord* base) {
	GeeCollection* result;
	GdaDataRecord* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->_keys;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GdaConnection* gda_data_record_real_get_connection (GdaDataDbObject* base) {
	GdaConnection* result;
	GdaDataRecord* self;
	GdaConnection* _tmp0_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static void gda_data_record_real_set_connection (GdaDataDbObject* base, GdaConnection* value) {
	GdaDataRecord* self;
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	self = (GdaDataRecord*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	g_object_notify ((GObject *) self, "connection");
}


static gboolean gda_data_record_real_get_update_meta (GdaDataDbObject* base) {
	gboolean result;
	GdaDataRecord* self;
	gboolean _tmp0_;
	self = (GdaDataRecord*) base;
	_tmp0_ = self->priv->_update_meta;
	result = _tmp0_;
	return result;
}


static void gda_data_record_real_set_update_meta (GdaDataDbObject* base, gboolean value) {
	GdaDataRecord* self;
	gboolean _tmp0_;
	self = (GdaDataRecord*) base;
	_tmp0_ = value;
	self->priv->_update_meta = _tmp0_;
	g_object_notify ((GObject *) self, "update-meta");
}


static void gda_data_record_class_init (GdaDataRecordClass * klass) {
	gda_data_record_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GdaDataRecordPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gda_data_record_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gda_data_record_set_property;
	G_OBJECT_CLASS (klass)->finalize = gda_data_record_finalize;
	/**
	         * Derived classes must implement this property to set the table used to get data from.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_TABLE, g_param_spec_object ("table", "table", "table", GDA_DATA_TYPE_DB_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * Returns a Gee.Collection with the data stored by this object.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_FIELDS, g_param_spec_object ("fields", "fields", "fields", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_KEYS, g_param_spec_object ("keys", "keys", "keys", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Set the connection to be used to get/set data.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_CONNECTION, g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_UPDATE_META, g_param_spec_boolean ("update-meta", "update-meta", "update-meta", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gda_data_record_gda_data_db_object_interface_init (GdaDataDbObjectIface * iface) {
	gda_data_record_gda_data_db_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->save = (void (*)(GdaDataDbObject*, GError**)) gda_data_record_real_save;
	iface->update = (void (*)(GdaDataDbObject*, GError**)) gda_data_record_real_update;
	iface->append = (void (*)(GdaDataDbObject*, GError**)) gda_data_record_real_append;
	iface->drop = (void (*)(GdaDataDbObject*, gboolean, GError**)) gda_data_record_real_drop;
	iface->get_connection = gda_data_record_real_get_connection;
	iface->set_connection = gda_data_record_real_set_connection;
	iface->get_update_meta = gda_data_record_real_get_update_meta;
	iface->set_update_meta = gda_data_record_real_set_update_meta;
}


static void gda_data_record_gee_comparable_interface_init (GeeComparableIface * iface) {
	gda_data_record_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) gda_data_record_real_compare_to;
}


static void gda_data_record_gda_data_db_record_interface_init (GdaDataDbRecordIface * iface) {
	gda_data_record_gda_data_db_record_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_value = (GValue* (*)(GdaDataDbRecord*, const gchar*, GError**)) gda_data_record_real_get_value;
	iface->set_field = (void (*)(GdaDataDbRecord*, GdaDataDbField*, GError**)) gda_data_record_real_set_field;
	iface->set_field_value = (void (*)(GdaDataDbRecord*, const gchar*, GValue*, GError**)) gda_data_record_real_set_field_value;
	iface->get_field = (GdaDataDbField* (*)(GdaDataDbRecord*, const gchar*, GError**)) gda_data_record_real_get_field;
	iface->set_key = (void (*)(GdaDataDbRecord*, GdaDataDbField*, GError**)) gda_data_record_real_set_key;
	iface->set_key_value = (void (*)(GdaDataDbRecord*, const gchar*, GValue*, GError**)) gda_data_record_real_set_key_value;
	iface->get_key = (GdaDataDbField* (*)(GdaDataDbRecord*, const gchar*, GError**)) gda_data_record_real_get_key;
	iface->to_string = (gchar* (*)(GdaDataDbRecord*)) gda_data_record_real_to_string;
	iface->get_table = gda_data_record_real_get_table;
	iface->set_table = gda_data_record_real_set_table;
	iface->get_fields = gda_data_record_real_get_fields;
	iface->get_keys = gda_data_record_real_get_keys;
}


static void gda_data_record_instance_init (GdaDataRecord * self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = GDA_DATA_RECORD_GET_PRIVATE (self);
	self->priv->_update_meta = FALSE;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDA_DATA_TYPE_DB_FIELD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->_fields = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDA_DATA_TYPE_DB_FIELD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->_keys = _tmp1_;
}


static void gda_data_record_finalize (GObject* obj) {
	GdaDataRecord * self;
	self = GDA_DATA_RECORD (obj);
	_g_object_unref0 (self->_fields);
	_g_object_unref0 (self->_keys);
	_g_object_unref0 (self->priv->_table);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (gda_data_record_parent_class)->finalize (obj);
}


GType gda_data_record_get_type (void) {
	static volatile gsize gda_data_record_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_record_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataRecordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gda_data_record_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdaDataRecord), 0, (GInstanceInitFunc) gda_data_record_instance_init, NULL };
		static const GInterfaceInfo gda_data_db_object_info = { (GInterfaceInitFunc) gda_data_record_gda_data_db_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) gda_data_record_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_record_info = { (GInterfaceInitFunc) gda_data_record_gda_data_db_record_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gda_data_record_type_id;
		gda_data_record_type_id = g_type_register_static (G_TYPE_OBJECT, "GdaDataRecord", &g_define_type_info, 0);
		g_type_add_interface_static (gda_data_record_type_id, GDA_DATA_TYPE_DB_OBJECT, &gda_data_db_object_info);
		g_type_add_interface_static (gda_data_record_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (gda_data_record_type_id, GDA_DATA_TYPE_DB_RECORD, &gda_data_db_record_info);
		g_once_init_leave (&gda_data_record_type_id__volatile, gda_data_record_type_id);
	}
	return gda_data_record_type_id__volatile;
}


static void _vala_gda_data_record_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GdaDataRecord * self;
	self = GDA_DATA_RECORD (object);
	switch (property_id) {
		case GDA_DATA_RECORD_TABLE:
		g_value_set_object (value, gda_data_db_record_get_table ((GdaDataDbRecord*) self));
		break;
		case GDA_DATA_RECORD_FIELDS:
		g_value_take_object (value, gda_data_db_record_get_fields ((GdaDataDbRecord*) self));
		break;
		case GDA_DATA_RECORD_KEYS:
		g_value_take_object (value, gda_data_db_record_get_keys ((GdaDataDbRecord*) self));
		break;
		case GDA_DATA_RECORD_CONNECTION:
		g_value_set_object (value, gda_data_db_object_get_connection ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_RECORD_UPDATE_META:
		g_value_set_boolean (value, gda_data_db_object_get_update_meta ((GdaDataDbObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gda_data_record_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GdaDataRecord * self;
	self = GDA_DATA_RECORD (object);
	switch (property_id) {
		case GDA_DATA_RECORD_TABLE:
		gda_data_db_record_set_table ((GdaDataDbRecord*) self, g_value_get_object (value));
		break;
		case GDA_DATA_RECORD_CONNECTION:
		gda_data_db_object_set_connection ((GdaDataDbObject*) self, g_value_get_object (value));
		break;
		case GDA_DATA_RECORD_UPDATE_META:
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



