/* CheckDataModelIterator.c generated by valac 0.15.2.9-69beb, the Vala compiler
 * generated from CheckDataModelIterator.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata Unit Tests
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <libgda/data/libgdadata.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define CHECK_TYPE_TESTS (check_tests_get_type ())
#define CHECK_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_TESTS, CheckTests))
#define CHECK_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_TESTS, CheckTestsClass))
#define CHECK_IS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_TESTS))
#define CHECK_IS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_TESTS))
#define CHECK_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_TESTS, CheckTestsClass))

typedef struct _CheckTests CheckTests;
typedef struct _CheckTestsClass CheckTestsClass;
typedef struct _CheckTestsPrivate CheckTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))

struct _CheckTests {
	GObject parent_instance;
	CheckTestsPrivate * priv;
};

struct _CheckTestsClass {
	GObjectClass parent_class;
};

struct _CheckTestsPrivate {
	GdaConnection* connection;
	GdaDataDbRecordCollection* itermodel;
};


static gpointer check_tests_parent_class = NULL;

GType check_tests_get_type (void) G_GNUC_CONST;
#define CHECK_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHECK_TYPE_TESTS, CheckTestsPrivate))
enum  {
	CHECK_TESTS_DUMMY_PROPERTY
};
static CheckTests* check_tests_new (void);
static CheckTests* check_tests_construct (GType object_type);
gint check_tests_iterating (CheckTests* self, GError** error);
gint check_tests_choping (CheckTests* self);
static void _vala_GValue_free (GValue* self);
gint check_tests_filtering (CheckTests* self);
static gboolean __lambda2_ (CheckTests* self, GdaDataDbRecord* g);
static gboolean ___lambda2__gee_predicate (gconstpointer g, gpointer self);
gint check_tests_streaming (CheckTests* self);
static GeeTraversableStream __lambda3_ (CheckTests* self, GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy);
static GeeTraversableStream ___lambda3__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
gint check_tests_InitIter (CheckTests* self, GError** error);
gint check_tests_t2 (CheckTests* self);
gint check_tests_main (gchar** args, int args_length1);
static void check_tests_finalize (GObject* obj);


static CheckTests* check_tests_construct (GType object_type) {
	CheckTests * self = NULL;
	GError * _inner_error_ = NULL;
	self = (CheckTests*) g_object_new (object_type, NULL);
	{
		FILE* _tmp0_;
		GdaConnection* _tmp1_ = NULL;
		GdaConnection* _tmp2_;
		FILE* _tmp3_;
		GdaConnection* _tmp4_;
		GdaConnection* _tmp5_;
		GdaConnection* _tmp6_;
		GdaConnection* _tmp7_;
		GdaConnection* _tmp8_;
		GdaConnection* _tmp9_;
		GdaConnection* _tmp10_;
		GdaConnection* _tmp11_;
		g_unlink ("datamodeliterator.db");
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Creating Database...\n");
		_tmp1_ = gda_connection_open_from_string ("SQLite", "DB_DIR=.;DB_NAME=datamodeliterator", NULL, GDA_CONNECTION_OPTIONS_NONE, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = _tmp2_;
		_tmp3_ = stdout;
		fprintf (_tmp3_, "Creating table 'user'...\n");
		_tmp4_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp4_, "CREATE TABLE user (id int PRIMARY KEY, name string, city string)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp5_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp5_, "INSERT INTO user (id, name, city) VALUES (1, \"Daniel\", \"Mexico\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp6_, "INSERT INTO user (id, name, city) VALUES (2, \"Jhon\", \"USA\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp7_, "INSERT INTO user (id, name, city) VALUES (3, \"James\", \"Germany\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp8_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp8_, "INSERT INTO user (id, name, city) VALUES (4, \"Jack\", \"United Kindom" \
"\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp9_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp9_, "INSERT INTO user (id, name, city) VALUES (5, \"Elsy\", \"España\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO user (id, name, city) VALUES (6, \"Mayo\", \"Mexico\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp11_ = self->priv->connection;
		gda_connection_update_meta_store (_tmp11_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stdout;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "Couln't create temporary database...\nERROR: %s\n", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static CheckTests* check_tests_new (void) {
	return check_tests_construct (CHECK_TYPE_TESTS);
}


gint check_tests_iterating (CheckTests* self, GError** error) {
	gint result = 0;
	gint fails;
	FILE* _tmp0_;
	gint i;
	FILE* _tmp1_;
	GdaDataDbRecordCollection* _tmp2_;
	GeeIterator* _tmp3_ = NULL;
	GeeIterator* iter;
	GeeIterator* _tmp4_;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_;
	gboolean _tmp31_;
	FILE* _tmp41_;
	gboolean _tmp57_ = FALSE;
	gint _tmp58_;
	gboolean _tmp60_;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Iterating over all Records in DataModel using foreach...\n");
	i = 0;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "Iterating using a Gee.Iterator...\n");
	i = 0;
	_tmp2_ = self->priv->itermodel;
	_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
	iter = _tmp3_;
	_tmp4_ = iter;
	if (_tmp4_ == NULL) {
		FILE* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = stdout;
		_tmp6_ = fails;
		fails = _tmp6_ + 1;
		_tmp7_ = fails;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("----- FAIL ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		fprintf (_tmp5_, "%s", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	while (TRUE) {
		GeeIterator* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GeeIterator* _tmp16_;
		gpointer _tmp17_ = NULL;
		GdaDataDbRecord* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* t2;
		const gchar* _tmp21_;
		_tmp14_ = iter;
		_tmp15_ = gee_iterator_next (_tmp14_);
		if (!_tmp15_) {
			break;
		}
		_tmp16_ = iter;
		_tmp17_ = gee_iterator_get (_tmp16_);
		_tmp18_ = (GdaDataDbRecord*) _tmp17_;
		_tmp19_ = gda_data_db_record_to_string (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		t2 = _tmp20_;
		_tmp21_ = t2;
		if (_tmp21_ == NULL) {
			gint _tmp22_;
			_tmp22_ = fails;
			fails = _tmp22_ + 1;
			_g_free0 (t2);
			break;
		} else {
			FILE* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gint _tmp27_;
			_tmp23_ = stdout;
			_tmp24_ = t2;
			_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
			_tmp26_ = _tmp25_;
			fprintf (_tmp23_, "%s", _tmp26_);
			_g_free0 (_tmp26_);
			_tmp27_ = i;
			i = _tmp27_ + 1;
		}
		_g_free0 (t2);
	}
	_tmp29_ = fails;
	if (_tmp29_ > 0) {
		_tmp28_ = TRUE;
	} else {
		gint _tmp30_;
		_tmp30_ = i;
		_tmp28_ = _tmp30_ != 6;
	}
	_tmp31_ = _tmp28_;
	if (_tmp31_) {
		FILE* _tmp32_;
		gint _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp32_ = stdout;
		_tmp33_ = fails;
		_tmp34_ = g_strdup_printf ("%i", _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("----- FAIL ", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp37_, "\n", NULL);
		_tmp39_ = _tmp38_;
		fprintf (_tmp32_, "%s", _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
	} else {
		FILE* _tmp40_;
		_tmp40_ = stdout;
		fprintf (_tmp40_, "+++++ PASS\n");
	}
	_tmp41_ = stdout;
	fprintf (_tmp41_, "Iterating using foreach instruction...\n");
	i = 0;
	{
		GdaDataDbRecordCollection* _tmp42_;
		GeeIterator* _tmp43_ = NULL;
		GeeIterator* _r_it;
		_tmp42_ = self->priv->itermodel;
		_tmp43_ = gee_iterable_iterator ((GeeIterable*) _tmp42_);
		_r_it = _tmp43_;
		while (TRUE) {
			GeeIterator* _tmp44_;
			gboolean _tmp45_ = FALSE;
			GeeIterator* _tmp46_;
			gpointer _tmp47_ = NULL;
			GdaDataDbRecord* r;
			GdaDataDbRecord* _tmp48_;
			gchar* _tmp49_ = NULL;
			gchar* t;
			const gchar* _tmp50_;
			gint _tmp52_;
			FILE* _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp44_ = _r_it;
			_tmp45_ = gee_iterator_next (_tmp44_);
			if (!_tmp45_) {
				break;
			}
			_tmp46_ = _r_it;
			_tmp47_ = gee_iterator_get (_tmp46_);
			r = (GdaDataDbRecord*) _tmp47_;
			_tmp48_ = r;
			_tmp49_ = gda_data_db_record_to_string (_tmp48_);
			t = _tmp49_;
			_tmp50_ = t;
			if (_tmp50_ == NULL) {
				gint _tmp51_;
				_tmp51_ = fails;
				fails = _tmp51_ + 1;
				_g_free0 (t);
				_g_object_unref0 (r);
				break;
			}
			_tmp52_ = i;
			i = _tmp52_ + 1;
			_tmp53_ = stdout;
			_tmp54_ = t;
			_tmp55_ = g_strconcat (_tmp54_, "\n", NULL);
			_tmp56_ = _tmp55_;
			fprintf (_tmp53_, "%s", _tmp56_);
			_g_free0 (_tmp56_);
			_g_free0 (t);
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_it);
	}
	_tmp58_ = fails;
	if (_tmp58_ > 0) {
		_tmp57_ = TRUE;
	} else {
		gint _tmp59_;
		_tmp59_ = i;
		_tmp57_ = _tmp59_ != 6;
	}
	_tmp60_ = _tmp57_;
	if (_tmp60_) {
		FILE* _tmp61_;
		gint _tmp62_;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp61_ = stdout;
		_tmp62_ = fails;
		_tmp63_ = g_strdup_printf ("%i", _tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_strconcat ("----- FAIL ", _tmp64_, NULL);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (_tmp66_, "\n", NULL);
		_tmp68_ = _tmp67_;
		fprintf (_tmp61_, "%s", _tmp68_);
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_g_free0 (_tmp64_);
	} else {
		FILE* _tmp69_;
		_tmp69_ = stdout;
		fprintf (_tmp69_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (iter);
	return result;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


gint check_tests_choping (CheckTests* self) {
	gint result = 0;
	gint fails;
	FILE* _tmp0_;
	FILE* _tmp1_;
	GdaDataDbRecordCollection* _tmp2_;
	GeeIterator* _tmp3_ = NULL;
	GeeIterator* iter;
	GeeIterator* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	FILE* _tmp16_;
	GeeIterator* _tmp17_;
	gpointer _tmp18_ = NULL;
	GdaDataDbRecord* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GeeIterator* _tmp24_;
	gpointer _tmp25_ = NULL;
	GdaDataDbRecord* _tmp26_;
	GValue* _tmp27_ = NULL;
	GValue* _tmp28_;
	GValue* _tmp29_;
	gchar* name;
	const gchar* _tmp30_;
	FILE* _tmp42_;
	GdaDataDbRecordCollection* _tmp43_;
	GeeIterator* _tmp44_ = NULL;
	GeeIterator* iter2;
	GeeIterator* _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	FILE* _tmp56_;
	gint i;
	gint _tmp100_;
	FILE* _tmp111_;
	FILE* _tmp112_;
	GdaDataDbRecordCollection* _tmp113_;
	GeeIterator* _tmp114_ = NULL;
	GeeIterator* iter3;
	GeeIterator* _tmp115_;
	gboolean _tmp116_;
	gboolean _tmp117_;
	GeeIterator* _tmp127_;
	gboolean _tmp128_ = FALSE;
	gint _tmp138_;
	FILE* _tmp140_;
	GdaDataDbRecordCollection* _tmp141_;
	GeeIterator* _tmp142_ = NULL;
	GeeIterator* iter4;
	GeeIterator* _tmp143_;
	gboolean _tmp144_;
	gboolean _tmp145_;
	GeeIterator* _tmp155_;
	gboolean _tmp156_ = FALSE;
	gint _tmp166_;
	FILE* _tmp168_;
	GdaDataDbRecordCollection* _tmp169_;
	GeeIterator* _tmp170_ = NULL;
	GeeIterator* iter5;
	GeeIterator* _tmp171_;
	gboolean _tmp172_;
	gboolean _tmp173_;
	GeeIterator* _tmp183_;
	gboolean _tmp184_ = FALSE;
	gint _tmp194_;
	FILE* _tmp196_;
	GdaDataDbRecordCollection* _tmp197_;
	GeeIterator* _tmp198_ = NULL;
	GeeIterator* iter6;
	GeeIterator* _tmp199_;
	gboolean _tmp200_;
	gboolean _tmp201_;
	GeeIterator* _tmp211_;
	gpointer _tmp212_ = NULL;
	GdaDataDbRecord* _tmp213_;
	GValue* _tmp214_ = NULL;
	GValue* _tmp215_;
	GValue* tr;
	GValue* _tmp216_;
	gint _tmp226_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Chopping...\n");
	_tmp1_ = stdout;
	fprintf (_tmp1_, " to get the 2nd DbRecord...\n");
	_tmp2_ = self->priv->itermodel;
	_tmp3_ = gee_traversable_chop ((GeeTraversable*) _tmp2_, 1, -1);
	iter = _tmp3_;
	_tmp4_ = iter;
	_tmp5_ = gee_iterator_get_valid (_tmp4_);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		FILE* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp7_ = stdout;
		_tmp8_ = fails;
		fails = _tmp8_ + 1;
		_tmp9_ = fails;
		_tmp10_ = g_strdup_printf ("%i", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat ("----- FAIL: ", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
		_tmp15_ = _tmp14_;
		fprintf (_tmp7_, "%s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
	}
	_tmp16_ = stdout;
	_tmp17_ = iter;
	_tmp18_ = gee_iterator_get (_tmp17_);
	_tmp19_ = (GdaDataDbRecord*) _tmp18_;
	_tmp20_ = gda_data_db_record_to_string (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
	_tmp23_ = _tmp22_;
	fprintf (_tmp16_, "%s", _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_object_unref0 (_tmp19_);
	_tmp24_ = iter;
	_tmp25_ = gee_iterator_get (_tmp24_);
	_tmp26_ = (GdaDataDbRecord*) _tmp25_;
	_tmp27_ = gda_data_db_record_get_value (_tmp26_, "name", &_inner_error_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (_tmp26_);
	_tmp29_ = _tmp28_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (iter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	name = g_value_get_string (_tmp29_);
	_tmp30_ = name;
	if (g_strcmp0 (_tmp30_, "Jhon") == 0) {
		FILE* _tmp31_;
		_tmp31_ = stdout;
		fprintf (_tmp31_, "+++++ PASS\n");
	} else {
		gint _tmp32_;
		FILE* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp32_ = fails;
		fails = _tmp32_ + 1;
		_tmp33_ = stdout;
		_tmp34_ = fails;
		fails = _tmp34_ + 1;
		_tmp35_ = fails;
		_tmp36_ = g_strdup_printf ("%i", _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat ("----- FAIL: ", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp39_, "\n", NULL);
		_tmp41_ = _tmp40_;
		fprintf (_tmp33_, "%s", _tmp41_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
	}
	_tmp42_ = stdout;
	fprintf (_tmp42_, "Choping to get the 4th to 5th DbRecords...\n");
	_tmp43_ = self->priv->itermodel;
	_tmp44_ = gee_traversable_chop ((GeeTraversable*) _tmp43_, 3, 2);
	iter2 = _tmp44_;
	_tmp45_ = iter2;
	_tmp46_ = gee_iterator_get_valid (_tmp45_);
	_tmp47_ = _tmp46_;
	if (!_tmp47_) {
		FILE* _tmp48_;
		gint _tmp49_;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp48_ = stdout;
		_tmp49_ = fails;
		fails = _tmp49_ + 1;
		_tmp50_ = g_strdup_printf ("%i", _tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strconcat ("----- FAIL: ", _tmp51_, NULL);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strconcat (_tmp53_, "\n", NULL);
		_tmp55_ = _tmp54_;
		fprintf (_tmp48_, "%s", _tmp55_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		_g_free0 (_tmp51_);
	}
	_tmp56_ = stdout;
	fprintf (_tmp56_, "Iterating over chopped records...\n");
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp57_;
		gboolean _tmp58_;
		gboolean _tmp59_;
		gint _tmp60_;
		FILE* _tmp61_;
		GeeIterator* _tmp62_;
		gpointer _tmp63_ = NULL;
		GdaDataDbRecord* _tmp64_;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		GeeIterator* _tmp69_;
		gpointer _tmp70_ = NULL;
		GdaDataDbRecord* _tmp71_;
		GValue* _tmp72_ = NULL;
		GValue* _tmp73_;
		GValue* _tmp74_;
		gchar* name2;
		gint _tmp75_;
		gint _tmp87_;
		GeeIterator* _tmp99_;
		_tmp57_ = iter2;
		_tmp58_ = gee_iterator_get_valid (_tmp57_);
		_tmp59_ = _tmp58_;
		if (!_tmp59_) {
			break;
		}
		_tmp60_ = i;
		i = _tmp60_ + 1;
		_tmp61_ = stdout;
		_tmp62_ = iter2;
		_tmp63_ = gee_iterator_get (_tmp62_);
		_tmp64_ = (GdaDataDbRecord*) _tmp63_;
		_tmp65_ = gda_data_db_record_to_string (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (_tmp66_, "\n", NULL);
		_tmp68_ = _tmp67_;
		fprintf (_tmp61_, "%s", _tmp68_);
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_g_object_unref0 (_tmp64_);
		_tmp69_ = iter2;
		_tmp70_ = gee_iterator_get (_tmp69_);
		_tmp71_ = (GdaDataDbRecord*) _tmp70_;
		_tmp72_ = gda_data_db_record_get_value (_tmp71_, "name", &_inner_error_);
		_tmp73_ = _tmp72_;
		_g_object_unref0 (_tmp71_);
		_tmp74_ = _tmp73_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (iter2);
			_g_free0 (name);
			_g_object_unref0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		name2 = g_value_get_string (_tmp74_);
		_tmp75_ = i;
		if (_tmp75_ == 1) {
			const gchar* _tmp76_;
			_tmp76_ = name2;
			if (g_strcmp0 (_tmp76_, "Jack") != 0) {
				gint _tmp77_;
				FILE* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				_tmp77_ = fails;
				fails = _tmp77_ + 1;
				_tmp78_ = stdout;
				_tmp79_ = fails;
				fails = _tmp79_ + 1;
				_tmp80_ = fails;
				_tmp81_ = g_strdup_printf ("%i", _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = g_strconcat ("----- FAIL: ", _tmp82_, NULL);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_strconcat (_tmp84_, "\n", NULL);
				_tmp86_ = _tmp85_;
				fprintf (_tmp78_, "%s", _tmp86_);
				_g_free0 (_tmp86_);
				_g_free0 (_tmp84_);
				_g_free0 (_tmp82_);
				_g_free0 (name2);
				break;
			}
		}
		_tmp87_ = i;
		if (_tmp87_ == 2) {
			const gchar* _tmp88_;
			_tmp88_ = name2;
			if (g_strcmp0 (_tmp88_, "Elsy") != 0) {
				gint _tmp89_;
				FILE* _tmp90_;
				gint _tmp91_;
				gint _tmp92_;
				gchar* _tmp93_ = NULL;
				gchar* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				_tmp89_ = fails;
				fails = _tmp89_ + 1;
				_tmp90_ = stdout;
				_tmp91_ = fails;
				fails = _tmp91_ + 1;
				_tmp92_ = fails;
				_tmp93_ = g_strdup_printf ("%i", _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = g_strconcat ("----- FAIL: ", _tmp94_, NULL);
				_tmp96_ = _tmp95_;
				_tmp97_ = g_strconcat (_tmp96_, "\n", NULL);
				_tmp98_ = _tmp97_;
				fprintf (_tmp90_, "%s", _tmp98_);
				_g_free0 (_tmp98_);
				_g_free0 (_tmp96_);
				_g_free0 (_tmp94_);
				_g_free0 (name2);
				break;
			}
		}
		_tmp99_ = iter2;
		gee_iterator_next (_tmp99_);
		_g_free0 (name2);
	}
	_tmp100_ = i;
	if (_tmp100_ != 2) {
		gint _tmp101_;
		FILE* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gchar* _tmp105_ = NULL;
		gchar* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		_tmp101_ = fails;
		fails = _tmp101_ + 1;
		_tmp102_ = stdout;
		_tmp103_ = fails;
		fails = _tmp103_ + 1;
		_tmp104_ = fails;
		_tmp105_ = g_strdup_printf ("%i", _tmp104_);
		_tmp106_ = _tmp105_;
		_tmp107_ = g_strconcat ("----- FAIL: ", _tmp106_, NULL);
		_tmp108_ = _tmp107_;
		_tmp109_ = g_strconcat (_tmp108_, "\n", NULL);
		_tmp110_ = _tmp109_;
		fprintf (_tmp102_, "%s", _tmp110_);
		_g_free0 (_tmp110_);
		_g_free0 (_tmp108_);
		_g_free0 (_tmp106_);
	}
	_tmp111_ = stdout;
	fprintf (_tmp111_, "+++++ PASS\n");
	_tmp112_ = stdout;
	fprintf (_tmp112_, "Choping offset = 7 must fail...\n");
	_tmp113_ = self->priv->itermodel;
	_tmp114_ = gee_traversable_chop ((GeeTraversable*) _tmp113_, 7, -1);
	iter3 = _tmp114_;
	_tmp115_ = iter3;
	_tmp116_ = gee_iterator_get_valid (_tmp115_);
	_tmp117_ = _tmp116_;
	if (_tmp117_) {
		FILE* _tmp118_;
		gint _tmp119_;
		gint _tmp120_;
		gchar* _tmp121_ = NULL;
		gchar* _tmp122_;
		gchar* _tmp123_;
		gchar* _tmp124_;
		gchar* _tmp125_;
		gchar* _tmp126_;
		_tmp118_ = stdout;
		_tmp119_ = fails;
		fails = _tmp119_ + 1;
		_tmp120_ = fails;
		_tmp121_ = g_strdup_printf ("%i", _tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = g_strconcat ("----- FAIL: ", _tmp122_, NULL);
		_tmp124_ = _tmp123_;
		_tmp125_ = g_strconcat (_tmp124_, "\n", NULL);
		_tmp126_ = _tmp125_;
		fprintf (_tmp118_, "%s", _tmp126_);
		_g_free0 (_tmp126_);
		_g_free0 (_tmp124_);
		_g_free0 (_tmp122_);
	}
	_tmp127_ = iter3;
	_tmp128_ = gee_iterator_next (_tmp127_);
	if (!_tmp128_) {
		FILE* _tmp129_;
		gint _tmp130_;
		gint _tmp131_;
		gchar* _tmp132_ = NULL;
		gchar* _tmp133_;
		gchar* _tmp134_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		_tmp129_ = stdout;
		_tmp130_ = fails;
		fails = _tmp130_ + 1;
		_tmp131_ = fails;
		_tmp132_ = g_strdup_printf ("%i", _tmp131_);
		_tmp133_ = _tmp132_;
		_tmp134_ = g_strconcat ("----- FAIL: ", _tmp133_, NULL);
		_tmp135_ = _tmp134_;
		_tmp136_ = g_strconcat (_tmp135_, "\n", NULL);
		_tmp137_ = _tmp136_;
		fprintf (_tmp129_, "%s", _tmp137_);
		_g_free0 (_tmp137_);
		_g_free0 (_tmp135_);
		_g_free0 (_tmp133_);
	}
	_tmp138_ = fails;
	if (_tmp138_ == 0) {
		FILE* _tmp139_;
		_tmp139_ = stdout;
		fprintf (_tmp139_, "+++++ PASS\n");
	}
	_tmp140_ = stdout;
	fprintf (_tmp140_, "Choping offset = 6 length = 0 must fail...\n");
	_tmp141_ = self->priv->itermodel;
	_tmp142_ = gee_traversable_chop ((GeeTraversable*) _tmp141_, 6, 0);
	iter4 = _tmp142_;
	_tmp143_ = iter4;
	_tmp144_ = gee_iterator_get_valid (_tmp143_);
	_tmp145_ = _tmp144_;
	if (_tmp145_) {
		FILE* _tmp146_;
		gint _tmp147_;
		gint _tmp148_;
		gchar* _tmp149_ = NULL;
		gchar* _tmp150_;
		gchar* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		gchar* _tmp154_;
		_tmp146_ = stdout;
		_tmp147_ = fails;
		fails = _tmp147_ + 1;
		_tmp148_ = fails;
		_tmp149_ = g_strdup_printf ("%i", _tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = g_strconcat ("----- FAIL: ", _tmp150_, NULL);
		_tmp152_ = _tmp151_;
		_tmp153_ = g_strconcat (_tmp152_, "\n", NULL);
		_tmp154_ = _tmp153_;
		fprintf (_tmp146_, "%s", _tmp154_);
		_g_free0 (_tmp154_);
		_g_free0 (_tmp152_);
		_g_free0 (_tmp150_);
	}
	_tmp155_ = iter4;
	_tmp156_ = gee_iterator_next (_tmp155_);
	if (!_tmp156_) {
		FILE* _tmp157_;
		gint _tmp158_;
		gint _tmp159_;
		gchar* _tmp160_ = NULL;
		gchar* _tmp161_;
		gchar* _tmp162_;
		gchar* _tmp163_;
		gchar* _tmp164_;
		gchar* _tmp165_;
		_tmp157_ = stdout;
		_tmp158_ = fails;
		fails = _tmp158_ + 1;
		_tmp159_ = fails;
		_tmp160_ = g_strdup_printf ("%i", _tmp159_);
		_tmp161_ = _tmp160_;
		_tmp162_ = g_strconcat ("----- FAIL: ", _tmp161_, NULL);
		_tmp163_ = _tmp162_;
		_tmp164_ = g_strconcat (_tmp163_, "\n", NULL);
		_tmp165_ = _tmp164_;
		fprintf (_tmp157_, "%s", _tmp165_);
		_g_free0 (_tmp165_);
		_g_free0 (_tmp163_);
		_g_free0 (_tmp161_);
	}
	_tmp166_ = fails;
	if (_tmp166_ == 0) {
		FILE* _tmp167_;
		_tmp167_ = stdout;
		fprintf (_tmp167_, "+++++ PASS\n");
	}
	_tmp168_ = stdout;
	fprintf (_tmp168_, "Choping offset = 5 length = 1...\n");
	_tmp169_ = self->priv->itermodel;
	_tmp170_ = gee_traversable_chop ((GeeTraversable*) _tmp169_, 5, 1);
	iter5 = _tmp170_;
	_tmp171_ = iter5;
	_tmp172_ = gee_iterator_get_valid (_tmp171_);
	_tmp173_ = _tmp172_;
	if (!_tmp173_) {
		FILE* _tmp174_;
		gint _tmp175_;
		gint _tmp176_;
		gchar* _tmp177_ = NULL;
		gchar* _tmp178_;
		gchar* _tmp179_;
		gchar* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		_tmp174_ = stdout;
		_tmp175_ = fails;
		fails = _tmp175_ + 1;
		_tmp176_ = fails;
		_tmp177_ = g_strdup_printf ("%i", _tmp176_);
		_tmp178_ = _tmp177_;
		_tmp179_ = g_strconcat ("----- FAIL: ", _tmp178_, NULL);
		_tmp180_ = _tmp179_;
		_tmp181_ = g_strconcat (_tmp180_, "\n", NULL);
		_tmp182_ = _tmp181_;
		fprintf (_tmp174_, "%s", _tmp182_);
		_g_free0 (_tmp182_);
		_g_free0 (_tmp180_);
		_g_free0 (_tmp178_);
	}
	_tmp183_ = iter5;
	_tmp184_ = gee_iterator_next (_tmp183_);
	if (_tmp184_) {
		FILE* _tmp185_;
		gint _tmp186_;
		gint _tmp187_;
		gchar* _tmp188_ = NULL;
		gchar* _tmp189_;
		gchar* _tmp190_;
		gchar* _tmp191_;
		gchar* _tmp192_;
		gchar* _tmp193_;
		_tmp185_ = stdout;
		_tmp186_ = fails;
		fails = _tmp186_ + 1;
		_tmp187_ = fails;
		_tmp188_ = g_strdup_printf ("%i", _tmp187_);
		_tmp189_ = _tmp188_;
		_tmp190_ = g_strconcat ("----- FAIL: ", _tmp189_, NULL);
		_tmp191_ = _tmp190_;
		_tmp192_ = g_strconcat (_tmp191_, "\n", NULL);
		_tmp193_ = _tmp192_;
		fprintf (_tmp185_, "%s", _tmp193_);
		_g_free0 (_tmp193_);
		_g_free0 (_tmp191_);
		_g_free0 (_tmp189_);
	}
	_tmp194_ = fails;
	if (_tmp194_ == 0) {
		FILE* _tmp195_;
		_tmp195_ = stdout;
		fprintf (_tmp195_, "+++++ PASS\n");
	}
	_tmp196_ = stdout;
	fprintf (_tmp196_, "Choping offset = 3 length = 1...\n");
	_tmp197_ = self->priv->itermodel;
	_tmp198_ = gee_traversable_chop ((GeeTraversable*) _tmp197_, 3, 2);
	iter6 = _tmp198_;
	_tmp199_ = iter6;
	_tmp200_ = gee_iterator_get_valid (_tmp199_);
	_tmp201_ = _tmp200_;
	if (!_tmp201_) {
		FILE* _tmp202_;
		gint _tmp203_;
		gint _tmp204_;
		gchar* _tmp205_ = NULL;
		gchar* _tmp206_;
		gchar* _tmp207_;
		gchar* _tmp208_;
		gchar* _tmp209_;
		gchar* _tmp210_;
		_tmp202_ = stdout;
		_tmp203_ = fails;
		fails = _tmp203_ + 1;
		_tmp204_ = fails;
		_tmp205_ = g_strdup_printf ("%i", _tmp204_);
		_tmp206_ = _tmp205_;
		_tmp207_ = g_strconcat ("----- FAIL: ", _tmp206_, NULL);
		_tmp208_ = _tmp207_;
		_tmp209_ = g_strconcat (_tmp208_, "\n", NULL);
		_tmp210_ = _tmp209_;
		fprintf (_tmp202_, "%s", _tmp210_);
		_g_free0 (_tmp210_);
		_g_free0 (_tmp208_);
		_g_free0 (_tmp206_);
	}
	_tmp211_ = iter6;
	_tmp212_ = gee_iterator_get (_tmp211_);
	_tmp213_ = (GdaDataDbRecord*) _tmp212_;
	_tmp214_ = gda_data_db_record_get_value (_tmp213_, "name", &_inner_error_);
	_tmp215_ = _tmp214_;
	_g_object_unref0 (_tmp213_);
	tr = _tmp215_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (iter6);
		_g_object_unref0 (iter5);
		_g_object_unref0 (iter4);
		_g_object_unref0 (iter3);
		_g_object_unref0 (iter2);
		_g_free0 (name);
		_g_object_unref0 (iter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp216_ = tr;
	if (_tmp216_ == NULL) {
		FILE* _tmp217_;
		gint _tmp218_;
		gint _tmp219_;
		gchar* _tmp220_ = NULL;
		gchar* _tmp221_;
		gchar* _tmp222_;
		gchar* _tmp223_;
		gchar* _tmp224_;
		gchar* _tmp225_;
		_tmp217_ = stdout;
		_tmp218_ = fails;
		fails = _tmp218_ + 1;
		_tmp219_ = fails;
		_tmp220_ = g_strdup_printf ("%i", _tmp219_);
		_tmp221_ = _tmp220_;
		_tmp222_ = g_strconcat ("----- FAIL: ", _tmp221_, NULL);
		_tmp223_ = _tmp222_;
		_tmp224_ = g_strconcat (_tmp223_, "\n", NULL);
		_tmp225_ = _tmp224_;
		fprintf (_tmp217_, "%s", _tmp225_);
		_g_free0 (_tmp225_);
		_g_free0 (_tmp223_);
		_g_free0 (_tmp221_);
	}
	_tmp226_ = fails;
	if (_tmp226_ == 0) {
		FILE* _tmp227_;
		_tmp227_ = stdout;
		fprintf (_tmp227_, "%s", "+++++ PASS: " "\n");
	}
	result = fails;
	__vala_GValue_free0 (tr);
	_g_object_unref0 (iter6);
	_g_object_unref0 (iter5);
	_g_object_unref0 (iter4);
	_g_object_unref0 (iter3);
	_g_object_unref0 (iter2);
	_g_free0 (name);
	_g_object_unref0 (iter);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean __lambda2_ (CheckTests* self, GdaDataDbRecord* g) {
	gboolean result = FALSE;
	gboolean ret;
	gboolean _tmp23_;
	g_return_val_if_fail (g != NULL, FALSE);
	ret = FALSE;
	{
		GdaDataDbRecord* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _fl_it;
		_tmp0_ = g;
		_tmp1_ = gda_data_db_record_get_fields (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_fl_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			GdaDataDbField* fl;
			GdaDataDbField* _tmp10_;
			GValue* _tmp11_;
			GValue* _tmp12_;
			GValue _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* t;
			FILE* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp6_ = _fl_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _fl_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			fl = (GdaDataDbField*) _tmp9_;
			_tmp10_ = fl;
			_tmp11_ = gda_data_db_field_get_value (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = *_tmp12_;
			_tmp14_ = gda_value_stringify (&_tmp13_);
			t = _tmp14_;
			_tmp15_ = stdout;
			_tmp16_ = t;
			_tmp17_ = g_strconcat ("Value to check: ", _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			fprintf (_tmp15_, "%s", _tmp18_);
			_g_free0 (_tmp18_);
			_tmp19_ = t;
			_tmp20_ = string_contains (_tmp19_, "J");
			if (_tmp20_) {
				FILE* _tmp21_;
				ret = TRUE;
				_tmp21_ = stdout;
				fprintf (_tmp21_, "...SELECTED\n");
				_g_free0 (t);
				_g_object_unref0 (fl);
				break;
			} else {
				FILE* _tmp22_;
				ret = FALSE;
				_tmp22_ = stdout;
				fprintf (_tmp22_, "...REJECTED\n");
			}
			_g_free0 (t);
			_g_object_unref0 (fl);
		}
		_g_object_unref0 (_fl_it);
	}
	_tmp23_ = ret;
	if (_tmp23_) {
		FILE* _tmp24_;
		GdaDataDbRecord* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp24_ = stdout;
		_tmp25_ = g;
		_tmp26_ = gda_data_db_record_to_string (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("SELECTED ROW: \n", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, "\n", NULL);
		_tmp31_ = _tmp30_;
		fprintf (_tmp24_, "%s", _tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
	}
	result = ret;
	return result;
}


static gboolean ___lambda2__gee_predicate (gconstpointer g, gpointer self) {
	gboolean result;
	result = __lambda2_ (self, g);
	return result;
}


gint check_tests_filtering (CheckTests* self) {
	gint result = 0;
	gint fails;
	FILE* _tmp0_;
	GdaDataDbRecordCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iter;
	FILE* _tmp3_;
	gint i;
	gint _tmp24_;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Filtering Records: Any field type STRING with a letter 'J" \
"'...\n");
	_tmp1_ = self->priv->itermodel;
	_tmp2_ = gee_traversable_filter ((GeeTraversable*) _tmp1_, ___lambda2__gee_predicate, g_object_ref (self), g_object_unref);
	iter = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "\nPrinting Filtered Values...\n");
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp4_;
		gboolean _tmp5_ = FALSE;
		FILE* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GeeIterator* _tmp15_;
		gpointer _tmp16_ = NULL;
		GdaDataDbRecord* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_next (_tmp4_);
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = stdout;
		_tmp7_ = i;
		i = _tmp7_ + 1;
		_tmp8_ = i;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("Row", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, ":\n", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = iter;
		_tmp16_ = gee_iterator_get (_tmp15_);
		_tmp17_ = (GdaDataDbRecord*) _tmp16_;
		_tmp18_ = gda_data_db_record_to_string (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp14_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
		_tmp23_ = _tmp22_;
		fprintf (_tmp6_, "%s", _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_object_unref0 (_tmp17_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
	}
	_tmp24_ = i;
	if (_tmp24_ != 3) {
		FILE* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp25_ = stdout;
		_tmp26_ = fails;
		fails = _tmp26_ + 1;
		_tmp27_ = fails;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat ("----- FAIL", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
		_tmp33_ = _tmp32_;
		fprintf (_tmp25_, "%s", _tmp33_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
	} else {
		FILE* _tmp34_;
		_tmp34_ = stdout;
		fprintf (_tmp34_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (iter);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeTraversableStream __lambda3_ (CheckTests* self, GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy) {
	GeeLazy* _vala_lazy = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_;
	_tmp0_ = state;
	if (_tmp0_ == GEE_TRAVERSABLE_STREAM_CONTINUE) {
		GeeLazy* _tmp1_;
		gconstpointer _tmp2_;
		GdaDataDbRecord* _tmp3_;
		GdaDataDbRecord* _tmp4_;
		GdaDataDbRecord* r;
		_tmp1_ = g;
		_tmp2_ = gee_lazy_get_value (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 ((GdaDataDbRecord*) _tmp3_);
		r = _tmp4_;
		{
			GdaDataDbRecord* _tmp5_;
			GeeCollection* _tmp6_;
			GeeCollection* _tmp7_;
			GeeCollection* _tmp8_;
			GeeIterator* _tmp9_ = NULL;
			GeeIterator* _tmp10_;
			GeeIterator* _f_it;
			_tmp5_ = r;
			_tmp6_ = gda_data_db_record_get_fields (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			_f_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				gboolean _tmp12_ = FALSE;
				GeeIterator* _tmp13_;
				gpointer _tmp14_ = NULL;
				GdaDataDbField* f;
				GdaDataDbField* _tmp15_;
				GValue* _tmp16_;
				GValue* _tmp17_;
				GType _tmp18_ = 0UL;
				_tmp11_ = _f_it;
				_tmp12_ = gee_iterator_next (_tmp11_);
				if (!_tmp12_) {
					break;
				}
				_tmp13_ = _f_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				f = (GdaDataDbField*) _tmp14_;
				_tmp15_ = f;
				_tmp16_ = gda_data_db_field_get_value (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = G_VALUE_TYPE (_tmp17_);
				if (_tmp18_ == G_TYPE_STRING) {
					FILE* _tmp19_;
					GdaDataDbField* _tmp20_;
					GValue* _tmp21_;
					GValue* _tmp22_;
					GValue _tmp23_;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					GdaDataDbField* _tmp26_;
					GValue* _tmp27_;
					GValue* _tmp28_;
					GValue _tmp29_;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* ts;
					const gchar* _tmp36_;
					gchar* _tmp37_ = NULL;
					gchar* _tmp38_;
					GeeLazy* _tmp39_;
					_tmp19_ = stdout;
					_tmp20_ = f;
					_tmp21_ = gda_data_db_field_get_value (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = *_tmp22_;
					_tmp24_ = gda_value_stringify (&_tmp23_);
					_tmp25_ = _tmp24_;
					fprintf (_tmp19_, "Value to YIELD: %s\n", _tmp25_);
					_g_free0 (_tmp25_);
					_tmp26_ = f;
					_tmp27_ = gda_data_db_field_get_value (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = *_tmp28_;
					_tmp30_ = gda_value_stringify (&_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_strconcat ("YIELDED Value = ", _tmp31_, NULL);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strconcat (_tmp33_, "\n", NULL);
					_tmp35_ = _tmp34_;
					_g_free0 (_tmp33_);
					_g_free0 (_tmp31_);
					ts = _tmp35_;
					_tmp36_ = ts;
					_tmp37_ = g_strdup (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = gee_lazy_new_from_value (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp38_);
					_gee_lazy_unref0 (_vala_lazy);
					_vala_lazy = _tmp39_;
					_g_free0 (_tmp38_);
					_g_free0 (ts);
				}
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
		result = GEE_TRAVERSABLE_STREAM_YIELD;
		_g_object_unref0 (r);
		_gee_lazy_unref0 (g);
		if (lazy) {
			*lazy = _vala_lazy;
		} else {
			_gee_lazy_unref0 (_vala_lazy);
		}
		return result;
	}
	result = GEE_TRAVERSABLE_STREAM_END;
	_gee_lazy_unref0 (g);
	if (lazy) {
		*lazy = _vala_lazy;
	} else {
		_gee_lazy_unref0 (_vala_lazy);
	}
	return result;
}


static GeeTraversableStream ___lambda3__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda3_ (self, state, g, lazy);
	return result;
}


gint check_tests_streaming (CheckTests* self) {
	gint result = 0;
	gint fails;
	FILE* _tmp0_;
	GdaDataDbRecordCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iter;
	FILE* _tmp3_;
	FILE* _tmp10_;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Streaming Values: Fist field type STRING will be YIELDED." \
"..\n");
	_tmp1_ = self->priv->itermodel;
	_tmp2_ = gee_traversable_stream ((GeeTraversable*) _tmp1_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ___lambda3__gee_stream_func, g_object_ref (self), g_object_unref);
	iter = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Printing Streamed Values...\n");
	while (TRUE) {
		GeeIterator* _tmp4_;
		gboolean _tmp5_ = FALSE;
		FILE* _tmp6_;
		GeeIterator* _tmp7_;
		gpointer _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_next (_tmp4_);
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = stdout;
		_tmp7_ = iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		_tmp9_ = (gchar*) _tmp8_;
		fprintf (_tmp6_, "%s", _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = stdout;
	fprintf (_tmp10_, "\n");
	result = fails;
	_g_object_unref0 (iter);
	return result;
}


gint check_tests_InitIter (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	GdaConnection* _tmp1_;
	GdaDataModel* _tmp2_ = NULL;
	GdaDataModel* model;
	FILE* _tmp3_;
	GdaDataTable* _tmp4_;
	GdaDataTable* t;
	GdaDataTable* _tmp5_;
	GdaConnection* _tmp6_;
	GdaDataTable* _tmp7_;
	FILE* _tmp8_;
	FILE* _tmp9_;
	GdaDataTable* _tmp10_;
	GdaDataRecordCollection* _tmp11_;
	FILE* _tmp12_;
	FILE* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Initializing DbRecordCollection/RecordCollection\n");
	fails = 0;
	_tmp1_ = self->priv->connection;
	_tmp2_ = gda_connection_execute_select_command (_tmp1_, "SELECT * FROM user", &_inner_error_);
	model = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Setting up Table...");
	_tmp4_ = gda_data_table_new ();
	t = _tmp4_;
	_tmp5_ = t;
	_tmp6_ = self->priv->connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp5_, _tmp6_);
	_tmp7_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp7_, "user");
	_tmp8_ = stdout;
	fprintf (_tmp8_, "+++++ PASS\n");
	_tmp9_ = stdout;
	fprintf (_tmp9_, "Setting up DbRecordCollection...");
	_tmp10_ = t;
	_tmp11_ = gda_data_record_collection_new (model, (GdaDataDbTable*) _tmp10_);
	_g_object_unref0 (self->priv->itermodel);
	self->priv->itermodel = (GdaDataDbRecordCollection*) _tmp11_;
	_tmp12_ = stdout;
	fprintf (_tmp12_, "+++++ PASS\n");
	_tmp13_ = stdout;
	_tmp14_ = gda_data_model_dump_as_string (model);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat ("DataModel rows:\n", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	fprintf (_tmp13_, "%s", _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	result = fails;
	_g_object_unref0 (t);
	_g_object_unref0 (model);
	return result;
}


gint check_tests_t2 (CheckTests* self) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	GdaConnection* _tmp1_;
	GdaDataModel* _tmp2_ = NULL;
	GdaDataModel* model;
	GdaDataModel* _tmp3_;
	GdaDataModel* _tmp4_;
	GdaDataProxy* _tmp5_;
	GdaDataProxy* pxy;
	GdaDataTable* _tmp6_;
	GdaDataTable* t;
	GdaDataTable* _tmp7_;
	GdaConnection* _tmp8_;
	GdaDataTable* _tmp9_;
	GdaDataProxy* _tmp10_;
	GdaDataTable* _tmp11_;
	GdaDataRecordCollection* _tmp12_;
	GdaDataRecordCollection* itermodel;
	GdaDataRecord* _tmp13_;
	GdaDataRecord* row;
	GdaDataRecord* _tmp14_;
	GdaDataTable* _tmp15_;
	GdaDataField* _tmp16_;
	GdaDataField* f;
	GdaDataField* _tmp17_;
	GValue* _tmp18_ = NULL;
	GdaDataRecord* _tmp19_;
	GdaDataField* _tmp20_;
	GdaDataField* _tmp21_;
	GdaDataField* _tmp22_;
	GValue* _tmp23_ = NULL;
	GdaDataRecord* _tmp24_;
	GdaDataField* _tmp25_;
	GdaDataField* _tmp26_;
	GdaDataField* _tmp27_;
	GValue* _tmp28_ = NULL;
	GdaDataRecord* _tmp29_;
	GdaDataField* _tmp30_;
	GdaDataRecordCollection* _tmp31_;
	GdaDataRecord* _tmp32_;
	gboolean _tmp33_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", ">>> NEW TEST: GdaData.RecordCollection & RecordCollectionIterator API " \
"tests\n" ">>> Testing Collection, Iterator, Traversable Interfaces implementatio" \
"n\n");
	fails = 0;
	_tmp1_ = self->priv->connection;
	_tmp2_ = gda_connection_execute_select_command (_tmp1_, "SELECT * FROM user", &_inner_error_);
	model = _tmp2_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp3_ = model;
	gda_data_select_compute_modification_statements (GDA_DATA_SELECT (_tmp3_), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp4_ = model;
	_tmp5_ = gda_data_proxy_new_with_data_model (_tmp4_);
	pxy = _tmp5_;
	_tmp6_ = gda_data_table_new ();
	t = _tmp6_;
	_tmp7_ = t;
	_tmp8_ = self->priv->connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp7_, _tmp8_);
	_tmp9_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp9_, "user");
	_tmp10_ = pxy;
	_tmp11_ = t;
	_tmp12_ = gda_data_record_collection_new ((GdaDataModel*) _tmp10_, (GdaDataDbTable*) _tmp11_);
	itermodel = _tmp12_;
	_tmp13_ = gda_data_record_new ();
	row = _tmp13_;
	_tmp14_ = row;
	_tmp15_ = t;
	gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp14_, (GdaDataDbTable*) _tmp15_);
	_tmp16_ = gda_data_field_new ("id", GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
	f = _tmp16_;
	_tmp17_ = f;
	_tmp18_ = g_new0 (GValue, 1);
	g_value_init (_tmp18_, G_TYPE_INT);
	g_value_set_int (_tmp18_, 10);
	gda_data_db_field_set_value ((GdaDataDbField*) _tmp17_, _tmp18_);
	__vala_GValue_free0 (_tmp18_);
	_tmp19_ = row;
	_tmp20_ = f;
	gda_data_db_record_set_field ((GdaDataDbRecord*) _tmp19_, (GdaDataDbField*) _tmp20_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		_g_object_unref0 (row);
		_g_object_unref0 (itermodel);
		_g_object_unref0 (t);
		_g_object_unref0 (pxy);
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp21_ = f;
	gda_data_db_field_set_name ((GdaDataDbField*) _tmp21_, "name");
	_tmp22_ = f;
	_tmp23_ = g_new0 (GValue, 1);
	g_value_init (_tmp23_, G_TYPE_STRING);
	g_value_set_string (_tmp23_, "Samanta");
	gda_data_db_field_set_value ((GdaDataDbField*) _tmp22_, _tmp23_);
	__vala_GValue_free0 (_tmp23_);
	_tmp24_ = row;
	_tmp25_ = f;
	gda_data_db_record_set_field ((GdaDataDbRecord*) _tmp24_, (GdaDataDbField*) _tmp25_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		_g_object_unref0 (row);
		_g_object_unref0 (itermodel);
		_g_object_unref0 (t);
		_g_object_unref0 (pxy);
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp26_ = f;
	gda_data_db_field_set_name ((GdaDataDbField*) _tmp26_, "city");
	_tmp27_ = f;
	_tmp28_ = g_new0 (GValue, 1);
	g_value_init (_tmp28_, G_TYPE_STRING);
	g_value_set_string (_tmp28_, "San Francisco");
	gda_data_db_field_set_value ((GdaDataDbField*) _tmp27_, _tmp28_);
	__vala_GValue_free0 (_tmp28_);
	_tmp29_ = row;
	_tmp30_ = f;
	gda_data_db_record_set_field ((GdaDataDbRecord*) _tmp29_, (GdaDataDbField*) _tmp30_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		_g_object_unref0 (row);
		_g_object_unref0 (itermodel);
		_g_object_unref0 (t);
		_g_object_unref0 (pxy);
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp31_ = itermodel;
	_tmp32_ = row;
	_tmp33_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, (GdaDataDbRecord*) _tmp32_);
	if (_tmp33_) {
		FILE* _tmp34_;
		GdaDataRecordCollection* _tmp35_;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp34_ = stdout;
		_tmp35_ = itermodel;
		_tmp36_ = gda_data_record_collection_to_string (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat ("New contents in DataModel:\n", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		fprintf (_tmp34_, "%s", _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
	} else {
		gint _tmp40_;
		_tmp40_ = fails;
		fails = _tmp40_ + 1;
	}
	result = fails;
	_g_object_unref0 (f);
	_g_object_unref0 (row);
	_g_object_unref0 (itermodel);
	_g_object_unref0 (t);
	_g_object_unref0 (pxy);
	_g_object_unref0 (model);
	return result;
}


gint check_tests_main (gchar** args, int args_length1) {
	gint result = 0;
	FILE* _tmp0_;
	gint failures;
	CheckTests* _tmp1_;
	CheckTests* app;
	CheckTests* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	CheckTests* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	CheckTests* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_;
	CheckTests* _tmp14_;
	gint _tmp15_ = 0;
	gint _tmp16_;
	CheckTests* _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_;
	gint _tmp21_;
	GError * _inner_error_ = NULL;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Checking Gda.DataModelIterator implementation...\n");
	failures = 0;
	_tmp1_ = check_tests_new ();
	app = _tmp1_;
	_tmp2_ = app;
	_tmp3_ = check_tests_InitIter (_tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = failures;
	failures = _tmp5_ + _tmp4_;
	_tmp6_ = app;
	_tmp7_ = check_tests_iterating (_tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = failures;
	failures = _tmp9_ + _tmp8_;
	_tmp10_ = failures;
	_tmp11_ = app;
	_tmp12_ = check_tests_streaming (_tmp11_);
	failures = _tmp10_ + _tmp12_;
	_tmp13_ = failures;
	_tmp14_ = app;
	_tmp15_ = check_tests_filtering (_tmp14_);
	failures = _tmp13_ + _tmp15_;
	_tmp16_ = failures;
	_tmp17_ = app;
	_tmp18_ = check_tests_choping (_tmp17_);
	failures = _tmp16_ + _tmp18_;
	_tmp20_ = failures;
	if (_tmp20_ != 0) {
		_tmp19_ = 1;
	} else {
		_tmp19_ = 0;
	}
	_tmp21_ = _tmp19_;
	result = _tmp21_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return check_tests_main (argv, argc);
}


static void check_tests_class_init (CheckTestsClass * klass) {
	check_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheckTestsPrivate));
	G_OBJECT_CLASS (klass)->finalize = check_tests_finalize;
}


static void check_tests_instance_init (CheckTests * self) {
	self->priv = CHECK_TESTS_GET_PRIVATE (self);
}


static void check_tests_finalize (GObject* obj) {
	CheckTests * self;
	self = CHECK_TESTS (obj);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->itermodel);
	G_OBJECT_CLASS (check_tests_parent_class)->finalize (obj);
}


GType check_tests_get_type (void) {
	static volatile gsize check_tests_type_id__volatile = 0;
	if (g_once_init_enter (&check_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckTests), 0, (GInstanceInitFunc) check_tests_instance_init, NULL };
		GType check_tests_type_id;
		check_tests_type_id = g_type_register_static (G_TYPE_OBJECT, "CheckTests", &g_define_type_info, 0);
		g_once_init_leave (&check_tests_type_id__volatile, check_tests_type_id);
	}
	return check_tests_type_id__volatile;
}



