/* Catalog.c generated by valac 0.16.0, the Vala compiler
 * generated from Catalog.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdavala
 * Copyright (C) Daniel Espinosa Ortiz 2012 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GDA_DATA_TYPE_DB_OBJECT (gda_data_db_object_get_type ())
#define GDA_DATA_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObject))
#define GDA_DATA_IS_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_OBJECT))
#define GDA_DATA_DB_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObjectIface))

typedef struct _GdaDataDbObject GdaDataDbObject;
typedef struct _GdaDataDbObjectIface GdaDataDbObjectIface;

#define GDA_DATA_TYPE_DB_NAMED_OBJECT (gda_data_db_named_object_get_type ())
#define GDA_DATA_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObject))
#define GDA_DATA_IS_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT))
#define GDA_DATA_DB_NAMED_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObjectIface))

typedef struct _GdaDataDbNamedObject GdaDataDbNamedObject;
typedef struct _GdaDataDbNamedObjectIface GdaDataDbNamedObjectIface;

#define GDA_DATA_TYPE_DB_CATALOG (gda_data_db_catalog_get_type ())
#define GDA_DATA_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalog))
#define GDA_DATA_IS_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_CATALOG))
#define GDA_DATA_DB_CATALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalogIface))

typedef struct _GdaDataDbCatalog GdaDataDbCatalog;
typedef struct _GdaDataDbCatalogIface GdaDataDbCatalogIface;

#define GDA_DATA_TYPE_DB_SCHEMA (gda_data_db_schema_get_type ())
#define GDA_DATA_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema))
#define GDA_DATA_IS_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_SCHEMA))
#define GDA_DATA_DB_SCHEMA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchemaIface))

typedef struct _GdaDataDbSchema GdaDataDbSchema;
typedef struct _GdaDataDbSchemaIface GdaDataDbSchemaIface;

#define GDA_DATA_TYPE_DB_TABLE (gda_data_db_table_get_type ())
#define GDA_DATA_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTable))
#define GDA_DATA_IS_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_TABLE))
#define GDA_DATA_DB_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTableIface))

typedef struct _GdaDataDbTable GdaDataDbTable;
typedef struct _GdaDataDbTableIface GdaDataDbTableIface;

#define GDA_DATA_TYPE_DB_FIELD_INFO (gda_data_db_field_info_get_type ())
#define GDA_DATA_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfo))
#define GDA_DATA_IS_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO))
#define GDA_DATA_DB_FIELD_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfoIface))

typedef struct _GdaDataDbFieldInfo GdaDataDbFieldInfo;
typedef struct _GdaDataDbFieldInfoIface GdaDataDbFieldInfoIface;

#define GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE (gda_data_db_field_info_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY (gda_data_db_field_info_foreign_key_get_type ())
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))

typedef struct _GdaDataDbFieldInfoForeignKey GdaDataDbFieldInfoForeignKey;
typedef struct _GdaDataDbFieldInfoForeignKeyClass GdaDataDbFieldInfoForeignKeyClass;

#define GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE (gda_data_db_table_table_type_get_type ())

#define GDA_DATA_TYPE_DB_RECORD (gda_data_db_record_get_type ())
#define GDA_DATA_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecord))
#define GDA_DATA_IS_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD))
#define GDA_DATA_DB_RECORD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecordIface))

typedef struct _GdaDataDbRecord GdaDataDbRecord;
typedef struct _GdaDataDbRecordIface GdaDataDbRecordIface;

#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())

#define GDA_DATA_TYPE_CATALOG (gda_data_catalog_get_type ())
#define GDA_DATA_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_CATALOG, GdaDataCatalog))
#define GDA_DATA_CATALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_CATALOG, GdaDataCatalogClass))
#define GDA_DATA_IS_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_CATALOG))
#define GDA_DATA_IS_CATALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_CATALOG))
#define GDA_DATA_CATALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_CATALOG, GdaDataCatalogClass))

typedef struct _GdaDataCatalog GdaDataCatalog;
typedef struct _GdaDataCatalogClass GdaDataCatalogClass;
typedef struct _GdaDataCatalogPrivate GdaDataCatalogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GdaDataDbObjectIface {
	GTypeInterface parent_iface;
	void (*append) (GdaDataDbObject* self, GError** error);
	void (*update) (GdaDataDbObject* self, GError** error);
	void (*save) (GdaDataDbObject* self, GError** error);
	void (*drop) (GdaDataDbObject* self, gboolean cascade, GError** error);
	GdaConnection* (*get_connection) (GdaDataDbObject* self);
	void (*set_connection) (GdaDataDbObject* self, GdaConnection* value);
	gboolean (*get_update_meta) (GdaDataDbObject* self);
	void (*set_update_meta) (GdaDataDbObject* self, gboolean value);
};

struct _GdaDataDbNamedObjectIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GdaDataDbNamedObject* self);
	void (*set_name) (GdaDataDbNamedObject* self, const gchar* value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY = 1 << 1,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE = 1 << 2,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY = 1 << 3,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK = 1 << 4,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT = 1 << 5,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL = 1 << 6,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT = 1 << 7
} GdaDataDbFieldInfoAttribute;

struct _GdaDataDbFieldInfoIface {
	GTypeInterface parent_iface;
	gint (*get_ordinal) (GdaDataDbFieldInfo* self);
	void (*set_ordinal) (GdaDataDbFieldInfo* self, gint value);
	GType (*get_value_type) (GdaDataDbFieldInfo* self);
	void (*set_value_type) (GdaDataDbFieldInfo* self, GType value);
	GdaDataDbFieldInfoAttribute (*get_attributes) (GdaDataDbFieldInfo* self);
	void (*set_attributes) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
	GValue* (*get_default_value) (GdaDataDbFieldInfo* self);
	void (*set_default_value) (GdaDataDbFieldInfo* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbFieldInfo* self);
	void (*set_name) (GdaDataDbFieldInfo* self, const gchar* value);
	const gchar* (*get_desc) (GdaDataDbFieldInfo* self);
	void (*set_desc) (GdaDataDbFieldInfo* self, const gchar* value);
	gint (*get_precision) (GdaDataDbFieldInfo* self);
	void (*set_precision) (GdaDataDbFieldInfo* self, gint value);
	gint (*get_scale) (GdaDataDbFieldInfo* self);
	void (*set_scale) (GdaDataDbFieldInfo* self, gint value);
	GdaDataDbFieldInfoForeignKey* (*get_fkey) (GdaDataDbFieldInfo* self);
	void (*set_fkey) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
};

typedef enum  {
	GDA_DATA_DB_TABLE_TABLE_TYPE_NONE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW,
	GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM
} GdaDataDbTableTableType;

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};

struct _GdaDataDbRecordIface {
	GTypeInterface parent_iface;
	GValue* (*get_value) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_field) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_field_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_field) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_key) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_key_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_key) (GdaDataDbRecord* self, const gchar* name, GError** error);
	gchar* (*to_string) (GdaDataDbRecord* self);
	GdaDataDbTable* (*get_table) (GdaDataDbRecord* self);
	void (*set_table) (GdaDataDbRecord* self, GdaDataDbTable* value);
	GeeCollection* (*get_fields) (GdaDataDbRecord* self);
	GeeCollection* (*get_keys) (GdaDataDbRecord* self);
};

struct _GdaDataDbTableIface {
	GTypeInterface parent_iface;
	void (*set_field) (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
	GdaDataDbFieldInfo* (*get_field) (GdaDataDbTable* self, const gchar* name, GError** error);
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbTable* self);
	void (*set_catalog) (GdaDataDbTable* self, GdaDataDbCatalog* value);
	GdaDataDbSchema* (*get_schema) (GdaDataDbTable* self);
	void (*set_schema) (GdaDataDbTable* self, GdaDataDbSchema* value);
	GdaDataDbTableTableType (*get_table_type) (GdaDataDbTable* self);
	void (*set_table_type) (GdaDataDbTable* self, GdaDataDbTableTableType value);
	GeeCollection* (*get_records) (GdaDataDbTable* self);
	GeeCollection* (*get_depends) (GdaDataDbTable* self);
	GeeCollection* (*get_referenced) (GdaDataDbTable* self);
	GeeCollection* (*get_fields) (GdaDataDbTable* self);
	GeeCollection* (*get_primary_keys) (GdaDataDbTable* self);
};

struct _GdaDataDbSchemaIface {
	GTypeInterface parent_iface;
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbSchema* self);
	void (*set_catalog) (GdaDataDbSchema* self, GdaDataDbCatalog* value);
	GeeCollection* (*get_tables) (GdaDataDbSchema* self);
};

struct _GdaDataDbCatalogIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_shemas) (GdaDataDbCatalog* self);
	void (*set_shemas) (GdaDataDbCatalog* self, GeeCollection* value);
};

struct _GdaDataCatalog {
	GObject parent_instance;
	GdaDataCatalogPrivate * priv;
};

struct _GdaDataCatalogClass {
	GObjectClass parent_class;
};

struct _GdaDataCatalogPrivate {
	GdaConnection* _connection;
	gboolean _update_meta;
	gchar* _name;
	GeeCollection* _shemas;
};


static gpointer gda_data_catalog_parent_class = NULL;
static GdaDataDbObjectIface* gda_data_catalog_gda_data_db_object_parent_iface = NULL;
static GdaDataDbNamedObjectIface* gda_data_catalog_gda_data_db_named_object_parent_iface = NULL;
static GdaDataDbCatalogIface* gda_data_catalog_gda_data_db_catalog_parent_iface = NULL;

GType gda_data_db_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_named_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_attribute_get_type (void) G_GNUC_CONST;
gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance);
void gda_data_db_field_info_foreign_key_unref (gpointer instance);
GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gda_data_db_field_info_value_set_foreign_key (GValue* value, gpointer v_object);
void gda_data_db_field_info_value_take_foreign_key (GValue* value, gpointer v_object);
gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value);
GType gda_data_db_field_info_foreign_key_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_table_type_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_get_type (void) G_GNUC_CONST;
GType gda_data_db_schema_get_type (void) G_GNUC_CONST;
GType gda_data_db_catalog_get_type (void) G_GNUC_CONST;
GType gda_data_catalog_get_type (void) G_GNUC_CONST;
#define GDA_DATA_CATALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GDA_DATA_TYPE_CATALOG, GdaDataCatalogPrivate))
enum  {
	GDA_DATA_CATALOG_DUMMY_PROPERTY,
	GDA_DATA_CATALOG_CONNECTION,
	GDA_DATA_CATALOG_UPDATE_META,
	GDA_DATA_CATALOG_NAME,
	GDA_DATA_CATALOG_SHEMAS
};
static void gda_data_catalog_real_update (GdaDataDbObject* base, GError** error);
static void gda_data_catalog_real_save (GdaDataDbObject* base, GError** error);
static void gda_data_catalog_real_append (GdaDataDbObject* base, GError** error);
static void gda_data_catalog_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error);
GdaDataCatalog* gda_data_catalog_new (void);
GdaDataCatalog* gda_data_catalog_construct (GType object_type);
static void gda_data_catalog_finalize (GObject* obj);
GdaConnection* gda_data_db_object_get_connection (GdaDataDbObject* self);
gboolean gda_data_db_object_get_update_meta (GdaDataDbObject* self);
const gchar* gda_data_db_named_object_get_name (GdaDataDbNamedObject* self);
GeeCollection* gda_data_db_catalog_get_shemas (GdaDataDbCatalog* self);
static void _vala_gda_data_catalog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gda_data_db_object_set_connection (GdaDataDbObject* self, GdaConnection* value);
void gda_data_db_object_set_update_meta (GdaDataDbObject* self, gboolean value);
void gda_data_db_named_object_set_name (GdaDataDbNamedObject* self, const gchar* value);
void gda_data_db_catalog_set_shemas (GdaDataDbCatalog* self, GeeCollection* value);
static void _vala_gda_data_catalog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void gda_data_catalog_real_update (GdaDataDbObject* base, GError** error) {
	GdaDataCatalog * self;
	self = (GdaDataCatalog*) base;
}


static void gda_data_catalog_real_save (GdaDataDbObject* base, GError** error) {
	GdaDataCatalog * self;
	self = (GdaDataCatalog*) base;
}


static void gda_data_catalog_real_append (GdaDataDbObject* base, GError** error) {
	GdaDataCatalog * self;
	self = (GdaDataCatalog*) base;
}


static void gda_data_catalog_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error) {
	GdaDataCatalog * self;
	self = (GdaDataCatalog*) base;
}


GdaDataCatalog* gda_data_catalog_construct (GType object_type) {
	GdaDataCatalog * self = NULL;
	self = (GdaDataCatalog*) g_object_new (object_type, NULL);
	return self;
}


GdaDataCatalog* gda_data_catalog_new (void) {
	return gda_data_catalog_construct (GDA_DATA_TYPE_CATALOG);
}


static GdaConnection* gda_data_catalog_real_get_connection (GdaDataDbObject* base) {
	GdaConnection* result;
	GdaDataCatalog* self;
	GdaConnection* _tmp0_;
	self = (GdaDataCatalog*) base;
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gda_data_catalog_real_set_connection (GdaDataDbObject* base, GdaConnection* value) {
	GdaDataCatalog* self;
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	self = (GdaDataCatalog*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	g_object_notify ((GObject *) self, "connection");
}


static gboolean gda_data_catalog_real_get_update_meta (GdaDataDbObject* base) {
	gboolean result;
	GdaDataCatalog* self;
	gboolean _tmp0_;
	self = (GdaDataCatalog*) base;
	_tmp0_ = self->priv->_update_meta;
	result = _tmp0_;
	return result;
}


static void gda_data_catalog_real_set_update_meta (GdaDataDbObject* base, gboolean value) {
	GdaDataCatalog* self;
	gboolean _tmp0_;
	self = (GdaDataCatalog*) base;
	_tmp0_ = value;
	self->priv->_update_meta = _tmp0_;
	g_object_notify ((GObject *) self, "update-meta");
}


static const gchar* gda_data_catalog_real_get_name (GdaDataDbNamedObject* base) {
	const gchar* result;
	GdaDataCatalog* self;
	const gchar* _tmp0_;
	self = (GdaDataCatalog*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void gda_data_catalog_real_set_name (GdaDataDbNamedObject* base, const gchar* value) {
	GdaDataCatalog* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (GdaDataCatalog*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static GeeCollection* gda_data_catalog_real_get_shemas (GdaDataDbCatalog* base) {
	GeeCollection* result;
	GdaDataCatalog* self;
	GeeCollection* _tmp0_;
	self = (GdaDataCatalog*) base;
	_tmp0_ = self->priv->_shemas;
	result = _tmp0_;
	return result;
}


static void gda_data_catalog_real_set_shemas (GdaDataDbCatalog* base, GeeCollection* value) {
	GdaDataCatalog* self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	self = (GdaDataCatalog*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_shemas);
	self->priv->_shemas = _tmp1_;
	g_object_notify ((GObject *) self, "shemas");
}


static void gda_data_catalog_class_init (GdaDataCatalogClass * klass) {
	gda_data_catalog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GdaDataCatalogPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gda_data_catalog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gda_data_catalog_set_property;
	G_OBJECT_CLASS (klass)->finalize = gda_data_catalog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_CATALOG_CONNECTION, g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_CATALOG_UPDATE_META, g_param_spec_boolean ("update-meta", "update-meta", "update-meta", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_CATALOG_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_CATALOG_SHEMAS, g_param_spec_object ("shemas", "shemas", "shemas", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gda_data_catalog_gda_data_db_object_interface_init (GdaDataDbObjectIface * iface) {
	gda_data_catalog_gda_data_db_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->update = (void (*)(GdaDataDbObject*, GError**)) gda_data_catalog_real_update;
	iface->save = (void (*)(GdaDataDbObject*, GError**)) gda_data_catalog_real_save;
	iface->append = (void (*)(GdaDataDbObject*, GError**)) gda_data_catalog_real_append;
	iface->drop = (void (*)(GdaDataDbObject*, gboolean, GError**)) gda_data_catalog_real_drop;
	iface->get_connection = gda_data_catalog_real_get_connection;
	iface->set_connection = gda_data_catalog_real_set_connection;
	iface->get_update_meta = gda_data_catalog_real_get_update_meta;
	iface->set_update_meta = gda_data_catalog_real_set_update_meta;
}


static void gda_data_catalog_gda_data_db_named_object_interface_init (GdaDataDbNamedObjectIface * iface) {
	gda_data_catalog_gda_data_db_named_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = gda_data_catalog_real_get_name;
	iface->set_name = gda_data_catalog_real_set_name;
}


static void gda_data_catalog_gda_data_db_catalog_interface_init (GdaDataDbCatalogIface * iface) {
	gda_data_catalog_gda_data_db_catalog_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_shemas = gda_data_catalog_real_get_shemas;
	iface->set_shemas = gda_data_catalog_real_set_shemas;
}


static void gda_data_catalog_instance_init (GdaDataCatalog * self) {
	self->priv = GDA_DATA_CATALOG_GET_PRIVATE (self);
}


static void gda_data_catalog_finalize (GObject* obj) {
	GdaDataCatalog * self;
	self = GDA_DATA_CATALOG (obj);
	_g_object_unref0 (self->priv->_connection);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_shemas);
	G_OBJECT_CLASS (gda_data_catalog_parent_class)->finalize (obj);
}


GType gda_data_catalog_get_type (void) {
	static volatile gsize gda_data_catalog_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_catalog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataCatalogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gda_data_catalog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdaDataCatalog), 0, (GInstanceInitFunc) gda_data_catalog_instance_init, NULL };
		static const GInterfaceInfo gda_data_db_object_info = { (GInterfaceInitFunc) gda_data_catalog_gda_data_db_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_named_object_info = { (GInterfaceInitFunc) gda_data_catalog_gda_data_db_named_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_catalog_info = { (GInterfaceInitFunc) gda_data_catalog_gda_data_db_catalog_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gda_data_catalog_type_id;
		gda_data_catalog_type_id = g_type_register_static (G_TYPE_OBJECT, "GdaDataCatalog", &g_define_type_info, 0);
		g_type_add_interface_static (gda_data_catalog_type_id, GDA_DATA_TYPE_DB_OBJECT, &gda_data_db_object_info);
		g_type_add_interface_static (gda_data_catalog_type_id, GDA_DATA_TYPE_DB_NAMED_OBJECT, &gda_data_db_named_object_info);
		g_type_add_interface_static (gda_data_catalog_type_id, GDA_DATA_TYPE_DB_CATALOG, &gda_data_db_catalog_info);
		g_once_init_leave (&gda_data_catalog_type_id__volatile, gda_data_catalog_type_id);
	}
	return gda_data_catalog_type_id__volatile;
}


static void _vala_gda_data_catalog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GdaDataCatalog * self;
	self = GDA_DATA_CATALOG (object);
	switch (property_id) {
		case GDA_DATA_CATALOG_CONNECTION:
		g_value_set_object (value, gda_data_db_object_get_connection ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_CATALOG_UPDATE_META:
		g_value_set_boolean (value, gda_data_db_object_get_update_meta ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_CATALOG_NAME:
		g_value_set_string (value, gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self));
		break;
		case GDA_DATA_CATALOG_SHEMAS:
		g_value_set_object (value, gda_data_db_catalog_get_shemas ((GdaDataDbCatalog*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gda_data_catalog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GdaDataCatalog * self;
	self = GDA_DATA_CATALOG (object);
	switch (property_id) {
		case GDA_DATA_CATALOG_CONNECTION:
		gda_data_db_object_set_connection ((GdaDataDbObject*) self, g_value_get_object (value));
		break;
		case GDA_DATA_CATALOG_UPDATE_META:
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, g_value_get_boolean (value));
		break;
		case GDA_DATA_CATALOG_NAME:
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) self, g_value_get_string (value));
		break;
		case GDA_DATA_CATALOG_SHEMAS:
		gda_data_db_catalog_set_shemas ((GdaDataDbCatalog*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



