/* Table.c generated by valac 0.16.0, the Vala compiler
 * generated from Table.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata
 * Copyright (C) Daniel Espinosa Ortiz 2012 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <stdio.h>


#define GDA_DATA_TYPE_DB_OBJECT (gda_data_db_object_get_type ())
#define GDA_DATA_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObject))
#define GDA_DATA_IS_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_OBJECT))
#define GDA_DATA_DB_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObjectIface))

typedef struct _GdaDataDbObject GdaDataDbObject;
typedef struct _GdaDataDbObjectIface GdaDataDbObjectIface;

#define GDA_DATA_TYPE_DB_NAMED_OBJECT (gda_data_db_named_object_get_type ())
#define GDA_DATA_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObject))
#define GDA_DATA_IS_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT))
#define GDA_DATA_DB_NAMED_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObjectIface))

typedef struct _GdaDataDbNamedObject GdaDataDbNamedObject;
typedef struct _GdaDataDbNamedObjectIface GdaDataDbNamedObjectIface;

#define GDA_DATA_TYPE_DB_TABLE (gda_data_db_table_get_type ())
#define GDA_DATA_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTable))
#define GDA_DATA_IS_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_TABLE))
#define GDA_DATA_DB_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTableIface))

typedef struct _GdaDataDbTable GdaDataDbTable;
typedef struct _GdaDataDbTableIface GdaDataDbTableIface;

#define GDA_DATA_TYPE_DB_FIELD_INFO (gda_data_db_field_info_get_type ())
#define GDA_DATA_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfo))
#define GDA_DATA_IS_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO))
#define GDA_DATA_DB_FIELD_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfoIface))

typedef struct _GdaDataDbFieldInfo GdaDataDbFieldInfo;
typedef struct _GdaDataDbFieldInfoIface GdaDataDbFieldInfoIface;

#define GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE (gda_data_db_field_info_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY (gda_data_db_field_info_foreign_key_get_type ())
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))

typedef struct _GdaDataDbFieldInfoForeignKey GdaDataDbFieldInfoForeignKey;
typedef struct _GdaDataDbFieldInfoForeignKeyClass GdaDataDbFieldInfoForeignKeyClass;

#define GDA_DATA_TYPE_DB_CATALOG (gda_data_db_catalog_get_type ())
#define GDA_DATA_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalog))
#define GDA_DATA_IS_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_CATALOG))
#define GDA_DATA_DB_CATALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalogIface))

typedef struct _GdaDataDbCatalog GdaDataDbCatalog;
typedef struct _GdaDataDbCatalogIface GdaDataDbCatalogIface;

#define GDA_DATA_TYPE_DB_SCHEMA (gda_data_db_schema_get_type ())
#define GDA_DATA_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema))
#define GDA_DATA_IS_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_SCHEMA))
#define GDA_DATA_DB_SCHEMA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchemaIface))

typedef struct _GdaDataDbSchema GdaDataDbSchema;
typedef struct _GdaDataDbSchemaIface GdaDataDbSchemaIface;

#define GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE (gda_data_db_table_table_type_get_type ())

#define GDA_DATA_TYPE_DB_RECORD (gda_data_db_record_get_type ())
#define GDA_DATA_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecord))
#define GDA_DATA_IS_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD))
#define GDA_DATA_DB_RECORD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecordIface))

typedef struct _GdaDataDbRecord GdaDataDbRecord;
typedef struct _GdaDataDbRecordIface GdaDataDbRecordIface;

#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())

#define GDA_DATA_TYPE_TABLE (gda_data_table_get_type ())
#define GDA_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_TABLE, GdaDataTable))
#define GDA_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_TABLE, GdaDataTableClass))
#define GDA_DATA_IS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_TABLE))
#define GDA_DATA_IS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_TABLE))
#define GDA_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_TABLE, GdaDataTableClass))

typedef struct _GdaDataTable GdaDataTable;
typedef struct _GdaDataTableClass GdaDataTableClass;
typedef struct _GdaDataTablePrivate GdaDataTablePrivate;

#define GDA_DATA_TYPE_DB_RECORD_COLLECTION (gda_data_db_record_collection_get_type ())
#define GDA_DATA_DB_RECORD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD_COLLECTION, GdaDataDbRecordCollection))
#define GDA_DATA_IS_DB_RECORD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD_COLLECTION))
#define GDA_DATA_DB_RECORD_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD_COLLECTION, GdaDataDbRecordCollectionIface))

typedef struct _GdaDataDbRecordCollection GdaDataDbRecordCollection;
typedef struct _GdaDataDbRecordCollectionIface GdaDataDbRecordCollectionIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GdaMetaContext_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdaMetaContext_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GDA_DATA_TYPE_CATALOG (gda_data_catalog_get_type ())
#define GDA_DATA_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_CATALOG, GdaDataCatalog))
#define GDA_DATA_CATALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_CATALOG, GdaDataCatalogClass))
#define GDA_DATA_IS_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_CATALOG))
#define GDA_DATA_IS_CATALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_CATALOG))
#define GDA_DATA_CATALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_CATALOG, GdaDataCatalogClass))

typedef struct _GdaDataCatalog GdaDataCatalog;
typedef struct _GdaDataCatalogClass GdaDataCatalogClass;

#define GDA_DATA_TYPE_SCHEMA (gda_data_schema_get_type ())
#define GDA_DATA_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_SCHEMA, GdaDataSchema))
#define GDA_DATA_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_SCHEMA, GdaDataSchemaClass))
#define GDA_DATA_IS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_SCHEMA))
#define GDA_DATA_IS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_SCHEMA))
#define GDA_DATA_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_SCHEMA, GdaDataSchemaClass))

typedef struct _GdaDataSchema GdaDataSchema;
typedef struct _GdaDataSchemaClass GdaDataSchemaClass;

#define GDA_DATA_TYPE_FIELD_INFO (gda_data_field_info_get_type ())
#define GDA_DATA_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_FIELD_INFO, GdaDataFieldInfo))
#define GDA_DATA_FIELD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_FIELD_INFO, GdaDataFieldInfoClass))
#define GDA_DATA_IS_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_FIELD_INFO))
#define GDA_DATA_IS_FIELD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_FIELD_INFO))
#define GDA_DATA_FIELD_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_FIELD_INFO, GdaDataFieldInfoClass))

typedef struct _GdaDataFieldInfo GdaDataFieldInfo;
typedef struct _GdaDataFieldInfoClass GdaDataFieldInfoClass;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _gda_data_db_field_info_foreign_key_unref0(var) ((var == NULL) ? NULL : (var = (gda_data_db_field_info_foreign_key_unref (var), NULL)))

#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_TYPE_MATCH (gda_data_db_field_info_foreign_key_match_get_type ())

#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_TYPE_RULE (gda_data_db_field_info_foreign_key_rule_get_type ())

#define GDA_DATA_TYPE_RECORD_COLLECTION (gda_data_record_collection_get_type ())
#define GDA_DATA_RECORD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollection))
#define GDA_DATA_RECORD_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollectionClass))
#define GDA_DATA_IS_RECORD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_RECORD_COLLECTION))
#define GDA_DATA_IS_RECORD_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_RECORD_COLLECTION))
#define GDA_DATA_RECORD_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollectionClass))

typedef struct _GdaDataRecordCollection GdaDataRecordCollection;
typedef struct _GdaDataRecordCollectionClass GdaDataRecordCollectionClass;

struct _GdaDataDbObjectIface {
	GTypeInterface parent_iface;
	void (*append) (GdaDataDbObject* self, GError** error);
	void (*update) (GdaDataDbObject* self, GError** error);
	void (*save) (GdaDataDbObject* self, GError** error);
	void (*drop) (GdaDataDbObject* self, gboolean cascade, GError** error);
	GdaConnection* (*get_connection) (GdaDataDbObject* self);
	void (*set_connection) (GdaDataDbObject* self, GdaConnection* value);
	gboolean (*get_update_meta) (GdaDataDbObject* self);
	void (*set_update_meta) (GdaDataDbObject* self, gboolean value);
};

struct _GdaDataDbNamedObjectIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GdaDataDbNamedObject* self);
	void (*set_name) (GdaDataDbNamedObject* self, const gchar* value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY = 1 << 1,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE = 1 << 2,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY = 1 << 3,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK = 1 << 4,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT = 1 << 5,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL = 1 << 6,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT = 1 << 7
} GdaDataDbFieldInfoAttribute;

struct _GdaDataDbFieldInfoIface {
	GTypeInterface parent_iface;
	gint (*get_ordinal) (GdaDataDbFieldInfo* self);
	void (*set_ordinal) (GdaDataDbFieldInfo* self, gint value);
	GType (*get_value_type) (GdaDataDbFieldInfo* self);
	void (*set_value_type) (GdaDataDbFieldInfo* self, GType value);
	GdaDataDbFieldInfoAttribute (*get_attributes) (GdaDataDbFieldInfo* self);
	void (*set_attributes) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
	GValue* (*get_default_value) (GdaDataDbFieldInfo* self);
	void (*set_default_value) (GdaDataDbFieldInfo* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbFieldInfo* self);
	void (*set_name) (GdaDataDbFieldInfo* self, const gchar* value);
	const gchar* (*get_desc) (GdaDataDbFieldInfo* self);
	void (*set_desc) (GdaDataDbFieldInfo* self, const gchar* value);
	gint (*get_precision) (GdaDataDbFieldInfo* self);
	void (*set_precision) (GdaDataDbFieldInfo* self, gint value);
	gint (*get_scale) (GdaDataDbFieldInfo* self);
	void (*set_scale) (GdaDataDbFieldInfo* self, gint value);
	GdaDataDbFieldInfoForeignKey* (*get_fkey) (GdaDataDbFieldInfo* self);
	void (*set_fkey) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
};

struct _GdaDataDbSchemaIface {
	GTypeInterface parent_iface;
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbSchema* self);
	void (*set_catalog) (GdaDataDbSchema* self, GdaDataDbCatalog* value);
	GeeCollection* (*get_tables) (GdaDataDbSchema* self);
};

struct _GdaDataDbCatalogIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_shemas) (GdaDataDbCatalog* self);
	void (*set_shemas) (GdaDataDbCatalog* self, GeeCollection* value);
};

typedef enum  {
	GDA_DATA_DB_TABLE_TABLE_TYPE_NONE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW,
	GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM
} GdaDataDbTableTableType;

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};

struct _GdaDataDbRecordIface {
	GTypeInterface parent_iface;
	GValue* (*get_value) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_field) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_field_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_field) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_key) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_key_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_key) (GdaDataDbRecord* self, const gchar* name, GError** error);
	gchar* (*to_string) (GdaDataDbRecord* self);
	GdaDataDbTable* (*get_table) (GdaDataDbRecord* self);
	void (*set_table) (GdaDataDbRecord* self, GdaDataDbTable* value);
	GeeCollection* (*get_fields) (GdaDataDbRecord* self);
	GeeCollection* (*get_keys) (GdaDataDbRecord* self);
};

struct _GdaDataDbTableIface {
	GTypeInterface parent_iface;
	void (*set_field) (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
	GdaDataDbFieldInfo* (*get_field) (GdaDataDbTable* self, const gchar* name, GError** error);
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbTable* self);
	void (*set_catalog) (GdaDataDbTable* self, GdaDataDbCatalog* value);
	GdaDataDbSchema* (*get_schema) (GdaDataDbTable* self);
	void (*set_schema) (GdaDataDbTable* self, GdaDataDbSchema* value);
	GdaDataDbTableTableType (*get_table_type) (GdaDataDbTable* self);
	void (*set_table_type) (GdaDataDbTable* self, GdaDataDbTableTableType value);
	GeeCollection* (*get_records) (GdaDataDbTable* self);
	GeeCollection* (*get_depends) (GdaDataDbTable* self);
	GeeCollection* (*get_referenced) (GdaDataDbTable* self);
	GeeCollection* (*get_fields) (GdaDataDbTable* self);
	GeeCollection* (*get_primary_keys) (GdaDataDbTable* self);
};

struct _GdaDataDbRecordCollectionIface {
	GTypeInterface parent_iface;
	GdaConnection* (*get_connection) (GdaDataDbRecordCollection* self);
	void (*set_connection) (GdaDataDbRecordCollection* self, GdaConnection* value);
	GdaDataDbTable* (*get_table) (GdaDataDbRecordCollection* self);
};

struct _GdaDataTable {
	GObject parent_instance;
	GdaDataTablePrivate * priv;
	gchar* _name;
	GdaDataDbTableTableType _type;
	GdaDataDbRecordCollection* _records;
	GeeHashMap* _fields;
	GeeHashMap* _depends;
	GeeHashMap* _referenced;
};

struct _GdaDataTableClass {
	GObjectClass parent_class;
};

struct _GdaDataTablePrivate {
	gboolean _read_only;
	gint _n_cols;
	gboolean _update_meta;
	gchar* _original_name;
	GdaConnection* _connection;
	GdaDataDbCatalog* _catalog;
	GdaDataDbSchema* _schema;
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_FULL,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_PARTIAL,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_MATCH_NONE
} GdaDataDbFieldInfoForeignKeyMatch;

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NONE,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_CASCADE,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_NULL,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_RESTRICT,
	GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_NO_ACTION
} GdaDataDbFieldInfoForeignKeyRule;

typedef enum  {
	GDA_DATA_DB_TABLE_ERROR_READ_ONLY,
	GDA_DATA_DB_TABLE_ERROR_FIELD
} GdaDataDbTableError;
#define GDA_DATA_DB_TABLE_ERROR gda_data_db_table_error_quark ()

static gpointer gda_data_table_parent_class = NULL;
static GdaDataDbObjectIface* gda_data_table_gda_data_db_object_parent_iface = NULL;
static GdaDataDbNamedObjectIface* gda_data_table_gda_data_db_named_object_parent_iface = NULL;
static GdaDataDbTableIface* gda_data_table_gda_data_db_table_parent_iface = NULL;

GType gda_data_db_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_named_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_attribute_get_type (void) G_GNUC_CONST;
gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance);
void gda_data_db_field_info_foreign_key_unref (gpointer instance);
GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gda_data_db_field_info_value_set_foreign_key (GValue* value, gpointer v_object);
void gda_data_db_field_info_value_take_foreign_key (GValue* value, gpointer v_object);
gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value);
GType gda_data_db_field_info_foreign_key_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_get_type (void) G_GNUC_CONST;
GType gda_data_db_schema_get_type (void) G_GNUC_CONST;
GType gda_data_db_catalog_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_table_type_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_get_type (void) G_GNUC_CONST;
GType gda_data_table_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_collection_get_type (void) G_GNUC_CONST;
#define GDA_DATA_TABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GDA_DATA_TYPE_TABLE, GdaDataTablePrivate))
enum  {
	GDA_DATA_TABLE_DUMMY_PROPERTY,
	GDA_DATA_TABLE_CONNECTION,
	GDA_DATA_TABLE_UPDATE_META,
	GDA_DATA_TABLE_NAME,
	GDA_DATA_TABLE_TABLE_TYPE,
	GDA_DATA_TABLE_FIELDS,
	GDA_DATA_TABLE_PRIMARY_KEYS,
	GDA_DATA_TABLE_CATALOG,
	GDA_DATA_TABLE_SCHEMA,
	GDA_DATA_TABLE_RECORDS,
	GDA_DATA_TABLE_DEPENDS,
	GDA_DATA_TABLE_REFERENCED
};
GdaDataTable* gda_data_table_new_with_fields_info (GeeHashMap* fields);
GdaDataTable* gda_data_table_construct_with_fields_info (GType object_type, GeeHashMap* fields);
const gchar* gda_data_db_field_info_get_name (GdaDataDbFieldInfo* self);
static void gda_data_table_real_update (GdaDataDbObject* base, GError** error);
gboolean gda_data_db_object_get_update_meta (GdaDataDbObject* self);
const gchar* gda_data_db_named_object_get_name (GdaDataDbNamedObject* self);
GdaConnection* gda_data_db_object_get_connection (GdaDataDbObject* self);
void gda_data_db_object_set_update_meta (GdaDataDbObject* self, gboolean value);
static void _vala_GdaMetaContext_free (GdaMetaContext* self);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
GdaDataDbSchema* gda_data_db_table_get_schema (GdaDataDbTable* self);
GdaDataCatalog* gda_data_catalog_new (void);
GdaDataCatalog* gda_data_catalog_construct (GType object_type);
GType gda_data_catalog_get_type (void) G_GNUC_CONST;
void gda_data_db_table_set_catalog (GdaDataDbTable* self, GdaDataDbCatalog* value);
GdaDataDbCatalog* gda_data_db_table_get_catalog (GdaDataDbTable* self);
void gda_data_db_object_set_connection (GdaDataDbObject* self, GdaConnection* value);
void gda_data_db_named_object_set_name (GdaDataDbNamedObject* self, const gchar* value);
GdaDataSchema* gda_data_schema_new (void);
GdaDataSchema* gda_data_schema_construct (GType object_type);
GType gda_data_schema_get_type (void) G_GNUC_CONST;
void gda_data_db_table_set_schema (GdaDataDbTable* self, GdaDataDbSchema* value);
void gda_data_db_schema_set_catalog (GdaDataDbSchema* self, GdaDataDbCatalog* value);
GdaDataDbCatalog* gda_data_db_schema_get_catalog (GdaDataDbSchema* self);
GdaDataFieldInfo* gda_data_field_info_new (void);
GdaDataFieldInfo* gda_data_field_info_construct (GType object_type);
GType gda_data_field_info_get_type (void) G_GNUC_CONST;
void gda_data_db_field_info_set_name (GdaDataDbFieldInfo* self, const gchar* value);
void gda_data_db_field_info_set_desc (GdaDataDbFieldInfo* self, const gchar* value);
void gda_data_db_field_info_set_ordinal (GdaDataDbFieldInfo* self, gint value);
void gda_data_db_field_info_set_attributes (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
GdaDataDbFieldInfoAttribute gda_data_db_field_info_get_attributes (GdaDataDbFieldInfo* self);
void gda_data_db_field_info_set_value_type (GdaDataDbFieldInfo* self, GType value);
GValue* gda_data_db_field_value_from_string (const gchar* as_string, GType type);
void gda_data_db_field_info_set_default_value (GdaDataDbFieldInfo* self, GValue* value);
GValue* gda_data_db_field_info_get_default_value (GdaDataDbFieldInfo* self);
void gda_data_db_field_info_set_precision (GdaDataDbFieldInfo* self, gint value);
void gda_data_db_field_info_set_scale (GdaDataDbFieldInfo* self, gint value);
GdaDataDbFieldInfoAttribute gda_data_db_field_info_attribute_from_string (const gchar* str);
GdaDataDbFieldInfoForeignKey* gda_data_db_field_info_foreign_key_new (void);
GdaDataDbFieldInfoForeignKey* gda_data_db_field_info_foreign_key_construct (GType object_type);
void gda_data_db_field_info_set_fkey (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
GdaDataDbFieldInfoForeignKey* gda_data_db_field_info_get_fkey (GdaDataDbFieldInfo* self);
void gda_data_db_field_info_foreign_key_set_name (GdaDataDbFieldInfoForeignKey* self, const gchar* value);
void gda_data_db_field_info_foreign_key_set_refname (GdaDataDbFieldInfoForeignKey* self, const gchar* value);
GdaDataTable* gda_data_table_new (void);
GdaDataTable* gda_data_table_construct (GType object_type);
void gda_data_db_field_info_foreign_key_set_reftable (GdaDataDbFieldInfoForeignKey* self, GdaDataDbTable* value);
GdaDataDbTable* gda_data_db_field_info_foreign_key_get_reftable (GdaDataDbFieldInfoForeignKey* self);
GType gda_data_db_field_info_foreign_key_match_get_type (void) G_GNUC_CONST;
GdaDataDbFieldInfoForeignKeyMatch gda_data_db_field_info_foreign_key_match_from_string (const gchar* str);
void gda_data_db_field_info_foreign_key_set_match (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKeyMatch value);
GType gda_data_db_field_info_foreign_key_rule_get_type (void) G_GNUC_CONST;
GdaDataDbFieldInfoForeignKeyRule gda_data_db_field_info_foreign_key_rule_from_string (const gchar* str);
void gda_data_db_field_info_foreign_key_set_update_rule (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKeyRule value);
void gda_data_db_field_info_foreign_key_set_delete_rule (GdaDataDbFieldInfoForeignKey* self, GdaDataDbFieldInfoForeignKeyRule value);
GeeArrayList* gda_data_db_field_info_foreign_key_get_refcol (GdaDataDbFieldInfoForeignKey* self);
static void gda_data_table_real_save (GdaDataDbObject* base, GError** error);
GQuark gda_data_db_table_error_quark (void);
static void gda_data_table_real_append (GdaDataDbObject* base, GError** error);
GdaDataDbTableTableType gda_data_db_table_get_table_type (GdaDataDbTable* self);
GeeCollection* gda_data_db_table_get_fields (GdaDataDbTable* self);
gint gda_data_db_field_info_get_ordinal (GdaDataDbFieldInfo* self);
GType gda_data_db_field_info_get_value_type (GdaDataDbFieldInfo* self);
gchar* gda_data_db_field_info_foreign_key_rule_to_string (GdaDataDbFieldInfoForeignKeyRule r);
GdaDataDbFieldInfoForeignKeyRule gda_data_db_field_info_foreign_key_get_update_rule (GdaDataDbFieldInfoForeignKey* self);
GdaDataDbFieldInfoForeignKeyRule gda_data_db_field_info_foreign_key_get_delete_rule (GdaDataDbFieldInfoForeignKey* self);
static void gda_data_table_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error);
static void gda_data_table_real_set_field (GdaDataDbTable* base, GdaDataDbFieldInfo* field, GError** error);
static GdaDataDbFieldInfo* gda_data_table_real_get_field (GdaDataDbTable* base, const gchar* name, GError** error);
GdaDataRecordCollection* gda_data_record_collection_new (GdaDataModel* m, GdaDataDbTable* table);
GdaDataRecordCollection* gda_data_record_collection_construct (GType object_type, GdaDataModel* m, GdaDataDbTable* table);
GType gda_data_record_collection_get_type (void) G_GNUC_CONST;
static void gda_data_table_finalize (GObject* obj);
GeeCollection* gda_data_db_table_get_primary_keys (GdaDataDbTable* self);
GeeCollection* gda_data_db_table_get_records (GdaDataDbTable* self);
GeeCollection* gda_data_db_table_get_depends (GdaDataDbTable* self);
GeeCollection* gda_data_db_table_get_referenced (GdaDataDbTable* self);
static void _vala_gda_data_table_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gda_data_db_table_set_table_type (GdaDataDbTable* self, GdaDataDbTableTableType value);
static void _vala_gda_data_table_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GdaDataTable* gda_data_table_construct_with_fields_info (GType object_type, GeeHashMap* fields) {
	GdaDataTable * self = NULL;
	g_return_val_if_fail (fields != NULL, NULL);
	self = (GdaDataTable*) g_object_new (object_type, NULL);
	{
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _f_it;
		_tmp0_ = fields;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_f_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			GdaDataDbFieldInfo* f;
			GeeHashMap* _tmp10_;
			GdaDataDbFieldInfo* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			GdaDataDbFieldInfo* _tmp14_;
			_tmp6_ = _f_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _f_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			f = (GdaDataDbFieldInfo*) _tmp9_;
			_tmp10_ = self->_fields;
			_tmp11_ = f;
			_tmp12_ = gda_data_db_field_info_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = f;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp13_, _tmp14_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	return self;
}


GdaDataTable* gda_data_table_new_with_fields_info (GeeHashMap* fields) {
	return gda_data_table_construct_with_fields_info (GDA_DATA_TYPE_TABLE, fields);
}


static void _vala_GdaMetaContext_free (GdaMetaContext* self) {
	g_boxed_free (gda_meta_context_get_type (), self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static void gda_data_table_real_update (GdaDataDbObject* base, GError** error) {
	GdaDataTable * self;
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* cond;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GdaConnection* _tmp25_;
	GdaConnection* _tmp26_;
	GdaMetaStore* _tmp27_ = NULL;
	GdaMetaStore* _tmp28_;
	GdaMetaStore* store;
	GHashFunc _tmp29_;
	GEqualFunc _tmp30_;
	GHashTable* _tmp31_;
	GHashTable* vals;
	GHashTable* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GValue* _tmp36_ = NULL;
	GdaDataDbSchema* _tmp37_;
	GdaDataDbSchema* _tmp38_;
	GHashTable* _tmp111_;
	gchar* _tmp112_;
	GdaDataDbSchema* _tmp113_;
	GdaDataDbSchema* _tmp114_;
	const gchar* _tmp115_;
	const gchar* _tmp116_;
	GValue* _tmp117_ = NULL;
	const gchar* _tmp118_;
	gchar* _tmp119_;
	GdaDataDbCatalog* _tmp120_;
	GdaDataDbCatalog* _tmp121_;
	GdaMetaStore* _tmp133_;
	const gchar* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	GHashTable* _tmp137_;
	GdaDataModel* _tmp138_ = NULL;
	GdaDataModel* _tmp139_;
	GdaDataModel* mt;
	gint r = 0;
	gboolean _tmp277_;
	gboolean _tmp278_;
	gboolean _tmp296_;
	gboolean _tmp297_;
	GdaMetaStore* _tmp315_;
	const gchar* _tmp316_;
	gchar* _tmp317_;
	gchar* _tmp318_;
	GHashTable* _tmp319_;
	GdaDataModel* _tmp320_ = NULL;
	GdaDataModel* _tmp321_;
	GdaDataModel* mc;
	GdaMetaStore* _tmp578_;
	GHashTable* _tmp579_;
	GdaDataModel* _tmp580_ = NULL;
	GdaDataModel* mtr;
	GdaDataModel* _tmp581_;
	gint _tmp582_ = 0;
	GeeHashMap* _tmp607_;
	gint _tmp608_;
	gint _tmp609_;
	GError * _inner_error_ = NULL;
	self = (GdaDataTable*) base;
	_tmp0_ = self->_fields;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	_tmp1_ = g_strdup ("");
	cond = _tmp1_;
	_tmp2_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GdaMetaContext* _tmp4_;
		GdaMetaContext* ctx;
		GdaMetaContext* _tmp5_;
		GdaMetaContext* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GValue _tmp9_ = {0};
		GdaConnection* _tmp10_;
		GdaConnection* _tmp11_;
		_tmp4_ = gda_meta_context_new ();
		ctx = _tmp4_;
		_tmp5_ = ctx;
		gda_meta_context_set_table (_tmp5_, "_columns");
		_tmp6_ = ctx;
		_tmp7_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self);
		_tmp8_ = _tmp7_;
		g_value_init (&_tmp9_, G_TYPE_STRING);
		g_value_set_string (&_tmp9_, _tmp8_);
		_tmp10_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
		_tmp11_ = _tmp10_;
		gda_meta_context_set_column (_tmp6_, "table_name", &_tmp9_, _tmp11_);
		G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
		{
			GdaConnection* _tmp12_;
			GdaConnection* _tmp13_;
			GdaMetaContext* _tmp14_;
			_tmp12_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = ctx;
			gda_connection_update_meta_store (_tmp13_, _tmp14_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			GdaConnection* _tmp21_;
			GdaConnection* _tmp22_;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			_tmp17_ = g_strconcat ("Updating meta store for _columns fails with error: ", _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
			_tmp20_ = _tmp19_;
			g_message ("Table.vala:63: %s", _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			g_message ("Table.vala:64: Trying to update all...");
			_tmp21_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = gda_connection_update_meta_store (_tmp22_, NULL, &_inner_error_);
			_tmp24_ = _tmp23_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (e);
				goto __finally0;
			}
			gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, !_tmp24_);
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			__vala_GdaMetaContext_free0 (ctx);
			_g_free0 (cond);
			return;
		}
		__vala_GdaMetaContext_free0 (ctx);
	}
	_tmp25_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = gda_connection_get_meta_store (_tmp26_);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	store = _tmp28_;
	_tmp29_ = g_str_hash;
	_tmp30_ = g_str_equal;
	_tmp31_ = g_hash_table_new_full (_tmp29_, _tmp30_, _g_free0_, __vala_GValue_free0_);
	vals = _tmp31_;
	_tmp32_ = vals;
	_tmp33_ = g_strdup ("name");
	_tmp34_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_new0 (GValue, 1);
	g_value_init (_tmp36_, G_TYPE_STRING);
	g_value_set_string (_tmp36_, _tmp35_);
	g_hash_table_insert (_tmp32_, _tmp33_, _tmp36_);
	_tmp37_ = gda_data_db_table_get_schema ((GdaDataDbTable*) self);
	_tmp38_ = _tmp37_;
	if (_tmp38_ == NULL) {
		gboolean _tmp39_;
		gboolean _tmp40_;
		GdaMetaStore* _tmp58_;
		GdaDataModel* _tmp59_ = NULL;
		GdaDataModel* catm;
		GdaDataCatalog* _tmp60_;
		GdaDataCatalog* _tmp61_;
		GdaDataDbCatalog* _tmp62_;
		GdaDataDbCatalog* _tmp63_;
		GdaConnection* _tmp64_;
		GdaConnection* _tmp65_;
		GdaDataModel* _tmp66_;
		GdaDataModel* _tmp67_;
		gint _tmp68_ = 0;
		GValue* _tmp69_ = NULL;
		GValue* _tmp70_;
		GdaDataDbCatalog* _tmp71_;
		GdaDataDbCatalog* _tmp72_;
		gboolean _tmp73_;
		gboolean _tmp74_;
		GdaMetaStore* _tmp92_;
		GdaDataModel* _tmp93_ = NULL;
		GdaDataModel* schm;
		GdaDataSchema* _tmp94_;
		GdaDataSchema* _tmp95_;
		GdaDataDbSchema* _tmp96_;
		GdaDataDbSchema* _tmp97_;
		GdaDataDbCatalog* _tmp98_;
		GdaDataDbCatalog* _tmp99_;
		GdaDataDbSchema* _tmp100_;
		GdaDataDbSchema* _tmp101_;
		GdaConnection* _tmp102_;
		GdaConnection* _tmp103_;
		GdaDataModel* _tmp104_;
		GdaDataModel* _tmp105_;
		gint _tmp106_ = 0;
		GValue* _tmp107_ = NULL;
		GValue* _tmp108_;
		GdaDataDbSchema* _tmp109_;
		GdaDataDbSchema* _tmp110_;
		_tmp39_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
		_tmp40_ = _tmp39_;
		if (_tmp40_) {
			{
				GdaMetaContext* _tmp41_;
				GdaMetaContext* cxc;
				GdaMetaContext* _tmp42_;
				GdaConnection* _tmp43_;
				GdaConnection* _tmp44_;
				GdaMetaContext* _tmp45_;
				_tmp41_ = gda_meta_context_new ();
				cxc = _tmp41_;
				_tmp42_ = cxc;
				gda_meta_context_set_table (_tmp42_, "_information_schema_catalog_name");
				_tmp43_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp44_ = _tmp43_;
				_tmp45_ = cxc;
				gda_connection_update_meta_store (_tmp44_, _tmp45_, &_inner_error_);
				if (_inner_error_ != NULL) {
					__vala_GdaMetaContext_free0 (cxc);
					goto __catch1_g_error;
				}
				__vala_GdaMetaContext_free0 (cxc);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp46_;
				const gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				GdaConnection* _tmp52_;
				GdaConnection* _tmp53_;
				gboolean _tmp54_ = FALSE;
				gboolean _tmp55_;
				gboolean _tmp56_;
				gboolean _tmp57_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp46_ = e;
				_tmp47_ = _tmp46_->message;
				_tmp48_ = g_strconcat ("Updating meta store for _information_schema_catalog_name fails with er" \
"ror: ", _tmp47_, NULL);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strconcat (_tmp49_, "\n", NULL);
				_tmp51_ = _tmp50_;
				g_message ("Table.vala:82: %s", _tmp51_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				g_message ("Table.vala:84: Trying to update all...");
				_tmp52_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp53_ = _tmp52_;
				_tmp54_ = gda_connection_update_meta_store (_tmp53_, NULL, &_inner_error_);
				_tmp55_ = _tmp54_;
				if (_inner_error_ != NULL) {
					_g_error_free0 (e);
					goto __finally1;
				}
				gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, !_tmp55_);
				_tmp56_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
				_tmp57_ = _tmp56_;
				if (!_tmp57_) {
					g_message ("Table.vala:87: Meta store update ... Ok");
				}
				_g_error_free0 (e);
			}
			__finally1:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
		}
		_tmp58_ = store;
		_tmp59_ = gda_meta_store_extract_v (_tmp58_, "SELECT * FROM _information_schema_catalog_name", NULL, &_inner_error_);
		catm = _tmp59_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (vals);
			_g_object_unref0 (store);
			_g_free0 (cond);
			return;
		}
		_tmp60_ = gda_data_catalog_new ();
		_tmp61_ = _tmp60_;
		gda_data_db_table_set_catalog ((GdaDataDbTable*) self, (GdaDataDbCatalog*) _tmp61_);
		_g_object_unref0 (_tmp61_);
		_tmp62_ = gda_data_db_table_get_catalog ((GdaDataDbTable*) self);
		_tmp63_ = _tmp62_;
		_tmp64_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
		_tmp65_ = _tmp64_;
		gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp63_, _tmp65_);
		_tmp66_ = catm;
		_tmp67_ = catm;
		_tmp68_ = gda_data_model_get_column_index (_tmp67_, "catalog_name");
		_tmp69_ = gda_data_model_get_value_at (_tmp66_, _tmp68_, 0, &_inner_error_);
		_tmp70_ = _tmp69_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (catm);
			_g_hash_table_unref0 (vals);
			_g_object_unref0 (store);
			_g_free0 (cond);
			return;
		}
		_tmp71_ = gda_data_db_table_get_catalog ((GdaDataDbTable*) self);
		_tmp72_ = _tmp71_;
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp72_, g_value_get_string (_tmp70_));
		_tmp73_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
		_tmp74_ = _tmp73_;
		if (!_tmp74_) {
			{
				GdaMetaContext* _tmp75_;
				GdaMetaContext* cxs;
				GdaMetaContext* _tmp76_;
				GdaConnection* _tmp77_;
				GdaConnection* _tmp78_;
				GdaMetaContext* _tmp79_;
				_tmp75_ = gda_meta_context_new ();
				cxs = _tmp75_;
				_tmp76_ = cxs;
				gda_meta_context_set_table (_tmp76_, "_schemata");
				_tmp77_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp78_ = _tmp77_;
				_tmp79_ = cxs;
				gda_connection_update_meta_store (_tmp78_, _tmp79_, &_inner_error_);
				if (_inner_error_ != NULL) {
					__vala_GdaMetaContext_free0 (cxs);
					goto __catch2_g_error;
				}
				__vala_GdaMetaContext_free0 (cxs);
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GError* _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				GdaConnection* _tmp86_;
				GdaConnection* _tmp87_;
				gboolean _tmp88_ = FALSE;
				gboolean _tmp89_;
				gboolean _tmp90_;
				gboolean _tmp91_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp80_ = e;
				_tmp81_ = _tmp80_->message;
				_tmp82_ = g_strconcat ("Updating meta store for _schemata fails with error: ", _tmp81_, NULL);
				_tmp83_ = _tmp82_;
				_tmp84_ = g_strconcat (_tmp83_, "\n", NULL);
				_tmp85_ = _tmp84_;
				g_message ("Table.vala:101: %s", _tmp85_);
				_g_free0 (_tmp85_);
				_g_free0 (_tmp83_);
				g_message ("Table.vala:102: Trying to update all...");
				_tmp86_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp87_ = _tmp86_;
				_tmp88_ = gda_connection_update_meta_store (_tmp87_, NULL, &_inner_error_);
				_tmp89_ = _tmp88_;
				if (_inner_error_ != NULL) {
					_g_error_free0 (e);
					goto __finally2;
				}
				gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, _tmp89_);
				_tmp90_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					g_message ("Table.vala:105: Meta store update ... Ok");
				}
				_g_error_free0 (e);
			}
			__finally2:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (catm);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
		}
		_tmp92_ = store;
		_tmp93_ = gda_meta_store_extract_v (_tmp92_, "SELECT * FROM _schemata WHERE schema_default = TRUE", NULL, &_inner_error_);
		schm = _tmp93_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (catm);
			_g_hash_table_unref0 (vals);
			_g_object_unref0 (store);
			_g_free0 (cond);
			return;
		}
		_tmp94_ = gda_data_schema_new ();
		_tmp95_ = _tmp94_;
		gda_data_db_table_set_schema ((GdaDataDbTable*) self, (GdaDataDbSchema*) _tmp95_);
		_g_object_unref0 (_tmp95_);
		_tmp96_ = gda_data_db_table_get_schema ((GdaDataDbTable*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = gda_data_db_table_get_catalog ((GdaDataDbTable*) self);
		_tmp99_ = _tmp98_;
		gda_data_db_schema_set_catalog (_tmp97_, _tmp99_);
		_tmp100_ = gda_data_db_table_get_schema ((GdaDataDbTable*) self);
		_tmp101_ = _tmp100_;
		_tmp102_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
		_tmp103_ = _tmp102_;
		gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp101_, _tmp103_);
		_tmp104_ = schm;
		_tmp105_ = schm;
		_tmp106_ = gda_data_model_get_column_index (_tmp105_, "schema_name");
		_tmp107_ = gda_data_model_get_value_at (_tmp104_, _tmp106_, 0, &_inner_error_);
		_tmp108_ = _tmp107_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (schm);
			_g_object_unref0 (catm);
			_g_hash_table_unref0 (vals);
			_g_object_unref0 (store);
			_g_free0 (cond);
			return;
		}
		_tmp109_ = gda_data_db_table_get_schema ((GdaDataDbTable*) self);
		_tmp110_ = _tmp109_;
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp110_, g_value_get_string (_tmp108_));
		_g_object_unref0 (schm);
		_g_object_unref0 (catm);
	}
	_tmp111_ = vals;
	_tmp112_ = g_strdup ("schema");
	_tmp113_ = gda_data_db_table_get_schema ((GdaDataDbTable*) self);
	_tmp114_ = _tmp113_;
	_tmp115_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp114_);
	_tmp116_ = _tmp115_;
	_tmp117_ = g_new0 (GValue, 1);
	g_value_init (_tmp117_, G_TYPE_STRING);
	g_value_set_string (_tmp117_, _tmp116_);
	g_hash_table_insert (_tmp111_, _tmp112_, _tmp117_);
	_tmp118_ = cond;
	_tmp119_ = g_strconcat (_tmp118_, " AND table_schema = ##schema::string", NULL);
	_g_free0 (cond);
	cond = _tmp119_;
	_tmp120_ = gda_data_db_table_get_catalog ((GdaDataDbTable*) self);
	_tmp121_ = _tmp120_;
	if (_tmp121_ != NULL) {
		GHashTable* _tmp122_;
		gchar* _tmp123_;
		GdaDataDbSchema* _tmp124_;
		GdaDataDbSchema* _tmp125_;
		GdaDataDbCatalog* _tmp126_;
		GdaDataDbCatalog* _tmp127_;
		const gchar* _tmp128_;
		const gchar* _tmp129_;
		GValue* _tmp130_ = NULL;
		const gchar* _tmp131_;
		gchar* _tmp132_;
		_tmp122_ = vals;
		_tmp123_ = g_strdup ("catalog");
		_tmp124_ = gda_data_db_table_get_schema ((GdaDataDbTable*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = gda_data_db_schema_get_catalog (_tmp125_);
		_tmp127_ = _tmp126_;
		_tmp128_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp127_);
		_tmp129_ = _tmp128_;
		_tmp130_ = g_new0 (GValue, 1);
		g_value_init (_tmp130_, G_TYPE_STRING);
		g_value_set_string (_tmp130_, _tmp129_);
		g_hash_table_insert (_tmp122_, _tmp123_, _tmp130_);
		_tmp131_ = cond;
		_tmp132_ = g_strconcat (_tmp131_, " AND table_catalog = ##catalog::string", NULL);
		_g_free0 (cond);
		cond = _tmp132_;
	}
	_tmp133_ = store;
	_tmp134_ = cond;
	_tmp135_ = g_strconcat ("SELECT * FROM _columns" " WHERE table_name  = ##name::string", _tmp134_, NULL);
	_tmp136_ = _tmp135_;
	_tmp137_ = vals;
	_tmp138_ = gda_meta_store_extract_v (_tmp133_, _tmp136_, _tmp137_, &_inner_error_);
	_tmp139_ = _tmp138_;
	_g_free0 (_tmp136_);
	mt = _tmp139_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (vals);
		_g_object_unref0 (store);
		_g_free0 (cond);
		return;
	}
	{
		gboolean _tmp140_;
		r = 0;
		_tmp140_ = TRUE;
		while (TRUE) {
			gboolean _tmp141_;
			gint _tmp143_;
			GdaDataModel* _tmp144_;
			gint _tmp145_ = 0;
			GdaDataFieldInfo* _tmp146_;
			GdaDataFieldInfo* fi;
			GdaDataModel* _tmp147_;
			GdaDataModel* _tmp148_;
			gint _tmp149_ = 0;
			gint _tmp150_;
			GValue* _tmp151_ = NULL;
			GValue* _tmp152_;
			GdaDataFieldInfo* _tmp153_;
			GdaDataModel* _tmp154_;
			GdaDataModel* _tmp155_;
			gint _tmp156_ = 0;
			gint _tmp157_;
			GValue* _tmp158_ = NULL;
			GValue _tmp159_ = {0};
			GValue v;
			gboolean _tmp160_ = FALSE;
			GdaDataModel* _tmp164_;
			GdaDataModel* _tmp165_;
			gint _tmp166_ = 0;
			gint _tmp167_;
			GValue* _tmp168_ = NULL;
			GValue* _tmp169_;
			GdaDataFieldInfo* _tmp170_;
			GdaDataFieldInfo* _tmp171_;
			GdaDataModel* _tmp172_;
			GdaDataModel* _tmp173_;
			gint _tmp174_ = 0;
			gint _tmp175_;
			GValue* _tmp176_ = NULL;
			GValue* _tmp177_;
			gboolean fcbn;
			gboolean _tmp178_;
			gchar* fai = NULL;
			GdaDataModel* _tmp183_;
			GdaDataModel* _tmp184_;
			gint _tmp185_ = 0;
			gint _tmp186_;
			GValue* _tmp187_ = NULL;
			GValue* _tmp188_;
			GValue _tmp189_ = {0};
			gboolean _tmp190_ = FALSE;
			const gchar* _tmp194_;
			gchar* fdv = NULL;
			GdaDataModel* _tmp199_;
			GdaDataModel* _tmp200_;
			gint _tmp201_ = 0;
			gint _tmp202_;
			GValue* _tmp203_ = NULL;
			GValue* _tmp204_;
			GValue _tmp205_ = {0};
			gboolean _tmp206_ = FALSE;
			GdaDataModel* _tmp210_;
			GdaDataModel* _tmp211_;
			gint _tmp212_ = 0;
			gint _tmp213_;
			GValue* _tmp214_ = NULL;
			GValue* _tmp215_;
			GType _tmp216_ = 0UL;
			GType ft;
			GdaDataFieldInfo* _tmp217_;
			GType _tmp218_;
			const gchar* _tmp219_;
			GType _tmp229_;
			GType _tmp246_;
			GType _tmp263_;
			GeeHashMap* _tmp272_;
			GdaDataFieldInfo* _tmp273_;
			const gchar* _tmp274_;
			const gchar* _tmp275_;
			GdaDataFieldInfo* _tmp276_;
			_tmp141_ = _tmp140_;
			if (!_tmp141_) {
				gint _tmp142_;
				_tmp142_ = r;
				r = _tmp142_ + 1;
			}
			_tmp140_ = FALSE;
			_tmp143_ = r;
			_tmp144_ = mt;
			_tmp145_ = gda_data_model_get_n_rows (_tmp144_);
			if (!(_tmp143_ < _tmp145_)) {
				break;
			}
			_tmp146_ = gda_data_field_info_new ();
			fi = _tmp146_;
			_tmp147_ = mt;
			_tmp148_ = mt;
			_tmp149_ = gda_data_model_get_column_index (_tmp148_, "column_name");
			_tmp150_ = r;
			_tmp151_ = gda_data_model_get_value_at (_tmp147_, _tmp149_, _tmp150_, &_inner_error_);
			_tmp152_ = _tmp151_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (fi);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			_tmp153_ = fi;
			gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp153_, g_value_get_string (_tmp152_));
			_tmp154_ = mt;
			_tmp155_ = mt;
			_tmp156_ = gda_data_model_get_column_index (_tmp155_, "column_comments");
			_tmp157_ = r;
			_tmp158_ = gda_data_model_get_value_at (_tmp154_, _tmp156_, _tmp157_, &_inner_error_);
			if (G_IS_VALUE (_tmp158_)) {
				g_value_init (&_tmp159_, G_VALUE_TYPE (_tmp158_));
				g_value_copy (_tmp158_, &_tmp159_);
			} else {
				_tmp159_ = *_tmp158_;
			}
			v = _tmp159_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (fi);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			_tmp160_ = G_VALUE_HOLDS (&v, G_TYPE_STRING);
			if (_tmp160_) {
				GdaDataFieldInfo* _tmp161_;
				GValue _tmp162_;
				_tmp161_ = fi;
				_tmp162_ = v;
				gda_data_db_field_info_set_desc ((GdaDataDbFieldInfo*) _tmp161_, g_value_get_string (&_tmp162_));
			} else {
				GdaDataFieldInfo* _tmp163_;
				_tmp163_ = fi;
				gda_data_db_field_info_set_desc ((GdaDataDbFieldInfo*) _tmp163_, "");
			}
			_tmp164_ = mt;
			_tmp165_ = mt;
			_tmp166_ = gda_data_model_get_column_index (_tmp165_, "ordinal_position");
			_tmp167_ = r;
			_tmp168_ = gda_data_model_get_value_at (_tmp164_, _tmp166_, _tmp167_, &_inner_error_);
			_tmp169_ = _tmp168_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (fi);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			_tmp170_ = fi;
			gda_data_db_field_info_set_ordinal ((GdaDataDbFieldInfo*) _tmp170_, g_value_get_int (_tmp169_));
			_tmp171_ = fi;
			gda_data_db_field_info_set_attributes ((GdaDataDbFieldInfo*) _tmp171_, GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE);
			_tmp172_ = mt;
			_tmp173_ = mt;
			_tmp174_ = gda_data_model_get_column_index (_tmp173_, "is_nullable");
			_tmp175_ = r;
			_tmp176_ = gda_data_model_get_value_at (_tmp172_, _tmp174_, _tmp175_, &_inner_error_);
			_tmp177_ = _tmp176_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (fi);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			fcbn = g_value_get_boolean (_tmp177_);
			_tmp178_ = fcbn;
			if (_tmp178_) {
				GdaDataFieldInfo* _tmp179_;
				GdaDataFieldInfo* _tmp180_;
				GdaDataDbFieldInfoAttribute _tmp181_;
				GdaDataDbFieldInfoAttribute _tmp182_;
				_tmp179_ = fi;
				_tmp180_ = fi;
				_tmp181_ = gda_data_db_field_info_get_attributes ((GdaDataDbFieldInfo*) _tmp180_);
				_tmp182_ = _tmp181_;
				gda_data_db_field_info_set_attributes ((GdaDataDbFieldInfo*) _tmp179_, _tmp182_ | GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL);
			}
			_tmp183_ = mt;
			_tmp184_ = mt;
			_tmp185_ = gda_data_model_get_column_index (_tmp184_, "extra");
			_tmp186_ = r;
			_tmp187_ = gda_data_model_get_value_at (_tmp183_, _tmp185_, _tmp186_, &_inner_error_);
			_tmp188_ = _tmp187_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (fai);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (fi);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			if (G_IS_VALUE (_tmp188_)) {
				g_value_init (&_tmp189_, G_VALUE_TYPE (_tmp188_));
				g_value_copy (_tmp188_, &_tmp189_);
			} else {
				_tmp189_ = *_tmp188_;
			}
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			v = _tmp189_;
			_tmp190_ = G_VALUE_HOLDS (&v, G_TYPE_STRING);
			if (_tmp190_) {
				GValue _tmp191_;
				gchar* _tmp192_;
				_tmp191_ = v;
				_tmp192_ = g_strdup (g_value_get_string (&_tmp191_));
				_g_free0 (fai);
				fai = _tmp192_;
			} else {
				gchar* _tmp193_;
				_tmp193_ = g_strdup ("");
				_g_free0 (fai);
				fai = _tmp193_;
			}
			_tmp194_ = fai;
			if (g_strcmp0 (_tmp194_, "AUTO_INCREMENT") == 0) {
				GdaDataFieldInfo* _tmp195_;
				GdaDataFieldInfo* _tmp196_;
				GdaDataDbFieldInfoAttribute _tmp197_;
				GdaDataDbFieldInfoAttribute _tmp198_;
				_tmp195_ = fi;
				_tmp196_ = fi;
				_tmp197_ = gda_data_db_field_info_get_attributes ((GdaDataDbFieldInfo*) _tmp196_);
				_tmp198_ = _tmp197_;
				gda_data_db_field_info_set_attributes ((GdaDataDbFieldInfo*) _tmp195_, _tmp198_ | GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT);
			}
			_tmp199_ = mt;
			_tmp200_ = mt;
			_tmp201_ = gda_data_model_get_column_index (_tmp200_, "column_default");
			_tmp202_ = r;
			_tmp203_ = gda_data_model_get_value_at (_tmp199_, _tmp201_, _tmp202_, &_inner_error_);
			_tmp204_ = _tmp203_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (fdv);
				_g_free0 (fai);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (fi);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			if (G_IS_VALUE (_tmp204_)) {
				g_value_init (&_tmp205_, G_VALUE_TYPE (_tmp204_));
				g_value_copy (_tmp204_, &_tmp205_);
			} else {
				_tmp205_ = *_tmp204_;
			}
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			v = _tmp205_;
			_tmp206_ = G_VALUE_HOLDS (&v, G_TYPE_STRING);
			if (_tmp206_) {
				GValue _tmp207_;
				gchar* _tmp208_;
				_tmp207_ = v;
				_tmp208_ = g_strdup (g_value_get_string (&_tmp207_));
				_g_free0 (fdv);
				fdv = _tmp208_;
			} else {
				gchar* _tmp209_;
				_tmp209_ = g_strdup ("");
				_g_free0 (fdv);
				fdv = _tmp209_;
			}
			_tmp210_ = mt;
			_tmp211_ = mt;
			_tmp212_ = gda_data_model_get_column_index (_tmp211_, "gtype");
			_tmp213_ = r;
			_tmp214_ = gda_data_model_get_value_at (_tmp210_, _tmp212_, _tmp213_, &_inner_error_);
			_tmp215_ = _tmp214_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (fdv);
				_g_free0 (fai);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (fi);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			_tmp216_ = gda_g_type_from_string (g_value_get_string (_tmp215_));
			ft = _tmp216_;
			_tmp217_ = fi;
			_tmp218_ = ft;
			gda_data_db_field_info_set_value_type ((GdaDataDbFieldInfo*) _tmp217_, _tmp218_);
			_tmp219_ = fdv;
			if (_tmp219_ != NULL) {
				GdaDataFieldInfo* _tmp220_;
				GdaDataFieldInfo* _tmp221_;
				GdaDataDbFieldInfoAttribute _tmp222_;
				GdaDataDbFieldInfoAttribute _tmp223_;
				GdaDataFieldInfo* _tmp224_;
				const gchar* _tmp225_;
				GType _tmp226_;
				GValue* _tmp227_ = NULL;
				GValue* _tmp228_;
				_tmp220_ = fi;
				_tmp221_ = fi;
				_tmp222_ = gda_data_db_field_info_get_attributes ((GdaDataDbFieldInfo*) _tmp221_);
				_tmp223_ = _tmp222_;
				gda_data_db_field_info_set_attributes ((GdaDataDbFieldInfo*) _tmp220_, _tmp223_ | GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT);
				_tmp224_ = fi;
				_tmp225_ = fdv;
				_tmp226_ = ft;
				_tmp227_ = gda_data_db_field_value_from_string (_tmp225_, _tmp226_);
				_tmp228_ = _tmp227_;
				gda_data_db_field_info_set_default_value ((GdaDataDbFieldInfo*) _tmp224_, _tmp228_);
				__vala_GValue_free0 (_tmp228_);
			}
			_tmp229_ = ft;
			if (_tmp229_ == G_TYPE_STRING) {
				GdaConnection* _tmp230_;
				GdaConnection* _tmp231_;
				GdaServerProvider* _tmp232_ = NULL;
				GdaConnection* _tmp233_;
				GdaConnection* _tmp234_;
				GdaDataHandler* _tmp235_ = NULL;
				GdaDataHandler* _tmp236_;
				GdaDataHandler* hld;
				GdaDataHandler* _tmp237_;
				GdaDataFieldInfo* _tmp238_;
				GValue* _tmp239_;
				GValue* _tmp240_;
				GValue* _tmp241_ = NULL;
				GValue _tmp242_ = {0};
				GValue strv;
				GdaDataFieldInfo* _tmp243_;
				GValue _tmp244_;
				GValue* _tmp245_ = NULL;
				_tmp230_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp231_ = _tmp230_;
				_tmp232_ = gda_connection_get_provider (_tmp231_);
				_tmp233_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp234_ = _tmp233_;
				_tmp235_ = gda_server_provider_get_data_handler_g_type (_tmp232_, _tmp234_, G_TYPE_STRING);
				_tmp236_ = _g_object_ref0 (_tmp235_);
				hld = _tmp236_;
				_tmp237_ = hld;
				_tmp238_ = fi;
				_tmp239_ = gda_data_db_field_info_get_default_value ((GdaDataDbFieldInfo*) _tmp238_);
				_tmp240_ = _tmp239_;
				_tmp241_ = gda_data_handler_get_value_from_sql (_tmp237_, g_value_get_string (_tmp240_), G_TYPE_STRING);
				g_value_init (&_tmp242_, G_TYPE_STRING);
				g_value_take_string (&_tmp242_, g_value_get_string (_tmp241_));
				strv = _tmp242_;
				_tmp243_ = fi;
				_tmp244_ = strv;
				_tmp245_ = g_new0 (GValue, 1);
				g_value_init (_tmp245_, G_TYPE_STRING);
				g_value_set_string (_tmp245_, g_value_get_string (&_tmp244_));
				gda_data_db_field_info_set_default_value ((GdaDataDbFieldInfo*) _tmp243_, _tmp245_);
				__vala_GValue_free0 (_tmp245_);
				G_IS_VALUE (&strv) ? (g_value_unset (&strv), NULL) : NULL;
				_g_object_unref0 (hld);
			}
			_tmp246_ = ft;
			if (_tmp246_ == gda_numeric_get_type ()) {
				GdaDataModel* _tmp247_;
				GdaDataModel* _tmp248_;
				gint _tmp249_ = 0;
				gint _tmp250_;
				GValue* _tmp251_ = NULL;
				GValue* _tmp252_;
				gint fp;
				GdaDataModel* _tmp253_;
				GdaDataModel* _tmp254_;
				gint _tmp255_ = 0;
				gint _tmp256_;
				GValue* _tmp257_ = NULL;
				GValue* _tmp258_;
				gint fs;
				GdaDataFieldInfo* _tmp259_;
				gint _tmp260_;
				GdaDataFieldInfo* _tmp261_;
				gint _tmp262_;
				_tmp247_ = mt;
				_tmp248_ = mt;
				_tmp249_ = gda_data_model_get_column_index (_tmp248_, "numeric_precision");
				_tmp250_ = r;
				_tmp251_ = gda_data_model_get_value_at (_tmp247_, _tmp249_, _tmp250_, &_inner_error_);
				_tmp252_ = _tmp251_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (fdv);
					_g_free0 (fai);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					_g_object_unref0 (fi);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				fp = g_value_get_int (_tmp252_);
				_tmp253_ = mt;
				_tmp254_ = mt;
				_tmp255_ = gda_data_model_get_column_index (_tmp254_, "numeric_scale");
				_tmp256_ = r;
				_tmp257_ = gda_data_model_get_value_at (_tmp253_, _tmp255_, _tmp256_, &_inner_error_);
				_tmp258_ = _tmp257_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (fdv);
					_g_free0 (fai);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					_g_object_unref0 (fi);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				fs = g_value_get_int (_tmp258_);
				_tmp259_ = fi;
				_tmp260_ = fp;
				gda_data_db_field_info_set_precision ((GdaDataDbFieldInfo*) _tmp259_, _tmp260_);
				_tmp261_ = fi;
				_tmp262_ = fs;
				gda_data_db_field_info_set_scale ((GdaDataDbFieldInfo*) _tmp261_, _tmp262_);
			}
			_tmp263_ = ft;
			if (_tmp263_ == G_TYPE_DATE) {
				GdaDataModel* _tmp264_;
				GdaDataModel* _tmp265_;
				gint _tmp266_ = 0;
				gint _tmp267_;
				GValue* _tmp268_ = NULL;
				GValue* _tmp269_;
				gint fp;
				GdaDataFieldInfo* _tmp270_;
				gint _tmp271_;
				_tmp264_ = mt;
				_tmp265_ = mt;
				_tmp266_ = gda_data_model_get_column_index (_tmp265_, "numeric_precision");
				_tmp267_ = r;
				_tmp268_ = gda_data_model_get_value_at (_tmp264_, _tmp266_, _tmp267_, &_inner_error_);
				_tmp269_ = _tmp268_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (fdv);
					_g_free0 (fai);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					_g_object_unref0 (fi);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				fp = g_value_get_int (_tmp269_);
				_tmp270_ = fi;
				_tmp271_ = fp;
				gda_data_db_field_info_set_precision ((GdaDataDbFieldInfo*) _tmp270_, _tmp271_);
			}
			_tmp272_ = self->_fields;
			_tmp273_ = fi;
			_tmp274_ = gda_data_db_field_info_get_name ((GdaDataDbFieldInfo*) _tmp273_);
			_tmp275_ = _tmp274_;
			_tmp276_ = fi;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp272_, _tmp275_, (GdaDataDbFieldInfo*) _tmp276_);
			_g_free0 (fdv);
			_g_free0 (fai);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			_g_object_unref0 (fi);
		}
	}
	_tmp277_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
	_tmp278_ = _tmp277_;
	if (!_tmp278_) {
		{
			GdaMetaContext* _tmp279_;
			GdaMetaContext* cxcr;
			GdaMetaContext* _tmp280_;
			GdaConnection* _tmp281_;
			GdaConnection* _tmp282_;
			GdaMetaContext* _tmp283_;
			_tmp279_ = gda_meta_context_new ();
			cxcr = _tmp279_;
			_tmp280_ = cxcr;
			gda_meta_context_set_table (_tmp280_, "_table_constraints");
			_tmp281_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp282_ = _tmp281_;
			_tmp283_ = cxcr;
			gda_connection_update_meta_store (_tmp282_, _tmp283_, &_inner_error_);
			if (_inner_error_ != NULL) {
				__vala_GdaMetaContext_free0 (cxcr);
				goto __catch3_g_error;
			}
			__vala_GdaMetaContext_free0 (cxcr);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			GError* _tmp284_;
			const gchar* _tmp285_;
			gchar* _tmp286_;
			gchar* _tmp287_;
			gchar* _tmp288_;
			gchar* _tmp289_;
			GdaConnection* _tmp290_;
			GdaConnection* _tmp291_;
			gboolean _tmp292_ = FALSE;
			gboolean _tmp293_;
			gboolean _tmp294_;
			gboolean _tmp295_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp284_ = e;
			_tmp285_ = _tmp284_->message;
			_tmp286_ = g_strconcat ("Updating meta store for _table_constraints usage fails with error: ", _tmp285_, NULL);
			_tmp287_ = _tmp286_;
			_tmp288_ = g_strconcat (_tmp287_, "\n", NULL);
			_tmp289_ = _tmp288_;
			g_message ("Table.vala:191: %s", _tmp289_);
			_g_free0 (_tmp289_);
			_g_free0 (_tmp287_);
			g_message ("Table.vala:193: Trying to update all...");
			_tmp290_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp291_ = _tmp290_;
			_tmp292_ = gda_connection_update_meta_store (_tmp291_, NULL, &_inner_error_);
			_tmp293_ = _tmp292_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (e);
				goto __finally3;
			}
			gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, _tmp293_);
			_tmp294_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
			_tmp295_ = _tmp294_;
			if (_tmp295_) {
				g_message ("Table.vala:196: Meta store update ... Ok");
			}
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (mt);
			_g_hash_table_unref0 (vals);
			_g_object_unref0 (store);
			_g_free0 (cond);
			return;
		}
	}
	_tmp296_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
	_tmp297_ = _tmp296_;
	if (!_tmp297_) {
		{
			GdaMetaContext* _tmp298_;
			GdaMetaContext* cxcr2;
			GdaMetaContext* _tmp299_;
			GdaConnection* _tmp300_;
			GdaConnection* _tmp301_;
			GdaMetaContext* _tmp302_;
			_tmp298_ = gda_meta_context_new ();
			cxcr2 = _tmp298_;
			_tmp299_ = cxcr2;
			gda_meta_context_set_table (_tmp299_, "_key_column_usage");
			_tmp300_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp301_ = _tmp300_;
			_tmp302_ = cxcr2;
			gda_connection_update_meta_store (_tmp301_, _tmp302_, &_inner_error_);
			if (_inner_error_ != NULL) {
				__vala_GdaMetaContext_free0 (cxcr2);
				goto __catch4_g_error;
			}
			__vala_GdaMetaContext_free0 (cxcr2);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp303_;
			const gchar* _tmp304_;
			gchar* _tmp305_;
			gchar* _tmp306_;
			gchar* _tmp307_;
			gchar* _tmp308_;
			GdaConnection* _tmp309_;
			GdaConnection* _tmp310_;
			gboolean _tmp311_ = FALSE;
			gboolean _tmp312_;
			gboolean _tmp313_;
			gboolean _tmp314_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp303_ = e;
			_tmp304_ = _tmp303_->message;
			_tmp305_ = g_strconcat ("Updating meta store for _key_column_usage usage fails with error: ", _tmp304_, NULL);
			_tmp306_ = _tmp305_;
			_tmp307_ = g_strconcat (_tmp306_, "\n", NULL);
			_tmp308_ = _tmp307_;
			g_message ("Table.vala:206: %s", _tmp308_);
			_g_free0 (_tmp308_);
			_g_free0 (_tmp306_);
			g_message ("Table.vala:208: Trying to update all...");
			_tmp309_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp310_ = _tmp309_;
			_tmp311_ = gda_connection_update_meta_store (_tmp310_, NULL, &_inner_error_);
			_tmp312_ = _tmp311_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (e);
				goto __finally4;
			}
			gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, _tmp312_);
			_tmp313_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
			_tmp314_ = _tmp313_;
			if (_tmp314_) {
				g_message ("Table.vala:211: Meta store update ... Ok");
			}
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (mt);
			_g_hash_table_unref0 (vals);
			_g_object_unref0 (store);
			_g_free0 (cond);
			return;
		}
	}
	_tmp315_ = store;
	_tmp316_ = cond;
	_tmp317_ = g_strconcat ("SELECT * FROM _table_constraints" " WHERE table_name  = ##name::string", _tmp316_, NULL);
	_tmp318_ = _tmp317_;
	_tmp319_ = vals;
	_tmp320_ = gda_meta_store_extract_v (_tmp315_, _tmp318_, _tmp319_, &_inner_error_);
	_tmp321_ = _tmp320_;
	_g_free0 (_tmp318_);
	mc = _tmp321_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (mt);
		_g_hash_table_unref0 (vals);
		_g_object_unref0 (store);
		_g_free0 (cond);
		return;
	}
	{
		gboolean _tmp322_;
		r = 0;
		_tmp322_ = TRUE;
		while (TRUE) {
			gboolean _tmp323_;
			gint _tmp325_;
			GdaDataModel* _tmp326_;
			gint _tmp327_ = 0;
			GdaDataModel* _tmp328_;
			GdaDataModel* _tmp329_;
			gint _tmp330_ = 0;
			gint _tmp331_;
			GValue* _tmp332_ = NULL;
			GValue* _tmp333_;
			gchar* _tmp334_;
			gchar* ct;
			GdaDataModel* _tmp335_;
			GdaDataModel* _tmp336_;
			gint _tmp337_ = 0;
			gint _tmp338_;
			GValue* _tmp339_ = NULL;
			GValue* _tmp340_;
			gchar* _tmp341_;
			gchar* cn;
			GHashTable* _tmp342_;
			gchar* _tmp343_;
			const gchar* _tmp344_;
			GValue* _tmp345_ = NULL;
			GdaMetaStore* _tmp346_;
			const gchar* _tmp347_;
			gchar* _tmp348_;
			gchar* _tmp349_;
			GHashTable* _tmp350_;
			GdaDataModel* _tmp351_ = NULL;
			GdaDataModel* _tmp352_;
			GdaDataModel* mpk;
			GdaDataModel* _tmp353_;
			gint _tmp354_ = 0;
			GdaDataModel* _tmp365_;
			GdaDataModel* _tmp366_;
			gint _tmp367_ = 0;
			GValue* _tmp368_ = NULL;
			GValue* _tmp369_;
			gchar* _tmp370_;
			gchar* colname;
			GeeHashMap* _tmp371_;
			const gchar* _tmp372_;
			gpointer _tmp373_ = NULL;
			GdaDataDbFieldInfo* f;
			GdaDataDbFieldInfo* _tmp374_;
			GdaDataDbFieldInfo* _tmp375_;
			GdaDataDbFieldInfoAttribute _tmp376_;
			GdaDataDbFieldInfoAttribute _tmp377_;
			const gchar* _tmp378_;
			GdaDataDbFieldInfoAttribute _tmp379_ = 0;
			GdaDataDbFieldInfo* _tmp380_;
			GdaDataDbFieldInfoAttribute _tmp381_;
			GdaDataDbFieldInfoAttribute _tmp382_;
			GdaDataDbFieldInfo* _tmp570_;
			GdaDataDbFieldInfoAttribute _tmp571_;
			GdaDataDbFieldInfoAttribute _tmp572_;
			GeeHashMap* _tmp573_;
			GdaDataDbFieldInfo* _tmp574_;
			const gchar* _tmp575_;
			const gchar* _tmp576_;
			GdaDataDbFieldInfo* _tmp577_;
			_tmp323_ = _tmp322_;
			if (!_tmp323_) {
				gint _tmp324_;
				_tmp324_ = r;
				r = _tmp324_ + 1;
			}
			_tmp322_ = FALSE;
			_tmp325_ = r;
			_tmp326_ = mc;
			_tmp327_ = gda_data_model_get_n_rows (_tmp326_);
			if (!(_tmp325_ < _tmp327_)) {
				break;
			}
			_tmp328_ = mc;
			_tmp329_ = mc;
			_tmp330_ = gda_data_model_get_column_index (_tmp329_, "constraint_type");
			_tmp331_ = r;
			_tmp332_ = gda_data_model_get_value_at (_tmp328_, _tmp330_, _tmp331_, &_inner_error_);
			_tmp333_ = _tmp332_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (mc);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			_tmp334_ = g_strdup (g_value_get_string (_tmp333_));
			ct = _tmp334_;
			_tmp335_ = mc;
			_tmp336_ = mc;
			_tmp337_ = gda_data_model_get_column_index (_tmp336_, "constraint_name");
			_tmp338_ = r;
			_tmp339_ = gda_data_model_get_value_at (_tmp335_, _tmp337_, _tmp338_, &_inner_error_);
			_tmp340_ = _tmp339_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ct);
				_g_object_unref0 (mc);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			_tmp341_ = g_strdup (g_value_get_string (_tmp340_));
			cn = _tmp341_;
			_tmp342_ = vals;
			_tmp343_ = g_strdup ("constraint_name");
			_tmp344_ = cn;
			_tmp345_ = g_new0 (GValue, 1);
			g_value_init (_tmp345_, G_TYPE_STRING);
			g_value_set_string (_tmp345_, _tmp344_);
			g_hash_table_insert (_tmp342_, _tmp343_, _tmp345_);
			_tmp346_ = store;
			_tmp347_ = cond;
			_tmp348_ = g_strconcat ("SELECT * FROM _key_column_usage" " WHERE table_name  = ##name::string" " AND constraint_name = ##constraint_name::string", _tmp347_, NULL);
			_tmp349_ = _tmp348_;
			_tmp350_ = vals;
			_tmp351_ = gda_meta_store_extract_v (_tmp346_, _tmp349_, _tmp350_, &_inner_error_);
			_tmp352_ = _tmp351_;
			_g_free0 (_tmp349_);
			mpk = _tmp352_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (cn);
				_g_free0 (ct);
				_g_object_unref0 (mc);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			_tmp353_ = mpk;
			_tmp354_ = gda_data_model_get_n_rows (_tmp353_);
			if (_tmp354_ != 1) {
				const gchar* _tmp355_;
				gchar* _tmp356_;
				gchar* _tmp357_;
				gchar* _tmp358_;
				gchar* _tmp359_;
				const gchar* _tmp360_;
				gchar* _tmp361_;
				gchar* _tmp362_;
				gchar* _tmp363_;
				gchar* _tmp364_;
				_tmp355_ = cn;
				_tmp356_ = g_strconcat ("Constraint '", _tmp355_, NULL);
				_tmp357_ = _tmp356_;
				_tmp358_ = g_strconcat (_tmp357_, "' type '", NULL);
				_tmp359_ = _tmp358_;
				_tmp360_ = ct;
				_tmp361_ = g_strconcat (_tmp359_, _tmp360_, NULL);
				_tmp362_ = _tmp361_;
				_tmp363_ = g_strconcat (_tmp362_, "' not found. Skipped!", NULL);
				_tmp364_ = _tmp363_;
				g_warning ("Table.vala:226: %s", _tmp364_);
				_g_free0 (_tmp364_);
				_g_free0 (_tmp362_);
				_g_free0 (_tmp359_);
				_g_free0 (_tmp357_);
				_g_object_unref0 (mpk);
				_g_free0 (cn);
				_g_free0 (ct);
				continue;
			}
			_tmp365_ = mpk;
			_tmp366_ = mpk;
			_tmp367_ = gda_data_model_get_column_index (_tmp366_, "column_name");
			_tmp368_ = gda_data_model_get_value_at (_tmp365_, _tmp367_, 0, &_inner_error_);
			_tmp369_ = _tmp368_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (mpk);
				_g_free0 (cn);
				_g_free0 (ct);
				_g_object_unref0 (mc);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			_tmp370_ = g_strdup (g_value_get_string (_tmp369_));
			colname = _tmp370_;
			_tmp371_ = self->_fields;
			_tmp372_ = colname;
			_tmp373_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp371_, _tmp372_);
			f = (GdaDataDbFieldInfo*) _tmp373_;
			_tmp374_ = f;
			_tmp375_ = f;
			_tmp376_ = gda_data_db_field_info_get_attributes (_tmp375_);
			_tmp377_ = _tmp376_;
			_tmp378_ = ct;
			_tmp379_ = gda_data_db_field_info_attribute_from_string (_tmp378_);
			gda_data_db_field_info_set_attributes (_tmp374_, _tmp377_ | _tmp379_);
			_tmp380_ = f;
			_tmp381_ = gda_data_db_field_info_get_attributes (_tmp380_);
			_tmp382_ = _tmp381_;
			if ((_tmp382_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY) {
				gboolean _tmp383_;
				gboolean _tmp384_;
				GdaMetaStore* _tmp402_;
				const gchar* _tmp403_;
				gchar* _tmp404_;
				gchar* _tmp405_;
				GHashTable* _tmp406_;
				GdaDataModel* _tmp407_ = NULL;
				GdaDataModel* _tmp408_;
				GdaDataModel* mfk;
				GdaDataDbFieldInfo* _tmp409_;
				GdaDataDbFieldInfoForeignKey* _tmp410_;
				GdaDataDbFieldInfoForeignKey* _tmp411_;
				GdaDataDbFieldInfo* _tmp412_;
				GdaDataDbFieldInfoForeignKey* _tmp413_;
				GdaDataDbFieldInfoForeignKey* _tmp414_;
				const gchar* _tmp415_;
				GdaDataModel* _tmp416_;
				GdaDataModel* _tmp417_;
				gint _tmp418_ = 0;
				GValue* _tmp419_ = NULL;
				GValue* _tmp420_;
				GdaDataDbFieldInfo* _tmp421_;
				GdaDataDbFieldInfoForeignKey* _tmp422_;
				GdaDataDbFieldInfoForeignKey* _tmp423_;
				GdaDataDbFieldInfo* _tmp424_;
				GdaDataDbFieldInfoForeignKey* _tmp425_;
				GdaDataDbFieldInfoForeignKey* _tmp426_;
				GdaDataTable* _tmp427_;
				GdaDataTable* _tmp428_;
				GdaDataDbFieldInfo* _tmp429_;
				GdaDataDbFieldInfoForeignKey* _tmp430_;
				GdaDataDbFieldInfoForeignKey* _tmp431_;
				GdaDataDbTable* _tmp432_;
				GdaDataDbTable* _tmp433_;
				GdaConnection* _tmp434_;
				GdaConnection* _tmp435_;
				GdaDataModel* _tmp436_;
				GdaDataModel* _tmp437_;
				gint _tmp438_ = 0;
				GValue* _tmp439_ = NULL;
				GValue* _tmp440_;
				GdaDataDbFieldInfo* _tmp441_;
				GdaDataDbFieldInfoForeignKey* _tmp442_;
				GdaDataDbFieldInfoForeignKey* _tmp443_;
				GdaDataDbTable* _tmp444_;
				GdaDataDbTable* _tmp445_;
				GdaDataDbFieldInfo* _tmp446_;
				GdaDataDbFieldInfoForeignKey* _tmp447_;
				GdaDataDbFieldInfoForeignKey* _tmp448_;
				GdaDataDbTable* _tmp449_;
				GdaDataDbTable* _tmp450_;
				GdaDataCatalog* _tmp451_;
				GdaDataCatalog* _tmp452_;
				GdaDataDbFieldInfo* _tmp453_;
				GdaDataDbFieldInfoForeignKey* _tmp454_;
				GdaDataDbFieldInfoForeignKey* _tmp455_;
				GdaDataDbTable* _tmp456_;
				GdaDataDbTable* _tmp457_;
				GdaDataDbCatalog* _tmp458_;
				GdaDataDbCatalog* _tmp459_;
				GdaConnection* _tmp460_;
				GdaConnection* _tmp461_;
				GdaDataModel* _tmp462_;
				GdaDataModel* _tmp463_;
				gint _tmp464_ = 0;
				GValue* _tmp465_ = NULL;
				GValue* _tmp466_;
				GdaDataDbFieldInfo* _tmp467_;
				GdaDataDbFieldInfoForeignKey* _tmp468_;
				GdaDataDbFieldInfoForeignKey* _tmp469_;
				GdaDataDbTable* _tmp470_;
				GdaDataDbTable* _tmp471_;
				GdaDataDbCatalog* _tmp472_;
				GdaDataDbCatalog* _tmp473_;
				GdaDataDbFieldInfo* _tmp474_;
				GdaDataDbFieldInfoForeignKey* _tmp475_;
				GdaDataDbFieldInfoForeignKey* _tmp476_;
				GdaDataDbTable* _tmp477_;
				GdaDataDbTable* _tmp478_;
				GdaDataSchema* _tmp479_;
				GdaDataSchema* _tmp480_;
				GdaDataDbFieldInfo* _tmp481_;
				GdaDataDbFieldInfoForeignKey* _tmp482_;
				GdaDataDbFieldInfoForeignKey* _tmp483_;
				GdaDataDbTable* _tmp484_;
				GdaDataDbTable* _tmp485_;
				GdaDataDbSchema* _tmp486_;
				GdaDataDbSchema* _tmp487_;
				GdaConnection* _tmp488_;
				GdaConnection* _tmp489_;
				GdaDataModel* _tmp490_;
				GdaDataModel* _tmp491_;
				gint _tmp492_ = 0;
				GValue* _tmp493_ = NULL;
				GValue* _tmp494_;
				GdaDataDbFieldInfo* _tmp495_;
				GdaDataDbFieldInfoForeignKey* _tmp496_;
				GdaDataDbFieldInfoForeignKey* _tmp497_;
				GdaDataDbTable* _tmp498_;
				GdaDataDbTable* _tmp499_;
				GdaDataDbSchema* _tmp500_;
				GdaDataDbSchema* _tmp501_;
				GeeHashMap* _tmp502_;
				GdaDataDbFieldInfo* _tmp503_;
				GdaDataDbFieldInfoForeignKey* _tmp504_;
				GdaDataDbFieldInfoForeignKey* _tmp505_;
				GdaDataDbTable* _tmp506_;
				GdaDataDbTable* _tmp507_;
				const gchar* _tmp508_;
				const gchar* _tmp509_;
				GdaDataDbFieldInfo* _tmp510_;
				GdaDataDbFieldInfoForeignKey* _tmp511_;
				GdaDataDbFieldInfoForeignKey* _tmp512_;
				GdaDataDbTable* _tmp513_;
				GdaDataDbTable* _tmp514_;
				GdaDataModel* _tmp515_;
				GdaDataModel* _tmp516_;
				gint _tmp517_ = 0;
				GValue* _tmp518_ = NULL;
				GValue* _tmp519_;
				gchar* _tmp520_;
				gchar* match;
				GdaDataDbFieldInfo* _tmp521_;
				GdaDataDbFieldInfoForeignKey* _tmp522_;
				GdaDataDbFieldInfoForeignKey* _tmp523_;
				const gchar* _tmp524_;
				GdaDataDbFieldInfoForeignKeyMatch _tmp525_ = 0;
				GdaDataModel* _tmp526_;
				GdaDataModel* _tmp527_;
				gint _tmp528_ = 0;
				GValue* _tmp529_ = NULL;
				GValue* _tmp530_;
				gchar* _tmp531_;
				gchar* update_rule;
				GdaDataDbFieldInfo* _tmp532_;
				GdaDataDbFieldInfoForeignKey* _tmp533_;
				GdaDataDbFieldInfoForeignKey* _tmp534_;
				const gchar* _tmp535_;
				GdaDataDbFieldInfoForeignKeyRule _tmp536_ = 0;
				GdaDataModel* _tmp537_;
				GdaDataModel* _tmp538_;
				gint _tmp539_ = 0;
				GValue* _tmp540_ = NULL;
				GValue* _tmp541_;
				gchar* _tmp542_;
				gchar* delete_rule;
				GdaDataDbFieldInfo* _tmp543_;
				GdaDataDbFieldInfoForeignKey* _tmp544_;
				GdaDataDbFieldInfoForeignKey* _tmp545_;
				const gchar* _tmp546_;
				GdaDataDbFieldInfoForeignKeyRule _tmp547_ = 0;
				GdaMetaStore* _tmp548_;
				GHashTable* _tmp549_;
				GdaDataModel* _tmp550_ = NULL;
				GdaDataModel* mfkr;
				_tmp383_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
				_tmp384_ = _tmp383_;
				if (!_tmp384_) {
					{
						GdaMetaContext* _tmp385_;
						GdaMetaContext* cxcr3;
						GdaMetaContext* _tmp386_;
						GdaConnection* _tmp387_;
						GdaConnection* _tmp388_;
						GdaMetaContext* _tmp389_;
						_tmp385_ = gda_meta_context_new ();
						cxcr3 = _tmp385_;
						_tmp386_ = cxcr3;
						gda_meta_context_set_table (_tmp386_, "_referential_constraints");
						_tmp387_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
						_tmp388_ = _tmp387_;
						_tmp389_ = cxcr3;
						gda_connection_update_meta_store (_tmp388_, _tmp389_, &_inner_error_);
						if (_inner_error_ != NULL) {
							__vala_GdaMetaContext_free0 (cxcr3);
							goto __catch5_g_error;
						}
						__vala_GdaMetaContext_free0 (cxcr3);
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* e = NULL;
						GError* _tmp390_;
						const gchar* _tmp391_;
						gchar* _tmp392_;
						gchar* _tmp393_;
						gchar* _tmp394_;
						gchar* _tmp395_;
						GdaConnection* _tmp396_;
						GdaConnection* _tmp397_;
						gboolean _tmp398_ = FALSE;
						gboolean _tmp399_;
						gboolean _tmp400_;
						gboolean _tmp401_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp390_ = e;
						_tmp391_ = _tmp390_->message;
						_tmp392_ = g_strconcat ("Updating for _referential_constraints usage fails with error: ", _tmp391_, NULL);
						_tmp393_ = _tmp392_;
						_tmp394_ = g_strconcat (_tmp393_, "\n", NULL);
						_tmp395_ = _tmp394_;
						g_message ("Table.vala:242: %s", _tmp395_);
						_g_free0 (_tmp395_);
						_g_free0 (_tmp393_);
						g_message ("Table.vala:244: Trying to update all...");
						_tmp396_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
						_tmp397_ = _tmp396_;
						_tmp398_ = gda_connection_update_meta_store (_tmp397_, NULL, &_inner_error_);
						_tmp399_ = _tmp398_;
						if (_inner_error_ != NULL) {
							_g_error_free0 (e);
							goto __finally5;
						}
						gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, _tmp399_);
						_tmp400_ = gda_data_db_object_get_update_meta ((GdaDataDbObject*) self);
						_tmp401_ = _tmp400_;
						if (_tmp401_) {
							g_message ("Table.vala:247: Meta store update ... Ok");
						}
						_g_error_free0 (e);
					}
					__finally5:
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (f);
						_g_free0 (colname);
						_g_object_unref0 (mpk);
						_g_free0 (cn);
						_g_free0 (ct);
						_g_object_unref0 (mc);
						_g_object_unref0 (mt);
						_g_hash_table_unref0 (vals);
						_g_object_unref0 (store);
						_g_free0 (cond);
						return;
					}
				}
				_tmp402_ = store;
				_tmp403_ = cond;
				_tmp404_ = g_strconcat ("SELECT * FROM _referential_constraints" " WHERE table_name  = ##name::string " "AND constraint_name = ##constraint_name::string", _tmp403_, NULL);
				_tmp405_ = _tmp404_;
				_tmp406_ = vals;
				_tmp407_ = gda_meta_store_extract_v (_tmp402_, _tmp405_, _tmp406_, &_inner_error_);
				_tmp408_ = _tmp407_;
				_g_free0 (_tmp405_);
				mfk = _tmp408_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_free0 (colname);
					_g_object_unref0 (mpk);
					_g_free0 (cn);
					_g_free0 (ct);
					_g_object_unref0 (mc);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				_tmp409_ = f;
				_tmp410_ = gda_data_db_field_info_foreign_key_new ();
				_tmp411_ = _tmp410_;
				gda_data_db_field_info_set_fkey (_tmp409_, _tmp411_);
				_gda_data_db_field_info_foreign_key_unref0 (_tmp411_);
				_tmp412_ = f;
				_tmp413_ = gda_data_db_field_info_get_fkey (_tmp412_);
				_tmp414_ = _tmp413_;
				_tmp415_ = cn;
				gda_data_db_field_info_foreign_key_set_name (_tmp414_, _tmp415_);
				_tmp416_ = mfk;
				_tmp417_ = mfk;
				_tmp418_ = gda_data_model_get_column_index (_tmp417_, "ref_constraint_name");
				_tmp419_ = gda_data_model_get_value_at (_tmp416_, _tmp418_, 0, &_inner_error_);
				_tmp420_ = _tmp419_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (mfk);
					_g_object_unref0 (f);
					_g_free0 (colname);
					_g_object_unref0 (mpk);
					_g_free0 (cn);
					_g_free0 (ct);
					_g_object_unref0 (mc);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				_tmp421_ = f;
				_tmp422_ = gda_data_db_field_info_get_fkey (_tmp421_);
				_tmp423_ = _tmp422_;
				gda_data_db_field_info_foreign_key_set_refname (_tmp423_, g_value_get_string (_tmp420_));
				_tmp424_ = f;
				_tmp425_ = gda_data_db_field_info_get_fkey (_tmp424_);
				_tmp426_ = _tmp425_;
				_tmp427_ = gda_data_table_new ();
				_tmp428_ = _tmp427_;
				gda_data_db_field_info_foreign_key_set_reftable (_tmp426_, (GdaDataDbTable*) _tmp428_);
				_g_object_unref0 (_tmp428_);
				_tmp429_ = f;
				_tmp430_ = gda_data_db_field_info_get_fkey (_tmp429_);
				_tmp431_ = _tmp430_;
				_tmp432_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp431_);
				_tmp433_ = _tmp432_;
				_tmp434_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp435_ = _tmp434_;
				gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp433_, _tmp435_);
				_tmp436_ = mfk;
				_tmp437_ = mfk;
				_tmp438_ = gda_data_model_get_column_index (_tmp437_, "ref_table_name");
				_tmp439_ = gda_data_model_get_value_at (_tmp436_, _tmp438_, 0, &_inner_error_);
				_tmp440_ = _tmp439_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (mfk);
					_g_object_unref0 (f);
					_g_free0 (colname);
					_g_object_unref0 (mpk);
					_g_free0 (cn);
					_g_free0 (ct);
					_g_object_unref0 (mc);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				_tmp441_ = f;
				_tmp442_ = gda_data_db_field_info_get_fkey (_tmp441_);
				_tmp443_ = _tmp442_;
				_tmp444_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp443_);
				_tmp445_ = _tmp444_;
				gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp445_, g_value_get_string (_tmp440_));
				_tmp446_ = f;
				_tmp447_ = gda_data_db_field_info_get_fkey (_tmp446_);
				_tmp448_ = _tmp447_;
				_tmp449_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp448_);
				_tmp450_ = _tmp449_;
				_tmp451_ = gda_data_catalog_new ();
				_tmp452_ = _tmp451_;
				gda_data_db_table_set_catalog (_tmp450_, (GdaDataDbCatalog*) _tmp452_);
				_g_object_unref0 (_tmp452_);
				_tmp453_ = f;
				_tmp454_ = gda_data_db_field_info_get_fkey (_tmp453_);
				_tmp455_ = _tmp454_;
				_tmp456_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp455_);
				_tmp457_ = _tmp456_;
				_tmp458_ = gda_data_db_table_get_catalog (_tmp457_);
				_tmp459_ = _tmp458_;
				_tmp460_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp461_ = _tmp460_;
				gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp459_, _tmp461_);
				_tmp462_ = mfk;
				_tmp463_ = mfk;
				_tmp464_ = gda_data_model_get_column_index (_tmp463_, "ref_table_catalog");
				_tmp465_ = gda_data_model_get_value_at (_tmp462_, _tmp464_, 0, &_inner_error_);
				_tmp466_ = _tmp465_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (mfk);
					_g_object_unref0 (f);
					_g_free0 (colname);
					_g_object_unref0 (mpk);
					_g_free0 (cn);
					_g_free0 (ct);
					_g_object_unref0 (mc);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				_tmp467_ = f;
				_tmp468_ = gda_data_db_field_info_get_fkey (_tmp467_);
				_tmp469_ = _tmp468_;
				_tmp470_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp469_);
				_tmp471_ = _tmp470_;
				_tmp472_ = gda_data_db_table_get_catalog (_tmp471_);
				_tmp473_ = _tmp472_;
				gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp473_, g_value_get_string (_tmp466_));
				_tmp474_ = f;
				_tmp475_ = gda_data_db_field_info_get_fkey (_tmp474_);
				_tmp476_ = _tmp475_;
				_tmp477_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp476_);
				_tmp478_ = _tmp477_;
				_tmp479_ = gda_data_schema_new ();
				_tmp480_ = _tmp479_;
				gda_data_db_table_set_schema (_tmp478_, (GdaDataDbSchema*) _tmp480_);
				_g_object_unref0 (_tmp480_);
				_tmp481_ = f;
				_tmp482_ = gda_data_db_field_info_get_fkey (_tmp481_);
				_tmp483_ = _tmp482_;
				_tmp484_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp483_);
				_tmp485_ = _tmp484_;
				_tmp486_ = gda_data_db_table_get_schema (_tmp485_);
				_tmp487_ = _tmp486_;
				_tmp488_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp489_ = _tmp488_;
				gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp487_, _tmp489_);
				_tmp490_ = mfk;
				_tmp491_ = mfk;
				_tmp492_ = gda_data_model_get_column_index (_tmp491_, "ref_table_schema");
				_tmp493_ = gda_data_model_get_value_at (_tmp490_, _tmp492_, 0, &_inner_error_);
				_tmp494_ = _tmp493_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (mfk);
					_g_object_unref0 (f);
					_g_free0 (colname);
					_g_object_unref0 (mpk);
					_g_free0 (cn);
					_g_free0 (ct);
					_g_object_unref0 (mc);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				_tmp495_ = f;
				_tmp496_ = gda_data_db_field_info_get_fkey (_tmp495_);
				_tmp497_ = _tmp496_;
				_tmp498_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp497_);
				_tmp499_ = _tmp498_;
				_tmp500_ = gda_data_db_table_get_schema (_tmp499_);
				_tmp501_ = _tmp500_;
				gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp501_, g_value_get_string (_tmp494_));
				_tmp502_ = self->_depends;
				_tmp503_ = f;
				_tmp504_ = gda_data_db_field_info_get_fkey (_tmp503_);
				_tmp505_ = _tmp504_;
				_tmp506_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp505_);
				_tmp507_ = _tmp506_;
				_tmp508_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp507_);
				_tmp509_ = _tmp508_;
				_tmp510_ = f;
				_tmp511_ = gda_data_db_field_info_get_fkey (_tmp510_);
				_tmp512_ = _tmp511_;
				_tmp513_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp512_);
				_tmp514_ = _tmp513_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp502_, _tmp509_, _tmp514_);
				_tmp515_ = mfk;
				_tmp516_ = mfk;
				_tmp517_ = gda_data_model_get_column_index (_tmp516_, "match_option");
				_tmp518_ = gda_data_model_get_value_at (_tmp515_, _tmp517_, 0, &_inner_error_);
				_tmp519_ = _tmp518_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (mfk);
					_g_object_unref0 (f);
					_g_free0 (colname);
					_g_object_unref0 (mpk);
					_g_free0 (cn);
					_g_free0 (ct);
					_g_object_unref0 (mc);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				_tmp520_ = g_strdup (g_value_get_string (_tmp519_));
				match = _tmp520_;
				_tmp521_ = f;
				_tmp522_ = gda_data_db_field_info_get_fkey (_tmp521_);
				_tmp523_ = _tmp522_;
				_tmp524_ = match;
				_tmp525_ = gda_data_db_field_info_foreign_key_match_from_string (_tmp524_);
				gda_data_db_field_info_foreign_key_set_match (_tmp523_, _tmp525_);
				_tmp526_ = mfk;
				_tmp527_ = mfk;
				_tmp528_ = gda_data_model_get_column_index (_tmp527_, "update_rule");
				_tmp529_ = gda_data_model_get_value_at (_tmp526_, _tmp528_, 0, &_inner_error_);
				_tmp530_ = _tmp529_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (match);
					_g_object_unref0 (mfk);
					_g_object_unref0 (f);
					_g_free0 (colname);
					_g_object_unref0 (mpk);
					_g_free0 (cn);
					_g_free0 (ct);
					_g_object_unref0 (mc);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				_tmp531_ = g_strdup (g_value_get_string (_tmp530_));
				update_rule = _tmp531_;
				_tmp532_ = f;
				_tmp533_ = gda_data_db_field_info_get_fkey (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp535_ = update_rule;
				_tmp536_ = gda_data_db_field_info_foreign_key_rule_from_string (_tmp535_);
				gda_data_db_field_info_foreign_key_set_update_rule (_tmp534_, _tmp536_);
				_tmp537_ = mfk;
				_tmp538_ = mfk;
				_tmp539_ = gda_data_model_get_column_index (_tmp538_, "delete_rule");
				_tmp540_ = gda_data_model_get_value_at (_tmp537_, _tmp539_, 0, &_inner_error_);
				_tmp541_ = _tmp540_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (update_rule);
					_g_free0 (match);
					_g_object_unref0 (mfk);
					_g_object_unref0 (f);
					_g_free0 (colname);
					_g_object_unref0 (mpk);
					_g_free0 (cn);
					_g_free0 (ct);
					_g_object_unref0 (mc);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				_tmp542_ = g_strdup (g_value_get_string (_tmp541_));
				delete_rule = _tmp542_;
				_tmp543_ = f;
				_tmp544_ = gda_data_db_field_info_get_fkey (_tmp543_);
				_tmp545_ = _tmp544_;
				_tmp546_ = delete_rule;
				_tmp547_ = gda_data_db_field_info_foreign_key_rule_from_string (_tmp546_);
				gda_data_db_field_info_foreign_key_set_delete_rule (_tmp545_, _tmp547_);
				_tmp548_ = store;
				_tmp549_ = vals;
				_tmp550_ = gda_meta_store_extract_v (_tmp548_, "SELECT * FROM _detailed_fk " " WHERE fk_table_name  = ##name::string" " AND fk_constraint_name = ##constraint_name::string" " AND fk_table_catalog = ##catalog::string" " AND fk_table_schema = ##schema::string", _tmp549_, &_inner_error_);
				mfkr = _tmp550_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (delete_rule);
					_g_free0 (update_rule);
					_g_free0 (match);
					_g_object_unref0 (mfk);
					_g_object_unref0 (f);
					_g_free0 (colname);
					_g_object_unref0 (mpk);
					_g_free0 (cn);
					_g_free0 (ct);
					_g_object_unref0 (mc);
					_g_object_unref0 (mt);
					_g_hash_table_unref0 (vals);
					_g_object_unref0 (store);
					_g_free0 (cond);
					return;
				}
				{
					gint r2;
					r2 = 0;
					{
						gboolean _tmp551_;
						_tmp551_ = TRUE;
						while (TRUE) {
							gboolean _tmp552_;
							gint _tmp554_;
							GdaDataModel* _tmp555_;
							gint _tmp556_ = 0;
							GdaDataModel* _tmp557_;
							GdaDataModel* _tmp558_;
							gint _tmp559_ = 0;
							gint _tmp560_;
							GValue* _tmp561_ = NULL;
							GValue* _tmp562_;
							gchar* _tmp563_;
							gchar* rc;
							GdaDataDbFieldInfo* _tmp564_;
							GdaDataDbFieldInfoForeignKey* _tmp565_;
							GdaDataDbFieldInfoForeignKey* _tmp566_;
							GeeArrayList* _tmp567_;
							GeeArrayList* _tmp568_;
							const gchar* _tmp569_;
							_tmp552_ = _tmp551_;
							if (!_tmp552_) {
								gint _tmp553_;
								_tmp553_ = r2;
								r2 = _tmp553_ + 1;
							}
							_tmp551_ = FALSE;
							_tmp554_ = r2;
							_tmp555_ = mfkr;
							_tmp556_ = gda_data_model_get_n_rows (_tmp555_);
							if (!(_tmp554_ < _tmp556_)) {
								break;
							}
							_tmp557_ = mfkr;
							_tmp558_ = mfkr;
							_tmp559_ = gda_data_model_get_column_index (_tmp558_, "ref_column");
							_tmp560_ = r2;
							_tmp561_ = gda_data_model_get_value_at (_tmp557_, _tmp559_, _tmp560_, &_inner_error_);
							_tmp562_ = _tmp561_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (mfkr);
								_g_free0 (delete_rule);
								_g_free0 (update_rule);
								_g_free0 (match);
								_g_object_unref0 (mfk);
								_g_object_unref0 (f);
								_g_free0 (colname);
								_g_object_unref0 (mpk);
								_g_free0 (cn);
								_g_free0 (ct);
								_g_object_unref0 (mc);
								_g_object_unref0 (mt);
								_g_hash_table_unref0 (vals);
								_g_object_unref0 (store);
								_g_free0 (cond);
								return;
							}
							_tmp563_ = g_strdup (g_value_get_string (_tmp562_));
							rc = _tmp563_;
							_tmp564_ = f;
							_tmp565_ = gda_data_db_field_info_get_fkey (_tmp564_);
							_tmp566_ = _tmp565_;
							_tmp567_ = gda_data_db_field_info_foreign_key_get_refcol (_tmp566_);
							_tmp568_ = _tmp567_;
							_tmp569_ = rc;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp568_, _tmp569_);
							_g_free0 (rc);
						}
					}
				}
				_g_object_unref0 (mfkr);
				_g_free0 (delete_rule);
				_g_free0 (update_rule);
				_g_free0 (match);
				_g_object_unref0 (mfk);
			}
			_tmp570_ = f;
			_tmp571_ = gda_data_db_field_info_get_attributes (_tmp570_);
			_tmp572_ = _tmp571_;
			if ((_tmp572_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK) {
			}
			_tmp573_ = self->_fields;
			_tmp574_ = f;
			_tmp575_ = gda_data_db_field_info_get_name (_tmp574_);
			_tmp576_ = _tmp575_;
			_tmp577_ = f;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp573_, _tmp576_, _tmp577_);
			_g_object_unref0 (f);
			_g_free0 (colname);
			_g_object_unref0 (mpk);
			_g_free0 (cn);
			_g_free0 (ct);
		}
	}
	_tmp578_ = store;
	_tmp579_ = vals;
	_tmp580_ = gda_meta_store_extract_v (_tmp578_, "SELECT * FROM " "_detailed_fk WHERE ref_table_name  = ##name::string" " AND ref_table_catalog = ##catalog::string" " AND ref_table_schema = ##schema::string", _tmp579_, &_inner_error_);
	mtr = _tmp580_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (mc);
		_g_object_unref0 (mt);
		_g_hash_table_unref0 (vals);
		_g_object_unref0 (store);
		_g_free0 (cond);
		return;
	}
	_tmp581_ = mtr;
	_tmp582_ = gda_data_model_get_n_rows (_tmp581_);
	if (_tmp582_ == 0) {
		g_message ("Table.vala:304: Rows = 0");
	}
	{
		gboolean _tmp583_;
		r = 0;
		_tmp583_ = TRUE;
		while (TRUE) {
			gboolean _tmp584_;
			gint _tmp586_;
			GdaDataModel* _tmp587_;
			gint _tmp588_ = 0;
			GdaDataModel* _tmp589_;
			GdaDataModel* _tmp590_;
			gint _tmp591_ = 0;
			gint _tmp592_;
			GValue* _tmp593_ = NULL;
			GValue* _tmp594_;
			gchar* _tmp595_;
			gchar* tn;
			GdaDataTable* _tmp596_;
			GdaDataTable* tr;
			GdaDataTable* _tmp597_;
			GdaConnection* _tmp598_;
			GdaConnection* _tmp599_;
			GdaDataTable* _tmp600_;
			const gchar* _tmp601_;
			GeeHashMap* _tmp602_;
			GdaDataTable* _tmp603_;
			const gchar* _tmp604_;
			const gchar* _tmp605_;
			GdaDataTable* _tmp606_;
			_tmp584_ = _tmp583_;
			if (!_tmp584_) {
				gint _tmp585_;
				_tmp585_ = r;
				r = _tmp585_ + 1;
			}
			_tmp583_ = FALSE;
			_tmp586_ = r;
			_tmp587_ = mtr;
			_tmp588_ = gda_data_model_get_n_rows (_tmp587_);
			if (!(_tmp586_ < _tmp588_)) {
				break;
			}
			_tmp589_ = mtr;
			_tmp590_ = mtr;
			_tmp591_ = gda_data_model_get_column_index (_tmp590_, "fk_table_name");
			_tmp592_ = r;
			_tmp593_ = gda_data_model_get_value_at (_tmp589_, _tmp591_, _tmp592_, &_inner_error_);
			_tmp594_ = _tmp593_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (mtr);
				_g_object_unref0 (mc);
				_g_object_unref0 (mt);
				_g_hash_table_unref0 (vals);
				_g_object_unref0 (store);
				_g_free0 (cond);
				return;
			}
			_tmp595_ = g_strdup (g_value_get_string (_tmp594_));
			tn = _tmp595_;
			_tmp596_ = gda_data_table_new ();
			tr = _tmp596_;
			_tmp597_ = tr;
			_tmp598_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp599_ = _tmp598_;
			gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp597_, _tmp599_);
			_tmp600_ = tr;
			_tmp601_ = tn;
			gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp600_, _tmp601_);
			_tmp602_ = self->_referenced;
			_tmp603_ = tr;
			_tmp604_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp603_);
			_tmp605_ = _tmp604_;
			_tmp606_ = tr;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp602_, _tmp605_, (GdaDataDbTable*) _tmp606_);
			_g_object_unref0 (tr);
			_g_free0 (tn);
		}
	}
	self->priv->_read_only = TRUE;
	_tmp607_ = self->_fields;
	_tmp608_ = gee_abstract_map_get_size ((GeeMap*) _tmp607_);
	_tmp609_ = _tmp608_;
	self->priv->_n_cols = _tmp609_;
	_g_object_unref0 (mtr);
	_g_object_unref0 (mc);
	_g_object_unref0 (mt);
	_g_hash_table_unref0 (vals);
	_g_object_unref0 (store);
	_g_free0 (cond);
}


static void gda_data_table_real_save (GdaDataDbObject* base, GError** error) {
	GdaDataTable * self;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	self = (GdaDataTable*) base;
	g_warning ("Table.vala:318: Not Implemented!");
	return;
}


static void gda_data_table_real_append (GdaDataDbObject* base, GError** error) {
	GdaDataTable * self;
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	GdaServerOperation* _tmp2_ = NULL;
	GdaServerOperation* op;
	GdaServerOperation* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GdaDataDbTableTableType _tmp6_;
	GdaDataDbTableTableType _tmp7_;
	gint refs;
	GdaConnection* _tmp204_;
	GdaConnection* _tmp205_;
	GdaServerOperation* _tmp206_;
	GError * _inner_error_ = NULL;
	self = (GdaDataTable*) base;
	_tmp0_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gda_connection_create_operation (_tmp1_, GDA_SERVER_OPERATION_CREATE_TABLE, NULL, &_inner_error_);
	op = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = op;
	_tmp4_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self);
	_tmp5_ = _tmp4_;
	gda_server_operation_set_value_at_path (_tmp3_, _tmp5_, "/TABLE_DEF_P/TABLE_NAME", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (op);
		return;
	}
	_tmp6_ = gda_data_db_table_get_table_type ((GdaDataDbTable*) self);
	_tmp7_ = _tmp6_;
	if ((_tmp7_ & GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY) == GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY) {
		GdaServerOperation* _tmp8_;
		_tmp8_ = op;
		gda_server_operation_set_value_at_path (_tmp8_, "TRUE", "/TABLE_DEF_P/TABLE_TEMP", &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (op);
			return;
		}
	}
	refs = 0;
	{
		GeeCollection* _tmp9_;
		GeeCollection* _tmp10_;
		GeeCollection* _tmp11_;
		GeeIterator* _tmp12_ = NULL;
		GeeIterator* _tmp13_;
		GeeIterator* _f_it;
		_tmp9_ = gda_data_db_table_get_fields ((GdaDataDbTable*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_f_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			gboolean _tmp15_ = FALSE;
			GeeIterator* _tmp16_;
			gpointer _tmp17_ = NULL;
			GdaDataDbFieldInfo* f;
			GdaServerOperation* _tmp18_;
			GdaDataDbFieldInfo* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			GdaDataDbFieldInfo* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			GdaServerOperation* _tmp29_;
			GdaConnection* _tmp30_;
			GdaConnection* _tmp31_;
			GdaServerProvider* _tmp32_ = NULL;
			GdaConnection* _tmp33_;
			GdaConnection* _tmp34_;
			GdaDataDbFieldInfo* _tmp35_;
			GType _tmp36_;
			GType _tmp37_;
			const gchar* _tmp38_ = NULL;
			GdaDataDbFieldInfo* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			GdaDataDbFieldInfo* _tmp46_;
			GdaDataDbFieldInfoAttribute _tmp47_;
			GdaDataDbFieldInfoAttribute _tmp48_;
			GdaDataDbFieldInfo* _tmp57_;
			GdaDataDbFieldInfoAttribute _tmp58_;
			GdaDataDbFieldInfoAttribute _tmp59_;
			GdaDataDbFieldInfo* _tmp68_;
			GdaDataDbFieldInfoAttribute _tmp69_;
			GdaDataDbFieldInfoAttribute _tmp70_;
			GdaDataDbFieldInfo* _tmp79_;
			GdaDataDbFieldInfoAttribute _tmp80_;
			GdaDataDbFieldInfoAttribute _tmp81_;
			GdaDataDbFieldInfo* _tmp90_;
			GdaDataDbFieldInfoAttribute _tmp91_;
			GdaDataDbFieldInfoAttribute _tmp92_;
			GdaDataDbFieldInfo* _tmp109_;
			GdaDataDbFieldInfoAttribute _tmp110_;
			GdaDataDbFieldInfoAttribute _tmp111_;
			_tmp14_ = _f_it;
			_tmp15_ = gee_iterator_next (_tmp14_);
			if (!_tmp15_) {
				break;
			}
			_tmp16_ = _f_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			f = (GdaDataDbFieldInfo*) _tmp17_;
			_tmp18_ = op;
			_tmp19_ = f;
			_tmp20_ = gda_data_db_field_info_get_name (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = f;
			_tmp23_ = gda_data_db_field_info_get_ordinal (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strdup_printf ("%i", _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat ("/FIELDS_A/@COLUMN_NAME/", _tmp26_, NULL);
			_tmp28_ = _tmp27_;
			gda_server_operation_set_value_at_path (_tmp18_, _tmp21_, _tmp28_, &_inner_error_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (f);
				_g_object_unref0 (_f_it);
				_g_object_unref0 (op);
				return;
			}
			_tmp29_ = op;
			_tmp30_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = gda_connection_get_provider (_tmp31_);
			_tmp33_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = f;
			_tmp36_ = gda_data_db_field_info_get_value_type (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = gda_server_provider_get_default_dbms_type (_tmp32_, _tmp34_, _tmp37_);
			_tmp39_ = f;
			_tmp40_ = gda_data_db_field_info_get_ordinal (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strdup_printf ("%i", _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat ("/FIELDS_A/@COLUMN_TYPE/", _tmp43_, NULL);
			_tmp45_ = _tmp44_;
			gda_server_operation_set_value_at_path (_tmp29_, _tmp38_, _tmp45_, &_inner_error_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (f);
				_g_object_unref0 (_f_it);
				_g_object_unref0 (op);
				return;
			}
			_tmp46_ = f;
			_tmp47_ = gda_data_db_field_info_get_attributes (_tmp46_);
			_tmp48_ = _tmp47_;
			if ((_tmp48_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY) {
				GdaServerOperation* _tmp49_;
				GdaDataDbFieldInfo* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gchar* _tmp53_ = NULL;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				_tmp49_ = op;
				_tmp50_ = f;
				_tmp51_ = gda_data_db_field_info_get_ordinal (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = g_strdup_printf ("%i", _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_strconcat ("/FIELDS_A/@COLUMN_PKEY/", _tmp54_, NULL);
				_tmp56_ = _tmp55_;
				gda_server_operation_set_value_at_path (_tmp49_, "TRUE", _tmp56_, &_inner_error_);
				_g_free0 (_tmp56_);
				_g_free0 (_tmp54_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					_g_object_unref0 (op);
					return;
				}
			}
			_tmp57_ = f;
			_tmp58_ = gda_data_db_field_info_get_attributes (_tmp57_);
			_tmp59_ = _tmp58_;
			if ((_tmp59_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL) {
				GdaServerOperation* _tmp60_;
				GdaDataDbFieldInfo* _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				_tmp60_ = op;
				_tmp61_ = f;
				_tmp62_ = gda_data_db_field_info_get_ordinal (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = g_strdup_printf ("%i", _tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strconcat ("/FIELDS_A/@COLUMN_NNUL/", _tmp65_, NULL);
				_tmp67_ = _tmp66_;
				gda_server_operation_set_value_at_path (_tmp60_, "TRUE", _tmp67_, &_inner_error_);
				_g_free0 (_tmp67_);
				_g_free0 (_tmp65_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					_g_object_unref0 (op);
					return;
				}
			}
			_tmp68_ = f;
			_tmp69_ = gda_data_db_field_info_get_attributes (_tmp68_);
			_tmp70_ = _tmp69_;
			if ((_tmp70_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT) {
				GdaServerOperation* _tmp71_;
				GdaDataDbFieldInfo* _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				gchar* _tmp75_ = NULL;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				_tmp71_ = op;
				_tmp72_ = f;
				_tmp73_ = gda_data_db_field_info_get_ordinal (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strdup_printf ("%i", _tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_strconcat ("/FIELDS_A/@COLUMN_AUTOINC/", _tmp76_, NULL);
				_tmp78_ = _tmp77_;
				gda_server_operation_set_value_at_path (_tmp71_, "TRUE", _tmp78_, &_inner_error_);
				_g_free0 (_tmp78_);
				_g_free0 (_tmp76_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					_g_object_unref0 (op);
					return;
				}
			}
			_tmp79_ = f;
			_tmp80_ = gda_data_db_field_info_get_attributes (_tmp79_);
			_tmp81_ = _tmp80_;
			if ((_tmp81_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE) {
				GdaServerOperation* _tmp82_;
				GdaDataDbFieldInfo* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				gchar* _tmp86_ = NULL;
				gchar* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				_tmp82_ = op;
				_tmp83_ = f;
				_tmp84_ = gda_data_db_field_info_get_ordinal (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = g_strdup_printf ("%i", _tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = g_strconcat ("/FIELDS_A/@COLUMN_UNIQUE/", _tmp87_, NULL);
				_tmp89_ = _tmp88_;
				gda_server_operation_set_value_at_path (_tmp82_, "TRUE", _tmp89_, &_inner_error_);
				_g_free0 (_tmp89_);
				_g_free0 (_tmp87_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					_g_object_unref0 (op);
					return;
				}
			}
			_tmp90_ = f;
			_tmp91_ = gda_data_db_field_info_get_attributes (_tmp90_);
			_tmp92_ = _tmp91_;
			if ((_tmp92_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT) {
				GdaServerOperation* _tmp93_;
				GdaConnection* _tmp94_;
				GdaConnection* _tmp95_;
				GdaDataDbFieldInfo* _tmp96_;
				GValue* _tmp97_;
				GValue* _tmp98_;
				GValue _tmp99_;
				gchar* _tmp100_ = NULL;
				gchar* _tmp101_;
				GdaDataDbFieldInfo* _tmp102_;
				gint _tmp103_;
				gint _tmp104_;
				gchar* _tmp105_ = NULL;
				gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				_tmp93_ = op;
				_tmp94_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
				_tmp95_ = _tmp94_;
				_tmp96_ = f;
				_tmp97_ = gda_data_db_field_info_get_default_value (_tmp96_);
				_tmp98_ = _tmp97_;
				_tmp99_ = *_tmp98_;
				_tmp100_ = gda_connection_value_to_sql_string (_tmp95_, &_tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = f;
				_tmp103_ = gda_data_db_field_info_get_ordinal (_tmp102_);
				_tmp104_ = _tmp103_;
				_tmp105_ = g_strdup_printf ("%i", _tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = g_strconcat ("/FIELDS_A/@COLUMN_DEFAULT/", _tmp106_, NULL);
				_tmp108_ = _tmp107_;
				gda_server_operation_set_value_at_path (_tmp93_, _tmp101_, _tmp108_, &_inner_error_);
				_g_free0 (_tmp108_);
				_g_free0 (_tmp106_);
				_g_free0 (_tmp101_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					_g_object_unref0 (op);
					return;
				}
			}
			_tmp109_ = f;
			_tmp110_ = gda_data_db_field_info_get_attributes (_tmp109_);
			_tmp111_ = _tmp110_;
			if ((_tmp111_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY) {
				GdaServerOperation* _tmp112_;
				GdaDataDbFieldInfo* _tmp113_;
				GdaDataDbFieldInfoForeignKey* _tmp114_;
				GdaDataDbFieldInfoForeignKey* _tmp115_;
				GdaDataDbTable* _tmp116_;
				GdaDataDbTable* _tmp117_;
				const gchar* _tmp118_;
				const gchar* _tmp119_;
				gint _tmp120_;
				gchar* _tmp121_ = NULL;
				gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				gchar* _tmp125_;
				gchar* _tmp126_;
				gint rc;
				GdaServerOperation* _tmp173_;
				GdaDataDbFieldInfo* _tmp174_;
				GdaDataDbFieldInfoForeignKey* _tmp175_;
				GdaDataDbFieldInfoForeignKey* _tmp176_;
				GdaDataDbFieldInfoForeignKeyRule _tmp177_;
				GdaDataDbFieldInfoForeignKeyRule _tmp178_;
				gchar* _tmp179_ = NULL;
				gchar* _tmp180_;
				gint _tmp181_;
				gchar* _tmp182_ = NULL;
				gchar* _tmp183_;
				gchar* _tmp184_;
				gchar* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				GdaServerOperation* _tmp188_;
				GdaDataDbFieldInfo* _tmp189_;
				GdaDataDbFieldInfoForeignKey* _tmp190_;
				GdaDataDbFieldInfoForeignKey* _tmp191_;
				GdaDataDbFieldInfoForeignKeyRule _tmp192_;
				GdaDataDbFieldInfoForeignKeyRule _tmp193_;
				gchar* _tmp194_ = NULL;
				gchar* _tmp195_;
				gint _tmp196_;
				gchar* _tmp197_ = NULL;
				gchar* _tmp198_;
				gchar* _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				gint _tmp203_;
				_tmp112_ = op;
				_tmp113_ = f;
				_tmp114_ = gda_data_db_field_info_get_fkey (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = gda_data_db_field_info_foreign_key_get_reftable (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp117_);
				_tmp119_ = _tmp118_;
				_tmp120_ = refs;
				_tmp121_ = g_strdup_printf ("%i", _tmp120_);
				_tmp122_ = _tmp121_;
				_tmp123_ = g_strconcat ("/FKEY_S/", _tmp122_, NULL);
				_tmp124_ = _tmp123_;
				_tmp125_ = g_strconcat (_tmp124_, "/FKEY_REF_TABLE", NULL);
				_tmp126_ = _tmp125_;
				gda_server_operation_set_value_at_path (_tmp112_, _tmp119_, _tmp126_, &_inner_error_);
				_g_free0 (_tmp126_);
				_g_free0 (_tmp124_);
				_g_free0 (_tmp122_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					_g_object_unref0 (op);
					return;
				}
				rc = 0;
				{
					GdaDataDbFieldInfo* _tmp127_;
					GdaDataDbFieldInfoForeignKey* _tmp128_;
					GdaDataDbFieldInfoForeignKey* _tmp129_;
					GeeArrayList* _tmp130_;
					GeeArrayList* _tmp131_;
					GeeArrayList* _tmp132_;
					GeeArrayList* _fkc_list;
					GeeArrayList* _tmp133_;
					gint _tmp134_;
					gint _tmp135_;
					gint _fkc_size;
					gint _fkc_index;
					_tmp127_ = f;
					_tmp128_ = gda_data_db_field_info_get_fkey (_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = gda_data_db_field_info_foreign_key_get_refcol (_tmp129_);
					_tmp131_ = _tmp130_;
					_tmp132_ = _g_object_ref0 (_tmp131_);
					_fkc_list = _tmp132_;
					_tmp133_ = _fkc_list;
					_tmp134_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp133_);
					_tmp135_ = _tmp134_;
					_fkc_size = _tmp135_;
					_fkc_index = -1;
					while (TRUE) {
						gint _tmp136_;
						gint _tmp137_;
						gint _tmp138_;
						GeeArrayList* _tmp139_;
						gint _tmp140_;
						gpointer _tmp141_ = NULL;
						gchar* fkc;
						GdaServerOperation* _tmp142_;
						GdaDataDbFieldInfo* _tmp143_;
						const gchar* _tmp144_;
						const gchar* _tmp145_;
						gint _tmp146_;
						gchar* _tmp147_ = NULL;
						gchar* _tmp148_;
						gchar* _tmp149_;
						gchar* _tmp150_;
						gchar* _tmp151_;
						gchar* _tmp152_;
						gint _tmp153_;
						gchar* _tmp154_ = NULL;
						gchar* _tmp155_;
						gchar* _tmp156_;
						gchar* _tmp157_;
						GdaServerOperation* _tmp158_;
						const gchar* _tmp159_;
						gint _tmp160_;
						gchar* _tmp161_ = NULL;
						gchar* _tmp162_;
						gchar* _tmp163_;
						gchar* _tmp164_;
						gchar* _tmp165_;
						gchar* _tmp166_;
						gint _tmp167_;
						gchar* _tmp168_ = NULL;
						gchar* _tmp169_;
						gchar* _tmp170_;
						gchar* _tmp171_;
						gint _tmp172_;
						_tmp136_ = _fkc_index;
						_fkc_index = _tmp136_ + 1;
						_tmp137_ = _fkc_index;
						_tmp138_ = _fkc_size;
						if (!(_tmp137_ < _tmp138_)) {
							break;
						}
						_tmp139_ = _fkc_list;
						_tmp140_ = _fkc_index;
						_tmp141_ = gee_abstract_list_get ((GeeAbstractList*) _tmp139_, _tmp140_);
						fkc = (gchar*) _tmp141_;
						_tmp142_ = op;
						_tmp143_ = f;
						_tmp144_ = gda_data_db_field_info_get_name (_tmp143_);
						_tmp145_ = _tmp144_;
						_tmp146_ = refs;
						_tmp147_ = g_strdup_printf ("%i", _tmp146_);
						_tmp148_ = _tmp147_;
						_tmp149_ = g_strconcat ("/FKEY_S/", _tmp148_, NULL);
						_tmp150_ = _tmp149_;
						_tmp151_ = g_strconcat (_tmp150_, "/FKEY_FIELDS_A/@FK_FIELD/", NULL);
						_tmp152_ = _tmp151_;
						_tmp153_ = rc;
						_tmp154_ = g_strdup_printf ("%i", _tmp153_);
						_tmp155_ = _tmp154_;
						_tmp156_ = g_strconcat (_tmp152_, _tmp155_, NULL);
						_tmp157_ = _tmp156_;
						gda_server_operation_set_value_at_path (_tmp142_, _tmp145_, _tmp157_, &_inner_error_);
						_g_free0 (_tmp157_);
						_g_free0 (_tmp155_);
						_g_free0 (_tmp152_);
						_g_free0 (_tmp150_);
						_g_free0 (_tmp148_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (fkc);
							_g_object_unref0 (_fkc_list);
							_g_object_unref0 (f);
							_g_object_unref0 (_f_it);
							_g_object_unref0 (op);
							return;
						}
						_tmp158_ = op;
						_tmp159_ = fkc;
						_tmp160_ = refs;
						_tmp161_ = g_strdup_printf ("%i", _tmp160_);
						_tmp162_ = _tmp161_;
						_tmp163_ = g_strconcat ("/FKEY_S/", _tmp162_, NULL);
						_tmp164_ = _tmp163_;
						_tmp165_ = g_strconcat (_tmp164_, "/FKEY_FIELDS_A/@FK_REF_PK_FIELD/", NULL);
						_tmp166_ = _tmp165_;
						_tmp167_ = rc;
						_tmp168_ = g_strdup_printf ("%i", _tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = g_strconcat (_tmp166_, _tmp169_, NULL);
						_tmp171_ = _tmp170_;
						gda_server_operation_set_value_at_path (_tmp158_, _tmp159_, _tmp171_, &_inner_error_);
						_g_free0 (_tmp171_);
						_g_free0 (_tmp169_);
						_g_free0 (_tmp166_);
						_g_free0 (_tmp164_);
						_g_free0 (_tmp162_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (fkc);
							_g_object_unref0 (_fkc_list);
							_g_object_unref0 (f);
							_g_object_unref0 (_f_it);
							_g_object_unref0 (op);
							return;
						}
						_tmp172_ = rc;
						rc = _tmp172_ + 1;
						_g_free0 (fkc);
					}
					_g_object_unref0 (_fkc_list);
				}
				_tmp173_ = op;
				_tmp174_ = f;
				_tmp175_ = gda_data_db_field_info_get_fkey (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = gda_data_db_field_info_foreign_key_get_update_rule (_tmp176_);
				_tmp178_ = _tmp177_;
				_tmp179_ = gda_data_db_field_info_foreign_key_rule_to_string (_tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = refs;
				_tmp182_ = g_strdup_printf ("%i", _tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = g_strconcat ("/FKEY_S/", _tmp183_, NULL);
				_tmp185_ = _tmp184_;
				_tmp186_ = g_strconcat (_tmp185_, "/FKEY_ONUPDATE", NULL);
				_tmp187_ = _tmp186_;
				gda_server_operation_set_value_at_path (_tmp173_, _tmp180_, _tmp187_, &_inner_error_);
				_g_free0 (_tmp187_);
				_g_free0 (_tmp185_);
				_g_free0 (_tmp183_);
				_g_free0 (_tmp180_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					_g_object_unref0 (op);
					return;
				}
				_tmp188_ = op;
				_tmp189_ = f;
				_tmp190_ = gda_data_db_field_info_get_fkey (_tmp189_);
				_tmp191_ = _tmp190_;
				_tmp192_ = gda_data_db_field_info_foreign_key_get_delete_rule (_tmp191_);
				_tmp193_ = _tmp192_;
				_tmp194_ = gda_data_db_field_info_foreign_key_rule_to_string (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = refs;
				_tmp197_ = g_strdup_printf ("%i", _tmp196_);
				_tmp198_ = _tmp197_;
				_tmp199_ = g_strconcat ("/FKEY_S/", _tmp198_, NULL);
				_tmp200_ = _tmp199_;
				_tmp201_ = g_strconcat (_tmp200_, "/FKEY_ONDELETE", NULL);
				_tmp202_ = _tmp201_;
				gda_server_operation_set_value_at_path (_tmp188_, _tmp195_, _tmp202_, &_inner_error_);
				_g_free0 (_tmp202_);
				_g_free0 (_tmp200_);
				_g_free0 (_tmp198_);
				_g_free0 (_tmp195_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					_g_object_unref0 (op);
					return;
				}
				_tmp203_ = refs;
				refs = _tmp203_ + 1;
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp204_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp205_ = _tmp204_;
	_tmp206_ = op;
	gda_connection_perform_operation (_tmp205_, _tmp206_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (op);
		return;
	}
	_g_object_unref0 (op);
}


static void gda_data_table_real_drop (GdaDataDbObject* base, gboolean cascade, GError** error) {
	GdaDataTable * self;
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GdaServerOperation* _tmp4_ = NULL;
	GdaServerOperation* op;
	GdaServerOperation* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (GdaDataTable*) base;
	_tmp0_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gda_server_operation_prepare_drop_table (_tmp1_, _tmp3_, &_inner_error_);
	op = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = op;
	gda_server_operation_perform_drop_table (_tmp5_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (op);
		return;
	}
	_g_object_unref0 (op);
}


static void gda_data_table_real_set_field (GdaDataDbTable* base, GdaDataDbFieldInfo* field, GError** error) {
	GdaDataTable * self;
	gboolean _tmp0_;
	GdaDataDbFieldInfo* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeHashMap* _tmp8_;
	GdaDataDbFieldInfo* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GdaDataDbFieldInfo* _tmp12_;
	GError * _inner_error_ = NULL;
	self = (GdaDataTable*) base;
	g_return_if_fail (field != NULL);
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GDA_DATA_DB_TABLE_ERROR, GDA_DATA_DB_TABLE_ERROR_READ_ONLY, "Table's definition is read only");
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = field;
	_tmp3_ = gda_data_db_field_info_get_ordinal (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ < 0) {
		gint _tmp5_;
		GdaDataDbFieldInfo* _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->_n_cols;
		self->priv->_n_cols = _tmp5_ + 1;
		_tmp6_ = field;
		_tmp7_ = self->priv->_n_cols;
		gda_data_db_field_info_set_ordinal (_tmp6_, _tmp7_);
	}
	_tmp8_ = self->_fields;
	_tmp9_ = field;
	_tmp10_ = gda_data_db_field_info_get_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = field;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
}


static GdaDataDbFieldInfo* gda_data_table_real_get_field (GdaDataDbTable* base, const gchar* name, GError** error) {
	GdaDataTable * self;
	GdaDataDbFieldInfo* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp10_;
	const gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	self = (GdaDataTable*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->_fields;
	_tmp1_ = name;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp3_ = name;
		_tmp4_ = g_strconcat ("Field '", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "' not found", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (GDA_DATA_DB_TABLE_ERROR, GDA_DATA_DB_TABLE_ERROR_FIELD, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp10_ = self->_fields;
	_tmp11_ = name;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
	result = (GdaDataDbFieldInfo*) _tmp12_;
	return result;
}


GdaDataTable* gda_data_table_construct (GType object_type) {
	GdaDataTable * self = NULL;
	self = (GdaDataTable*) g_object_new (object_type, NULL);
	return self;
}


GdaDataTable* gda_data_table_new (void) {
	return gda_data_table_construct (GDA_DATA_TYPE_TABLE);
}


static GdaConnection* gda_data_table_real_get_connection (GdaDataDbObject* base) {
	GdaConnection* result;
	GdaDataTable* self;
	GdaConnection* _tmp0_;
	self = (GdaDataTable*) base;
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static void gda_data_table_real_set_connection (GdaDataDbObject* base, GdaConnection* value) {
	GdaDataTable* self;
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	self = (GdaDataTable*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	g_object_notify ((GObject *) self, "connection");
}


static gboolean gda_data_table_real_get_update_meta (GdaDataDbObject* base) {
	gboolean result;
	GdaDataTable* self;
	gboolean _tmp0_;
	self = (GdaDataTable*) base;
	_tmp0_ = self->priv->_update_meta;
	result = _tmp0_;
	return result;
}


static void gda_data_table_real_set_update_meta (GdaDataDbObject* base, gboolean value) {
	GdaDataTable* self;
	gboolean _tmp0_;
	self = (GdaDataTable*) base;
	_tmp0_ = value;
	self->priv->_update_meta = _tmp0_;
	g_object_notify ((GObject *) self, "update-meta");
}


static const gchar* gda_data_table_real_get_name (GdaDataDbNamedObject* base) {
	const gchar* result;
	GdaDataTable* self;
	const gchar* _tmp0_;
	self = (GdaDataTable*) base;
	_tmp0_ = self->_name;
	result = _tmp0_;
	return result;
}


static void gda_data_table_real_set_name (GdaDataDbNamedObject* base, const gchar* value) {
	GdaDataTable* self;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	self = (GdaDataTable*) base;
	_tmp0_ = g_strcmp0;
	_tmp1_ = self->priv->_original_name;
	_tmp2_ = _tmp0_ ("", _tmp1_);
	if (_tmp2_ == 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = value;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->_original_name);
		self->priv->_original_name = _tmp4_;
	}
	_tmp5_ = value;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->_name);
	self->_name = _tmp6_;
	g_object_notify ((GObject *) self, "name");
}


static GdaDataDbTableTableType gda_data_table_real_get_table_type (GdaDataDbTable* base) {
	GdaDataDbTableTableType result;
	GdaDataTable* self;
	GdaDataDbTableTableType _tmp0_;
	self = (GdaDataTable*) base;
	_tmp0_ = self->_type;
	result = _tmp0_;
	return result;
}


static void gda_data_table_real_set_table_type (GdaDataDbTable* base, GdaDataDbTableTableType value) {
	GdaDataTable* self;
	GdaDataDbTableTableType _tmp0_;
	self = (GdaDataTable*) base;
	_tmp0_ = value;
	self->_type = _tmp0_;
	g_object_notify ((GObject *) self, "table-type");
}


static GeeCollection* gda_data_table_real_get_fields (GdaDataDbTable* base) {
	GeeCollection* result;
	GdaDataTable* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (GdaDataTable*) base;
	_tmp0_ = self->_fields;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GeeCollection* gda_data_table_real_get_primary_keys (GdaDataDbTable* base) {
	GeeCollection* result;
	GdaDataTable* self;
	GeeHashMap* _tmp0_;
	GeeHashMap* pk;
	GeeHashMap* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	self = (GdaDataTable*) base;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDA_DATA_TYPE_DB_FIELD_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	pk = _tmp0_;
	{
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _f_it;
		_tmp1_ = gda_data_db_table_get_fields ((GdaDataDbTable*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_f_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			GdaDataDbFieldInfo* f;
			gboolean _tmp10_ = FALSE;
			GdaDataDbFieldInfo* _tmp11_;
			GdaDataDbFieldInfoAttribute _tmp12_;
			GdaDataDbFieldInfoAttribute _tmp13_;
			gboolean _tmp17_;
			_tmp6_ = _f_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _f_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			f = (GdaDataDbFieldInfo*) _tmp9_;
			_tmp11_ = f;
			_tmp12_ = gda_data_db_field_info_get_attributes (_tmp11_);
			_tmp13_ = _tmp12_;
			if ((_tmp13_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY) {
				_tmp10_ = TRUE;
			} else {
				GdaDataDbFieldInfo* _tmp14_;
				GdaDataDbFieldInfoAttribute _tmp15_;
				GdaDataDbFieldInfoAttribute _tmp16_;
				_tmp14_ = f;
				_tmp15_ = gda_data_db_field_info_get_attributes (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp10_ = (_tmp16_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE;
			}
			_tmp17_ = _tmp10_;
			if (_tmp17_) {
				GeeHashMap* _tmp18_;
				GdaDataDbFieldInfo* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				GdaDataDbFieldInfo* _tmp22_;
				_tmp18_ = pk;
				_tmp19_ = f;
				_tmp20_ = gda_data_db_field_info_get_name (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = f;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _tmp21_, _tmp22_);
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp23_ = pk;
	_tmp24_ = gee_abstract_map_get_values ((GeeMap*) _tmp23_);
	_tmp25_ = _tmp24_;
	result = _tmp25_;
	_g_object_unref0 (pk);
	return result;
}


static GdaDataDbCatalog* gda_data_table_real_get_catalog (GdaDataDbTable* base) {
	GdaDataDbCatalog* result;
	GdaDataTable* self;
	GdaDataDbCatalog* _tmp0_;
	self = (GdaDataTable*) base;
	_tmp0_ = self->priv->_catalog;
	result = _tmp0_;
	return result;
}


static void gda_data_table_real_set_catalog (GdaDataDbTable* base, GdaDataDbCatalog* value) {
	GdaDataTable* self;
	GdaDataDbCatalog* _tmp0_;
	GdaDataDbCatalog* _tmp1_;
	self = (GdaDataTable*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_catalog);
	self->priv->_catalog = _tmp1_;
	g_object_notify ((GObject *) self, "catalog");
}


static GdaDataDbSchema* gda_data_table_real_get_schema (GdaDataDbTable* base) {
	GdaDataDbSchema* result;
	GdaDataTable* self;
	GdaDataDbSchema* _tmp0_;
	self = (GdaDataTable*) base;
	_tmp0_ = self->priv->_schema;
	result = _tmp0_;
	return result;
}


static void gda_data_table_real_set_schema (GdaDataDbTable* base, GdaDataDbSchema* value) {
	GdaDataTable* self;
	GdaDataDbSchema* _tmp0_;
	GdaDataDbSchema* _tmp1_;
	self = (GdaDataTable*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_schema);
	self->priv->_schema = _tmp1_;
	g_object_notify ((GObject *) self, "schema");
}


static GeeCollection* gda_data_table_real_get_records (GdaDataDbTable* base) {
	GeeCollection* result;
	GdaDataTable* self;
	GdaDataDbRecordCollection* _tmp15_;
	GeeCollection* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (GdaDataTable*) base;
	{
		GdaSqlBuilder* _tmp0_;
		GdaSqlBuilder* q;
		GdaSqlBuilder* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GdaSqlBuilder* _tmp4_;
		GdaSqlBuilder* _tmp5_;
		GdaStatement* _tmp6_ = NULL;
		GdaStatement* s;
		GdaConnection* _tmp7_;
		GdaConnection* _tmp8_;
		GdaStatement* _tmp9_;
		GdaDataModel* _tmp10_ = NULL;
		GdaDataModel* m;
		GdaDataModel* _tmp11_;
		GdaDataRecordCollection* _tmp12_;
		_tmp0_ = gda_sql_builder_new (GDA_SQL_STATEMENT_SELECT);
		q = _tmp0_;
		_tmp1_ = q;
		_tmp2_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self);
		_tmp3_ = _tmp2_;
		gda_sql_builder_select_add_target (_tmp1_, _tmp3_, NULL);
		_tmp4_ = q;
		gda_sql_builder_select_add_field (_tmp4_, "*", NULL, NULL);
		_tmp5_ = q;
		_tmp6_ = gda_sql_builder_get_statement (_tmp5_, &_inner_error_);
		s = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (q);
			goto __catch6_g_error;
		}
		_tmp7_ = gda_data_db_object_get_connection ((GdaDataDbObject*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = s;
		_tmp10_ = gda_connection_statement_execute_select (_tmp8_, _tmp9_, NULL, &_inner_error_);
		m = _tmp10_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (s);
			_g_object_unref0 (q);
			goto __catch6_g_error;
		}
		_tmp11_ = m;
		_tmp12_ = gda_data_record_collection_new (_tmp11_, (GdaDataDbTable*) self);
		_g_object_unref0 (self->_records);
		self->_records = (GdaDataDbRecordCollection*) _tmp12_;
		_g_object_unref0 (m);
		_g_object_unref0 (s);
		_g_object_unref0 (q);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("Table.vala:452: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp15_ = self->_records;
	_tmp16_ = _g_object_ref0 ((GeeCollection*) _tmp15_);
	result = _tmp16_;
	return result;
}


static GeeCollection* gda_data_table_real_get_depends (GdaDataDbTable* base) {
	GeeCollection* result;
	GdaDataTable* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (GdaDataTable*) base;
	_tmp0_ = self->_depends;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GeeCollection* gda_data_table_real_get_referenced (GdaDataDbTable* base) {
	GeeCollection* result;
	GdaDataTable* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (GdaDataTable*) base;
	_tmp0_ = self->_referenced;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void gda_data_table_class_init (GdaDataTableClass * klass) {
	gda_data_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GdaDataTablePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gda_data_table_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gda_data_table_set_property;
	G_OBJECT_CLASS (klass)->finalize = gda_data_table_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_CONNECTION, g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_UPDATE_META, g_param_spec_boolean ("update-meta", "update-meta", "update-meta", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_TABLE_TYPE, g_param_spec_enum ("table-type", "table-type", "table-type", GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_FIELDS, g_param_spec_object ("fields", "fields", "fields", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_PRIMARY_KEYS, g_param_spec_object ("primary-keys", "primary-keys", "primary-keys", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_CATALOG, g_param_spec_object ("catalog", "catalog", "catalog", GDA_DATA_TYPE_DB_CATALOG, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_SCHEMA, g_param_spec_object ("schema", "schema", "schema", GDA_DATA_TYPE_DB_SCHEMA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_RECORDS, g_param_spec_object ("records", "records", "records", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_DEPENDS, g_param_spec_object ("depends", "depends", "depends", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_TABLE_REFERENCED, g_param_spec_object ("referenced", "referenced", "referenced", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gda_data_table_gda_data_db_object_interface_init (GdaDataDbObjectIface * iface) {
	gda_data_table_gda_data_db_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->update = (void (*)(GdaDataDbObject*, GError**)) gda_data_table_real_update;
	iface->save = (void (*)(GdaDataDbObject*, GError**)) gda_data_table_real_save;
	iface->append = (void (*)(GdaDataDbObject*, GError**)) gda_data_table_real_append;
	iface->drop = (void (*)(GdaDataDbObject*, gboolean, GError**)) gda_data_table_real_drop;
	iface->get_connection = gda_data_table_real_get_connection;
	iface->set_connection = gda_data_table_real_set_connection;
	iface->get_update_meta = gda_data_table_real_get_update_meta;
	iface->set_update_meta = gda_data_table_real_set_update_meta;
}


static void gda_data_table_gda_data_db_named_object_interface_init (GdaDataDbNamedObjectIface * iface) {
	gda_data_table_gda_data_db_named_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = gda_data_table_real_get_name;
	iface->set_name = gda_data_table_real_set_name;
}


static void gda_data_table_gda_data_db_table_interface_init (GdaDataDbTableIface * iface) {
	gda_data_table_gda_data_db_table_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_field = (void (*)(GdaDataDbTable*, GdaDataDbFieldInfo*, GError**)) gda_data_table_real_set_field;
	iface->get_field = (GdaDataDbFieldInfo* (*)(GdaDataDbTable*, const gchar*, GError**)) gda_data_table_real_get_field;
	iface->get_table_type = gda_data_table_real_get_table_type;
	iface->set_table_type = gda_data_table_real_set_table_type;
	iface->get_fields = gda_data_table_real_get_fields;
	iface->get_primary_keys = gda_data_table_real_get_primary_keys;
	iface->get_catalog = gda_data_table_real_get_catalog;
	iface->set_catalog = gda_data_table_real_set_catalog;
	iface->get_schema = gda_data_table_real_get_schema;
	iface->set_schema = gda_data_table_real_set_schema;
	iface->get_records = gda_data_table_real_get_records;
	iface->get_depends = gda_data_table_real_get_depends;
	iface->get_referenced = gda_data_table_real_get_referenced;
}


static void gda_data_table_instance_init (GdaDataTable * self) {
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	self->priv = GDA_DATA_TABLE_GET_PRIVATE (self);
	self->priv->_read_only = FALSE;
	self->priv->_n_cols = -1;
	self->priv->_update_meta = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->_original_name = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDA_DATA_TYPE_DB_FIELD_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->_fields = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDA_DATA_TYPE_DB_TABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->_depends = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDA_DATA_TYPE_DB_TABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->_referenced = _tmp3_;
}


static void gda_data_table_finalize (GObject* obj) {
	GdaDataTable * self;
	self = GDA_DATA_TABLE (obj);
	_g_free0 (self->priv->_original_name);
	_g_free0 (self->_name);
	_g_object_unref0 (self->_records);
	_g_object_unref0 (self->_fields);
	_g_object_unref0 (self->_depends);
	_g_object_unref0 (self->_referenced);
	_g_object_unref0 (self->priv->_connection);
	_g_object_unref0 (self->priv->_catalog);
	_g_object_unref0 (self->priv->_schema);
	G_OBJECT_CLASS (gda_data_table_parent_class)->finalize (obj);
}


GType gda_data_table_get_type (void) {
	static volatile gsize gda_data_table_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gda_data_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdaDataTable), 0, (GInstanceInitFunc) gda_data_table_instance_init, NULL };
		static const GInterfaceInfo gda_data_db_object_info = { (GInterfaceInitFunc) gda_data_table_gda_data_db_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_named_object_info = { (GInterfaceInitFunc) gda_data_table_gda_data_db_named_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gda_data_db_table_info = { (GInterfaceInitFunc) gda_data_table_gda_data_db_table_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gda_data_table_type_id;
		gda_data_table_type_id = g_type_register_static (G_TYPE_OBJECT, "GdaDataTable", &g_define_type_info, 0);
		g_type_add_interface_static (gda_data_table_type_id, GDA_DATA_TYPE_DB_OBJECT, &gda_data_db_object_info);
		g_type_add_interface_static (gda_data_table_type_id, GDA_DATA_TYPE_DB_NAMED_OBJECT, &gda_data_db_named_object_info);
		g_type_add_interface_static (gda_data_table_type_id, GDA_DATA_TYPE_DB_TABLE, &gda_data_db_table_info);
		g_once_init_leave (&gda_data_table_type_id__volatile, gda_data_table_type_id);
	}
	return gda_data_table_type_id__volatile;
}


static void _vala_gda_data_table_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GdaDataTable * self;
	self = GDA_DATA_TABLE (object);
	switch (property_id) {
		case GDA_DATA_TABLE_CONNECTION:
		g_value_set_object (value, gda_data_db_object_get_connection ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_TABLE_UPDATE_META:
		g_value_set_boolean (value, gda_data_db_object_get_update_meta ((GdaDataDbObject*) self));
		break;
		case GDA_DATA_TABLE_NAME:
		g_value_set_string (value, gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) self));
		break;
		case GDA_DATA_TABLE_TABLE_TYPE:
		g_value_set_enum (value, gda_data_db_table_get_table_type ((GdaDataDbTable*) self));
		break;
		case GDA_DATA_TABLE_FIELDS:
		g_value_take_object (value, gda_data_db_table_get_fields ((GdaDataDbTable*) self));
		break;
		case GDA_DATA_TABLE_PRIMARY_KEYS:
		g_value_take_object (value, gda_data_db_table_get_primary_keys ((GdaDataDbTable*) self));
		break;
		case GDA_DATA_TABLE_CATALOG:
		g_value_set_object (value, gda_data_db_table_get_catalog ((GdaDataDbTable*) self));
		break;
		case GDA_DATA_TABLE_SCHEMA:
		g_value_set_object (value, gda_data_db_table_get_schema ((GdaDataDbTable*) self));
		break;
		case GDA_DATA_TABLE_RECORDS:
		g_value_take_object (value, gda_data_db_table_get_records ((GdaDataDbTable*) self));
		break;
		case GDA_DATA_TABLE_DEPENDS:
		g_value_take_object (value, gda_data_db_table_get_depends ((GdaDataDbTable*) self));
		break;
		case GDA_DATA_TABLE_REFERENCED:
		g_value_take_object (value, gda_data_db_table_get_referenced ((GdaDataDbTable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gda_data_table_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GdaDataTable * self;
	self = GDA_DATA_TABLE (object);
	switch (property_id) {
		case GDA_DATA_TABLE_CONNECTION:
		gda_data_db_object_set_connection ((GdaDataDbObject*) self, g_value_get_object (value));
		break;
		case GDA_DATA_TABLE_UPDATE_META:
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) self, g_value_get_boolean (value));
		break;
		case GDA_DATA_TABLE_NAME:
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) self, g_value_get_string (value));
		break;
		case GDA_DATA_TABLE_TABLE_TYPE:
		gda_data_db_table_set_table_type ((GdaDataDbTable*) self, g_value_get_enum (value));
		break;
		case GDA_DATA_TABLE_CATALOG:
		gda_data_db_table_set_catalog ((GdaDataDbTable*) self, g_value_get_object (value));
		break;
		case GDA_DATA_TABLE_SCHEMA:
		gda_data_db_table_set_schema ((GdaDataDbTable*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



