/* CheckTable.c generated by valac 0.16.0, the Vala compiler
 * generated from CheckTable.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata Unit Tests
 * Copyright (C) Daniel Espinosa Ortiz 2012 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/data/libgdadata.h>
#include <libgda/libgda.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define CHECK_TYPE_TESTS (check_tests_get_type ())
#define CHECK_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_TESTS, CheckTests))
#define CHECK_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_TESTS, CheckTestsClass))
#define CHECK_IS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_TESTS))
#define CHECK_IS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_TESTS))
#define CHECK_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_TESTS, CheckTestsClass))

typedef struct _CheckTests CheckTests;
typedef struct _CheckTestsClass CheckTestsClass;
typedef struct _CheckTestsPrivate CheckTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _gda_data_db_field_info_foreign_key_unref0(var) ((var == NULL) ? NULL : (var = (gda_data_db_field_info_foreign_key_unref (var), NULL)))

struct _CheckTests {
	GObject parent_instance;
	CheckTestsPrivate * priv;
	GdaDataDbTable* table;
};

struct _CheckTestsClass {
	GObjectClass parent_class;
};

struct _CheckTestsPrivate {
	GdaConnection* _connection;
};


static gpointer check_tests_parent_class = NULL;

GType check_tests_get_type (void) G_GNUC_CONST;
#define CHECK_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHECK_TYPE_TESTS, CheckTestsPrivate))
enum  {
	CHECK_TESTS_DUMMY_PROPERTY,
	CHECK_TESTS_CONNECTION
};
static CheckTests* check_tests_new (void);
static CheckTests* check_tests_construct (GType object_type);
void check_tests_set_connection (CheckTests* self, GdaConnection* value);
GdaConnection* check_tests_get_connection (CheckTests* self);
static void check_tests_init_pg (CheckTests* self, GError** error);
static void check_tests_Init_sqlite (CheckTests* self, GError** error);
void check_tests_init (CheckTests* self, GError** error);
gint check_tests_update (CheckTests* self, GError** error);
gint check_tests_fields (CheckTests* self, GError** error);
gint check_tests_records (CheckTests* self, GError** error);
gint check_tests_append (CheckTests* self, GError** error);
static void _vala_GValue_free (GValue* self);
gint check_tests_save (CheckTests* self, GError** error);
gint check_tests_main (gchar** args, int args_length1);
static void check_tests_finalize (GObject* obj);
static void _vala_check_tests_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_check_tests_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static CheckTests* check_tests_construct (GType object_type) {
	CheckTests * self = NULL;
	GError * _inner_error_ = NULL;
	self = (CheckTests*) g_object_new (object_type, NULL);
	{
		gboolean usepg;
		gboolean _tmp12_;
		g_unlink ("table.db");
		usepg = FALSE;
		{
			GdaConnection* _tmp0_ = NULL;
			GdaConnection* _tmp1_;
			GdaConnection* _tmp2_;
			GdaConnection* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp0_ = gda_connection_open_from_string ("PostgreSQL", "DB_NAME=test", NULL, GDA_CONNECTION_OPTIONS_NONE, &_inner_error_);
			_tmp1_ = _tmp0_;
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			_tmp2_ = _tmp1_;
			check_tests_set_connection (self, _tmp2_);
			_g_object_unref0 (_tmp2_);
			_tmp3_ = self->priv->_connection;
			_tmp4_ = gda_connection_is_opened (_tmp3_);
			if (_tmp4_) {
				FILE* _tmp5_;
				usepg = TRUE;
				_tmp5_ = stdout;
				fprintf (_tmp5_, "Using PostgreSQL provider. Creating Database...\n");
				check_tests_init_pg (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			_tmp8_ = g_strconcat ("Not using PostgreSQL provider. Message: ", _tmp7_, NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
			_tmp11_ = _tmp10_;
			g_message ("CheckTable.vala:45: %s", _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp12_ = usepg;
		if (!_tmp12_) {
			{
				GdaConnection* _tmp13_ = NULL;
				GdaConnection* _tmp14_;
				GdaConnection* _tmp15_;
				GdaConnection* _tmp16_;
				gboolean _tmp17_ = FALSE;
				_tmp13_ = gda_connection_open_from_string ("SQLite", "DB_DIR=.;DB_NAME=table", NULL, GDA_CONNECTION_OPTIONS_NONE, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
				_tmp15_ = _tmp14_;
				check_tests_set_connection (self, _tmp15_);
				_g_object_unref0 (_tmp15_);
				_tmp16_ = self->priv->_connection;
				_tmp17_ = gda_connection_is_opened (_tmp16_);
				if (_tmp17_) {
					FILE* _tmp18_;
					_tmp18_ = stdout;
					fprintf (_tmp18_, "Using SQLite provider. Creating Database...\n");
					check_tests_Init_sqlite (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch2_g_error;
					}
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally2:
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = g_strconcat ("Couln't initalize database...\nERROR: ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "\n", NULL);
		_tmp24_ = _tmp23_;
		g_warning ("CheckTable.vala:62: %s", _tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static CheckTests* check_tests_new (void) {
	return check_tests_construct (CHECK_TYPE_TESTS);
}


static void check_tests_init_pg (CheckTests* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		FILE* _tmp8_;
		GdaConnection* _tmp9_;
		GdaConnection* _tmp10_;
		GdaConnection* _tmp11_;
		{
			GdaConnection* _tmp0_;
			_tmp0_ = self->priv->_connection;
			gda_connection_execute_non_select_command (_tmp0_, "DROP TABLE IF EXISTS company CASCADE", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FILE* _tmp1_;
			GError* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = stdout;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = g_strconcat ("Error on dopping table company: ", _tmp3_, NULL);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat (_tmp5_, "\n", NULL);
			_tmp7_ = _tmp6_;
			fprintf (_tmp1_, "%s", _tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp8_ = stdout;
		fprintf (_tmp8_, "Creating table 'company'...\n");
		_tmp9_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp9_, "CREATE TABLE company (id serial PRIMARY KEY, " "name text, responsability text)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp10_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO company (name, responsability) " "VALUES (\'Telcsa\', \'Programing\')", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp11_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp11_, "INSERT INTO company (name, responsability) " "VALUES (\'Viasa\', \'Accessories\')", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stdout;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strconcat ("Error on Create company table: ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "\n", NULL);
		_tmp18_ = _tmp17_;
		fprintf (_tmp12_, "%s", _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		FILE* _tmp27_;
		GdaConnection* _tmp28_;
		GdaConnection* _tmp29_;
		GdaConnection* _tmp30_;
		GdaConnection* _tmp31_;
		{
			GdaConnection* _tmp19_;
			_tmp19_ = self->priv->_connection;
			gda_connection_execute_non_select_command (_tmp19_, "DROP TABLE IF EXISTS customer CASCADE", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch6_g_error;
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* e = NULL;
			FILE* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = stdout;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			_tmp23_ = g_strconcat ("Error on dopping table customer: ", _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
			_tmp26_ = _tmp25_;
			fprintf (_tmp20_, "%s", _tmp26_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_g_error_free0 (e);
		}
		__finally6:
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp27_ = stdout;
		fprintf (_tmp27_, "Creating table 'customer'...\n");
		_tmp28_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp28_, "CREATE TABLE customer (id serial PRIMARY KEY, " "name text UNIQUE," " city text DEFAULT \'New Yield\'," " company integer REFERENCES company (id) ON DELETE SET NULL ON UPDATE " \
"CASCADE)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp29_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp29_, "INSERT INTO customer (name, city, company) " "VALUES (\'Daniel\', \'Mexico\', 1)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp30_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp30_, "INSERT INTO customer (name, city) VALUES " "(\'Jhon\', \'Springfield\')", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp31_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp31_, "INSERT INTO customer (name) VALUES (\'Jack\')", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp32_;
		GError* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = stdout;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		_tmp35_ = g_strconcat ("Error on Create customer table: ", _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp36_, "\n", NULL);
		_tmp38_ = _tmp37_;
		fprintf (_tmp32_, "%s", _tmp38_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		FILE* _tmp47_;
		GdaConnection* _tmp48_;
		GdaConnection* _tmp49_;
		GdaConnection* _tmp50_;
		GdaConnection* _tmp51_;
		{
			GdaConnection* _tmp39_;
			_tmp39_ = self->priv->_connection;
			gda_connection_execute_non_select_command (_tmp39_, "DROP TABLE IF EXISTS salary CASCADE", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch8_g_error;
			}
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* e = NULL;
			FILE* _tmp40_;
			GError* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp40_ = stdout;
			_tmp41_ = e;
			_tmp42_ = _tmp41_->message;
			_tmp43_ = g_strconcat ("Error on dopping table salary: ", _tmp42_, NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strconcat (_tmp44_, "\n", NULL);
			_tmp46_ = _tmp45_;
			fprintf (_tmp40_, "%s", _tmp46_);
			_g_free0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_error_free0 (e);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp47_ = stdout;
		fprintf (_tmp47_, "Creating table 'salary'...\n");
		_tmp48_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp48_, "CREATE TABLE salary (id serial PRIMARY KEY," " customer integer REFERENCES customer (id) " " ON DELETE CASCADE ON UPDATE CASCADE," " income float DEFAULT 10.0)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp49_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp49_, "INSERT INTO salary (customer, income) VALUES " " (1,55.0)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp50_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp50_, "INSERT INTO salary (customer, income) VALUES " " (2,65.0)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp51_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp51_, "INSERT INTO salary (customer) VALUES (3)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp52_;
		GError* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp52_ = stdout;
		_tmp53_ = e;
		_tmp54_ = _tmp53_->message;
		_tmp55_ = g_strconcat ("Error on Create company table: ", _tmp54_, NULL);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat (_tmp56_, "\n", NULL);
		_tmp58_ = _tmp57_;
		fprintf (_tmp52_, "%s", _tmp58_);
		_g_free0 (_tmp58_);
		_g_free0 (_tmp56_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void check_tests_Init_sqlite (CheckTests* self, GError** error) {
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	GdaConnection* _tmp2_;
	FILE* _tmp3_;
	GdaConnection* _tmp4_;
	GdaConnection* _tmp5_;
	GdaConnection* _tmp6_;
	GdaConnection* _tmp7_;
	FILE* _tmp8_;
	GdaConnection* _tmp9_;
	GdaConnection* _tmp10_;
	GdaConnection* _tmp11_;
	GdaConnection* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp0_, "CREATE TABLE company (id int PRIMARY KEY, name string, responsability " \
"string)", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp1_, "INSERT INTO company (id, name, responsability) VALUES (1, \"Telcsa\", " \
"\"Programing\")", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp2_, "INSERT INTO company (id, name, responsability) VALUES (2, \"Viasa\", \"" \
"Accessories\")", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Creating table 'customer'...\n");
	_tmp4_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp4_, "CREATE TABLE customer (id integer PRIMARY KEY AUTOINCREMENT, name stri" \
"ng UNIQUE," " city string DEFAULT \'New Yield\'," " company integer REFERENCES company (id) ON DELETE SET NULL ON UPDATE " \
"CASCADE)", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp5_, "INSERT INTO customer (id, name, city, company) VALUES (1, \"Daniel\", " \
"\"Mexico\", 1)", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp6_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp6_, "INSERT INTO customer (id, name, city) VALUES (2, \"Jhon\", \"Springfie" \
"ld\")", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp7_, "INSERT INTO customer (id, name) VALUES (3, \"Jack\")", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp8_ = stdout;
	fprintf (_tmp8_, "Creating table 'salary'...\n");
	_tmp9_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp9_, "CREATE TABLE salary (id integer PRIMARY KEY AUTOINCREMENT," " customer integer REFERENCES customer (id) ON DELETE CASCADE ON UPDATE" \
" CASCADE," " income float DEFAULT 10.0)", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp10_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO salary (id, customer, income) VALUES (1,1,55.0)", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp11_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp11_, "INSERT INTO salary (id, customer, income) VALUES (2,2,65.0)", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp12_ = self->priv->_connection;
	gda_connection_execute_non_select_command (_tmp12_, "INSERT INTO salary (customer) VALUES (3)", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void check_tests_init (CheckTests* self, GError** error) {
	FILE* _tmp0_;
	GdaDataTable* _tmp1_;
	FILE* _tmp2_;
	GdaDataDbTable* _tmp3_;
	GdaConnection* _tmp4_;
	FILE* _tmp5_;
	GdaDataDbTable* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\nCreating new table\n");
	_tmp1_ = gda_data_table_new ();
	_g_object_unref0 (self->table);
	self->table = (GdaDataDbTable*) _tmp1_;
	_tmp2_ = stdout;
	fprintf (_tmp2_, "Setting connection\n");
	_tmp3_ = self->table;
	_tmp4_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp3_, _tmp4_);
	_tmp5_ = stdout;
	fprintf (_tmp5_, "Setting name\n");
	_tmp6_ = self->table;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp6_, "customer");
}


gint check_tests_update (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	FILE* _tmp1_;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: GdaData.DbTable -- Update\n");
	fails = 0;
	_tmp1_ = stdout;
	fprintf (_tmp1_, ">>>>>> Updating meta information\n");
	{
		GdaDataDbTable* _tmp2_;
		GdaDataDbTable* _tmp3_;
		_tmp2_ = self->table;
		gda_data_db_object_set_update_meta ((GdaDataDbObject*) _tmp2_, TRUE);
		_tmp3_ = self->table;
		gda_data_db_object_update ((GdaDataDbObject*) _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		gint _tmp4_;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = fails;
		fails = _tmp4_ + 1;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strconcat ("Error on Updating: ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
		_tmp11_ = _tmp10_;
		fprintf (_tmp5_, "%s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp12_ = fails;
	if (_tmp12_ > 0) {
		FILE* _tmp13_;
		_tmp13_ = stdout;
		fprintf (_tmp13_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp14_;
		_tmp14_ = stdout;
		fprintf (_tmp14_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gint check_tests_fields (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	GeeHashMap* _tmp1_;
	GeeHashMap* f;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp27_;
	GeeHashMap* f2;
	GeeHashMap* _tmp28_;
	GeeHashMap* _tmp29_;
	GeeHashMap* _tmp51_;
	GeeHashMap* f3;
	GeeHashMap* _tmp52_;
	GeeHashMap* _tmp74_;
	GeeHashMap* f4;
	GeeHashMap* _tmp75_;
	gint found;
	GdaDataFieldInfo* _tmp139_;
	GdaDataFieldInfo* fl;
	GdaDataFieldInfo* _tmp140_;
	GCompareFunc _tmp141_;
	GdaDataFieldInfo* _tmp142_;
	const gchar* _tmp143_;
	const gchar* _tmp144_;
	gint _tmp145_ = 0;
	GdaDataFieldInfo* _tmp155_;
	GCompareFunc _tmp156_;
	GdaDataFieldInfo* _tmp157_;
	const gchar* _tmp158_;
	const gchar* _tmp159_;
	gint _tmp160_ = 0;
	gint _tmp170_;
	gint _tmp173_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - Fields...\n");
	fails = 0;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	f = _tmp1_;
	_tmp2_ = f;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, "id", GINT_TO_POINTER (0));
	_tmp3_ = f;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, "name", GINT_TO_POINTER (0));
	_tmp4_ = f;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, "city", GINT_TO_POINTER (0));
	_tmp5_ = f;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, "company", GINT_TO_POINTER (0));
	{
		GdaDataDbTable* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _tmp11_;
		GeeIterator* _fi_it;
		_tmp6_ = self->table;
		_tmp7_ = gda_data_db_table_get_fields (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_fi_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gboolean _tmp13_ = FALSE;
			GeeIterator* _tmp14_;
			gpointer _tmp15_ = NULL;
			GdaDataDbFieldInfo* fi;
			GeeHashMap* _tmp16_;
			GeeSet* _tmp17_;
			GeeSet* _tmp18_;
			GeeSet* _tmp19_;
			GdaDataDbFieldInfo* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_;
			_tmp12_ = _fi_it;
			_tmp13_ = gee_iterator_next (_tmp12_);
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = _fi_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			fi = (GdaDataDbFieldInfo*) _tmp15_;
			_tmp16_ = f;
			_tmp17_ = gee_abstract_map_get_keys ((GeeMap*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp20_ = fi;
			_tmp21_ = gda_data_db_field_info_get_name (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = gee_collection_contains ((GeeCollection*) _tmp19_, _tmp22_);
			_tmp24_ = !_tmp23_;
			_g_object_unref0 (_tmp19_);
			if (_tmp24_) {
				gint _tmp25_;
				FILE* _tmp26_;
				_tmp25_ = fails;
				fails = _tmp25_ + 1;
				_tmp26_ = stdout;
				fprintf (_tmp26_, ">>>>>>>> Check Fields names:  FAIL\n");
				_g_object_unref0 (fi);
				break;
			}
			_g_object_unref0 (fi);
		}
		_g_object_unref0 (_fi_it);
	}
	_tmp27_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	f2 = _tmp27_;
	_tmp28_ = f2;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, "id", GINT_TO_POINTER (0));
	_tmp29_ = f2;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, "name", GINT_TO_POINTER (0));
	{
		GdaDataDbTable* _tmp30_;
		GeeCollection* _tmp31_;
		GeeCollection* _tmp32_;
		GeeCollection* _tmp33_;
		GeeIterator* _tmp34_ = NULL;
		GeeIterator* _tmp35_;
		GeeIterator* _fi2_it;
		_tmp30_ = self->table;
		_tmp31_ = gda_data_db_table_get_primary_keys (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_;
		_tmp34_ = gee_iterable_iterator ((GeeIterable*) _tmp33_);
		_tmp35_ = _tmp34_;
		_g_object_unref0 (_tmp33_);
		_fi2_it = _tmp35_;
		while (TRUE) {
			GeeIterator* _tmp36_;
			gboolean _tmp37_ = FALSE;
			GeeIterator* _tmp38_;
			gpointer _tmp39_ = NULL;
			GdaDataDbFieldInfo* fi2;
			GeeHashMap* _tmp40_;
			GeeSet* _tmp41_;
			GeeSet* _tmp42_;
			GeeSet* _tmp43_;
			GdaDataDbFieldInfo* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			gboolean _tmp47_ = FALSE;
			gboolean _tmp48_;
			_tmp36_ = _fi2_it;
			_tmp37_ = gee_iterator_next (_tmp36_);
			if (!_tmp37_) {
				break;
			}
			_tmp38_ = _fi2_it;
			_tmp39_ = gee_iterator_get (_tmp38_);
			fi2 = (GdaDataDbFieldInfo*) _tmp39_;
			_tmp40_ = f2;
			_tmp41_ = gee_abstract_map_get_keys ((GeeMap*) _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = _tmp42_;
			_tmp44_ = fi2;
			_tmp45_ = gda_data_db_field_info_get_name (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = gee_collection_contains ((GeeCollection*) _tmp43_, _tmp46_);
			_tmp48_ = !_tmp47_;
			_g_object_unref0 (_tmp43_);
			if (_tmp48_) {
				FILE* _tmp49_;
				gint _tmp50_;
				_tmp49_ = stdout;
				fprintf (_tmp49_, ">>>>>>>> Check Primary Keys Fields:  FAIL\n");
				_tmp50_ = fails;
				fails = _tmp50_ + 1;
				_g_object_unref0 (fi2);
				break;
			}
			_g_object_unref0 (fi2);
		}
		_g_object_unref0 (_fi2_it);
	}
	_tmp51_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	f3 = _tmp51_;
	_tmp52_ = f3;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp52_, "company", GINT_TO_POINTER (0));
	{
		GdaDataDbTable* _tmp53_;
		GeeCollection* _tmp54_;
		GeeCollection* _tmp55_;
		GeeCollection* _tmp56_;
		GeeIterator* _tmp57_ = NULL;
		GeeIterator* _tmp58_;
		GeeIterator* _t_it;
		_tmp53_ = self->table;
		_tmp54_ = gda_data_db_table_get_depends (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = _tmp55_;
		_tmp57_ = gee_iterable_iterator ((GeeIterable*) _tmp56_);
		_tmp58_ = _tmp57_;
		_g_object_unref0 (_tmp56_);
		_t_it = _tmp58_;
		while (TRUE) {
			GeeIterator* _tmp59_;
			gboolean _tmp60_ = FALSE;
			GeeIterator* _tmp61_;
			gpointer _tmp62_ = NULL;
			GdaDataDbTable* t;
			GeeHashMap* _tmp63_;
			GeeSet* _tmp64_;
			GeeSet* _tmp65_;
			GeeSet* _tmp66_;
			GdaDataDbTable* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			gboolean _tmp70_ = FALSE;
			gboolean _tmp71_;
			_tmp59_ = _t_it;
			_tmp60_ = gee_iterator_next (_tmp59_);
			if (!_tmp60_) {
				break;
			}
			_tmp61_ = _t_it;
			_tmp62_ = gee_iterator_get (_tmp61_);
			t = (GdaDataDbTable*) _tmp62_;
			_tmp63_ = f3;
			_tmp64_ = gee_abstract_map_get_keys ((GeeMap*) _tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = _tmp65_;
			_tmp67_ = t;
			_tmp68_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = gee_collection_contains ((GeeCollection*) _tmp66_, _tmp69_);
			_tmp71_ = !_tmp70_;
			_g_object_unref0 (_tmp66_);
			if (_tmp71_) {
				FILE* _tmp72_;
				gint _tmp73_;
				_tmp72_ = stdout;
				fprintf (_tmp72_, ">>>>>>>> Check Table Depends:  FAIL\n");
				_tmp73_ = fails;
				fails = _tmp73_ + 1;
				_g_object_unref0 (t);
				break;
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	_tmp74_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	f4 = _tmp74_;
	_tmp75_ = f4;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp75_, "salary", GINT_TO_POINTER (0));
	{
		GdaDataDbTable* _tmp76_;
		GeeCollection* _tmp77_;
		GeeCollection* _tmp78_;
		GeeCollection* _tmp79_;
		GeeIterator* _tmp80_ = NULL;
		GeeIterator* _tmp81_;
		GeeIterator* _t2_it;
		_tmp76_ = self->table;
		_tmp77_ = gda_data_db_table_get_referenced (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = _tmp78_;
		_tmp80_ = gee_iterable_iterator ((GeeIterable*) _tmp79_);
		_tmp81_ = _tmp80_;
		_g_object_unref0 (_tmp79_);
		_t2_it = _tmp81_;
		while (TRUE) {
			GeeIterator* _tmp82_;
			gboolean _tmp83_ = FALSE;
			GeeIterator* _tmp84_;
			gpointer _tmp85_ = NULL;
			GdaDataDbTable* t2;
			GeeHashMap* _tmp86_;
			GeeSet* _tmp87_;
			GeeSet* _tmp88_;
			GeeSet* _tmp89_;
			GdaDataDbTable* _tmp90_;
			const gchar* _tmp91_;
			const gchar* _tmp92_;
			gboolean _tmp93_ = FALSE;
			gboolean _tmp94_;
			_tmp82_ = _t2_it;
			_tmp83_ = gee_iterator_next (_tmp82_);
			if (!_tmp83_) {
				break;
			}
			_tmp84_ = _t2_it;
			_tmp85_ = gee_iterator_get (_tmp84_);
			t2 = (GdaDataDbTable*) _tmp85_;
			_tmp86_ = f4;
			_tmp87_ = gee_abstract_map_get_keys ((GeeMap*) _tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = _tmp88_;
			_tmp90_ = t2;
			_tmp91_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = gee_collection_contains ((GeeCollection*) _tmp89_, _tmp92_);
			_tmp94_ = !_tmp93_;
			_g_object_unref0 (_tmp89_);
			if (_tmp94_) {
				FILE* _tmp95_;
				gint _tmp96_;
				_tmp95_ = stdout;
				fprintf (_tmp95_, ">>>>>>>> Check Table Referenced by:  FAIL\n");
				_tmp96_ = fails;
				fails = _tmp96_ + 1;
				_g_object_unref0 (t2);
				break;
			}
			_g_object_unref0 (t2);
		}
		_g_object_unref0 (_t2_it);
	}
	found = 0;
	{
		GdaDataDbTable* _tmp97_;
		GeeCollection* _tmp98_;
		GeeCollection* _tmp99_;
		GeeCollection* _tmp100_;
		GeeIterator* _tmp101_ = NULL;
		GeeIterator* _tmp102_;
		GeeIterator* _fi3_it;
		_tmp97_ = self->table;
		_tmp98_ = gda_data_db_table_get_fields (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = _tmp99_;
		_tmp101_ = gee_iterable_iterator ((GeeIterable*) _tmp100_);
		_tmp102_ = _tmp101_;
		_g_object_unref0 (_tmp100_);
		_fi3_it = _tmp102_;
		while (TRUE) {
			GeeIterator* _tmp103_;
			gboolean _tmp104_ = FALSE;
			GeeIterator* _tmp105_;
			gpointer _tmp106_ = NULL;
			GdaDataDbFieldInfo* fi3;
			gboolean _tmp107_ = FALSE;
			GdaDataDbFieldInfo* _tmp108_;
			GdaDataDbFieldInfoAttribute _tmp109_;
			GdaDataDbFieldInfoAttribute _tmp110_;
			gboolean _tmp114_;
			_tmp103_ = _fi3_it;
			_tmp104_ = gee_iterator_next (_tmp103_);
			if (!_tmp104_) {
				break;
			}
			_tmp105_ = _fi3_it;
			_tmp106_ = gee_iterator_get (_tmp105_);
			fi3 = (GdaDataDbFieldInfo*) _tmp106_;
			_tmp108_ = fi3;
			_tmp109_ = gda_data_db_field_info_get_attributes (_tmp108_);
			_tmp110_ = _tmp109_;
			if ((_tmp110_ & GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT) == GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT) {
				GdaDataDbFieldInfo* _tmp111_;
				const gchar* _tmp112_;
				const gchar* _tmp113_;
				_tmp111_ = fi3;
				_tmp112_ = gda_data_db_field_info_get_name (_tmp111_);
				_tmp113_ = _tmp112_;
				_tmp107_ = g_strcmp0 (_tmp113_, "city") == 0;
			} else {
				_tmp107_ = FALSE;
			}
			_tmp114_ = _tmp107_;
			if (_tmp114_) {
				gint _tmp115_;
				GdaDataDbTable* _tmp116_;
				GdaConnection* _tmp117_;
				GdaConnection* _tmp118_;
				GdaServerProvider* _tmp119_ = NULL;
				GdaDataDbTable* _tmp120_;
				GdaConnection* _tmp121_;
				GdaConnection* _tmp122_;
				GdaDataHandler* _tmp123_ = NULL;
				GdaDataHandler* _tmp124_;
				GdaDataHandler* dh;
				GCompareFunc _tmp125_;
				GdaDataDbFieldInfo* _tmp126_;
				GValue* _tmp127_;
				GValue* _tmp128_;
				gint _tmp129_ = 0;
				_tmp115_ = found;
				found = _tmp115_ + 1;
				_tmp116_ = self->table;
				_tmp117_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp116_);
				_tmp118_ = _tmp117_;
				_tmp119_ = gda_connection_get_provider (_tmp118_);
				_tmp120_ = self->table;
				_tmp121_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp120_);
				_tmp122_ = _tmp121_;
				_tmp123_ = gda_server_provider_get_data_handler_g_type (_tmp119_, _tmp122_, G_TYPE_STRING);
				_tmp124_ = _g_object_ref0 (_tmp123_);
				dh = _tmp124_;
				_tmp125_ = g_strcmp0;
				_tmp126_ = fi3;
				_tmp127_ = gda_data_db_field_info_get_default_value (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _tmp125_ (g_value_get_string (_tmp128_), "New Yield");
				if (_tmp129_ != 0) {
					gint _tmp130_;
					FILE* _tmp131_;
					GdaDataDbFieldInfo* _tmp132_;
					GValue* _tmp133_;
					GValue* _tmp134_;
					gchar* _tmp135_;
					gchar* _tmp136_;
					gchar* _tmp137_;
					gchar* _tmp138_;
					_tmp130_ = fails;
					fails = _tmp130_ + 1;
					_tmp131_ = stdout;
					_tmp132_ = fi3;
					_tmp133_ = gda_data_db_field_info_get_default_value (_tmp132_);
					_tmp134_ = _tmp133_;
					_tmp135_ = g_strconcat (">>>>>>>> Default Value No Match. Holded \'", g_value_get_string (_tmp134_), NULL);
					_tmp136_ = _tmp135_;
					_tmp137_ = g_strconcat (_tmp136_, "\' but Expected \'New Yield\' : FAIL\n", NULL);
					_tmp138_ = _tmp137_;
					fprintf (_tmp131_, "%s", _tmp138_);
					_g_free0 (_tmp138_);
					_g_free0 (_tmp136_);
				}
				_g_object_unref0 (dh);
				_g_object_unref0 (fi3);
				break;
			}
			_g_object_unref0 (fi3);
		}
		_g_object_unref0 (_fi3_it);
	}
	_tmp139_ = gda_data_field_info_new ();
	fl = _tmp139_;
	_tmp140_ = fl;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp140_, "FieldName1");
	_tmp141_ = g_strcmp0;
	_tmp142_ = fl;
	_tmp143_ = gda_data_db_field_info_get_name ((GdaDataDbFieldInfo*) _tmp142_);
	_tmp144_ = _tmp143_;
	_tmp145_ = _tmp141_ (_tmp144_, "FieldName1");
	if (_tmp145_ != 0) {
		gint _tmp146_;
		FILE* _tmp147_;
		GdaDataFieldInfo* _tmp148_;
		const gchar* _tmp149_;
		const gchar* _tmp150_;
		gchar* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		gchar* _tmp154_;
		_tmp146_ = fails;
		fails = _tmp146_ + 1;
		_tmp147_ = stdout;
		_tmp148_ = fl;
		_tmp149_ = gda_data_db_field_info_get_name ((GdaDataDbFieldInfo*) _tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = g_strconcat (">>>>>>>> Default Value No Match. Holded \'", (const gchar*) _tmp150_, NULL);
		_tmp152_ = _tmp151_;
		_tmp153_ = g_strconcat (_tmp152_, "\' But Expected \"FieldName1\" : FAIL\n", NULL);
		_tmp154_ = _tmp153_;
		fprintf (_tmp147_, "%s", _tmp154_);
		_g_free0 (_tmp154_);
		_g_free0 (_tmp152_);
	}
	_tmp155_ = fl;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp155_, "NewFieldName");
	_tmp156_ = g_strcmp0;
	_tmp157_ = fl;
	_tmp158_ = gda_data_db_field_info_get_name ((GdaDataDbFieldInfo*) _tmp157_);
	_tmp159_ = _tmp158_;
	_tmp160_ = _tmp156_ (_tmp159_, "NewFieldName");
	if (_tmp160_ != 0) {
		gint _tmp161_;
		FILE* _tmp162_;
		GdaDataFieldInfo* _tmp163_;
		const gchar* _tmp164_;
		const gchar* _tmp165_;
		gchar* _tmp166_;
		gchar* _tmp167_;
		gchar* _tmp168_;
		gchar* _tmp169_;
		_tmp161_ = fails;
		fails = _tmp161_ + 1;
		_tmp162_ = stdout;
		_tmp163_ = fl;
		_tmp164_ = gda_data_db_field_info_get_name ((GdaDataDbFieldInfo*) _tmp163_);
		_tmp165_ = _tmp164_;
		_tmp166_ = g_strconcat (">>>>>>>> Default Value No Match. Holded \'", (const gchar*) _tmp165_, NULL);
		_tmp167_ = _tmp166_;
		_tmp168_ = g_strconcat (_tmp167_, "\' But Expected \"NewFieldName\" : FAIL\n", NULL);
		_tmp169_ = _tmp168_;
		fprintf (_tmp162_, "%s", _tmp169_);
		_g_free0 (_tmp169_);
		_g_free0 (_tmp167_);
	}
	_tmp170_ = found;
	if (_tmp170_ == 0) {
		FILE* _tmp171_;
		gint _tmp172_;
		_tmp171_ = stdout;
		fprintf (_tmp171_, ">>>>>>>> Check Default Values: FAIL\n");
		_tmp172_ = fails;
		fails = _tmp172_ + 1;
	}
	_tmp173_ = fails;
	if (_tmp173_ > 0) {
		FILE* _tmp174_;
		_tmp174_ = stdout;
		fprintf (_tmp174_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp175_;
		_tmp175_ = stdout;
		fprintf (_tmp175_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	_g_object_unref0 (fl);
	_g_object_unref0 (f4);
	_g_object_unref0 (f3);
	_g_object_unref0 (f2);
	_g_object_unref0 (f);
	return result;
}


gint check_tests_records (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	gint _tmp17_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - Records...\n");
	fails = 0;
	{
		GdaDataDbTable* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _r_it;
		_tmp1_ = self->table;
		_tmp2_ = gda_data_db_table_get_records (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_r_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			GdaDataDbRecord* r;
			FILE* _tmp11_;
			GdaDataDbRecord* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp7_ = _r_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _r_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			r = (GdaDataDbRecord*) _tmp10_;
			_tmp11_ = stdout;
			_tmp12_ = r;
			_tmp13_ = gda_data_db_record_to_string (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_tmp14_, "\n", NULL);
			_tmp16_ = _tmp15_;
			fprintf (_tmp11_, "%s", _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_it);
	}
	_tmp17_ = fails;
	if (_tmp17_ > 0) {
		FILE* _tmp18_;
		_tmp18_ = stdout;
		fprintf (_tmp18_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp19_;
		_tmp19_ = stdout;
		fprintf (_tmp19_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	return result;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


gint check_tests_append (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	GdaDataTable* _tmp1_;
	GdaDataTable* t;
	GdaDataTable* _tmp2_;
	GdaDataTable* _tmp3_;
	GdaConnection* _tmp4_;
	GdaDataFieldInfo* _tmp24_;
	GdaDataFieldInfo* field;
	GdaDataFieldInfo* _tmp25_;
	GdaDataFieldInfo* _tmp26_;
	GdaDataFieldInfo* _tmp27_;
	GdaDataTable* _tmp28_;
	GdaDataFieldInfo* _tmp29_;
	GdaDataFieldInfo* _tmp30_;
	GdaDataFieldInfo* field1;
	GdaDataFieldInfo* _tmp31_;
	GdaDataFieldInfo* _tmp32_;
	GdaDataFieldInfo* _tmp33_;
	GdaDataTable* _tmp34_;
	GdaDataFieldInfo* _tmp35_;
	GdaDataFieldInfo* _tmp36_;
	GdaDataFieldInfo* field2;
	GdaDataFieldInfo* _tmp37_;
	GdaDataFieldInfo* _tmp38_;
	GdaDataFieldInfo* _tmp39_;
	GValue* _tmp40_ = NULL;
	GdaDataDbFieldInfoForeignKey* _tmp41_;
	GdaDataDbFieldInfoForeignKey* fk;
	GdaDataTable* _tmp42_;
	GdaDataTable* rt;
	GdaDataTable* _tmp43_;
	GdaDataDbFieldInfoForeignKey* _tmp44_;
	GdaDataTable* _tmp45_;
	GdaDataDbFieldInfoForeignKey* _tmp46_;
	GeeArrayList* _tmp47_;
	GeeArrayList* _tmp48_;
	GdaDataDbFieldInfoForeignKey* _tmp49_;
	GdaDataDbFieldInfoForeignKey* _tmp50_;
	GdaDataFieldInfo* _tmp51_;
	GdaDataDbFieldInfoForeignKey* _tmp52_;
	GdaDataTable* _tmp53_;
	GdaDataFieldInfo* _tmp54_;
	FILE* _tmp55_;
	gboolean f;
	GdaDataRecord* _tmp112_;
	GdaDataRecord* r;
	GdaDataRecord* _tmp113_;
	GdaConnection* _tmp114_;
	GdaDataTable* _tmp115_;
	GdaDataTable* nt;
	GdaDataTable* _tmp116_;
	GdaDataRecord* _tmp117_;
	GdaDataTable* _tmp118_;
	GdaDataRecord* _tmp119_;
	GValue* _tmp120_ = NULL;
	GdaDataRecord* _tmp121_;
	GdaConnection* _tmp122_;
	GdaDataModel* _tmp123_ = NULL;
	GdaDataModel* m2;
	gboolean f2;
	GdaDataModel* _tmp124_;
	gint _tmp125_ = 0;
	GdaDataModel* _tmp126_;
	GValue* _tmp127_ = NULL;
	GValue* _tmp128_;
	gint id;
	gint _tmp129_;
	GdaDataModel* _tmp130_;
	GValue* _tmp131_ = NULL;
	GValue* _tmp132_;
	gchar* _tmp133_;
	gchar* name;
	GCompareFunc _tmp134_;
	const gchar* _tmp135_;
	gint _tmp136_ = 0;
	GdaDataModel* _tmp137_;
	GValue* _tmp138_ = NULL;
	GValue* _tmp139_;
	gint company;
	gint _tmp140_;
	gboolean _tmp141_;
	gint _tmp153_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - Append...\n");
	fails = 0;
	_tmp1_ = gda_data_table_new ();
	t = _tmp1_;
	_tmp2_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp2_, "created_table");
	_tmp3_ = t;
	_tmp4_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp3_, _tmp4_);
	{
		FILE* _tmp5_;
		GdaDataTable* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gboolean _tmp12_;
		_tmp5_ = stdout;
		fprintf (_tmp5_, "If the table doesn't exists this will warn...\n");
		_tmp6_ = t;
		_tmp7_ = gda_data_db_table_get_records ((GdaDataDbTable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_collection_get_size (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_ > 0;
		_g_object_unref0 (_tmp9_);
		if (_tmp12_) {
			FILE* _tmp13_;
			GdaDataTable* _tmp14_;
			_tmp13_ = stdout;
			fprintf (_tmp13_, "Table exists and is not empty. Deleting it!!\n");
			_tmp14_ = t;
			gda_data_db_object_drop ((GdaDataDbObject*) _tmp14_, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
		} else {
			FILE* _tmp15_;
			_tmp15_ = stdout;
			fprintf (_tmp15_, "Table doesn't exist continue...\n");
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		FILE* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gint _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = g_strconcat ("Error on dropping table with error message: ", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, "\n", NULL);
		_tmp22_ = _tmp21_;
		fprintf (_tmp16_, "%s", _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp23_ = fails;
		fails = _tmp23_ + 1;
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp24_ = gda_data_field_info_new ();
	field = _tmp24_;
	_tmp25_ = field;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp25_, "id");
	_tmp26_ = field;
	gda_data_db_field_info_set_value_type ((GdaDataDbFieldInfo*) _tmp26_, G_TYPE_INT);
	_tmp27_ = field;
	gda_data_db_field_info_set_attributes ((GdaDataDbFieldInfo*) _tmp27_, GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY | GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT);
	_tmp28_ = t;
	_tmp29_ = field;
	gda_data_db_table_set_field ((GdaDataDbTable*) _tmp28_, (GdaDataDbFieldInfo*) _tmp29_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp30_ = gda_data_field_info_new ();
	field1 = _tmp30_;
	_tmp31_ = field1;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp31_, "name");
	_tmp32_ = field1;
	gda_data_db_field_info_set_value_type ((GdaDataDbFieldInfo*) _tmp32_, G_TYPE_STRING);
	_tmp33_ = field1;
	gda_data_db_field_info_set_attributes ((GdaDataDbFieldInfo*) _tmp33_, GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE);
	_tmp34_ = t;
	_tmp35_ = field1;
	gda_data_db_table_set_field ((GdaDataDbTable*) _tmp34_, (GdaDataDbFieldInfo*) _tmp35_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp36_ = gda_data_field_info_new ();
	field2 = _tmp36_;
	_tmp37_ = field2;
	gda_data_db_field_info_set_name ((GdaDataDbFieldInfo*) _tmp37_, "company");
	_tmp38_ = field2;
	gda_data_db_field_info_set_value_type ((GdaDataDbFieldInfo*) _tmp38_, G_TYPE_INT);
	_tmp39_ = field2;
	_tmp40_ = g_new0 (GValue, 1);
	g_value_init (_tmp40_, G_TYPE_INT);
	g_value_set_int (_tmp40_, 1);
	gda_data_db_field_info_set_default_value ((GdaDataDbFieldInfo*) _tmp39_, _tmp40_);
	__vala_GValue_free0 (_tmp40_);
	_tmp41_ = gda_data_db_field_info_foreign_key_new ();
	fk = _tmp41_;
	_tmp42_ = gda_data_table_new ();
	rt = _tmp42_;
	_tmp43_ = rt;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp43_, "company");
	_tmp44_ = fk;
	_tmp45_ = rt;
	gda_data_db_field_info_foreign_key_set_reftable (_tmp44_, (GdaDataDbTable*) _tmp45_);
	_tmp46_ = fk;
	_tmp47_ = gda_data_db_field_info_foreign_key_get_refcol (_tmp46_);
	_tmp48_ = _tmp47_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, "id");
	_tmp49_ = fk;
	gda_data_db_field_info_foreign_key_set_update_rule (_tmp49_, GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_CASCADE);
	_tmp50_ = fk;
	gda_data_db_field_info_foreign_key_set_delete_rule (_tmp50_, GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_RULE_SET_DEFAULT);
	_tmp51_ = field2;
	_tmp52_ = fk;
	gda_data_db_field_info_set_fkey ((GdaDataDbFieldInfo*) _tmp51_, _tmp52_);
	_tmp53_ = t;
	_tmp54_ = field2;
	gda_data_db_table_set_field ((GdaDataDbTable*) _tmp53_, (GdaDataDbFieldInfo*) _tmp54_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp55_ = stdout;
	fprintf (_tmp55_, "Table definition:\n");
	{
		GdaDataTable* _tmp56_;
		GeeCollection* _tmp57_;
		GeeCollection* _tmp58_;
		GeeCollection* _tmp59_;
		GeeIterator* _tmp60_ = NULL;
		GeeIterator* _tmp61_;
		GeeIterator* _f_it;
		_tmp56_ = t;
		_tmp57_ = gda_data_db_table_get_fields ((GdaDataDbTable*) _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = _tmp58_;
		_tmp60_ = gee_iterable_iterator ((GeeIterable*) _tmp59_);
		_tmp61_ = _tmp60_;
		_g_object_unref0 (_tmp59_);
		_f_it = _tmp61_;
		while (TRUE) {
			GeeIterator* _tmp62_;
			gboolean _tmp63_ = FALSE;
			GeeIterator* _tmp64_;
			gpointer _tmp65_ = NULL;
			GdaDataDbFieldInfo* f;
			FILE* _tmp66_;
			GdaDataDbFieldInfo* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			GdaDataDbFieldInfo* _tmp74_;
			GType _tmp75_;
			GType _tmp76_;
			const gchar* _tmp77_ = NULL;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			GdaDataDbFieldInfo* _tmp82_;
			GdaDataDbFieldInfoAttribute _tmp83_;
			GdaDataDbFieldInfoAttribute _tmp84_;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			_tmp62_ = _f_it;
			_tmp63_ = gee_iterator_next (_tmp62_);
			if (!_tmp63_) {
				break;
			}
			_tmp64_ = _f_it;
			_tmp65_ = gee_iterator_get (_tmp64_);
			f = (GdaDataDbFieldInfo*) _tmp65_;
			_tmp66_ = stdout;
			_tmp67_ = f;
			_tmp68_ = gda_data_db_field_info_get_name (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strconcat ("Field: ", _tmp69_, NULL);
			_tmp71_ = _tmp70_;
			_tmp72_ = g_strconcat (_tmp71_, "\nType: ", NULL);
			_tmp73_ = _tmp72_;
			_tmp74_ = f;
			_tmp75_ = gda_data_db_field_info_get_value_type (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = gda_g_type_to_string (_tmp76_);
			_tmp78_ = g_strconcat (_tmp73_, _tmp77_, NULL);
			_tmp79_ = _tmp78_;
			_tmp80_ = g_strconcat (_tmp79_, "\nAttr: ", NULL);
			_tmp81_ = _tmp80_;
			_tmp82_ = f;
			_tmp83_ = gda_data_db_field_info_get_attributes (_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = g_strdup_printf ("%i", (gint) _tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_strconcat (_tmp81_, _tmp86_, NULL);
			_tmp88_ = _tmp87_;
			_tmp89_ = g_strconcat (_tmp88_, "\n", NULL);
			_tmp90_ = _tmp89_;
			fprintf (_tmp66_, "%s", _tmp90_);
			_g_free0 (_tmp90_);
			_g_free0 (_tmp88_);
			_g_free0 (_tmp86_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp79_);
			_g_free0 (_tmp73_);
			_g_free0 (_tmp71_);
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	f = FALSE;
	{
		GdaDataTable* _tmp91_;
		GdaConnection* _tmp92_;
		GdaDataModel* _tmp93_ = NULL;
		GdaDataModel* m;
		FILE* _tmp94_;
		GdaDataModel* _tmp95_;
		gint _tmp96_ = 0;
		GdaDataModel* _tmp97_;
		gint _tmp98_ = 0;
		GdaDataModel* _tmp99_;
		gint _tmp100_ = 0;
		gboolean _tmp101_;
		_tmp91_ = t;
		gda_data_db_object_append ((GdaDataDbObject*) _tmp91_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_tmp92_ = self->priv->_connection;
		_tmp93_ = gda_connection_execute_select_command (_tmp92_, "SELECT * FROM created_table", &_inner_error_);
		m = _tmp93_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_tmp94_ = stdout;
		fprintf (_tmp94_, "Table was append succeeded\n");
		_tmp95_ = m;
		_tmp96_ = gda_data_model_get_column_index (_tmp95_, "id");
		if (_tmp96_ != 0) {
			f = TRUE;
		}
		_tmp97_ = m;
		_tmp98_ = gda_data_model_get_column_index (_tmp97_, "name");
		if (_tmp98_ != 1) {
			f = TRUE;
		}
		_tmp99_ = m;
		_tmp100_ = gda_data_model_get_column_index (_tmp99_, "company");
		if (_tmp100_ != 2) {
			f = TRUE;
		}
		_tmp101_ = f;
		if (_tmp101_) {
			gint _tmp102_;
			FILE* _tmp103_;
			_tmp102_ = fails;
			fails = _tmp102_ + 1;
			_tmp103_ = stdout;
			fprintf (_tmp103_, "Check Ordinal position: FAILED\n");
		}
		_g_object_unref0 (m);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		FILE* _tmp104_;
		GError* _tmp105_;
		const gchar* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		gint _tmp111_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp104_ = stdout;
		_tmp105_ = e;
		_tmp106_ = _tmp105_->message;
		_tmp107_ = g_strconcat ("Error on calling SELECT query for new table. Message: ", _tmp106_, NULL);
		_tmp108_ = _tmp107_;
		_tmp109_ = g_strconcat (_tmp108_, "\n", NULL);
		_tmp110_ = _tmp109_;
		fprintf (_tmp104_, "%s", _tmp110_);
		_g_free0 (_tmp110_);
		_g_free0 (_tmp108_);
		_tmp111_ = fails;
		fails = _tmp111_ + 1;
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp112_ = gda_data_record_new ();
	r = _tmp112_;
	_tmp113_ = r;
	_tmp114_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp113_, _tmp114_);
	_tmp115_ = gda_data_table_new ();
	nt = _tmp115_;
	_tmp116_ = nt;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp116_, "created_table");
	_tmp117_ = r;
	_tmp118_ = nt;
	gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp117_, (GdaDataDbTable*) _tmp118_);
	_tmp119_ = r;
	_tmp120_ = g_new0 (GValue, 1);
	g_value_init (_tmp120_, G_TYPE_STRING);
	g_value_set_string (_tmp120_, "Nancy");
	gda_data_db_record_set_field_value ((GdaDataDbRecord*) _tmp119_, "name", _tmp120_, &_inner_error_);
	__vala_GValue_free0 (_tmp120_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (nt);
		_g_object_unref0 (r);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp121_ = r;
	gda_data_db_object_append ((GdaDataDbObject*) _tmp121_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (nt);
		_g_object_unref0 (r);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp122_ = self->priv->_connection;
	_tmp123_ = gda_connection_execute_select_command (_tmp122_, "SELECT * FROM created_table", &_inner_error_);
	m2 = _tmp123_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (nt);
		_g_object_unref0 (r);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	f2 = FALSE;
	_tmp124_ = m2;
	_tmp125_ = gda_data_model_get_n_rows (_tmp124_);
	if (_tmp125_ != 1) {
		f2 = TRUE;
	}
	_tmp126_ = m2;
	_tmp127_ = gda_data_model_get_value_at (_tmp126_, 0, 0, &_inner_error_);
	_tmp128_ = _tmp127_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (m2);
		_g_object_unref0 (nt);
		_g_object_unref0 (r);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	id = g_value_get_int (_tmp128_);
	_tmp129_ = id;
	if (_tmp129_ != 1) {
		f2 = TRUE;
	}
	_tmp130_ = m2;
	_tmp131_ = gda_data_model_get_value_at (_tmp130_, 1, 0, &_inner_error_);
	_tmp132_ = _tmp131_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (m2);
		_g_object_unref0 (nt);
		_g_object_unref0 (r);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp133_ = g_strdup (g_value_get_string (_tmp132_));
	name = _tmp133_;
	_tmp134_ = g_strcmp0;
	_tmp135_ = name;
	_tmp136_ = _tmp134_ (_tmp135_, "Nancy");
	if (_tmp136_ != 0) {
		f2 = TRUE;
	}
	_tmp137_ = m2;
	_tmp138_ = gda_data_model_get_value_at (_tmp137_, 2, 0, &_inner_error_);
	_tmp139_ = _tmp138_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (name);
		_g_object_unref0 (m2);
		_g_object_unref0 (nt);
		_g_object_unref0 (r);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	company = g_value_get_int (_tmp139_);
	_tmp140_ = company;
	if (_tmp140_ != 1) {
		f2 = TRUE;
	}
	_tmp141_ = f;
	if (_tmp141_) {
		gint _tmp142_;
		FILE* _tmp143_;
		_tmp142_ = fails;
		fails = _tmp142_ + 1;
		_tmp143_ = stdout;
		fprintf (_tmp143_, "Check Table Values: FAILED\n");
	}
	{
		GdaDataTable* _tmp144_;
		_tmp144_ = t;
		gda_data_db_object_drop ((GdaDataDbObject*) _tmp144_, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		FILE* _tmp145_;
		GError* _tmp146_;
		const gchar* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		gchar* _tmp150_;
		gchar* _tmp151_;
		gint _tmp152_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp145_ = stdout;
		_tmp146_ = e;
		_tmp147_ = _tmp146_->message;
		_tmp148_ = g_strconcat ("Dropping table Fails: ", _tmp147_, NULL);
		_tmp149_ = _tmp148_;
		_tmp150_ = g_strconcat (_tmp149_, "\n", NULL);
		_tmp151_ = _tmp150_;
		fprintf (_tmp145_, "%s", _tmp151_);
		_g_free0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp152_ = fails;
		fails = _tmp152_ + 1;
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (name);
		_g_object_unref0 (m2);
		_g_object_unref0 (nt);
		_g_object_unref0 (r);
		_g_object_unref0 (rt);
		_gda_data_db_field_info_foreign_key_unref0 (fk);
		_g_object_unref0 (field2);
		_g_object_unref0 (field1);
		_g_object_unref0 (field);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp153_ = fails;
	if (_tmp153_ > 0) {
		FILE* _tmp154_;
		_tmp154_ = stdout;
		fprintf (_tmp154_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp155_;
		_tmp155_ = stdout;
		fprintf (_tmp155_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	_g_free0 (name);
	_g_object_unref0 (m2);
	_g_object_unref0 (nt);
	_g_object_unref0 (r);
	_g_object_unref0 (rt);
	_gda_data_db_field_info_foreign_key_unref0 (fk);
	_g_object_unref0 (field2);
	_g_object_unref0 (field1);
	_g_object_unref0 (field);
	_g_object_unref0 (t);
	return result;
}


gint check_tests_save (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	GdaDataTable* _tmp1_;
	GdaDataTable* t;
	GdaConnection* _tmp2_;
	gint _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n\n\n>>>>>>>>>>>>>>> NEW TEST: Gda.DbTable - Rename ...\n");
	fails = 0;
	_tmp1_ = gda_data_table_new ();
	t = _tmp1_;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) t, "customer");
	_tmp2_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) t, _tmp2_);
	{
		FILE* _tmp3_;
		gint _tmp4_;
		gda_data_db_object_save ((GdaDataDbObject*) t, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		_tmp3_ = stdout;
		fprintf (_tmp3_, "Table save() method should throws Error: FAIL\n");
		_tmp4_ = fails;
		fails = _tmp4_ + 1;
	}
	goto __finally13;
	__catch13_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return 0;
	}
	{
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) t, "customer2");
		gda_data_db_object_save ((GdaDataDbObject*) t, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strconcat ("Table rename fails. Message: ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
		_tmp11_ = _tmp10_;
		fprintf (_tmp5_, "%s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_tmp12_ = fails;
		fails = _tmp12_ + 1;
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return 0;
	}
	{
		GdaConnection* _tmp13_;
		GdaDataModel* _tmp14_ = NULL;
		GdaDataModel* m;
		FILE* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp13_ = self->priv->_connection;
		_tmp14_ = gda_connection_execute_select_command (_tmp13_, "SELECT * FROM customer2", &_inner_error_);
		m = _tmp14_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_tmp15_ = stdout;
		_tmp16_ = gda_data_model_dump_as_string (m);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("Data from customer2:\n", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		fprintf (_tmp15_, "%s", _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_object_unref0 (m);
	}
	goto __finally15;
	__catch15_g_error:
	{
		gint _tmp20_;
		FILE* _tmp21_;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp20_ = fails;
		fails = _tmp20_ + 1;
		_tmp21_ = stdout;
		fprintf (_tmp21_, "Table rename: FAIL\n");
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t);
		return 0;
	}
	_tmp22_ = fails;
	if (_tmp22_ > 0) {
		FILE* _tmp23_;
		_tmp23_ = stdout;
		fprintf (_tmp23_, ">>>>>>>> FAIL <<<<<<<<<<<\n");
	} else {
		FILE* _tmp24_;
		_tmp24_ = stdout;
		fprintf (_tmp24_, ">>>>>>>> TEST PASS <<<<<<<<<<<\n");
	}
	result = fails;
	_g_object_unref0 (t);
	return result;
}


gint check_tests_main (gchar** args, int args_length1) {
	gint result = 0;
	FILE* _tmp0_;
	gint failures;
	CheckTests* _tmp1_;
	CheckTests* app;
	gint _tmp26_ = 0;
	gint _tmp27_;
	gint _tmp28_;
	GError * _inner_error_ = NULL;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n" \
"\n" \
"\n" \
">>>>>>>>>>>>>>>> NEW TEST: Checking GdaData.DbTable implementation... " \
"<<<<<<<<<< \n");
	failures = 0;
	_tmp1_ = check_tests_new ();
	app = _tmp1_;
	{
		CheckTests* _tmp2_;
		CheckTests* _tmp3_;
		gint _tmp4_ = 0;
		gint _tmp5_;
		gint _tmp6_;
		CheckTests* _tmp7_;
		gint _tmp8_ = 0;
		gint _tmp9_;
		gint _tmp10_;
		CheckTests* _tmp11_;
		gint _tmp12_ = 0;
		gint _tmp13_;
		gint _tmp14_;
		CheckTests* _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_;
		gint _tmp18_;
		_tmp2_ = app;
		check_tests_init (_tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_tmp3_ = app;
		_tmp4_ = check_tests_update (_tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_tmp6_ = failures;
		failures = _tmp6_ + _tmp5_;
		_tmp7_ = app;
		_tmp8_ = check_tests_fields (_tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_tmp10_ = failures;
		failures = _tmp10_ + _tmp9_;
		_tmp11_ = app;
		_tmp12_ = check_tests_records (_tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_tmp14_ = failures;
		failures = _tmp14_ + _tmp13_;
		_tmp15_ = app;
		_tmp16_ = check_tests_append (_tmp15_, &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_tmp18_ = failures;
		failures = _tmp18_ + _tmp17_;
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		FILE* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = stdout;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		_tmp22_ = g_strconcat ("ERROR: ", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "\n", NULL);
		_tmp25_ = _tmp24_;
		fprintf (_tmp19_, "%s", _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (app);
		return result;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp27_ = failures;
	if (_tmp27_ != 0) {
		_tmp26_ = 1;
	} else {
		_tmp26_ = 0;
	}
	_tmp28_ = _tmp26_;
	result = _tmp28_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return check_tests_main (argv, argc);
}


GdaConnection* check_tests_get_connection (CheckTests* self) {
	GdaConnection* result;
	GdaConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


void check_tests_set_connection (CheckTests* self, GdaConnection* value) {
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	g_object_notify ((GObject *) self, "connection");
}


static void check_tests_class_init (CheckTestsClass * klass) {
	check_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheckTestsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_check_tests_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_check_tests_set_property;
	G_OBJECT_CLASS (klass)->finalize = check_tests_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHECK_TESTS_CONNECTION, g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void check_tests_instance_init (CheckTests * self) {
	self->priv = CHECK_TESTS_GET_PRIVATE (self);
}


static void check_tests_finalize (GObject* obj) {
	CheckTests * self;
	self = CHECK_TESTS (obj);
	_g_object_unref0 (self->priv->_connection);
	_g_object_unref0 (self->table);
	G_OBJECT_CLASS (check_tests_parent_class)->finalize (obj);
}


GType check_tests_get_type (void) {
	static volatile gsize check_tests_type_id__volatile = 0;
	if (g_once_init_enter (&check_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckTests), 0, (GInstanceInitFunc) check_tests_instance_init, NULL };
		GType check_tests_type_id;
		check_tests_type_id = g_type_register_static (G_TYPE_OBJECT, "CheckTests", &g_define_type_info, 0);
		g_once_init_leave (&check_tests_type_id__volatile, check_tests_type_id);
	}
	return check_tests_type_id__volatile;
}


static void _vala_check_tests_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CheckTests * self;
	self = CHECK_TESTS (object);
	switch (property_id) {
		case CHECK_TESTS_CONNECTION:
		g_value_set_object (value, check_tests_get_connection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_check_tests_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CheckTests * self;
	self = CHECK_TESTS (object);
	switch (property_id) {
		case CHECK_TESTS_CONNECTION:
		check_tests_set_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



