// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_VALUE_H
#define _LIBGDAMM_VALUE_H

#include <glibmm.h>

/* $Id: value.hg,v 1.8.2.2 2005/02/04 12:22:47 murrayc Exp $ */
// -*- C++ -*- //

/* value.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgda/gda-value.h> //TODO: Patch libgda to use the struct _ technique.


namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum ValueType
{
  VALUE_TYPE_NULL,
  VALUE_TYPE_BIGINT,
  VALUE_TYPE_BIGUINT,
  VALUE_TYPE_BINARY,
  VALUE_TYPE_BLOB,
  VALUE_TYPE_BOOLEAN,
  VALUE_TYPE_DATE,
  VALUE_TYPE_DOUBLE,
  VALUE_TYPE_GEOMETRIC_POINT,
  VALUE_TYPE_GOBJECT,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_LIST,
  VALUE_TYPE_MONEY,
  VALUE_TYPE_NUMERIC,
  VALUE_TYPE_SINGLE,
  VALUE_TYPE_SMALLINT,
  VALUE_TYPE_SMALLUINT,
  VALUE_TYPE_STRING,
  VALUE_TYPE_TIME,
  VALUE_TYPE_TIMESTAMP,
  VALUE_TYPE_TINYINT,
  VALUE_TYPE_TINYUINT,
  VALUE_TYPE_TYPE,
  VALUE_TYPE_UINTEGER,
  VALUE_TYPE_UNKNOWN
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ValueType> : public Glib::Value_Enum<Gnome::Gda::ValueType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


typedef GdaDate Date;
typedef GdaGeometricPoint GeometricPoint;

/*  TODO:
typedef struct {
	gchar *currency;
	gdouble amount;
} GdaMoney;

typedef struct {
	gchar *number;
	glong precision;
	glong width;
} GdaNumeric;
*/

typedef GdaTime Time;
typedef GdaTimestamp Timestamp;

class Value
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Value CppObjectType;
  typedef GdaValue BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Value();

  // Use make_a_copy=true when getting it directly from a struct.
  explicit Value(GdaValue* castitem, bool make_a_copy = false);

  Value(const Value& src);
  Value& operator=(const Value& src);

  ~Value();

  GdaValue*       gobj()       { return gobject_; }
  const GdaValue* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdaValue* gobj_copy() const;

protected:
  GdaValue* gobject_;

private:

  
public:

//We can't have this constructor because gint64 and int are the same on 64-bit systems:
//explicit Value(gint64 val);
  static Value create_as_bigint(gint64 val);
  

//We can't have this constructor because guint64 and unsigned int are the same on 64-bit systems:
//explicit Value(gint64 val);
// explicit Value(guint64 val);
   static Value create_as_biguint(guint64 val);
  

  explicit Value(const void* val, glong size); 
  

  //gda_value_new_blob() is not implemented. explicit Value(const GdaBlob *val);
  //__IGNORE(gda_value_new_blob)

  explicit Value(bool val);
  
  explicit Value(const Date& val);
  
  explicit Value(double val);
  
  explicit Value(const GeometricPoint& val);
  
  explicit Value(const GObject *val);
  
  explicit Value(int val);
  
  explicit Value(const GdaValueList *val);
  
  explicit Value(const GdaMoney *val);
  
  explicit Value(const GdaNumeric *val);
  
  explicit Value(float val);
  
  explicit Value(gshort val);
  
  explicit Value(gushort val);
  
  explicit Value(const Glib::ustring& val);
  

  //If this constructor does not exists, then Value("something") uses Value(bool) instead of Value(ustring).
  explicit Value(const char* val);

  explicit Value(const Time& val);
  
  explicit Value(const Timestamp& val);
  
  
  //This causes ambiguity with another constructor on 64-bit systems:
  //explicit Value(time_t val);
  
 static Value create_as_time_t(time_t val);
  explicit Value(gchar val);
  
  explicit Value(guchar val);
  
  explicit Value(ValueType val);
  
  explicit Value(guint val);
  
  explicit Value(const Glib::ustring& as_string, ValueType type);
  
  //TODO: explicit Value(const xmlNodePtr node);
  //__IGNORE(gda_value_new_from_xml)

  bool operator==(const Value& src) const;
  bool operator!=(const Value& src) const;

  
  ValueType get_value_type() const;
  
  bool is_null() const;
  
  bool is_number() const;

  
  gint64 get_bigint() const;
  
  void set(gint64 val);
  
  guint64 get_biguint() const;
  
  void set(guint64 val);

  //TODO: The const here is quite meaningless:
  
  const gpointer get_binary(glong* size) const;
  
  void set(gconstpointer val, glong size);

  //TODO: The const here is quite meaningless:
  
  const GdaBlob* get_blob() const;
  
  void set(const GdaBlob* val);
  
  bool get_bool() const;
  
  void set(bool val);
  
  Date get_date() const;
  
  void set(const Date& val);
  
  double get_double() const;
  
  void set(double val);
  
  GeometricPoint get_geometric_point() const;
  
  void set(const GeometricPoint& val);
  
  Glib::RefPtr<const Glib::Object> get_gobject();
  
  void set(const Glib::RefPtr<Glib::Object>& val);
  
  int get_integer() const;
  
  void set(int val);
  
  const GdaValueList* get_list();
  
  void set(const GdaValueList *val);
  
  void set_null();
  
  const GdaMoney* get_money() const;
  
  void set(const GdaMoney *val);
  
  const GdaNumeric* get_numeric() const;
  
  void set(const GdaNumeric *val);
  
  float get_single() const;
  
  void set(float val);
  
  gshort get_smallint() const;
  
  void set(gshort val);
  
  gushort get_smalluint() const;
  
  void set(gushort val);
  
  Glib::ustring get_string() const;
  
  void set(const Glib::ustring& val);
  
  Time get_time() const;
  
  void set(const Time& val);
  
  Timestamp get_timestamp() const;
  
  void set(const Timestamp& val);
  
  gchar get_tinyint() const;
  
  void set(gchar val);
  
  guchar get_tinyuint();
  
  void set(guchar val);
  
  guint get_uinteger() const;
  
  void set(guint val);
  
  ValueType get_vtype() const;
  
  void set(GdaValueType type);
  
  bool set_from_string(const Glib::ustring& as_string, ValueType type);

  //Use the copy constructor instead: _WRAP_METHOD(bool set_from_value(const Value& from), gda_value_set_from_value)
  

  //TODO: Wrap this as some stream operator thing?
  
  Glib::ustring to_string() const;

  //TODO: _WRAP_METHOD(xmlNodePtr gda_value_to_xml(), gda_value_to_xml)


  static Glib::ustring type_to_string(ValueType type);
  
  static ValueType type_from_string(const Glib::ustring& type);


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{

  /** @relates Gnome::Gda::Value
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
Gnome::Gda::Value wrap(GdaValue* object, bool take_copy = false);

} // namespace Glib

#endif /* _LIBGDAMM_VALUE_H */

