// Generated by gtkmmproc -- DO NOT MODIFY!

#include <libgdamm/value.h>
#include <libgdamm/private/value_p.h>

/* $Id: value.ccg,v 1.6.2.3 2005/07/13 14:41:13 murrayc Exp $ */
// -*- C++ -*- //

/* value.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgda/gda-value.h>
#include <libgda/gda-enum-types.h>
#include <libgda/gda-util.h>

namespace Gnome
{

namespace Gda
{


// gint64 and guint64 are the same as gint and guint on 64-bit systems, 
// so these would cause conflicts/ambiguity.
/*
Value::Value(gint64 val)
{
  gobject_ = gda_value_new_integer(val);
}

Value::Value(guint64 val)
{
  gobject_ = gda_value_new_biguint(val);
}
*/


//static:
Value Value::create_as_bigint(gint64 val)
{
  return Value( gda_value_new_bigint(val) );
}


//static:
Value Value::create_as_biguint(guint64 val)
{
  return Value( gda_value_new_biguint(val) );
}


Value::Value(const void* val, long size)
{
  gobject_ = gda_value_new_binary(val, size);
}


/* gda_value_new_blob() is not implemented
Value::Value(const GdaBlob *val)
{
  gobject_ = gda_value_new_blob(val);
}
*/

Value::Value(bool val)
{
  gobject_ = gda_value_new_boolean(val);
}

Value::Value(const Date& val)
{
  gobject_ = gda_value_new_date(&val);
}

Value::Value(double val)
{
  gobject_ = gda_value_new_double(val);
}

Value::Value(const GeometricPoint& val)
{
  gobject_ = gda_value_new_geometric_point(&val);
}

Value::Value(const GObject *val)
{
  gobject_ = gda_value_new_gobject(val);
}

Value::Value(int val)
{
  gobject_ = gda_value_new_integer(val);
}

Value::Value(const GdaValueList *val)
{
  gobject_ = gda_value_new_list(val);
}

Value::Value(const GdaMoney *val)
{
  gobject_ = gda_value_new_money(val);
}

Value::Value(const GdaNumeric *val)
{
  gobject_ = gda_value_new_numeric(val);
}

Value::Value(float val)
{
  gobject_ = gda_value_new_single(val);
}

Value::Value(gshort val)
{
  gobject_ = gda_value_new_smallint(val);
}

Value::Value(gushort val)
{
  gobject_ = gda_value_new_smalluint(val);
}

Value::Value(const Glib::ustring& val)
{
  gobject_ = gda_value_new_string(val.c_str());
}

Value::Value(const char* val)
{
  gobject_ = gda_value_new_string(val);
}

Value::Value(const Time& val)
{
  gobject_ = gda_value_new_time(&val);
}

Value::Value(const Timestamp& val)
{
  gobject_ = gda_value_new_timestamp(&val);
}

/*
Value::Value(time_t val)
{
  gobject_ = gda_value_new_timestamp_from_timet(val);
}
*/

//static:
Value Value::create_as_time_t(time_t val)
{
  return Value( gda_value_new_timestamp_from_timet(val) );
}


Value::Value(gchar val)
{
  gobject_ = gda_value_new_tinyint(val);
}

Value::Value(guchar val)
{
  gobject_ = gda_value_new_tinyuint(val);
}

Value::Value(ValueType val)
{
  gobject_ = gda_value_new_type((GdaValueType)val);
}

Value::Value(guint val)
{
  gobject_ = gda_value_new_uinteger(val);
}

Value::Value(const Glib::ustring& as_string, ValueType type)
{
  gobject_ = gda_value_new_from_string(as_string.c_str(), (GdaValueType)type);
}

bool Value::operator==(const Value& src) const
{
  if( !gobject_ && !src.gobject_) //If both are null.
    return true;

  if( !gobject_ && src.gobject_) //If one is null.
    return false;

  if( gobject_ && !src.gobject_) //If one is null.
    return false;

  if(get_value_type() != src.get_value_type()) //gda_value_compare() can only compare GdaValues of the same type.
    return false;
    
  gint test = gda_value_compare(const_cast<GdaValue*>(gobj()), const_cast<GdaValue*>(src.gobj()));   //returns 0 if both contain
  return test == 0;
}

bool Value::operator!=(const Value& src) const
{
  return !operator==(src);
}


} //namespace Gda

} //namespace Gnome


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gnome::Gda::ValueType>::value_type()
{
  return gda_value_type_get_type();
}


namespace Glib
{

Gnome::Gda::Value wrap(GdaValue* object, bool take_copy /* = false */)
{
  return Gnome::Gda::Value(object, take_copy);
}

} // namespace Glib


namespace Gnome
{

namespace Gda
{


Value::Value()
:
  gobject_ (gda_value_new_null())
{}

Value::Value(const Value& src)
:
  gobject_ ((src.gobject_) ? gda_value_copy(src.gobject_) : 0)
{}

Value::Value(GdaValue* castitem, bool make_a_copy /* = false */)
{
  if(!make_a_copy)
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
  else
  {
    // We are probably getting it via direct access to a struct,
    // so we can not just take it - we have to take a copy of it.
    if(castitem)
      gobject_ = gda_value_copy(castitem);
    else
      gobject_ = 0;
  }
}

Value& Value::operator=(const Value& src)
{
  GdaValue *const new_gobject = (src.gobject_) ? gda_value_copy(src.gobject_) : 0;

  if(gobject_)
    gda_value_free(gobject_);

  gobject_ = new_gobject;

  return *this;
}

Value::~Value()
{
  if(gobject_)
    gda_value_free(gobject_);
}

GdaValue* Value::gobj_copy() const
{
  return gda_value_copy(gobject_);
}


ValueType Value::get_value_type() const
{
  return ((ValueType)(gda_value_get_type(const_cast<GdaValue*>(gobj()))));
}

bool Value::is_null() const
{
  return gda_value_is_null(const_cast<GdaValue*>(gobj()));
}

bool Value::is_number() const
{
  return gda_value_is_number(const_cast<GdaValue*>(gobj()));
}

gint64 Value::get_bigint() const
{
  return gda_value_get_bigint(const_cast<GdaValue*>(gobj()));
}

void Value::set(gint64 val)
{
  gda_value_set_bigint(gobj(), val);
}

guint64 Value::get_biguint() const
{
  return gda_value_get_biguint(const_cast<GdaValue*>(gobj()));
}

void Value::set(guint64 val)
{
  gda_value_set_biguint(gobj(), val);
}

const gpointer Value::get_binary(long& size) const
{
  return gda_value_get_binary(const_cast<GdaValue*>(gobj()), &(size));
}

void Value::set(gconstpointer val, long size)
{
  gda_value_set_binary(gobj(), val, size);
}

const GdaBlob* Value::get_blob() const
{
  return gda_value_get_blob(const_cast<GdaValue*>(gobj()));
}

void Value::set(const GdaBlob* val)
{
  gda_value_set_blob(gobj(), val);
}

bool Value::get_bool() const
{
  return gda_value_get_boolean(const_cast<GdaValue*>(gobj()));
}

void Value::set(bool val)
{
  gda_value_set_boolean(gobj(), static_cast<int>(val));
}

Date Value::get_date() const
{
  return *(gda_value_get_date(const_cast<GdaValue*>(gobj())));
}

void Value::set(const Date& val)
{
  gda_value_set_date(gobj(), &(val));
}

double Value::get_double() const
{
  return gda_value_get_double(const_cast<GdaValue*>(gobj()));
}

void Value::set(double val)
{
  gda_value_set_double(gobj(), val);
}

GeometricPoint Value::get_geometric_point() const
{
  return *(gda_value_get_geometric_point(const_cast<GdaValue*>(gobj())));
}

void Value::set(const GeometricPoint& val)
{
  gda_value_set_geometric_point(gobj(), &(val));
}

Glib::RefPtr<const Glib::Object> Value::get_gobject()
{

  Glib::RefPtr<const Glib::Object> retvalue = Glib::wrap(const_cast<GObject*>(gda_value_get_gobject(gobj())));

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void Value::set(const Glib::RefPtr<Glib::Object>& val)
{
  gda_value_set_gobject(gobj(), (val)->gobj());
}

int Value::get_integer() const
{
  return gda_value_get_integer(const_cast<GdaValue*>(gobj()));
}

void Value::set(int val)
{
  gda_value_set_integer(gobj(), val);
}

const GdaValueList* Value::get_list()
{
  return gda_value_get_list(gobj());
}

void Value::set(const GdaValueList * val)
{
  gda_value_set_list(gobj(), val);
}

void Value::set_null()
{
  gda_value_set_null(gobj());
}

const GdaMoney* Value::get_money() const
{
  return gda_value_get_money(const_cast<GdaValue*>(gobj()));
}

void Value::set(const GdaMoney * val)
{
  gda_value_set_money(gobj(), val);
}

const GdaNumeric* Value::get_numeric() const
{
  return gda_value_get_numeric(const_cast<GdaValue*>(gobj()));
}

void Value::set(const GdaNumeric * val)
{
  gda_value_set_numeric(gobj(), val);
}

float Value::get_single() const
{
  return gda_value_get_single(const_cast<GdaValue*>(gobj()));
}

void Value::set(float val)
{
  gda_value_set_single(gobj(), val);
}

gshort Value::get_smallint() const
{
  return gda_value_get_smallint(const_cast<GdaValue*>(gobj()));
}

void Value::set(gshort val)
{
  gda_value_set_smallint(gobj(), val);
}

gushort Value::get_smalluint() const
{
  return gda_value_get_smalluint(const_cast<GdaValue*>(gobj()));
}

void Value::set(gushort val)
{
  gda_value_set_smalluint(gobj(), val);
}

Glib::ustring Value::get_string() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_value_get_string(const_cast<GdaValue*>(gobj())));
}

void Value::set(const Glib::ustring& val)
{
  gda_value_set_string(gobj(), val.c_str());
}

Time Value::get_time() const
{
  return *(gda_value_get_time(const_cast<GdaValue*>(gobj())));
}

void Value::set(const Time& val)
{
  gda_value_set_time(gobj(), &(val));
}

Timestamp Value::get_timestamp() const
{
  return *(gda_value_get_timestamp(const_cast<GdaValue*>(gobj())));
}

void Value::set(const Timestamp& val)
{
  gda_value_set_timestamp(gobj(), &(val));
}

gchar Value::get_tinyint() const
{
  return gda_value_get_tinyint(const_cast<GdaValue*>(gobj()));
}

void Value::set(gchar val)
{
  gda_value_set_tinyint(gobj(), val);
}

guchar Value::get_tinyuint()
{
  return gda_value_get_tinyuint(gobj());
}

void Value::set(guchar val)
{
  gda_value_set_tinyuint(gobj(), val);
}

guint Value::get_uinteger() const
{
  return gda_value_get_uinteger(const_cast<GdaValue*>(gobj()));
}

void Value::set(guint val)
{
  gda_value_set_uinteger(gobj(), val);
}

ValueType Value::get_vtype() const
{
  return ((ValueType)(gda_value_get_vtype(const_cast<GdaValue*>(gobj()))));
}

void Value::set(GdaValueType type)
{
  gda_value_set_vtype(gobj(), type);
}

bool Value::set_from_string(const Glib::ustring& as_string, ValueType type)
{
  return gda_value_set_from_string(gobj(), as_string.c_str(), ((GdaValueType)(type)));
}

Glib::ustring Value::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_value_stringify(const_cast<GdaValue*>(gobj())));
}

Glib::ustring Value::type_to_string(ValueType type)
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_type_to_string(((GdaValueType)(type))));
}

ValueType Value::type_from_string(const Glib::ustring& type)
{
  return ((ValueType)(gda_type_from_string(type.c_str())));
}


} // namespace Gda

} // namespace Gnome


