// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_COLUMN_H
#define _LIBGDAMM_COLUMN_H


#include <glibmm.h>

/* $Id: column.hg,v 1.14 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* modelcolumnattributes.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/transactionstatus.h>
#include <glibmm/object.h>


#include <libgdamm/value.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaColumn GdaColumn;
typedef struct _GdaColumnClass GdaColumnClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Column_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Management of DataModel column attributes.
 *
 */

class Column : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Column CppObjectType;
  typedef Column_Class CppClassType;
  typedef GdaColumn BaseObjectType;
  typedef GdaColumnClass BaseClassType;

private:  friend class Column_Class;
  static CppClassType column_class_;

private:
  // noncopyable
  Column(const Column&);
  Column& operator=(const Column&);

protected:
  explicit Column(const Glib::ConstructParams& construct_params);
  explicit Column(GdaColumn* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Column();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaColumn*       gobj()       { return reinterpret_cast<GdaColumn*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaColumn* gobj() const { return reinterpret_cast<GdaColumn*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaColumn* gobj_copy();

private:

protected:
  Column();

public:
  
  static Glib::RefPtr<Column> create();

  
  /** Creates a new Gda::Column object from an existing one.
   * @return A newly allocated Gda::Column with a copy of the data 	 
   * in @a column .
   */
  Glib::RefPtr<Column> copy() const;
  bool equal(const Glib::RefPtr<const Column>& src) const;

  
  /** 
   * @return The column's title.
   */
  Glib::ustring get_title() const;
  
  /** Sets the column's title
   * @param title Title name.
   */
  void set_title(const Glib::ustring& title);

  
  /** 
   * @return The defined size of @a column .
   */
  glong get_defined_size() const;
  
  /** Sets the defined size of a Gda::Column.
   * @param size The defined size we want to set.
   */
  void set_defined_size(glong size);
  
  /** 
   * @return The name of @a column .
   */
  Glib::ustring get_name() const;
  
  /** Sets the name of @a column  to @a name .
   * @param name The new name of @a column .
   */
  void set_name(const Glib::ustring& name);
  
  /** 
   * @return The name of the table to which this column belongs.
   */
  Glib::ustring get_table() const;
  
  /** Sets the name of the table to which the given column belongs.
   * @param table Table name.
   */
  void set_table(const Glib::ustring& table);
  
  /** 
   * @return  @a column 's caption.
   */
  Glib::ustring get_caption() const;
  
  /** Sets @a column 's @a caption .
   * @param caption Caption.
   */
  void set_caption(const Glib::ustring& caption);
  
  /** 
   * @return The number of decimals of @a column .
   */
  glong get_scale() const;
  
  /** Sets the scale of @a column  to @a scale .
   * @param scale Number of decimals.
   */
  void set_scale(glong scale);
  
  /** 
   * @return The dbms_type of @a column .
   */
  Glib::ustring get_dbms_type() const;
  
  void set_dbms_type(const Glib::ustring& dbms_type);

  
  /** 
   * @return The type of @a column .
   */
  GType get_g_type() const;
  
  /** Sets the type of @a column  to @a type .
   * @param type The new type of @a column .
   */
  void set_g_type(GType type);
  
  /** Gets the 'allow null' flag of the given column.
   * @return Whether the given column allows null values or not (<tt>true</tt> or <tt>false</tt>).
   */
  bool get_allow_null() const;
  
  /** Sets the 'allow null' flag of the given column.
   * @param allow Whether the given column should allows null values or not.
   */
  void set_allow_null(bool allow = true);
  
  /** 
   * @return Whether if the given column is a primary key (<tt>true</tt> or <tt>false</tt>).
   */
  bool get_primary_key() const;
  
  /** Sets the 'primary key' flag of the given column.
   * @param pk Whether if the given column should be a primary key.
   */
  void set_primary_key(bool pk = true);
  
  /** 
   * @return Whether if the given column is an unique key (<tt>true</tt> or <tt>false</tt>).
   */
  bool get_unique_key() const;
  
  /** Sets the 'unique key' flag of the given column.
   * @param uk Whether if the given column should be an unique key.
   */
  void set_unique_key(bool uk = true);
  
  /** Reference is returned in tablename.fieldname format. Do not free
   * this variable, it is used internally within GdaColumn.
   * @return  @a column 's references.
   */
  Glib::ustring get_references() const; //TODO: What's this?
  
  /** Sets @a column 's @a references .
   * @param ref References.
   */
  void set_references(const Glib::ustring& ref);
  
  /** 
   * @return Whether the given column is an auto incremented one (<tt>true</tt> or <tt>false</tt>).
   */
  bool get_auto_increment() const;
  
  /** Sets the auto increment flag for the given column.
   * @param is_auto Auto increment status.
   */
  void set_auto_increment(bool is_auto = true);
  
  /** 
   * @return The position of the column refer to in the
   * containing data model.
   */
  gint get_position() const;
  
  /** Sets the position of the column refer to in the containing
   * data model.
   * @param position The wanted position of the column in the containing data model.
   */
  void set_position(gint position);

   Value get_default_value() const;
  
  
  /** Sets @a column 's default G::Value.
   * @param default_value Default G::Value for the column.
   */
  void set_default_value(const Value& default_value);

  
/**
   * @par Prototype:
   * <tt>void %name_changed(const Glib::ustring& old_name)</tt>
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_name_changed();

  
/**
   * @par Prototype:
   * <tt>void %g_type_changed(GType old_type, GType new_type)</tt>
   */

  Glib::SignalProxy2< void,GType,GType > signal_g_type_changed();
;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_name_changed(const Glib::ustring& old_name);
  virtual void on_g_type_changed(GType old_type, GType new_type);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::Column
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::Column> wrap(GdaColumn* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_COLUMN_H */

