// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_QUERYCONDITION_H
#define _LIBGDAMM_QUERYCONDITION_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* querycondition.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>

#include <libgdamm/xmlstorage.h>
#include <libgdamm/referer.h>
#include <libgdamm/renderer.h>
#include <libgdamm/queryobject.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaQueryCondition GdaQueryCondition;
typedef struct _GdaQueryConditionClass GdaQueryConditionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class QueryCondition_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class Query;
class QueryField;
class QueryTarget;

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum QueryConditionType
{
  QUERY_CONDITION_NODE_AND,
  QUERY_CONDITION_NODE_OR,
  QUERY_CONDITION_NODE_NOT,
  QUERY_CONDITION_LEAF_EQUAL,
  QUERY_CONDITION_LEAF_DIFF,
  QUERY_CONDITION_LEAF_SUP,
  QUERY_CONDITION_LEAF_SUPEQUAL,
  QUERY_CONDITION_LEAF_INF,
  QUERY_CONDITION_LEAF_INFEQUAL,
  QUERY_CONDITION_LEAF_LIKE,
  QUERY_CONDITION_LEAF_SIMILAR,
  QUERY_CONDITION_LEAF_REGEX,
  QUERY_CONDITION_LEAF_REGEX_NOCASE,
  QUERY_CONDITION_LEAF_NOT_REGEX,
  QUERY_CONDITION_LEAF_NOT_REGEX_NOCASE,
  QUERY_CONDITION_LEAF_IN,
  QUERY_CONDITION_LEAF_BETWEEN,
  QUERY_CONDITION_TYPE_UNKNOWN
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::QueryConditionType> : public Glib::Value_Enum<Gnome::Gda::QueryConditionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum QueryConditionOperator
{
  QUERY_CONDITION_OP_LEFT,
  QUERY_CONDITION_OP_RIGHT,
  QUERY_CONDITION_OP_RIGHT2
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::QueryConditionOperator> : public Glib::Value_Enum<Gnome::Gda::QueryConditionOperator>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** Represents a condition within a query.
 *
 * @ingroup Queries
 */

class QueryCondition
 : public QueryObject,
   public XmlStorage,
   public Referer,
   public Renderer
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef QueryCondition CppObjectType;
  typedef QueryCondition_Class CppClassType;
  typedef GdaQueryCondition BaseObjectType;
  typedef GdaQueryConditionClass BaseClassType;

private:  friend class QueryCondition_Class;
  static CppClassType querycondition_class_;

private:
  // noncopyable
  QueryCondition(const QueryCondition&);
  QueryCondition& operator=(const QueryCondition&);

protected:
  explicit QueryCondition(const Glib::ConstructParams& construct_params);
  explicit QueryCondition(GdaQueryCondition* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~QueryCondition();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaQueryCondition*       gobj()       { return reinterpret_cast<GdaQueryCondition*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaQueryCondition* gobj() const { return reinterpret_cast<GdaQueryCondition*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaQueryCondition* gobj_copy();

private:


protected:
  QueryCondition(const Glib::RefPtr<Query>& query, QueryConditionType type);
  

  // TODO: If we want to wrap gda_query_condition_new_from_sql, libgda
  // should either provide a sql_cond property or a
  // gda_query_condition_set_sql_text() function.

public:
  
  static Glib::RefPtr<QueryCondition> create(const Glib::RefPtr<Query>& query, QueryConditionType type);


  /** Sets the kind of condition @a condition  represents. If @a type  implies a node condition and
   *  @a condition  currently represents a leaf, or if @a type  implies a leaf condition and
   *  @a condition  currently represents a node, then @a condition  is changed without any error.
   */
  void set_cond_type(QueryConditionType type);
  
  /** Get the type of @a condition 
   * @return The type.
   */
  QueryConditionType get_cond_type() const;

  // TODO: I am not sure whether refcounting works correctly for the
  // returned QueryConditions. armin.
   

  /** Get a list of Gda::QueryCondition objects which are children of @a condition 
   * @return A new list of Gda::QueryCondition objects.
   */
  Glib::SListHandle<Glib::RefPtr<QueryCondition> > get_children();
  
  /** Get a list of Gda::QueryCondition objects which are children of @a condition 
   * @return A new list of Gda::QueryCondition objects.
   */
  Glib::SListHandle<Glib::RefPtr<const QueryCondition> > get_children() const;

  
  /** Get the Gda::QueryCondition object which is parent of @a condition 
   * @return The parent object, or <tt>0</tt>.
   */
  Glib::RefPtr<QueryCondition> get_parent();
  
  /** Get the Gda::QueryCondition object which is parent of @a condition 
   * @return The parent object, or <tt>0</tt>.
   */
  Glib::RefPtr<const QueryCondition> get_parent() const;
  
  /** Get a pointer to a Gda::QueryCondition child from its XML Id
   * @param xml_id The XML Id of the requested Gda::QueryCondition child.
   * @return The Gda::QueryCondition object, or <tt>0</tt> if not found.
   */
  Glib::RefPtr<QueryCondition> get_child_by_xml_id(const Glib::ustring& xml_id);
  
  /** Get a pointer to a Gda::QueryCondition child from its XML Id
   * @param xml_id The XML Id of the requested Gda::QueryCondition child.
   * @return The Gda::QueryCondition object, or <tt>0</tt> if not found.
   */
  Glib::RefPtr<const QueryCondition> get_child_by_xml_id(const Glib::ustring& xml_id) const;

  
  /** Tests if @a ancestor  is an ancestor of @a condition 
   * @param ancestor A Gda::QueryCondition object.
   * @return <tt>true</tt> if @a ancestor  is an ancestor of @a condition .
   */
  bool is_ancestor(const Glib::RefPtr<QueryCondition>& ancestor) const;
  
  /** Tells if @a condition  is a leaf condition (not AND, OR, NOT, etc)
   * @return <tt>true</tt> if @a condition  is a leaf condition.
   */
  bool is_leaf() const;
  
  /** Adds a child to @a condition ; this is possible only if @a condition  is a node type (AND, OR, etc)
   * @param child A Gda::QueryCondition object.
   * @param error Location to store error, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool node_add_child(const Glib::RefPtr<QueryCondition>& child);
#else
  bool node_add_child(const Glib::RefPtr<QueryCondition>& child, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Removes a child from @a condition ; this is possible only if @a condition  is a node type (AND, OR, etc)
   * @param child A Gda::QueryCondition object.
   */
  void node_del_child(const Glib::RefPtr<QueryCondition>& child);
  
  void leaf_set_operator(QueryConditionOperator op, const Glib::RefPtr<QueryField>& field);
  
  /** Get one of @a condition 's operators.
   * @param op Which oparetor is concerned.
   * @return The requested Gda::QueryField object.
   */
  Glib::RefPtr<QueryField> leaf_get_operator(QueryConditionOperator op);
  
  /** Get one of @a condition 's operators.
   * @param op Which oparetor is concerned.
   * @return The requested Gda::QueryField object.
   */
  Glib::RefPtr<const QueryField> leaf_get_operator(QueryConditionOperator op) const;

  // TODO: Wrap gda_query_condition_represents_join and gda_query_condition_represents_join_strict

  
  /** Makes a list of all the conditions which
   * are always verified by @a condition  when it returns <tt>true</tt> when evaluated.
   * Basically the returned list lists the atomic conditions which are AND'ed
   * together to form the complex @a condition .
   * 
   * Examples: if @a condition  is:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt; "A and B" then the list will contains {A, B}&lt;/listitem&gt;
   * &lt;listitem&gt; "A and (B or C)" it will contain {A, B or C}&lt;/listitem&gt;
   * &lt;listitem&gt; "A and (B and not C)", it will contain {A, B, not C}&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * @return A new list of Gda::QueryCondition objects.
   */
  Glib::SListHandle<Glib::RefPtr<QueryCondition> > get_main_conditions();
  
  /** Makes a list of all the conditions which
   * are always verified by @a condition  when it returns <tt>true</tt> when evaluated.
   * Basically the returned list lists the atomic conditions which are AND'ed
   * together to form the complex @a condition .
   * 
   * Examples: if @a condition  is:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt; "A and B" then the list will contains {A, B}&lt;/listitem&gt;
   * &lt;listitem&gt; "A and (B or C)" it will contain {A, B or C}&lt;/listitem&gt;
   * &lt;listitem&gt; "A and (B and not C)", it will contain {A, B, not C}&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * @return A new list of Gda::QueryCondition objects.
   */
  Glib::SListHandle<Glib::RefPtr<const QueryCondition> > get_main_conditions() const;

  // TODO: Wrap gda_query_condition_get_ref_objects_all
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<QueryConditionType> property_cond_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<QueryConditionType> property_cond_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  //_WRAP_PROPERTY("join", Glib::RefPtr<QueryJoin>)
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Query> > property_query() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::QueryCondition
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::QueryCondition> wrap(GdaQueryCondition* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_QUERYCONDITION_H */

