// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_OBJECT_H
#define _LIBGDAMM_OBJECT_H


#include <glibmm.h>

/* $Id: object.hg,v 1.3 2006/11/08 00:07:37 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* error.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
//#include <libgdamm/dict.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaObject GdaObject;
typedef struct _GdaObjectClass GdaObjectClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Object_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%ValueAttribute operator|(ValueAttribute, ValueAttribute)</tt><br>
 * <tt>%ValueAttribute operator&(ValueAttribute, ValueAttribute)</tt><br>
 * <tt>%ValueAttribute operator^(ValueAttribute, ValueAttribute)</tt><br>
 * <tt>%ValueAttribute operator~(ValueAttribute)</tt><br>
 * <tt>%ValueAttribute& operator|=(ValueAttribute&, ValueAttribute)</tt><br>
 * <tt>%ValueAttribute& operator&=(ValueAttribute&, ValueAttribute)</tt><br>
 * <tt>%ValueAttribute& operator^=(ValueAttribute&, ValueAttribute)</tt><br>
 */
enum ValueAttribute
{
  VALUE_ATTR_NONE = 0,
  VALUE_ATTR_IS_NULL = 1 << 0,
  VALUE_ATTR_CAN_BE_NULL = 1 << 1,
  VALUE_ATTR_IS_DEFAULT = 1 << 2,
  VALUE_ATTR_CAN_BE_DEFAULT = 1 << 3,
  VALUE_ATTR_IS_UNCHANGED = 1 << 4,
  VALUE_ATTR_ACTIONS_SHOWN = 1 << 5,
  VALUE_ATTR_DATA_NON_VALID = 1 << 6,
  VALUE_ATTR_HAS_VALUE_ORIG = 1 << 7,
  VALUE_ATTR_NO_MODIF = 1 << 8,
  VALUE_ATTR_UNUSED = 1 << 9
};

/** @ingroup libgdammEnums */
inline ValueAttribute operator|(ValueAttribute lhs, ValueAttribute rhs)
  { return static_cast<ValueAttribute>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ValueAttribute operator&(ValueAttribute lhs, ValueAttribute rhs)
  { return static_cast<ValueAttribute>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ValueAttribute operator^(ValueAttribute lhs, ValueAttribute rhs)
  { return static_cast<ValueAttribute>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ValueAttribute operator~(ValueAttribute flags)
  { return static_cast<ValueAttribute>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline ValueAttribute& operator|=(ValueAttribute& lhs, ValueAttribute rhs)
  { return (lhs = static_cast<ValueAttribute>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline ValueAttribute& operator&=(ValueAttribute& lhs, ValueAttribute rhs)
  { return (lhs = static_cast<ValueAttribute>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline ValueAttribute& operator^=(ValueAttribute& lhs, ValueAttribute rhs)
  { return (lhs = static_cast<ValueAttribute>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ValueAttribute> : public Glib::Value_Flags<Gnome::Gda::ValueAttribute>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


class Dict;

/** The base class for many of the libgda objects.
 */

class Object : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Object CppObjectType;
  typedef Object_Class CppClassType;
  typedef GdaObject BaseObjectType;
  typedef GdaObjectClass BaseClassType;

private:  friend class Object_Class;
  static CppClassType object_class_;

private:
  // noncopyable
  Object(const Object&);
  Object& operator=(const Object&);

protected:
  explicit Object(const Glib::ConstructParams& construct_params);
  explicit Object(GdaObject* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Object();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaObject*       gobj()       { return reinterpret_cast<GdaObject*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaObject* gobj() const { return reinterpret_cast<GdaObject*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaObject* gobj_copy();

private:

protected:

 Object();

public:
  
  static Glib::RefPtr<Object> create();


  /** Fetch the corresponding Gda::Dict object.
   * @return The Gda::Dict object to which @a gdaobj  is attached to.
   */
  Glib::RefPtr<Dict> get_dict();
  
  /** Fetch the corresponding Gda::Dict object.
   * @return The Gda::Dict object to which @a gdaobj  is attached to.
   */
  Glib::RefPtr<const Dict> get_dict() const;

  
  /** Sets the string ID of the @a gdaobj  object.
   * 
   * The string ID must be unique for all the objects related to a given Gda::Dict object.
   * @param strid The string Identifier.
   */
  void set_id(const Glib::ustring& strid);
  
  /** Sets the name of the GdaObject object. If the name is changed, then the 
   * "name_changed" signal is emitted.
   */
  void set_name(const Glib::ustring& name);
  
  /** Sets the description of the GdaObject object. If the description is changed, then the 
   * "descr_changed" signal is emitted.
   */
  void set_description(const Glib::ustring& descr);
  
  /** Sets the owner of the GdaObject object. If the owner is changed, then the 
   * "owner_changed" signal is emitted.
   */
  void set_owner(const Glib::ustring& owner);

  
  /** Fetch the string ID of the GdaObject object.
   * @return The id.
   */
  Glib::ustring get_id() const;
  
  /** Fetch the name of the GdaObject object.
   * @return The object's name.
   */
  Glib::ustring get_name() const;
  
  /** Fetch the description of the GdaObject object.
   * @return The object's description.
   */
  Glib::ustring get_description() const;
  
  /** Fetch the owner of the GdaObject object.
   * @return The object's owner.
   */
  Glib::ustring get_owner() const;

  //We ignore the *destroy methods because they are not appropriate for C++ and don't even seem necessary as public API.
  

  // Ignore this debugging method
  

  /** Force emission of the "changed" signal, except if block_changed() has
   * been called.
   */
  void signal_emit_changed();
  
  /** No "changed" signal will be emitted.
   */
  void block_changed();
  
  /** The "changed" signal will again be emitted.
   */
  void unblock_changed();

  // IMHO, this one might be useful because it is emitted when a Gda::Parameter changes for example
  
/**
   * @par Prototype:
   * <tt>void %signal_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_signal_changed();


  /* TODO: Ignore these signals for now because they look strange and not useful:
  _WRAP_SIGNAL(void id_changed, "id_changed")
  _WRAP_SIGNAL(void name_changed, "name_changed")
  _WRAP_SIGNAL(void descr_changed, "descr_changed")
  _WRAP_SIGNAL(void owner_changed, "owner_changed")

  _WRAP_SIGNAL(void to_be_destroyed, "to_be_destroyed")
  _WRAP_SIGNAL(void destroyed, "destroyed")
  */


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_signal_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::Object
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::Object> wrap(GdaObject* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_OBJECT_H */

