// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_CONNECTION_H
#define _LIBGDAMM_CONNECTION_H


#include <glibmm.h>

/* $Id: connection.hg,v 1.35 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- // 

/* connection.h
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/transactionstatus.h>
#include <libgdamm/connectionevent.h>
#include <libgdamm/command.h>
#include <libgdamm/datamodel.h>
#include <libgdamm/parameterlist.h>
#include <libgdamm/datamodelindex.h>
#include <libgdamm/dict.h>
//#include <libgdamm/serverprovider.h>
//#include <libgda/gda-connection.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaConnection GdaConnection;
typedef struct _GdaConnectionClass GdaConnectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Connection_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class ServerProvider;
typedef GdaServerProviderInfo ServerProviderInfo;

/** Exception class for Gda errors.
 */
class GeneralError : public Glib::Error
{
public:
  enum Code
  {
    GENERAL_OBJECT_NAME_ERROR,
    GENERAL_INCORRECT_VALUE_ERROR,
    GENERAL_OPERATION_ERROR
  };

  GeneralError(Code error_code, const Glib::ustring& error_message);
  explicit GeneralError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::GeneralError::Code> : public Glib::Value_Enum<Gnome::Gda::GeneralError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** Exception class for Gda connection errors.
 */
class ConnectionError : public Glib::Error
{
public:
  enum Code
  {
    CONNECTION_CONN_OPEN_ERROR,
    CONNECTION_DO_QUERY_ERROR,
    CONNECTION_NONEXIST_DSN_ERROR,
    CONNECTION_NO_CNC_SPEC_ERROR,
    CONNECTION_NO_PROVIDER_SPEC_ERROR,
    CONNECTION_OPEN_ERROR,
    CONNECTION_EXECUTE_COMMAND_ERROR
  };

  ConnectionError(Code error_code, const Glib::ustring& error_message);
  explicit ConnectionError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionError::Code> : public Glib::Value_Enum<Gnome::Gda::ConnectionError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


class Client;

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum ConnectionFeature
{
  CONNECTION_FEATURE_AGGREGATES,
  CONNECTION_FEATURE_BLOBS,
  CONNECTION_FEATURE_INDEXES,
  CONNECTION_FEATURE_INHERITANCE,
  CONNECTION_FEATURE_NAMESPACES,
  CONNECTION_FEATURE_PROCEDURES,
  CONNECTION_FEATURE_SEQUENCES,
  CONNECTION_FEATURE_SQL,
  CONNECTION_FEATURE_TRANSACTIONS,
  CONNECTION_FEATURE_SAVEPOINTS,
  CONNECTION_FEATURE_SAVEPOINTS_REMOVE,
  CONNECTION_FEATURE_TRIGGERS,
  CONNECTION_FEATURE_UPDATABLE_CURSOR,
  CONNECTION_FEATURE_USERS,
  CONNECTION_FEATURE_VIEWS,
  CONNECTION_FEATURE_XML_QUERIES
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionFeature> : public Glib::Value_Enum<Gnome::Gda::ConnectionFeature>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum ConnectionSchema
{
  CONNECTION_SCHEMA_AGGREGATES,
  CONNECTION_SCHEMA_DATABASES,
  CONNECTION_SCHEMA_FIELDS,
  CONNECTION_SCHEMA_INDEXES,
  CONNECTION_SCHEMA_LANGUAGES,
  CONNECTION_SCHEMA_NAMESPACES,
  CONNECTION_SCHEMA_PARENT_TABLES,
  CONNECTION_SCHEMA_PROCEDURES,
  CONNECTION_SCHEMA_SEQUENCES,
  CONNECTION_SCHEMA_TABLES,
  CONNECTION_SCHEMA_TRIGGERS,
  CONNECTION_SCHEMA_TYPES,
  CONNECTION_SCHEMA_USERS,
  CONNECTION_SCHEMA_VIEWS,
  CONNECTION_SCHEMA_CONSTRAINTS,
  CONNECTION_SCHEMA_TABLE_CONTENTS
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionSchema> : public Glib::Value_Enum<Gnome::Gda::ConnectionSchema>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%ConnectionOptions operator|(ConnectionOptions, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions operator&(ConnectionOptions, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions operator^(ConnectionOptions, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions operator~(ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions& operator|=(ConnectionOptions&, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions& operator&=(ConnectionOptions&, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions& operator^=(ConnectionOptions&, ConnectionOptions)</tt><br>
 */
enum ConnectionOptions
{
  CONNECTION_OPTIONS_NONE = 0,
  CONNECTION_OPTIONS_READ_ONLY = 1 << 0
};

/** @ingroup libgdammEnums */
inline ConnectionOptions operator|(ConnectionOptions lhs, ConnectionOptions rhs)
  { return static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions operator&(ConnectionOptions lhs, ConnectionOptions rhs)
  { return static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions operator^(ConnectionOptions lhs, ConnectionOptions rhs)
  { return static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions operator~(ConnectionOptions flags)
  { return static_cast<ConnectionOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions& operator|=(ConnectionOptions& lhs, ConnectionOptions rhs)
  { return (lhs = static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline ConnectionOptions& operator&=(ConnectionOptions& lhs, ConnectionOptions rhs)
  { return (lhs = static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline ConnectionOptions& operator^=(ConnectionOptions& lhs, ConnectionOptions rhs)
  { return (lhs = static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionOptions> : public Glib::Value_Flags<Gnome::Gda::ConnectionOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** Manages a connection to a data source.
 * This class offers access to all operations involving an opened connection to a database. 
 * Connection objects are obtained via the Client class.
 * 
 * Once obtained, applications can use a Connection to execute commands, run transactions, and get information about all 
 * objects stored in the underlying database.
 *
 * @ingroup Connections
 */

class Connection : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Connection CppObjectType;
  typedef Connection_Class CppClassType;
  typedef GdaConnection BaseObjectType;
  typedef GdaConnectionClass BaseClassType;

private:  friend class Connection_Class;
  static CppClassType connection_class_;

private:
  // noncopyable
  Connection(const Connection&);
  Connection& operator=(const Connection&);

protected:
  explicit Connection(const Glib::ConstructParams& construct_params);
  explicit Connection(GdaConnection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Connection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaConnection*       gobj()       { return reinterpret_cast<GdaConnection*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaConnection* gobj() const { return reinterpret_cast<GdaConnection*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaConnection* gobj_copy();

private:

protected:

  Connection();
  

public:
  
  static Glib::RefPtr<Connection> create();


  /** Tries to open the connection.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if the connection is opened, and <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool open();
#else
  bool open(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Closes the connection to the underlying data source, but first emits the "conn_to_close" signal.
   */
  void close();
  

  /** Checks whether a connection is open or not.
   * @return <tt>true</tt> if the connection is open, <tt>false</tt> if it's not.
   */
  bool is_opened() const;

  
  /** Gets the Gda::Client object associated with a connection. This
   * is always the client that created the connection, as returned
   * by #gda_client_open_connection.
   * @return The client to which the connection belongs to.
   */
  Glib::RefPtr<Client> get_client();
  
  /** Gets the Gda::Client object associated with a connection. This
   * is always the client that created the connection, as returned
   * by #gda_client_open_connection.
   * @return The client to which the connection belongs to.
   */
  Glib::RefPtr<const Client> get_client() const;

  
  /** Gets the Gda::ConnectionOptions used to open this connection.
   * @return The connection options.
   */
  ConnectionOptions get_options() const;
  
  /** Gets the version string of the underlying database server.
   * @return The server version string.
   */
  Glib::ustring get_server_version() const;

  
  /** Gets the name of the currently active database in the given
   *  @a GdaConnection .
   * @return The name of the current database.
   */
  Glib::ustring get_database() const;
  
  /** 
   * @return The data source name the connection object is connected
   * to.
   */
  Glib::ustring get_dsn() const;
  
  /** Sets the data source of the connection. If the connection is already opened,
   * then no action is performed at all and <tt>false</tt> is returned.
   * 
   * If the requested datasource does not exist, then nothing is done and <tt>false</tt>
   * is returned.
   * @param datasource A gda datasource.
   * @return <tt>true</tt> on success.
   */
  bool set_dsn(const Glib::ustring& datasource);
  
  /** Gets the connection string used to open this connection.
   * 
   * The connection string is the string sent over to the underlying
   * database provider, which describes the parameters to be used
   * to open a connection on the underlying data source.
   * @return The connection string used when opening the connection.
   */
  Glib::ustring get_cnc_string() const;

  
  /** Gets the provider id that this connection is connected to.
   * @return The provider ID used to open this connection.
   */
  Glib::ustring get_provider() const;
  
  /** Get a pointer to the Gda::ServerProvider object used to access the database
   * @return The Gda::ServerProvider (NEVER <tt>0</tt>).
   */
  Glib::RefPtr<ServerProvider> get_provider_obj();
  
  /** Get a pointer to the Gda::ServerProvider object used to access the database
   * @return The Gda::ServerProvider (NEVER <tt>0</tt>).
   */
  Glib::RefPtr<const ServerProvider> get_provider_obj() const;

  //Let's not bother trying to copy the ServerProviderInfo by value.
  //Its (boolean) contents should just be examined quickly and then forgotten.
   

  /** Get a pointer to a Gda::ServerProviderInfo structure (which must not be modified)
   * to retreive specific information about the provider used by @a cnc .
   */
  const ServerProviderInfo* get_infos() const;

  
  /** Gets the user name used to open this connection.
   * @return The user name.
   */
  Glib::ustring get_username() const;
  
  /** Sets the user name for the connection. If the connection is already opened,
   * then no action is performed at all and <tt>false</tt> is returned.
   * @return <tt>true</tt> on success.
   */
  bool set_username(const Glib::ustring& username);
  
  /** Gets the password used to open this connection.
   * @return The password.
   */
  Glib::ustring get_password() const;
  
  /** Sets the user password for the connection to the server. If the connection is already opened,
   * then no action is performed at all and <tt>false</tt> is returned.
   * @return <tt>true</tt> on success.
   */
  bool set_password(const Glib::ustring& password);

  
  /** Adds an event to the given connection. This function is usually
   * called by providers, to inform clients of events that happened
   * during some operation.
   * 
   * As soon as a provider (or a client, it does not matter) calls this
   * function with an @a event  object which is an error,
   * the connection object (and the associated Gda::Client object)
   * emits the "error" signal, to which clients can connect to be
   * informed of events.
   * 
   * WARNING: the reference to the @a event  object is stolen by this function!
   * @param event Is stored internally, so you don't need to unref it.
   */
  void add_event(const Glib::RefPtr<ConnectionEvent>& event);
  
  /** Adds a new error to the given connection object. This is just a convenience
   * function that simply creates a Gda::ConnectionEvent and then calls
   * #gda_server_connection_add_error.
   * @param str A format string (see the printf(3) documentation).
   * @param Varargs The arguments to insert in the error message.
   * @return A new Gda::ConnectionEvent object, however the caller does not hold a reference to the returned
   * object, and if need be the caller must call Glib::object_ref() on it.
   */
   Glib::RefPtr<ConnectionEvent> add_event_string(const Glib::ustring& str);

  //TODO: Use ListHandle, and watch out because the C function frees the input list parameter.
  //However, this is not high-priority because this is apparently just a convenience function.
  //You canuse add_event() repeatedly instead.
  //_WRAP_METHOD(void add_events_list(GList *error_list), gda_connection_add_events_list)
  

  /** This function lets you clear the list of Gda::ConnectionEvent's of the
   * given connection.
   */
  void clear_events_list();

  
  /** Changes the current database for the given connection. This operation
   * is not available in all providers.
   * @param name Name of database to switch to.
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool change_database(const Glib::ustring& name);

   //Use deep ownership because we own both the list and its elements;
   

  /** Executes a selection command on the given connection.
   * 
   * This function returns a Gda::DataModel resulting from the SELECT statement, or <tt>0</tt>
   * if an error occurred.
   * 
   * Note that no check is made regarding the actual number of statements in @a cmd  or if it really contains a SELECT
   * statement. This function is just a convenience function around the execute_command()
   * function. If @a cmd  contains several statements, the last Gda::DataModel is returned.
   * 
   * See the documentation of the execute_command() for information
   * about the @a params  list of parameters.
   * @param cmd A Gda::Command.
   * @param params Parameter list for the command.
   * @param error A place to store an error, or <tt>0</tt>.
   * @return A Gda::DataModel containing the data returned by the
   * data source, or <tt>0</tt> if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> execute_select_command(const Command& cmd, const Glib::RefPtr<ParameterList>& params);
#else
  Glib::RefPtr<DataModel> execute_select_command(const Command& cmd, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Executes a selection command on the given connection.
   *
   * Note that no check is made regarding the actual number of statements in @a cmd or if it really contains a SELECT
   * statement. This function is just a convenience function around the execute_command()
   * method. If @a cmd contains several statements, only the last DataModel is returned.
   *
   * @param cmd A Command.
   * @result A DataModel containing the data returned by the data source, or a null DataModel if an error occurred.
   *
   * @throw ConnectionError
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> execute_select_command(const Command& cmd);
#else
  Glib::RefPtr<DataModel> execute_select_command(const Command& cmd, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  /** Executes a selection command on the given connection.
   *
   * Note that no check is made regarding the actual number of statements in @a cmd or if it really contains a SELECT
   * statement. This function is just a convenience function around the execute_command()
   * method. If @a cmd contains several statements, only the last DataModel is returned.
   *
   * @param cmd A SQL command string.
   * @result A DataModel containing the data returned by the
   * data source, or a null DataModel if an error occurred.
   *
   * @throw ConnectionError
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> execute_select_command(const Glib::ustring& cmd);
#else
  Glib::RefPtr<DataModel> execute_select_command(const Glib::ustring& cmd, std::auto_ptr<Glib::Error>& error);
#endif

  
  /** Executes a selection command on the given connection.
   * 
   * This function returns the number of rows impacted by the execution of @a cmd , or -1
   * if an error occurred, or -2 if the provider does not return the number of rows impacted.
   * 
   * Note that no check is made regarding the actual number of statements in @a cmd  or if it really contains a non SELECT
   * statement. This function is just a convenience function around the execute_command()
   * function. If @a cmd  contains several statements, the last Gda::ParameterList is returned.
   * 
   * See the documentation of the execute_command() for information
   * about the @a params  list of parameters.
   * @param cmd A Gda::Command.
   * @param params Parameter list for the command.
   * @param error A place to store an error, or <tt>0</tt>.
   * @return The number of rows impacted (&gt;=0) or -1 or -2.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  int execute_non_select_command(const Command& cmd, const Glib::RefPtr<ParameterList>& params);
#else
  int execute_non_select_command(const Command& cmd, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Executes a non-selection command on the given connection.
   *
   * This function returns the number of rows impacted by the execution of @a cmd, or -1
   * if an error occurred, or -2 if the provider does not return the number of rows impacted.
   *
   * Note that no check is made regarding the actual number of statements in @a cmd or if it really contains a non SELECT
   * statement. This function is just a convenience function around the execute_command()
   * function. If @a cmd contains several statements, the last ParameterList is returned.
   *
   * @param cmd A Command.
   * @result the number of rows affected (>=0) or -1 or -2 
   *
   * @throw ConnectionError
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  int execute_non_select_command(const Command& cmd);
#else
  int execute_non_select_command(const Command& cmd, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  /** Executes a non-selection command on the given connection.
   *
   * This function returns the number of rows impacted by the execution of @a cmd, or -1
   * if an error occurred, or -2 if the provider does not return the number of rows impacted.
   *
   * Note that no check is made regarding the actual number of statements in @a cmd or if it really contains a non SELECT
   * statement. This function is just a convenience function around the execute_command()
   * function. If @a cmd contains several statements, the last ParameterList is returned.
   *
   * @param cmd A Command.
   * @result the number of rows affected (>=0) or -1 or -2 
   *
   * @throw ConnectionError
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  int execute_non_select_command(const Glib::ustring& cmd);
#else
  int execute_non_select_command(const Glib::ustring& cmd, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  //Note that we do not add a non-const version of this because the documentation says that it should not be modified:
  
  /** Get the status of @a cnc  regarding transactions. The returned object should not be modified
   * or destroyed; however it may be modified or destroyed by the connection itself.
   * 
   * If <tt>0</tt> is returned, then no transaction has been associated with @a cnc 
   * @return A Gda::TransactionStatus object, or <tt>0</tt>.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<const TransactionStatus> get_transaction_status() const;
#else
  Glib::RefPtr<const TransactionStatus> get_transaction_status(std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


/*
gint                 gda_connection_execute_non_select_command (GdaConnection *cnc, GdaCommand *cmd,
								GdaParameterList *params, GError **error);


  typedef ListHandle<DataModel> ListDataModels
  ListDataModels execute_command(const Command& cmd, Glib::RefPtr<ParameterList>& params), gda_connection_execute_command, errthrow)
  _IGNORE(gda_connection_execute_command)

  Glib::RefPtr<DataModel> execute_command(const Command& cmd);
  Glib::RefPtr<DataModel> execute_command(const Glib::ustring& cmd);
 
  //_WRAP_METHOD(Glib::RefPtr<DataModel> execute_command(const Command& cmd, const Glib::RefPtr<ParameterList>& params), gda_connection_execute_command_l, errthrow)
*/


  /** Starts a transaction on the data source, identified by the
   *  @a xaction  parameter.
   * 
   * Before starting a transaction, you can check whether the underlying
   * provider does support transactions or not by using the
   * #supports_feature() function.
   * @param name The name of the transation to start.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if the transaction was started successfully, <tt>false</tt>
   * otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool begin_transaction(const Glib::ustring& name, TransactionIsolation level);
#else
  bool begin_transaction(const Glib::ustring& name, TransactionIsolation level, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Commits the given transaction to the backend database. You need to call
   * begin_transaction() first.
   * @param name The name of the transation to commit.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if the transaction was finished successfully,
   * <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool commit_transaction(const Glib::ustring& name);
#else
  bool commit_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Rollbacks the given transaction. This means that all changes
   * made to the underlying data source since the last call to
   * #begin_transaction() or #commit_transaction()
   * will be discarded.
   * @param name The name of the transation to commit.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if the operation was successful, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool rollback_transaction(const Glib::ustring& name);
#else
  bool rollback_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Adds a SAVEPOINT named @a name .
   * @param name Name of the savepoint to add.
   * @param error A place to store errors or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool add_savepoint(const Glib::ustring& name);
#else
  bool add_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Rollback all the modifications made after the SAVEPOINT named @a name .
   * @param name Name of the savepoint to rollback to.
   * @param error A place to store errors or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool rollback_savepoint(const Glib::ustring& name);
#else
  bool rollback_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Delete the SAVEPOINT named @a name  when not used anymore.
   * @param name Name of the savepoint to delete.
   * @param error A place to store errors or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool delete_savepoint(const Glib::ustring& name);
#else
  bool delete_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


   //Use a special conversion here, because we should not own any part of the returned GList, 
   //according to the documentation for gda_connection_get_events(), 
   //and because we need to unconst the GList.:
    

  /** Retrieves a list of the last errors occurred during the connection.
   * You can make a copy of the list using #gda_connection_event_list_copy.
   * @return A GList of Gda::ConnectionEvent.
   */
  Glib::ListHandle< Glib::RefPtr<ConnectionEvent> > get_events();
  
  /** Retrieves a list of the last errors occurred during the connection.
   * You can make a copy of the list using #gda_connection_event_list_copy.
   * @return A GList of Gda::ConnectionEvent.
   */
  Glib::ListHandle< Glib::RefPtr<const ConnectionEvent> > get_events() const;


  /** Produces a fully quoted and escaped string from a GValue
   * @param from G::Value to convert from.
   * @return Escaped and quoted value or <tt>0</tt> if not supported.
   */
  Glib::ustring value_to_sql_string(const Value& from) const;;

  
  /** Asks the underlying provider for if a specific feature is supported.
   * @param feature Feature to ask for.
   * @return <tt>true</tt> if the provider supports it, <tt>false</tt> if not.
   */
  bool supports_feature(ConnectionFeature feature) const;

  
  /** Asks the underlying data source for a list of database objects.
   * 
   * This is the function that lets applications ask the different
   * providers about all their database objects (tables, views, procedures,
   * etc). The set of database objects that are retrieved are given by the
   * 2 parameters of this function: @a schema , which specifies the specific
   * schema required, and @a params , which is a list of parameters that can
   * be used to give more detail about the objects to be returned.
   * 
   * The list of parameters is specific to each schema type, see the
   * get_schema() virtual method for providers for more details.
   * @param schema Database schema to get.
   * @param params Parameter list.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return A Gda::DataModel containing the data required. The caller is responsible
   * of freeing the returned model using Glib::object_unref().
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> get_schema(ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params);
#else
  Glib::RefPtr<DataModel> get_schema(ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  // TODO: This is not constversion because the generated code does not pass
  // error to the non-const function if exceptions are disabled.
  
  /** Asks the underlying data source for a list of database objects.
   * 
   * This is the function that lets applications ask the different
   * providers about all their database objects (tables, views, procedures,
   * etc). The set of database objects that are retrieved are given by the
   * 2 parameters of this function: @a schema , which specifies the specific
   * schema required, and @a params , which is a list of parameters that can
   * be used to give more detail about the objects to be returned.
   * 
   * The list of parameters is specific to each schema type, see the
   * get_schema() virtual method for providers for more details.
   * @param schema Database schema to get.
   * @param params Parameter list.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return A Gda::DataModel containing the data required. The caller is responsible
   * of freeing the returned model using Glib::object_unref().
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<const DataModel> get_schema(ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params) const;
#else
  Glib::RefPtr<const DataModel> get_schema(ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Asks the underlying data source for a list of database objects.
   * This is the function that lets applications ask the different providers about all their database objects (tables,
   * views, procedures, etc). The set of database objects that are retrieved are given by the 2 parameters of this 
   * function: schema, which specifies the specific schema required, and params, which is a list of parameters that can 
   * be used to give more detail about the objects to be returned.
   *
   * The list of parameters is specific to each schema type, see the get_schema() virtual method for providers for more details.
   *
   * @param schema Database schema to get.
   * @result A DataModel containing the data required.
   *
   * @throw Gda::ConnectionError
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> get_schema(ConnectionSchema schema);
#else
  Glib::RefPtr<DataModel> get_schema(ConnectionSchema schema, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  /** Asks the underlying data source for a list of database objects.
   * This is the function that lets applications ask the different providers about all their database objects (tables,
   * views, procedures, etc). The set of database objects that are retrieved are given by the 2 parameters of this 
   * function: schema, which specifies the specific schema required, and params, which is a list of parameters that can 
   * be used to give more detail about the objects to be returned.
   *
   * The list of parameters is specific to each schema type, see the get_schema() virtual method for providers for more details.
   *
   * @param schema Database schema to get.
   * @result A DataModel containing the data required.
   *
   * @throw Gda::ConnectionError
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<const DataModel> get_schema(ConnectionSchema schema) const;
#else
  Glib::RefPtr<const DataModel> get_schema(ConnectionSchema schema, std::auto_ptr<Glib::Error>& error) const;
#endif // GLIBMM_EXCEPTIONS_ENABLED

  
  /** Retrieve from the given Gda::Connection the ID of the last inserted row.
   * A connection must be specified, and, optionally, a result set. If not <tt>0</tt>,
   * the underlying provider should try to get the last insert ID for the given result set.
   * @param recset Recordset.
   * @return A string representing the ID of the last inserted row, or <tt>0</tt>
   * if an error occurred or no row has been inserted. It is the caller's
   * reponsibility to free the returned string.
   */
  Glib::ustring get_last_insert_id(const Glib::RefPtr<DataModel>& recset) const; 


/**
   * @par Prototype:
   * <tt>void %error(const Glib::RefPtr<ConnectionEvent>& error)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<ConnectionEvent>& > signal_error();


/**
   * @par Prototype:
   * <tt>void %conn_opened()</tt>
   */

  Glib::SignalProxy0< void > signal_conn_opened();

  
/**
   * @par Prototype:
   * <tt>void %conn_to_close()</tt>
   */

  Glib::SignalProxy0< void > signal_conn_to_close();

  
/**
   * @par Prototype:
   * <tt>void %conn_closed()</tt>
   */

  Glib::SignalProxy0< void > signal_conn_closed();

  
/**
   * @par Prototype:
   * <tt>void %dsn_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_dsn_changed();

  
/**
   * @par Prototype:
   * <tt>void %transaction_status_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_transaction_status_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_error(const Glib::RefPtr<ConnectionEvent>& error);
  virtual void on_conn_opened();
  virtual void on_conn_to_close();
  virtual void on_conn_closed();
  virtual void on_dsn_changed();
  virtual void on_transaction_status_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::Connection
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::Connection> wrap(GdaConnection* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_CONNECTION_H */

