// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgdamm/connection.h>
#include <libgdamm/private/connection_p.h>

/* $Id: connection.ccg,v 1.18 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- // 

/* connection.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/serverprovider.h>
#include <libgdamm/client.h>
#include <libgdamm/command.h>
#include <libgda/gda-enum-types.h>
#include <libgda/gda-connection.h>
#include <libgda/libgda.h> //For GDA_GENERAL_ERROR

namespace Gnome
{

namespace Gda
{

Connection::~Connection()
{
  //Make sure the connection is closed.
  //An open connection with no associated connection object could never be closed.
  if(gobj())
  {
    if(is_opened())
      close();
  }
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::get_schema(ConnectionSchema schema)
#else
Glib::RefPtr<DataModel> Connection::get_schema(ConnectionSchema schema, std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  GError *gerror = 0;
  Glib::RefPtr<DataModel> retval = Glib::wrap(gda_connection_get_schema(gobj(), ((GdaConnectionSchema)(schema)), 0, &gerror));
  if(retval)
    retval->reference();

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror) ::Glib::Error::throw_exception(gerror);
#else
  if(gerror) error = ::Glib::Error::throw_exception(gerror);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<const DataModel> Connection::get_schema(ConnectionSchema schema) const
#else
Glib::RefPtr<const DataModel> Connection::get_schema(ConnectionSchema schema, std::auto_ptr<Glib::Error>& error) const
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  return const_cast<Connection*>(this)->get_schema(schema);
#else
  return const_cast<Connection*>(this)->get_schema(schema, error);
#endif // GLIBMM_EXCEPTIONS_ENABLED
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::execute_select_command(const Command& cmd)
#else
Glib::RefPtr<DataModel> Connection::execute_select_command(const Command& cmd, std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  GError *gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_execute_select_command(gobj(), const_cast<GdaCommand*>((cmd).gobj()), 0, &(gerror)));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror) ::Glib::Error::throw_exception(gerror);
#else
  if(gerror) error = ::Glib::Error::throw_exception(gerror);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::execute_select_command(const Glib::ustring& cmd)
#else
Glib::RefPtr<DataModel> Connection::execute_select_command(const Glib::ustring& cmd, std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  Command command(cmd);

  GError *gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_execute_select_command(gobj(), const_cast<GdaCommand*>((command).gobj()), 0, &(gerror)));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror) ::Glib::Error::throw_exception(gerror);
#else
  if(gerror) error = ::Glib::Error::throw_exception(gerror);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int Connection::execute_non_select_command(const Command& cmd)
#else
int Connection::execute_non_select_command(const Command& cmd, std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  GError *gerror = 0;

  int retvalue = gda_connection_execute_non_select_command(gobj(), const_cast<GdaCommand*>((cmd).gobj()), 0, &(gerror));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror) ::Glib::Error::throw_exception(gerror);
#else
  if(gerror) error = ::Glib::Error::throw_exception(gerror);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int Connection::execute_non_select_command(const Glib::ustring& cmd)
#else
int Connection::execute_non_select_command(const Glib::ustring& cmd, std::auto_ptr<Glib::Error>& error)
#endif
{
  Command command(cmd);

  GError *gerror = 0;
  int retvalue = gda_connection_execute_non_select_command(gobj(), const_cast<GdaCommand*>(command.gobj()), 0, &(gerror));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror) ::Glib::Error::throw_exception(gerror);
#else
  if(gerror) error = ::Glib::Error::throw_exception(gerror);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}

void Connection::close()
{
  //gda_connection_close() does an unref, but we don't want that:
  reference();
  gda_connection_close(gobj());
}

} //namespace Gda

} //namespace Gnome


namespace
{


static void Connection_signal_error_callback(GdaConnection* self, GdaConnectionEvent* p0,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,const Glib::RefPtr<ConnectionEvent>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Connection_signal_error_info =
{
  "error",
  (GCallback) &Connection_signal_error_callback,
  (GCallback) &Connection_signal_error_callback
};


static const Glib::SignalProxyInfo Connection_signal_conn_opened_info =
{
  "conn_opened",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_conn_to_close_info =
{
  "conn_to_close",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_conn_closed_info =
{
  "conn_closed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_dsn_changed_info =
{
  "dsn_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_transaction_status_changed_info =
{
  "transaction_status_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


Gnome::Gda::GeneralError::GeneralError(Gnome::Gda::GeneralError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDA_GENERAL_ERROR, error_code, error_message)
{}

Gnome::Gda::GeneralError::GeneralError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Gda::GeneralError::Code Gnome::Gda::GeneralError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Gnome::Gda::GeneralError::throw_func(GError* gobject)
{
  throw Gnome::Gda::GeneralError(gobject);
}
#else
//When not using exceptions, we just pass the Exception object around without throwing it:
std::auto_ptr<Glib::Error> Gnome::Gda::GeneralError::throw_func(GError* gobject)
{
  return std::auto_ptr<Glib::Error>(new Gnome::Gda::GeneralError(gobject));
}
#endif //GLIBMM_EXCEPTIONS_ENABLED

// static
GType Glib::Value<Gnome::Gda::GeneralError::Code>::value_type()
{
  return gda_general_error_get_type();
}


Gnome::Gda::ConnectionError::ConnectionError(Gnome::Gda::ConnectionError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDA_CONNECTION_ERROR, error_code, error_message)
{}

Gnome::Gda::ConnectionError::ConnectionError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Gda::ConnectionError::Code Gnome::Gda::ConnectionError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Gnome::Gda::ConnectionError::throw_func(GError* gobject)
{
  throw Gnome::Gda::ConnectionError(gobject);
}
#else
//When not using exceptions, we just pass the Exception object around without throwing it:
std::auto_ptr<Glib::Error> Gnome::Gda::ConnectionError::throw_func(GError* gobject)
{
  return std::auto_ptr<Glib::Error>(new Gnome::Gda::ConnectionError(gobject));
}
#endif //GLIBMM_EXCEPTIONS_ENABLED

// static
GType Glib::Value<Gnome::Gda::ConnectionError::Code>::value_type()
{
  return gda_connection_error_get_type();
}

// static
GType Glib::Value<Gnome::Gda::ConnectionFeature>::value_type()
{
  return gda_connection_feature_get_type();
}

// static
GType Glib::Value<Gnome::Gda::ConnectionSchema>::value_type()
{
  return gda_connection_schema_get_type();
}

// static
GType Glib::Value<Gnome::Gda::ConnectionOptions>::value_type()
{
  return gda_connection_options_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Gda::Connection> wrap(GdaConnection* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::Connection>( dynamic_cast<Gnome::Gda::Connection*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Class& Connection_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Connection_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gda_connection_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Connection_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->error = &error_callback;
  klass->conn_opened = &conn_opened_callback;
  klass->conn_to_close = &conn_to_close_callback;
  klass->conn_closed = &conn_closed_callback;
  klass->dsn_changed = &dsn_changed_callback;
  klass->transaction_status_changed = &transaction_status_changed_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Connection_Class::error_callback(GdaConnection* self, GdaConnectionEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_error(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->error)
    (*base->error)(self, p0);
}
void Connection_Class::conn_opened_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_conn_opened();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->conn_opened)
    (*base->conn_opened)(self);
}
void Connection_Class::conn_to_close_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_conn_to_close();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->conn_to_close)
    (*base->conn_to_close)(self);
}
void Connection_Class::conn_closed_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_conn_closed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->conn_closed)
    (*base->conn_closed)(self);
}
void Connection_Class::dsn_changed_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_dsn_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->dsn_changed)
    (*base->dsn_changed)(self);
}
void Connection_Class::transaction_status_changed_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_transaction_status_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->transaction_status_changed)
    (*base->transaction_status_changed)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Connection_Class::wrap_new(GObject* object)
{
  return new Connection((GdaConnection*)object);
}


/* The implementation: */

GdaConnection* Connection::gobj_copy()
{
  reference();
  return gobj();
}

Connection::Connection(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

Connection::Connection(GdaConnection* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Connection::CppClassType Connection::connection_class_; // initialize static member

GType Connection::get_type()
{
  return connection_class_.init().get_type();
}

GType Connection::get_base_type()
{
  return gda_connection_get_type();
}


Connection::Connection()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(connection_class_.init()))
{
  }

Glib::RefPtr<Connection> Connection::create()
{
  return Glib::RefPtr<Connection>( new Connection() );
}
#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::open()
#else
bool Connection::open(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_open(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

bool Connection::is_opened() const
{
  return gda_connection_is_opened(const_cast<GdaConnection*>(gobj()));
}

Glib::RefPtr<Client> Connection::get_client()
{

  Glib::RefPtr<Client> retvalue = Glib::wrap(gda_connection_get_client(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Client> Connection::get_client() const
{
  return const_cast<Connection*>(this)->get_client();
}

ConnectionOptions Connection::get_options() const
{
  return ((ConnectionOptions)(gda_connection_get_options(const_cast<GdaConnection*>(gobj()))));
}

Glib::ustring Connection::get_server_version() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_server_version(const_cast<GdaConnection*>(gobj())));
}

Glib::ustring Connection::get_database() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_database(const_cast<GdaConnection*>(gobj())));
}

Glib::ustring Connection::get_dsn() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_dsn(const_cast<GdaConnection*>(gobj())));
}

bool Connection::set_dsn(const Glib::ustring& datasource)
{
  return gda_connection_set_dsn(gobj(), datasource.c_str());
}

Glib::ustring Connection::get_cnc_string() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_cnc_string(const_cast<GdaConnection*>(gobj())));
}

Glib::ustring Connection::get_provider() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_provider(const_cast<GdaConnection*>(gobj())));
}

Glib::RefPtr<ServerProvider> Connection::get_provider_obj()
{

  Glib::RefPtr<ServerProvider> retvalue = Glib::wrap(gda_connection_get_provider_obj(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const ServerProvider> Connection::get_provider_obj() const
{
  return const_cast<Connection*>(this)->get_provider_obj();
}

const ServerProviderInfo* Connection::get_infos() const
{
  return static_cast<ServerProviderInfo*>(gda_connection_get_infos(const_cast<GdaConnection*>(gobj())));
}

Glib::ustring Connection::get_username() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_username(const_cast<GdaConnection*>(gobj())));
}

bool Connection::set_username(const Glib::ustring& username)
{
  return gda_connection_set_username(gobj(), username.c_str());
}

Glib::ustring Connection::get_password() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_password(const_cast<GdaConnection*>(gobj())));
}

bool Connection::set_password(const Glib::ustring& password)
{
  return gda_connection_set_password(gobj(), password.c_str());
}

void Connection::add_event(const Glib::RefPtr<ConnectionEvent>& event)
{
gda_connection_add_event(gobj(), Glib::unwrap(event)); 
}

Glib::RefPtr<ConnectionEvent> Connection::add_event_string(const Glib::ustring& str)
{
  return Glib::wrap(gda_connection_add_event_string(gobj(), str.c_str()));
}

void Connection::clear_events_list()
{
gda_connection_clear_events_list(gobj()); 
}

bool Connection::change_database(const Glib::ustring& name)
{
  return gda_connection_change_database(gobj(), name.c_str());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::execute_select_command(const Command& cmd, const Glib::RefPtr<ParameterList>& params)
#else
Glib::RefPtr<DataModel> Connection::execute_select_command(const Command& cmd, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_execute_select_command(gobj(), const_cast<GdaCommand*>((cmd).gobj()), Glib::unwrap(params), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int Connection::execute_non_select_command(const Command& cmd, const Glib::RefPtr<ParameterList>& params)
#else
int Connection::execute_non_select_command(const Command& cmd, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  int retvalue = gda_connection_execute_non_select_command(gobj(), const_cast<GdaCommand*>((cmd).gobj()), Glib::unwrap(params), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<const TransactionStatus> Connection::get_transaction_status() const
#else
Glib::RefPtr<const TransactionStatus> Connection::get_transaction_status(std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<const TransactionStatus> retvalue = Glib::wrap(gda_connection_get_transaction_status(const_cast<GdaConnection*>(gobj())));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::begin_transaction(const Glib::ustring& name, TransactionIsolation level)
#else
bool Connection::begin_transaction(const Glib::ustring& name, TransactionIsolation level, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_begin_transaction(gobj(), name.c_str(), ((GdaTransactionIsolation)(level)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::commit_transaction(const Glib::ustring& name)
#else
bool Connection::commit_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_commit_transaction(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::rollback_transaction(const Glib::ustring& name)
#else
bool Connection::rollback_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_rollback_transaction(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::add_savepoint(const Glib::ustring& name)
#else
bool Connection::add_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_add_savepoint(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::rollback_savepoint(const Glib::ustring& name)
#else
bool Connection::rollback_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_rollback_savepoint(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::delete_savepoint(const Glib::ustring& name)
#else
bool Connection::delete_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_delete_savepoint(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

Glib::ListHandle< Glib::RefPtr<ConnectionEvent> > Connection::get_events()
{
  return Glib::ListHandle< Glib::RefPtr<ConnectionEvent> >((GList*)gda_connection_get_events(gobj()), Glib::OWNERSHIP_NONE);
}

Glib::ListHandle< Glib::RefPtr<const ConnectionEvent> > Connection::get_events() const
{
  return Glib::ListHandle< Glib::RefPtr<const ConnectionEvent> >((GList*)gda_connection_get_events(const_cast<GdaConnection*>(gobj())), Glib::OWNERSHIP_NONE);
}

Glib::ustring Connection::value_to_sql_string(const Value& from) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_connection_value_to_sql_string(const_cast<GdaConnection*>(gobj()), const_cast<GValue*>((from).gobj())));
}

bool Connection::supports_feature(ConnectionFeature feature) const
{
  return gda_connection_supports_feature(const_cast<GdaConnection*>(gobj()), ((GdaConnectionFeature)(feature)));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::get_schema(ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params)
#else
Glib::RefPtr<DataModel> Connection::get_schema(ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_get_schema(gobj(), ((GdaConnectionSchema)(schema)), Glib::unwrap(params), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<const DataModel> Connection::get_schema(ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params) const
#else
Glib::RefPtr<const DataModel> Connection::get_schema(ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<const DataModel> retvalue = Glib::wrap(gda_connection_get_schema(const_cast<GdaConnection*>(gobj()), ((GdaConnectionSchema)(schema)), Glib::unwrap(params), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::ustring Connection::get_last_insert_id(const Glib::RefPtr<DataModel>& recset) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_connection_get_last_insert_id(const_cast<GdaConnection*>(gobj()), Glib::unwrap(recset)));
}


Glib::SignalProxy1< void,const Glib::RefPtr<ConnectionEvent>& > Connection::signal_error()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<ConnectionEvent>& >(this, &Connection_signal_error_info);
}


Glib::SignalProxy0< void > Connection::signal_conn_opened()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_conn_opened_info);
}


Glib::SignalProxy0< void > Connection::signal_conn_to_close()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_conn_to_close_info);
}


Glib::SignalProxy0< void > Connection::signal_conn_closed()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_conn_closed_info);
}


Glib::SignalProxy0< void > Connection::signal_dsn_changed()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_dsn_changed_info);
}


Glib::SignalProxy0< void > Connection::signal_transaction_status_changed()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_transaction_status_changed_info);
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gnome::Gda::Connection::on_error(const Glib::RefPtr<ConnectionEvent>& error)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->error)
    (*base->error)(gobj(),Glib::unwrap(error));
}
void Gnome::Gda::Connection::on_conn_opened()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->conn_opened)
    (*base->conn_opened)(gobj());
}
void Gnome::Gda::Connection::on_conn_to_close()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->conn_to_close)
    (*base->conn_to_close)(gobj());
}
void Gnome::Gda::Connection::on_conn_closed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->conn_closed)
    (*base->conn_closed)(gobj());
}
void Gnome::Gda::Connection::on_dsn_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->dsn_changed)
    (*base->dsn_changed)(gobj());
}
void Gnome::Gda::Connection::on_transaction_status_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->transaction_status_changed)
    (*base->transaction_status_changed)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gda

} // namespace Gnome


