// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_SERVEROPERATION_H
#define _LIBGDAMM_SERVEROPERATION_H


#include <glibmm.h>

/* $Id: serveroperation.hg,v 1.2 2006/11/08 00:52:25 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* serveroperation.h
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgda/gda-server-provider.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaServerOperation GdaServerOperation;
typedef struct _GdaServerOperationClass GdaServerOperationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class ServerOperation_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{


class Connection;
class ServerProvider;

//_WRAP_ENUM(ClientSpecsType, GdaClientSpecsType)
/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum ServerOperationNodeType
{
  SERVER_OPERATION_NODE_PARAMLIST,
  SERVER_OPERATION_NODE_DATA_MODEL,
  SERVER_OPERATION_NODE_PARAM,
  SERVER_OPERATION_NODE_SEQUENCE,
  SERVER_OPERATION_NODE_SEQUENCE_ITEM,
  SERVER_OPERATION_NODE_DATA_MODEL_COLUMN,
  SERVER_OPERATION_NODE_UNKNOWN
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ServerOperationNodeType> : public Glib::Value_Enum<Gnome::Gda::ServerOperationNodeType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum ServerOperationNodeStatus
{
  SERVER_OPERATION_STATUS_OPTIONAL,
  SERVER_OPERATION_STATUS_REQUIRED,
  SERVER_OPERATION_STATUS_UNKNOWN
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ServerOperationNodeStatus> : public Glib::Value_Enum<Gnome::Gda::ServerOperationNodeStatus>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum ServerOperationType
{
  SERVER_OPERATION_CREATE_DB,
  SERVER_OPERATION_DROP_DB,
  SERVER_OPERATION_CREATE_TABLE,
  SERVER_OPERATION_DROP_TABLE,
  SERVER_OPERATION_RENAME_TABLE,
  SERVER_OPERATION_ADD_COLUMN,
  SERVER_OPERATION_DROP_COLUMN,
  SERVER_OPERATION_CREATE_INDEX,
  SERVER_OPERATION_DROP_INDEX,
  SERVER_OPERATION_CREATE_VIEW,
  SERVER_OPERATION_DROP_VIEW,
  SERVER_OPERATION_LAST
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ServerOperationType> : public Glib::Value_Enum<Gnome::Gda::ServerOperationType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

typedef GdaServerOperationNode ServerOperationNode;

/** @defgroup DDL Data definition (DDL) queries
 */

/** Handles any DDL query in an abstract way.
 *
 * Basically this object is just a named data store: it can store named values, 
 * the values being organized hirarchically. A value can be read from its path
 * (similar to a Unix file path) using the get_value_at() method.
 * 
 * @ingroup DDL
 */

class ServerOperation : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ServerOperation CppObjectType;
  typedef ServerOperation_Class CppClassType;
  typedef GdaServerOperation BaseObjectType;
  typedef GdaServerOperationClass BaseClassType;

private:  friend class ServerOperation_Class;
  static CppClassType serveroperation_class_;

private:
  // noncopyable
  ServerOperation(const ServerOperation&);
  ServerOperation& operator=(const ServerOperation&);

protected:
  explicit ServerOperation(const Glib::ConstructParams& construct_params);
  explicit ServerOperation(GdaServerOperation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ServerOperation();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaServerOperation*       gobj()       { return reinterpret_cast<GdaServerOperation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaServerOperation* gobj() const { return reinterpret_cast<GdaServerOperation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaServerOperation* gobj_copy();

private:


public:
  // The C version of these take varargs for some reason.
  
  /** Get the value for the node at the path formed using @a path_format and ... (the rules are the same as
   * for Glib::strdup_printf())
   * @param path_format A complete path to a node (starting with "/").
   * @param Varargs Arguments to use with @a path_format to make a complete path.
   * @return A constant Value if a value has been defined, or <tt>0</tt> if the value is undefined or
   * if the @a path is not defined or @a path does not hold any value.
   */

  Glib::ValueBase get_value_at(const Glib::ustring& path_format) const;

  
  /** Set the value for the node at the path formed using @a path_format and @... the rules are the same as
   * for Glib::strdup_printf()). 
   * 
   * Note that trying to set a value for a path which is not used by the current
   * provider (such as "/TABLE_OPTIONS_P/TABLE_ENGINE" for a PostgreSQL connection), will <em>not</em> generate
   * any error; this allows one to set all the possible parameters and use the same code for several providers.
   * 
   * Here are the possible formats of @a path_format:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;If the path corresponds to a Gda::Holder, then the parameter is set to @a value&lt;/listitem&gt;
   * &lt;listitem&gt;If the path corresponds to a sequence item like for example "/SEQUENCE_NAME/5/NAME" for
   * the "NAME" value of the 6th item of the "SEQUENCE_NAME" sequence then:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;if the sequence already has 6 or more items, then the value is just set to the corresponding 
   * value in the 6th item of the sequence&lt;/listitem&gt;
   * &lt;listitem&gt;if the sequence has less then 6 items, then items are added up to the 6th one before setting
   * the value to the corresponding in the 6th item of the sequence&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * &lt;/listitem&gt;
   * &lt;listitem&gt;If the path corresponds to a Gda::DataModel, like for example "/ARRAY/@ @a COLUMN/5" for the value at the
   * 6th row of the "COLUMN" column of the "ARRAY" data model, then:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;if the data model already contains 6 or more rows, then the value is just set&lt;/listitem&gt;
   * &lt;listitem&gt;if the data model has less than 6 rows, then rows are added up to the 6th one before setting
   * the value&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * &lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * @param value A string.
   * @param path_format A complete path to a node (starting with "/").
   * @param Varargs Arguments to use with @a path_format to make a complete path.
   * @return <tt>true</tt> if no error occurred.
   */

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void set_value_at(const Glib::ustring& path_format, const Glib::ustring& value);
#else
  void set_value_at(const Glib::ustring& path_format, const Glib::ustring& value, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  
  /** Convenience function to get the type of a node.
   * @param path A complete path to a node (starting with "/").
   * @param status A place to store the status of the node, or <tt>0</tt>.
   * @return The type of node, or GDA_SERVER_OPERATION_NODE_UNKNOWN if the node was not found.
   */
  ServerOperationNodeType get_node_type(const Glib::ustring& path, ServerOperationNodeStatus& status) const;
  
  /** 
   * @param path A complete path to a sequence node (starting with "/").
   * @return The number of items in the sequence at @a path, or 0 if @a path is not a sequence node.
   */
  guint get_sequence_size(const Glib::ustring& path);;
  
  /** 
   * @param path A complete path to a sequence node (starting with "/").
   * @return The maximum number of items in the sequence at @a path, or 0 if @a path is not a sequence node.
   */
  guint get_sequence_max_size(const Glib::ustring& path);;
  
  /** 
   * @param path A complete path to a sequence node (starting with "/").
   * @return The minimum number of items in the sequence at @a path, or 0 if @a path is not a sequence node.
   */
  guint get_sequence_min_size(const Glib::ustring& path);;
  
  /** Fetch the contents of a sequence. @a path can describe either a sequence (for example "/SEQNAME") or an item in a sequence
   * (for example "/SEQNAME/3")
   * @param path A complete path to a sequence node (starting with "/").
   * @return A array of strings containing the complete paths of the nodes contained at @a path (free with Glib::strfreev()).
   */
  Glib::StringArrayHandle get_sequence_item_names(const Glib::ustring& path);;
  
  /** 
   * @param path A complete path to a sequence node (starting with "/").
   * @return The name of the sequence at @a path.
   */
  Glib::ustring get_sequence_name(const std::string& path);;

  //TODO: get_node_info => varargs
  
  /** Tells if all the required values in @a op have been defined.
   * 
   * if @a xml_file is not <tt>0</tt>, the validity of @a op is tested against that specification, 
   * and not againts the current @a op's specification.
   * @param xml_file An XML specification file (see new()).
   * @return <tt>true</tt> if @a op is valid.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool is_valid(const std::string& xml_file);
#else
  bool is_valid(const std::string& xml_file, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Loads the contents of @a node into @a op. The XML tree passed through the @a node
   * argument must correspond to an XML tree saved using save_data_to_xml().
   * @param node A #xmlNodePtr.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool load_data_from_xml (xmlNodePtr node);
#else
  bool load_data_from_xml(xmlNodePtr node, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Creates a new #xmlNodePtr tree which can be used to save the #op object. This
   * XML structure can then be saved to disk if necessary. Use xmlFreeNode to free
   * the associated memory when not needed anymore.
   * @return A new #xmlNodePtr structure, or <tt>0</tt>.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  xmlNodePtr save_data_to_xml();
#else
  xmlNodePtr save_data_to_xml(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  
  
  /** Get the last part of @a path
   * @param path A complete path to a node (starting with "/").
   * @return A new string, or <tt>0</tt> if an error occurred.
   */
  Glib::ustring get_node_path_portion(const Glib::ustring& path);
  
  /** Get the complete path to the parent of the node defined by @a path
   * @param path A complete path to a node (starting with "/").
   * @return A new string or <tt>0</tt> if the node does not have any parent or does not exist.
   */
  Glib::ustring get_node_parent(const Glib::ustring& path);
  
  /** Get the type of operation @a op is for
   */
  ServerOperationType get_op_type();
  
  
  bool del_item_from_sequence(const std::string& item_path);
  
  guint add_item_to_sequence(const std::string& item_path);
  
  /** Get an array of strings containing the paths of nodes situated at the root of @a op.
   * @return A new array, which must be freed with Glib::strfreev().
   */
  Glib::StringArrayHandle get_root_nodes();;

  
  /**
   * @par Prototype:
   * <tt>void on_my_%signal_sequence_item_added(Glib::ustring arg1, int arg2)</tt>
   */

  Glib::SignalProxy2< void,Glib::ustring,int > signal_signal_sequence_item_added();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%signal_sequence_item_remove(Glib::ustring arg1, int arg2)</tt>
   */

  Glib::SignalProxy2< void,Glib::ustring,int > signal_signal_sequence_item_remove();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Connection> > property_connection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gint> property_op_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 //TODO: vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::ServerOperation
   */
  Glib::RefPtr<Gnome::Gda::ServerOperation> wrap(GdaServerOperation* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_SERVEROPERATION_H */

