
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libgdamm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "connection.h"
#include "connectionevent.h"
#include "datahandler.h"
#include "datamodel.h"
#include "datamodelarray.h"
#include "datamodelimport.h"
#include "datamodeliter.h"
#include "dataproxy.h"
#include "handlerstring.h"
#include "handlerboolean.h"
#include "handlertime.h"
#include "handlernumerical.h"
#include "handlerbin.h"
#include "handlertype.h"
#include "serverprovider.h"
#include "serveroperation.h"
#include "transactionstatus.h"
#include "set.h"
#include "row.h"
#include "column.h"
#include "holder.h"
#include "statement.h"
#include "sqlparser.h"
#include "batch.h"
#include "metastore.h"
#include "metastruct.h"
#include "config.h"
#include "blobop.h"
#include "blob.h"
#include "quarklist.h"
#include "datacomparator.h"
#include "dataaccesswrapper.h"
#include "dataselect.h"
#include "xatransaction.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gda_batch_get_type(void);
GType gda_blob_op_get_type(void);
GType gda_column_get_type(void);
GType gda_config_get_type(void);
GType gda_connection_get_type(void);
GType gda_connection_event_get_type(void);
GType gda_data_access_wrapper_get_type(void);
GType gda_data_comparator_get_type(void);
GType gda_data_model_array_get_type(void);
GType gda_data_model_import_get_type(void);
GType gda_data_model_iter_get_type(void);
GType gda_data_proxy_get_type(void);
GType gda_data_select_get_type(void);
GType gda_handler_bin_get_type(void);
GType gda_handler_boolean_get_type(void);
GType gda_handler_numerical_get_type(void);
GType gda_handler_string_get_type(void);
GType gda_handler_time_get_type(void);
GType gda_handler_type_get_type(void);
GType gda_holder_get_type(void);
GType gda_meta_store_get_type(void);
GType gda_meta_struct_get_type(void);
GType gda_row_get_type(void);
GType gda_server_operation_get_type(void);
GType gda_server_provider_get_type(void);
GType gda_set_get_type(void);
GType gda_sql_parser_get_type(void);
GType gda_statement_get_type(void);
GType gda_transaction_status_get_type(void);
GType gda_xa_transaction_get_type(void);

//Declarations of the *_error_quark() functions:

GQuark gda_connection_error_quark(void);
GQuark gda_data_model_iter_error_quark(void);
GQuark gda_holder_error_quark(void);
GQuark gda_server_provider_error_quark(void);
GQuark gda_sql_parser_error_quark(void);
GQuark gda_statement_error_quark(void);
} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gnome { namespace Gda {  class Batch_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class BlobOp_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Column_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Config_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Connection_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class ConnectionEvent_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataAccessWrapper_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataComparator_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelArray_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelImport_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataModelIter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataProxy_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class DataSelect_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerBin_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerBoolean_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerNumerical_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerString_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerTime_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class HandlerType_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Holder_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class MetaStore_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class MetaStruct_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Row_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class ServerOperation_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class ServerProvider_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Set_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class SqlParser_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class Statement_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class TransactionStatus_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Gda {  class XaTransaction_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }

namespace Gnome { namespace Gda { 

void wrap_init()
{
  // Register Error domains:
  Glib::Error::register_domain(gda_connection_error_quark(), &Gnome::Gda::ConnectionError::throw_func);
  Glib::Error::register_domain(gda_data_model_iter_error_quark(), &Gnome::Gda::DataModelIterError::throw_func);
  Glib::Error::register_domain(gda_holder_error_quark(), &Gnome::Gda::HolderError::throw_func);
  Glib::Error::register_domain(gda_server_provider_error_quark(), &Gnome::Gda::ServerProviderError::throw_func);
  Glib::Error::register_domain(gda_sql_parser_error_quark(), &Gnome::Gda::SqlParserError::throw_func);
  Glib::Error::register_domain(gda_statement_error_quark(), &Gnome::Gda::StatementError::throw_func);

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gda_batch_get_type(), &Gnome::Gda::Batch_Class::wrap_new);
  Glib::wrap_register(gda_blob_op_get_type(), &Gnome::Gda::BlobOp_Class::wrap_new);
  Glib::wrap_register(gda_column_get_type(), &Gnome::Gda::Column_Class::wrap_new);
  Glib::wrap_register(gda_config_get_type(), &Gnome::Gda::Config_Class::wrap_new);
  Glib::wrap_register(gda_connection_get_type(), &Gnome::Gda::Connection_Class::wrap_new);
  Glib::wrap_register(gda_connection_event_get_type(), &Gnome::Gda::ConnectionEvent_Class::wrap_new);
  Glib::wrap_register(gda_data_access_wrapper_get_type(), &Gnome::Gda::DataAccessWrapper_Class::wrap_new);
  Glib::wrap_register(gda_data_comparator_get_type(), &Gnome::Gda::DataComparator_Class::wrap_new);
  Glib::wrap_register(gda_data_model_array_get_type(), &Gnome::Gda::DataModelArray_Class::wrap_new);
  Glib::wrap_register(gda_data_model_import_get_type(), &Gnome::Gda::DataModelImport_Class::wrap_new);
  Glib::wrap_register(gda_data_model_iter_get_type(), &Gnome::Gda::DataModelIter_Class::wrap_new);
  Glib::wrap_register(gda_data_proxy_get_type(), &Gnome::Gda::DataProxy_Class::wrap_new);
  Glib::wrap_register(gda_data_select_get_type(), &Gnome::Gda::DataSelect_Class::wrap_new);
  Glib::wrap_register(gda_handler_bin_get_type(), &Gnome::Gda::HandlerBin_Class::wrap_new);
  Glib::wrap_register(gda_handler_boolean_get_type(), &Gnome::Gda::HandlerBoolean_Class::wrap_new);
  Glib::wrap_register(gda_handler_numerical_get_type(), &Gnome::Gda::HandlerNumerical_Class::wrap_new);
  Glib::wrap_register(gda_handler_string_get_type(), &Gnome::Gda::HandlerString_Class::wrap_new);
  Glib::wrap_register(gda_handler_time_get_type(), &Gnome::Gda::HandlerTime_Class::wrap_new);
  Glib::wrap_register(gda_handler_type_get_type(), &Gnome::Gda::HandlerType_Class::wrap_new);
  Glib::wrap_register(gda_holder_get_type(), &Gnome::Gda::Holder_Class::wrap_new);
  Glib::wrap_register(gda_meta_store_get_type(), &Gnome::Gda::MetaStore_Class::wrap_new);
  Glib::wrap_register(gda_meta_struct_get_type(), &Gnome::Gda::MetaStruct_Class::wrap_new);
  Glib::wrap_register(gda_row_get_type(), &Gnome::Gda::Row_Class::wrap_new);
  Glib::wrap_register(gda_server_operation_get_type(), &Gnome::Gda::ServerOperation_Class::wrap_new);
  Glib::wrap_register(gda_server_provider_get_type(), &Gnome::Gda::ServerProvider_Class::wrap_new);
  Glib::wrap_register(gda_set_get_type(), &Gnome::Gda::Set_Class::wrap_new);
  Glib::wrap_register(gda_sql_parser_get_type(), &Gnome::Gda::SqlParser_Class::wrap_new);
  Glib::wrap_register(gda_statement_get_type(), &Gnome::Gda::Statement_Class::wrap_new);
  Glib::wrap_register(gda_transaction_status_get_type(), &Gnome::Gda::TransactionStatus_Class::wrap_new);
  Glib::wrap_register(gda_xa_transaction_get_type(), &Gnome::Gda::XaTransaction_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gnome::Gda::Batch::get_type();
  Gnome::Gda::BlobOp::get_type();
  Gnome::Gda::Column::get_type();
  Gnome::Gda::Config::get_type();
  Gnome::Gda::Connection::get_type();
  Gnome::Gda::ConnectionEvent::get_type();
  Gnome::Gda::DataAccessWrapper::get_type();
  Gnome::Gda::DataComparator::get_type();
  Gnome::Gda::DataModelArray::get_type();
  Gnome::Gda::DataModelImport::get_type();
  Gnome::Gda::DataModelIter::get_type();
  Gnome::Gda::DataProxy::get_type();
  Gnome::Gda::DataSelect::get_type();
  Gnome::Gda::HandlerBin::get_type();
  Gnome::Gda::HandlerBoolean::get_type();
  Gnome::Gda::HandlerNumerical::get_type();
  Gnome::Gda::HandlerString::get_type();
  Gnome::Gda::HandlerTime::get_type();
  Gnome::Gda::HandlerType::get_type();
  Gnome::Gda::Holder::get_type();
  Gnome::Gda::MetaStore::get_type();
  Gnome::Gda::MetaStruct::get_type();
  Gnome::Gda::Row::get_type();
  Gnome::Gda::ServerOperation::get_type();
  Gnome::Gda::ServerProvider::get_type();
  Gnome::Gda::Set::get_type();
  Gnome::Gda::SqlParser::get_type();
  Gnome::Gda::Statement::get_type();
  Gnome::Gda::TransactionStatus::get_type();
  Gnome::Gda::XaTransaction::get_type();

} // wrap_init()

} //Gda
} //Gnome


