// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgdamm/xatransaction.h>
#include <libgdamm/private/xatransaction_p.h>

// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* xatransaction.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgda/gda-xa-transaction.h>

namespace Gnome
{

namespace Gda
{

typedef Glib::SListHandle< Glib::RefPtr<Connection> > ConnectionSList;
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool XaTransaction::commit(ConnectionList& cncs_to_recover)
#else
bool XaTransaction::commit(ConnectionList& cncs_to_recover, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  GSList* cncs = NULL;
  bool retvalue = gda_xa_transaction_commit (gobj(), &cncs, &gerror);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  ConnectionSList cncs_cpp(cncs, Glib::OWNERSHIP_SHALLOW);
  for (ConnectionSList::const_iterator i = cncs_cpp.begin();
       i != cncs_cpp.end(); i++)
  {
    cncs_to_recover.push_back(*i);
  }
  
  return retvalue;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool XaTransaction::commit_recovered(ConnectionList& cncs_to_recover)
#else
bool XaTransaction::commit_recovered(ConnectionList& cncs_to_recover, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  GSList* cncs = NULL;
  bool retvalue = gda_xa_transaction_commit_recovered (gobj(), &cncs, &gerror);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  ConnectionSList cncs_cpp(cncs, Glib::OWNERSHIP_SHALLOW);
  for (ConnectionSList::const_iterator i = cncs_cpp.begin();
       i != cncs_cpp.end(); i++)
  {
    cncs_to_recover.push_back(*i);
  }
  
  return retvalue;
}

}

} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gnome::Gda::XaTransaction> wrap(GdaXaTransaction* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::XaTransaction>( dynamic_cast<Gnome::Gda::XaTransaction*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Class& XaTransaction_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &XaTransaction_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gda_xa_transaction_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void XaTransaction_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* XaTransaction_Class::wrap_new(GObject* object)
{
  return new XaTransaction((GdaXaTransaction*)object);
}


/* The implementation: */

GdaXaTransaction* XaTransaction::gobj_copy()
{
  reference();
  return gobj();
}

XaTransaction::XaTransaction(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

XaTransaction::XaTransaction(GdaXaTransaction* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

XaTransaction::~XaTransaction()
{}


XaTransaction::CppClassType XaTransaction::xatransaction_class_; // initialize static member

GType XaTransaction::get_type()
{
  return xatransaction_class_.init().get_type();
}

GType XaTransaction::get_base_type()
{
  return gda_xa_transaction_get_type();
}


XaTransaction::XaTransaction(guint32 format_id, const Glib::ustring& transaction_id)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(xatransaction_class_.init(), "format_id", format_id, "transaction_id", transaction_id.c_str(), static_cast<char*>(0)))
{
  

}

Glib::RefPtr<XaTransaction> XaTransaction::create(guint32 format_id, const Glib::ustring& transaction_id)
{
  return Glib::RefPtr<XaTransaction>( new XaTransaction(format_id, transaction_id) );
}
#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool XaTransaction::register_connection(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& branch)
#else
bool XaTransaction::register_connection(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& branch, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_xa_transaction_register_connection(gobj(), Glib::unwrap(cnc), branch.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

void XaTransaction::unregister_connection(const Glib::RefPtr<Connection>& cnc)
{
gda_xa_transaction_unregister_connection(gobj(), Glib::unwrap(cnc)); 
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool XaTransaction::begin()
#else
bool XaTransaction::begin(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_xa_transaction_begin(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool XaTransaction::rollback()
#else
bool XaTransaction::rollback(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_xa_transaction_rollback(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> XaTransaction::property_transaction_id() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "transaction-id");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<guint> XaTransaction::property_format_id() const
{
  return Glib::PropertyProxy_ReadOnly<guint>(this, "format-id");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gda

} // namespace Gnome


