// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgdamm/connection.h>
#include <libgdamm/private/connection_p.h>

/* $Id: connection.ccg,v 1.18 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- // 

/* connection.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/serverprovider.h>
#include <libgdamm/metastore.h>
#include <libgda/gda-enum-types.h>
#include <libgda/gda-connection.h>
#include <sql-parser/gda-sql-parser.h> //For gda_sql_identifier_quote().
#include <libgda/libgda.h> //For GDA_GENERAL_ERROR
#include <iostream>

namespace Gnome
{

namespace Gda
{

Connection::~Connection()
{
  //Make sure the connection is closed.
  //An open connection with no associated connection object could never be closed.
  if(gobj())
  {
    if(is_opened())
      close();
  }
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<Connection> Connection::open_from_string(const Glib::ustring& provider_name,
                                                       const Glib::ustring& cnc_string,
                                                       const Glib::ustring& auth_string,
                                                       ConnectionOptions options)
#else
Glib::RefPtr<Connection> Connection::open_from_string(const Glib::ustring& provider_name,
                                                       const Glib::ustring& cnc_string,
                                                       const Glib::ustring& auth_string,
                                                       ConnectionOptions options,
                                                       std::auto_ptr<Glib::Error>& error)
#endif
{
  GError* gerror = 0;
  Glib::RefPtr<Connection> retval = Glib::wrap(gda_connection_open_from_string(provider_name.c_str(),
                                                                                cnc_string.c_str(),
                                                                                auth_string.c_str(),
                                                                                (GdaConnectionOptions)options,
                                                                                &gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retval;
}

void Connection::close()
{
  //gda_connection_close() does an unref, but we don't want that:
  reference();
  gda_connection_close(gobj());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<Glib::Object> Connection::statement_execute(const Glib::RefPtr<Statement>& cmd, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, Glib::RefPtr<Set>& last_inserted_row)
#else
Glib::RefPtr<Glib::Object> Connection::statement_execute(const Glib::RefPtr<Statement>& cmd, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, Glib::RefPtr<Set>& last_inserted_row, std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  GdaSet* lir = 0;
  Glib::RefPtr<Glib::Object> retval = Glib::wrap(
    gda_connection_statement_execute(gobj(), cmd->gobj(), Glib::unwrap(params), (GdaStatementModelUsage)model_usage, &lir, &gerror));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(lir)
    last_inserted_row = Glib::wrap(lir);

  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<Glib::Object> Connection::statement_execute(const Glib::RefPtr<Statement>& stmt, StatementModelUsage model_usage)
#else
Glib::RefPtr<Glib::Object> Connection::statement_execute(const Glib::RefPtr<Statement>& stmt, StatementModelUsage model_usage, std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<Glib::Object> retval = Glib::wrap(
    gda_connection_statement_execute(gobj(), Glib::unwrap(stmt), 0, (GdaStatementModelUsage)model_usage, 0, &gerror));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<Glib::Object> Connection::statement_execute(const Glib::ustring& sql, StatementModelUsage model_usage)
#else
Glib::RefPtr<Glib::Object> Connection::statement_execute(const Glib::ustring& sql, StatementModelUsage model_usage, std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  Glib::RefPtr<Statement> stmt;
  Glib::RefPtr<SqlParser> parser = create_parser();
  if(parser)
  {
#ifdef GLIBMM_EXCEPTIONS_ENABLED
    stmt = parser->parse_string(sql);
#else
    stmt = parser->parse_string(sql, error);
    if(error.get())
      return Glib::RefPtr<Glib::Object>();
#endif
  }
  else
    std::cerr << "Gda::Connection::statement_execute(): Couldn't create parser" << std::endl;

  if(!stmt)
    return Glib::RefPtr<Glib::Object>();

#ifdef GLIBMM_EXCEPTIONS_ENABLED
    return statement_execute(stmt, model_usage);
#else
    return statement_execute(stmt, model_usage, error);
#endif
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int Connection::statement_execute_non_select(const Glib::RefPtr<Statement>& cmd, const Glib::RefPtr<Set>& params, Glib::RefPtr<Set>& last_inserted_row)
#else
int Connection::statement_execute_non_select(const Glib::RefPtr<Statement>& cmd, const Glib::RefPtr<Set>& params, Glib::RefPtr<Set>& last_inserted_row, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  GdaSet* lir = 0;
  const int retval = gda_connection_statement_execute_non_select(gobj(), Glib::unwrap(cmd), Glib::unwrap(params), &lir, &gerror);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(lir)
    last_inserted_row = Glib::wrap(lir);

  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int Connection::statement_execute_non_select(const Glib::RefPtr<Statement>& cmd, const Glib::RefPtr<Set>& params)
#else
int Connection::statement_execute_non_select(const Glib::RefPtr<Statement>& cmd, const Glib::RefPtr<Set>& params, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  const int retval = gda_connection_statement_execute_non_select(gobj(), Glib::unwrap(cmd), Glib::unwrap(params), 0, &gerror);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int Connection::statement_execute_non_select(const Glib::RefPtr<Statement>& cmd)
#else
int Connection::statement_execute_non_select(const Glib::RefPtr<Statement>& cmd, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  int retval = gda_connection_statement_execute_non_select(gobj(), Glib::unwrap(cmd), 0, 0, &gerror);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring Connection::statement_to_sql(const Glib::RefPtr<Statement>& statement, const Glib::RefPtr<Set>& params, StatementSqlFlag flags, std::list< Glib::RefPtr<Holder> >& params_used)
#else
Glib::ustring Connection::statement_to_sql(const Glib::RefPtr<Statement>& statement, const Glib::RefPtr<Set>& params, StatementSqlFlag flags, std::list< Glib::RefPtr<Holder> >& params_used, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  GSList* params_usedc = NULL;
  const Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(gda_connection_statement_to_sql(gobj(), Glib::unwrap(statement), Glib::unwrap(params), ((GdaStatementSqlFlag)(flags)), &params_usedc, &(gerror)));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  Glib::SListHandle< Glib::RefPtr<Holder> > params_usedcpp(params_usedc, Glib::OWNERSHIP_SHALLOW);
  for (Glib::SListHandle< Glib::RefPtr<Holder> >::const_iterator i = params_usedcpp.begin();
       i != params_usedcpp.end(); i++)
  {
    params_used.push_back(*i);
  }
  
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::RefPtr<Statement>& stmt, StatementModelUsage model_usage)
#else
Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::RefPtr<Statement>& stmt, StatementModelUsage model_usage, std::auto_ptr<Glib::Error>& error)
#endif
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_statement_execute_select_full(gobj(), Glib::unwrap(stmt), NULL /* params */, ((GdaStatementModelUsage)(model_usage)), NULL /* col_types */, &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::ustring& sql, StatementModelUsage model_usage)
#else
Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::ustring& sql, StatementModelUsage model_usage, std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  Glib::RefPtr<Statement> stmt;
  Glib::RefPtr<SqlParser> parser = create_parser();
  if(parser)
  {
#ifdef GLIBMM_EXCEPTIONS_ENABLED
    stmt = parser->parse_string(sql);
#else
    stmt = parser->parse_string(sql, error);
    if(error.get())
      return Glib::RefPtr<DataModel>();
#endif
  }

  if(!stmt)
    return Glib::RefPtr<DataModel>();

  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_statement_execute_select_full(gobj(), Glib::unwrap(stmt), NULL /* params */, ((GdaStatementModelUsage)(model_usage)), NULL /* col_types */, &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}


#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::update_meta_store()
#else
bool Connection::update_meta_store(std::auto_ptr<Glib::Error>& error)
#endif
{
  GError* gerror = 0;
  const bool retvalue = gda_connection_update_meta_store(gobj(), 0, &gerror);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  
  return retvalue;  
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::update_meta_store(const Glib::ustring& id)
#else
bool Connection::update_meta_store(const Glib::ustring& id, std::auto_ptr<Glib::Error>& error)
#endif
{
  GError* gerror = 0;
  GdaMetaContext mcontext = {const_cast<gchar*>(id.c_str()), 1, NULL, NULL};
  const bool retvalue = gda_connection_update_meta_store(gobj(), &mcontext, &gerror);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  
  return retvalue;  
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::get_meta_store_data(ConnectionMetaType meta_type)
#else
Glib::RefPtr<DataModel> Connection::get_meta_store_data(ConnectionMetaType meta_type, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_get_meta_store_data_v(gobj(), ((GdaConnectionMetaType)(meta_type)), NULL, &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::update_meta_store_table(const Glib::ustring& table_name, const Glib::ustring& schema_name)
#else
bool Connection::update_meta_store_table(const Glib::ustring& table_name, const Glib::ustring& schema_name, std::auto_ptr<Glib::Error>& error)
#endif
{
  // This function is needed to make sure that 
  // the GdaMetaStore really gets the meta data for the table we specified, even if 
  // the table name contains upper-case characters or spaces. murrayc.
  gchar* table_name_quoted = gda_meta_store_sql_identifier_quote (table_name.c_str(), gobj());
  //std::cout << "Connection::update_meta_store_table(): table_name_quoted=" << table_name_quoted << std::endl;
  
  GValue table_name_value = { 0 };
  g_value_init(&table_name_value, G_TYPE_STRING);
  g_value_set_static_string(&table_name_value, table_name_quoted);

  GValue table_schema_value = { 0 };
  g_value_init(&table_schema_value, G_TYPE_STRING);
  g_value_set_static_string(&table_schema_value, schema_name.c_str());

  gchar* column_names[] = { (gchar*)"table_name" , (gchar*)"table_schema"};
  GValue* column_values[] = { &table_name_value, &table_schema_value };

  GdaMetaContext mcontext = {(gchar*)"_tables", schema_name.empty() ? 1 : 2, column_names, column_values };
  GError* gerror = 0;
  const bool retval = gda_connection_update_meta_store(gobj(), &mcontext, &gerror);
  std::cout << "  retval=" << retval << std::endl;

  g_value_unset(&table_name_value);
  g_value_unset(&table_schema_value);
  
  g_free(table_name_quoted);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::update_meta_store_table_names(const Glib::ustring& schema_name)
#else
bool Connection::update_meta_store_table_names(const Glib::ustring& schema_name, std::auto_ptr<Glib::Error>& error)
#endif
{
  GValue table_schema_value = { 0 };
  g_value_init(&table_schema_value, G_TYPE_STRING);
  g_value_set_static_string(&table_schema_value, schema_name.c_str());

  gchar* column_names[] = { (gchar*)"table_schema"};
  GValue* column_values[] = { &table_schema_value };

  GdaMetaContext mcontext = {(gchar*)"_tables", schema_name.empty() ? 0 : 1, column_names, column_values };
  GError* gerror = 0;
  const bool retval = gda_connection_update_meta_store(gobj(), &mcontext, &gerror);

  g_value_unset(&table_schema_value);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  
  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::update_meta_store_data_types()
#else
bool Connection::update_meta_store_data_types(std::auto_ptr<Glib::Error>& error)
#endif
{
  GdaMetaContext mcontext = {(gchar*)"_builtin_data_types", 0, 0, 0 };
  GError* gerror = 0;
  const bool retval = gda_connection_update_meta_store(gobj(), &mcontext, &gerror);
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  
  return retval;
}

} //namespace Gda

} //namespace Gnome

namespace
{


static void Connection_signal_error_callback(GdaConnection* self, GdaConnectionEvent* p0,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,const Glib::RefPtr<ConnectionEvent>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Connection_signal_error_info =
{
  "error",
  (GCallback) &Connection_signal_error_callback,
  (GCallback) &Connection_signal_error_callback
};


static const Glib::SignalProxyInfo Connection_signal_conn_opened_info =
{
  "conn_opened",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_conn_to_close_info =
{
  "conn_to_close",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_conn_closed_info =
{
  "conn_closed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_dsn_changed_info =
{
  "dsn_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_transaction_status_changed_info =
{
  "transaction_status_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


Gnome::Gda::ConnectionError::ConnectionError(Gnome::Gda::ConnectionError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDA_CONNECTION_ERROR, error_code, error_message)
{}

Gnome::Gda::ConnectionError::ConnectionError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Gda::ConnectionError::Code Gnome::Gda::ConnectionError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Gnome::Gda::ConnectionError::throw_func(GError* gobject)
{
  throw Gnome::Gda::ConnectionError(gobject);
}
#else
//When not using exceptions, we just pass the Exception object around without throwing it:
std::auto_ptr<Glib::Error> Gnome::Gda::ConnectionError::throw_func(GError* gobject)
{
  return std::auto_ptr<Glib::Error>(new Gnome::Gda::ConnectionError(gobject));
}
#endif //GLIBMM_EXCEPTIONS_ENABLED

// static
GType Glib::Value<Gnome::Gda::ConnectionError::Code>::value_type()
{
  return gda_connection_error_get_type();
}

// static
GType Glib::Value<Gnome::Gda::ConnectionSchema>::value_type()
{
  return gda_connection_schema_get_type();
}

// static
GType Glib::Value<Gnome::Gda::ConnectionOptions>::value_type()
{
  return gda_connection_options_get_type();
}

// static
GType Glib::Value<Gnome::Gda::ConnectionMetaType>::value_type()
{
  return gda_connection_meta_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Gda::Connection> wrap(GdaConnection* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::Connection>( dynamic_cast<Gnome::Gda::Connection*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Class& Connection_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Connection_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gda_connection_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Connection_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->error = &error_callback;
  klass->conn_opened = &conn_opened_callback;
  klass->conn_to_close = &conn_to_close_callback;
  klass->conn_closed = &conn_closed_callback;
  klass->dsn_changed = &dsn_changed_callback;
  klass->transaction_status_changed = &transaction_status_changed_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Connection_Class::error_callback(GdaConnection* self, GdaConnectionEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_error(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->error)
    (*base->error)(self, p0);
}
void Connection_Class::conn_opened_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_conn_opened();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->conn_opened)
    (*base->conn_opened)(self);
}
void Connection_Class::conn_to_close_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_conn_to_close();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->conn_to_close)
    (*base->conn_to_close)(self);
}
void Connection_Class::conn_closed_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_conn_closed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->conn_closed)
    (*base->conn_closed)(self);
}
void Connection_Class::dsn_changed_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_dsn_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->dsn_changed)
    (*base->dsn_changed)(self);
}
void Connection_Class::transaction_status_changed_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_transaction_status_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->transaction_status_changed)
    (*base->transaction_status_changed)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Connection_Class::wrap_new(GObject* object)
{
  return new Connection((GdaConnection*)object);
}


/* The implementation: */

GdaConnection* Connection::gobj_copy()
{
  reference();
  return gobj();
}

Connection::Connection(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Connection::Connection(GdaConnection* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Connection::CppClassType Connection::connection_class_; // initialize static member

GType Connection::get_type()
{
  return connection_class_.init().get_type();
}


GType Connection::get_base_type()
{
  return gda_connection_get_type();
}


Connection::Connection()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(connection_class_.init()))
{
  

}

Glib::RefPtr<Connection> Connection::create()
{
  return Glib::RefPtr<Connection>( new Connection() );
}
#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::open()
#else
bool Connection::open(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_open(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

bool Connection::is_opened() const
{
  return gda_connection_is_opened(const_cast<GdaConnection*>(gobj()));
}

ConnectionOptions Connection::get_options() const
{
  return ((ConnectionOptions)(gda_connection_get_options(const_cast<GdaConnection*>(gobj()))));
}

Glib::ustring Connection::get_dsn() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_dsn(const_cast<GdaConnection*>(gobj())));
}

Glib::ustring Connection::get_cnc_string() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_cnc_string(const_cast<GdaConnection*>(gobj())));
}

void Connection::add_event(const Glib::RefPtr<ConnectionEvent>& event)
{
gda_connection_add_event(gobj(), Glib::unwrap(event)); 
}

Glib::RefPtr<ConnectionEvent> Connection::add_event_string(const Glib::ustring& str)
{
  return Glib::wrap(gda_connection_add_event_string(gobj(), str.c_str()));
}

void Connection::clear_events_list()
{
gda_connection_clear_events_list(gobj()); 
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params)
#else
Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_statement_execute_select(gobj(), Glib::unwrap(stmt), Glib::unwrap(params), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, const Glib::ArrayHandle<GType>& col_types)
#else
Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, const Glib::ArrayHandle<GType>& col_types, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_statement_execute_select_full(gobj(), Glib::unwrap(stmt), Glib::unwrap(params), ((GdaStatementModelUsage)(model_usage)), const_cast<GType*>((col_types).data()), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int Connection::statement_execute_non_select(const Glib::ustring& sql)
#else
int Connection::statement_execute_non_select(const Glib::ustring& sql, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  int retvalue = gda_execute_non_select_command(gobj(), sql.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<const TransactionStatus> Connection::get_transaction_status() const
#else
Glib::RefPtr<const TransactionStatus> Connection::get_transaction_status(std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<const TransactionStatus> retvalue = Glib::wrap(gda_connection_get_transaction_status(const_cast<GdaConnection*>(gobj())));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::begin_transaction(const Glib::ustring& name, TransactionIsolation level)
#else
bool Connection::begin_transaction(const Glib::ustring& name, TransactionIsolation level, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_begin_transaction(gobj(), name.c_str(), ((GdaTransactionIsolation)(level)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::commit_transaction(const Glib::ustring& name)
#else
bool Connection::commit_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_commit_transaction(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::rollback_transaction(const Glib::ustring& name)
#else
bool Connection::rollback_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_rollback_transaction(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::add_savepoint(const Glib::ustring& name)
#else
bool Connection::add_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_add_savepoint(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::rollback_savepoint(const Glib::ustring& name)
#else
bool Connection::rollback_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_rollback_savepoint(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::delete_savepoint(const Glib::ustring& name)
#else
bool Connection::delete_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_delete_savepoint(gobj(), name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

Glib::ListHandle< Glib::RefPtr<ConnectionEvent> > Connection::get_events()
{
  return Glib::ListHandle< Glib::RefPtr<ConnectionEvent> >((GList*)gda_connection_get_events(gobj()), Glib::OWNERSHIP_NONE);
}

Glib::ListHandle< Glib::RefPtr<const ConnectionEvent> > Connection::get_events() const
{
  return Glib::ListHandle< Glib::RefPtr<const ConnectionEvent> >((GList*)gda_connection_get_events(const_cast<GdaConnection*>(gobj())), Glib::OWNERSHIP_NONE);
}

Glib::ustring Connection::value_to_sql_string(const Value& from) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_connection_value_to_sql_string(const_cast<GdaConnection*>(gobj()), const_cast<GValue*>((from).gobj())));
}

bool Connection::supports_feature(ConnectionFeature feature) const
{
  return gda_connection_supports_feature(const_cast<GdaConnection*>(gobj()), ((GdaConnectionFeature)(feature)));
}

Glib::ustring Connection::get_authentication() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_authentication(const_cast<GdaConnection*>(gobj())));
}

Glib::RefPtr<SqlParser> Connection::create_parser()
{
  return Glib::wrap(gda_connection_create_parser(gobj()));
}

Glib::ustring Connection::get_provider_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_provider_name(const_cast<GdaConnection*>(gobj())));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::statement_prepare(const Glib::RefPtr<Statement>& stmt)
#else
bool Connection::statement_prepare(const Glib::RefPtr<Statement>& stmt, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_statement_prepare(gobj(), Glib::unwrap(stmt), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<DataModel> Connection::get_meta_store_data(ConnectionMetaType meta_type, const Glib::ListHandle< Glib::RefPtr<Holder> >& filters)
#else
Glib::RefPtr<DataModel> Connection::get_meta_store_data(ConnectionMetaType meta_type, const Glib::ListHandle< Glib::RefPtr<Holder> >& filters, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_get_meta_store_data_v(gobj(), ((GdaConnectionMetaType)(meta_type)), filters.data(), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

Glib::RefPtr<MetaStore> Connection::get_meta_store()
{

  Glib::RefPtr<MetaStore> retvalue = Glib::wrap(gda_connection_get_meta_store(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const MetaStore> Connection::get_meta_store() const
{
  return const_cast<Connection*>(this)->get_meta_store();
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::SListHandle< Glib::RefPtr<Glib::Object> > Connection::batch_execute(const Glib::RefPtr<Batch>& batch, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage)
#else
Glib::SListHandle< Glib::RefPtr<Glib::Object> > Connection::batch_execute(const Glib::RefPtr<Batch>& batch, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::SListHandle< Glib::RefPtr<Glib::Object> > retvalue = Glib::SListHandle< Glib::RefPtr<Glib::Object> >((GSList*)gda_connection_batch_execute(gobj(), const_cast<GdaBatch*>(Glib::unwrap(batch)), Glib::unwrap(params), ((GdaStatementModelUsage)(model_usage)), &(gerror)), Glib::OWNERSHIP_SHALLOW);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<ServerOperation> Connection::create_operation(ServerOperationType type, const Glib::RefPtr<Set>& options)
#else
Glib::RefPtr<ServerOperation> Connection::create_operation(ServerOperationType type, const Glib::RefPtr<Set>& options, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<ServerOperation> retvalue = Glib::wrap(gda_connection_create_operation(gobj(), ((GdaServerOperationType)(type)), Glib::unwrap(options), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Connection::perform_operation(const Glib::RefPtr<ServerOperation>& op)
#else
bool Connection::perform_operation(const Glib::RefPtr<ServerOperation>& op, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_connection_perform_operation(gobj(), Glib::unwrap(op), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

Glib::RefPtr<ServerProvider> Connection::get_provider()
{

  Glib::RefPtr<ServerProvider> retvalue = Glib::wrap(gda_connection_get_provider(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const ServerProvider> Connection::get_provider() const
{

  Glib::RefPtr<const ServerProvider> retvalue = Glib::wrap(gda_connection_get_provider(const_cast<GdaConnection*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}


Glib::SignalProxy1< void,const Glib::RefPtr<ConnectionEvent>& > Connection::signal_error()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<ConnectionEvent>& >(this, &Connection_signal_error_info);
}


Glib::SignalProxy0< void > Connection::signal_conn_opened()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_conn_opened_info);
}


Glib::SignalProxy0< void > Connection::signal_conn_to_close()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_conn_to_close_info);
}


Glib::SignalProxy0< void > Connection::signal_conn_closed()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_conn_closed_info);
}


Glib::SignalProxy0< void > Connection::signal_dsn_changed()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_dsn_changed_info);
}


Glib::SignalProxy0< void > Connection::signal_transaction_status_changed()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_transaction_status_changed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Connection::property_auth_string() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "auth-string");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Connection::property_auth_string() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "auth-string");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Connection::property_cnc_string() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "cnc-string");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Connection::property_cnc_string() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "cnc-string");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Connection::property_dsn() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "dsn");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Connection::property_dsn() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "dsn");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<MetaStore> > Connection::property_meta_store() 
{
  return Glib::PropertyProxy< Glib::RefPtr<MetaStore> >(this, "meta-store");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<MetaStore> > Connection::property_meta_store() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<MetaStore> >(this, "meta-store");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<ConnectionOptions> Connection::property_options() 
{
  return Glib::PropertyProxy<ConnectionOptions>(this, "options");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<ConnectionOptions> Connection::property_options() const
{
  return Glib::PropertyProxy_ReadOnly<ConnectionOptions>(this, "options");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gnome::Gda::Connection::on_error(const Glib::RefPtr<ConnectionEvent>& error)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->error)
    (*base->error)(gobj(),Glib::unwrap(error));
}
void Gnome::Gda::Connection::on_conn_opened()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->conn_opened)
    (*base->conn_opened)(gobj());
}
void Gnome::Gda::Connection::on_conn_to_close()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->conn_to_close)
    (*base->conn_to_close)(gobj());
}
void Gnome::Gda::Connection::on_conn_closed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->conn_closed)
    (*base->conn_closed)(gobj());
}
void Gnome::Gda::Connection::on_dsn_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->dsn_changed)
    (*base->dsn_changed)(gobj());
}
void Gnome::Gda::Connection::on_transaction_status_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->transaction_status_changed)
    (*base->transaction_status_changed)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gda

} // namespace Gnome


