// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DATAMODELARRAY_H
#define _LIBGDAMM_DATAMODELARRAY_H


#include <glibmm.h>

// -*- C++ -*- //

/* datamodelarray.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/datamodel.h>
#include <libgdamm/row.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDataModelArray GdaDataModelArray;
typedef struct _GdaDataModelArrayClass GdaDataModelArrayClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DataModelArray_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** An implementation of DataModel based on an array.
 *
 * The Gda::DataModelArray object is a data model which internally uses a GArray to index all its rows (represented as Gda::Row objects).
 * In this data model, all the data is stored in memory, which can be a memory limitation if the number of rows is huge.
 * This type of data model is easy to use to store some temporary data, and has a random access mode (any value can be accessed at 
 * any time without the need for an iterator). 
 *
 * @ingroup DataModels
 */

class DataModelArray
 : public Glib::Object,
   public DataModel
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataModelArray CppObjectType;
  typedef DataModelArray_Class CppClassType;
  typedef GdaDataModelArray BaseObjectType;
  typedef GdaDataModelArrayClass BaseClassType;

private:  friend class DataModelArray_Class;
  static CppClassType datamodelarray_class_;

private:
  // noncopyable
  DataModelArray(const DataModelArray&);
  DataModelArray& operator=(const DataModelArray&);

protected:
  explicit DataModelArray(const Glib::ConstructParams& construct_params);
  explicit DataModelArray(GdaDataModelArray* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataModelArray();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDataModelArray*       gobj()       { return reinterpret_cast<GdaDataModelArray*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDataModelArray* gobj() const { return reinterpret_cast<GdaDataModelArray*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaDataModelArray* gobj_copy();

private:

  
protected:
  explicit DataModelArray(int cols);

public:
  
  static Glib::RefPtr<DataModelArray> create(int cols);


  //This is an equivalent for gda_data_model_array_new_with_g_types().
  void set_column_g_type(int col, GType type);
  

  /** Sets the number of columns for rows inserted in this model. 
   *  @a cols must be greated than or equal to 0.
   * 
   * Also clears @a model's contents.
   * @param cols Number of columns for rows this data model should use.
   */
  void set_n_columns(int cols);
  
  /** Frees all the rows in @a model.
   */
  void clear();

  
  /** Get a pointer to a row in @a model
   * @return The Gda::Row, or <tt>0</tt> if an error occurred.
   */
  Glib::RefPtr<Row> get_row(int row);
  
  /** Get a pointer to a row in @a model
   * @return The Gda::Row, or <tt>0</tt> if an error occurred.
   */
  Glib::RefPtr<const Row> get_row(int row) const;
    
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of columns in the model.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_n_columns() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of columns in the model.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_n_columns() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::DataModelArray
   */
  Glib::RefPtr<Gnome::Gda::DataModelArray> wrap(GdaDataModelArray* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_DATAMODELARRAY_H */

