// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DATAMODELIMPORT_H
#define _LIBGDAMM_DATAMODELIMPORT_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* datamodelimport.h
 *
 * Copyright 2007 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/datamodel.h>
#include <libgdamm/set.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDataModelImport GdaDataModelImport;
typedef struct _GdaDataModelImportClass GdaDataModelImportClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DataModelImport_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{


/** Importing data from a string or a file.
 *
 * This data model imports data from a string or a file. The data can either be in a CSV (comma separated values) 
 * format or in an XML format as described by the libgda-array.dtd DTD (It is also possible to import 
 * data from an already-build XML tree validated against that DTD).
 * The caller must decide, upon construction, if the new DataModelImport must support random access or simply  
 * cursor based access. Random access makes it easier to use the resulting data model but consumes more memory as all 
 * the data is copied in memory, and this is thus not suitable for large data sets. Note that importing from an 
 * already-built XML tree will always result in a random access data model.
 *
 * Various import options can be specified using parameters in a Set object. The available options depend 
 * on the format of the imported data listed here:
 * - "SEPARATOR" (string, CVS import only): specifies the separator to consider.
 * - "ESCAPE_CHAR" (string, CVS import only): specifies the character used to "escape" the strings contained between two separators.
 * - "ENCODING" (string, CVS import only): specifies the character set used in the imported data.
 * - "TITLE_AS_FIRST_LINE" (boolean, CVS import only): TRUE to specify that the first line of the imported data contains the column names.
 * - "GDA_TYPE_<col number>" (gda type, CVS import only): specifies the requested GDA type for the column numbered "col number".
 * - "DBMS_TYPE_<col number>" (string, CVS import only): specifies the requested DBMS type for the column numbered "col number"; if the DBMS type is listed in the dictionary used by the created model, then the GDA type is set in accordance.
 *
 * @ingroup DataModels
 */

class DataModelImport
 : public Glib::Object,
   public DataModel
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataModelImport CppObjectType;
  typedef DataModelImport_Class CppClassType;
  typedef GdaDataModelImport BaseObjectType;
  typedef GdaDataModelImportClass BaseClassType;

private:  friend class DataModelImport_Class;
  static CppClassType datamodelimport_class_;

private:
  // noncopyable
  DataModelImport(const DataModelImport&);
  DataModelImport& operator=(const DataModelImport&);

protected:
  explicit DataModelImport(const Glib::ConstructParams& construct_params);
  explicit DataModelImport(GdaDataModelImport* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataModelImport();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDataModelImport*       gobj()       { return reinterpret_cast<GdaDataModelImport*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDataModelImport* gobj() const { return reinterpret_cast<GdaDataModelImport*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaDataModelImport* gobj_copy();

private:

  
protected:
  DataModelImport(const std::string& filename, bool random_access, const Glib::RefPtr<const Set>& options);
  

  //Note: data is a null-terminated string, not copied, so the instance must stay alive as long as this model.
  DataModelImport(const gchar* data, bool random_access, const Glib::RefPtr<const Set>& options);
  

  explicit DataModelImport(xmlNodePtr node);
  

public:
  //TODO: Documentation:
  
  static Glib::RefPtr<DataModelImport> create(const std::string& filename, bool random_access, const Glib::RefPtr<const Set>& options);

  
  static Glib::RefPtr<DataModelImport> create(const gchar* data, bool random_access, const Glib::RefPtr<const Set>& options);

  
  static Glib::RefPtr<DataModelImport> create(xmlNodePtr node);


  //TODO: Use ListHandle or similar:
  
  /** Get the list of errors which @a model has to report. The returned list is a list of
   * Error structures, and must not be modified
   * @return The list of errors (which must not be modified), or <tt>0</tt>.
   */
  GSList* get_errors();

  
  /** Clears the history of errors @a model has to report
   */
  void clean_errors();

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_data_string() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<std::string> property_filename() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Set> > property_options() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_random_access() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<xmlNodePtr> property_xml_node() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::DataModelImport
   */
  Glib::RefPtr<Gnome::Gda::DataModelImport> wrap(GdaDataModelImport* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_DATAMODELIMPORT_H */

