// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DATAPROXY_H
#define _LIBGDAMM_DATAPROXY_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* dataproxy.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <glibmm/object.h>
#include <libgdamm/datamodel.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDataProxy GdaDataProxy;
typedef struct _GdaDataProxyClass GdaDataProxyClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DataProxy_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Proxy to hold modifications for any DataModel, providing the DataModel interface itself.
 *  This object stores modifications made to a DataModel object which is proxied until asked to make the changes 
 * inside the DataModel. It also filters the proxied data model to show only a sample (a defined number of continuous 
 * rows) of it.
 *
 * Specifically, for a proxied data model having nb_cols columns and nb_rows rows, the DataProxy object has the following attributes:
 * - 2 * nb_cols columns:
 *  - The first (>= 0) nb_cols columns are the current values stored in the proxy (which correspond to the values of the proxied data model if the considered row has not been changed). The associated values are writable.
 *  - The last nb_cols columns are the values stored in the proxied data model, at column col - nb_cols.
 * - A variable number of rows depending on the following attributes:
 *  - Whether the proxy is configured to have an empty row as the first row.
 *  - Whether the proxy only displays parts of the proxied data model.
 *  - Whether new rows have been added to the proxy.
 *
 * Note that unless explicitely mentioned, the columns are read-only. 
 *
 * @ingroup DataModels
 */

class DataProxy
 : public Glib::Object,
   public DataModel
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataProxy CppObjectType;
  typedef DataProxy_Class CppClassType;
  typedef GdaDataProxy BaseObjectType;
  typedef GdaDataProxyClass BaseClassType;

private:  friend class DataProxy_Class;
  static CppClassType dataproxy_class_;

private:
  // noncopyable
  DataProxy(const DataProxy&);
  DataProxy& operator=(const DataProxy&);

protected:
  explicit DataProxy(const Glib::ConstructParams& construct_params);
  explicit DataProxy(GdaDataProxy* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataProxy();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDataProxy*       gobj()       { return reinterpret_cast<GdaDataProxy*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDataProxy* gobj() const { return reinterpret_cast<GdaDataProxy*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaDataProxy* gobj_copy();

private:

  
protected:
  explicit DataProxy(const Glib::RefPtr<DataModel>& model);

public:
  
  static Glib::RefPtr<DataProxy> create(const Glib::RefPtr<DataModel>& model);


  /** Fetch the Gda::DataModel which @a proxy does proxy
   * @return The proxied data model.
   */
  Glib::RefPtr<DataModel> get_proxied_model();
  
  /** Fetch the Gda::DataModel which @a proxy does proxy
   * @return The proxied data model.
   */
  Glib::RefPtr<const DataModel> get_proxied_model() const;
  
  /** Get the number of columns in the proxied data model
   * @return The number of columns, or -1 if an error occurred.
   */
  int get_proxied_model_n_cols() const;
  
  /** Get the number of rows in the proxied data model
   * @return The number of rows, or -1 if the number of rows is not known.
   */
  int get_proxied_model_n_rows() const;
  
  /** 
   * @return <tt>true</tt> if the proxied data model is itself read-only.
   */
  bool is_read_only() const;

  
  /** Retreive a whole list of values from the @a proxy store. This function calls gda_data_proxy_get_value()
   * for each column index specified in @a cols_index, and generates a Slist on the way.
   * @param proxy_row A proxy row.
   * @return A new list of values (the list must be freed, not the values), or <tt>0</tt> if an error occurred.
   */

  ValueSList get_values(int proxy_row, const Glib::ArrayHandle<int>& cols_index) const;

  
  /** Get the attributes of the value stored at (proxy_row, col) in @a proxy, which
   * is an ORed value of Gda::ValueAttribute flags
   * @param proxy_row A proxy row.
   * @param col A valid proxy column.
   * @return The attribute.
   */
  ValueAttribute get_value_attributes(int proxy_row, int col) const;
  
  /** Alters the attributes of the value stored at (proxy_row, col) in @a proxy. the @a alter_flags
   * can only contain the GDA_VALUE_ATTR_IS_<tt>0</tt>, GDA_VALUE_ATTR_IS_DEFAULT and GDA_VALUE_ATTR_IS_UNCHANGED
   * flags (other flags are ignored).
   * @param proxy_row A proxy row number.
   * @param col A valid column number.
   * @param alter_flags Flags to alter the attributes.
   */
  void alter_value_attributes(int proxy_row, int col, ValueAttribute alter_flags);

  
  /** Get the @a proxy's proxied model row corresponding to @a proxy_row
   * @param proxy_row A proxy row number.
   * @return The proxied model's row, or -1 if @a proxy row which only exists @a proxy.
   */
  int get_proxied_model_row(int proxy_row) const;

  // Renamed delete/undelete to erase/unerase because delete is a C++ keyword
  
  /** Marks the row @a proxy_row to be deleted
   * @param proxy_row A proxy row number.
   */
  void erase(int proxy_row);
  
  /** Remove the "to be deleted" mark at the row @a proxy_row, if it existed.
   * @param proxy_row A proxy row number.
   */
  void unerase(int proxy_row);
  
  /** Tells if the row number @a proxy_row is marked to be deleted.
   * @param proxy_row A proxy row number.
   * @return <tt>true</tt> if the row is marked to be deleted.
   */
  bool row_is_deleted(int proxy_row) const;
  
  /** Tells if the row number @a proxy_row is a row which has been inserted in @a proxy
   * (and is thus not in the proxied data model).
   * @param proxy_row A proxy row number.
   * @return <tt>true</tt> if the row is an inserted row.
   */
  bool row_is_inserted(int proxy_row) const;

  
  /** Resets data at the corresponding row and column. If @a proxy_row corresponds to a new row, then
   * that new row is deleted from @a proxy.
   * @param proxy_row The row to cancel changes.
   * @param col The column to cancel changes, or less than 0 to cancel any change on the @a row row.
   */
  void cancel_row_changes(int proxy_row, int col);
  
  /** Commits the modified data in the proxy back into the Gda::DataModel.
   * @param proxy_row The row number to commit.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void apply_row_changes(int proxy_row);
#else
  void apply_row_changes(int proxy_row, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Tells if @a proxy contains any modifications not applied to the proxied data model.
   * @return <tt>true</tt> if there are some modifications in @a proxy.
   */
  bool has_changed() const;
  
  /** Tells if the row number @a proxy_row has changed
   * @param proxy_row A proxy row number.
   */
  bool row_has_changed(int proxy_row) const;
  
  /** Get the number of rows which have been added to @a proxy and which are not part of
   * the proxied data model.
   * @return The number of new rows.
   */
  int get_n_new_rows() const;
  
  /** Get the number of rows which have been modified in the proxy (the sum of rows existing in
   * the proxied data model which have been modified, and new rows).
   * @return The number of modified rows.
   */
  int get_n_modified_rows() const;
  
  /** Sets the size of each chunk of fata to display: the maximum number of rows which
   * can be displayed at a time. The default value is arbitrary 300 as it is big enough to
   * be able to display quite a lot of data, but small enough to avoid too much data
   * displayed at the same time.
   * 
   * @note the rows which have been added but not yet commited will always be displayed
   * regardless of the current chunk of data, and the modified rows which are not visible
   * when the displayed chunk of data changes are still held as modified rows.
   * 
   * To remove the chunking of the data to display, simply pass @a sample_size the 0 value.
   * @param sample_size The requested size of a chunk, or 0.
   */
  void set_sample_size(int sample_size);
  
  /** Get the size of each chunk of data displayed at a time.
   * @return The chunk (or sample) size, or 0 if chunking is disabled.
   */
  int get_sample_size() const;
  
  /** Sets the number of the first row to be displayed.
   * @param sample_start The number of the first row to be displayed.
   */
  void set_sample_start(int sample_start);
  
  /** Get the row number of the first row to be displayed.
   * @return The number of the first row being displayed.
   */
  int get_sample_start() const;
  
  /** Get the row number of the last row to be displayed.
   * @return The number of the last row being displayed.
   */
  int get_sample_end() const;
  
  /** Apply all the changes stored in the proxy to the proxied data model. The changes are done row
   * after row, and if an error
   * occurs, then it is possible that not all the changes to all the rows have been applied.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool apply_all_changes();
#else
  bool apply_all_changes(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Cancel all the changes stored in the proxy (the @a proxy will be reset to its state
   * as it was just after creation).
   * @return <tt>true</tt> if no error occurred.
   */
  bool cancel_all_changes();
  
  
  /** Get the total number of filtered rows in @a proxy if a filter has been applied. As new rows
   * (rows added to the proxy and not yet added to the proxied data model) and rows to remove
   * (rows marked for removal but not yet removed from the proxied data model) are also filtered,
   * the returned number also contains reefrences to new rows and rows to be removed.
   * @return The number of filtered rows in @a proxy, or -1 if no filter has been applied.
   */
  int get_filtered_n_rows();
  
  /** Get the current filter expression used by @a proxy.
   * @return The current filter expression or <tt>0</tt> if no filter has been set.
   */
  Glib::ustring get_filter_expr();
  
  /** Sets a filter among the rows presented by @a proxy. The filter is defined by a filter expression
   * which can be any SQL valid expression using @a proxy's columns. For instance if @a proxy has the "id" and
   * "name" columns, then a filter can be "length(name) &lt; 5" to filter only the rows where the length of the
   * name is strictly inferior to 5, or "id &gt;= 1000 and id &lt; 2000 order by name limit 50" to filter only the rows where the id
   * is between 1000 and 2000, ordered by name and limited to 50 rows.
   * 
   * Note about column names: real column names can be used (double quoted if necessary), but columns can also be named
   * "_&lt;column number&gt;" with colmun numbers starting at 1.
   * 
   * Note that any previous filter expression is replaced with the new @a filter_expr if no error occurs
   * (if an error occurs, then any previous filter is left unchanged).
   * @param filter_expr An SQL based expression which will filter the contents of @a proxy, or <tt>0</tt> to remove any previous filter.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void get_filter_expr(const Glib::ustring& filter_expr);
#else
  void get_filter_expr(const Glib::ustring& filter_expr, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Orders by the @a col column
   * @param col The column number to order from.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void set_ordering_column(int col);
#else
  void set_ordering_column(int col, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<DataModel> > property_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DataModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_prepend_null_entry() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_prepend_null_entry() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_defer_sync() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_defer_sync() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_sample_size() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_sample_size() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%row_delete_changed(int row, bool to_be_deleted)</tt>
   */

  Glib::SignalProxy2< void,int,bool > signal_row_delete_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%sample_changed(int sample_start, int sample_end)</tt>
   */

  Glib::SignalProxy2< void,int,int > signal_sample_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%sample_size_changed(int sample_size)</tt>
   */

  Glib::SignalProxy1< void,int > signal_sample_size_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%filter_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_filter_changed();

  
  /**
   * @par Prototype:
   * <tt>Error on_my_%validate_row_changes(int row, int proxied_row)</tt>
   */

  Glib::SignalProxy2< Error,int,int > signal_validate_row_changes();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%row_changes_applied(int row, int proxied_row)</tt>
   */

  Glib::SignalProxy2< void,int,int > signal_row_changes_applied();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_row_delete_changed(int row, bool to_be_deleted);
  virtual void on_sample_changed(int sample_start, int sample_end);
  virtual void on_sample_size_changed(int sample_size);
  virtual void on_row_changes_applied(int row, int proxied_row);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::DataProxy
   */
  Glib::RefPtr<Gnome::Gda::DataProxy> wrap(GdaDataProxy* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_DATAPROXY_H */

