// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_SET_H
#define _LIBGDAMM_SET_H


#include <glibmm.h>

// -*- C++ -*- //

/* set.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/holder.h>
#include <libgdamm/value.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaSet GdaSet;
typedef struct _GdaSetClass GdaSetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Set_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{


/** Container for several values.
 *
 * The Gda::Set object is a container for several values (as Gda::Holder objects), 
 * which also offers different classifications of the group of GdaHolder values 
 * (see get_node(), get_source() or get_group()).
 *
 * It is possible to control the values a Gda::Holder can have in the Gda::Set by 
 * connecting to the signal_before_holder_change() signal.
 * 
 * @ingroup DataHandlers
 */

class Set : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Set CppObjectType;
  typedef Set_Class CppClassType;
  typedef GdaSet BaseObjectType;
  typedef GdaSetClass BaseClassType;

private:  friend class Set_Class;
  static CppClassType set_class_;

private:
  // noncopyable
  Set(const Set&);
  Set& operator=(const Set&);

protected:
  explicit Set(const Glib::ConstructParams& construct_params);
  explicit Set(GdaSet* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Set();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaSet*       gobj()       { return reinterpret_cast<GdaSet*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaSet* gobj() const { return reinterpret_cast<GdaSet*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaSet* gobj_copy();

private:

protected:
  typedef std::vector< Glib::RefPtr<Holder> > HolderVector;

   
    explicit Set(const HolderVector& holders);


public:
  
  static Glib::RefPtr<Set> create(const HolderVector& holders =  HolderVector());

  
  /** Creates a new Gda::Set object, copy of @a set
   * @return A new Gda::Set object.
   */
  Glib::RefPtr<Set> copy();

  
  /** Get the value of the Gda::Holder which ID is @a holder_id
   * @param holder_id The ID of the holder to set the value.
   * @return The requested GValue, or <tt>0</tt> (see Gda::Holder::get_value()).
   */
  Value get_holder_value(const Glib::ustring& holder_id) const;

  
  /** Set the value of the Gda::Holder which ID is @a holder_id to a specified value
   * @param holder_id The ID of the holder to set the value.
   * @param Varargs Value, of the correct type, depending on the requested holder's type (not <tt>0</tt>).
   * @return <tt>true</tt> if no error occurred and the value was set correctly.
   */

  template<class T>
  bool set_holder_value(const Glib::ustring& holder_id, T value);
  
  
  /** Finds a Gda::Holder using its ID
   * @param holder_id The ID of the requested value holder.
   * @return The requested Gda::Holder or <tt>0</tt>.
   */
  Glib::RefPtr<Holder> get_holder(const Glib::ustring& holder_id);
  
  /** Finds a Gda::Holder using its ID
   * @param holder_id The ID of the requested value holder.
   * @return The requested Gda::Holder or <tt>0</tt>.
   */
  Glib::RefPtr<const Holder> get_holder(const Glib::ustring& holder_id) const;

  
  /** Adds @a holder to the list of holders managed within @a set.
   * 
   * NOTE: if @a set already has a Gda::Holder with the same ID as @a holder, then @a holder
   * will not be added to the set (even if @a holder's type or value is not the same as the
   * one already in @a set).
   * @param holder A Gda::Holder object.
   * @return <tt>true</tt> if @a holder has been added to @a set (and <tt>false</tt> if it has not been added because there is another Gda::Holder
   * with the same ID).
   */
  void add_holder(const Glib::RefPtr<Holder>& holder);
  
  /** Add a holder
   * 
   * Convenience method to add a holder with value
   * @param id Name of the holder
   * @param value Value of the holder
   */
  void add_holder_as_value(const Glib::ustring& id, const Gda::Value& value);

  /** Add a holder
   * 
   * Convenience method to add a holder with value
   * @param id Name of the holder
   * @param value Value of the holder
   */
  template <class ValueType>
  void add_holder(const Glib::ustring& id, const ValueType& value);
  
  
  /** Removes a Gda::Holder from the list of holders managed by @a set
   * @param holder The Gda::Holder to remove from @a set.
   */
  void remove_holder(const Glib::RefPtr<Holder>& holder);

  
  /** Add to @a set all the holders of @a set_to_merge. 
   * @note only the Gda::Holder of @a set_to_merge for which no holder in @a set has the same ID are merged
   * @note all the Gda::Holder merged in @a set are still used by @a set_to_merge.
   * @param set_to_merge A Gda::Set object.
   */
  void merge_with_set(const Glib::RefPtr<Set>& set_to_merge);
  
  
  /** This method tells if all @a set's Gda::Holder objects are valid, and if
   * they represent a valid combination of values, as defined by rules
   * external to Libgda: the "validate-set" signal is emitted and if none of the signal handlers return an
   * error, then the returned value is <tt>true</tt>, otherwise the return value is <tt>false</tt> as soon as a signal handler
   * returns an error.
   * @return <tt>true</tt> if the set is valid.
   */
  bool is_valid() const;
  
  /* TODO: These don't seem to be very useful */
  //See http://bugzilla.gnome.org/show_bug.cgi?id=574742
  
/*
  _WRAP_METHOD(SetSource* get_source_for_model (const Glib::RefPtr<DataModel>& model), gda_set_get_source_for_model)
  _WRAP_METHOD(SetSource* get_source (const Glib::RefPtr<Holder>& holder), gda_set_get_source)
  _WRAP_METHOD(SetGroup* get_group (const Glib::RefPtr<Holder>& holder), gda_set_get_group)
  _WRAP_METHOD(SetNode* get_node (const Glib::RefPtr<Holder>& holder), gda_set_get_node)
*/		

//The m4 conversion is here because it is only for signals:
 

  /**
   * @par Prototype:
   * <tt>void on_my_%holder_changed(const Glib::RefPtr<Holder>& holder)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Holder>& > signal_holder_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%public_data_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_public_data_changed();

  
  /**
   * @par Prototype:
   * <tt>Glib::Error on_my_%validate_set()</tt>
   */

  Glib::SignalProxy0< Glib::Error > signal_validate_set();

  
  /**
   * @par Prototype:
   * <tt>Glib::Error on_my_%validate_holder_change(const Glib::RefPtr<Holder>& holder, const Value& value)</tt>
   */

  Glib::SignalProxy2< Glib::Error,const Glib::RefPtr<Holder>&,const Value& > signal_validate_holder_change();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%holder_attr_changed(const Glib::RefPtr<Holder>& holder, const Glib::ustring& attr_name, Value value)</tt>
   */

  Glib::SignalProxy3< void,const Glib::RefPtr<Holder>&,const Glib::ustring&,Value > signal_holder_attr_changed();

     
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Description.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_description() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Description.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_description() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Id.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Id.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Name.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Name.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_holder_changed(const Glib::RefPtr<Holder>& holder);
  virtual void on_public_data_changed();


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <class ValueType> inline
void Set::add_holder(const Glib::ustring& id, const ValueType& value)
{
  Gnome::Gda::Value gdavalue(value);
  Glib::RefPtr<Holder> holder = Holder::create(gdavalue.get_value_type(), id);
  holder->set_value(value);
  this->add_holder(holder);
}
#endif //DOXYGEN_SHOULD_SKIP_THIS

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Set
   */
  Glib::RefPtr<Gnome::Gda::Set> wrap(GdaSet* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_SET_H */

