// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgdamm/datamodel.h>
#include <libgdamm/private/datamodel_p.h>

/* $Id: datamodel.ccg,v 1.11 2006/11/08 01:42:01 murrayc Exp $ */
// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* datamodel.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/serverprovider.h>
#include <libgda/gda-data-model.h>
#include <libgda/gda-data-model-extra.h>
#include <libgda/gda-data-model-iter-extra.h>
#include <libgda/gda-data-model-array.h>
#include <libgda/gda-enum-types.h>


namespace Gnome
{

namespace Gda
{


bool DataModel::export_to_file(DataModelIOFormat format, const std::string& file, const std::vector<int>& cols, const std::vector<int>& rows, const Glib::RefPtr<Set>& options)
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_export_to_file(gobj(), static_cast<GdaDataModelIOFormat>(format), file.c_str(), cols.data(), cols.size(), rows.data(), rows.size(), options->gobj(), &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::ustring DataModel::export_to_string(DataModelIOFormat format, const std::vector<int>& cols, const std::vector<int>& rows, const Glib::RefPtr<Set>& options)
{
  gchar* retvalue = gda_data_model_export_to_string(gobj(), static_cast<GdaDataModelIOFormat>(format), cols.data(), cols.size(), rows.data(), rows.size(), options->gobj());
  Glib::ustring cppretvalue(retvalue);
  g_free(retvalue);

  return cppretvalue;
}


} /* namespace Gda */

} /* namespace Gnome */


namespace
{


static void DataModel_signal_row_inserted_callback(GdaDataModel* self, gint p0,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo DataModel_signal_row_inserted_info =
{
  "row_inserted",
  (GCallback) &DataModel_signal_row_inserted_callback,
  (GCallback) &DataModel_signal_row_inserted_callback
};


static void DataModel_signal_row_updated_callback(GdaDataModel* self, gint p0,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo DataModel_signal_row_updated_info =
{
  "row_updated",
  (GCallback) &DataModel_signal_row_updated_callback,
  (GCallback) &DataModel_signal_row_updated_callback
};


static void DataModel_signal_row_removed_callback(GdaDataModel* self, gint p0,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo DataModel_signal_row_removed_info =
{
  "row_removed",
  (GCallback) &DataModel_signal_row_removed_callback,
  (GCallback) &DataModel_signal_row_removed_callback
};


static const Glib::SignalProxyInfo DataModel_signal_reset_info =
{
  "reset",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo DataModel_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


Gnome::Gda::DataModelError::DataModelError(Gnome::Gda::DataModelError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDA_DATA_MODEL_ERROR, error_code, error_message)
{}

Gnome::Gda::DataModelError::DataModelError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Gda::DataModelError::Code Gnome::Gda::DataModelError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

void Gnome::Gda::DataModelError::throw_func(GError* gobject)
{
  throw Gnome::Gda::DataModelError(gobject);
}

// static
GType Glib::Value<Gnome::Gda::DataModelError::Code>::value_type()
{
  return gda_data_model_error_get_type();
}

// static
GType Glib::Value<Gnome::Gda::DataModelAccessFlags>::value_type()
{
  return gda_data_model_access_flags_get_type();
}

// static
GType Glib::Value<Gnome::Gda::DataModelHint>::value_type()
{
  return gda_data_model_hint_get_type();
}

// static
GType Glib::Value<Gnome::Gda::DataModelIOFormat>::value_type()
{
  return gda_data_model_io_format_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Gda::DataModel> wrap(GdaDataModel* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::DataModel>( dynamic_cast<Gnome::Gda::DataModel*> (Glib::wrap_auto_interface<Gnome::Gda::DataModel> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Interface_Class& DataModel_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &DataModel_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = gda_data_model_get_type();
  }

  return *this;
}

void DataModel_Class::iface_init_function(void* g_iface, void*)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != 0); 


  klass->row_inserted = &row_inserted_callback;
  klass->row_updated = &row_updated_callback;
  klass->row_removed = &row_removed_callback;
  klass->reset = &reset_callback;
  klass->changed = &changed_callback;
}


void DataModel_Class::row_inserted_callback(GdaDataModel* self, gint p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_row_inserted(p0
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_inserted)
    (*base->row_inserted)(self, p0);
}
void DataModel_Class::row_updated_callback(GdaDataModel* self, gint p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_row_updated(p0
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_updated)
    (*base->row_updated)(self, p0);
}
void DataModel_Class::row_removed_callback(GdaDataModel* self, gint p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_row_removed(p0
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_removed)
    (*base->row_removed)(self, p0);
}
void DataModel_Class::reset_callback(GdaDataModel* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_reset();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->reset)
    (*base->reset)(self);
}
void DataModel_Class::changed_callback(GdaDataModel* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->changed)
    (*base->changed)(self);
}


Glib::ObjectBase* DataModel_Class::wrap_new(GObject* object)
{
  return new DataModel((GdaDataModel*)(object));
}


/* The implementation: */

DataModel::DataModel()
:
  Glib::Interface(datamodel_class_.init())
{}

DataModel::DataModel(GdaDataModel* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

DataModel::DataModel(const Glib::Interface_Class& interface_class)
: Glib::Interface(interface_class)
{
}

DataModel::~DataModel()
{}

// static
void DataModel::add_interface(GType gtype_implementer)
{
  datamodel_class_.init().add_interface(gtype_implementer);
}

DataModel::CppClassType DataModel::datamodel_class_; // initialize static member

GType DataModel::get_type()
{
  return datamodel_class_.init().get_type();
}


GType DataModel::get_base_type()
{
  return gda_data_model_get_type();
}


void DataModel::freeze()
{
gda_data_model_freeze(gobj()); 
}

void DataModel::thaw()
{
gda_data_model_thaw(gobj()); 
}

int DataModel::get_n_rows() const
{
  return gda_data_model_get_n_rows(const_cast<GdaDataModel*>(gobj()));
}

int DataModel::get_n_columns() const
{
  return gda_data_model_get_n_columns(const_cast<GdaDataModel*>(gobj()));
}

int DataModel::get_column_index(const Glib::ustring& name)
{
  return gda_data_model_get_column_index(gobj(), name.c_str());
}

Glib::RefPtr<Column> DataModel::describe_column(int col)
{

  Glib::RefPtr<Column> retvalue = Glib::wrap(gda_data_model_describe_column(gobj(), col));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Column> DataModel::describe_column(int col) const
{
  return const_cast<DataModel*>(this)->describe_column(col);
}

Glib::ustring DataModel::get_column_title(int col) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_data_model_get_column_title(const_cast<GdaDataModel*>(gobj()), col));
}

void DataModel::set_column_title(int col, const Glib::ustring& title)
{
gda_data_model_set_column_title(gobj(), col, title.c_str()); 
}

Value DataModel::get_value_at(int col, int row) const
{
  GError* gerror = 0;
  Value retvalue = Value(gda_data_model_get_value_at(const_cast<GdaDataModel*>(gobj()), col, row, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Value DataModel::get_typed_value_at(int col, int row, GType expected_type, bool nullok) const
{
  GError* gerror = 0;
  Value retvalue = Value(gda_data_model_get_typed_value_at(const_cast<GdaDataModel*>(gobj()), col, row, expected_type, static_cast<int>(nullok), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

ValueAttribute DataModel::get_attributes_at(int col, int row)
{
  return ((ValueAttribute)(gda_data_model_get_attributes_at(gobj(), col, row)));
}

Glib::RefPtr<DataModelIter> DataModel::create_iter()
{
  return Glib::wrap(gda_data_model_create_iter(gobj()));
}

bool DataModel::set_value_at(int col, int row, const Value& value)
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_set_value_at(gobj(), col, row, (value).gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool DataModel::set_values(int row, const std::vector<Value>& values)
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_set_values(gobj(), row, Glib::ListHandler<Value, ValueTraits>::vector_to_list(values).data(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

DataModelAccessFlags DataModel::get_access_flags() const
{
  return ((DataModelAccessFlags)(gda_data_model_get_access_flags(const_cast<GdaDataModel*>(gobj()))));
}

int DataModel::append_values(const std::vector<Value>& values)
{
  GError* gerror = 0;
  int retvalue = gda_data_model_append_values(gobj(), Glib::ListHandler<Value, ValueTraits>::vector_to_list(values).data(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool DataModel::append_row()
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_append_row(gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool DataModel::remove_row(int row)
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_remove_row(gobj(), row, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

int DataModel::get_row_from_values(const ValueVector& values, const std::vector<int>& cols_index)
{
  return gda_data_model_get_row_from_values(gobj(), Glib::SListHandler<Value, ValueTraits>::vector_to_slist(values).data(), const_cast<gint*>(Glib::ArrayHandler<int>::vector_to_array(cols_index).data()));
}

void DataModel::send_hint(DataModelHint hint, const Value& hint_value)
{
gda_data_model_send_hint(gobj(), ((GdaDataModelHint)(hint)), (hint_value).gobj()); 
}

bool DataModel::import_from_model(const Glib::RefPtr<DataModel>& from, bool overwrite, GHashTable * cols_trans)
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_import_from_model(gobj(), Glib::unwrap(from), static_cast<int>(overwrite), cols_trans, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool DataModel::import_from_string(const Glib::ustring& string, GHashTable * cols_trans, const Glib::RefPtr<const Set>& options)
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_import_from_string(gobj(), string.c_str(), cols_trans, const_cast<GdaSet*>(Glib::unwrap(options)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool DataModel::import_from_file(const std::string& file, GHashTable * cols_trans, const Glib::RefPtr<const Set>& options)
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_import_from_file(gobj(), file.c_str(), cols_trans, const_cast<GdaSet*>(Glib::unwrap(options)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

void DataModel::dump(FILE* to_stream) const
{
gda_data_model_dump(const_cast<GdaDataModel*>(gobj()), to_stream); 
}

Glib::ustring DataModel::dump_as_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_data_model_dump_as_string(const_cast<GdaDataModel*>(gobj())));
}

void DataModel::set_column_name(int col, const Glib::ustring& name)
{
gda_data_model_set_column_name(gobj(), col, name.c_str()); 
}

Glib::ustring DataModel::get_column_name(int col) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_data_model_get_column_name(const_cast<GdaDataModel*>(gobj()), col));
}

bool DataModel::iter_move_next_default(const Glib::RefPtr<DataModelIter>& iter)
{
  return gda_data_model_iter_move_next_default(gobj(), Glib::unwrap(iter));
}

bool DataModel::iter_move_prev_default(const Glib::RefPtr<DataModelIter>& iter)
{
  return gda_data_model_iter_move_prev_default(gobj(), Glib::unwrap(iter));
}

bool DataModel::iter_move_to_row_default(const Glib::RefPtr<DataModelIter>& iter, int row)
{
  return gda_data_model_iter_move_to_row_default(gobj(), Glib::unwrap(iter), row);
}


Glib::SignalProxy1< void,int > DataModel::signal_row_inserted()
{
  return Glib::SignalProxy1< void,int >(this, &DataModel_signal_row_inserted_info);
}


Glib::SignalProxy1< void,int > DataModel::signal_row_updated()
{
  return Glib::SignalProxy1< void,int >(this, &DataModel_signal_row_updated_info);
}


Glib::SignalProxy1< void,int > DataModel::signal_row_removed()
{
  return Glib::SignalProxy1< void,int >(this, &DataModel_signal_row_removed_info);
}


Glib::SignalProxy0< void > DataModel::signal_reset()
{
  return Glib::SignalProxy0< void >(this, &DataModel_signal_reset_info);
}


Glib::SignalProxy0< void > DataModel::signal_changed()
{
  return Glib::SignalProxy0< void >(this, &DataModel_signal_changed_info);
}


void Gnome::Gda::DataModel::on_row_inserted(int row)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_inserted)
    (*base->row_inserted)(gobj(),row);
}
void Gnome::Gda::DataModel::on_row_updated(int row)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_updated)
    (*base->row_updated)(gobj(),row);
}
void Gnome::Gda::DataModel::on_row_removed(int row)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_removed)
    (*base->row_removed)(gobj(),row);
}
void Gnome::Gda::DataModel::on_reset()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->reset)
    (*base->reset)(gobj());
}
void Gnome::Gda::DataModel::on_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->changed)
    (*base->changed)(gobj());
}


} // namespace Gda

} // namespace Gnome


