/* testarraylist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <tests/testarraylist.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <stdlib.h>
#include <string.h>

static void test_arraylist_int_add (void);
static void test_arraylist_int_iterator (void);
static void test_arraylist_int_remove (void);
static void test_arraylist_string_add (void);
static void test_arraylist_string_iterator (void);
static void test_arraylist_string_remove (void);
static void _test_arraylist_int_add_gcallback (void);
static void _test_arraylist_int_iterator_gcallback (void);
static void _test_arraylist_int_remove_gcallback (void);
static void _test_arraylist_string_add_gcallback (void);
static void _test_arraylist_string_iterator_gcallback (void);
static void _test_arraylist_string_remove_gcallback (void);
static void _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void test_arraylist_int_add (void) {
	GeeArrayList* arraylist;
	arraylist = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	gee_collection_add (GEE_COLLECTION (arraylist), GINT_TO_POINTER (42));
	g_assert (gee_collection_contains (GEE_COLLECTION (arraylist), GINT_TO_POINTER (42)));
	g_assert (gee_collection_get_size (GEE_COLLECTION (arraylist)) == 1);
	(arraylist == NULL ? NULL : (arraylist = (g_object_unref (arraylist), NULL)));
}


static void test_arraylist_int_iterator (void) {
	GeeArrayList* arraylist;
	GeeIterator* it;
	arraylist = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	gee_collection_add (GEE_COLLECTION (arraylist), GINT_TO_POINTER (42));
	it = gee_iterable_iterator (GEE_ITERABLE (arraylist));
	g_assert (gee_iterator_next (it));
	g_assert (GPOINTER_TO_INT (gee_iterator_get (it)) == 42);
	g_assert (!gee_iterator_next (it));
	(arraylist == NULL ? NULL : (arraylist = (g_object_unref (arraylist), NULL)));
	(it == NULL ? NULL : (it = (g_object_unref (it), NULL)));
}


static void test_arraylist_int_remove (void) {
	GeeArrayList* arraylist;
	arraylist = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	gee_collection_add (GEE_COLLECTION (arraylist), GINT_TO_POINTER (42));
	gee_collection_remove (GEE_COLLECTION (arraylist), GINT_TO_POINTER (42));
	g_assert (!gee_collection_contains (GEE_COLLECTION (arraylist), GINT_TO_POINTER (42)));
	g_assert (gee_collection_get_size (GEE_COLLECTION (arraylist)) == 0);
	(arraylist == NULL ? NULL : (arraylist = (g_object_unref (arraylist), NULL)));
}


static void test_arraylist_string_add (void) {
	GeeArrayList* arraylist;
	arraylist = gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_equal);
	gee_collection_add (GEE_COLLECTION (arraylist), "hello");
	g_assert (gee_collection_contains (GEE_COLLECTION (arraylist), "hello"));
	g_assert (gee_collection_get_size (GEE_COLLECTION (arraylist)) == 1);
	(arraylist == NULL ? NULL : (arraylist = (g_object_unref (arraylist), NULL)));
}


static void test_arraylist_string_iterator (void) {
	GeeArrayList* arraylist;
	GeeIterator* it;
	char* _tmp0;
	arraylist = gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_equal);
	gee_collection_add (GEE_COLLECTION (arraylist), "hello");
	it = gee_iterable_iterator (GEE_ITERABLE (arraylist));
	g_assert (gee_iterator_next (it));
	_tmp0 = NULL;
	g_assert (_vala_strcmp0 ((_tmp0 = ((char*) gee_iterator_get (it))), "hello") == 0);
	(_tmp0 = (g_free (_tmp0), NULL));
	g_assert (!gee_iterator_next (it));
	(arraylist == NULL ? NULL : (arraylist = (g_object_unref (arraylist), NULL)));
	(it == NULL ? NULL : (it = (g_object_unref (it), NULL)));
}


static void test_arraylist_string_remove (void) {
	GeeArrayList* arraylist;
	arraylist = gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_equal);
	gee_collection_add (GEE_COLLECTION (arraylist), "hello");
	gee_collection_remove (GEE_COLLECTION (arraylist), "hello");
	g_assert (!gee_collection_contains (GEE_COLLECTION (arraylist), "hello"));
	g_assert (gee_collection_get_size (GEE_COLLECTION (arraylist)) == 0);
	(arraylist == NULL ? NULL : (arraylist = (g_object_unref (arraylist), NULL)));
}


static void _test_arraylist_int_add_gcallback (void) {
	test_arraylist_int_add ();
}


static void _test_arraylist_int_iterator_gcallback (void) {
	test_arraylist_int_iterator ();
}


static void _test_arraylist_int_remove_gcallback (void) {
	test_arraylist_int_remove ();
}


static void _test_arraylist_string_add_gcallback (void) {
	test_arraylist_string_add ();
}


static void _test_arraylist_string_iterator_gcallback (void) {
	test_arraylist_string_iterator ();
}


static void _test_arraylist_string_remove_gcallback (void) {
	test_arraylist_string_remove ();
}


static void _main (char** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/arraylist/int/add", _test_arraylist_int_add_gcallback);
	g_test_add_func ("/arraylist/int/iterator", _test_arraylist_int_iterator_gcallback);
	g_test_add_func ("/arraylist/int/remove", _test_arraylist_int_remove_gcallback);
	g_test_add_func ("/arraylist/string/add", _test_arraylist_string_add_gcallback);
	g_test_add_func ("/arraylist/string/iterator", _test_arraylist_string_iterator_gcallback);
	g_test_add_func ("/arraylist/string/remove", _test_arraylist_string_remove_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_type_init ();
	_main (argv, argc);
	return 0;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




