/* readonlyset.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GEE_READONLYSET_H__
#define __GEE_READONLYSET_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/iterable.h>
#include <gee/collection.h>
#include <gee/set.h>
#include <gee/iterator.h>

G_BEGIN_DECLS


#define GEE_TYPE_READ_ONLY_SET (gee_read_only_set_get_type ())
#define GEE_READ_ONLY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_SET, GeeReadOnlySet))
#define GEE_READ_ONLY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_SET, GeeReadOnlySetClass))
#define GEE_IS_READ_ONLY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_SET))
#define GEE_IS_READ_ONLY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_SET))
#define GEE_READ_ONLY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_SET, GeeReadOnlySetClass))

typedef struct _GeeReadOnlySet GeeReadOnlySet;
typedef struct _GeeReadOnlySetClass GeeReadOnlySetClass;
typedef struct _GeeReadOnlySetPrivate GeeReadOnlySetPrivate;

/**
 * Represents a read-only collection of items without duplicates.
 */
struct _GeeReadOnlySet {
	GObject parent_instance;
	GeeReadOnlySetPrivate * priv;
};

struct _GeeReadOnlySetClass {
	GObjectClass parent_class;
};


GeeReadOnlySet* gee_read_only_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeSet* set);
GeeReadOnlySet* gee_read_only_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeSet* set);
void gee_read_only_set_set_set (GeeReadOnlySet* self, GeeSet* value);
GType gee_read_only_set_get_type (void);


G_END_DECLS

#endif
