/* hashset.c generated by valac 0.20.1.66-2886, the Vala compiler
 * generated from hashset.vala, do not modify */

/* hashset.vala
 *
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1997-2000  GLib Team and others
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;
typedef struct _GeeAbstractSetPrivate GeeAbstractSetPrivate;

#define GEE_TYPE_HASH_SET (gee_hash_set_get_type ())
#define GEE_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_SET, GeeHashSet))
#define GEE_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_SET, GeeHashSetClass))
#define GEE_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_SET))
#define GEE_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_SET))
#define GEE_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_SET, GeeHashSetClass))

typedef struct _GeeHashSet GeeHashSet;
typedef struct _GeeHashSetClass GeeHashSetClass;
typedef struct _GeeHashSetPrivate GeeHashSetPrivate;
typedef struct _GeeHashSetNode GeeHashSetNode;

#define GEE_HASH_SET_TYPE_ITERATOR (gee_hash_set_iterator_get_type ())
#define GEE_HASH_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator))
#define GEE_HASH_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))
#define GEE_HASH_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))

typedef struct _GeeHashSetIterator GeeHashSetIterator;
typedef struct _GeeHashSetIteratorClass GeeHashSetIteratorClass;
#define _gee_hash_set_node_free0(var) ((var == NULL) ? NULL : (var = (gee_hash_set_node_free (var), NULL)))
typedef struct _GeeHashSetIteratorPrivate GeeHashSetIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef guint (*GeeHashDataFunc) (gconstpointer v, void* user_data);
typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeSet* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeSet* self);
	GDestroyNotify (*get_g_destroy_func) (GeeSet* self);
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeAbstractSet {
	GeeAbstractCollection parent_instance;
	GeeAbstractSetPrivate * priv;
};

struct _GeeAbstractSetClass {
	GeeAbstractCollectionClass parent_class;
	void (*reserved0) (GeeAbstractSet* self);
	void (*reserved1) (GeeAbstractSet* self);
	void (*reserved2) (GeeAbstractSet* self);
	void (*reserved3) (GeeAbstractSet* self);
	void (*reserved4) (GeeAbstractSet* self);
	void (*reserved5) (GeeAbstractSet* self);
	void (*reserved6) (GeeAbstractSet* self);
	void (*reserved7) (GeeAbstractSet* self);
	void (*reserved8) (GeeAbstractSet* self);
	void (*reserved9) (GeeAbstractSet* self);
	GeeSet* (*get_read_only_view) (GeeAbstractSet* self);
};

struct _GeeHashSet {
	GeeAbstractSet parent_instance;
	GeeHashSetPrivate * priv;
};

struct _GeeHashSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeHashSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeHashDataFunc _hash_func;
	gpointer _hash_func_target;
	GDestroyNotify _hash_func_target_destroy_notify;
	GeeEqualDataFunc _equal_func;
	gpointer _equal_func_target;
	GDestroyNotify _equal_func_target_destroy_notify;
	gint _array_size;
	gint _nnodes;
	GeeHashSetNode** _nodes;
	gint _nodes_length1;
	gint __nodes_size_;
	gint _stamp;
};

struct _GeeHashSetNode {
	gpointer key;
	GeeHashSetNode* next;
	guint key_hash;
};

struct _GeeHashSetIterator {
	GObject parent_instance;
	GeeHashSetIteratorPrivate * priv;
};

struct _GeeHashSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeHashSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeHashSet* _set;
	gint _index;
	GeeHashSetNode* _node;
	GeeHashSetNode* _next;
	gint _stamp;
};


static gpointer gee_hash_set_parent_class = NULL;
static gpointer gee_hash_set_iterator_parent_class = NULL;
static GeeTraversableIface* gee_hash_set_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface* gee_hash_set_iterator_gee_iterator_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_hash_set_get_type (void) G_GNUC_CONST;
static void gee_hash_set_node_free (GeeHashSetNode* self);
#define GEE_HASH_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_HASH_SET, GeeHashSetPrivate))
enum  {
	GEE_HASH_SET_DUMMY_PROPERTY,
	GEE_HASH_SET_G_TYPE,
	GEE_HASH_SET_G_DUP_FUNC,
	GEE_HASH_SET_G_DESTROY_FUNC,
	GEE_HASH_SET_SIZE,
	GEE_HASH_SET_READ_ONLY
};
void gee_abstract_collection_clear (GeeAbstractCollection* self);
#define GEE_HASH_SET_MIN_SIZE 11
#define GEE_HASH_SET_MAX_SIZE 13845163
GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeAbstractSet* gee_abstract_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeHashDataFunc gee_functions_get_hash_func_for (GType t, void** result_target, GDestroyNotify* result_target_destroy_notify);
GeeEqualDataFunc gee_functions_get_equal_func_for (GType t, void** result_target, GDestroyNotify* result_target_destroy_notify);
static void gee_hash_set_set_hash_func (GeeHashSet* self, GeeHashDataFunc value, gpointer value_target);
static void gee_hash_set_set_equal_func (GeeHashSet* self, GeeEqualDataFunc value, gpointer value_target);
static GeeHashSetNode** gee_hash_set_lookup_node (GeeHashSet* self, gconstpointer key);
GeeHashDataFunc gee_hash_set_get_hash_func (GeeHashSet* self, gpointer* result_target);
GeeEqualDataFunc gee_hash_set_get_equal_func (GeeHashSet* self, gpointer* result_target);
static gboolean gee_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer key);
static GeeIterator* gee_hash_set_real_iterator (GeeAbstractCollection* base);
static GeeHashSetIterator* gee_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set);
static GeeHashSetIterator* gee_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set);
static GType gee_hash_set_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean gee_hash_set_real_add (GeeAbstractCollection* base, gconstpointer key);
static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash);
static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash);
static void gee_hash_set_resize (GeeHashSet* self);
static gboolean gee_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer key);
static inline gboolean gee_hash_set_remove_helper (GeeHashSet* self, gconstpointer key);
static void gee_hash_set_real_clear (GeeAbstractCollection* base);
static void gee_hash_set_node_instance_init (GeeHashSetNode * self);
#define GEE_HASH_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorPrivate))
enum  {
	GEE_HASH_SET_ITERATOR_DUMMY_PROPERTY,
	GEE_HASH_SET_ITERATOR_G_TYPE,
	GEE_HASH_SET_ITERATOR_G_DUP_FUNC,
	GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC,
	GEE_HASH_SET_ITERATOR_READ_ONLY,
	GEE_HASH_SET_ITERATOR_VALID
};
static gboolean gee_hash_set_iterator_real_next (GeeIterator* base);
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_hash_set_iterator_real_has_next (GeeIterator* base);
static gpointer gee_hash_set_iterator_real_get (GeeIterator* base);
static void gee_hash_set_iterator_real_remove (GeeIterator* base);
static gboolean gee_hash_set_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static void gee_hash_set_iterator_finalize (GObject* obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
gboolean gee_iterator_get_valid (GeeIterator* self);
static void _vala_gee_hash_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_hash_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_hash_set_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
static void _vala_gee_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Constructs a new, empty hash set.
 *
 * If not provided, the functions parameters are requested to the
 * {@link Functions} function factory methods.
 *
 * @param hash_func an optional hash function
 * @param equal_func an optional equality testing function
 */
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	GeeHashSet * self = NULL;
	GeeHashDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeEqualDataFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	GeeHashDataFunc _tmp8_ = NULL;
	void* _tmp8__target = NULL;
	GeeEqualDataFunc _tmp9_ = NULL;
	void* _tmp9__target = NULL;
	gint _tmp10_ = 0;
	GeeHashSetNode** _tmp11_ = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_type = g_type;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = hash_func;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0__target = hash_func_target;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp0_ == NULL) {
#line 430 "hashset.c"
		void* _tmp1_ = NULL;
		GDestroyNotify _tmp2_ = NULL;
		GeeHashDataFunc _tmp3_ = NULL;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp3_ = gee_functions_get_hash_func_for (g_type, &_tmp1_, &_tmp2_);
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		hash_func = NULL;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		hash_func_target = NULL;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		hash_func_target_destroy_notify = NULL;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		hash_func = _tmp3_;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		hash_func_target = _tmp1_;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		hash_func_target_destroy_notify = _tmp2_;
#line 450 "hashset.c"
	}
#line 91 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = equal_func;
#line 91 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4__target = equal_func_target;
#line 91 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp4_ == NULL) {
#line 458 "hashset.c"
		void* _tmp5_ = NULL;
		GDestroyNotify _tmp6_ = NULL;
		GeeEqualDataFunc _tmp7_ = NULL;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp7_ = gee_functions_get_equal_func_for (g_type, &_tmp5_, &_tmp6_);
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		equal_func = NULL;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		equal_func_target = NULL;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		equal_func_target_destroy_notify = NULL;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		equal_func = _tmp7_;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		equal_func_target = _tmp5_;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		equal_func_target_destroy_notify = _tmp6_;
#line 478 "hashset.c"
	}
#line 94 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp8_ = hash_func;
#line 94 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp8__target = hash_func_target;
#line 94 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_set_hash_func (self, _tmp8_, _tmp8__target);
#line 95 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp9_ = equal_func;
#line 95 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp9__target = equal_func_target;
#line 95 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_set_equal_func (self, _tmp9_, _tmp9__target);
#line 96 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_array_size = GEE_HASH_SET_MIN_SIZE;
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp10_ = self->priv->_array_size;
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp11_ = g_new0 (GeeHashSetNode*, _tmp10_ + 1);
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nodes = _tmp11_;
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nodes_length1 = _tmp10_;
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->__nodes_size_ = self->priv->_nodes_length1;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	hash_func = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	hash_func_target = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	hash_func_target_destroy_notify = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	equal_func = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	equal_func_target = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	equal_func_target_destroy_notify = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self;
#line 524 "hashset.c"
}


GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return gee_hash_set_construct (GEE_TYPE_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, hash_func_target, hash_func_target_destroy_notify, equal_func, equal_func_target, equal_func_target_destroy_notify);
#line 531 "hashset.c"
}


static GeeHashSetNode** gee_hash_set_lookup_node (GeeHashSet* self, gconstpointer key) {
	GeeHashSetNode** result = NULL;
	guint hash_value = 0U;
	GeeHashDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeHashDataFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	gconstpointer _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GeeHashSetNode** node = NULL;
	GeeHashSetNode** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint _tmp5_ = 0U;
	gint _tmp6_ = 0;
	GeeHashSetNode** _tmp22_ = NULL;
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = gee_hash_set_get_hash_func (self, &_tmp0__target);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = _tmp0_;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1__target = _tmp0__target;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = key;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = _tmp1_ (_tmp2_, _tmp1__target);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	hash_value = _tmp3_;
#line 102 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = self->priv->_nodes;
#line 102 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4__length1 = self->priv->_nodes_length1;
#line 102 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = hash_value;
#line 102 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp6_ = self->priv->_array_size;
#line 102 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	node = &_tmp4_[_tmp5_ % _tmp6_];
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	while (TRUE) {
#line 576 "hashset.c"
		gboolean _tmp7_ = FALSE;
		GeeHashSetNode** _tmp8_ = NULL;
		gboolean _tmp20_ = FALSE;
		GeeHashSetNode** _tmp21_ = NULL;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp8_ = node;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if ((*_tmp8_) != NULL) {
#line 585 "hashset.c"
			gboolean _tmp9_ = FALSE;
			guint _tmp10_ = 0U;
			GeeHashSetNode** _tmp11_ = NULL;
			guint _tmp12_ = 0U;
			gboolean _tmp19_ = FALSE;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp10_ = hash_value;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp11_ = node;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp12_ = (*_tmp11_)->key_hash;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			if (_tmp10_ != _tmp12_) {
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp9_ = TRUE;
#line 601 "hashset.c"
			} else {
				GeeEqualDataFunc _tmp13_ = NULL;
				void* _tmp13__target = NULL;
				GeeEqualDataFunc _tmp14_ = NULL;
				void* _tmp14__target = NULL;
				GeeHashSetNode** _tmp15_ = NULL;
				gconstpointer _tmp16_ = NULL;
				gconstpointer _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp13_ = gee_hash_set_get_equal_func (self, &_tmp13__target);
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp14_ = _tmp13_;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp14__target = _tmp13__target;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp15_ = node;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp16_ = (*_tmp15_)->key;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp17_ = key;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp18_ = _tmp14_ (_tmp16_, _tmp17_, _tmp14__target);
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp9_ = !_tmp18_;
#line 627 "hashset.c"
			}
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp19_ = _tmp9_;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp7_ = _tmp19_;
#line 633 "hashset.c"
		} else {
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp7_ = FALSE;
#line 637 "hashset.c"
		}
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp20_ = _tmp7_;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if (!_tmp20_) {
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			break;
#line 645 "hashset.c"
		}
#line 104 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp21_ = node;
#line 104 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		node = &(*_tmp21_)->next;
#line 651 "hashset.c"
	}
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp22_ = node;
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp22_;
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 659 "hashset.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	GeeHashSetNode** node = NULL;
	gconstpointer _tmp0_ = NULL;
	GeeHashSetNode** _tmp1_ = NULL;
#line 112 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = key;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = gee_hash_set_lookup_node (self, _tmp0_);
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	node = _tmp1_;
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = (*node) != NULL;
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 684 "hashset.c"
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_hash_set_real_iterator (GeeAbstractCollection* base) {
	GeeHashSet * self;
	GeeIterator* result = NULL;
	GeeHashSetIterator* _tmp0_ = NULL;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = gee_hash_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = (GeeIterator*) _tmp0_;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 703 "hashset.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_add (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	GeeHashSetNode** node = NULL;
	gconstpointer _tmp0_ = NULL;
	GeeHashSetNode** _tmp1_ = NULL;
	GeeHashSetNode** _tmp2_ = NULL;
#line 127 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = key;
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = gee_hash_set_lookup_node (self, _tmp0_);
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	node = _tmp1_;
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = node;
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if ((*_tmp2_) != NULL) {
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		result = FALSE;
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		return result;
#line 733 "hashset.c"
	} else {
		guint hash_value = 0U;
		GeeHashDataFunc _tmp3_ = NULL;
		void* _tmp3__target = NULL;
		GeeHashDataFunc _tmp4_ = NULL;
		void* _tmp4__target = NULL;
		gconstpointer _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		GeeHashSetNode** _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gpointer _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		GeeHashSetNode* _tmp11_ = NULL;
		GeeHashSetNode* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp3_ = gee_hash_set_get_hash_func (self, &_tmp3__target);
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp4_ = _tmp3_;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp4__target = _tmp3__target;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp5_ = key;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp6_ = _tmp4_ (_tmp5_, _tmp4__target);
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		hash_value = _tmp6_;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp7_ = node;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp8_ = key;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp9_ = ((_tmp8_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp8_) : ((gpointer) _tmp8_);
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp10_ = hash_value;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp11_ = gee_hash_set_node_new (_tmp9_, _tmp10_);
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		*_tmp7_ = _tmp11_;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp12_ = *_tmp7_;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp13_ = self->priv->_nnodes;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nnodes = _tmp13_ + 1;
#line 135 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		gee_hash_set_resize (self);
#line 136 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp14_ = self->priv->_stamp;
#line 136 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_stamp = _tmp14_ + 1;
#line 137 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		result = TRUE;
#line 137 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		return result;
#line 790 "hashset.c"
	}
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	gboolean b = FALSE;
	gconstpointer _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = key;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = gee_hash_set_remove_helper (self, _tmp0_);
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	b = _tmp1_;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = b;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp2_) {
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		gee_hash_set_resize (self);
#line 819 "hashset.c"
	}
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = b;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 825 "hashset.c"
}


/**
 * {@inheritDoc}
 */
static void gee_hash_set_real_clear (GeeAbstractCollection* base) {
	GeeHashSet * self;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 836 "hashset.c"
	{
		gint i = 0;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		i = 0;
#line 841 "hashset.c"
		{
			gboolean _tmp0_ = FALSE;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp0_ = TRUE;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			while (TRUE) {
#line 848 "hashset.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				GeeHashSetNode* node = NULL;
				GeeHashSetNode** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				GeeHashSetNode* _tmp7_ = NULL;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp1_ = _tmp0_;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				if (!_tmp1_) {
#line 861 "hashset.c"
					gint _tmp2_ = 0;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp2_ = i;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					i = _tmp2_ + 1;
#line 867 "hashset.c"
				}
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp0_ = FALSE;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp3_ = i;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp4_ = self->priv->_array_size;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					break;
#line 879 "hashset.c"
				}
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp5_ = self->priv->_nodes;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp5__length1 = self->priv->_nodes_length1;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp6_ = i;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp5_[_tmp6_] = NULL;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				node = _tmp7_;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				while (TRUE) {
#line 895 "hashset.c"
					GeeHashSetNode* _tmp8_ = NULL;
					GeeHashSetNode* next = NULL;
					GeeHashSetNode* _tmp9_ = NULL;
					GeeHashSetNode* _tmp10_ = NULL;
					GeeHashSetNode* _tmp11_ = NULL;
					GeeHashSetNode* _tmp12_ = NULL;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp8_ = node;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					if (!(_tmp8_ != NULL)) {
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						break;
#line 908 "hashset.c"
					}
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp9_ = node;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp10_ = _tmp9_->next;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp9_->next = NULL;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					next = _tmp10_;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp11_ = node;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					((_tmp11_->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp11_->key = (self->priv->g_destroy_func (_tmp11_->key), NULL));
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp11_->key = NULL;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp12_ = next;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					next = NULL;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_gee_hash_set_node_free0 (node);
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					node = _tmp12_;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_gee_hash_set_node_free0 (next);
#line 934 "hashset.c"
				}
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_gee_hash_set_node_free0 (node);
#line 938 "hashset.c"
			}
		}
	}
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nnodes = 0;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_resize (self);
#line 946 "hashset.c"
}


static inline gboolean gee_hash_set_remove_helper (GeeHashSet* self, gconstpointer key) {
	gboolean result = FALSE;
	GeeHashSetNode** node = NULL;
	gconstpointer _tmp0_ = NULL;
	GeeHashSetNode** _tmp1_ = NULL;
	GeeHashSetNode** _tmp2_ = NULL;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = key;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = gee_hash_set_lookup_node (self, _tmp0_);
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	node = _tmp1_;
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = node;
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if ((*_tmp2_) != NULL) {
#line 968 "hashset.c"
		GeeHashSetNode** _tmp3_ = NULL;
		GeeHashSetNode* next = NULL;
		GeeHashSetNode** _tmp4_ = NULL;
		GeeHashSetNode* _tmp5_ = NULL;
		GeeHashSetNode** _tmp6_ = NULL;
		GeeHashSetNode** _tmp7_ = NULL;
		GeeHashSetNode** _tmp8_ = NULL;
		GeeHashSetNode* _tmp9_ = NULL;
		GeeHashSetNode* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp3_ = node;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_vala_assert ((*_tmp3_) != NULL, "*node != null");
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp4_ = node;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp5_ = (*_tmp4_)->next;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		(*_tmp4_)->next = NULL;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		next = _tmp5_;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp6_ = node;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		(((*_tmp6_)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp6_)->key = (self->priv->g_destroy_func ((*_tmp6_)->key), NULL));
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		(*_tmp6_)->key = NULL;
#line 175 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp7_ = node;
#line 175 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		gee_hash_set_node_free (*_tmp7_);
#line 177 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp8_ = node;
#line 177 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp9_ = next;
#line 177 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		next = NULL;
#line 177 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		*_tmp8_ = _tmp9_;
#line 177 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp10_ = *_tmp8_;
#line 179 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp11_ = self->priv->_nnodes;
#line 179 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nnodes = _tmp11_ - 1;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp12_ = self->priv->_stamp;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_stamp = _tmp12_ + 1;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		result = TRUE;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_gee_hash_set_node_free0 (next);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		return result;
#line 1026 "hashset.c"
	}
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = FALSE;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1032 "hashset.c"
}


static void gee_hash_set_resize (GeeHashSet* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp11_ = FALSE;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = self->priv->_array_size;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_nnodes;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp2_ >= (3 * _tmp3_)) {
#line 1051 "hashset.c"
		gint _tmp4_ = 0;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp4_ = self->priv->_array_size;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp1_ = _tmp4_ >= GEE_HASH_SET_MIN_SIZE;
#line 1057 "hashset.c"
	} else {
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp1_ = FALSE;
#line 1061 "hashset.c"
	}
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = _tmp1_;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp5_) {
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp0_ = TRUE;
#line 1069 "hashset.c"
	} else {
		gboolean _tmp6_ = FALSE;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp10_ = FALSE;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp7_ = self->priv->_array_size;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp8_ = self->priv->_nnodes;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if ((3 * _tmp7_) <= _tmp8_) {
#line 1081 "hashset.c"
			gint _tmp9_ = 0;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp9_ = self->priv->_array_size;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp6_ = _tmp9_ < GEE_HASH_SET_MAX_SIZE;
#line 1087 "hashset.c"
		} else {
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp6_ = FALSE;
#line 1091 "hashset.c"
		}
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp10_ = _tmp6_;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp0_ = _tmp10_;
#line 1097 "hashset.c"
	}
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp11_ = _tmp0_;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp11_) {
#line 1103 "hashset.c"
		gint new_array_size = 0;
		gint _tmp12_ = 0;
		guint _tmp13_ = 0U;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		GeeHashSetNode** new_nodes = NULL;
		gint _tmp16_ = 0;
		GeeHashSetNode** _tmp17_ = NULL;
		gint new_nodes_length1 = 0;
		gint _new_nodes_size_ = 0;
		GeeHashSetNode** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gint _tmp44_ = 0;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp12_ = self->priv->_nnodes;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp13_ = g_spaced_primes_closest ((guint) _tmp12_);
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_array_size = (gint) _tmp13_;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp14_ = new_array_size;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp15_ = CLAMP (_tmp14_, GEE_HASH_SET_MIN_SIZE, GEE_HASH_SET_MAX_SIZE);
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_array_size = _tmp15_;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp16_ = new_array_size;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp17_ = g_new0 (GeeHashSetNode*, _tmp16_ + 1);
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_nodes = _tmp17_;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_nodes_length1 = _tmp16_;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_new_nodes_size_ = new_nodes_length1;
#line 1139 "hashset.c"
		{
			gint i = 0;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			i = 0;
#line 1144 "hashset.c"
			{
				gboolean _tmp18_ = FALSE;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp18_ = TRUE;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				while (TRUE) {
#line 1151 "hashset.c"
					gboolean _tmp19_ = FALSE;
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					GeeHashSetNode* node = NULL;
					GeeHashSetNode* next = NULL;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp19_ = _tmp18_;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					if (!_tmp19_) {
#line 1161 "hashset.c"
						gint _tmp20_ = 0;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp20_ = i;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						i = _tmp20_ + 1;
#line 1167 "hashset.c"
					}
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp18_ = FALSE;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp21_ = i;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp22_ = self->priv->_array_size;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					if (!(_tmp21_ < _tmp22_)) {
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						break;
#line 1179 "hashset.c"
					}
#line 196 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					next = NULL;
#line 1183 "hashset.c"
					{
						GeeHashSetNode** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						gint _tmp24_ = 0;
						GeeHashSetNode* _tmp25_ = NULL;
						gboolean _tmp26_ = FALSE;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp23_ = self->priv->_nodes;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp23__length1 = self->priv->_nodes_length1;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp24_ = i;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp25_ = _tmp23_[_tmp24_];
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp23_[_tmp24_] = NULL;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_gee_hash_set_node_free0 (node);
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						node = _tmp25_;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp26_ = TRUE;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						while (TRUE) {
#line 1208 "hashset.c"
							gboolean _tmp27_ = FALSE;
							GeeHashSetNode* _tmp29_ = NULL;
							GeeHashSetNode* _tmp30_ = NULL;
							GeeHashSetNode* _tmp31_ = NULL;
							guint hash_val = 0U;
							GeeHashSetNode* _tmp32_ = NULL;
							guint _tmp33_ = 0U;
							gint _tmp34_ = 0;
							GeeHashSetNode* _tmp35_ = NULL;
							GeeHashSetNode** _tmp36_ = NULL;
							gint _tmp36__length1 = 0;
							guint _tmp37_ = 0U;
							GeeHashSetNode* _tmp38_ = NULL;
							GeeHashSetNode** _tmp39_ = NULL;
							gint _tmp39__length1 = 0;
							guint _tmp40_ = 0U;
							GeeHashSetNode* _tmp41_ = NULL;
							GeeHashSetNode* _tmp42_ = NULL;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp27_ = _tmp26_;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							if (!_tmp27_) {
#line 1231 "hashset.c"
								GeeHashSetNode* _tmp28_ = NULL;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								_tmp28_ = next;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								next = NULL;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								_gee_hash_set_node_free0 (node);
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								node = _tmp28_;
#line 1241 "hashset.c"
							}
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp26_ = FALSE;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp29_ = node;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							if (!(_tmp29_ != NULL)) {
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								break;
#line 1251 "hashset.c"
							}
#line 198 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp30_ = node;
#line 198 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp31_ = _tmp30_->next;
#line 198 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp30_->next = NULL;
#line 198 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_gee_hash_set_node_free0 (next);
#line 198 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							next = _tmp31_;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp32_ = node;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp33_ = _tmp32_->key_hash;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp34_ = new_array_size;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							hash_val = _tmp33_ % _tmp34_;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp35_ = node;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp36_ = new_nodes;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp36__length1 = new_nodes_length1;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp37_ = hash_val;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp38_ = _tmp36_[_tmp37_];
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp36_[_tmp37_] = NULL;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_gee_hash_set_node_free0 (_tmp35_->next);
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp35_->next = _tmp38_;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp39_ = new_nodes;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp39__length1 = new_nodes_length1;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp40_ = hash_val;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp41_ = node;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							node = NULL;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_gee_hash_set_node_free0 (_tmp39_[_tmp40_]);
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp39_[_tmp40_] = _tmp41_;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp42_ = _tmp39_[_tmp40_];
#line 1303 "hashset.c"
						}
					}
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_gee_hash_set_node_free0 (next);
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_gee_hash_set_node_free0 (node);
#line 1310 "hashset.c"
				}
			}
		}
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp43_ = new_nodes;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp43__length1 = new_nodes_length1;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_nodes = NULL;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nodes = _tmp43_;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nodes_length1 = _tmp43__length1;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->__nodes_size_ = self->priv->_nodes_length1;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp44_ = new_array_size;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_array_size = _tmp44_;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_nodes = (_vala_array_free (new_nodes, new_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
#line 1334 "hashset.c"
	}
}


static gint gee_hash_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeHashSet* self;
	gint _tmp0_ = 0;
#line 46 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 46 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_nnodes;
#line 46 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp0_;
#line 46 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1351 "hashset.c"
}


static gboolean gee_hash_set_real_get_read_only (GeeAbstractCollection* base) {
	gboolean result;
	GeeHashSet* self;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = FALSE;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1364 "hashset.c"
}


GeeHashDataFunc gee_hash_set_get_hash_func (GeeHashSet* self, gpointer* result_target) {
	GeeHashDataFunc result;
	GeeHashDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeHashDataFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_hash_func;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0__target = self->priv->_hash_func_target;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = _tmp0_;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1__target = _tmp0__target;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	*result_target = _tmp1__target;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp1_;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1390 "hashset.c"
}


static void gee_hash_set_set_hash_func (GeeHashSet* self, GeeHashDataFunc value, gpointer value_target) {
	GeeHashDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = value;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0__target = value_target;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	(self->priv->_hash_func_target_destroy_notify == NULL) ? NULL : (self->priv->_hash_func_target_destroy_notify (self->priv->_hash_func_target), NULL);
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func = NULL;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func_target = NULL;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func_target_destroy_notify = NULL;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func = _tmp0_;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func_target = _tmp0__target;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func_target_destroy_notify = NULL;
#line 1417 "hashset.c"
}


GeeEqualDataFunc gee_hash_set_get_equal_func (GeeHashSet* self, gpointer* result_target) {
	GeeEqualDataFunc result;
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeEqualDataFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_equal_func;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0__target = self->priv->_equal_func_target;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = _tmp0_;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1__target = _tmp0__target;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	*result_target = _tmp1__target;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp1_;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1443 "hashset.c"
}


static void gee_hash_set_set_equal_func (GeeHashSet* self, GeeEqualDataFunc value, gpointer value_target) {
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = value;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0__target = value_target;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func = NULL;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func_target = NULL;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func_target_destroy_notify = NULL;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func = _tmp0_;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func_target = _tmp0__target;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func_target_destroy_notify = NULL;
#line 1470 "hashset.c"
}


static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash) {
	GeeHashSetNode* self;
	gpointer _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = g_slice_new0 (GeeHashSetNode);
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_node_instance_init (self);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = k;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	k = NULL;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->key = _tmp0_;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = hash;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->key_hash = _tmp1_;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self;
#line 1494 "hashset.c"
}


static void gee_hash_set_node_instance_init (GeeHashSetNode * self) {
}


static void gee_hash_set_node_free (GeeHashSetNode* self) {
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_gee_hash_set_node_free0 (self->next);
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_slice_free (GeeHashSetNode, self);
#line 1507 "hashset.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self ? g_object_ref (self) : NULL;
#line 1514 "hashset.c"
}


static GeeHashSetIterator* gee_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set) {
	GeeHashSetIterator * self = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) g_object_new (object_type, NULL);
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_type = g_type;
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = set;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_g_object_unref0 (self->priv->_set);
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_set = _tmp1_;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = self->priv->_set;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = _tmp2_->priv->_stamp;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_stamp = _tmp3_;
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self;
#line 1550 "hashset.c"
}


static GeeHashSetIterator* gee_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set) {
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return gee_hash_set_iterator_construct (GEE_HASH_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
#line 1557 "hashset.c"
}


static gboolean gee_hash_set_iterator_real_next (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GeeHashSetNode* _tmp4_ = NULL;
	GeeHashSetNode* _tmp5_ = NULL;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 241 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = gee_iterator_has_next ((GeeIterator*) self);
#line 241 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (!_tmp3_) {
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		result = FALSE;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		return result;
#line 1588 "hashset.c"
	}
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = self->priv->_next;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_node = _tmp4_;
#line 245 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_next = NULL;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = self->priv->_node;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp5_ != NULL;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1602 "hashset.c"
}


static gboolean gee_hash_set_iterator_real_has_next (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeHashSetNode* _tmp3_ = NULL;
	GeeHashSetNode* _tmp19_ = NULL;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_next;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp3_ == NULL) {
#line 1628 "hashset.c"
		GeeHashSetNode* _tmp4_ = NULL;
		GeeHashSetNode* _tmp5_ = NULL;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp4_ = self->priv->_node;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_next = _tmp4_;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp5_ = self->priv->_next;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if (_tmp5_ != NULL) {
#line 1639 "hashset.c"
			GeeHashSetNode* _tmp6_ = NULL;
			GeeHashSetNode* _tmp7_ = NULL;
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp6_ = self->priv->_next;
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp7_ = _tmp6_->next;
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			self->priv->_next = _tmp7_;
#line 1648 "hashset.c"
		}
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		while (TRUE) {
#line 1652 "hashset.c"
			gboolean _tmp8_ = FALSE;
			GeeHashSetNode* _tmp9_ = NULL;
			gboolean _tmp13_ = FALSE;
			gint _tmp14_ = 0;
			GeeHashSet* _tmp15_ = NULL;
			GeeHashSetNode** _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			gint _tmp17_ = 0;
			GeeHashSetNode* _tmp18_ = NULL;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp9_ = self->priv->_next;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			if (_tmp9_ == NULL) {
#line 1666 "hashset.c"
				gint _tmp10_ = 0;
				GeeHashSet* _tmp11_ = NULL;
				gint _tmp12_ = 0;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp10_ = self->priv->_index;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp11_ = self->priv->_set;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp12_ = _tmp11_->priv->_array_size;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp8_ = (_tmp10_ + 1) < _tmp12_;
#line 1678 "hashset.c"
			} else {
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp8_ = FALSE;
#line 1682 "hashset.c"
			}
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp13_ = _tmp8_;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			if (!_tmp13_) {
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				break;
#line 1690 "hashset.c"
			}
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp14_ = self->priv->_index;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			self->priv->_index = _tmp14_ + 1;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp15_ = self->priv->_set;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp16_ = _tmp15_->priv->_nodes;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp16__length1 = _tmp15_->priv->_nodes_length1;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp17_ = self->priv->_index;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp18_ = _tmp16_[_tmp17_];
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			self->priv->_next = _tmp18_;
#line 1708 "hashset.c"
		}
	}
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp19_ = self->priv->_next;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp19_ != NULL;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1717 "hashset.c"
}


static gpointer gee_hash_set_iterator_real_get (GeeIterator* base) {
	GeeHashSetIterator * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeHashSetNode* _tmp3_ = NULL;
	GeeHashSetNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_node;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp3_ != NULL, "_node != null");
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = self->priv->_node;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = _tmp4_->key;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp6_;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1755 "hashset.c"
}


static void gee_hash_set_iterator_real_remove (GeeIterator* base) {
	GeeHashSetIterator * self;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeHashSetNode* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSetNode* _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	GeeHashSet* _tmp7_ = NULL;
	gint _tmp8_ = 0;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 272 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_node;
#line 272 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp3_ != NULL, "_node != null");
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_iterator_has_next ((GeeIterator*) self);
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = self->priv->_set;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = self->priv->_node;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp6_ = _tmp5_->key;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_remove_helper (_tmp4_, _tmp6_);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_node = NULL;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp7_ = self->priv->_set;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp8_ = _tmp7_->priv->_stamp;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_stamp = _tmp8_;
#line 1802 "hashset.c"
}


static gboolean gee_hash_set_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeHashSetNode* node = NULL;
	GeeHashSetNode* _tmp3_ = NULL;
	GeeHashSetNode* next = NULL;
	GeeHashSetNode* _tmp4_ = NULL;
	GeeHashSetNode* current = NULL;
	GeeHashSetNode* prev = NULL;
	GeeHashSetNode* _tmp5_ = NULL;
	GeeHashSetNode* _tmp14_ = NULL;
	GeeHashSetNode* _tmp48_ = NULL;
#line 291 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_node;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	node = _tmp3_;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = self->priv->_next;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	next = _tmp4_;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	current = NULL;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	prev = NULL;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = node;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp5_ != NULL) {
#line 1847 "hashset.c"
		GeeForallFunc _tmp6_ = NULL;
		void* _tmp6__target = NULL;
		GeeHashSetNode* _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gpointer _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		GeeHashSetNode* _tmp11_ = NULL;
		GeeHashSetNode* _tmp12_ = NULL;
		GeeHashSetNode* _tmp13_ = NULL;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp6_ = f;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp6__target = f_target;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp7_ = node;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp8_ = _tmp7_->key;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp9_ = ((_tmp8_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp8_) : ((gpointer) _tmp8_);
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp10_ = _tmp6_ (_tmp9_, _tmp6__target);
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if (!_tmp10_) {
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			result = FALSE;
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			return result;
#line 1875 "hashset.c"
		}
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp11_ = node;
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		prev = _tmp11_;
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp12_ = node;
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp13_ = _tmp12_->next;
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		current = _tmp13_;
#line 1887 "hashset.c"
	}
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp14_ = next;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp14_ != NULL) {
#line 1893 "hashset.c"
		GeeForallFunc _tmp15_ = NULL;
		void* _tmp15__target = NULL;
		GeeHashSetNode* _tmp16_ = NULL;
		gconstpointer _tmp17_ = NULL;
		gpointer _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		GeeHashSetNode* _tmp21_ = NULL;
		GeeHashSetNode* _tmp22_ = NULL;
		GeeHashSetNode* _tmp23_ = NULL;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp15_ = f;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp15__target = f_target;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp16_ = next;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp17_ = _tmp16_->key;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp18_ = ((_tmp17_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp17_) : ((gpointer) _tmp17_);
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp19_ = _tmp15_ (_tmp18_, _tmp15__target);
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if (!_tmp19_) {
#line 1917 "hashset.c"
			GeeHashSetNode* _tmp20_ = NULL;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp20_ = next;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			self->priv->_node = _tmp20_;
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			self->priv->_next = NULL;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			result = FALSE;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			return result;
#line 1929 "hashset.c"
		}
#line 307 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp21_ = next;
#line 307 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		prev = _tmp21_;
#line 308 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp22_ = next;
#line 308 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp23_ = _tmp22_->next;
#line 308 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		current = _tmp23_;
#line 1941 "hashset.c"
	}
	{
		gboolean _tmp24_ = FALSE;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp24_ = TRUE;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		while (TRUE) {
#line 1949 "hashset.c"
			gboolean _tmp25_ = FALSE;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp25_ = _tmp24_;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			if (!_tmp25_) {
#line 1955 "hashset.c"
				GeeHashSetNode* _tmp26_ = NULL;
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp26_ = current;
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				if (!(_tmp26_ != NULL)) {
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					break;
#line 1963 "hashset.c"
				}
			}
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp24_ = FALSE;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			while (TRUE) {
#line 1970 "hashset.c"
				GeeHashSetNode* _tmp27_ = NULL;
				GeeForallFunc _tmp28_ = NULL;
				void* _tmp28__target = NULL;
				GeeHashSetNode* _tmp29_ = NULL;
				gconstpointer _tmp30_ = NULL;
				gpointer _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				GeeHashSetNode* _tmp34_ = NULL;
				GeeHashSetNode* _tmp35_ = NULL;
				GeeHashSetNode* _tmp36_ = NULL;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp27_ = current;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				if (!(_tmp27_ != NULL)) {
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					break;
#line 1987 "hashset.c"
				}
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp28_ = f;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp28__target = f_target;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp29_ = current;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp30_ = _tmp29_->key;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp31_ = ((_tmp30_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp30_) : ((gpointer) _tmp30_);
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp32_ = _tmp28_ (_tmp31_, _tmp28__target);
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				if (!_tmp32_) {
#line 2003 "hashset.c"
					GeeHashSetNode* _tmp33_ = NULL;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp33_ = current;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					self->priv->_node = _tmp33_;
#line 314 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					self->priv->_next = NULL;
#line 315 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					result = FALSE;
#line 315 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					return result;
#line 2015 "hashset.c"
				}
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp34_ = current;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				prev = _tmp34_;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp35_ = current;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp36_ = _tmp35_->next;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				current = _tmp36_;
#line 2027 "hashset.c"
			}
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			while (TRUE) {
#line 2031 "hashset.c"
				gboolean _tmp37_ = FALSE;
				GeeHashSetNode* _tmp38_ = NULL;
				gboolean _tmp42_ = FALSE;
				gint _tmp43_ = 0;
				GeeHashSet* _tmp44_ = NULL;
				GeeHashSetNode** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				gint _tmp46_ = 0;
				GeeHashSetNode* _tmp47_ = NULL;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp38_ = current;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				if (_tmp38_ == NULL) {
#line 2045 "hashset.c"
					gint _tmp39_ = 0;
					GeeHashSet* _tmp40_ = NULL;
					gint _tmp41_ = 0;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp39_ = self->priv->_index;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp40_ = self->priv->_set;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp41_ = _tmp40_->priv->_array_size;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp37_ = (_tmp39_ + 1) < _tmp41_;
#line 2057 "hashset.c"
				} else {
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp37_ = FALSE;
#line 2061 "hashset.c"
				}
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp42_ = _tmp37_;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				if (!_tmp42_) {
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					break;
#line 2069 "hashset.c"
				}
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp43_ = self->priv->_index;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				self->priv->_index = _tmp43_ + 1;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp44_ = self->priv->_set;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp45_ = _tmp44_->priv->_nodes;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp45__length1 = _tmp44_->priv->_nodes_length1;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp46_ = self->priv->_index;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp47_ = _tmp45_[_tmp46_];
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				current = _tmp47_;
#line 2087 "hashset.c"
			}
		}
	}
#line 325 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp48_ = prev;
#line 325 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_node = _tmp48_;
#line 326 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_next = NULL;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = TRUE;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 2101 "hashset.c"
}


static gboolean gee_hash_set_iterator_real_get_read_only (GeeIterator* base) {
	gboolean result;
	GeeHashSetIterator* self;
#line 280 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = FALSE;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 2114 "hashset.c"
}


static gboolean gee_hash_set_iterator_real_get_valid (GeeIterator* base) {
	gboolean result;
	GeeHashSetIterator* self;
	GeeHashSetNode* _tmp0_ = NULL;
#line 286 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_node;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp0_ != NULL;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 2130 "hashset.c"
}


static void gee_hash_set_iterator_class_init (GeeHashSetIteratorClass * klass) {
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_iterator_parent_class = g_type_class_peek_parent (klass);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_type_class_add_private (klass, sizeof (GeeHashSetIteratorPrivate));
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_hash_set_iterator_get_property;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_hash_set_iterator_set_property;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_iterator_finalize;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2155 "hashset.c"
}


static GType gee_hash_set_iterator_gee_traversable_get_g_type (GeeHashSetIterator* self) {
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self->priv->g_type;
#line 2162 "hashset.c"
}


static GBoxedCopyFunc gee_hash_set_iterator_gee_traversable_get_g_dup_func (GeeHashSetIterator* self) {
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self->priv->g_dup_func;
#line 2169 "hashset.c"
}


static GDestroyNotify gee_hash_set_iterator_gee_traversable_get_g_destroy_func (GeeHashSetIterator* self) {
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self->priv->g_destroy_func;
#line 2176 "hashset.c"
}


static void gee_hash_set_iterator_gee_traversable_interface_init (GeeTraversableIface * iface) {
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) gee_hash_set_iterator_real_foreach;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->get_g_type = (GType(*)(GeeTraversable*)) gee_hash_set_iterator_gee_traversable_get_g_type;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) gee_hash_set_iterator_gee_traversable_get_g_dup_func;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) gee_hash_set_iterator_gee_traversable_get_g_destroy_func;
#line 2191 "hashset.c"
}


static void gee_hash_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->next = (gboolean (*)(GeeIterator*)) gee_hash_set_iterator_real_next;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_hash_set_iterator_real_has_next;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->get = (gpointer (*)(GeeIterator*)) gee_hash_set_iterator_real_get;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->remove = (void (*)(GeeIterator*)) gee_hash_set_iterator_real_remove;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->get_read_only = gee_hash_set_iterator_real_get_read_only;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->get_valid = gee_hash_set_iterator_real_get_valid;
#line 2210 "hashset.c"
}


static void gee_hash_set_iterator_instance_init (GeeHashSetIterator * self) {
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv = GEE_HASH_SET_ITERATOR_GET_PRIVATE (self);
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_index = -1;
#line 232 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_stamp = 0;
#line 2221 "hashset.c"
}


static void gee_hash_set_iterator_finalize (GObject* obj) {
	GeeHashSetIterator * self;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_g_object_unref0 (self->priv->_set);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (gee_hash_set_iterator_parent_class)->finalize (obj);
#line 2233 "hashset.c"
}


static GType gee_hash_set_iterator_get_type (void) {
	static volatile gsize gee_hash_set_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hash_set_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSetIterator), 0, (GInstanceInitFunc) gee_hash_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_hash_set_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_hash_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_hash_set_iterator_type_id;
		gee_hash_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeHashSetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_hash_set_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_hash_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&gee_hash_set_iterator_type_id__volatile, gee_hash_set_iterator_type_id);
	}
	return gee_hash_set_iterator_type_id__volatile;
}


static void _vala_gee_hash_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	switch (property_id) {
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_ITERATOR_READ_ONLY:
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_ITERATOR_VALID:
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 2270 "hashset.c"
		default:
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 2276 "hashset.c"
	}
}


static void _vala_gee_hash_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	switch (property_id) {
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_ITERATOR_G_TYPE:
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_ITERATOR_G_DUP_FUNC:
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC:
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 2304 "hashset.c"
		default:
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 2310 "hashset.c"
	}
}


static void gee_hash_set_class_init (GeeHashSetClass * klass) {
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_parent_class = g_type_class_peek_parent (klass);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_type_class_add_private (klass, sizeof (GeeHashSetPrivate));
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_hash_set_real_contains;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_hash_set_real_iterator;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_hash_set_real_add;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_hash_set_real_remove;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_hash_set_real_clear;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_hash_set_real_get_size;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_hash_set_real_get_read_only;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_hash_set_get_property;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_hash_set_set_property;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_finalize;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2346 "hashset.c"
	/**
	 * {@inheritDoc}
	 */
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2352 "hashset.c"
	/**
	 * {@inheritDoc}
	 */
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2358 "hashset.c"
}


static void gee_hash_set_instance_init (GeeHashSet * self) {
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv = GEE_HASH_SET_GET_PRIVATE (self);
#line 73 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_stamp = 0;
#line 2367 "hashset.c"
}


static void gee_hash_set_finalize (GObject* obj) {
	GeeHashSet * self;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_HASH_SET, GeeHashSet);
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	(self->priv->_hash_func_target_destroy_notify == NULL) ? NULL : (self->priv->_hash_func_target_destroy_notify (self->priv->_hash_func_target), NULL);
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func = NULL;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func_target = NULL;
#line 60 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func_target_destroy_notify = NULL;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func = NULL;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func_target = NULL;
#line 66 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func_target_destroy_notify = NULL;
#line 70 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (gee_hash_set_parent_class)->finalize (obj);
#line 2397 "hashset.c"
}


/**
 * Hash table implementation of the {@link Set} interface.
 *
 * This implementation is better fit for highly heterogenous values.
 * In case of high value hashes redundancy or higher amount of data prefer using
 * tree implementation like {@link TreeSet}.
 *
 * @see TreeSet
 */
GType gee_hash_set_get_type (void) {
	static volatile gsize gee_hash_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hash_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSet), 0, (GInstanceInitFunc) gee_hash_set_instance_init, NULL };
		GType gee_hash_set_type_id;
		gee_hash_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeHashSet", &g_define_type_info, 0);
		g_once_init_leave (&gee_hash_set_type_id__volatile, gee_hash_set_type_id);
	}
	return gee_hash_set_type_id__volatile;
}


static void _vala_gee_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_HASH_SET, GeeHashSet);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	switch (property_id) {
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_SIZE:
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_READ_ONLY:
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 2439 "hashset.c"
		default:
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 2445 "hashset.c"
	}
}


static void _vala_gee_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_HASH_SET, GeeHashSet);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	switch (property_id) {
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_G_TYPE:
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_G_DUP_FUNC:
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_G_DESTROY_FUNC:
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 2473 "hashset.c"
		default:
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 2479 "hashset.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



