/* linkedlist.c generated by valac 0.21.1.7-1351, the Vala compiler
 * generated from linkedlist.vala, do not modify */

/* linkedlist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Mark Lee, Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Mark Lee <marklee@src.gnome.org>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_BIDIR_LIST (gee_bidir_list_get_type ())
#define GEE_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_LIST, GeeBidirList))
#define GEE_IS_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_LIST))
#define GEE_BIDIR_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_LIST, GeeBidirListIface))

typedef struct _GeeBidirList GeeBidirList;
typedef struct _GeeBidirListIface GeeBidirListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_BIDIR_LIST_ITERATOR (gee_bidir_list_iterator_get_type ())
#define GEE_BIDIR_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR, GeeBidirListIterator))
#define GEE_IS_BIDIR_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR))
#define GEE_BIDIR_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR, GeeBidirListIteratorIface))

typedef struct _GeeBidirListIterator GeeBidirListIterator;
typedef struct _GeeBidirListIteratorIface GeeBidirListIteratorIface;

#define GEE_TYPE_ABSTRACT_BIDIR_LIST (gee_abstract_bidir_list_get_type ())
#define GEE_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList))
#define GEE_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))
#define GEE_IS_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_IS_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_ABSTRACT_BIDIR_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))

typedef struct _GeeAbstractBidirList GeeAbstractBidirList;
typedef struct _GeeAbstractBidirListClass GeeAbstractBidirListClass;
typedef struct _GeeAbstractBidirListPrivate GeeAbstractBidirListPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_DEQUE (gee_deque_get_type ())
#define GEE_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_DEQUE, GeeDeque))
#define GEE_IS_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_DEQUE))
#define GEE_DEQUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_DEQUE, GeeDequeIface))

typedef struct _GeeDeque GeeDeque;
typedef struct _GeeDequeIface GeeDequeIface;

#define GEE_TYPE_LINKED_LIST (gee_linked_list_get_type ())
#define GEE_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedList))
#define GEE_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))
#define GEE_IS_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LINKED_LIST))
#define GEE_IS_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LINKED_LIST))
#define GEE_LINKED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))

typedef struct _GeeLinkedList GeeLinkedList;
typedef struct _GeeLinkedListClass GeeLinkedListClass;
typedef struct _GeeLinkedListPrivate GeeLinkedListPrivate;
typedef struct _GeeLinkedListNode GeeLinkedListNode;
#define _gee_linked_list_node_free0(var) ((var == NULL) ? NULL : (var = (gee_linked_list_node_free (var), NULL)))

#define GEE_LINKED_LIST_TYPE_ITERATOR (gee_linked_list_iterator_get_type ())
#define GEE_LINKED_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator))
#define GEE_LINKED_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))
#define GEE_LINKED_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))

typedef struct _GeeLinkedListIterator GeeLinkedListIterator;
typedef struct _GeeLinkedListIteratorClass GeeLinkedListIteratorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GeeLinkedListIteratorPrivate GeeLinkedListIteratorPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeList* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeList* self);
	GDestroyNotify (*get_g_destroy_func) (GeeList* self);
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	void (*reserved0) (GeeAbstractList* self);
	void (*reserved1) (GeeAbstractList* self);
	void (*reserved2) (GeeAbstractList* self);
	void (*reserved3) (GeeAbstractList* self);
	void (*reserved4) (GeeAbstractList* self);
	void (*reserved5) (GeeAbstractList* self);
	void (*reserved6) (GeeAbstractList* self);
	void (*reserved7) (GeeAbstractList* self);
	void (*reserved8) (GeeAbstractList* self);
	void (*reserved9) (GeeAbstractList* self);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeBidirIterator* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeBidirIterator* self);
	GDestroyNotify (*get_g_destroy_func) (GeeBidirIterator* self);
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*first) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeBidirListIteratorIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeBidirListIterator* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeBidirListIterator* self);
	GDestroyNotify (*get_g_destroy_func) (GeeBidirListIterator* self);
	void (*insert) (GeeBidirListIterator* self, gconstpointer item);
};

struct _GeeBidirListIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeBidirList* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeBidirList* self);
	GDestroyNotify (*get_g_destroy_func) (GeeBidirList* self);
	GeeBidirListIterator* (*bidir_list_iterator) (GeeBidirList* self);
	GeeBidirList* (*get_read_only_view) (GeeBidirList* self);
};

struct _GeeAbstractBidirList {
	GeeAbstractList parent_instance;
	GeeAbstractBidirListPrivate * priv;
};

struct _GeeAbstractBidirListClass {
	GeeAbstractListClass parent_class;
	GeeBidirListIterator* (*bidir_list_iterator) (GeeAbstractBidirList* self);
	void (*reserved0) (GeeAbstractBidirList* self);
	void (*reserved1) (GeeAbstractBidirList* self);
	void (*reserved2) (GeeAbstractBidirList* self);
	void (*reserved3) (GeeAbstractBidirList* self);
	void (*reserved4) (GeeAbstractBidirList* self);
	void (*reserved5) (GeeAbstractBidirList* self);
	void (*reserved6) (GeeAbstractBidirList* self);
	void (*reserved7) (GeeAbstractBidirList* self);
	void (*reserved8) (GeeAbstractBidirList* self);
	void (*reserved9) (GeeAbstractBidirList* self);
	GeeBidirList* (*get_read_only_view) (GeeAbstractBidirList* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeQueue* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeQueue* self);
	GDestroyNotify (*get_g_destroy_func) (GeeQueue* self);
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeDequeIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeDeque* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeDeque* self);
	GDestroyNotify (*get_g_destroy_func) (GeeDeque* self);
	gboolean (*offer_head) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_head) (GeeDeque* self);
	gpointer (*poll_head) (GeeDeque* self);
	gint (*drain_head) (GeeDeque* self, GeeCollection* recipient, gint amount);
	gboolean (*offer_tail) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_tail) (GeeDeque* self);
	gpointer (*poll_tail) (GeeDeque* self);
	gint (*drain_tail) (GeeDeque* self, GeeCollection* recipient, gint amount);
};

struct _GeeLinkedList {
	GeeAbstractBidirList parent_instance;
	GeeLinkedListPrivate * priv;
};

struct _GeeLinkedListClass {
	GeeAbstractBidirListClass parent_class;
};

typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
struct _GeeLinkedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _size;
	gint _stamp;
	GeeLinkedListNode* _head;
	GeeLinkedListNode* _tail;
	GeeEqualDataFunc _equal_func;
	gpointer _equal_func_target;
	GDestroyNotify _equal_func_target_destroy_notify;
};

struct _GeeLinkedListNode {
	gpointer data;
	GeeLinkedListNode* prev;
	GeeLinkedListNode* next;
};

struct _GeeLinkedListIterator {
	GObject parent_instance;
	GeeLinkedListIteratorPrivate * priv;
};

struct _GeeLinkedListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeLinkedListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gboolean started;
	gboolean removed;
	GeeLinkedListNode* position;
	gint _stamp;
	GeeLinkedList* _list;
	gint _index;
};


static gpointer gee_linked_list_parent_class = NULL;
static gpointer gee_linked_list_iterator_parent_class = NULL;
static GeeTraversableIface* gee_linked_list_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface* gee_linked_list_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_linked_list_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeListIteratorIface* gee_linked_list_iterator_gee_list_iterator_parent_iface = NULL;
static GeeBidirListIteratorIface* gee_linked_list_iterator_gee_bidir_list_iterator_parent_iface = NULL;
static GeeQueueIface* gee_linked_list_gee_queue_parent_iface = NULL;
static GeeDequeIface* gee_linked_list_gee_deque_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_bidir_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_bidir_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_bidir_list_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_deque_get_type (void) G_GNUC_CONST;
GType gee_linked_list_get_type (void) G_GNUC_CONST;
static void gee_linked_list_node_free (GeeLinkedListNode* self);
#define GEE_LINKED_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_LINKED_LIST, GeeLinkedListPrivate))
enum  {
	GEE_LINKED_LIST_DUMMY_PROPERTY,
	GEE_LINKED_LIST_G_TYPE,
	GEE_LINKED_LIST_G_DUP_FUNC,
	GEE_LINKED_LIST_G_DESTROY_FUNC,
	GEE_LINKED_LIST_SIZE,
	GEE_LINKED_LIST_READ_ONLY,
	GEE_LINKED_LIST_CAPACITY,
	GEE_LINKED_LIST_REMAINING_CAPACITY,
	GEE_LINKED_LIST_IS_FULL
};
void gee_abstract_collection_clear (GeeAbstractCollection* self);
GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeAbstractBidirList* gee_abstract_bidir_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeEqualDataFunc gee_functions_get_equal_func_for (GType t, void** result_target, GDestroyNotify* result_target_destroy_notify);
static void gee_linked_list_set_equal_func (GeeLinkedList* self, GeeEqualDataFunc value, gpointer value_target);
static gboolean gee_linked_list_real_foreach (GeeAbstractCollection* base, GeeForallFunc f, void* f_target);
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base);
static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GType gee_linked_list_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeListIterator* gee_linked_list_real_list_iterator (GeeAbstractList* base);
static GeeBidirListIterator* gee_linked_list_real_bidir_list_iterator (GeeAbstractBidirList* base);
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item);
gint gee_abstract_list_index_of (GeeAbstractList* self, gconstpointer item);
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item);
static GeeLinkedListNode* gee_linked_list_node_new (gpointer data);
static GeeLinkedListNode* gee_linked_list_node_new (gpointer data);
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item);
GeeEqualDataFunc gee_linked_list_get_equal_func (GeeLinkedList* self, gpointer* result_target);
static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* _n);
static void gee_linked_list_real_clear (GeeAbstractCollection* base);
static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index);
static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index);
static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item);
static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item);
static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gpointer gee_linked_list_real_remove_at (GeeAbstractList* base, gint index);
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gpointer gee_linked_list_first (GeeLinkedList* self);
gpointer gee_linked_list_last (GeeLinkedList* self);
static gboolean gee_linked_list_real_offer (GeeQueue* base, gconstpointer element);
gboolean gee_deque_offer_tail (GeeDeque* self, gconstpointer element);
static gpointer gee_linked_list_real_peek (GeeQueue* base);
gpointer gee_deque_peek_head (GeeDeque* self);
static gpointer gee_linked_list_real_poll (GeeQueue* base);
gpointer gee_deque_poll_head (GeeDeque* self);
static gint gee_linked_list_real_drain (GeeQueue* base, GeeCollection* recipient, gint amount);
gint gee_deque_drain_head (GeeDeque* self, GeeCollection* recipient, gint amount);
static gboolean gee_linked_list_real_offer_head (GeeDeque* base, gconstpointer element);
void gee_abstract_list_insert (GeeAbstractList* self, gint index, gconstpointer item);
static gpointer gee_linked_list_real_peek_head (GeeDeque* base);
gpointer gee_abstract_list_get (GeeAbstractList* self, gint index);
static gpointer gee_linked_list_real_poll_head (GeeDeque* base);
gpointer gee_abstract_list_remove_at (GeeAbstractList* self, gint index);
static gint gee_linked_list_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount);
static gboolean gee_linked_list_real_offer_tail (GeeDeque* base, gconstpointer element);
static gpointer gee_linked_list_real_peek_tail (GeeDeque* base);
static gpointer gee_linked_list_real_poll_tail (GeeDeque* base);
static gint gee_linked_list_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
static void gee_linked_list_node_instance_init (GeeLinkedListNode * self);
#define GEE_LINKED_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorPrivate))
enum  {
	GEE_LINKED_LIST_ITERATOR_DUMMY_PROPERTY,
	GEE_LINKED_LIST_ITERATOR_G_TYPE,
	GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC,
	GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC,
	GEE_LINKED_LIST_ITERATOR_READ_ONLY,
	GEE_LINKED_LIST_ITERATOR_VALID
};
static gboolean gee_linked_list_iterator_real_next (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_has_next (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_first (GeeBidirIterator* base);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static gpointer gee_linked_list_iterator_real_get (GeeIterator* base);
static void gee_linked_list_iterator_real_remove (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_last (GeeBidirIterator* base);
static void gee_linked_list_iterator_real_set (GeeListIterator* base, gconstpointer item);
static void gee_linked_list_iterator_real_insert (GeeBidirListIterator* base, gconstpointer item);
static void gee_linked_list_iterator_real_add (GeeListIterator* base, gconstpointer item);
static gint gee_linked_list_iterator_real_index (GeeListIterator* base);
static gboolean gee_linked_list_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static void gee_linked_list_iterator_finalize (GObject* obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
gboolean gee_iterator_get_valid (GeeIterator* self);
static void _vala_gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_linked_list_finalize (GObject* obj);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
gint gee_queue_get_capacity (GeeQueue* self);
gint gee_queue_get_remaining_capacity (GeeQueue* self);
gboolean gee_queue_get_is_full (GeeQueue* self);
static void _vala_gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Constructs a new, empty linked list.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	GeeLinkedList * self = NULL;
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeEqualDataFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	self = (GeeLinkedList*) gee_abstract_bidir_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = equal_func;
	_tmp0__target = equal_func_target;
	if (_tmp0_ == NULL) {
		void* _tmp1_ = NULL;
		GDestroyNotify _tmp2_ = NULL;
		GeeEqualDataFunc _tmp3_ = NULL;
		_tmp3_ = gee_functions_get_equal_func_for (g_type, &_tmp1_, &_tmp2_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp3_;
		equal_func_target = _tmp1_;
		equal_func_target_destroy_notify = _tmp2_;
	}
	_tmp4_ = equal_func;
	_tmp4__target = equal_func_target;
	gee_linked_list_set_equal_func (self, _tmp4_, _tmp4__target);
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}


GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	return gee_linked_list_construct (GEE_TYPE_LINKED_LIST, g_type, g_dup_func, g_destroy_func, equal_func, equal_func_target, equal_func_target_destroy_notify);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_foreach (GeeAbstractCollection* base, GeeForallFunc f, void* f_target) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	{
		GeeLinkedListNode* node = NULL;
		GeeLinkedListNode* _tmp0_ = NULL;
		_tmp0_ = self->priv->_head;
		node = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				GeeLinkedListNode* _tmp5_ = NULL;
				GeeForallFunc _tmp6_ = NULL;
				void* _tmp6__target = NULL;
				GeeLinkedListNode* _tmp7_ = NULL;
				gconstpointer _tmp8_ = NULL;
				gpointer _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					GeeLinkedListNode* _tmp3_ = NULL;
					GeeLinkedListNode* _tmp4_ = NULL;
					_tmp3_ = node;
					_tmp4_ = _tmp3_->next;
					node = _tmp4_;
				}
				_tmp1_ = FALSE;
				_tmp5_ = node;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = f;
				_tmp6__target = f_target;
				_tmp7_ = node;
				_tmp8_ = _tmp7_->data;
				_tmp9_ = ((_tmp8_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp8_) : ((gpointer) _tmp8_);
				_tmp10_ = _tmp6_ (_tmp9_, _tmp6__target);
				if (!_tmp10_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base) {
	GeeLinkedList * self;
	GeeIterator* result = NULL;
	GeeLinkedListIterator* _tmp0_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeListIterator* gee_linked_list_real_list_iterator (GeeAbstractList* base) {
	GeeLinkedList * self;
	GeeListIterator* result = NULL;
	GeeLinkedListIterator* _tmp0_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (GeeListIterator*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeBidirListIterator* gee_linked_list_real_bidir_list_iterator (GeeAbstractBidirList* base) {
	GeeLinkedList * self;
	GeeBidirListIterator* result = NULL;
	GeeLinkedListIterator* _tmp0_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (GeeBidirListIterator*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gint _tmp1_ = 0;
	self = (GeeLinkedList*) base;
	_tmp0_ = item;
	_tmp1_ = gee_abstract_list_index_of ((GeeAbstractList*) self, _tmp0_);
	result = _tmp1_ != (-1);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	GeeLinkedListNode* n = NULL;
	gconstpointer _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	GeeLinkedListNode* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeLinkedListNode* _tmp4_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint _tmp15_ = 0;
	self = (GeeLinkedList*) base;
	_tmp0_ = item;
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
	_tmp2_ = gee_linked_list_node_new (_tmp1_);
	n = _tmp2_;
	_tmp4_ = self->priv->_head;
	if (_tmp4_ == NULL) {
		GeeLinkedListNode* _tmp5_ = NULL;
		_tmp5_ = self->priv->_tail;
		_tmp3_ = _tmp5_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		GeeLinkedListNode* _tmp7_ = NULL;
		GeeLinkedListNode* _tmp8_ = NULL;
		_tmp7_ = n;
		self->priv->_tail = _tmp7_;
		_tmp8_ = n;
		n = NULL;
		_gee_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = _tmp8_;
	} else {
		GeeLinkedListNode* _tmp9_ = NULL;
		GeeLinkedListNode* _tmp10_ = NULL;
		GeeLinkedListNode* _tmp11_ = NULL;
		GeeLinkedListNode* _tmp12_ = NULL;
		GeeLinkedListNode* _tmp13_ = NULL;
		GeeLinkedListNode* _tmp14_ = NULL;
		_tmp9_ = n;
		_tmp10_ = self->priv->_tail;
		_tmp9_->prev = _tmp10_;
		_tmp11_ = self->priv->_tail;
		_tmp12_ = n;
		n = NULL;
		_gee_linked_list_node_free0 (_tmp11_->next);
		_tmp11_->next = _tmp12_;
		_tmp13_ = self->priv->_tail;
		_tmp14_ = _tmp13_->next;
		self->priv->_tail = _tmp14_;
	}
	_tmp15_ = self->priv->_size;
	self->priv->_size = _tmp15_ + 1;
	result = TRUE;
	_gee_linked_list_node_free0 (n);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	{
		GeeLinkedListNode* n = NULL;
		GeeLinkedListNode* _tmp0_ = NULL;
		_tmp0_ = self->priv->_head;
		n = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				GeeLinkedListNode* _tmp5_ = NULL;
				GeeEqualDataFunc _tmp6_ = NULL;
				void* _tmp6__target = NULL;
				GeeEqualDataFunc _tmp7_ = NULL;
				void* _tmp7__target = NULL;
				gconstpointer _tmp8_ = NULL;
				GeeLinkedListNode* _tmp9_ = NULL;
				gconstpointer _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					GeeLinkedListNode* _tmp3_ = NULL;
					GeeLinkedListNode* _tmp4_ = NULL;
					_tmp3_ = n;
					_tmp4_ = _tmp3_->next;
					n = _tmp4_;
				}
				_tmp1_ = FALSE;
				_tmp5_ = n;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = gee_linked_list_get_equal_func (self, &_tmp6__target);
				_tmp7_ = _tmp6_;
				_tmp7__target = _tmp6__target;
				_tmp8_ = item;
				_tmp9_ = n;
				_tmp10_ = _tmp9_->data;
				_tmp11_ = _tmp7_ (_tmp8_, _tmp10_, _tmp7__target);
				if (_tmp11_) {
					GeeLinkedListNode* _tmp12_ = NULL;
					_tmp12_ = n;
					_gee_linked_list_remove_node (self, _tmp12_);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_linked_list_real_clear (GeeAbstractCollection* base) {
	GeeLinkedList * self;
	gint _tmp2_ = 0;
	self = (GeeLinkedList*) base;
	while (TRUE) {
		GeeLinkedListNode* _tmp0_ = NULL;
		GeeLinkedListNode* _tmp1_ = NULL;
		_tmp0_ = self->priv->_head;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = self->priv->_head;
		_gee_linked_list_remove_node (self, _tmp1_);
	}
	_tmp2_ = self->priv->_stamp;
	self->priv->_stamp = _tmp2_ + 1;
	_gee_linked_list_node_free0 (self->priv->_head);
	self->priv->_head = NULL;
	self->priv->_tail = NULL;
	self->priv->_size = 0;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeLinkedListNode* n = NULL;
	gint _tmp3_ = 0;
	GeeLinkedListNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= 0, "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->priv->_size;
	_vala_assert (_tmp1_ < _tmp2_, "index < this._size");
	_tmp3_ = index;
	_tmp4_ = _gee_linked_list_get_node_at (self, _tmp3_);
	n = _tmp4_;
	_vala_assert (n != NULL, "n != null");
	_tmp5_ = n->data;
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	result = _tmp6_;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeLinkedList * self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeLinkedListNode* n = NULL;
	gint _tmp3_ = 0;
	GeeLinkedListNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= 0, "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->priv->_size;
	_vala_assert (_tmp1_ < _tmp2_, "index < this._size");
	_tmp3_ = index;
	_tmp4_ = _gee_linked_list_get_node_at (self, _tmp3_);
	n = _tmp4_;
	g_return_if_fail (n != NULL);
	_tmp5_ = item;
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	((n->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (n->data = (self->priv->g_destroy_func (n->data), NULL));
	n->data = _tmp6_;
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item) {
	GeeLinkedList * self;
	gint result = 0;
	gint idx = 0;
	self = (GeeLinkedList*) base;
	idx = 0;
	{
		GeeLinkedListNode* node = NULL;
		GeeLinkedListNode* _tmp0_ = NULL;
		_tmp0_ = self->priv->_head;
		node = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				GeeLinkedListNode* _tmp6_ = NULL;
				GeeEqualDataFunc _tmp7_ = NULL;
				void* _tmp7__target = NULL;
				GeeEqualDataFunc _tmp8_ = NULL;
				void* _tmp8__target = NULL;
				gconstpointer _tmp9_ = NULL;
				GeeLinkedListNode* _tmp10_ = NULL;
				gconstpointer _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					GeeLinkedListNode* _tmp3_ = NULL;
					GeeLinkedListNode* _tmp4_ = NULL;
					gint _tmp5_ = 0;
					_tmp3_ = node;
					_tmp4_ = _tmp3_->next;
					node = _tmp4_;
					_tmp5_ = idx;
					idx = _tmp5_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp6_ = node;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = gee_linked_list_get_equal_func (self, &_tmp7__target);
				_tmp8_ = _tmp7_;
				_tmp8__target = _tmp7__target;
				_tmp9_ = item;
				_tmp10_ = node;
				_tmp11_ = _tmp10_->data;
				_tmp12_ = _tmp8_ (_tmp9_, _tmp11_, _tmp8__target);
				if (_tmp12_) {
					result = idx;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeLinkedList * self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	self = (GeeLinkedList*) base;
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= 0, "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->priv->_size;
	_vala_assert (_tmp1_ <= _tmp2_, "index <= this._size");
	_tmp3_ = index;
	_tmp4_ = self->priv->_size;
	if (_tmp3_ == _tmp4_) {
		gconstpointer _tmp5_ = NULL;
		_tmp5_ = item;
		gee_abstract_collection_add ((GeeAbstractCollection*) self, _tmp5_);
	} else {
		GeeLinkedListNode* n = NULL;
		gconstpointer _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		GeeLinkedListNode* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp34_ = 0;
		_tmp6_ = item;
		_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
		_tmp8_ = gee_linked_list_node_new (_tmp7_);
		n = _tmp8_;
		_tmp9_ = index;
		if (_tmp9_ == 0) {
			GeeLinkedListNode* _tmp10_ = NULL;
			GeeLinkedListNode* _tmp11_ = NULL;
			GeeLinkedListNode* _tmp12_ = NULL;
			GeeLinkedListNode* _tmp13_ = NULL;
			GeeLinkedListNode* _tmp14_ = NULL;
			GeeLinkedListNode* _tmp15_ = NULL;
			_tmp10_ = n;
			_tmp11_ = self->priv->_head;
			self->priv->_head = NULL;
			_gee_linked_list_node_free0 (_tmp10_->next);
			_tmp10_->next = _tmp11_;
			_tmp12_ = n;
			_tmp13_ = _tmp12_->next;
			_tmp14_ = n;
			_tmp13_->prev = _tmp14_;
			_tmp15_ = n;
			n = NULL;
			_gee_linked_list_node_free0 (self->priv->_head);
			self->priv->_head = _tmp15_;
		} else {
			GeeLinkedListNode* prev = NULL;
			GeeLinkedListNode* _tmp16_ = NULL;
			GeeLinkedListNode* _tmp24_ = NULL;
			GeeLinkedListNode* _tmp25_ = NULL;
			GeeLinkedListNode* _tmp26_ = NULL;
			GeeLinkedListNode* _tmp27_ = NULL;
			GeeLinkedListNode* _tmp28_ = NULL;
			GeeLinkedListNode* _tmp29_ = NULL;
			GeeLinkedListNode* _tmp30_ = NULL;
			GeeLinkedListNode* _tmp31_ = NULL;
			GeeLinkedListNode* _tmp32_ = NULL;
			GeeLinkedListNode* _tmp33_ = NULL;
			_tmp16_ = self->priv->_head;
			prev = _tmp16_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp17_ = FALSE;
					_tmp17_ = TRUE;
					while (TRUE) {
						gboolean _tmp18_ = FALSE;
						gint _tmp20_ = 0;
						gint _tmp21_ = 0;
						GeeLinkedListNode* _tmp22_ = NULL;
						GeeLinkedListNode* _tmp23_ = NULL;
						_tmp18_ = _tmp17_;
						if (!_tmp18_) {
							gint _tmp19_ = 0;
							_tmp19_ = i;
							i = _tmp19_ + 1;
						}
						_tmp17_ = FALSE;
						_tmp20_ = i;
						_tmp21_ = index;
						if (!(_tmp20_ < (_tmp21_ - 1))) {
							break;
						}
						_tmp22_ = prev;
						_tmp23_ = _tmp22_->next;
						prev = _tmp23_;
					}
				}
			}
			_tmp24_ = n;
			_tmp25_ = prev;
			_tmp24_->prev = _tmp25_;
			_tmp26_ = n;
			_tmp27_ = prev;
			_tmp28_ = _tmp27_->next;
			_tmp27_->next = NULL;
			_gee_linked_list_node_free0 (_tmp26_->next);
			_tmp26_->next = _tmp28_;
			_tmp29_ = n;
			_tmp30_ = _tmp29_->next;
			_tmp31_ = n;
			_tmp30_->prev = _tmp31_;
			_tmp32_ = prev;
			_tmp33_ = n;
			n = NULL;
			_gee_linked_list_node_free0 (_tmp32_->next);
			_tmp32_->next = _tmp33_;
		}
		_tmp34_ = self->priv->_size;
		self->priv->_size = _tmp34_ + 1;
		_gee_linked_list_node_free0 (n);
	}
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_remove_at (GeeAbstractList* base, gint index) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeLinkedListNode* n = NULL;
	gint _tmp3_ = 0;
	GeeLinkedListNode* _tmp4_ = NULL;
	gpointer element = NULL;
	gconstpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= 0, "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->priv->_size;
	_vala_assert (_tmp1_ < _tmp2_, "index < this._size");
	_tmp3_ = index;
	_tmp4_ = _gee_linked_list_get_node_at (self, _tmp3_);
	n = _tmp4_;
	_vala_assert (n != NULL, "n != null");
	_tmp5_ = n->data;
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	element = _tmp6_;
	_gee_linked_list_remove_node (self, n);
	result = element;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop) {
	GeeLinkedList * self;
	GeeList* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GeeList* slice = NULL;
	GeeEqualDataFunc _tmp5_ = NULL;
	void* _tmp5__target = NULL;
	GeeEqualDataFunc _tmp6_ = NULL;
	void* _tmp6__target = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	GeeLinkedListNode* n = NULL;
	gint _tmp8_ = 0;
	GeeLinkedListNode* _tmp9_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = start;
	_tmp1_ = stop;
	g_return_val_if_fail (_tmp0_ <= _tmp1_, NULL);
	_tmp2_ = start;
	g_return_val_if_fail (_tmp2_ >= 0, NULL);
	_tmp3_ = stop;
	_tmp4_ = self->priv->_size;
	g_return_val_if_fail (_tmp3_ <= _tmp4_, NULL);
	_tmp5_ = gee_linked_list_get_equal_func (self, &_tmp5__target);
	_tmp6_ = _tmp5_;
	_tmp6__target = _tmp5__target;
	_tmp7_ = gee_linked_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp6_, _tmp6__target, NULL);
	slice = (GeeList*) _tmp7_;
	_tmp8_ = start;
	_tmp9_ = _gee_linked_list_get_node_at (self, _tmp8_);
	n = _tmp9_;
	{
		gint i = 0;
		gint _tmp10_ = 0;
		_tmp10_ = start;
		i = _tmp10_;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_ = FALSE;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				GeeList* _tmp16_ = NULL;
				GeeLinkedListNode* _tmp17_ = NULL;
				gconstpointer _tmp18_ = NULL;
				GeeLinkedListNode* _tmp19_ = NULL;
				GeeLinkedListNode* _tmp20_ = NULL;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = stop;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = slice;
				_tmp17_ = n;
				_tmp18_ = _tmp17_->data;
				gee_collection_add ((GeeCollection*) _tmp16_, _tmp18_);
				_tmp19_ = n;
				_tmp20_ = _tmp19_->next;
				n = _tmp20_;
			}
		}
	}
	result = slice;
	return result;
}


/**
 * {@inheritDoc}
 */
gpointer gee_linked_list_first (GeeLinkedList* self) {
	gpointer result = NULL;
	gint _tmp0_ = 0;
	GeeLinkedListNode* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_size;
	_vala_assert (_tmp0_ > 0, "_size > 0");
	_tmp1_ = self->priv->_head;
	_tmp2_ = _tmp1_->data;
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
	result = _tmp3_;
	return result;
}


/**
 * {@inheritDoc}
 */
gpointer gee_linked_list_last (GeeLinkedList* self) {
	gpointer result = NULL;
	gint _tmp0_ = 0;
	GeeLinkedListNode* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_size;
	_vala_assert (_tmp0_ > 0, "_size > 0");
	_tmp1_ = self->priv->_tail;
	_tmp2_ = _tmp1_->data;
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
	result = _tmp3_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_offer (GeeQueue* base, gconstpointer element) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (GeeLinkedList*) base;
	_tmp0_ = element;
	_tmp1_ = gee_deque_offer_tail ((GeeDeque*) self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_peek (GeeQueue* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_deque_peek_head ((GeeDeque*) self);
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_poll (GeeQueue* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_deque_poll_head ((GeeDeque*) self);
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_drain (GeeQueue* base, GeeCollection* recipient, gint amount) {
	GeeLinkedList * self;
	gint result = 0;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	_tmp0_ = recipient;
	_tmp1_ = amount;
	_tmp2_ = gee_deque_drain_head ((GeeDeque*) self, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_offer_head (GeeDeque* base, gconstpointer element) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = element;
	gee_abstract_list_insert ((GeeAbstractList*) self, 0, _tmp0_);
	result = TRUE;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_peek_head (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	gpointer _tmp1_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = self->priv->_size;
	if (_tmp0_ == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) self, 0);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_poll_head (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	gpointer _tmp1_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = self->priv->_size;
	if (_tmp0_ == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeLinkedList * self;
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp11_ = 0;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	_tmp0_ = amount;
	if (_tmp0_ == (-1)) {
		gint _tmp1_ = 0;
		_tmp1_ = self->priv->_size;
		amount = _tmp1_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				GeeCollection* _tmp8_ = NULL;
				gpointer _tmp9_ = NULL;
				gpointer _tmp10_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = amount;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->_size;
				if (_tmp7_ == 0) {
					result = i;
					return result;
				}
				_tmp8_ = recipient;
				_tmp9_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0);
				_tmp10_ = _tmp9_;
				gee_collection_add (_tmp8_, _tmp10_);
				((_tmp10_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp10_ = (self->priv->g_destroy_func (_tmp10_), NULL));
			}
		}
	}
	_tmp11_ = amount;
	result = _tmp11_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_offer_tail (GeeDeque* base, gconstpointer element) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (GeeLinkedList*) base;
	_tmp0_ = element;
	_tmp1_ = gee_abstract_collection_add ((GeeAbstractCollection*) self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_peek_tail (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = self->priv->_size;
	if (_tmp0_ == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_size;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) self, _tmp1_ - 1);
	result = _tmp2_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_poll_tail (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	self = (GeeLinkedList*) base;
	_tmp0_ = self->priv->_size;
	if (_tmp0_ == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_size;
	_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, _tmp1_ - 1);
	result = _tmp2_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeLinkedList * self;
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp12_ = 0;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	_tmp0_ = amount;
	if (_tmp0_ == (-1)) {
		gint _tmp1_ = 0;
		_tmp1_ = self->priv->_size;
		amount = _tmp1_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				GeeCollection* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gpointer _tmp10_ = NULL;
				gpointer _tmp11_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = amount;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->_size;
				if (_tmp7_ == 0) {
					result = i;
					return result;
				}
				_tmp8_ = recipient;
				_tmp9_ = self->priv->_size;
				_tmp10_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, _tmp9_ - 1);
				_tmp11_ = _tmp10_;
				gee_collection_add (_tmp8_, _tmp11_);
				((_tmp11_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp11_ = (self->priv->g_destroy_func (_tmp11_), NULL));
			}
		}
	}
	_tmp12_ = amount;
	result = _tmp12_;
	return result;
}


static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index) {
	GeeLinkedListNode* result = NULL;
	GeeLinkedListNode* n = NULL;
	gint _tmp0_ = 0;
	GeeLinkedListNode* _tmp24_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	n = NULL;
	_tmp0_ = index;
	if (_tmp0_ == 0) {
		GeeLinkedListNode* _tmp1_ = NULL;
		_tmp1_ = self->priv->_head;
		n = _tmp1_;
	} else {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp2_ = index;
		_tmp3_ = self->priv->_size;
		if (_tmp2_ == (_tmp3_ - 1)) {
			GeeLinkedListNode* _tmp4_ = NULL;
			_tmp4_ = self->priv->_tail;
			n = _tmp4_;
		} else {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			_tmp5_ = index;
			_tmp6_ = self->priv->_size;
			if (_tmp5_ <= (_tmp6_ / 2)) {
				GeeLinkedListNode* _tmp7_ = NULL;
				_tmp7_ = self->priv->_head;
				n = _tmp7_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp9_ = FALSE;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							GeeLinkedListNode* _tmp13_ = NULL;
							GeeLinkedListNode* _tmp14_ = NULL;
							_tmp9_ = _tmp8_;
							if (!_tmp9_) {
								gint _tmp10_ = 0;
								_tmp10_ = i;
								i = _tmp10_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp11_ = index;
							_tmp12_ = i;
							if (!(_tmp11_ != _tmp12_)) {
								break;
							}
							_tmp13_ = n;
							_tmp14_ = _tmp13_->next;
							n = _tmp14_;
						}
					}
				}
			} else {
				GeeLinkedListNode* _tmp15_ = NULL;
				_tmp15_ = self->priv->_tail;
				n = _tmp15_;
				{
					gint i = 0;
					gint _tmp16_ = 0;
					_tmp16_ = self->priv->_size;
					i = _tmp16_ - 1;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							gboolean _tmp18_ = FALSE;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							GeeLinkedListNode* _tmp22_ = NULL;
							GeeLinkedListNode* _tmp23_ = NULL;
							_tmp18_ = _tmp17_;
							if (!_tmp18_) {
								gint _tmp19_ = 0;
								_tmp19_ = i;
								i = _tmp19_ - 1;
							}
							_tmp17_ = FALSE;
							_tmp20_ = index;
							_tmp21_ = i;
							if (!(_tmp20_ != _tmp21_)) {
								break;
							}
							_tmp22_ = n;
							_tmp23_ = _tmp22_->prev;
							n = _tmp23_;
						}
					}
				}
			}
		}
	}
	_tmp24_ = n;
	result = _tmp24_;
	return result;
}


static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* _n) {
	GeeLinkedListNode* n = NULL;
	GeeLinkedListNode* next = NULL;
	GeeLinkedListNode* _tmp0_ = NULL;
	GeeLinkedListNode* _tmp1_ = NULL;
	GeeLinkedListNode* _tmp14_ = NULL;
	GeeLinkedListNode* _tmp15_ = NULL;
	GeeLinkedListNode* _tmp21_ = NULL;
	GeeLinkedListNode* _tmp22_ = NULL;
	GeeLinkedListNode* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_n != NULL);
	_tmp0_ = _n;
	_tmp1_ = self->priv->_head;
	if (_tmp0_ == _tmp1_) {
		GeeLinkedListNode* _tmp2_ = NULL;
		GeeLinkedListNode* _tmp3_ = NULL;
		GeeLinkedListNode* _tmp4_ = NULL;
		GeeLinkedListNode* _tmp5_ = NULL;
		_tmp2_ = self->priv->_head;
		self->priv->_head = NULL;
		_gee_linked_list_node_free0 (n);
		n = _tmp2_;
		_tmp3_ = n;
		_tmp4_ = _tmp3_->next;
		_tmp3_->next = NULL;
		_gee_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = _tmp4_;
		_tmp5_ = self->priv->_head;
		next = _tmp5_;
	} else {
		GeeLinkedListNode* _tmp6_ = NULL;
		GeeLinkedListNode* _tmp7_ = NULL;
		GeeLinkedListNode* _tmp8_ = NULL;
		GeeLinkedListNode* _tmp9_ = NULL;
		GeeLinkedListNode* _tmp10_ = NULL;
		GeeLinkedListNode* _tmp11_ = NULL;
		GeeLinkedListNode* _tmp12_ = NULL;
		GeeLinkedListNode* _tmp13_ = NULL;
		_tmp6_ = _n;
		_tmp7_ = _tmp6_->prev;
		_tmp8_ = _tmp7_->next;
		_tmp7_->next = NULL;
		_gee_linked_list_node_free0 (n);
		n = _tmp8_;
		_tmp9_ = n;
		_tmp10_ = _tmp9_->prev;
		_tmp11_ = n;
		_tmp12_ = _tmp11_->next;
		_tmp11_->next = NULL;
		_gee_linked_list_node_free0 (_tmp10_->next);
		_tmp10_->next = _tmp12_;
		_tmp13_ = _tmp10_->next;
		next = _tmp13_;
	}
	_tmp14_ = n;
	_tmp15_ = self->priv->_tail;
	if (_tmp14_ == _tmp15_) {
		GeeLinkedListNode* _tmp16_ = NULL;
		GeeLinkedListNode* _tmp17_ = NULL;
		_tmp16_ = n;
		_tmp17_ = _tmp16_->prev;
		self->priv->_tail = _tmp17_;
	} else {
		GeeLinkedListNode* _tmp18_ = NULL;
		GeeLinkedListNode* _tmp19_ = NULL;
		GeeLinkedListNode* _tmp20_ = NULL;
		_tmp18_ = next;
		_tmp19_ = n;
		_tmp20_ = _tmp19_->prev;
		_tmp18_->prev = _tmp20_;
	}
	_tmp21_ = n;
	_tmp21_->prev = NULL;
	_tmp22_ = n;
	_gee_linked_list_node_free0 (_tmp22_->next);
	_tmp22_->next = NULL;
	_tmp23_ = n;
	((_tmp23_->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp23_->data = (self->priv->g_destroy_func (_tmp23_->data), NULL));
	_tmp23_->data = NULL;
	_tmp24_ = self->priv->_stamp;
	self->priv->_stamp = _tmp24_ + 1;
	_tmp25_ = self->priv->_size;
	self->priv->_size = _tmp25_ - 1;
	_gee_linked_list_node_free0 (n);
}


GeeEqualDataFunc gee_linked_list_get_equal_func (GeeLinkedList* self, gpointer* result_target) {
	GeeEqualDataFunc result;
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeEqualDataFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp0__target = self->priv->_equal_func_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}


static void gee_linked_list_set_equal_func (GeeLinkedList* self, GeeEqualDataFunc value, gpointer value_target) {
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__target = value_target;
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
	self->priv->_equal_func = NULL;
	self->priv->_equal_func_target = NULL;
	self->priv->_equal_func_target_destroy_notify = NULL;
	self->priv->_equal_func = _tmp0_;
	self->priv->_equal_func_target = _tmp0__target;
	self->priv->_equal_func_target_destroy_notify = NULL;
}


static gint gee_linked_list_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeLinkedList* self;
	gint _tmp0_ = 0;
	self = (GeeLinkedList*) base;
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


static gboolean gee_linked_list_real_get_read_only (GeeAbstractCollection* base) {
	gboolean result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = FALSE;
	return result;
}


static gint gee_linked_list_real_get_capacity (GeeQueue* base) {
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}


static gint gee_linked_list_real_get_remaining_capacity (GeeQueue* base) {
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}


static gboolean gee_linked_list_real_get_is_full (GeeQueue* base) {
	gboolean result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = FALSE;
	return result;
}


static GeeLinkedListNode* gee_linked_list_node_new (gpointer data) {
	GeeLinkedListNode* self;
	gconstpointer _tmp0_ = NULL;
	self = g_slice_new0 (GeeLinkedListNode);
	gee_linked_list_node_instance_init (self);
	_tmp0_ = data;
	self->data = _tmp0_;
	return self;
}


static void gee_linked_list_node_instance_init (GeeLinkedListNode * self) {
	self->prev = NULL;
	self->next = NULL;
}


static void gee_linked_list_node_free (GeeLinkedListNode* self) {
	_gee_linked_list_node_free0 (self->next);
	g_slice_free (GeeLinkedListNode, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
	GeeLinkedListIterator * self = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (list != NULL, NULL);
	self = (GeeLinkedListIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = list;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_list);
	self->priv->_list = _tmp1_;
	self->priv->position = NULL;
	self->priv->_index = -1;
	_tmp2_ = list;
	_tmp3_ = _tmp2_->priv->_stamp;
	self->priv->_stamp = _tmp3_;
	return self;
}


static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
	return gee_linked_list_iterator_construct (GEE_LINKED_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
}


static gboolean gee_linked_list_iterator_real_next (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->removed;
	if (_tmp3_) {
		GeeLinkedListNode* _tmp4_ = NULL;
		_tmp4_ = self->priv->position;
		if (_tmp4_ != NULL) {
			self->priv->removed = FALSE;
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	} else {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->priv->started;
		if (!_tmp5_) {
			GeeLinkedList* _tmp6_ = NULL;
			GeeLinkedListNode* _tmp7_ = NULL;
			_tmp6_ = self->priv->_list;
			_tmp7_ = _tmp6_->priv->_head;
			if (_tmp7_ != NULL) {
				GeeLinkedList* _tmp8_ = NULL;
				GeeLinkedListNode* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				self->priv->started = TRUE;
				_tmp8_ = self->priv->_list;
				_tmp9_ = _tmp8_->priv->_head;
				self->priv->position = _tmp9_;
				_tmp10_ = self->priv->_index;
				self->priv->_index = _tmp10_ + 1;
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		} else {
			GeeLinkedListNode* _tmp11_ = NULL;
			_tmp11_ = self->priv->position;
			if (_tmp11_ != NULL) {
				GeeLinkedListNode* _tmp12_ = NULL;
				GeeLinkedListNode* _tmp13_ = NULL;
				_tmp12_ = self->priv->position;
				_tmp13_ = _tmp12_->next;
				if (_tmp13_ != NULL) {
					GeeLinkedListNode* _tmp14_ = NULL;
					GeeLinkedListNode* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					_tmp14_ = self->priv->position;
					_tmp15_ = _tmp14_->next;
					self->priv->position = _tmp15_;
					_tmp16_ = self->priv->_index;
					self->priv->_index = _tmp16_ + 1;
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean gee_linked_list_iterator_real_has_next (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->removed;
	if (_tmp3_) {
		GeeLinkedListNode* _tmp4_ = NULL;
		_tmp4_ = self->priv->position;
		result = _tmp4_ != NULL;
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->priv->started;
		if (!_tmp5_) {
			GeeLinkedList* _tmp6_ = NULL;
			GeeLinkedListNode* _tmp7_ = NULL;
			_tmp6_ = self->priv->_list;
			_tmp7_ = _tmp6_->priv->_head;
			result = _tmp7_ != NULL;
			return result;
		} else {
			GeeLinkedListNode* _tmp8_ = NULL;
			_tmp8_ = self->priv->position;
			if (_tmp8_ != NULL) {
				GeeLinkedListNode* _tmp9_ = NULL;
				GeeLinkedListNode* _tmp10_ = NULL;
				_tmp9_ = self->priv->position;
				_tmp10_ = _tmp9_->next;
				result = _tmp10_ != NULL;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean gee_linked_list_iterator_real_first (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeLinkedList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedListNode* _tmp7_ = NULL;
	GeeLinkedListNode* _tmp8_ = NULL;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->_list;
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->_list;
	_tmp7_ = _tmp6_->priv->_head;
	self->priv->position = _tmp7_;
	self->priv->started = TRUE;
	self->priv->_index = 0;
	self->priv->removed = FALSE;
	_tmp8_ = self->priv->position;
	result = _tmp8_ != NULL;
	return result;
}


static gpointer gee_linked_list_iterator_real_get (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeLinkedListNode* _tmp3_ = NULL;
	GeeLinkedListNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->position;
	_vala_assert (_tmp3_ != NULL, "this.position != null");
	_tmp4_ = self->priv->position;
	_tmp5_ = _tmp4_->data;
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	result = _tmp6_;
	return result;
}


static void gee_linked_list_iterator_real_remove (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeLinkedListNode* _tmp3_ = NULL;
	GeeLinkedListNode* new_position = NULL;
	GeeLinkedListNode* _tmp4_ = NULL;
	GeeLinkedListNode* _tmp5_ = NULL;
	GeeLinkedListNode* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	GeeLinkedListNode* _tmp8_ = NULL;
	GeeLinkedListNode* _tmp9_ = NULL;
	GeeLinkedList* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->position;
	_vala_assert (_tmp3_ != NULL, "this.position != null");
	_tmp4_ = self->priv->position;
	_tmp5_ = _tmp4_->next;
	new_position = _tmp5_;
	_tmp6_ = new_position;
	if (_tmp6_ == NULL) {
		self->priv->started = FALSE;
	}
	_tmp7_ = self->priv->_list;
	_tmp8_ = self->priv->position;
	_gee_linked_list_remove_node (_tmp7_, _tmp8_);
	_tmp9_ = new_position;
	self->priv->position = _tmp9_;
	self->priv->removed = TRUE;
	_tmp10_ = self->priv->_list;
	_tmp11_ = _tmp10_->priv->_stamp;
	self->priv->_stamp = _tmp11_;
}


static gboolean gee_linked_list_iterator_real_previous (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->started;
	if (!_tmp3_) {
		self->priv->position = NULL;
		result = FALSE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		GeeLinkedListNode* _tmp5_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = self->priv->position;
		if (_tmp5_ != NULL) {
			GeeLinkedListNode* _tmp6_ = NULL;
			GeeLinkedListNode* _tmp7_ = NULL;
			_tmp6_ = self->priv->position;
			_tmp7_ = _tmp6_->prev;
			_tmp4_ = _tmp7_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp8_ = _tmp4_;
		if (_tmp8_) {
			GeeLinkedListNode* _tmp9_ = NULL;
			GeeLinkedListNode* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			_tmp9_ = self->priv->position;
			_tmp10_ = _tmp9_->prev;
			self->priv->position = _tmp10_;
			_tmp11_ = self->priv->_index;
			self->priv->_index = _tmp11_ - 1;
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->started;
	if (!_tmp3_) {
		result = FALSE;
		return result;
	} else {
		GeeLinkedListNode* _tmp4_ = NULL;
		_tmp4_ = self->priv->position;
		if (_tmp4_ != NULL) {
			GeeLinkedListNode* _tmp5_ = NULL;
			GeeLinkedListNode* _tmp6_ = NULL;
			_tmp5_ = self->priv->position;
			_tmp6_ = _tmp5_->prev;
			result = _tmp6_ != NULL;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean gee_linked_list_iterator_real_last (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeLinkedList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedListNode* _tmp7_ = NULL;
	GeeLinkedList* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GeeLinkedListNode* _tmp10_ = NULL;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->_list;
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->_list;
	_tmp7_ = _tmp6_->priv->_tail;
	self->priv->position = _tmp7_;
	self->priv->started = TRUE;
	_tmp8_ = self->priv->_list;
	_tmp9_ = _tmp8_->priv->_size;
	self->priv->_index = _tmp9_ - 1;
	_tmp10_ = self->priv->position;
	result = _tmp10_ != NULL;
	return result;
}


static void gee_linked_list_iterator_real_set (GeeListIterator* base, gconstpointer item) {
	GeeLinkedListIterator * self;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeLinkedListNode* _tmp3_ = NULL;
	GeeLinkedListNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->position;
	_vala_assert (_tmp3_ != NULL, "this.position != null");
	_tmp4_ = self->priv->position;
	_tmp5_ = item;
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	((_tmp4_->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp4_->data = (self->priv->g_destroy_func (_tmp4_->data), NULL));
	_tmp4_->data = _tmp6_;
}


static void gee_linked_list_iterator_real_insert (GeeBidirListIterator* base, gconstpointer item) {
	GeeLinkedListIterator * self;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeLinkedListNode* _tmp3_ = NULL;
	GeeLinkedListNode* n = NULL;
	gconstpointer _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GeeLinkedListNode* _tmp6_ = NULL;
	GeeLinkedListNode* _tmp7_ = NULL;
	GeeLinkedListNode* _tmp8_ = NULL;
	GeeLinkedList* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	GeeLinkedList* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->position;
	_vala_assert (_tmp3_ != NULL, "this.position != null");
	_tmp4_ = item;
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
	_tmp6_ = gee_linked_list_node_new (_tmp5_);
	n = _tmp6_;
	_tmp7_ = self->priv->position;
	_tmp8_ = _tmp7_->prev;
	if (_tmp8_ != NULL) {
		GeeLinkedListNode* position = NULL;
		GeeLinkedListNode* _tmp9_ = NULL;
		GeeLinkedListNode* _tmp10_ = NULL;
		GeeLinkedListNode* _tmp11_ = NULL;
		GeeLinkedListNode* _tmp12_ = NULL;
		GeeLinkedListNode* _tmp13_ = NULL;
		GeeLinkedListNode* _tmp14_ = NULL;
		GeeLinkedListNode* _tmp15_ = NULL;
		GeeLinkedListNode* _tmp16_ = NULL;
		GeeLinkedListNode* _tmp17_ = NULL;
		GeeLinkedListNode* _tmp18_ = NULL;
		GeeLinkedListNode* _n = NULL;
		GeeLinkedListNode* _tmp19_ = NULL;
		GeeLinkedListNode* _tmp20_ = NULL;
		GeeLinkedListNode* _tmp21_ = NULL;
		GeeLinkedListNode* _tmp22_ = NULL;
		_tmp9_ = self->priv->position;
		_tmp10_ = _tmp9_->prev;
		_tmp11_ = _tmp10_->next;
		_tmp10_->next = NULL;
		position = _tmp11_;
		_tmp12_ = n;
		_tmp13_ = position;
		_tmp14_ = _tmp13_->prev;
		_tmp12_->prev = _tmp14_;
		_tmp15_ = position;
		_tmp16_ = n;
		_tmp15_->prev = _tmp16_;
		_tmp17_ = n;
		_tmp18_ = position;
		position = NULL;
		_gee_linked_list_node_free0 (_tmp17_->next);
		_tmp17_->next = _tmp18_;
		_tmp19_ = n;
		_n = _tmp19_;
		_tmp20_ = _n;
		_tmp21_ = _tmp20_->prev;
		_tmp22_ = n;
		n = NULL;
		_gee_linked_list_node_free0 (_tmp21_->next);
		_tmp21_->next = _tmp22_;
		_gee_linked_list_node_free0 (position);
	} else {
		GeeLinkedListNode* position = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedListNode* _tmp24_ = NULL;
		GeeLinkedListNode* _tmp25_ = NULL;
		GeeLinkedListNode* _tmp26_ = NULL;
		GeeLinkedListNode* _tmp27_ = NULL;
		GeeLinkedListNode* _tmp28_ = NULL;
		GeeLinkedList* _tmp29_ = NULL;
		GeeLinkedListNode* _tmp30_ = NULL;
		_tmp23_ = self->priv->_list;
		_tmp24_ = _tmp23_->priv->_head;
		_tmp23_->priv->_head = NULL;
		position = _tmp24_;
		_tmp25_ = position;
		_tmp26_ = n;
		_tmp25_->prev = _tmp26_;
		_tmp27_ = n;
		_tmp28_ = position;
		position = NULL;
		_gee_linked_list_node_free0 (_tmp27_->next);
		_tmp27_->next = _tmp28_;
		_tmp29_ = self->priv->_list;
		_tmp30_ = n;
		n = NULL;
		_gee_linked_list_node_free0 (_tmp29_->priv->_head);
		_tmp29_->priv->_head = _tmp30_;
		_gee_linked_list_node_free0 (position);
	}
	_tmp31_ = self->priv->_list;
	_tmp32_ = _tmp31_->priv->_size;
	_tmp31_->priv->_size = _tmp32_ + 1;
	_tmp33_ = self->priv->_index;
	self->priv->_index = _tmp33_ + 1;
	_tmp34_ = self->priv->_list;
	_tmp35_ = _tmp34_->priv->_stamp;
	self->priv->_stamp = _tmp35_;
	_gee_linked_list_node_free0 (n);
}


static void gee_linked_list_iterator_real_add (GeeListIterator* base, gconstpointer item) {
	GeeLinkedListIterator * self;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeLinkedListNode* _tmp3_ = NULL;
	GeeLinkedListNode* n = NULL;
	gconstpointer _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GeeLinkedListNode* _tmp6_ = NULL;
	GeeLinkedListNode* _tmp7_ = NULL;
	GeeLinkedListNode* _tmp8_ = NULL;
	GeeLinkedListNode* _tmp17_ = NULL;
	GeeLinkedListNode* _tmp18_ = NULL;
	GeeLinkedListNode* _tmp19_ = NULL;
	GeeLinkedListNode* _tmp20_ = NULL;
	GeeLinkedListNode* _tmp21_ = NULL;
	GeeLinkedListNode* _tmp22_ = NULL;
	GeeLinkedListNode* _tmp23_ = NULL;
	GeeLinkedList* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	GeeLinkedList* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->position;
	_vala_assert (_tmp3_ != NULL, "this.position != null");
	_tmp4_ = item;
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
	_tmp6_ = gee_linked_list_node_new (_tmp5_);
	n = _tmp6_;
	_tmp7_ = self->priv->position;
	_tmp8_ = _tmp7_->next;
	if (_tmp8_ != NULL) {
		GeeLinkedListNode* _tmp9_ = NULL;
		GeeLinkedListNode* _tmp10_ = NULL;
		GeeLinkedListNode* _tmp11_ = NULL;
		GeeLinkedListNode* _tmp12_ = NULL;
		GeeLinkedListNode* _tmp13_ = NULL;
		GeeLinkedListNode* _tmp14_ = NULL;
		_tmp9_ = self->priv->position;
		_tmp10_ = _tmp9_->next;
		_tmp11_ = n;
		_tmp10_->prev = _tmp11_;
		_tmp12_ = n;
		_tmp13_ = self->priv->position;
		_tmp14_ = _tmp13_->next;
		_tmp13_->next = NULL;
		_gee_linked_list_node_free0 (_tmp12_->next);
		_tmp12_->next = _tmp14_;
	} else {
		GeeLinkedList* _tmp15_ = NULL;
		GeeLinkedListNode* _tmp16_ = NULL;
		_tmp15_ = self->priv->_list;
		_tmp16_ = n;
		_tmp15_->priv->_tail = _tmp16_;
	}
	_tmp17_ = self->priv->position;
	_tmp18_ = n;
	n = NULL;
	_gee_linked_list_node_free0 (_tmp17_->next);
	_tmp17_->next = _tmp18_;
	_tmp19_ = self->priv->position;
	_tmp20_ = _tmp19_->next;
	_tmp21_ = self->priv->position;
	_tmp20_->prev = _tmp21_;
	_tmp22_ = self->priv->position;
	_tmp23_ = _tmp22_->next;
	self->priv->position = _tmp23_;
	_tmp24_ = self->priv->_list;
	_tmp25_ = _tmp24_->priv->_size;
	_tmp24_->priv->_size = _tmp25_ + 1;
	_tmp26_ = self->priv->_index;
	self->priv->_index = _tmp26_ + 1;
	_tmp27_ = self->priv->_list;
	_tmp28_ = _tmp27_->priv->_stamp;
	self->priv->_stamp = _tmp28_;
	_gee_linked_list_node_free0 (n);
}


static gint gee_linked_list_iterator_real_index (GeeListIterator* base) {
	GeeLinkedListIterator * self;
	gint result = 0;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeLinkedListNode* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
	_tmp3_ = self->priv->position;
	_vala_assert (_tmp3_ != NULL, "this.position != null");
	_tmp4_ = self->priv->_index;
	result = _tmp4_;
	return result;
}


static gboolean gee_linked_list_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GeeLinkedList* _tmp15_ = NULL;
	GeeLinkedListNode* _tmp16_ = NULL;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->started;
	if (!_tmp3_) {
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedListNode* _tmp5_ = NULL;
		GeeLinkedListNode* _tmp6_ = NULL;
		_tmp4_ = self->priv->_list;
		_tmp5_ = _tmp4_->priv->_head;
		self->priv->position = _tmp5_;
		_tmp6_ = self->priv->position;
		if (_tmp6_ != NULL) {
			self->priv->started = TRUE;
		}
	}
	self->priv->removed = FALSE;
	while (TRUE) {
		GeeLinkedListNode* _tmp7_ = NULL;
		GeeForallFunc _tmp8_ = NULL;
		void* _tmp8__target = NULL;
		GeeLinkedListNode* _tmp9_ = NULL;
		gconstpointer _tmp10_ = NULL;
		gpointer _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GeeLinkedListNode* _tmp13_ = NULL;
		GeeLinkedListNode* _tmp14_ = NULL;
		_tmp7_ = self->priv->position;
		if (!(_tmp7_ != NULL)) {
			break;
		}
		_tmp8_ = f;
		_tmp8__target = f_target;
		_tmp9_ = self->priv->position;
		_tmp10_ = _tmp9_->data;
		_tmp11_ = ((_tmp10_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp10_) : ((gpointer) _tmp10_);
		_tmp12_ = _tmp8_ (_tmp11_, _tmp8__target);
		if (!_tmp12_) {
			result = FALSE;
			return result;
		}
		_tmp13_ = self->priv->position;
		_tmp14_ = _tmp13_->next;
		self->priv->position = _tmp14_;
	}
	_tmp15_ = self->priv->_list;
	_tmp16_ = _tmp15_->priv->_tail;
	self->priv->position = _tmp16_;
	result = TRUE;
	return result;
}


static gboolean gee_linked_list_iterator_real_get_read_only (GeeIterator* base) {
	gboolean result;
	GeeLinkedListIterator* self;
	self = (GeeLinkedListIterator*) base;
	result = FALSE;
	return result;
}


static gboolean gee_linked_list_iterator_real_get_valid (GeeIterator* base) {
	gboolean result;
	GeeLinkedListIterator* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = (GeeLinkedListIterator*) base;
	_tmp1_ = self->priv->removed;
	if (!_tmp1_) {
		GeeLinkedListNode* _tmp2_ = NULL;
		_tmp2_ = self->priv->position;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


static void gee_linked_list_iterator_class_init (GeeLinkedListIteratorClass * klass) {
	gee_linked_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeLinkedListIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_linked_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_linked_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static GType gee_linked_list_iterator_gee_traversable_get_g_type (GeeLinkedListIterator* self) {
	return self->priv->g_type;
}


static GBoxedCopyFunc gee_linked_list_iterator_gee_traversable_get_g_dup_func (GeeLinkedListIterator* self) {
	return self->priv->g_dup_func;
}


static GDestroyNotify gee_linked_list_iterator_gee_traversable_get_g_destroy_func (GeeLinkedListIterator* self) {
	return self->priv->g_destroy_func;
}


static void gee_linked_list_iterator_gee_traversable_interface_init (GeeTraversableIface * iface) {
	gee_linked_list_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) gee_linked_list_iterator_real_foreach;
	iface->get_g_type = (GType(*)(GeeTraversable*)) gee_linked_list_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) gee_linked_list_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) gee_linked_list_iterator_gee_traversable_get_g_destroy_func;
}


static void gee_linked_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_linked_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeIterator*)) gee_linked_list_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_linked_list_iterator_real_has_next;
	iface->get = (gpointer (*)(GeeIterator*)) gee_linked_list_iterator_real_get;
	iface->remove = (void (*)(GeeIterator*)) gee_linked_list_iterator_real_remove;
	iface->get_read_only = gee_linked_list_iterator_real_get_read_only;
	iface->get_valid = gee_linked_list_iterator_real_get_valid;
}


static GType gee_linked_list_iterator_gee_bidir_iterator_get_g_type (GeeLinkedListIterator* self) {
	return self->priv->g_type;
}


static GBoxedCopyFunc gee_linked_list_iterator_gee_bidir_iterator_get_g_dup_func (GeeLinkedListIterator* self) {
	return self->priv->g_dup_func;
}


static GDestroyNotify gee_linked_list_iterator_gee_bidir_iterator_get_g_destroy_func (GeeLinkedListIterator* self) {
	return self->priv->g_destroy_func;
}


static void gee_linked_list_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_linked_list_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->first = (gboolean (*)(GeeBidirIterator*)) gee_linked_list_iterator_real_first;
	iface->previous = (gboolean (*)(GeeBidirIterator*)) gee_linked_list_iterator_real_previous;
	iface->has_previous = (gboolean (*)(GeeBidirIterator*)) gee_linked_list_iterator_real_has_previous;
	iface->last = (gboolean (*)(GeeBidirIterator*)) gee_linked_list_iterator_real_last;
	iface->get_g_type = (GType(*)(GeeBidirIterator*)) gee_linked_list_iterator_gee_bidir_iterator_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeBidirIterator*)) gee_linked_list_iterator_gee_bidir_iterator_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeBidirIterator*)) gee_linked_list_iterator_gee_bidir_iterator_get_g_destroy_func;
}


static void gee_linked_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface) {
	gee_linked_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->set = (void (*)(GeeListIterator*, gconstpointer)) gee_linked_list_iterator_real_set;
	iface->add = (void (*)(GeeListIterator*, gconstpointer)) gee_linked_list_iterator_real_add;
	iface->index = (gint (*)(GeeListIterator*)) gee_linked_list_iterator_real_index;
}


static GType gee_linked_list_iterator_gee_bidir_list_iterator_get_g_type (GeeLinkedListIterator* self) {
	return self->priv->g_type;
}


static GBoxedCopyFunc gee_linked_list_iterator_gee_bidir_list_iterator_get_g_dup_func (GeeLinkedListIterator* self) {
	return self->priv->g_dup_func;
}


static GDestroyNotify gee_linked_list_iterator_gee_bidir_list_iterator_get_g_destroy_func (GeeLinkedListIterator* self) {
	return self->priv->g_destroy_func;
}


static void gee_linked_list_iterator_gee_bidir_list_iterator_interface_init (GeeBidirListIteratorIface * iface) {
	gee_linked_list_iterator_gee_bidir_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->insert = (void (*)(GeeBidirListIterator*, gconstpointer)) gee_linked_list_iterator_real_insert;
	iface->get_g_type = (GType(*)(GeeBidirListIterator*)) gee_linked_list_iterator_gee_bidir_list_iterator_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeBidirListIterator*)) gee_linked_list_iterator_gee_bidir_list_iterator_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeBidirListIterator*)) gee_linked_list_iterator_gee_bidir_list_iterator_get_g_destroy_func;
}


static void gee_linked_list_iterator_instance_init (GeeLinkedListIterator * self) {
	self->priv = GEE_LINKED_LIST_ITERATOR_GET_PRIVATE (self);
	self->priv->started = FALSE;
	self->priv->removed = FALSE;
}


static void gee_linked_list_iterator_finalize (GObject* obj) {
	GeeLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (gee_linked_list_iterator_parent_class)->finalize (obj);
}


static GType gee_linked_list_iterator_get_type (void) {
	static volatile gsize gee_linked_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedListIterator), 0, (GInstanceInitFunc) gee_linked_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_list_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_bidir_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_iterator_type_id;
		gee_linked_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeLinkedListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_BIDIR_LIST_ITERATOR, &gee_bidir_list_iterator_info);
		g_once_init_leave (&gee_linked_list_iterator_type_id__volatile, gee_linked_list_iterator_type_id);
	}
	return gee_linked_list_iterator_type_id__volatile;
}


static void _vala_gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator);
	switch (property_id) {
		case GEE_LINKED_LIST_ITERATOR_READ_ONLY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case GEE_LINKED_LIST_ITERATOR_VALID:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator);
	switch (property_id) {
		case GEE_LINKED_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_linked_list_class_init (GeeLinkedListClass * klass) {
	gee_linked_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeLinkedListPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->foreach = gee_linked_list_real_foreach;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_linked_list_real_iterator;
	GEE_ABSTRACT_LIST_CLASS (klass)->list_iterator = gee_linked_list_real_list_iterator;
	GEE_ABSTRACT_BIDIR_LIST_CLASS (klass)->bidir_list_iterator = gee_linked_list_real_bidir_list_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_linked_list_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_linked_list_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_linked_list_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_linked_list_real_clear;
	GEE_ABSTRACT_LIST_CLASS (klass)->get = gee_linked_list_real_get;
	GEE_ABSTRACT_LIST_CLASS (klass)->set = gee_linked_list_real_set;
	GEE_ABSTRACT_LIST_CLASS (klass)->index_of = gee_linked_list_real_index_of;
	GEE_ABSTRACT_LIST_CLASS (klass)->insert = gee_linked_list_real_insert;
	GEE_ABSTRACT_LIST_CLASS (klass)->remove_at = gee_linked_list_real_remove_at;
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = gee_linked_list_real_slice;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_linked_list_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_linked_list_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_linked_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_linked_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_CAPACITY, g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_REMAINING_CAPACITY, g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_IS_FULL, g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static GType gee_linked_list_gee_queue_get_g_type (GeeLinkedList* self) {
	return self->priv->g_type;
}


static GBoxedCopyFunc gee_linked_list_gee_queue_get_g_dup_func (GeeLinkedList* self) {
	return self->priv->g_dup_func;
}


static GDestroyNotify gee_linked_list_gee_queue_get_g_destroy_func (GeeLinkedList* self) {
	return self->priv->g_destroy_func;
}


static void gee_linked_list_gee_queue_interface_init (GeeQueueIface * iface) {
	gee_linked_list_gee_queue_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer = (gboolean (*)(GeeQueue*, gconstpointer)) gee_linked_list_real_offer;
	iface->peek = (gpointer (*)(GeeQueue*)) gee_linked_list_real_peek;
	iface->poll = (gpointer (*)(GeeQueue*)) gee_linked_list_real_poll;
	iface->drain = (gint (*)(GeeQueue*, GeeCollection*, gint)) gee_linked_list_real_drain;
	iface->get_g_type = (GType(*)(GeeQueue*)) gee_linked_list_gee_queue_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeQueue*)) gee_linked_list_gee_queue_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeQueue*)) gee_linked_list_gee_queue_get_g_destroy_func;
	iface->get_capacity = gee_linked_list_real_get_capacity;
	iface->get_remaining_capacity = gee_linked_list_real_get_remaining_capacity;
	iface->get_is_full = gee_linked_list_real_get_is_full;
}


static GType gee_linked_list_gee_deque_get_g_type (GeeLinkedList* self) {
	return self->priv->g_type;
}


static GBoxedCopyFunc gee_linked_list_gee_deque_get_g_dup_func (GeeLinkedList* self) {
	return self->priv->g_dup_func;
}


static GDestroyNotify gee_linked_list_gee_deque_get_g_destroy_func (GeeLinkedList* self) {
	return self->priv->g_destroy_func;
}


static void gee_linked_list_gee_deque_interface_init (GeeDequeIface * iface) {
	gee_linked_list_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer_head = (gboolean (*)(GeeDeque*, gconstpointer)) gee_linked_list_real_offer_head;
	iface->peek_head = (gpointer (*)(GeeDeque*)) gee_linked_list_real_peek_head;
	iface->poll_head = (gpointer (*)(GeeDeque*)) gee_linked_list_real_poll_head;
	iface->drain_head = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_linked_list_real_drain_head;
	iface->offer_tail = (gboolean (*)(GeeDeque*, gconstpointer)) gee_linked_list_real_offer_tail;
	iface->peek_tail = (gpointer (*)(GeeDeque*)) gee_linked_list_real_peek_tail;
	iface->poll_tail = (gpointer (*)(GeeDeque*)) gee_linked_list_real_poll_tail;
	iface->drain_tail = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_linked_list_real_drain_tail;
	iface->get_g_type = (GType(*)(GeeDeque*)) gee_linked_list_gee_deque_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeDeque*)) gee_linked_list_gee_deque_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeDeque*)) gee_linked_list_gee_deque_get_g_destroy_func;
}


static void gee_linked_list_instance_init (GeeLinkedList * self) {
	self->priv = GEE_LINKED_LIST_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->_stamp = 0;
	self->priv->_head = NULL;
	self->priv->_tail = NULL;
}


static void gee_linked_list_finalize (GObject* obj) {
	GeeLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_LINKED_LIST, GeeLinkedList);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
	_gee_linked_list_node_free0 (self->priv->_head);
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
	self->priv->_equal_func = NULL;
	self->priv->_equal_func_target = NULL;
	self->priv->_equal_func_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gee_linked_list_parent_class)->finalize (obj);
}


/**
 * Doubly-linked list implementation of the {@link List} interface.
 *
 * This implementation is pretty well designed for highly mutable data. When
 * indexed access is privileged prefer using {@link ArrayList}.
 *
 * @see ArrayList
 */
GType gee_linked_list_get_type (void) {
	static volatile gsize gee_linked_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedList), 0, (GInstanceInitFunc) gee_linked_list_instance_init, NULL };
		static const GInterfaceInfo gee_queue_info = { (GInterfaceInitFunc) gee_linked_list_gee_queue_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_linked_list_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_type_id;
		gee_linked_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_BIDIR_LIST, "GeeLinkedList", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_QUEUE, &gee_queue_info);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
		g_once_init_leave (&gee_linked_list_type_id__volatile, gee_linked_list_type_id);
	}
	return gee_linked_list_type_id__volatile;
}


static void _vala_gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_LINKED_LIST, GeeLinkedList);
	switch (property_id) {
		case GEE_LINKED_LIST_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_LINKED_LIST_READ_ONLY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GEE_LINKED_LIST_CAPACITY:
		g_value_set_int (value, gee_queue_get_capacity ((GeeQueue*) self));
		break;
		case GEE_LINKED_LIST_REMAINING_CAPACITY:
		g_value_set_int (value, gee_queue_get_remaining_capacity ((GeeQueue*) self));
		break;
		case GEE_LINKED_LIST_IS_FULL:
		g_value_set_boolean (value, gee_queue_get_is_full ((GeeQueue*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_LINKED_LIST, GeeLinkedList);
	switch (property_id) {
		case GEE_LINKED_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



