/* testlist.c generated by valac 0.21.1.7-1351, the Vala compiler
 * generated from testlist.vala, do not modify */

/* testlist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_LIST_TESTS (list_tests_get_type ())
#define LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_TESTS, ListTests))
#define LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_TESTS, ListTestsClass))
#define IS_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_TESTS))
#define IS_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_TESTS))
#define LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_TESTS, ListTestsClass))

typedef struct _ListTests ListTests;
typedef struct _ListTestsClass ListTestsClass;
typedef struct _ListTestsPrivate ListTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _ListTests {
	CollectionTests parent_instance;
	ListTestsPrivate * priv;
};

struct _ListTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_retained) (ListTests* self);
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer list_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType list_tests_get_type (void) G_GNUC_CONST;
enum  {
	LIST_TESTS_DUMMY_PROPERTY
};
ListTests* list_tests_construct (GType object_type, const gchar* name);
CollectionTests* collection_tests_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target, GDestroyNotify test_target_destroy_notify);
void list_tests_test_iterator_is_ordered (ListTests* self);
static void _list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self);
void list_tests_test_list_iterator (ListTests* self);
static void _list_tests_test_list_iterator_gee_test_case_test_method (gpointer self);
void list_tests_test_duplicates_are_retained (ListTests* self);
static void _list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self);
void list_tests_test_get (ListTests* self);
static void _list_tests_test_get_gee_test_case_test_method (gpointer self);
void list_tests_test_set (ListTests* self);
static void _list_tests_test_set_gee_test_case_test_method (gpointer self);
void list_tests_test_insert (ListTests* self);
static void _list_tests_test_insert_gee_test_case_test_method (gpointer self);
void list_tests_test_remove_at (ListTests* self);
static void _list_tests_test_remove_at_gee_test_case_test_method (gpointer self);
void list_tests_test_index_of (ListTests* self);
static void _list_tests_test_index_of_gee_test_case_test_method (gpointer self);
void list_tests_test_first (ListTests* self);
static void _list_tests_test_first_gee_test_case_test_method (gpointer self);
void list_tests_test_last (ListTests* self);
static void _list_tests_test_last_gee_test_case_test_method (gpointer self);
void list_tests_test_insert_all (ListTests* self);
static void _list_tests_test_insert_all_gee_test_case_test_method (gpointer self);
void list_tests_test_slice (ListTests* self);
static void _list_tests_test_slice_gee_test_case_test_method (gpointer self);
static void list_tests_real_test_duplicates_are_retained (ListTests* self);


static void _list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self) {
	list_tests_test_iterator_is_ordered (self);
}


static void _list_tests_test_list_iterator_gee_test_case_test_method (gpointer self) {
	list_tests_test_list_iterator (self);
}


static void _list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self) {
	list_tests_test_duplicates_are_retained (self);
}


static void _list_tests_test_get_gee_test_case_test_method (gpointer self) {
	list_tests_test_get (self);
}


static void _list_tests_test_set_gee_test_case_test_method (gpointer self) {
	list_tests_test_set (self);
}


static void _list_tests_test_insert_gee_test_case_test_method (gpointer self) {
	list_tests_test_insert (self);
}


static void _list_tests_test_remove_at_gee_test_case_test_method (gpointer self) {
	list_tests_test_remove_at (self);
}


static void _list_tests_test_index_of_gee_test_case_test_method (gpointer self) {
	list_tests_test_index_of (self);
}


static void _list_tests_test_first_gee_test_case_test_method (gpointer self) {
	list_tests_test_first (self);
}


static void _list_tests_test_last_gee_test_case_test_method (gpointer self) {
	list_tests_test_last (self);
}


static void _list_tests_test_insert_all_gee_test_case_test_method (gpointer self) {
	list_tests_test_insert_all (self);
}


static void _list_tests_test_slice_gee_test_case_test_method (gpointer self) {
	list_tests_test_slice (self);
}


ListTests* list_tests_construct (GType object_type, const gchar* name) {
	ListTests * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	self = (ListTests*) collection_tests_construct (object_type, _tmp0_);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] iterator is ordered", _list_tests_test_iterator_is_ordered_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] list iterator", _list_tests_test_list_iterator_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] duplicates are retained", _list_tests_test_duplicates_are_retained_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] get", _list_tests_test_get_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] set", _list_tests_test_set_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert", _list_tests_test_insert_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] remove_at", _list_tests_test_remove_at_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] index_of", _list_tests_test_index_of_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] first", _list_tests_test_first_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] last", _list_tests_test_last_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert_all", _list_tests_test_insert_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] slice", _list_tests_test_slice_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void list_tests_test_iterator_is_ordered (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeIterator* iterator = NULL;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GeeIterator* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GeeIterator* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GeeIterator* _tmp17_ = NULL;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GeeIterator* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GeeIterator* _tmp22_ = NULL;
	gpointer _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GeeIterator* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GeeIterator* _tmp27_ = NULL;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GeeIterator* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_vala_assert (test_list != NULL, "test_list != null");
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) test_list);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_tmp4_ = gee_iterator_next (_tmp3_);
	_vala_assert (!_tmp4_, "! iterator.next ()");
	_tmp5_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp5_, "test_list.add (\"one\")");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_list, "two");
	_vala_assert (_tmp6_, "test_list.add (\"two\")");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_list, "three");
	_vala_assert (_tmp7_, "test_list.add (\"three\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp8_, "test_list.add (\"one\")");
	_tmp9_ = gee_iterable_iterator ((GeeIterable*) test_list);
	_g_object_unref0 (iterator);
	iterator = _tmp9_;
	_tmp10_ = iterator;
	_tmp11_ = gee_iterator_next (_tmp10_);
	_vala_assert (_tmp11_, "iterator.next()");
	_tmp12_ = iterator;
	_tmp13_ = gee_iterator_get (_tmp12_);
	_tmp14_ = (gchar*) _tmp13_;
	_vala_assert (g_strcmp0 (_tmp14_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp14_);
	_tmp15_ = iterator;
	_tmp16_ = gee_iterator_next (_tmp15_);
	_vala_assert (_tmp16_, "iterator.next()");
	_tmp17_ = iterator;
	_tmp18_ = gee_iterator_get (_tmp17_);
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "two") == 0, "iterator.get () == \"two\"");
	_g_free0 (_tmp19_);
	_tmp20_ = iterator;
	_tmp21_ = gee_iterator_next (_tmp20_);
	_vala_assert (_tmp21_, "iterator.next()");
	_tmp22_ = iterator;
	_tmp23_ = gee_iterator_get (_tmp22_);
	_tmp24_ = (gchar*) _tmp23_;
	_vala_assert (g_strcmp0 (_tmp24_, "three") == 0, "iterator.get () == \"three\"");
	_g_free0 (_tmp24_);
	_tmp25_ = iterator;
	_tmp26_ = gee_iterator_next (_tmp25_);
	_vala_assert (_tmp26_, "iterator.next()");
	_tmp27_ = iterator;
	_tmp28_ = gee_iterator_get (_tmp27_);
	_tmp29_ = (gchar*) _tmp28_;
	_vala_assert (g_strcmp0 (_tmp29_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp29_);
	_tmp30_ = iterator;
	_tmp31_ = gee_iterator_next (_tmp30_);
	_vala_assert (!_tmp31_, "! iterator.next ()");
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}


void list_tests_test_list_iterator (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeListIterator* iterator = NULL;
	GeeListIterator* _tmp2_ = NULL;
	GeeListIterator* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeListIterator* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GeeListIterator* _tmp10_ = NULL;
	GeeListIterator* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GeeListIterator* _tmp13_ = NULL;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GeeListIterator* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GeeListIterator* _tmp18_ = NULL;
	GeeListIterator* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GeeListIterator* _tmp21_ = NULL;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GeeListIterator* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GeeListIterator* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GeeListIterator* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	GeeListIterator* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	GeeListIterator* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	GeeListIterator* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	GeeListIterator* _tmp38_ = NULL;
	gpointer _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	GeeListIterator* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	GeeListIterator* _tmp43_ = NULL;
	GeeListIterator* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	GeeListIterator* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	GeeListIterator* _tmp48_ = NULL;
	GeeListIterator* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	GeeListIterator* _tmp51_ = NULL;
	gpointer _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	GeeListIterator* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_vala_assert (test_list != NULL, "test_list != null");
	_tmp2_ = gee_list_list_iterator (test_list);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_tmp4_ = gee_iterator_has_next ((GeeIterator*) _tmp3_);
	_vala_assert (!_tmp4_, "! iterator.has_next ()");
	_tmp5_ = iterator;
	_tmp6_ = gee_iterator_next ((GeeIterator*) _tmp5_);
	_vala_assert (!_tmp6_, "! iterator.next ()");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp7_, "test_list.add (\"one\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_list, "two");
	_vala_assert (_tmp8_, "test_list.add (\"two\")");
	_tmp9_ = gee_collection_add ((GeeCollection*) test_list, "three");
	_vala_assert (_tmp9_, "test_list.add (\"three\")");
	_tmp10_ = gee_list_list_iterator (test_list);
	_g_object_unref0 (iterator);
	iterator = _tmp10_;
	_tmp11_ = iterator;
	_tmp12_ = gee_iterator_next ((GeeIterator*) _tmp11_);
	_vala_assert (_tmp12_, "iterator.next()");
	_tmp13_ = iterator;
	_tmp14_ = gee_iterator_get ((GeeIterator*) _tmp13_);
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp15_);
	_tmp16_ = iterator;
	_tmp17_ = gee_list_iterator_index (_tmp16_);
	_vala_assert (_tmp17_ == 0, "iterator.index () == 0");
	_tmp18_ = iterator;
	gee_list_iterator_set (_tmp18_, "new one");
	_tmp19_ = iterator;
	_tmp20_ = gee_iterator_next ((GeeIterator*) _tmp19_);
	_vala_assert (_tmp20_, "iterator.next()");
	_tmp21_ = iterator;
	_tmp22_ = gee_iterator_get ((GeeIterator*) _tmp21_);
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "two") == 0, "iterator.get () == \"two\"");
	_g_free0 (_tmp23_);
	_tmp24_ = iterator;
	_tmp25_ = gee_list_iterator_index (_tmp24_);
	_vala_assert (_tmp25_ == 1, "iterator.index () == 1");
	_tmp26_ = iterator;
	gee_list_iterator_set (_tmp26_, "new two");
	_tmp27_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_ == 3, "test_list.size == 3");
	_tmp29_ = iterator;
	_tmp30_ = gee_list_iterator_index (_tmp29_);
	_vala_assert (_tmp30_ == 1, "iterator.index () == 1");
	_tmp31_ = iterator;
	gee_list_iterator_add (_tmp31_, "after two");
	_tmp32_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp33_ = _tmp32_;
	_vala_assert (_tmp33_ == 4, "test_list.size == 4");
	_tmp34_ = iterator;
	_tmp35_ = gee_list_iterator_index (_tmp34_);
	_vala_assert (_tmp35_ == 2, "iterator.index () == 2");
	_tmp36_ = iterator;
	_tmp37_ = gee_iterator_next ((GeeIterator*) _tmp36_);
	_vala_assert (_tmp37_, "iterator.next()");
	_tmp38_ = iterator;
	_tmp39_ = gee_iterator_get ((GeeIterator*) _tmp38_);
	_tmp40_ = (gchar*) _tmp39_;
	_vala_assert (g_strcmp0 (_tmp40_, "three") == 0, "iterator.get () == \"three\"");
	_g_free0 (_tmp40_);
	_tmp41_ = iterator;
	_tmp42_ = gee_list_iterator_index (_tmp41_);
	_vala_assert (_tmp42_ == 3, "iterator.index () == 3");
	_tmp43_ = iterator;
	gee_list_iterator_set (_tmp43_, "new three");
	_tmp44_ = iterator;
	_tmp45_ = gee_iterator_has_next ((GeeIterator*) _tmp44_);
	_vala_assert (!_tmp45_, "! iterator.has_next ()");
	_tmp46_ = iterator;
	_tmp47_ = gee_iterator_next ((GeeIterator*) _tmp46_);
	_vala_assert (!_tmp47_, "! iterator.next ()");
	_tmp48_ = gee_list_list_iterator (test_list);
	_g_object_unref0 (iterator);
	iterator = _tmp48_;
	_tmp49_ = iterator;
	_tmp50_ = gee_iterator_next ((GeeIterator*) _tmp49_);
	_vala_assert (_tmp50_, "iterator.next ()");
	_tmp51_ = iterator;
	_tmp52_ = gee_iterator_get ((GeeIterator*) _tmp51_);
	_tmp53_ = (gchar*) _tmp52_;
	_vala_assert (g_strcmp0 (_tmp53_, "new one") == 0, "iterator.get () == \"new one\"");
	_g_free0 (_tmp53_);
	_tmp54_ = iterator;
	_tmp55_ = gee_list_iterator_index (_tmp54_);
	_vala_assert (_tmp55_ == 0, "iterator.index () == 0");
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}


static void list_tests_real_test_duplicates_are_retained (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_vala_assert (test_list != NULL, "test_list != null");
	_tmp2_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp2_, "test_list.add (\"one\")");
	_tmp3_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp3_, "test_list.contains (\"one\")");
	_tmp4_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 1, "test_list.size == 1");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp6_, "test_list.add (\"one\")");
	_tmp7_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp7_, "test_list.contains (\"one\")");
	_tmp8_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 2, "test_list.size == 2");
	_tmp10_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp10_, "test_list.add (\"one\")");
	_tmp11_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp11_, "test_list.contains (\"one\")");
	_tmp12_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp13_ == 3, "test_list.size == 3");
	_tmp14_ = gee_collection_remove ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp14_, "test_list.remove (\"one\")");
	_tmp15_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp15_, "test_list.contains (\"one\")");
	_tmp16_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp17_ == 2, "test_list.size == 2");
	_tmp18_ = gee_collection_remove ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp18_, "test_list.remove (\"one\")");
	_tmp19_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp19_, "test_list.contains (\"one\")");
	_tmp20_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp21_ = _tmp20_;
	_vala_assert (_tmp21_ == 1, "test_list.size == 1");
	_tmp22_ = gee_collection_remove ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp22_, "test_list.remove (\"one\")");
	_tmp23_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (!_tmp23_, "!test_list.contains (\"one\")");
	_tmp24_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp25_ = _tmp24_;
	_vala_assert (_tmp25_ == 0, "test_list.size == 0");
	_g_object_unref0 (test_list);
}


void list_tests_test_duplicates_are_retained (ListTests* self) {
	g_return_if_fail (self != NULL);
	LIST_TESTS_GET_CLASS (self)->test_duplicates_are_retained (self);
}


void list_tests_test_get (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeList* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GeeList* _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GeeList* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GeeList* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GeeList* _tmp24_ = NULL;
	gpointer _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GeeList* _tmp27_ = NULL;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GeeList* _tmp30_ = NULL;
	gpointer _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GeeList* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = test_list;
		_tmp5_ = gee_list_get (_tmp4_, 0);
		_tmp6_ = (gchar*) _tmp5_;
		_g_free0 (_tmp6_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp7_ = test_list;
	_tmp8_ = gee_collection_add ((GeeCollection*) _tmp7_, "one");
	_vala_assert (_tmp8_, "test_list.add (\"one\")");
	_tmp9_ = test_list;
	_tmp10_ = gee_list_get (_tmp9_, 0);
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "one") == 0, "test_list.get (0) == \"one\"");
	_g_free0 (_tmp11_);
	_tmp12_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp12_) {
		GeeList* _tmp13_ = NULL;
		gpointer _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp13_ = test_list;
		_tmp14_ = gee_list_get (_tmp13_, 1);
		_tmp15_ = (gchar*) _tmp14_;
		_g_free0 (_tmp15_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp16_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp16_) {
		GeeList* _tmp17_ = NULL;
		gpointer _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp17_ = test_list;
		_tmp18_ = gee_list_get (_tmp17_, -1);
		_tmp19_ = (gchar*) _tmp18_;
		_g_free0 (_tmp19_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp20_ = test_list;
	_tmp21_ = gee_collection_add ((GeeCollection*) _tmp20_, "two");
	_vala_assert (_tmp21_, "test_list.add (\"two\")");
	_tmp22_ = test_list;
	_tmp23_ = gee_collection_add ((GeeCollection*) _tmp22_, "three");
	_vala_assert (_tmp23_, "test_list.add (\"three\")");
	_tmp24_ = test_list;
	_tmp25_ = gee_list_get (_tmp24_, 0);
	_tmp26_ = (gchar*) _tmp25_;
	_vala_assert (g_strcmp0 (_tmp26_, "one") == 0, "test_list.get (0) == \"one\"");
	_g_free0 (_tmp26_);
	_tmp27_ = test_list;
	_tmp28_ = gee_list_get (_tmp27_, 1);
	_tmp29_ = (gchar*) _tmp28_;
	_vala_assert (g_strcmp0 (_tmp29_, "two") == 0, "test_list.get (1) == \"two\"");
	_g_free0 (_tmp29_);
	_tmp30_ = test_list;
	_tmp31_ = gee_list_get (_tmp30_, 2);
	_tmp32_ = (gchar*) _tmp31_;
	_vala_assert (g_strcmp0 (_tmp32_, "three") == 0, "test_list.get (2) == \"three\"");
	_g_free0 (_tmp32_);
	_tmp33_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp33_);
	_tmp34_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp34_) {
		GeeList* _tmp35_ = NULL;
		gpointer _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		_tmp35_ = test_list;
		_tmp36_ = gee_list_get (_tmp35_, 0);
		_tmp37_ = (gchar*) _tmp36_;
		_g_free0 (_tmp37_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_set (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	GeeList* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GeeList* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GeeList* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GeeList* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GeeList* _tmp19_ = NULL;
	GeeList* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GeeList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	GeeList* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gboolean _tmp29_ = FALSE;
	GeeList* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = test_list;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 0, "test_list.size == 0");
	_tmp6_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp6_) {
		GeeList* _tmp7_ = NULL;
		_tmp7_ = test_list;
		gee_list_set (_tmp7_, 0, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp8_ = test_list;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_assert (_tmp10_ == 0, "test_list.size == 0");
	_tmp11_ = test_list;
	_tmp12_ = gee_collection_add ((GeeCollection*) _tmp11_, "one");
	_vala_assert (_tmp12_, "test_list.add (\"one\")");
	_tmp13_ = test_list;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_ == 1, "test_list.size == 1");
	_tmp16_ = test_list;
	_tmp17_ = gee_list_get (_tmp16_, 0);
	_tmp18_ = (gchar*) _tmp17_;
	_vala_assert (g_strcmp0 (_tmp18_, "one") == 0, "test_list.get (0) == \"one\"");
	_g_free0 (_tmp18_);
	_tmp19_ = test_list;
	gee_list_set (_tmp19_, 0, "two");
	_tmp20_ = test_list;
	_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	_vala_assert (_tmp22_ == 1, "test_list.size == 1");
	_tmp23_ = test_list;
	_tmp24_ = gee_list_get (_tmp23_, 0);
	_tmp25_ = (gchar*) _tmp24_;
	_vala_assert (g_strcmp0 (_tmp25_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp25_);
	_tmp26_ = test_list;
	_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_ == 1, "test_list.size == 1");
	_tmp29_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp29_) {
		GeeList* _tmp30_ = NULL;
		_tmp30_ = test_list;
		gee_list_set (_tmp30_, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp31_ = test_list;
	_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	_vala_assert (_tmp33_ == 1, "test_list.size == 1");
	_g_object_unref0 (test_list);
}


void list_tests_test_insert (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GeeList* _tmp8_ = NULL;
	GeeList* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GeeList* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GeeList* _tmp15_ = NULL;
	GeeList* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GeeList* _tmp19_ = NULL;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GeeList* _tmp22_ = NULL;
	GeeList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	GeeList* _tmp26_ = NULL;
	gpointer _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	GeeList* _tmp29_ = NULL;
	gpointer _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	GeeList* _tmp34_ = NULL;
	GeeList* _tmp35_ = NULL;
	gpointer _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	GeeList* _tmp38_ = NULL;
	gpointer _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	GeeList* _tmp41_ = NULL;
	gpointer _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	GeeList* _tmp44_ = NULL;
	gpointer _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_ = NULL;
		_tmp4_ = test_list;
		gee_list_insert (_tmp4_, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = test_list;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_ == 0, "test_list.size == 0");
	_tmp8_ = test_list;
	gee_list_insert (_tmp8_, 0, "one");
	_tmp9_ = test_list;
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp11_ == 1, "test_list.size == 1");
	_tmp12_ = test_list;
	_tmp13_ = gee_list_get (_tmp12_, 0);
	_tmp14_ = (gchar*) _tmp13_;
	_vala_assert (g_strcmp0 (_tmp14_, "one") == 0, "test_list.get (0) == \"one\"");
	_g_free0 (_tmp14_);
	_tmp15_ = test_list;
	gee_list_insert (_tmp15_, 0, "two");
	_tmp16_ = test_list;
	_tmp17_ = gee_list_get (_tmp16_, 0);
	_tmp18_ = (gchar*) _tmp17_;
	_vala_assert (g_strcmp0 (_tmp18_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp18_);
	_tmp19_ = test_list;
	_tmp20_ = gee_list_get (_tmp19_, 1);
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp21_);
	_tmp22_ = test_list;
	gee_list_insert (_tmp22_, 1, "three");
	_tmp23_ = test_list;
	_tmp24_ = gee_list_get (_tmp23_, 0);
	_tmp25_ = (gchar*) _tmp24_;
	_vala_assert (g_strcmp0 (_tmp25_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp25_);
	_tmp26_ = test_list;
	_tmp27_ = gee_list_get (_tmp26_, 1);
	_tmp28_ = (gchar*) _tmp27_;
	_vala_assert (g_strcmp0 (_tmp28_, "three") == 0, "test_list.get (1) == \"three\"");
	_g_free0 (_tmp28_);
	_tmp29_ = test_list;
	_tmp30_ = gee_list_get (_tmp29_, 2);
	_tmp31_ = (gchar*) _tmp30_;
	_vala_assert (g_strcmp0 (_tmp31_, "one") == 0, "test_list.get (2) == \"one\"");
	_g_free0 (_tmp31_);
	_tmp32_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp32_) {
		GeeList* _tmp33_ = NULL;
		_tmp33_ = test_list;
		gee_list_insert (_tmp33_, 4, "four");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp34_ = test_list;
	gee_list_insert (_tmp34_, 3, "four");
	_tmp35_ = test_list;
	_tmp36_ = gee_list_get (_tmp35_, 0);
	_tmp37_ = (gchar*) _tmp36_;
	_vala_assert (g_strcmp0 (_tmp37_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp37_);
	_tmp38_ = test_list;
	_tmp39_ = gee_list_get (_tmp38_, 1);
	_tmp40_ = (gchar*) _tmp39_;
	_vala_assert (g_strcmp0 (_tmp40_, "three") == 0, "test_list.get (1) == \"three\"");
	_g_free0 (_tmp40_);
	_tmp41_ = test_list;
	_tmp42_ = gee_list_get (_tmp41_, 2);
	_tmp43_ = (gchar*) _tmp42_;
	_vala_assert (g_strcmp0 (_tmp43_, "one") == 0, "test_list.get (2) == \"one\"");
	_g_free0 (_tmp43_);
	_tmp44_ = test_list;
	_tmp45_ = gee_list_get (_tmp44_, 3);
	_tmp46_ = (gchar*) _tmp45_;
	_vala_assert (g_strcmp0 (_tmp46_, "four") == 0, "test_list.get (3) == \"four\"");
	_g_free0 (_tmp46_);
	_tmp47_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp47_) {
		GeeList* _tmp48_ = NULL;
		_tmp48_ = test_list;
		gee_list_insert (_tmp48_, -1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_remove_at (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GeeList* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GeeList* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GeeList* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GeeList* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GeeList* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GeeList* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GeeList* _tmp24_ = NULL;
	gpointer _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GeeList* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	GeeList* _tmp30_ = NULL;
	gpointer _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GeeList* _tmp33_ = NULL;
	gpointer _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GeeList* _tmp36_ = NULL;
	gpointer _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GeeList* _tmp39_ = NULL;
	gpointer _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	GeeList* _tmp42_ = NULL;
	gpointer _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	GeeList* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	GeeList* _tmp48_ = NULL;
	gpointer _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	GeeList* _tmp51_ = NULL;
	gpointer _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	GeeList* _tmp54_ = NULL;
	gpointer _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	GeeList* _tmp57_ = NULL;
	gpointer _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	GeeList* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	GeeList* _tmp63_ = NULL;
	gpointer _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	GeeList* _tmp66_ = NULL;
	gpointer _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp73_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = test_list;
		_tmp5_ = gee_list_remove_at (_tmp4_, 0);
		_tmp6_ = (gchar*) _tmp5_;
		_g_free0 (_tmp6_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp7_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp7_) {
		GeeList* _tmp8_ = NULL;
		gpointer _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = test_list;
		_tmp9_ = gee_list_remove_at (_tmp8_, 1);
		_tmp10_ = (gchar*) _tmp9_;
		_g_free0 (_tmp10_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp11_ = test_list;
	_tmp12_ = gee_collection_add ((GeeCollection*) _tmp11_, "one");
	_vala_assert (_tmp12_, "test_list.add (\"one\")");
	_tmp13_ = test_list;
	_tmp14_ = gee_collection_add ((GeeCollection*) _tmp13_, "two");
	_vala_assert (_tmp14_, "test_list.add (\"two\")");
	_tmp15_ = test_list;
	_tmp16_ = gee_collection_add ((GeeCollection*) _tmp15_, "three");
	_vala_assert (_tmp16_, "test_list.add (\"three\")");
	_tmp17_ = test_list;
	_tmp18_ = gee_collection_add ((GeeCollection*) _tmp17_, "four");
	_vala_assert (_tmp18_, "test_list.add (\"four\")");
	_tmp19_ = test_list;
	_tmp20_ = gee_collection_add ((GeeCollection*) _tmp19_, "five");
	_vala_assert (_tmp20_, "test_list.add (\"five\")");
	_tmp21_ = test_list;
	_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	_vala_assert (_tmp23_ == 5, "test_list.size == 5");
	_tmp24_ = test_list;
	_tmp25_ = gee_list_remove_at (_tmp24_, 0);
	_tmp26_ = (gchar*) _tmp25_;
	_vala_assert (g_strcmp0 (_tmp26_, "one") == 0, "test_list.remove_at (0) == \"one\"");
	_g_free0 (_tmp26_);
	_tmp27_ = test_list;
	_tmp28_ = gee_collection_get_size ((GeeCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_vala_assert (_tmp29_ == 4, "test_list.size == 4");
	_tmp30_ = test_list;
	_tmp31_ = gee_list_get (_tmp30_, 0);
	_tmp32_ = (gchar*) _tmp31_;
	_vala_assert (g_strcmp0 (_tmp32_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp32_);
	_tmp33_ = test_list;
	_tmp34_ = gee_list_get (_tmp33_, 1);
	_tmp35_ = (gchar*) _tmp34_;
	_vala_assert (g_strcmp0 (_tmp35_, "three") == 0, "test_list.get (1) == \"three\"");
	_g_free0 (_tmp35_);
	_tmp36_ = test_list;
	_tmp37_ = gee_list_get (_tmp36_, 2);
	_tmp38_ = (gchar*) _tmp37_;
	_vala_assert (g_strcmp0 (_tmp38_, "four") == 0, "test_list.get (2) == \"four\"");
	_g_free0 (_tmp38_);
	_tmp39_ = test_list;
	_tmp40_ = gee_list_get (_tmp39_, 3);
	_tmp41_ = (gchar*) _tmp40_;
	_vala_assert (g_strcmp0 (_tmp41_, "five") == 0, "test_list.get (3) == \"five\"");
	_g_free0 (_tmp41_);
	_tmp42_ = test_list;
	_tmp43_ = gee_list_remove_at (_tmp42_, 3);
	_tmp44_ = (gchar*) _tmp43_;
	_vala_assert (g_strcmp0 (_tmp44_, "five") == 0, "test_list.remove_at (3) == \"five\"");
	_g_free0 (_tmp44_);
	_tmp45_ = test_list;
	_tmp46_ = gee_collection_get_size ((GeeCollection*) _tmp45_);
	_tmp47_ = _tmp46_;
	_vala_assert (_tmp47_ == 3, "test_list.size == 3");
	_tmp48_ = test_list;
	_tmp49_ = gee_list_get (_tmp48_, 0);
	_tmp50_ = (gchar*) _tmp49_;
	_vala_assert (g_strcmp0 (_tmp50_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp50_);
	_tmp51_ = test_list;
	_tmp52_ = gee_list_get (_tmp51_, 1);
	_tmp53_ = (gchar*) _tmp52_;
	_vala_assert (g_strcmp0 (_tmp53_, "three") == 0, "test_list.get (1) == \"three\"");
	_g_free0 (_tmp53_);
	_tmp54_ = test_list;
	_tmp55_ = gee_list_get (_tmp54_, 2);
	_tmp56_ = (gchar*) _tmp55_;
	_vala_assert (g_strcmp0 (_tmp56_, "four") == 0, "test_list.get (2) == \"four\"");
	_g_free0 (_tmp56_);
	_tmp57_ = test_list;
	_tmp58_ = gee_list_remove_at (_tmp57_, 1);
	_tmp59_ = (gchar*) _tmp58_;
	_vala_assert (g_strcmp0 (_tmp59_, "three") == 0, "test_list.remove_at (1) == \"three\"");
	_g_free0 (_tmp59_);
	_tmp60_ = test_list;
	_tmp61_ = gee_collection_get_size ((GeeCollection*) _tmp60_);
	_tmp62_ = _tmp61_;
	_vala_assert (_tmp62_ == 2, "test_list.size == 2");
	_tmp63_ = test_list;
	_tmp64_ = gee_list_get (_tmp63_, 0);
	_tmp65_ = (gchar*) _tmp64_;
	_vala_assert (g_strcmp0 (_tmp65_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp65_);
	_tmp66_ = test_list;
	_tmp67_ = gee_list_get (_tmp66_, 1);
	_tmp68_ = (gchar*) _tmp67_;
	_vala_assert (g_strcmp0 (_tmp68_, "four") == 0, "test_list.get (1) == \"four\"");
	_g_free0 (_tmp68_);
	_tmp69_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp69_) {
		GeeList* _tmp70_ = NULL;
		gpointer _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		_tmp70_ = test_list;
		_tmp71_ = gee_list_remove_at (_tmp70_, 2);
		_tmp72_ = (gchar*) _tmp71_;
		_g_free0 (_tmp72_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp73_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp73_) {
		GeeList* _tmp74_ = NULL;
		gpointer _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		_tmp74_ = test_list;
		_tmp75_ = gee_list_remove_at (_tmp74_, -1);
		_tmp76_ = (gchar*) _tmp75_;
		_g_free0 (_tmp76_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_index_of (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_vala_assert (test_list != NULL, "test_list != null");
	_tmp2_ = gee_list_index_of (test_list, "one");
	_vala_assert (_tmp2_ == (-1), "test_list.index_of (\"one\") == -1");
	_tmp3_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp3_, "test_list.add (\"one\")");
	_tmp4_ = gee_list_index_of (test_list, "one");
	_vala_assert (_tmp4_ == 0, "test_list.index_of (\"one\") == 0");
	_tmp5_ = gee_list_index_of (test_list, "two");
	_vala_assert (_tmp5_ == (-1), "test_list.index_of (\"two\") == -1");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_list, "two");
	_vala_assert (_tmp6_, "test_list.add (\"two\")");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_list, "three");
	_vala_assert (_tmp7_, "test_list.add (\"three\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_list, "four");
	_vala_assert (_tmp8_, "test_list.add (\"four\")");
	_tmp9_ = gee_list_index_of (test_list, "one");
	_vala_assert (_tmp9_ == 0, "test_list.index_of (\"one\") == 0");
	_tmp10_ = gee_list_index_of (test_list, "two");
	_vala_assert (_tmp10_ == 1, "test_list.index_of (\"two\") == 1");
	_tmp11_ = gee_list_index_of (test_list, "three");
	_vala_assert (_tmp11_ == 2, "test_list.index_of (\"three\") == 2");
	_tmp12_ = gee_list_index_of (test_list, "four");
	_vala_assert (_tmp12_ == 3, "test_list.index_of (\"four\") == 3");
	_tmp13_ = gee_list_index_of (test_list, "five");
	_vala_assert (_tmp13_ == (-1), "test_list.index_of (\"five\") == -1");
	_g_object_unref0 (test_list);
}


void list_tests_test_first (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeList* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GeeList* _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GeeList* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GeeList* _tmp15_ = NULL;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GeeList* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GeeList* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GeeList* _tmp22_ = NULL;
	gpointer _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GeeList* _tmp25_ = NULL;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GeeList* _tmp28_ = NULL;
	gpointer _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	GeeList* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = test_list;
		_tmp5_ = gee_list_first (_tmp4_);
		_tmp6_ = (gchar*) _tmp5_;
		_g_free0 (_tmp6_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp7_ = test_list;
	_tmp8_ = gee_collection_add ((GeeCollection*) _tmp7_, "one");
	_vala_assert (_tmp8_, "test_list.add (\"one\")");
	_tmp9_ = test_list;
	_tmp10_ = gee_list_first (_tmp9_);
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "one") == 0, "test_list.first () == \"one\"");
	_g_free0 (_tmp11_);
	_tmp12_ = test_list;
	_tmp13_ = gee_list_first (_tmp12_);
	_tmp14_ = (gchar*) _tmp13_;
	_tmp15_ = test_list;
	_tmp16_ = gee_list_get (_tmp15_, 0);
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp14_, _tmp17_) == 0, "test_list.first () == test_list.get (0)");
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp18_ = test_list;
	_tmp19_ = gee_collection_add ((GeeCollection*) _tmp18_, "two");
	_vala_assert (_tmp19_, "test_list.add (\"two\")");
	_tmp20_ = test_list;
	_tmp21_ = gee_collection_add ((GeeCollection*) _tmp20_, "three");
	_vala_assert (_tmp21_, "test_list.add (\"three\")");
	_tmp22_ = test_list;
	_tmp23_ = gee_list_first (_tmp22_);
	_tmp24_ = (gchar*) _tmp23_;
	_vala_assert (g_strcmp0 (_tmp24_, "one") == 0, "test_list.first () == \"one\"");
	_g_free0 (_tmp24_);
	_tmp25_ = test_list;
	_tmp26_ = gee_list_first (_tmp25_);
	_tmp27_ = (gchar*) _tmp26_;
	_tmp28_ = test_list;
	_tmp29_ = gee_list_get (_tmp28_, 0);
	_tmp30_ = (gchar*) _tmp29_;
	_vala_assert (g_strcmp0 (_tmp27_, _tmp30_) == 0, "test_list.first () == test_list.get (0)");
	_g_free0 (_tmp30_);
	_g_free0 (_tmp27_);
	_tmp31_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp31_);
	_tmp32_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp32_) {
		GeeList* _tmp33_ = NULL;
		gpointer _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		_tmp33_ = test_list;
		_tmp34_ = gee_list_first (_tmp33_);
		_tmp35_ = (gchar*) _tmp34_;
		_g_free0 (_tmp35_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_last (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeList* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GeeList* _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GeeList* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GeeList* _tmp15_ = NULL;
	GeeList* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gpointer _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GeeList* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GeeList* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	GeeList* _tmp25_ = NULL;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GeeList* _tmp28_ = NULL;
	gpointer _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	GeeList* _tmp31_ = NULL;
	GeeList* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gpointer _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	GeeList* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = test_list;
		_tmp5_ = gee_list_last (_tmp4_);
		_tmp6_ = (gchar*) _tmp5_;
		_g_free0 (_tmp6_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp7_ = test_list;
	_tmp8_ = gee_collection_add ((GeeCollection*) _tmp7_, "one");
	_vala_assert (_tmp8_, "test_list.add (\"one\")");
	_tmp9_ = test_list;
	_tmp10_ = gee_list_last (_tmp9_);
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "one") == 0, "test_list.last () == \"one\"");
	_g_free0 (_tmp11_);
	_tmp12_ = test_list;
	_tmp13_ = gee_list_last (_tmp12_);
	_tmp14_ = (gchar*) _tmp13_;
	_tmp15_ = test_list;
	_tmp16_ = test_list;
	_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_list_get (_tmp15_, _tmp18_ - 1);
	_tmp20_ = (gchar*) _tmp19_;
	_vala_assert (g_strcmp0 (_tmp14_, _tmp20_) == 0, "test_list.last () == test_list.get (test_list.size - 1)");
	_g_free0 (_tmp20_);
	_g_free0 (_tmp14_);
	_tmp21_ = test_list;
	_tmp22_ = gee_collection_add ((GeeCollection*) _tmp21_, "two");
	_vala_assert (_tmp22_, "test_list.add (\"two\")");
	_tmp23_ = test_list;
	_tmp24_ = gee_collection_add ((GeeCollection*) _tmp23_, "three");
	_vala_assert (_tmp24_, "test_list.add (\"three\")");
	_tmp25_ = test_list;
	_tmp26_ = gee_list_last (_tmp25_);
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp27_, "three") == 0, "test_list.last () == \"three\"");
	_g_free0 (_tmp27_);
	_tmp28_ = test_list;
	_tmp29_ = gee_list_last (_tmp28_);
	_tmp30_ = (gchar*) _tmp29_;
	_tmp31_ = test_list;
	_tmp32_ = test_list;
	_tmp33_ = gee_collection_get_size ((GeeCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = gee_list_get (_tmp31_, _tmp34_ - 1);
	_tmp36_ = (gchar*) _tmp35_;
	_vala_assert (g_strcmp0 (_tmp30_, _tmp36_) == 0, "test_list.last () == test_list.get (test_list.size - 1)");
	_g_free0 (_tmp36_);
	_g_free0 (_tmp30_);
	_tmp37_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp37_);
	_tmp38_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp38_) {
		GeeList* _tmp39_ = NULL;
		gpointer _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		_tmp39_ = test_list;
		_tmp40_ = gee_list_last (_tmp39_);
		_tmp41_ = (gchar*) _tmp40_;
		_g_free0 (_tmp41_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_insert_all (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GeeList* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeList* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GeeList* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	GeeArrayList* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GeeList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	GeeList* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	GeeArrayList* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GeeList* _tmp24_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	GeeArrayList* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	GeeArrayList* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GeeArrayList* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	GeeList* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	GeeArrayList* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	GeeList* _tmp38_ = NULL;
	GeeArrayList* _tmp39_ = NULL;
	GeeList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	GeeArrayList* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	GeeList* _tmp46_ = NULL;
	GeeArrayList* _tmp47_ = NULL;
	GeeArrayList* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	GeeArrayList* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	GeeArrayList* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	GeeList* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	GeeList* _tmp60_ = NULL;
	GeeArrayList* _tmp61_ = NULL;
	GeeList* _tmp62_ = NULL;
	gboolean _tmp63_ = FALSE;
	GeeList* _tmp64_ = NULL;
	gboolean _tmp65_ = FALSE;
	GeeList* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	GeeArrayList* _tmp68_ = NULL;
	gboolean _tmp69_ = FALSE;
	GeeArrayList* _tmp70_ = NULL;
	gboolean _tmp71_ = FALSE;
	GeeArrayList* _tmp72_ = NULL;
	gboolean _tmp73_ = FALSE;
	GeeList* _tmp74_ = NULL;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	GeeArrayList* _tmp77_ = NULL;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	GeeList* _tmp80_ = NULL;
	GeeArrayList* _tmp81_ = NULL;
	GeeList* _tmp82_ = NULL;
	gint _tmp83_ = 0;
	gint _tmp84_ = 0;
	GeeArrayList* _tmp85_ = NULL;
	gint _tmp86_ = 0;
	gint _tmp87_ = 0;
	GeeList* _tmp88_ = NULL;
	gpointer _tmp89_ = NULL;
	gchar* _tmp90_ = NULL;
	GeeList* _tmp91_ = NULL;
	gpointer _tmp92_ = NULL;
	gchar* _tmp93_ = NULL;
	GeeList* _tmp94_ = NULL;
	gpointer _tmp95_ = NULL;
	gchar* _tmp96_ = NULL;
	GeeList* _tmp97_ = NULL;
	gpointer _tmp98_ = NULL;
	gchar* _tmp99_ = NULL;
	GeeList* _tmp100_ = NULL;
	gpointer _tmp101_ = NULL;
	gchar* _tmp102_ = NULL;
	GeeList* _tmp103_ = NULL;
	gpointer _tmp104_ = NULL;
	gchar* _tmp105_ = NULL;
	GeeList* _tmp106_ = NULL;
	GeeArrayList* _tmp107_ = NULL;
	GeeList* _tmp108_ = NULL;
	gboolean _tmp109_ = FALSE;
	GeeList* _tmp110_ = NULL;
	gboolean _tmp111_ = FALSE;
	GeeList* _tmp112_ = NULL;
	gboolean _tmp113_ = FALSE;
	GeeList* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	GeeArrayList* _tmp116_ = NULL;
	gboolean _tmp117_ = FALSE;
	GeeArrayList* _tmp118_ = NULL;
	gboolean _tmp119_ = FALSE;
	GeeArrayList* _tmp120_ = NULL;
	gboolean _tmp121_ = FALSE;
	GeeList* _tmp122_ = NULL;
	gint _tmp123_ = 0;
	gint _tmp124_ = 0;
	GeeArrayList* _tmp125_ = NULL;
	gint _tmp126_ = 0;
	gint _tmp127_ = 0;
	GeeList* _tmp128_ = NULL;
	GeeArrayList* _tmp129_ = NULL;
	GeeList* _tmp130_ = NULL;
	gint _tmp131_ = 0;
	gint _tmp132_ = 0;
	GeeArrayList* _tmp133_ = NULL;
	gint _tmp134_ = 0;
	gint _tmp135_ = 0;
	GeeList* _tmp136_ = NULL;
	gpointer _tmp137_ = NULL;
	gchar* _tmp138_ = NULL;
	GeeList* _tmp139_ = NULL;
	gpointer _tmp140_ = NULL;
	gchar* _tmp141_ = NULL;
	GeeList* _tmp142_ = NULL;
	gpointer _tmp143_ = NULL;
	gchar* _tmp144_ = NULL;
	GeeList* _tmp145_ = NULL;
	gpointer _tmp146_ = NULL;
	gchar* _tmp147_ = NULL;
	GeeList* _tmp148_ = NULL;
	gpointer _tmp149_ = NULL;
	gchar* _tmp150_ = NULL;
	GeeList* _tmp151_ = NULL;
	gpointer _tmp152_ = NULL;
	gchar* _tmp153_ = NULL;
	GeeList* _tmp154_ = NULL;
	gpointer _tmp155_ = NULL;
	gchar* _tmp156_ = NULL;
	GeeList* _tmp157_ = NULL;
	GeeArrayList* _tmp158_ = NULL;
	GeeList* _tmp159_ = NULL;
	gboolean _tmp160_ = FALSE;
	GeeList* _tmp161_ = NULL;
	gboolean _tmp162_ = FALSE;
	GeeList* _tmp163_ = NULL;
	gboolean _tmp164_ = FALSE;
	GeeArrayList* _tmp165_ = NULL;
	gboolean _tmp166_ = FALSE;
	GeeArrayList* _tmp167_ = NULL;
	gboolean _tmp168_ = FALSE;
	GeeArrayList* _tmp169_ = NULL;
	gboolean _tmp170_ = FALSE;
	GeeList* _tmp171_ = NULL;
	gint _tmp172_ = 0;
	gint _tmp173_ = 0;
	GeeArrayList* _tmp174_ = NULL;
	gint _tmp175_ = 0;
	gint _tmp176_ = 0;
	GeeList* _tmp177_ = NULL;
	GeeArrayList* _tmp178_ = NULL;
	GeeList* _tmp179_ = NULL;
	gint _tmp180_ = 0;
	gint _tmp181_ = 0;
	GeeArrayList* _tmp182_ = NULL;
	gint _tmp183_ = 0;
	gint _tmp184_ = 0;
	GeeList* _tmp185_ = NULL;
	gpointer _tmp186_ = NULL;
	gchar* _tmp187_ = NULL;
	GeeList* _tmp188_ = NULL;
	gpointer _tmp189_ = NULL;
	gchar* _tmp190_ = NULL;
	GeeList* _tmp191_ = NULL;
	gpointer _tmp192_ = NULL;
	gchar* _tmp193_ = NULL;
	GeeList* _tmp194_ = NULL;
	gpointer _tmp195_ = NULL;
	gchar* _tmp196_ = NULL;
	GeeList* _tmp197_ = NULL;
	gpointer _tmp198_ = NULL;
	gchar* _tmp199_ = NULL;
	GeeList* _tmp200_ = NULL;
	gpointer _tmp201_ = NULL;
	gchar* _tmp202_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dummy = _tmp3_;
	_tmp4_ = test_list;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "zero");
	_vala_assert (_tmp5_, "test_list.add (\"zero\")");
	_tmp6_ = test_list;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "one");
	_vala_assert (_tmp7_, "test_list.add (\"one\")");
	_tmp8_ = test_list;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "two");
	_vala_assert (_tmp9_, "test_list.add (\"two\")");
	_tmp10_ = test_list;
	_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	_vala_assert (_tmp12_ == 3, "test_list.size == 3");
	_tmp13_ = dummy;
	_tmp14_ = gee_collection_get_is_empty ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_, "dummy.is_empty");
	_tmp16_ = test_list;
	_tmp17_ = dummy;
	gee_list_insert_all (_tmp16_, 0, (GeeCollection*) _tmp17_);
	_tmp18_ = test_list;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_vala_assert (_tmp20_ == 3, "test_list.size == 3");
	_tmp21_ = dummy;
	_tmp22_ = gee_collection_get_is_empty ((GeeCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	_vala_assert (_tmp23_, "dummy.is_empty");
	_tmp24_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp24_);
	_tmp25_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp25_);
	_tmp26_ = dummy;
	_tmp27_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, "zero");
	_vala_assert (_tmp27_, "dummy.add (\"zero\")");
	_tmp28_ = dummy;
	_tmp29_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, "one");
	_vala_assert (_tmp29_, "dummy.add (\"one\")");
	_tmp30_ = dummy;
	_tmp31_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, "two");
	_vala_assert (_tmp31_, "dummy.add (\"two\")");
	_tmp32_ = test_list;
	_tmp33_ = gee_collection_get_is_empty ((GeeCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	_vala_assert (_tmp34_, "test_list.is_empty");
	_tmp35_ = dummy;
	_tmp36_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp35_);
	_tmp37_ = _tmp36_;
	_vala_assert (_tmp37_ == 3, "dummy.size == 3");
	_tmp38_ = test_list;
	_tmp39_ = dummy;
	gee_list_insert_all (_tmp38_, 0, (GeeCollection*) _tmp39_);
	_tmp40_ = test_list;
	_tmp41_ = gee_collection_get_size ((GeeCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	_vala_assert (_tmp42_ == 3, "test_list.size == 3");
	_tmp43_ = dummy;
	_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_assert (_tmp45_ == 3, "dummy.size == 3");
	_tmp46_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp46_);
	_tmp47_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp47_);
	_tmp48_ = dummy;
	_tmp49_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, "zero");
	_vala_assert (_tmp49_, "dummy.add (\"zero\")");
	_tmp50_ = dummy;
	_tmp51_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, "one");
	_vala_assert (_tmp51_, "dummy.add (\"one\")");
	_tmp52_ = dummy;
	_tmp53_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, "two");
	_vala_assert (_tmp53_, "dummy.add (\"two\")");
	_tmp54_ = test_list;
	_tmp55_ = gee_collection_get_is_empty ((GeeCollection*) _tmp54_);
	_tmp56_ = _tmp55_;
	_vala_assert (_tmp56_, "test_list.is_empty");
	_tmp57_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp57_) {
		GeeList* _tmp58_ = NULL;
		GeeArrayList* _tmp59_ = NULL;
		_tmp58_ = test_list;
		_tmp59_ = dummy;
		gee_list_insert_all (_tmp58_, 1, (GeeCollection*) _tmp59_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp60_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp60_);
	_tmp61_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp61_);
	_tmp62_ = test_list;
	_tmp63_ = gee_collection_add ((GeeCollection*) _tmp62_, "three");
	_vala_assert (_tmp63_, "test_list.add (\"three\")");
	_tmp64_ = test_list;
	_tmp65_ = gee_collection_add ((GeeCollection*) _tmp64_, "four");
	_vala_assert (_tmp65_, "test_list.add (\"four\")");
	_tmp66_ = test_list;
	_tmp67_ = gee_collection_add ((GeeCollection*) _tmp66_, "five");
	_vala_assert (_tmp67_, "test_list.add (\"five\")");
	_tmp68_ = dummy;
	_tmp69_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, "zero");
	_vala_assert (_tmp69_, "dummy.add (\"zero\")");
	_tmp70_ = dummy;
	_tmp71_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp70_, "one");
	_vala_assert (_tmp71_, "dummy.add (\"one\")");
	_tmp72_ = dummy;
	_tmp73_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp72_, "two");
	_vala_assert (_tmp73_, "dummy.add (\"two\")");
	_tmp74_ = test_list;
	_tmp75_ = gee_collection_get_size ((GeeCollection*) _tmp74_);
	_tmp76_ = _tmp75_;
	_vala_assert (_tmp76_ == 3, "test_list.size == 3");
	_tmp77_ = dummy;
	_tmp78_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp77_);
	_tmp79_ = _tmp78_;
	_vala_assert (_tmp79_ == 3, "dummy.size == 3");
	_tmp80_ = test_list;
	_tmp81_ = dummy;
	gee_list_insert_all (_tmp80_, 0, (GeeCollection*) _tmp81_);
	_tmp82_ = test_list;
	_tmp83_ = gee_collection_get_size ((GeeCollection*) _tmp82_);
	_tmp84_ = _tmp83_;
	_vala_assert (_tmp84_ == 6, "test_list.size == 6");
	_tmp85_ = dummy;
	_tmp86_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp85_);
	_tmp87_ = _tmp86_;
	_vala_assert (_tmp87_ == 3, "dummy.size == 3");
	_tmp88_ = test_list;
	_tmp89_ = gee_list_get (_tmp88_, 0);
	_tmp90_ = (gchar*) _tmp89_;
	_vala_assert (g_strcmp0 (_tmp90_, "zero") == 0, "test_list.get (0) == \"zero\"");
	_g_free0 (_tmp90_);
	_tmp91_ = test_list;
	_tmp92_ = gee_list_get (_tmp91_, 1);
	_tmp93_ = (gchar*) _tmp92_;
	_vala_assert (g_strcmp0 (_tmp93_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp93_);
	_tmp94_ = test_list;
	_tmp95_ = gee_list_get (_tmp94_, 2);
	_tmp96_ = (gchar*) _tmp95_;
	_vala_assert (g_strcmp0 (_tmp96_, "two") == 0, "test_list.get (2) == \"two\"");
	_g_free0 (_tmp96_);
	_tmp97_ = test_list;
	_tmp98_ = gee_list_get (_tmp97_, 3);
	_tmp99_ = (gchar*) _tmp98_;
	_vala_assert (g_strcmp0 (_tmp99_, "three") == 0, "test_list.get (3) == \"three\"");
	_g_free0 (_tmp99_);
	_tmp100_ = test_list;
	_tmp101_ = gee_list_get (_tmp100_, 4);
	_tmp102_ = (gchar*) _tmp101_;
	_vala_assert (g_strcmp0 (_tmp102_, "four") == 0, "test_list.get (4) == \"four\"");
	_g_free0 (_tmp102_);
	_tmp103_ = test_list;
	_tmp104_ = gee_list_get (_tmp103_, 5);
	_tmp105_ = (gchar*) _tmp104_;
	_vala_assert (g_strcmp0 (_tmp105_, "five") == 0, "test_list.get (5) == \"five\"");
	_g_free0 (_tmp105_);
	_tmp106_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp106_);
	_tmp107_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp107_);
	_tmp108_ = test_list;
	_tmp109_ = gee_collection_add ((GeeCollection*) _tmp108_, "zero");
	_vala_assert (_tmp109_, "test_list.add (\"zero\")");
	_tmp110_ = test_list;
	_tmp111_ = gee_collection_add ((GeeCollection*) _tmp110_, "one");
	_vala_assert (_tmp111_, "test_list.add (\"one\")");
	_tmp112_ = test_list;
	_tmp113_ = gee_collection_add ((GeeCollection*) _tmp112_, "five");
	_vala_assert (_tmp113_, "test_list.add (\"five\")");
	_tmp114_ = test_list;
	_tmp115_ = gee_collection_add ((GeeCollection*) _tmp114_, "six");
	_vala_assert (_tmp115_, "test_list.add (\"six\")");
	_tmp116_ = dummy;
	_tmp117_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp116_, "two");
	_vala_assert (_tmp117_, "dummy.add (\"two\")");
	_tmp118_ = dummy;
	_tmp119_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp118_, "three");
	_vala_assert (_tmp119_, "dummy.add (\"three\")");
	_tmp120_ = dummy;
	_tmp121_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, "four");
	_vala_assert (_tmp121_, "dummy.add (\"four\")");
	_tmp122_ = test_list;
	_tmp123_ = gee_collection_get_size ((GeeCollection*) _tmp122_);
	_tmp124_ = _tmp123_;
	_vala_assert (_tmp124_ == 4, "test_list.size == 4");
	_tmp125_ = dummy;
	_tmp126_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp125_);
	_tmp127_ = _tmp126_;
	_vala_assert (_tmp127_ == 3, "dummy.size == 3");
	_tmp128_ = test_list;
	_tmp129_ = dummy;
	gee_list_insert_all (_tmp128_, 2, (GeeCollection*) _tmp129_);
	_tmp130_ = test_list;
	_tmp131_ = gee_collection_get_size ((GeeCollection*) _tmp130_);
	_tmp132_ = _tmp131_;
	_vala_assert (_tmp132_ == 7, "test_list.size == 7");
	_tmp133_ = dummy;
	_tmp134_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp133_);
	_tmp135_ = _tmp134_;
	_vala_assert (_tmp135_ == 3, "dummy.size == 3");
	_tmp136_ = test_list;
	_tmp137_ = gee_list_get (_tmp136_, 0);
	_tmp138_ = (gchar*) _tmp137_;
	_vala_assert (g_strcmp0 (_tmp138_, "zero") == 0, "test_list.get (0) == \"zero\"");
	_g_free0 (_tmp138_);
	_tmp139_ = test_list;
	_tmp140_ = gee_list_get (_tmp139_, 1);
	_tmp141_ = (gchar*) _tmp140_;
	_vala_assert (g_strcmp0 (_tmp141_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp141_);
	_tmp142_ = test_list;
	_tmp143_ = gee_list_get (_tmp142_, 2);
	_tmp144_ = (gchar*) _tmp143_;
	_vala_assert (g_strcmp0 (_tmp144_, "two") == 0, "test_list.get (2) == \"two\"");
	_g_free0 (_tmp144_);
	_tmp145_ = test_list;
	_tmp146_ = gee_list_get (_tmp145_, 3);
	_tmp147_ = (gchar*) _tmp146_;
	_vala_assert (g_strcmp0 (_tmp147_, "three") == 0, "test_list.get (3) == \"three\"");
	_g_free0 (_tmp147_);
	_tmp148_ = test_list;
	_tmp149_ = gee_list_get (_tmp148_, 4);
	_tmp150_ = (gchar*) _tmp149_;
	_vala_assert (g_strcmp0 (_tmp150_, "four") == 0, "test_list.get (4) == \"four\"");
	_g_free0 (_tmp150_);
	_tmp151_ = test_list;
	_tmp152_ = gee_list_get (_tmp151_, 5);
	_tmp153_ = (gchar*) _tmp152_;
	_vala_assert (g_strcmp0 (_tmp153_, "five") == 0, "test_list.get (5) == \"five\"");
	_g_free0 (_tmp153_);
	_tmp154_ = test_list;
	_tmp155_ = gee_list_get (_tmp154_, 6);
	_tmp156_ = (gchar*) _tmp155_;
	_vala_assert (g_strcmp0 (_tmp156_, "six") == 0, "test_list.get (6) == \"six\"");
	_g_free0 (_tmp156_);
	_tmp157_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp157_);
	_tmp158_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp158_);
	_tmp159_ = test_list;
	_tmp160_ = gee_collection_add ((GeeCollection*) _tmp159_, "zero");
	_vala_assert (_tmp160_, "test_list.add (\"zero\")");
	_tmp161_ = test_list;
	_tmp162_ = gee_collection_add ((GeeCollection*) _tmp161_, "one");
	_vala_assert (_tmp162_, "test_list.add (\"one\")");
	_tmp163_ = test_list;
	_tmp164_ = gee_collection_add ((GeeCollection*) _tmp163_, "two");
	_vala_assert (_tmp164_, "test_list.add (\"two\")");
	_tmp165_ = dummy;
	_tmp166_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp165_, "three");
	_vala_assert (_tmp166_, "dummy.add (\"three\")");
	_tmp167_ = dummy;
	_tmp168_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp167_, "four");
	_vala_assert (_tmp168_, "dummy.add (\"four\")");
	_tmp169_ = dummy;
	_tmp170_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp169_, "five");
	_vala_assert (_tmp170_, "dummy.add (\"five\")");
	_tmp171_ = test_list;
	_tmp172_ = gee_collection_get_size ((GeeCollection*) _tmp171_);
	_tmp173_ = _tmp172_;
	_vala_assert (_tmp173_ == 3, "test_list.size == 3");
	_tmp174_ = dummy;
	_tmp175_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp174_);
	_tmp176_ = _tmp175_;
	_vala_assert (_tmp176_ == 3, "dummy.size == 3");
	_tmp177_ = test_list;
	_tmp178_ = dummy;
	gee_list_insert_all (_tmp177_, 3, (GeeCollection*) _tmp178_);
	_tmp179_ = test_list;
	_tmp180_ = gee_collection_get_size ((GeeCollection*) _tmp179_);
	_tmp181_ = _tmp180_;
	_vala_assert (_tmp181_ == 6, "test_list.size == 6");
	_tmp182_ = dummy;
	_tmp183_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp182_);
	_tmp184_ = _tmp183_;
	_vala_assert (_tmp184_ == 3, "dummy.size == 3");
	_tmp185_ = test_list;
	_tmp186_ = gee_list_get (_tmp185_, 0);
	_tmp187_ = (gchar*) _tmp186_;
	_vala_assert (g_strcmp0 (_tmp187_, "zero") == 0, "test_list.get (0) == \"zero\"");
	_g_free0 (_tmp187_);
	_tmp188_ = test_list;
	_tmp189_ = gee_list_get (_tmp188_, 1);
	_tmp190_ = (gchar*) _tmp189_;
	_vala_assert (g_strcmp0 (_tmp190_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp190_);
	_tmp191_ = test_list;
	_tmp192_ = gee_list_get (_tmp191_, 2);
	_tmp193_ = (gchar*) _tmp192_;
	_vala_assert (g_strcmp0 (_tmp193_, "two") == 0, "test_list.get (2) == \"two\"");
	_g_free0 (_tmp193_);
	_tmp194_ = test_list;
	_tmp195_ = gee_list_get (_tmp194_, 3);
	_tmp196_ = (gchar*) _tmp195_;
	_vala_assert (g_strcmp0 (_tmp196_, "three") == 0, "test_list.get (3) == \"three\"");
	_g_free0 (_tmp196_);
	_tmp197_ = test_list;
	_tmp198_ = gee_list_get (_tmp197_, 4);
	_tmp199_ = (gchar*) _tmp198_;
	_vala_assert (g_strcmp0 (_tmp199_, "four") == 0, "test_list.get (4) == \"four\"");
	_g_free0 (_tmp199_);
	_tmp200_ = test_list;
	_tmp201_ = gee_list_get (_tmp200_, 5);
	_tmp202_ = (gchar*) _tmp201_;
	_vala_assert (g_strcmp0 (_tmp202_, "five") == 0, "test_list.get (5) == \"five\"");
	_g_free0 (_tmp202_);
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}


void list_tests_test_slice (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* dummy = NULL;
	gboolean _tmp3_ = FALSE;
	GeeList* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeList* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GeeList* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GeeList* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GeeList* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GeeList* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GeeList* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	GeeList* _tmp21_ = NULL;
	GeeList* _tmp22_ = NULL;
	GeeList* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GeeList* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GeeList* _tmp29_ = NULL;
	gpointer _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	GeeList* _tmp32_ = NULL;
	gpointer _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GeeList* _tmp35_ = NULL;
	gpointer _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_ = NULL;
		GeeList* _tmp5_ = NULL;
		_tmp4_ = test_list;
		_tmp5_ = gee_list_slice (_tmp4_, 1, 4);
		_g_object_unref0 (dummy);
		dummy = _tmp5_;
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp6_ = test_list;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "zero");
	_vala_assert (_tmp7_, "test_list.add (\"zero\")");
	_tmp8_ = test_list;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "one");
	_vala_assert (_tmp9_, "test_list.add (\"one\")");
	_tmp10_ = test_list;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "two");
	_vala_assert (_tmp11_, "test_list.add (\"two\")");
	_tmp12_ = test_list;
	_tmp13_ = gee_collection_add ((GeeCollection*) _tmp12_, "three");
	_vala_assert (_tmp13_, "test_list.add (\"three\")");
	_tmp14_ = test_list;
	_tmp15_ = gee_collection_add ((GeeCollection*) _tmp14_, "four");
	_vala_assert (_tmp15_, "test_list.add (\"four\")");
	_tmp16_ = test_list;
	_tmp17_ = gee_collection_add ((GeeCollection*) _tmp16_, "five");
	_vala_assert (_tmp17_, "test_list.add (\"five\")");
	_tmp18_ = test_list;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_vala_assert (_tmp20_ == 6, "test_list.size == 6");
	_tmp21_ = test_list;
	_tmp22_ = gee_list_slice (_tmp21_, 1, 4);
	_g_object_unref0 (dummy);
	dummy = _tmp22_;
	_tmp23_ = dummy;
	_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_vala_assert (_tmp25_ == 3, "dummy.size == 3");
	_tmp26_ = test_list;
	_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_ == 6, "test_list.size == 6");
	_tmp29_ = dummy;
	_tmp30_ = gee_list_get (_tmp29_, 0);
	_tmp31_ = (gchar*) _tmp30_;
	_vala_assert (g_strcmp0 (_tmp31_, "one") == 0, "dummy.get (0) == \"one\"");
	_g_free0 (_tmp31_);
	_tmp32_ = dummy;
	_tmp33_ = gee_list_get (_tmp32_, 1);
	_tmp34_ = (gchar*) _tmp33_;
	_vala_assert (g_strcmp0 (_tmp34_, "two") == 0, "dummy.get (1) == \"two\"");
	_g_free0 (_tmp34_);
	_tmp35_ = dummy;
	_tmp36_ = gee_list_get (_tmp35_, 2);
	_tmp37_ = (gchar*) _tmp36_;
	_vala_assert (g_strcmp0 (_tmp37_, "three") == 0, "dummy.get (2) == \"three\"");
	_g_free0 (_tmp37_);
	_tmp38_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp38_) {
		GeeList* _tmp39_ = NULL;
		GeeList* _tmp40_ = NULL;
		_tmp39_ = test_list;
		_tmp40_ = gee_list_slice (_tmp39_, 0, 9);
		_g_object_unref0 (dummy);
		dummy = _tmp40_;
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}


static void list_tests_class_init (ListTestsClass * klass) {
	list_tests_parent_class = g_type_class_peek_parent (klass);
	LIST_TESTS_CLASS (klass)->test_duplicates_are_retained = list_tests_real_test_duplicates_are_retained;
}


static void list_tests_instance_init (ListTests * self) {
}


GType list_tests_get_type (void) {
	static volatile gsize list_tests_type_id__volatile = 0;
	if (g_once_init_enter (&list_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListTests), 0, (GInstanceInitFunc) list_tests_instance_init, NULL };
		GType list_tests_type_id;
		list_tests_type_id = g_type_register_static (TYPE_COLLECTION_TESTS, "ListTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&list_tests_type_id__volatile, list_tests_type_id);
	}
	return list_tests_type_id__volatile;
}



