/* traversable.c generated by valac 0.20.1.51-7ff1, the Vala compiler
 * generated from traversable.vala, do not modify */

/* traversable.vala
 *
 * Copyright (C) 2011-2012  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;
typedef struct _Block8Data Block8Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;
typedef struct _Block9Data Block9Data;
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))
typedef struct _Block10Data Block10Data;
#define _a_destroy_func0(var) (((var == NULL) || (a_destroy_func == NULL)) ? NULL : (var = (a_destroy_func (var), NULL)))
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef GeeLazy* (*GeeUnfoldFunc) (void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
};

struct _Block8Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeIterator* _self_;
	GeeStreamFunc f;
	gpointer f_target;
	GDestroyNotify f_target_destroy_notify;
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	GeeTraversableStream str;
	gboolean need_next;
};

typedef gpointer (*GeeLazyFunc) (void* user_data);
struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
};

struct _Block11Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block12Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeMapFunc f;
	gpointer f_target;
};

struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	GeeLazy* item;
};

struct _Block14Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean seed_emitted;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block15Data {
	int _ref_count_;
	Block14Data * _data14_;
	GeeLazy* item;
};

struct _Block16Data {
	int _ref_count_;
	GeeTraversable * self;
	GeePredicate pred;
	gpointer pred_target;
	GDestroyNotify pred_target_destroy_notify;
};

struct _Block17Data {
	int _ref_count_;
	GeeTraversable * self;
	gint offset;
	gint length;
};



gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
gboolean gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target);
GeeIterator* gee_traversable_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
static GeeIterator* gee_traversable_real_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
GType gee_iterable_get_type (void) G_GNUC_CONST;
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
gboolean gee_iterator_get_valid (GeeIterator* self);
static gpointer _____lambda3_ (Block9Data* _data9_);
gpointer gee_iterator_get (GeeIterator* self);
static gpointer ______lambda3__gee_lazy_func (gpointer self);
GeeLazy* gee_lazy_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeLazy* gee_lazy_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeIterator* gee_iterator_unfold (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeUnfoldFunc f, void* f_target, GDestroyNotify f_target_destroy_notify, GeeLazy* current);
static GeeLazy* ______lambda4_ (Block9Data* _data9_);
static GeeLazy* _______lambda4__gee_unfold_func (gpointer self);
static GeeLazy* ____lambda5_ (Block9Data* _data9_);
static GeeLazy* _____lambda5__gee_unfold_func (gpointer self);
static GeeLazy* ___lambda6_ (Block9Data* _data9_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
gboolean gee_iterator_next (GeeIterator* self);
static gpointer ___lambda7_ (Block10Data* _data10_);
static gpointer ____lambda7__gee_lazy_func (gpointer self);
static GeeLazy* ____lambda6__gee_unfold_func (gpointer self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static gpointer gee_traversable_real_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block11Data* _data11_, gpointer item);
static gboolean ___lambda8__gee_forall_func (gpointer g, gpointer self);
GeeIterator* gee_traversable_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
static GeeIterator* gee_traversable_real_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static GeeTraversableStream __lambda9_ (Block12Data* _data12_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gpointer ___lambda10_ (Block13Data* _data13_);
gpointer gee_lazy_get (GeeLazy* self);
static gpointer ____lambda10__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda9__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static GeeIterator* gee_traversable_real_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static GeeTraversableStream __lambda11_ (Block14Data* _data14_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
GeeLazy* gee_lazy_new_from_value (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
GeeLazy* gee_lazy_construct_from_value (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
static gpointer ___lambda12_ (Block15Data* _data15_);
static gpointer ____lambda12__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda11__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
static GeeIterator* gee_traversable_real_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static GeeTraversableStream __lambda13_ (Block16Data* _data16_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static GeeTraversableStream ___lambda13__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_chop (GeeTraversable* self, gint offset, gint length);
static GeeIterator* gee_traversable_real_chop (GeeTraversable* self, gint offset, gint length);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static GeeTraversableStream __lambda14_ (Block17Data* _data17_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static GeeTraversableStream ___lambda14__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GType gee_traversable_get_element_type (GeeTraversable* self);


GType gee_traversable_stream_get_type (void) {
	static volatile gsize gee_traversable_stream_type_id__volatile = 0;
	if (g_once_init_enter (&gee_traversable_stream_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TRAVERSABLE_STREAM_YIELD, "GEE_TRAVERSABLE_STREAM_YIELD", "yield"}, {GEE_TRAVERSABLE_STREAM_CONTINUE, "GEE_TRAVERSABLE_STREAM_CONTINUE", "continue"}, {GEE_TRAVERSABLE_STREAM_END, "GEE_TRAVERSABLE_STREAM_END", "end"}, {0, NULL, NULL}};
		GType gee_traversable_stream_type_id;
		gee_traversable_stream_type_id = g_enum_register_static ("GeeTraversableStream", values);
		g_once_init_leave (&gee_traversable_stream_type_id__volatile, gee_traversable_stream_type_id);
	}
	return gee_traversable_stream_type_id__volatile;
}


/**
 * Apply function to each element returned by iterator untill last element
 * or function return ''false''.
 *
 * ''{@link Iterator} implementation:'' Operation moves the iterator
 * to last element in iteration or the first element that returned ''false''.
 * If iterator points at some element it will be included in iteration.
 *
 * @param f function applied to every element of the collection
 *
 * @return ''false'' if the argument returned ''false'' at last invocation and
 *         ''true'' otherwise.
 */
gboolean gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->foreach (self, f, f_target);
}


/**
 * Stream function is an abstract function allowing writing many
 * operations.
 *
 * The stream function accepts three parameter:
 *
 *   1. state. It is usually the last returned value from function but
 *      it may be {@link Stream.END} when {@link Stream.CONTINUE} was
 *      returned and there was no more elements.
 *   1. input. It is valid only if first argument is
 *      {@link Stream.CONTINUE}
 *   1. output. It is valid only if result is Stream.YIELD
 *
 * It may return one of 3 results:
 *
 *   1. {@link Stream.YIELD}. It means that value was yielded and can
 *      be passed to outgoing iterator.
 *   1. {@link Stream.CONTINUE}. It means that the function needs to be
 *      called with next element or with {@link Stream.END} if it is
 *      end of stream). If the state element was Stream.END during the
 *      current iteration function ''must not'' return {@link Stream.CONTINUE}
 *   1. Stream.END. It means that the last argument was yielded.
 *
 * If the function yields the value immediately then the returning iterator
 * is {@link Iterator.valid} and points to this value as well as in case when the
 * parent iterator is {@link Iterator.valid} and function yields
 * after consuming 1 input. In other case returned iterator is invalid.
 *
 * Note: In {@link Iterator} implementation: if iterator is
 *    {@link Iterator.valid} the current value should be fed
 *    immediately to function if during initial call function returns
 *    {@link Stream.CONTINUE}. The parent iterator cannot be used before
 *    the functions return {@link Stream.END} afterwards it points on the
 *    last element consumed.
 *
 * @param f function generating stream
 * @return iterator containing values yielded by stream
 */
static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data8_->self;
		a_type = _data8_->a_type;
		a_dup_func = _data8_->a_dup_func;
		a_destroy_func = _data8_->a_destroy_func;
		_g_object_unref0 (_data8_->_self_);
		(_data8_->f_target_destroy_notify == NULL) ? NULL : (_data8_->f_target_destroy_notify (_data8_->f_target), NULL);
		_data8_->f = NULL;
		_data8_->f_target = NULL;
		_data8_->f_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data9_->_data8_->self;
		a_type = _data9_->_data8_->a_type;
		a_dup_func = _data9_->_data8_->a_dup_func;
		a_destroy_func = _data9_->_data8_->a_destroy_func;
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}


static gpointer _____lambda3_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeIterator* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	a_type = _data8_->a_type;
	a_dup_func = _data8_->a_dup_func;
	a_destroy_func = _data8_->a_destroy_func;
	_tmp0_ = _data8_->_self_;
	_tmp1_ = gee_iterator_get (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer ______lambda3__gee_lazy_func (gpointer self) {
	gpointer result;
	result = _____lambda3_ (self);
	return result;
}


static GeeLazy* ______lambda4_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* result = NULL;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	a_type = _data8_->a_type;
	a_dup_func = _data8_->a_dup_func;
	a_destroy_func = _data8_->a_destroy_func;
	result = NULL;
	return result;
}


static GeeLazy* _______lambda4__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = ______lambda4_ (self);
	return result;
}


static GeeLazy* ____lambda5_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* result = NULL;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	a_type = _data8_->a_type;
	a_dup_func = _data8_->a_dup_func;
	a_destroy_func = _data8_->a_destroy_func;
	result = NULL;
	return result;
}


static GeeLazy* _____lambda5__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = ____lambda5_ (self);
	return result;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data10_->_data9_->_data8_->self;
		a_type = _data10_->_data9_->_data8_->a_type;
		a_dup_func = _data10_->_data9_->_data8_->a_dup_func;
		a_destroy_func = _data10_->_data9_->_data8_->a_destroy_func;
		block9_data_unref (_data10_->_data9_);
		_data10_->_data9_ = NULL;
		g_slice_free (Block10Data, _data10_);
	}
}


static gpointer ___lambda7_ (Block10Data* _data10_) {
	Block9Data* _data9_;
	Block8Data* _data8_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeIterator* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	_data9_ = _data10_->_data9_;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	a_type = _data8_->a_type;
	a_dup_func = _data8_->a_dup_func;
	a_destroy_func = _data8_->a_destroy_func;
	_tmp0_ = _data8_->_self_;
	_tmp1_ = gee_iterator_get (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer ____lambda7__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda7_ (self);
	return result;
}


static GeeLazy* ___lambda6_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* result = NULL;
	Block10Data* _data10_;
	GeeLazy* val = NULL;
	GeeTraversableStream _tmp0_ = 0;
	GeeTraversableStream _tmp16_ = 0;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	a_type = _data8_->a_type;
	a_dup_func = _data8_->a_dup_func;
	a_destroy_func = _data8_->a_destroy_func;
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->_data9_ = block9_data_ref (_data9_);
	val = NULL;
	_tmp0_ = _data9_->str;
	if (_tmp0_ != GEE_TRAVERSABLE_STREAM_CONTINUE) {
		GeeStreamFunc _tmp1_ = NULL;
		void* _tmp1__target = NULL;
		GeeLazy* _tmp2_ = NULL;
		GeeTraversableStream _tmp3_ = 0;
		_tmp1_ = _data8_->f;
		_tmp1__target = _data8_->f_target;
		_tmp3_ = _tmp1_ (GEE_TRAVERSABLE_STREAM_YIELD, NULL, &_tmp2_, _tmp1__target);
		_gee_lazy_unref0 (val);
		val = _tmp2_;
		_data9_->str = _tmp3_;
	}
	while (TRUE) {
		GeeTraversableStream _tmp4_ = 0;
		gboolean _tmp5_ = FALSE;
		GeeStreamFunc _tmp12_ = NULL;
		void* _tmp12__target = NULL;
		GeeLazy* _tmp13_ = NULL;
		GeeLazy* _tmp14_ = NULL;
		GeeTraversableStream _tmp15_ = 0;
		_tmp4_ = _data9_->str;
		if (!(_tmp4_ == GEE_TRAVERSABLE_STREAM_CONTINUE)) {
			break;
		}
		_tmp5_ = _data9_->need_next;
		if (_tmp5_) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			_tmp6_ = _data8_->_self_;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				GeeStreamFunc _tmp8_ = NULL;
				void* _tmp8__target = NULL;
				GeeLazy* _tmp9_ = NULL;
				GeeTraversableStream _tmp10_ = 0;
				GeeTraversableStream _tmp11_ = 0;
				_tmp8_ = _data8_->f;
				_tmp8__target = _data8_->f_target;
				_tmp10_ = _tmp8_ (GEE_TRAVERSABLE_STREAM_END, NULL, &_tmp9_, _tmp8__target);
				_gee_lazy_unref0 (val);
				val = _tmp9_;
				_data9_->str = _tmp10_;
				_tmp11_ = _data9_->str;
				_vala_assert (_tmp11_ != GEE_TRAVERSABLE_STREAM_CONTINUE, "str != Traversable.Stream.CONTINUE");
				break;
			}
		} else {
			_data9_->need_next = TRUE;
		}
		_tmp12_ = _data8_->f;
		_tmp12__target = _data8_->f_target;
		_tmp13_ = gee_lazy_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ____lambda7__gee_lazy_func, block10_data_ref (_data10_), block10_data_unref);
		_tmp15_ = _tmp12_ (GEE_TRAVERSABLE_STREAM_CONTINUE, _tmp13_, &_tmp14_, _tmp12__target);
		_gee_lazy_unref0 (val);
		val = _tmp14_;
		_data9_->str = _tmp15_;
	}
	_tmp16_ = _data9_->str;
	switch (_tmp16_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			result = val;
			block10_data_unref (_data10_);
			_data10_ = NULL;
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			result = NULL;
			_gee_lazy_unref0 (val);
			block10_data_unref (_data10_);
			_data10_ = NULL;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_gee_lazy_unref0 (val);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static GeeLazy* ____lambda6__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = ___lambda6_ (self);
	return result;
}


static gpointer _gee_lazy_ref0 (gpointer self) {
	return self ? gee_lazy_ref (self) : NULL;
}


static GeeIterator* gee_traversable_real_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	GeeIterator* result = NULL;
	Block8Data* _data8_;
	GeeStreamFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeIterable* iself = NULL;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->a_type = a_type;
	_data8_->a_dup_func = a_dup_func;
	_data8_->a_destroy_func = a_destroy_func;
	_tmp0_ = f;
	_tmp0__target = f_target;
	(_data8_->f_target_destroy_notify == NULL) ? NULL : (_data8_->f_target_destroy_notify (_data8_->f_target), NULL);
	_data8_->f = NULL;
	_data8_->f_target = NULL;
	_data8_->f_target_destroy_notify = NULL;
	_data8_->f = _tmp0_;
	_data8_->f_target = _tmp0__target;
	_data8_->f_target_destroy_notify = f_target_destroy_notify;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, GEE_TYPE_ITERATOR) ? ((GeeIterator*) self) : NULL);
	_g_object_unref0 (_data8_->_self_);
	_data8_->_self_ = _tmp1_;
	_tmp2_ = _data8_->_self_;
	if (_tmp2_ != NULL) {
		Block9Data* _data9_;
		GeeLazy* initial = NULL;
		GeeStreamFunc _tmp3_ = NULL;
		void* _tmp3__target = NULL;
		GeeLazy* _tmp4_ = NULL;
		GeeTraversableStream _tmp5_ = 0;
		GeeTraversableStream _tmp6_ = 0;
		GeeLazy* _tmp20_ = NULL;
		GeeLazy* _tmp21_ = NULL;
		GeeIterator* _tmp22_ = NULL;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->_data8_ = block8_data_ref (_data8_);
		initial = NULL;
		_data9_->need_next = TRUE;
		_tmp3_ = _data8_->f;
		_tmp3__target = _data8_->f_target;
		_tmp5_ = _tmp3_ (GEE_TRAVERSABLE_STREAM_YIELD, NULL, &_tmp4_, _tmp3__target);
		_gee_lazy_unref0 (initial);
		initial = _tmp4_;
		_data9_->str = _tmp5_;
		_tmp6_ = _data9_->str;
		switch (_tmp6_) {
			case GEE_TRAVERSABLE_STREAM_CONTINUE:
			{
				GeeIterator* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				_tmp7_ = _data8_->_self_;
				_tmp8_ = gee_iterator_get_valid (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					GeeStreamFunc _tmp10_ = NULL;
					void* _tmp10__target = NULL;
					GeeLazy* _tmp11_ = NULL;
					GeeLazy* _tmp12_ = NULL;
					GeeTraversableStream _tmp13_ = 0;
					GeeTraversableStream _tmp14_ = 0;
					_tmp10_ = _data8_->f;
					_tmp10__target = _data8_->f_target;
					_tmp11_ = gee_lazy_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ______lambda3__gee_lazy_func, block9_data_ref (_data9_), block9_data_unref);
					_tmp13_ = _tmp10_ (GEE_TRAVERSABLE_STREAM_CONTINUE, _tmp11_, &_tmp12_, _tmp10__target);
					_gee_lazy_unref0 (initial);
					initial = _tmp12_;
					_data9_->str = _tmp13_;
					_tmp14_ = _data9_->str;
					switch (_tmp14_) {
						case GEE_TRAVERSABLE_STREAM_YIELD:
						case GEE_TRAVERSABLE_STREAM_CONTINUE:
						{
							break;
						}
						case GEE_TRAVERSABLE_STREAM_END:
						{
							GeeIterator* _tmp15_ = NULL;
							_tmp15_ = gee_iterator_unfold (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _______lambda4__gee_unfold_func, block9_data_ref (_data9_), block9_data_unref, NULL);
							result = _tmp15_;
							_gee_lazy_unref0 (initial);
							block9_data_unref (_data9_);
							_data9_ = NULL;
							_g_object_unref0 (iself);
							block8_data_unref (_data8_);
							_data8_ = NULL;
							return result;
						}
						default:
						{
							g_assert_not_reached ();
						}
					}
				}
				break;
			}
			case GEE_TRAVERSABLE_STREAM_YIELD:
			{
				GeeIterator* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				_tmp16_ = _data8_->_self_;
				_tmp17_ = gee_iterator_get_valid (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_) {
					_data9_->need_next = FALSE;
				}
				break;
			}
			case GEE_TRAVERSABLE_STREAM_END:
			{
				GeeIterator* _tmp19_ = NULL;
				_tmp19_ = gee_iterator_unfold (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _____lambda5__gee_unfold_func, block9_data_ref (_data9_), block9_data_unref, NULL);
				result = _tmp19_;
				_gee_lazy_unref0 (initial);
				block9_data_unref (_data9_);
				_data9_ = NULL;
				_g_object_unref0 (iself);
				block8_data_unref (_data8_);
				_data8_ = NULL;
				return result;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
		_tmp20_ = initial;
		_tmp21_ = _gee_lazy_ref0 (_tmp20_);
		_tmp22_ = gee_iterator_unfold (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda6__gee_unfold_func, block9_data_ref (_data9_), block9_data_unref, _tmp21_);
		result = _tmp22_;
		_gee_lazy_unref0 (initial);
		block9_data_unref (_data9_);
		_data9_ = NULL;
		_g_object_unref0 (iself);
		block8_data_unref (_data8_);
		_data8_ = NULL;
		return result;
	} else {
		GeeIterable* _tmp23_ = NULL;
		GeeIterable* _tmp24_ = NULL;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, GEE_TYPE_ITERABLE) ? ((GeeIterable*) self) : NULL);
		_g_object_unref0 (iself);
		iself = _tmp23_;
		_tmp24_ = iself;
		if (_tmp24_ != NULL) {
			GeeIterable* _tmp25_ = NULL;
			GeeIterator* _tmp26_ = NULL;
			GeeIterator* _tmp27_ = NULL;
			GeeStreamFunc _tmp28_ = NULL;
			void* _tmp28__target = NULL;
			GDestroyNotify _tmp28__target_destroy_notify = NULL;
			GeeIterator* _tmp29_ = NULL;
			GeeIterator* _tmp30_ = NULL;
			_tmp25_ = iself;
			_tmp26_ = gee_iterable_iterator (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = _data8_->f;
			_tmp28__target = _data8_->f_target;
			_tmp28__target_destroy_notify = _data8_->f_target_destroy_notify;
			_data8_->f_target_destroy_notify = NULL;
			_tmp29_ = gee_traversable_stream ((GeeTraversable*) _tmp27_, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp28_, _tmp28__target, _tmp28__target_destroy_notify);
			_tmp30_ = _tmp29_;
			_g_object_unref0 (_tmp27_);
			result = _tmp30_;
			_g_object_unref0 (iself);
			block8_data_unref (_data8_);
			_data8_ = NULL;
			return result;
		} else {
			g_assert_not_reached ();
		}
	}
	_g_object_unref0 (iself);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}


GeeIterator* gee_traversable_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->stream (self, a_type, a_dup_func, a_destroy_func, f, f_target, f_target_destroy_notify);
}


/**
 * Standard aggregation function.
 *
 * It takes a function, seed and first element, returns the new seed and
 * progress to next element when the operation repeats.
 *
 * Note: Default implementation uses {@link foreach}.
 *
 * Note: In {@link Iterator} implementation operation moves the
 *    iterator to last element in iteration. If iterator is
 *    {@link Iterator.valid} the current element will be considered
 *    as well.
 *
 */
static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data11_->self;
		a_type = _data11_->a_type;
		a_dup_func = _data11_->a_dup_func;
		a_destroy_func = _data11_->a_destroy_func;
		_a_destroy_func0 (_data11_->seed);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}


static gboolean __lambda8_ (Block11Data* _data11_, gpointer item) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean result = FALSE;
	GeeFoldFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gpointer _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	self = _data11_->self;
	a_type = _data11_->a_type;
	a_dup_func = _data11_->a_dup_func;
	a_destroy_func = _data11_->a_destroy_func;
	_tmp0_ = _data11_->f;
	_tmp0__target = _data11_->f_target;
	_tmp1_ = item;
	item = NULL;
	_tmp2_ = _data11_->seed;
	_data11_->seed = NULL;
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
	_a_destroy_func0 (_data11_->seed);
	_data11_->seed = _tmp3_;
	result = TRUE;
	((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}


static gboolean ___lambda8__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = __lambda8_ (self, g);
	return result;
}


static gpointer gee_traversable_real_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	gpointer result = NULL;
	Block11Data* _data11_;
	GeeFoldFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gconstpointer _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->a_type = a_type;
	_data11_->a_dup_func = a_dup_func;
	_data11_->a_destroy_func = a_destroy_func;
	_tmp0_ = f;
	_tmp0__target = f_target;
	_data11_->f = _tmp0_;
	_data11_->f_target = _tmp0__target;
	_tmp1_ = seed;
	_a_destroy_func0 (_data11_->seed);
	_data11_->seed = _tmp1_;
	gee_traversable_foreach (self, ___lambda8__gee_forall_func, _data11_);
	_tmp2_ = _data11_->seed;
	_data11_->seed = NULL;
	result = _tmp2_;
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}


gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->fold (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
}


/**
 * Produces an iterator pointing at elements generated by function passed.
 *
 * Iterator is lazy evaluated but value is force-evaluated when
 * iterator moves to next element. ({@link Iterator.next})
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: In {@link Iterator} implementation if the parent iterator is
 *    {@link Iterator.valid} so is the returned one. Using the parent
 *    iterator is not allowed before the inner iterator {@link Iterator.next}
 *    return false and then it points on its last element.
 *    The resulting iterator is {@link Iterator.valid} if the parent
 *    iterator is.
 *
 * @param f Mapping function
 * @return Iterator listing mapped value
 */
static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (void * _userdata_) {
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data12_->self;
		a_type = _data12_->a_type;
		a_dup_func = _data12_->a_dup_func;
		a_destroy_func = _data12_->a_destroy_func;
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (void * _userdata_) {
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data13_->_data12_->self;
		a_type = _data13_->_data12_->a_type;
		a_dup_func = _data13_->_data12_->a_dup_func;
		a_destroy_func = _data13_->_data12_->a_destroy_func;
		_gee_lazy_unref0 (_data13_->item);
		block12_data_unref (_data13_->_data12_);
		_data13_->_data12_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}


static gpointer ___lambda10_ (Block13Data* _data13_) {
	Block12Data* _data12_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	gpointer tmp = NULL;
	GeeLazy* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	GeeMapFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	gpointer _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	a_type = _data12_->a_type;
	a_dup_func = _data12_->a_dup_func;
	a_destroy_func = _data12_->a_destroy_func;
	_tmp0_ = _data13_->item;
	_tmp1_ = gee_lazy_get (_tmp0_);
	tmp = _tmp1_;
	_gee_lazy_unref0 (_data13_->item);
	_data13_->item = NULL;
	_tmp2_ = _data12_->f;
	_tmp2__target = _data12_->f_target;
	_tmp3_ = tmp;
	tmp = NULL;
	_tmp4_ = _tmp2_ (_tmp3_, _tmp2__target);
	result = _tmp4_;
	_a_destroy_func0 (tmp);
	return result;
}


static gpointer ____lambda10__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda10_ (self);
	return result;
}


static GeeTraversableStream __lambda9_ (Block12Data* _data12_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	Block13Data* _data13_;
	GeeLazy* _tmp0_ = NULL;
	GeeTraversableStream _tmp1_ = 0;
	self = _data12_->self;
	a_type = _data12_->a_type;
	a_dup_func = _data12_->a_dup_func;
	a_destroy_func = _data12_->a_destroy_func;
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->_data12_ = block12_data_ref (_data12_);
	_tmp0_ = item;
	_gee_lazy_unref0 (_data13_->item);
	_data13_->item = _tmp0_;
	_tmp1_ = state;
	switch (_tmp1_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
			block13_data_unref (_data13_);
			_data13_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GeeLazy* _tmp2_ = NULL;
			_tmp2_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda10__gee_lazy_func, block13_data_ref (_data13_), block13_data_unref);
			_gee_lazy_unref0 (_vala_val);
			_vala_val = _tmp2_;
			result = GEE_TRAVERSABLE_STREAM_YIELD;
			block13_data_unref (_data13_);
			_data13_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			block13_data_unref (_data13_);
			_data13_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	if (val) {
		*val = _vala_val;
	} else {
		_gee_lazy_unref0 (_vala_val);
	}
	block13_data_unref (_data13_);
	_data13_ = NULL;
}


static GeeTraversableStream ___lambda9__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda9_ (self, state, g, lazy);
	return result;
}


static GeeIterator* gee_traversable_real_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target) {
	GeeIterator* result = NULL;
	Block12Data* _data12_;
	GeeMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeIterator* _tmp1_ = NULL;
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_data12_->a_type = a_type;
	_data12_->a_dup_func = a_dup_func;
	_data12_->a_destroy_func = a_destroy_func;
	_tmp0_ = f;
	_tmp0__target = f_target;
	_data12_->f = _tmp0_;
	_data12_->f_target = _tmp0__target;
	_tmp1_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda9__gee_stream_func, block12_data_ref (_data12_), block12_data_unref);
	result = _tmp1_;
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return result;
}


GeeIterator* gee_traversable_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->map (self, a_type, a_dup_func, a_destroy_func, f, f_target);
}


/**
 * Creates a new iterator that is initially pointing to seed. Then
 * subsequent values are obtained after applying the function to previous
 * value and the subsequent items.
 *
 * The resulting iterator is always valid and it contains the seed value.
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: When the method is called on {@link Iterator} using the parent
 *    iterator is not allowed befor the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element. The resulting iterator is {@link Iterator.valid}.
 *
 * @param f Folding function
 * @param seed original seed value
 * @return Iterator containing values of subsequent values of seed
 */
static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data14_->self;
		a_type = _data14_->a_type;
		a_dup_func = _data14_->a_dup_func;
		a_destroy_func = _data14_->a_destroy_func;
		_a_destroy_func0 (_data14_->seed);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data15_->_data14_->self;
		a_type = _data15_->_data14_->a_type;
		a_dup_func = _data15_->_data14_->a_dup_func;
		a_destroy_func = _data15_->_data14_->a_destroy_func;
		_gee_lazy_unref0 (_data15_->item);
		block14_data_unref (_data15_->_data14_);
		_data15_->_data14_ = NULL;
		g_slice_free (Block15Data, _data15_);
	}
}


static gpointer ___lambda12_ (Block15Data* _data15_) {
	Block14Data* _data14_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	gpointer tmp = NULL;
	GeeLazy* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	GeeFoldFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	gpointer _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
	_data14_ = _data15_->_data14_;
	self = _data14_->self;
	a_type = _data14_->a_type;
	a_dup_func = _data14_->a_dup_func;
	a_destroy_func = _data14_->a_destroy_func;
	_tmp0_ = _data15_->item;
	_tmp1_ = gee_lazy_get (_tmp0_);
	tmp = _tmp1_;
	_gee_lazy_unref0 (_data15_->item);
	_data15_->item = NULL;
	_tmp2_ = _data14_->f;
	_tmp2__target = _data14_->f_target;
	_tmp3_ = tmp;
	tmp = NULL;
	_tmp4_ = _data14_->seed;
	_data14_->seed = NULL;
	_tmp5_ = _tmp2_ (_tmp3_, _tmp4_, _tmp2__target);
	_a_destroy_func0 (_data14_->seed);
	_data14_->seed = _tmp5_;
	_tmp6_ = _data14_->seed;
	_tmp7_ = ((_tmp6_ != NULL) && (a_dup_func != NULL)) ? a_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
	result = _tmp7_;
	_a_destroy_func0 (tmp);
	return result;
}


static gpointer ____lambda12__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda12_ (self);
	return result;
}


static GeeTraversableStream __lambda11_ (Block14Data* _data14_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	Block15Data* _data15_;
	GeeLazy* _tmp0_ = NULL;
	GeeTraversableStream _tmp1_ = 0;
	self = _data14_->self;
	a_type = _data14_->a_type;
	a_dup_func = _data14_->a_dup_func;
	a_destroy_func = _data14_->a_destroy_func;
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->_data14_ = block14_data_ref (_data14_);
	_tmp0_ = item;
	_gee_lazy_unref0 (_data15_->item);
	_data15_->item = _tmp0_;
	_tmp1_ = state;
	switch (_tmp1_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			if (_data14_->seed_emitted) {
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				block15_data_unref (_data15_);
				_data15_ = NULL;
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				gconstpointer _tmp2_ = NULL;
				GeeLazy* _tmp3_ = NULL;
				_tmp2_ = _data14_->seed;
				_tmp3_ = gee_lazy_new_from_value (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp2_);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp3_;
				_data14_->seed_emitted = TRUE;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				block15_data_unref (_data15_);
				_data15_ = NULL;
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GeeLazy* _tmp4_ = NULL;
			_tmp4_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda12__gee_lazy_func, block15_data_ref (_data15_), block15_data_unref);
			_gee_lazy_unref0 (_vala_val);
			_vala_val = _tmp4_;
			result = GEE_TRAVERSABLE_STREAM_YIELD;
			block15_data_unref (_data15_);
			_data15_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			block15_data_unref (_data15_);
			_data15_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	if (val) {
		*val = _vala_val;
	} else {
		_gee_lazy_unref0 (_vala_val);
	}
	block15_data_unref (_data15_);
	_data15_ = NULL;
}


static GeeTraversableStream ___lambda11__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda11_ (self, state, g, lazy);
	return result;
}


static GeeIterator* gee_traversable_real_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	GeeIterator* result = NULL;
	Block14Data* _data14_;
	GeeFoldFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gconstpointer _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_data14_->a_type = a_type;
	_data14_->a_dup_func = a_dup_func;
	_data14_->a_destroy_func = a_destroy_func;
	_tmp0_ = f;
	_tmp0__target = f_target;
	_data14_->f = _tmp0_;
	_data14_->f_target = _tmp0__target;
	_tmp1_ = seed;
	_a_destroy_func0 (_data14_->seed);
	_data14_->seed = _tmp1_;
	_data14_->seed_emitted = FALSE;
	_tmp2_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda11__gee_stream_func, block14_data_ref (_data14_), block14_data_unref);
	result = _tmp2_;
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return result;
}


GeeIterator* gee_traversable_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->scan (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
}


/**
 * Creates a new iterator that contains only values that fullfills the
 * predicate.
 *
 * Note: When the method is called on {@link Iterator} using the parent
 *    iterator is not allowed befor the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element. The resulting iterator is {@link Iterator.valid} if parent
 *    iterator is {@link Iterator.valid} and value it is pointing on
 *    fullfills the predicate.
 *
 * @param pred predicate to check should the value be retained
 * @return Iterator containing values of subsequent values of seed
 */
static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		GeeTraversable * self;
		self = _data16_->self;
		(_data16_->pred_target_destroy_notify == NULL) ? NULL : (_data16_->pred_target_destroy_notify (_data16_->pred_target), NULL);
		_data16_->pred = NULL;
		_data16_->pred_target = NULL;
		_data16_->pred_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}


static GeeTraversableStream __lambda13_ (Block16Data* _data16_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_ = 0;
	self = _data16_->self;
	_tmp0_ = state;
	switch (_tmp0_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			gpointer g = NULL;
			GeeLazy* _tmp1_ = NULL;
			gpointer _tmp2_ = NULL;
			GeePredicate _tmp3_ = NULL;
			void* _tmp3__target = NULL;
			gconstpointer _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			_tmp1_ = item;
			_tmp2_ = gee_lazy_get (_tmp1_);
			g = _tmp2_;
			_tmp3_ = _data16_->pred;
			_tmp3__target = _data16_->pred_target;
			_tmp4_ = g;
			_tmp5_ = _tmp3_ (_tmp4_, _tmp3__target);
			if (_tmp5_) {
				GeeLazy* _tmp6_ = NULL;
				GeeLazy* _tmp7_ = NULL;
				_tmp6_ = item;
				_tmp7_ = _gee_lazy_ref0 (_tmp6_);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp7_;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
			((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_gee_lazy_unref0 (item);
	if (val) {
		*val = _vala_val;
	} else {
		_gee_lazy_unref0 (_vala_val);
	}
}


static GeeTraversableStream ___lambda13__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda13_ (self, state, g, lazy);
	return result;
}


static GeeIterator* gee_traversable_real_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify) {
	GeeIterator* result = NULL;
	Block16Data* _data16_;
	GeePredicate _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeIterator* _tmp1_ = NULL;
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = pred;
	_tmp0__target = pred_target;
	(_data16_->pred_target_destroy_notify == NULL) ? NULL : (_data16_->pred_target_destroy_notify (_data16_->pred_target), NULL);
	_data16_->pred = NULL;
	_data16_->pred_target = NULL;
	_data16_->pred_target_destroy_notify = NULL;
	_data16_->pred = _tmp0_;
	_data16_->pred_target = _tmp0__target;
	_data16_->pred_target_destroy_notify = pred_target_destroy_notify;
	_tmp1_ = gee_traversable_stream (self, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ___lambda13__gee_stream_func, block16_data_ref (_data16_), block16_data_unref);
	result = _tmp1_;
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return result;
}


GeeIterator* gee_traversable_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->filter (self, pred, pred_target, pred_target_destroy_notify);
}


/**
 * Creates a new iterator which contains elements from iterable. The
 * first argument states the offset i.e. number of elements the iterator
 * skips by default.
 *
 * Note: In {@link Iterator} implementation resulting iterator is
 *    {@link Iterator.valid} when parent iterator is
 *    {@link Iterator.valid} and the offset is 0. Using the parent
 *    iterator is not allowed before the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element.
 *
 * @param offset the offset to first element the iterator is pointing to
 * @param length maximum number of elements iterator may return. Negative
 *        value means that the number is unbounded
 */
static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		GeeTraversable * self;
		self = _data17_->self;
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}


static GeeTraversableStream __lambda14_ (Block17Data* _data17_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_ = 0;
	self = _data17_->self;
	_tmp0_ = state;
	switch (_tmp0_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			gint _tmp1_ = 0;
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			_tmp1_ = _data17_->offset;
			if (_tmp1_ > 0) {
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				gint _tmp2_ = 0;
				_tmp2_ = _data17_->length;
				if (_tmp2_ > 0) {
					GeeTraversableStream _tmp3_ = 0;
					gint _tmp4_ = 0;
					GeeTraversableStream _tmp5_ = 0;
					_tmp4_ = _data17_->length;
					if (_tmp4_ != 0) {
						_tmp3_ = GEE_TRAVERSABLE_STREAM_CONTINUE;
					} else {
						_tmp3_ = GEE_TRAVERSABLE_STREAM_END;
					}
					_tmp5_ = _tmp3_;
					result = _tmp5_;
					_gee_lazy_unref0 (item);
					if (val) {
						*val = _vala_val;
					} else {
						_gee_lazy_unref0 (_vala_val);
					}
					return result;
				} else {
					gint _tmp6_ = 0;
					_tmp6_ = _data17_->length;
					if (_tmp6_ == 0) {
						result = GEE_TRAVERSABLE_STREAM_END;
						_gee_lazy_unref0 (item);
						if (val) {
							*val = _vala_val;
						} else {
							_gee_lazy_unref0 (_vala_val);
						}
						return result;
					} else {
						result = GEE_TRAVERSABLE_STREAM_CONTINUE;
						_gee_lazy_unref0 (item);
						if (val) {
							*val = _vala_val;
						} else {
							_gee_lazy_unref0 (_vala_val);
						}
						return result;
					}
				}
			}
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			gint _tmp7_ = 0;
			_tmp7_ = _data17_->offset;
			if (_tmp7_ == 0) {
				GeeLazy* _tmp8_ = NULL;
				GeeLazy* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				_tmp8_ = item;
				_tmp9_ = _gee_lazy_ref0 (_tmp8_);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp9_;
				_tmp10_ = _data17_->length;
				_data17_->length = _tmp10_ - 1;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				gint _tmp11_ = 0;
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				_tmp11_ = _data17_->offset;
				_data17_->offset = _tmp11_ - 1;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_gee_lazy_unref0 (item);
	if (val) {
		*val = _vala_val;
	} else {
		_gee_lazy_unref0 (_vala_val);
	}
}


static GeeTraversableStream ___lambda14__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda14_ (self, state, g, lazy);
	return result;
}


static GeeIterator* gee_traversable_real_chop (GeeTraversable* self, gint offset, gint length) {
	GeeIterator* result = NULL;
	Block17Data* _data17_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeIterator* _tmp3_ = NULL;
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = offset;
	_data17_->offset = _tmp0_;
	_tmp1_ = length;
	_data17_->length = _tmp1_;
	_tmp2_ = _data17_->offset;
	_vala_assert (_tmp2_ >= 0, "offset >= 0");
	_tmp3_ = gee_traversable_stream (self, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ___lambda14__gee_stream_func, block17_data_ref (_data17_), block17_data_unref);
	result = _tmp3_;
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}


GeeIterator* gee_traversable_chop (GeeTraversable* self, gint offset, gint length) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->chop (self, offset, length);
}


GType gee_traversable_get_element_type (GeeTraversable* self) {
	g_return_val_if_fail (self != NULL, 0UL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->get_element_type (self);
}


static GType gee_traversable_real_get_element_type (GeeTraversable* base) {
	GType result;
	GeeTraversable* self;
	self = base;
	result = GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self);
	return result;
}


static void gee_traversable_base_init (GeeTraversableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		iface->stream = gee_traversable_real_stream;
		iface->fold = gee_traversable_real_fold;
		iface->map = gee_traversable_real_map;
		iface->scan = gee_traversable_real_scan;
		iface->filter = gee_traversable_real_filter;
		iface->chop = gee_traversable_real_chop;
		iface->get_element_type = gee_traversable_real_get_element_type;
	}
}


/**
 * It's a common interface for {@link Iterator} and {@link Iterable}. It
 * provides a fast, high level functions.
 *
 * ''{@link Iterator} implementation:'' Please note that most of the functions
 * affect the state of the iterator by moving it forward.
 * Even if the iterator is {@link BidirIterator} it ''must not''
 * rewind the state.
 *
 * ''{@link Iterable} implementation:'' validy ({@link Iterator.valid})
 * of returned iterator is the same as for invalid
 * iterator. In other words the following code is semantically equivalent:
 *
 * {{{
 *     var x = iterable.function (args);
 *     var x = iterable.iterator ().function(args);
 * }}}
 *
 * @since 0.7.0
 */
GType gee_traversable_get_type (void) {
	static volatile gsize gee_traversable_type_id__volatile = 0;
	if (g_once_init_enter (&gee_traversable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTraversableIface), (GBaseInitFunc) gee_traversable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_traversable_type_id;
		gee_traversable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeTraversable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_traversable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_traversable_type_id__volatile, gee_traversable_type_id);
	}
	return gee_traversable_type_id__volatile;
}



