/* arrayqueue.c generated by valac 0.20.1.66-2886, the Vala compiler
 * generated from arrayqueue.vala, do not modify */

/* arrayqueue.vala
 *
 * Copyright (C) 2012  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_ABSTRACT_QUEUE (gee_abstract_queue_get_type ())
#define GEE_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue))
#define GEE_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))
#define GEE_IS_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_IS_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_ABSTRACT_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))

typedef struct _GeeAbstractQueue GeeAbstractQueue;
typedef struct _GeeAbstractQueueClass GeeAbstractQueueClass;
typedef struct _GeeAbstractQueuePrivate GeeAbstractQueuePrivate;

#define GEE_TYPE_DEQUE (gee_deque_get_type ())
#define GEE_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_DEQUE, GeeDeque))
#define GEE_IS_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_DEQUE))
#define GEE_DEQUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_DEQUE, GeeDequeIface))

typedef struct _GeeDeque GeeDeque;
typedef struct _GeeDequeIface GeeDequeIface;

#define GEE_TYPE_ARRAY_QUEUE (gee_array_queue_get_type ())
#define GEE_ARRAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue))
#define GEE_ARRAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueueClass))
#define GEE_IS_ARRAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_QUEUE))
#define GEE_IS_ARRAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_QUEUE))
#define GEE_ARRAY_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueueClass))

typedef struct _GeeArrayQueue GeeArrayQueue;
typedef struct _GeeArrayQueueClass GeeArrayQueueClass;
typedef struct _GeeArrayQueuePrivate GeeArrayQueuePrivate;

#define GEE_ARRAY_QUEUE_TYPE_ITERATOR (gee_array_queue_iterator_get_type ())
#define GEE_ARRAY_QUEUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator))
#define GEE_ARRAY_QUEUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorClass))
#define GEE_ARRAY_QUEUE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR))
#define GEE_ARRAY_QUEUE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_ARRAY_QUEUE_TYPE_ITERATOR))
#define GEE_ARRAY_QUEUE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorClass))

typedef struct _GeeArrayQueueIterator GeeArrayQueueIterator;
typedef struct _GeeArrayQueueIteratorClass GeeArrayQueueIteratorClass;
typedef struct _GeeArrayQueueIteratorPrivate GeeArrayQueueIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, int* result_length1);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeQueue* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeQueue* self);
	GDestroyNotify (*get_g_destroy_func) (GeeQueue* self);
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeAbstractQueue {
	GeeAbstractCollection parent_instance;
	GeeAbstractQueuePrivate * priv;
};

struct _GeeAbstractQueueClass {
	GeeAbstractCollectionClass parent_class;
	gpointer (*peek) (GeeAbstractQueue* self);
	gpointer (*poll) (GeeAbstractQueue* self);
	void (*reserved0) (GeeAbstractQueue* self);
	void (*reserved1) (GeeAbstractQueue* self);
	void (*reserved2) (GeeAbstractQueue* self);
	void (*reserved3) (GeeAbstractQueue* self);
	void (*reserved4) (GeeAbstractQueue* self);
	void (*reserved5) (GeeAbstractQueue* self);
	void (*reserved6) (GeeAbstractQueue* self);
	void (*reserved7) (GeeAbstractQueue* self);
	void (*reserved8) (GeeAbstractQueue* self);
	void (*reserved9) (GeeAbstractQueue* self);
	gint (*get_capacity) (GeeAbstractQueue* self);
	gint (*get_remaining_capacity) (GeeAbstractQueue* self);
	gboolean (*get_is_full) (GeeAbstractQueue* self);
};

struct _GeeDequeIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeDeque* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeDeque* self);
	GDestroyNotify (*get_g_destroy_func) (GeeDeque* self);
	gboolean (*offer_head) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_head) (GeeDeque* self);
	gpointer (*poll_head) (GeeDeque* self);
	gint (*drain_head) (GeeDeque* self, GeeCollection* recipient, gint amount);
	gboolean (*offer_tail) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_tail) (GeeDeque* self);
	gpointer (*poll_tail) (GeeDeque* self);
	gint (*drain_tail) (GeeDeque* self, GeeCollection* recipient, gint amount);
};

struct _GeeArrayQueue {
	GeeAbstractQueue parent_instance;
	GeeArrayQueuePrivate * priv;
};

struct _GeeArrayQueueClass {
	GeeAbstractQueueClass parent_class;
};

typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
struct _GeeArrayQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeEqualDataFunc _equal_func;
	gpointer _equal_func_target;
	GDestroyNotify _equal_func_target_destroy_notify;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _start;
	gint _length;
	gint _stamp;
};

struct _GeeArrayQueueIterator {
	GObject parent_instance;
	GeeArrayQueueIteratorPrivate * priv;
};

struct _GeeArrayQueueIteratorClass {
	GObjectClass parent_class;
};

struct _GeeArrayQueueIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeArrayQueue* _queue;
	gint _stamp;
	gint _offset;
	gboolean _removed;
};


static gpointer gee_array_queue_parent_class = NULL;
static gpointer gee_array_queue_iterator_parent_class = NULL;
static GeeTraversableIface* gee_array_queue_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface* gee_array_queue_iterator_gee_iterator_parent_iface = NULL;
static GeeDequeIface* gee_array_queue_gee_deque_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_abstract_queue_get_type (void) G_GNUC_CONST;
GType gee_deque_get_type (void) G_GNUC_CONST;
GType gee_array_queue_get_type (void) G_GNUC_CONST;
#define GEE_ARRAY_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueuePrivate))
enum  {
	GEE_ARRAY_QUEUE_DUMMY_PROPERTY,
	GEE_ARRAY_QUEUE_G_TYPE,
	GEE_ARRAY_QUEUE_G_DUP_FUNC,
	GEE_ARRAY_QUEUE_G_DESTROY_FUNC,
	GEE_ARRAY_QUEUE_SIZE,
	GEE_ARRAY_QUEUE_IS_EMPTY,
	GEE_ARRAY_QUEUE_READ_ONLY,
	GEE_ARRAY_QUEUE_CAPACITY,
	GEE_ARRAY_QUEUE_REMAINING_CAPACITY,
	GEE_ARRAY_QUEUE_IS_FULL
};
GeeArrayQueue* gee_array_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeArrayQueue* gee_array_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeAbstractQueue* gee_abstract_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeEqualDataFunc gee_functions_get_equal_func_for (GType t, void** result_target, GDestroyNotify* result_target_destroy_notify);
static void gee_array_queue_set_equal_func (GeeArrayQueue* self, GeeEqualDataFunc value, gpointer value_target);
static GeeIterator* gee_array_queue_real_iterator (GeeAbstractCollection* base);
static GeeArrayQueueIterator* gee_array_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue);
static GeeArrayQueueIterator* gee_array_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue);
static GType gee_array_queue_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean gee_array_queue_real_add (GeeAbstractCollection* base, gconstpointer element);
gboolean gee_deque_offer_tail (GeeDeque* self, gconstpointer element);
static gboolean gee_array_queue_real_contains (GeeAbstractCollection* base, gconstpointer item);
static gint gee_array_queue_find_index (GeeArrayQueue* self, gconstpointer item);
static gboolean gee_array_queue_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_array_queue_remove_at (GeeArrayQueue* self, gint index);
static void gee_array_queue_real_clear (GeeAbstractCollection* base);
static gboolean gee_array_queue_real_foreach (GeeAbstractCollection* base, GeeForallFunc f, void* f_target);
static gpointer gee_array_queue_real_peek (GeeAbstractQueue* base);
gpointer gee_deque_peek_head (GeeDeque* self);
static gpointer gee_array_queue_real_poll (GeeAbstractQueue* base);
gpointer gee_deque_poll_head (GeeDeque* self);
static gboolean gee_array_queue_real_offer_head (GeeDeque* base, gconstpointer element);
static void gee_array_queue_grow_if_needed (GeeArrayQueue* self);
static gpointer gee_array_queue_real_peek_head (GeeDeque* base);
static gpointer gee_array_queue_real_poll_head (GeeDeque* base);
static gint gee_array_queue_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount);
gint gee_queue_drain (GeeQueue* self, GeeCollection* recipient, gint amount);
static gboolean gee_array_queue_real_offer_tail (GeeDeque* base, gconstpointer element);
static gpointer gee_array_queue_real_peek_tail (GeeDeque* base);
static gpointer gee_array_queue_real_poll_tail (GeeDeque* base);
static gint gee_array_queue_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount);
gpointer gee_deque_poll_tail (GeeDeque* self);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
GeeEqualDataFunc gee_array_queue_get_equal_func (GeeArrayQueue* self, gpointer* result_target);
gboolean gee_array_queue_get_is_empty (GeeArrayQueue* self);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
#define GEE_ARRAY_QUEUE_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorPrivate))
enum  {
	GEE_ARRAY_QUEUE_ITERATOR_DUMMY_PROPERTY,
	GEE_ARRAY_QUEUE_ITERATOR_G_TYPE,
	GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC,
	GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC,
	GEE_ARRAY_QUEUE_ITERATOR_VALID,
	GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY
};
static gboolean gee_array_queue_iterator_real_next (GeeIterator* base);
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_array_queue_iterator_real_has_next (GeeIterator* base);
static gpointer gee_array_queue_iterator_real_get (GeeIterator* base);
static void gee_array_queue_iterator_real_remove (GeeIterator* base);
static gboolean gee_array_queue_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
gboolean gee_iterator_get_valid (GeeIterator* self);
static void gee_array_queue_iterator_finalize (GObject* obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
static void _vala_gee_array_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_array_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_array_queue_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
gint gee_abstract_queue_get_capacity (GeeAbstractQueue* self);
gint gee_abstract_queue_get_remaining_capacity (GeeAbstractQueue* self);
gboolean gee_abstract_queue_get_is_full (GeeAbstractQueue* self);
static void _vala_gee_array_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_array_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);


/**
 * Constructs a new, empty array queue.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeArrayQueue* gee_array_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	GeeArrayQueue * self = NULL;
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeEqualDataFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	gpointer* _tmp5_ = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) gee_abstract_queue_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_type = g_type;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = equal_func;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__target = equal_func_target;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp0_ == NULL) {
#line 466 "arrayqueue.c"
		void* _tmp1_ = NULL;
		GDestroyNotify _tmp2_ = NULL;
		GeeEqualDataFunc _tmp3_ = NULL;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_ = gee_functions_get_equal_func_for (g_type, &_tmp1_, &_tmp2_);
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func = NULL;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func_target = NULL;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func_target_destroy_notify = NULL;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func = _tmp3_;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func_target = _tmp1_;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func_target_destroy_notify = _tmp2_;
#line 486 "arrayqueue.c"
	}
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = equal_func;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4__target = equal_func_target;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_set_equal_func (self, _tmp4_, _tmp4__target);
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = g_new0 (gpointer, 10);
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) g_destroy_func), NULL);
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_items = _tmp5_;
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_items_length1 = 10;
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->__items_size_ = self->priv->_items_length1;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	equal_func = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	equal_func_target = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	equal_func_target_destroy_notify = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self;
#line 514 "arrayqueue.c"
}


GeeArrayQueue* gee_array_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return gee_array_queue_construct (GEE_TYPE_ARRAY_QUEUE, g_type, g_dup_func, g_destroy_func, equal_func, equal_func_target, equal_func_target_destroy_notify);
#line 521 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_array_queue_real_iterator (GeeAbstractCollection* base) {
	GeeArrayQueue * self;
	GeeIterator* result = NULL;
	GeeArrayQueueIterator* _tmp0_ = NULL;
#line 84 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = gee_array_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = (GeeIterator*) _tmp0_;
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 540 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_add (GeeAbstractCollection* base, gconstpointer element) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 91 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = element;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = gee_deque_offer_tail ((GeeDeque*) self, _tmp0_);
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp1_;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 562 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = item;
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = gee_array_queue_find_index (self, _tmp0_);
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp1_ != (-1);
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 584 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint index = 0;
	gconstpointer _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_stamp;
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp0_ + 1;
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = item;
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = gee_array_queue_find_index (self, _tmp1_);
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	index = _tmp2_;
#line 108 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = index;
#line 108 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp3_ == (-1)) {
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = FALSE;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 619 "arrayqueue.c"
	} else {
		gint _tmp4_ = 0;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp4_ = index;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		gee_array_queue_remove_at (self, _tmp4_);
#line 112 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = TRUE;
#line 112 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 630 "arrayqueue.c"
	}
}


/**
 * {@inheritDoc}
 */
static void gee_array_queue_real_clear (GeeAbstractCollection* base) {
	GeeArrayQueue * self;
	gint _tmp0_ = 0;
	gint _tmp11_ = 0;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_stamp;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp0_ + 1;
#line 648 "arrayqueue.c"
	{
		gint i = 0;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		i = 0;
#line 653 "arrayqueue.c"
		{
			gboolean _tmp1_ = FALSE;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp1_ = TRUE;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			while (TRUE) {
#line 660 "arrayqueue.c"
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gpointer* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gpointer* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gpointer _tmp10_ = NULL;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp2_ = _tmp1_;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp2_) {
#line 675 "arrayqueue.c"
					gint _tmp3_ = 0;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp3_ = i;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					i = _tmp3_ + 1;
#line 681 "arrayqueue.c"
				}
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp1_ = FALSE;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp4_ = i;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp5_ = self->priv->_length;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!(_tmp4_ < _tmp5_)) {
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					break;
#line 693 "arrayqueue.c"
				}
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6_ = self->priv->_items;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6__length1 = self->priv->_items_length1;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp7_ = self->priv->_start;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp8_ = i;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp9_ = self->priv->_items;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp9__length1 = self->priv->_items_length1;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				((_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1] = (self->priv->g_destroy_func (_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1]), NULL));
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1] = NULL;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp10_ = _tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1];
#line 713 "arrayqueue.c"
			}
		}
	}
#line 124 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_length = 0;
#line 124 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp11_ = self->priv->_length;
#line 124 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_start = _tmp11_;
#line 723 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_foreach (GeeAbstractCollection* base, GeeForallFunc f, void* f_target) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 735 "arrayqueue.c"
	{
		gint i = 0;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		i = 0;
#line 740 "arrayqueue.c"
		{
			gboolean _tmp0_ = FALSE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp0_ = TRUE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			while (TRUE) {
#line 747 "arrayqueue.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				GeeForallFunc _tmp5_ = NULL;
				void* _tmp5__target = NULL;
				gpointer* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gpointer* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gconstpointer _tmp10_ = NULL;
				gpointer _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp1_ = _tmp0_;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp1_) {
#line 766 "arrayqueue.c"
					gint _tmp2_ = 0;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp2_ = i;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					i = _tmp2_ + 1;
#line 772 "arrayqueue.c"
				}
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp0_ = FALSE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp3_ = i;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp4_ = self->priv->_length;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					break;
#line 784 "arrayqueue.c"
				}
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp5_ = f;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp5__target = f_target;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6_ = self->priv->_items;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6__length1 = self->priv->_items_length1;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp7_ = self->priv->_start;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp8_ = i;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp9_ = self->priv->_items;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp9__length1 = self->priv->_items_length1;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp10_ = _tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1];
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp11_ = ((_tmp10_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp10_) : ((gpointer) _tmp10_);
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp12_ = _tmp5_ (_tmp11_, _tmp5__target);
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp12_) {
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					result = FALSE;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					return result;
#line 814 "arrayqueue.c"
				}
			}
		}
	}
#line 136 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = TRUE;
#line 136 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 823 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_peek (GeeAbstractQueue* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = gee_deque_peek_head ((GeeDeque*) self);
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp0_;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 842 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_poll (GeeAbstractQueue* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = gee_deque_poll_head ((GeeDeque*) self);
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp0_;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 861 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_offer_head (GeeDeque* base, gconstpointer element) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gpointer* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gpointer* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gpointer* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gconstpointer _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
	gpointer _tmp8_ = NULL;
	gint _tmp9_ = 0;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_grow_if_needed (self);
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_start;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_items;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2__length1 = self->priv->_items_length1;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_start = ((_tmp0__length1 + _tmp1_) - 1) % _tmp2__length1;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_length;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_length = _tmp3_ + 1;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_items;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4__length1 = self->priv->_items_length1;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = self->priv->_start;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = element;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	((_tmp4_[_tmp5_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp4_[_tmp5_] = (self->priv->g_destroy_func (_tmp4_[_tmp5_]), NULL));
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_[_tmp5_] = _tmp7_;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp8_ = _tmp4_[_tmp5_];
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp9_ = self->priv->_stamp;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp9_ + 1;
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = TRUE;
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 928 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_peek_head (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gconstpointer _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_start;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp3_;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 959 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_poll_head (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 175 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_stamp;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp0_ + 1;
#line 177 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_length;
#line 177 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp1_ == 0) {
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_start = 0;
#line 179 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = NULL;
#line 179 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 987 "arrayqueue.c"
	} else {
		gint _tmp2_ = 0;
		gpointer _result_ = NULL;
		gpointer* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		gint _tmp4_ = 0;
		gpointer _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gpointer* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gpointer _tmp8_ = NULL;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = self->priv->_length;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_length = _tmp2_ - 1;
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_ = self->priv->_items;
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3__length1 = self->priv->_items_length1;
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp4_ = self->priv->_start;
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp5_ = _tmp3_[_tmp4_];
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_[_tmp4_] = NULL;
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_result_ = _tmp5_;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_ = self->priv->_start;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7_ = self->priv->_items;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7__length1 = self->priv->_items_length1;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_start = (_tmp6_ + 1) % _tmp7__length1;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp8_ = _result_;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_result_ = NULL;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = _tmp8_;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		((_result_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_result_ = (self->priv->g_destroy_func (_result_), NULL));
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 1033 "arrayqueue.c"
	}
}


/**
 * {@inheritDoc}
 */
static gint gee_array_queue_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeArrayQueue * self;
	gint result = 0;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = recipient;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = amount;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = gee_queue_drain ((GeeQueue*) self, _tmp0_, _tmp1_);
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp2_;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1061 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_offer_tail (GeeDeque* base, gconstpointer element) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gpointer* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gpointer* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gconstpointer _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	gint _tmp7_ = 0;
#line 198 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_grow_if_needed (self);
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_start;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_length;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_length = _tmp2_ + 1;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_items;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3__length1 = self->priv->_items_length1;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = element;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	((_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1] = (self->priv->g_destroy_func (_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1]), NULL));
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1] = _tmp5_;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = _tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1];
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp7_ = self->priv->_stamp;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp7_ + 1;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = TRUE;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1117 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_peek_tail (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gpointer* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gpointer* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gconstpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_items;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1__length1 = self->priv->_items_length1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_start;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_length;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_items;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4__length1 = self->priv->_items_length1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = _tmp0_[(((_tmp1__length1 + _tmp2_) + _tmp3_) - 1) % _tmp4__length1];
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp6_;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1163 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_poll_tail (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_stamp;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp0_ + 1;
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_length;
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp1_ == 0) {
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_start = 0;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = NULL;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 1191 "arrayqueue.c"
	} else {
		gpointer* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gpointer* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gpointer* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gpointer _tmp8_ = NULL;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = self->priv->_items;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2__length1 = self->priv->_items_length1;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_ = self->priv->_items;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3__length1 = self->priv->_items_length1;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp4_ = self->priv->_start;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp5_ = self->priv->_length;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_length = _tmp5_ - 1;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_ = self->priv->_length;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7_ = self->priv->_items;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7__length1 = self->priv->_items_length1;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp8_ = _tmp2_[((_tmp3__length1 + _tmp4_) + _tmp6_) % _tmp7__length1];
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_[((_tmp3__length1 + _tmp4_) + _tmp6_) % _tmp7__length1] = NULL;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = _tmp8_;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 1231 "arrayqueue.c"
	}
}


/**
 * {@inheritDoc}
 */
static gint gee_array_queue_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeArrayQueue * self;
	gint result = 0;
	gpointer item = NULL;
	gint drained = 0;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	item = NULL;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	drained = 0;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	while (TRUE) {
#line 1254 "arrayqueue.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gint _tmp2_ = 0;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp8_ = FALSE;
		GeeCollection* _tmp9_ = NULL;
		gconstpointer _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = amount;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (_tmp2_ == (-1)) {
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp1_ = TRUE;
#line 1269 "arrayqueue.c"
		} else {
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp3_ = amount;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			amount = _tmp3_ - 1;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp4_ = amount;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp1_ = _tmp4_ >= 0;
#line 1281 "arrayqueue.c"
		}
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp5_ = _tmp1_;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (_tmp5_) {
#line 1287 "arrayqueue.c"
			gpointer _tmp6_ = NULL;
			gconstpointer _tmp7_ = NULL;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp6_ = gee_deque_poll_tail ((GeeDeque*) self);
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			item = _tmp6_;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp7_ = item;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp0_ = _tmp7_ != NULL;
#line 1300 "arrayqueue.c"
		} else {
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp0_ = FALSE;
#line 1304 "arrayqueue.c"
		}
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp8_ = _tmp0_;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (!_tmp8_) {
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			break;
#line 1312 "arrayqueue.c"
		}
#line 232 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp9_ = recipient;
#line 232 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp10_ = item;
#line 232 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		gee_collection_add (_tmp9_, _tmp10_);
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp11_ = drained;
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		drained = _tmp11_ + 1;
#line 1324 "arrayqueue.c"
	}
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = drained;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1332 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static void gee_array_queue_grow_if_needed (GeeArrayQueue* self) {
	gpointer* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
#line 241 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_if_fail (self != NULL);
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_length;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp0__length1 < (_tmp1_ + 1)) {
#line 1353 "arrayqueue.c"
		gpointer* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gint _tmp3_ = 0;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = self->priv->_items;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2__length1 = self->priv->_items_length1;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_ = 2 * _tmp2__length1;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_items = g_renew (gpointer, self->priv->_items, 2 * _tmp2__length1);
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		(_tmp3_ > self->priv->_items_length1) ? memset (self->priv->_items + self->priv->_items_length1, 0, sizeof (gpointer) * (_tmp3_ - self->priv->_items_length1)) : NULL;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_items_length1 = _tmp3_;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->__items_size_ = _tmp3_;
#line 1371 "arrayqueue.c"
		{
			gint i = 0;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			i = 0;
#line 1376 "arrayqueue.c"
			{
				gboolean _tmp4_ = FALSE;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp4_ = TRUE;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				while (TRUE) {
#line 1383 "arrayqueue.c"
					gboolean _tmp5_ = FALSE;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gpointer* _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					gpointer* _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					gint _tmp13_ = 0;
					gpointer _tmp14_ = NULL;
					gpointer _tmp15_ = NULL;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp5_ = _tmp4_;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					if (!_tmp5_) {
#line 1400 "arrayqueue.c"
						gint _tmp6_ = 0;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
						_tmp6_ = i;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
						i = _tmp6_ + 1;
#line 1406 "arrayqueue.c"
					}
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp4_ = FALSE;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp7_ = i;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp8_ = self->priv->_start;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					if (!(_tmp7_ < _tmp8_)) {
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
						break;
#line 1418 "arrayqueue.c"
					}
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp9_ = self->priv->_items;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp9__length1 = self->priv->_items_length1;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp10_ = self->priv->_length;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp11_ = i;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp12_ = self->priv->_items;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp12__length1 = self->priv->_items_length1;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp13_ = i;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp14_ = _tmp12_[_tmp13_];
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp12_[_tmp13_] = NULL;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					((_tmp9_[_tmp10_ + _tmp11_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp9_[_tmp10_ + _tmp11_] = (self->priv->g_destroy_func (_tmp9_[_tmp10_ + _tmp11_]), NULL));
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp9_[_tmp10_ + _tmp11_] = _tmp14_;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp15_ = _tmp9_[_tmp10_ + _tmp11_];
#line 1444 "arrayqueue.c"
				}
			}
		}
	}
}


static gint gee_array_queue_find_index (GeeArrayQueue* self, gconstpointer item) {
	gint result = 0;
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1456 "arrayqueue.c"
	{
		gint i = 0;
		gint _tmp0_ = 0;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp0_ = self->priv->_start;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		i = _tmp0_;
#line 1464 "arrayqueue.c"
		{
			gboolean _tmp1_ = FALSE;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp1_ = TRUE;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			while (TRUE) {
#line 1471 "arrayqueue.c"
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				gpointer* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GeeEqualDataFunc _tmp9_ = NULL;
				void* _tmp9__target = NULL;
				GeeEqualDataFunc _tmp10_ = NULL;
				void* _tmp10__target = NULL;
				gconstpointer _tmp11_ = NULL;
				gpointer* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				gconstpointer _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp2_ = _tmp1_;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp2_) {
#line 1493 "arrayqueue.c"
					gint _tmp3_ = 0;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp3_ = i;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					i = _tmp3_ + 1;
#line 1499 "arrayqueue.c"
				}
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp1_ = FALSE;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp4_ = i;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp5_ = self->priv->_items;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp5__length1 = self->priv->_items_length1;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6_ = self->priv->_start;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp7_ = self->priv->_length;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp8_ = MIN (_tmp5__length1, _tmp6_ + _tmp7_);
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!(_tmp4_ < _tmp8_)) {
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					break;
#line 1519 "arrayqueue.c"
				}
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp9_ = gee_array_queue_get_equal_func (self, &_tmp9__target);
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp10_ = _tmp9_;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp10__target = _tmp9__target;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp11_ = item;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp12_ = self->priv->_items;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp12__length1 = self->priv->_items_length1;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp13_ = i;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp14_ = _tmp12_[_tmp13_];
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp15_ = _tmp10_ (_tmp11_, _tmp14_, _tmp10__target);
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (_tmp15_) {
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					result = i;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					return result;
#line 1545 "arrayqueue.c"
				}
			}
		}
	}
	{
		gint i = 0;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		i = 0;
#line 1554 "arrayqueue.c"
		{
			gboolean _tmp16_ = FALSE;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp16_ = TRUE;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			while (TRUE) {
#line 1561 "arrayqueue.c"
				gboolean _tmp17_ = FALSE;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gpointer* _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				GeeEqualDataFunc _tmp23_ = NULL;
				void* _tmp23__target = NULL;
				GeeEqualDataFunc _tmp24_ = NULL;
				void* _tmp24__target = NULL;
				gconstpointer _tmp25_ = NULL;
				gpointer* _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				gconstpointer _tmp28_ = NULL;
				gboolean _tmp29_ = FALSE;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp17_ = _tmp16_;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp17_) {
#line 1582 "arrayqueue.c"
					gint _tmp18_ = 0;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp18_ = i;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					i = _tmp18_ + 1;
#line 1588 "arrayqueue.c"
				}
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp16_ = FALSE;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp19_ = i;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp20_ = self->priv->_start;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp21_ = self->priv->_length;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp22_ = self->priv->_items;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp22__length1 = self->priv->_items_length1;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!(_tmp19_ < ((_tmp20_ + _tmp21_) - _tmp22__length1))) {
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					break;
#line 1606 "arrayqueue.c"
				}
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp23_ = gee_array_queue_get_equal_func (self, &_tmp23__target);
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp24_ = _tmp23_;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp24__target = _tmp23__target;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp25_ = item;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp26_ = self->priv->_items;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp26__length1 = self->priv->_items_length1;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp27_ = i;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp28_ = _tmp26_[_tmp27_];
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp29_ = _tmp24_ (_tmp25_, _tmp28_, _tmp24__target);
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (_tmp29_) {
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					result = i;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					return result;
#line 1632 "arrayqueue.c"
				}
			}
		}
	}
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = -1;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1641 "arrayqueue.c"
}


static void gee_array_queue_remove_at (GeeArrayQueue* self, gint index) {
	gint end = 0;
	gpointer* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gpointer* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_if_fail (self != NULL);
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_start;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_length;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_items;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3__length1 = self->priv->_items_length1;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	end = ((((_tmp0__length1 + _tmp1_) + _tmp2_) - 1) % _tmp3__length1) + 1;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = index;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = self->priv->_start;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp4_ == _tmp5_) {
#line 1677 "arrayqueue.c"
		gpointer* _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gint _tmp7_ = 0;
		gpointer _tmp8_ = NULL;
		gint _tmp9_ = 0;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_ = self->priv->_items;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6__length1 = self->priv->_items_length1;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7_ = self->priv->_start;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_start = _tmp7_ + 1;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		((_tmp6_[_tmp7_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp6_[_tmp7_] = (self->priv->g_destroy_func (_tmp6_[_tmp7_]), NULL));
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_[_tmp7_] = NULL;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp8_ = _tmp6_[_tmp7_];
#line 272 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp9_ = self->priv->_length;
#line 272 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_length = _tmp9_ - 1;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return;
#line 1703 "arrayqueue.c"
	} else {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gboolean _tmp15_ = FALSE;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp11_ = index;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp12_ = self->priv->_start;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (_tmp11_ > _tmp12_) {
#line 1715 "arrayqueue.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp13_ = end;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp14_ = self->priv->_start;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp10_ = _tmp13_ <= _tmp14_;
#line 1724 "arrayqueue.c"
		} else {
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp10_ = FALSE;
#line 1728 "arrayqueue.c"
		}
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp15_ = _tmp10_;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (_tmp15_) {
#line 1734 "arrayqueue.c"
			gpointer* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gpointer* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gpointer* _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			gpointer* _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			gpointer* _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			gpointer _tmp25_ = NULL;
			gpointer _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp16_ = self->priv->_items;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp16__length1 = self->priv->_items_length1;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp17_ = index;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			((_tmp16_[_tmp17_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp16_[_tmp17_] = (self->priv->g_destroy_func (_tmp16_[_tmp17_]), NULL));
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp16_[_tmp17_] = NULL;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp18_ = _tmp16_[_tmp17_];
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp19_ = index;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp20_ = index;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp21_ = self->priv->_items;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp21__length1 = self->priv->_items_length1;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_vala_array_move (self->priv->_items, sizeof (gpointer), _tmp19_ + 1, _tmp20_, _tmp21__length1 - 1);
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp22_ = self->priv->_items;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp22__length1 = self->priv->_items_length1;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp23_ = self->priv->_items;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp23__length1 = self->priv->_items_length1;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp24_ = self->priv->_items;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp24__length1 = self->priv->_items_length1;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp25_ = _tmp24_[0];
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp24_[0] = NULL;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			((_tmp22_[_tmp23__length1 - 1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp22_[_tmp23__length1 - 1] = (self->priv->g_destroy_func (_tmp22_[_tmp23__length1 - 1]), NULL));
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp22_[_tmp23__length1 - 1] = _tmp25_;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp26_ = _tmp22_[_tmp23__length1 - 1];
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp27_ = end;
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_vala_array_move (self->priv->_items, sizeof (gpointer), 1, 0, _tmp27_ - 1);
#line 279 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp28_ = self->priv->_length;
#line 279 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			self->priv->_length = _tmp28_ - 1;
#line 1805 "arrayqueue.c"
		} else {
			gpointer* _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			gint _tmp30_ = 0;
			gpointer _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp29_ = self->priv->_items;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp29__length1 = self->priv->_items_length1;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp30_ = index;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			((_tmp29_[_tmp30_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp29_[_tmp30_] = (self->priv->g_destroy_func (_tmp29_[_tmp30_]), NULL));
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp29_[_tmp30_] = NULL;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp31_ = _tmp29_[_tmp30_];
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp32_ = index;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp33_ = index;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp34_ = end;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp35_ = index;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_vala_array_move (self->priv->_items, sizeof (gpointer), _tmp32_ + 1, _tmp33_, _tmp34_ - (_tmp35_ + 1));
#line 283 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp36_ = self->priv->_length;
#line 283 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			self->priv->_length = _tmp36_ - 1;
#line 1842 "arrayqueue.c"
		}
	}
}


GeeEqualDataFunc gee_array_queue_get_equal_func (GeeArrayQueue* self, gpointer* result_target) {
	GeeEqualDataFunc result;
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeEqualDataFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_equal_func;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__target = self->priv->_equal_func_target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1__target = _tmp0__target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	*result_target = _tmp1__target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp1_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1870 "arrayqueue.c"
}


static void gee_array_queue_set_equal_func (GeeArrayQueue* self, GeeEqualDataFunc value, gpointer value_target) {
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = value;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__target = value_target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target_destroy_notify = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func = _tmp0_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target = _tmp0__target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target_destroy_notify = NULL;
#line 1897 "arrayqueue.c"
}


static gint gee_array_queue_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeArrayQueue* self;
	gint _tmp0_ = 0;
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_length;
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp0_;
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1913 "arrayqueue.c"
}


gboolean gee_array_queue_get_is_empty (GeeArrayQueue* self) {
	gboolean result;
	gint _tmp0_ = 0;
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_length;
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp0_ == 0;
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1928 "arrayqueue.c"
}


static gboolean gee_array_queue_real_get_read_only (GeeAbstractCollection* base) {
	gboolean result;
	GeeArrayQueue* self;
#line 64 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 64 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = FALSE;
#line 64 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1941 "arrayqueue.c"
}


static gint gee_array_queue_real_get_capacity (GeeAbstractQueue* base) {
	gint result;
	GeeArrayQueue* self;
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1954 "arrayqueue.c"
}


static gint gee_array_queue_real_get_remaining_capacity (GeeAbstractQueue* base) {
	gint result;
	GeeArrayQueue* self;
#line 74 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 74 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 74 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1967 "arrayqueue.c"
}


static gboolean gee_array_queue_real_get_is_full (GeeAbstractQueue* base) {
	gboolean result;
	GeeArrayQueue* self;
#line 79 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 79 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = FALSE;
#line 79 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1980 "arrayqueue.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 289 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self ? g_object_ref (self) : NULL;
#line 1987 "arrayqueue.c"
}


static GeeArrayQueueIterator* gee_array_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue) {
	GeeArrayQueueIterator * self = NULL;
	GeeArrayQueue* _tmp0_ = NULL;
	GeeArrayQueue* _tmp1_ = NULL;
	GeeArrayQueue* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (queue != NULL, NULL);
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) g_object_new (object_type, NULL);
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_type = g_type;
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 289 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = queue;
#line 289 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 289 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_g_object_unref0 (self->priv->_queue);
#line 289 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_queue = _tmp1_;
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_queue;
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = _tmp2_->priv->_stamp;
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp3_;
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self;
#line 2023 "arrayqueue.c"
}


static GeeArrayQueueIterator* gee_array_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue) {
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return gee_array_queue_iterator_construct (GEE_ARRAY_QUEUE_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, queue);
#line 2030 "arrayqueue.c"
}


static gboolean gee_array_queue_iterator_real_next (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	gboolean result = FALSE;
	GeeArrayQueue* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp == _stamp");
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = gee_iterator_has_next ((GeeIterator*) self);
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp3_) {
#line 2055 "arrayqueue.c"
		gint _tmp4_ = 0;
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp4_ = self->priv->_offset;
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_offset = _tmp4_ + 1;
#line 297 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_removed = FALSE;
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = TRUE;
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 2067 "arrayqueue.c"
	} else {
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = FALSE;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 2073 "arrayqueue.c"
	}
}


static gboolean gee_array_queue_iterator_real_has_next (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	gboolean result = FALSE;
	GeeArrayQueue* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeArrayQueue* _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp == _stamp");
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_offset;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_queue;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = _tmp4_->priv->_length;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = (_tmp3_ + 1) < _tmp5_;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2107 "arrayqueue.c"
}


static gpointer gee_array_queue_iterator_real_get (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	gpointer result = NULL;
	GeeArrayQueue* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	GeeArrayQueue* _tmp5_ = NULL;
	gpointer* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GeeArrayQueue* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GeeArrayQueue* _tmp10_ = NULL;
	gpointer* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gconstpointer _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp == _stamp");
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_offset;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp3_ != (-1), "_offset != -1");
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_removed;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (!_tmp4_, "!_removed");
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = self->priv->_queue;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = _tmp5_->priv->_items;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6__length1 = _tmp5_->priv->_items_length1;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp7_ = self->priv->_queue;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp8_ = _tmp7_->priv->_start;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp9_ = self->priv->_offset;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp10_ = self->priv->_queue;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp11_ = _tmp10_->priv->_items;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp11__length1 = _tmp10_->priv->_items_length1;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp12_ = _tmp6_[(_tmp8_ + _tmp9_) % _tmp11__length1];
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp13_ = ((_tmp12_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp12_) : ((gpointer) _tmp12_);
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp13_;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2174 "arrayqueue.c"
}


static void gee_array_queue_iterator_real_remove (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	GeeArrayQueue* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeArrayQueue* _tmp3_ = NULL;
	GeeArrayQueue* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GeeArrayQueue* _tmp7_ = NULL;
	gpointer* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_->priv->_stamp = _tmp1_ + 1;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp2_ + 1;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp++ == _stamp++");
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_queue;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_queue;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = _tmp4_->priv->_start;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = self->priv->_offset;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp7_ = self->priv->_queue;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp8_ = _tmp7_->priv->_items;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp8__length1 = _tmp7_->priv->_items_length1;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_remove_at (_tmp3_, (_tmp5_ + _tmp6_) % _tmp8__length1);
#line 319 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp9_ = self->priv->_offset;
#line 319 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_offset = _tmp9_ - 1;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_removed = TRUE;
#line 2227 "arrayqueue.c"
}


static gboolean gee_array_queue_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	GeeArrayQueueIterator * self;
	gboolean result = FALSE;
	GeeArrayQueue* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GeeArrayQueue* _tmp25_ = NULL;
	gint _tmp26_ = 0;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 328 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 328 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 328 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 328 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp == _stamp");
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = gee_iterator_get_valid ((GeeIterator*) self);
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = _tmp3_;
#line 329 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (!_tmp4_) {
#line 2257 "arrayqueue.c"
		gint _tmp5_ = 0;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp5_ = self->priv->_offset;
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_offset = _tmp5_ + 1;
#line 331 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_removed = FALSE;
#line 2265 "arrayqueue.c"
	}
	{
		gint i = 0;
		gint _tmp6_ = 0;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_ = self->priv->_offset;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		i = _tmp6_;
#line 2274 "arrayqueue.c"
		{
			gboolean _tmp7_ = FALSE;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp7_ = TRUE;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			while (TRUE) {
#line 2281 "arrayqueue.c"
				gboolean _tmp8_ = FALSE;
				gint _tmp10_ = 0;
				GeeArrayQueue* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				GeeForallFunc _tmp13_ = NULL;
				void* _tmp13__target = NULL;
				GeeArrayQueue* _tmp14_ = NULL;
				gpointer* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				GeeArrayQueue* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				GeeArrayQueue* _tmp19_ = NULL;
				gpointer* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				gconstpointer _tmp21_ = NULL;
				gpointer _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp8_ = _tmp7_;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp8_) {
#line 2304 "arrayqueue.c"
					gint _tmp9_ = 0;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp9_ = i;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					i = _tmp9_ + 1;
#line 2310 "arrayqueue.c"
				}
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp7_ = FALSE;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp10_ = i;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp11_ = self->priv->_queue;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp12_ = _tmp11_->priv->_length;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!(_tmp10_ < _tmp12_)) {
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					break;
#line 2324 "arrayqueue.c"
				}
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp13_ = f;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp13__target = f_target;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp14_ = self->priv->_queue;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp15_ = _tmp14_->priv->_items;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp15__length1 = _tmp14_->priv->_items_length1;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp16_ = self->priv->_queue;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp17_ = _tmp16_->priv->_start;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp18_ = i;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp19_ = self->priv->_queue;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp20_ = _tmp19_->priv->_items;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp20__length1 = _tmp19_->priv->_items_length1;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp21_ = _tmp15_[(_tmp17_ + _tmp18_) % _tmp20__length1];
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp22_ = ((_tmp21_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp21_) : ((gpointer) _tmp21_);
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp23_ = _tmp13_ (_tmp22_, _tmp13__target);
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp23_) {
#line 2356 "arrayqueue.c"
					gint _tmp24_ = 0;
#line 335 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp24_ = i;
#line 335 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					self->priv->_offset = _tmp24_;
#line 336 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					result = FALSE;
#line 336 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					return result;
#line 2366 "arrayqueue.c"
				}
			}
		}
	}
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp25_ = self->priv->_queue;
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp26_ = _tmp25_->priv->_length;
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_offset = _tmp26_ - 1;
#line 340 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = TRUE;
#line 340 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2381 "arrayqueue.c"
}


static gboolean gee_array_queue_iterator_real_get_valid (GeeIterator* base) {
	gboolean result;
	GeeArrayQueueIterator* self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_offset;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp1_ != (-1)) {
#line 2397 "arrayqueue.c"
		gboolean _tmp2_ = FALSE;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = self->priv->_removed;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp0_ = !_tmp2_;
#line 2403 "arrayqueue.c"
	} else {
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp0_ = FALSE;
#line 2407 "arrayqueue.c"
	}
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = _tmp0_;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp3_;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2415 "arrayqueue.c"
}


static gboolean gee_array_queue_iterator_real_get_read_only (GeeIterator* base) {
	gboolean result;
	GeeArrayQueueIterator* self;
#line 325 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 325 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = FALSE;
#line 325 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2428 "arrayqueue.c"
}


static void gee_array_queue_iterator_class_init (GeeArrayQueueIteratorClass * klass) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_iterator_parent_class = g_type_class_peek_parent (klass);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_type_class_add_private (klass, sizeof (GeeArrayQueueIteratorPrivate));
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_queue_iterator_get_property;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_queue_iterator_set_property;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_array_queue_iterator_finalize;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2453 "arrayqueue.c"
}


static GType gee_array_queue_iterator_gee_traversable_get_g_type (GeeArrayQueueIterator* self) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_type;
#line 2460 "arrayqueue.c"
}


static GBoxedCopyFunc gee_array_queue_iterator_gee_traversable_get_g_dup_func (GeeArrayQueueIterator* self) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_dup_func;
#line 2467 "arrayqueue.c"
}


static GDestroyNotify gee_array_queue_iterator_gee_traversable_get_g_destroy_func (GeeArrayQueueIterator* self) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_destroy_func;
#line 2474 "arrayqueue.c"
}


static void gee_array_queue_iterator_gee_traversable_interface_init (GeeTraversableIface * iface) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) gee_array_queue_iterator_real_foreach;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_type = (GType(*)(GeeTraversable*)) gee_array_queue_iterator_gee_traversable_get_g_type;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) gee_array_queue_iterator_gee_traversable_get_g_dup_func;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) gee_array_queue_iterator_gee_traversable_get_g_destroy_func;
#line 2489 "arrayqueue.c"
}


static void gee_array_queue_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->next = (gboolean (*)(GeeIterator*)) gee_array_queue_iterator_real_next;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_array_queue_iterator_real_has_next;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get = (gpointer (*)(GeeIterator*)) gee_array_queue_iterator_real_get;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->remove = (void (*)(GeeIterator*)) gee_array_queue_iterator_real_remove;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_valid = gee_array_queue_iterator_real_get_valid;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_read_only = gee_array_queue_iterator_real_get_read_only;
#line 2508 "arrayqueue.c"
}


static void gee_array_queue_iterator_instance_init (GeeArrayQueueIterator * self) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv = GEE_ARRAY_QUEUE_ITERATOR_GET_PRIVATE (self);
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_offset = -1;
#line 346 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_removed = FALSE;
#line 2519 "arrayqueue.c"
}


static void gee_array_queue_iterator_finalize (GObject* obj) {
	GeeArrayQueueIterator * self;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator);
#line 343 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_g_object_unref0 (self->priv->_queue);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (gee_array_queue_iterator_parent_class)->finalize (obj);
#line 2531 "arrayqueue.c"
}


static GType gee_array_queue_iterator_get_type (void) {
	static volatile gsize gee_array_queue_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_queue_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayQueueIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_queue_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayQueueIterator), 0, (GInstanceInitFunc) gee_array_queue_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_array_queue_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_array_queue_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_queue_iterator_type_id;
		gee_array_queue_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeArrayQueueIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_queue_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_array_queue_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&gee_array_queue_iterator_type_id__volatile, gee_array_queue_iterator_type_id);
	}
	return gee_array_queue_iterator_type_id__volatile;
}


static void _vala_gee_array_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	switch (property_id) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_VALID:
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY:
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2568 "arrayqueue.c"
		default:
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2574 "arrayqueue.c"
	}
}


static void _vala_gee_array_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	switch (property_id) {
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_G_TYPE:
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC:
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC:
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2602 "arrayqueue.c"
		default:
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2608 "arrayqueue.c"
	}
}


static void gee_array_queue_class_init (GeeArrayQueueClass * klass) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_type_class_add_private (klass, sizeof (GeeArrayQueuePrivate));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_array_queue_real_iterator;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_array_queue_real_add;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_array_queue_real_contains;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_array_queue_real_remove;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_array_queue_real_clear;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->foreach = gee_array_queue_real_foreach;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->peek = gee_array_queue_real_peek;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->poll = gee_array_queue_real_poll;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_array_queue_real_get_size;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_array_queue_real_get_read_only;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_capacity = gee_array_queue_real_get_capacity;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_remaining_capacity = gee_array_queue_real_get_remaining_capacity;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_is_full = gee_array_queue_real_get_is_full;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_queue_get_property;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_queue_set_property;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_array_queue_finalize;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2656 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2664 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2670 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_CAPACITY, g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2676 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_REMAINING_CAPACITY, g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2682 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_IS_FULL, g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2688 "arrayqueue.c"
}


static GType gee_array_queue_gee_deque_get_g_type (GeeArrayQueue* self) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_type;
#line 2695 "arrayqueue.c"
}


static GBoxedCopyFunc gee_array_queue_gee_deque_get_g_dup_func (GeeArrayQueue* self) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_dup_func;
#line 2702 "arrayqueue.c"
}


static GDestroyNotify gee_array_queue_gee_deque_get_g_destroy_func (GeeArrayQueue* self) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_destroy_func;
#line 2709 "arrayqueue.c"
}


static void gee_array_queue_gee_deque_interface_init (GeeDequeIface * iface) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->offer_head = (gboolean (*)(GeeDeque*, gconstpointer)) gee_array_queue_real_offer_head;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->peek_head = (gpointer (*)(GeeDeque*)) gee_array_queue_real_peek_head;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->poll_head = (gpointer (*)(GeeDeque*)) gee_array_queue_real_poll_head;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->drain_head = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_array_queue_real_drain_head;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->offer_tail = (gboolean (*)(GeeDeque*, gconstpointer)) gee_array_queue_real_offer_tail;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->peek_tail = (gpointer (*)(GeeDeque*)) gee_array_queue_real_peek_tail;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->poll_tail = (gpointer (*)(GeeDeque*)) gee_array_queue_real_poll_tail;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->drain_tail = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_array_queue_real_drain_tail;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_type = (GType(*)(GeeDeque*)) gee_array_queue_gee_deque_get_g_type;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeDeque*)) gee_array_queue_gee_deque_get_g_dup_func;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeDeque*)) gee_array_queue_gee_deque_get_g_destroy_func;
#line 2738 "arrayqueue.c"
}


static void gee_array_queue_instance_init (GeeArrayQueue * self) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv = GEE_ARRAY_QUEUE_GET_PRIVATE (self);
#line 350 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_start = 0;
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_length = 0;
#line 352 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = 0;
#line 2751 "arrayqueue.c"
}


static void gee_array_queue_finalize (GObject* obj) {
	GeeArrayQueue * self;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target_destroy_notify = NULL;
#line 349 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (gee_array_queue_parent_class)->finalize (obj);
#line 2771 "arrayqueue.c"
}


/**
 * Resizable array implementation of the {@link Deque} interface.
 *
 * The storage array grows automatically when needed.
 *
 * This implementation is pretty good for lookups at the end or random.
 * Because they are stored in an array this structure does not fit for deleting
 * arbitrary elements. For an alternative implementation see {@link LinkedList}.
 *
 * @see LinkedList
 */
GType gee_array_queue_get_type (void) {
	static volatile gsize gee_array_queue_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayQueue), 0, (GInstanceInitFunc) gee_array_queue_instance_init, NULL };
		static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_array_queue_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_queue_type_id;
		gee_array_queue_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_QUEUE, "GeeArrayQueue", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_queue_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
		g_once_init_leave (&gee_array_queue_type_id__volatile, gee_array_queue_type_id);
	}
	return gee_array_queue_type_id__volatile;
}


static void _vala_gee_array_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	switch (property_id) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_SIZE:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_IS_EMPTY:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_array_queue_get_is_empty (self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_READ_ONLY:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_CAPACITY:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_int (value, gee_abstract_queue_get_capacity ((GeeAbstractQueue*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_REMAINING_CAPACITY:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_int (value, gee_abstract_queue_get_remaining_capacity ((GeeAbstractQueue*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_IS_FULL:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_abstract_queue_get_is_full ((GeeAbstractQueue*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2841 "arrayqueue.c"
		default:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2847 "arrayqueue.c"
	}
}


static void _vala_gee_array_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	switch (property_id) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_G_TYPE:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_G_DUP_FUNC:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_G_DESTROY_FUNC:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2875 "arrayqueue.c"
		default:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2881 "arrayqueue.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}



