/* future.c generated by valac 0.23.2, the Vala compiler
 * generated from future.vala, do not modify */

/* future.vala
 *
 * Copyright (C) 2013  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>


#define GEE_TYPE_FUTURE (gee_future_get_type ())
#define GEE_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_FUTURE, GeeFuture))
#define GEE_IS_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_FUTURE))
#define GEE_FUTURE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_FUTURE, GeeFutureIface))

typedef struct _GeeFuture GeeFuture;
typedef struct _GeeFutureIface GeeFutureIface;

#define GEE_TYPE_PROMISE (gee_promise_get_type ())
#define GEE_PROMISE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_PROMISE, GeePromise))
#define GEE_PROMISE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_PROMISE, GeePromiseClass))
#define GEE_IS_PROMISE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_PROMISE))
#define GEE_IS_PROMISE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_PROMISE))
#define GEE_PROMISE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_PROMISE, GeePromiseClass))

typedef struct _GeePromise GeePromise;
typedef struct _GeePromiseClass GeePromiseClass;
typedef struct _Block7Data Block7Data;
#define _gee_promise_unref0(var) ((var == NULL) ? NULL : (var = (gee_promise_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GEE_TYPE_LIGHT_MAP_FUTURE (gee_light_map_future_get_type ())
#define GEE_LIGHT_MAP_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIGHT_MAP_FUTURE, GeeLightMapFuture))
#define GEE_LIGHT_MAP_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LIGHT_MAP_FUTURE, GeeLightMapFutureClass))
#define GEE_IS_LIGHT_MAP_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIGHT_MAP_FUTURE))
#define GEE_IS_LIGHT_MAP_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LIGHT_MAP_FUTURE))
#define GEE_LIGHT_MAP_FUTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LIGHT_MAP_FUTURE, GeeLightMapFutureClass))

typedef struct _GeeLightMapFuture GeeLightMapFuture;
typedef struct _GeeLightMapFutureClass GeeLightMapFutureClass;
typedef struct _Block8Data Block8Data;
typedef struct _GeeFutureDoZipData GeeFutureDoZipData;
typedef struct _Block9Data Block9Data;
typedef struct _GeeFutureDoFlatMapData GeeFutureDoFlatMapData;

#define GEE_FUTURE_TYPE_SOURCE_FUNC_ARRAY_ELEMENT (gee_future_source_func_array_element_get_type ())
typedef struct _GeeFutureSourceFuncArrayElement GeeFutureSourceFuncArrayElement;

typedef enum  {
	GEE_FUTURE_ERROR_ABANDON_PROMISE,
	GEE_FUTURE_ERROR_EXCEPTION
} GeeFutureError;
#define GEE_FUTURE_ERROR gee_future_error_quark ()
typedef gpointer (*GeeFutureMapFunc) (gconstpointer value, void* user_data);
typedef gconstpointer (*GeeFutureLightMapFunc) (gconstpointer value, void* user_data);
typedef gpointer (*GeeFutureZipFunc) (gconstpointer a, gconstpointer b, void* user_data);
typedef GeeFuture* (*GeeFutureFlatMapFunc) (gconstpointer value, void* user_data);
struct _GeeFutureIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeFuture* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeFuture* self);
	GDestroyNotify (*get_g_destroy_func) (GeeFuture* self);
	gconstpointer (*wait) (GeeFuture* self, GError** error);
	gboolean (*wait_until) (GeeFuture* self, gint64 end_time, gconstpointer* value, GError** error);
	void (*wait_async) (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gconstpointer (*wait_finish) (GeeFuture* self, GAsyncResult* _res_, GError** error);
	GeeFuture* (*map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
	GeeFuture* (*light_map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target);
	GeeFuture* (*zip) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second);
	GeeFuture* (*flat_map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
	gconstpointer (*get_value) (GeeFuture* self);
	gboolean (*get_ready) (GeeFuture* self);
	GError* (*get_exception) (GeeFuture* self);
	GeeFuture* (*light_map_fixed) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
};

struct _Block7Data {
	int _ref_count_;
	GeeFuture* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeePromise* promise;
	GeeFutureMapFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _Block8Data {
	int _ref_count_;
	GeeFuture* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
};

struct _GeeFutureDoZipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GeeFutureZipFunc zip_func;
	gpointer zip_func_target;
	GDestroyNotify zip_func_target_destroy_notify;
	GeeFuture* first;
	GeeFuture* second;
	GeePromise* _result_;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
	GType c_type;
	GBoxedCopyFunc c_dup_func;
	GDestroyNotify c_destroy_func;
	gpointer left;
	GeeFuture* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gpointer right;
	GeeFuture* _tmp3_;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	GeePromise* _tmp6_;
	GeeFutureZipFunc _tmp7_;
	void* _tmp7__target;
	gconstpointer _tmp8_;
	gconstpointer _tmp9_;
	gpointer _tmp10_;
	GError* ex;
	GeePromise* _tmp11_;
	GError* _tmp12_;
	GError * _inner_error_;
};

struct _Block9Data {
	int _ref_count_;
	GeeFuture* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
};

struct _GeeFutureDoFlatMapData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GeeFutureFlatMapFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
	GeeFuture* future;
	GeePromise* promise;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
	gpointer input;
	GeeFuture* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gpointer output;
	GeeFutureFlatMapFunc _tmp3_;
	void* _tmp3__target;
	gconstpointer _tmp4_;
	GeeFuture* _tmp5_;
	GeeFuture* _tmp6_;
	gconstpointer _tmp7_;
	gpointer _tmp8_;
	gpointer _tmp9_;
	GeePromise* _tmp10_;
	gpointer _tmp11_;
	GError* ex;
	GeePromise* _tmp12_;
	GError* _tmp13_;
	GError * _inner_error_;
};

struct _GeeFutureSourceFuncArrayElement {
	GSourceFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};



GQuark gee_future_error_quark (void);
GType gee_future_get_type (void) G_GNUC_CONST;
gconstpointer gee_future_wait (GeeFuture* self, GError** error);
gboolean gee_future_wait_until (GeeFuture* self, gint64 end_time, gconstpointer* value, GError** error);
void gee_future_wait_async (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gconstpointer gee_future_wait_finish (GeeFuture* self, GAsyncResult* _res_, GError** error);
GeeFuture* gee_future_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static GeeFuture* gee_future_real_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
gpointer gee_promise_ref (gpointer instance);
void gee_promise_unref (gpointer instance);
GParamSpec* gee_param_spec_promise (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_promise (GValue* value, gpointer v_object);
void gee_value_take_promise (GValue* value, gpointer v_object);
gpointer gee_value_get_promise (const GValue* value);
GType gee_promise_get_type (void) G_GNUC_CONST;
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
GeePromise* gee_promise_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeePromise* gee_promise_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void __lambda3_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res);
void gee_promise_set_value (GeePromise* self, gpointer value);
void gee_promise_set_exception (GeePromise* self, GError* exception);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GeeFuture* gee_promise_get_future (GeePromise* self);
GeeFuture* gee_future_light_map_fixed (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static GeeFuture* gee_future_real_light_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeLightMapFuture* gee_light_map_future_new (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFuture* base_future, GeeFutureLightMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeLightMapFuture* gee_light_map_future_construct (GType object_type, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFuture* base_future, GeeFutureLightMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GType gee_light_map_future_get_type (void) G_GNUC_CONST;
GeeFuture* gee_future_light_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target);
static GeeFuture* gee_future_real_light_map_broken (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target);
GeeFuture* gee_future_zip (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second);
static GeeFuture* gee_future_real_zip (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void gee_future_do_zip (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GType c_type, GBoxedCopyFunc c_dup_func, GDestroyNotify c_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* first, GeeFuture* second, GeePromise* _result_, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gee_future_do_zip_finish (GAsyncResult* _res_);
static void __lambda4_ (Block8Data* _data8_, GObject* obj, GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gee_future_do_zip_data_free (gpointer _data);
static gboolean gee_future_do_zip_co (GeeFutureDoZipData* _data_);
static void gee_future_do_zip_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeFuture* gee_future_flat_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static GeeFuture* gee_future_real_flat_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void gee_future_do_flat_map (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, GeeFuture* future, GeePromise* promise, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gee_future_do_flat_map_finish (GAsyncResult* _res_);
static void __lambda5_ (Block9Data* _data9_, GObject* obj, GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gee_future_do_flat_map_data_free (gpointer _data);
static gboolean gee_future_do_flat_map_co (GeeFutureDoFlatMapData* _data_);
static void gee_future_do_flat_map_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gconstpointer gee_future_get_value (GeeFuture* self);
gboolean gee_future_get_ready (GeeFuture* self);
GError* gee_future_get_exception (GeeFuture* self);
GType gee_future_source_func_array_element_get_type (void) G_GNUC_CONST;
GeeFutureSourceFuncArrayElement* gee_future_source_func_array_element_dup (const GeeFutureSourceFuncArrayElement* self);
void gee_future_source_func_array_element_free (GeeFutureSourceFuncArrayElement* self);
void gee_future_source_func_array_element_copy (const GeeFutureSourceFuncArrayElement* self, GeeFutureSourceFuncArrayElement* dest);
void gee_future_source_func_array_element_destroy (GeeFutureSourceFuncArrayElement* self);
void gee_future_source_func_array_element_init (GeeFutureSourceFuncArrayElement *self, GSourceFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);


/**
 * Waits until the value is ready.
 *
 * @returns The {@link value} associated with future
 * @see ready
 * @see wait_until
 * @see wait_async
 */
gconstpointer gee_future_wait (GeeFuture* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->wait (self, error);
}


/**
 * Waits until the value is ready or deadline have passed.
 *
 * @param end_time The time when the wait should finish
 * @param value The {@link value} associated with future if the wait was successful
 * @returns ``true`` if the value was ready within deadline or ``false`` otherwise
 * @see ready
 * @see wait
 * @see wait_async
 */
gboolean gee_future_wait_until (GeeFuture* self, gint64 end_time, gconstpointer* value, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_FUTURE_GET_INTERFACE (self)->wait_until (self, end_time, value, error);
}


void gee_future_wait_async (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GEE_FUTURE_GET_INTERFACE (self)->wait_async (self, _callback_, _user_data_);
}


gconstpointer gee_future_wait_finish (GeeFuture* self, GAsyncResult* _res_, GError** error) {
	return GEE_FUTURE_GET_INTERFACE (self)->wait_finish (self, _res_, error);
}


/**
 * Maps a future value to another value by a function and returns the
 * another value in future.
 *
 * @param func Function applied to {@link value}
 * @returns Value returned by function
 *
 * @see flat_map
 * @see light_map
 *
 * Note: As time taken by function might not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to use
 *   {@link task} and {@link flat_map} for longer computation.
 */
static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GeeFuture* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data7_->self;
		a_type = _data7_->a_type;
		a_dup_func = _data7_->a_dup_func;
		a_destroy_func = _data7_->a_destroy_func;
		_gee_promise_unref0 (_data7_->promise);
		(_data7_->func_target_destroy_notify == NULL) ? NULL : (_data7_->func_target_destroy_notify (_data7_->func_target), NULL);
		_data7_->func = NULL;
		_data7_->func_target = NULL;
		_data7_->func_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda3_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res) {
	GeeFuture* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GError * _inner_error_ = NULL;
	self = _data7_->self;
	a_type = _data7_->a_type;
	a_dup_func = _data7_->a_dup_func;
	a_destroy_func = _data7_->a_destroy_func;
	g_return_if_fail (res != NULL);
	{
		gconstpointer _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		GeeFutureMapFunc _tmp3_ = NULL;
		void* _tmp3__target = NULL;
		gpointer _tmp4_ = NULL;
		_tmp1_ = res;
		_tmp2_ = gee_future_wait_finish (self, _tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp3_ = _data7_->func;
		_tmp3__target = _data7_->func_target;
		_tmp4_ = _tmp3_ (_tmp0_, _tmp3__target);
		gee_promise_set_value (_data7_->promise, _tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* ex = NULL;
		GError* _tmp5_ = NULL;
		ex = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = ex;
		ex = NULL;
		gee_promise_set_exception (_data7_->promise, _tmp5_);
		_g_error_free0 (ex);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda3_ (self, source_object, res);
	block7_data_unref (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeFuture* gee_future_real_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	GeeFuture* result = NULL;
	Block7Data* _data7_;
	GeeFutureMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeePromise* _tmp1_ = NULL;
	GeeFuture* _tmp2_ = NULL;
	GeeFuture* _tmp3_ = NULL;
	GeeFuture* _tmp4_ = NULL;
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->a_type = a_type;
	_data7_->a_dup_func = a_dup_func;
	_data7_->a_destroy_func = a_destroy_func;
	_tmp0_ = func;
	_tmp0__target = func_target;
	(_data7_->func_target_destroy_notify == NULL) ? NULL : (_data7_->func_target_destroy_notify (_data7_->func_target), NULL);
	_data7_->func = NULL;
	_data7_->func_target = NULL;
	_data7_->func_target_destroy_notify = NULL;
	_data7_->func = _tmp0_;
	_data7_->func_target = _tmp0__target;
	_data7_->func_target_destroy_notify = func_target_destroy_notify;
	_tmp1_ = gee_promise_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func);
	_data7_->promise = _tmp1_;
	gee_future_wait_async (self, ___lambda3__gasync_ready_callback, block7_data_ref (_data7_));
	_tmp2_ = gee_promise_get_future (_data7_->promise);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}


GeeFuture* gee_future_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->map (self, a_type, a_dup_func, a_destroy_func, func, func_target, func_target_destroy_notify);
}


/**
 * Maps a future value to another value by a function and returns the
 * another value in future.
 *
 * @param func Function applied to {@link value}
 * @returns Value returned by function
 *
 * @see flat_map
 * @see map
 * @since 0.11.4
 *
 * Note: The function may be reevaluated at any time and it might
 *   be called lazily. Therefore it is recommended for it to be
 *   idempotent. If the function needs to be called eagerly or have
 *   side-effects it is recommended to use {@link map}.
 *
 * Note: As time taken by function does not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to use
 *   {@link task} and {@link flat_map} for longer computation.
 */
static GeeFuture* gee_future_real_light_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	GeeFuture* result = NULL;
	GeeFutureLightMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeLightMapFuture* _tmp1_ = NULL;
	_tmp0_ = func;
	_tmp0__target = func_target;
	_tmp1_ = gee_light_map_future_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, GEE_FUTURE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_FUTURE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_FUTURE_GET_INTERFACE (self)->get_g_destroy_func (self), self, _tmp0_, _tmp0__target, NULL);
	result = (GeeFuture*) _tmp1_;
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
	return result;
}


GeeFuture* gee_future_light_map_fixed (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->light_map_fixed (self, a_type, a_dup_func, a_destroy_func, func, func_target, func_target_destroy_notify);
}


static GeeFuture* gee_future_real_light_map_broken (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target) {
	GeeFuture* result = NULL;
	GeeFutureLightMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeFuture* _tmp1_ = NULL;
	_tmp0_ = func;
	_tmp0__target = func_target;
	_tmp1_ = gee_future_light_map_fixed (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp0_, _tmp0__target, NULL);
	result = _tmp1_;
	return result;
}


GeeFuture* gee_future_light_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->light_map (self, a_type, a_dup_func, a_destroy_func, func, func_target);
}


/**
 * Combines values of two futures using a function returning the combined
 * value in future (call does not block).
 *
 * @param join_func Function applied to values
 * @param second Second parameter
 * @returns A combine value
 * @since 0.11.4
 *
 * Note: As time taken by function does not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to return a
 *   future from {@link task} and use {@link flat_map} for longer computation.
 */
static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GeeFuture* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		GType b_type;
		GBoxedCopyFunc b_dup_func;
		GDestroyNotify b_destroy_func;
		self = _data8_->self;
		a_type = _data8_->a_type;
		a_dup_func = _data8_->a_dup_func;
		a_destroy_func = _data8_->a_destroy_func;
		b_type = _data8_->b_type;
		b_dup_func = _data8_->b_dup_func;
		b_destroy_func = _data8_->b_destroy_func;
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void __lambda4_ (Block8Data* _data8_, GObject* obj, GAsyncResult* res) {
	GeeFuture* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
	GAsyncResult* _tmp0_ = NULL;
	self = _data8_->self;
	a_type = _data8_->a_type;
	a_dup_func = _data8_->a_dup_func;
	a_destroy_func = _data8_->a_destroy_func;
	b_type = _data8_->b_type;
	b_dup_func = _data8_->b_dup_func;
	b_destroy_func = _data8_->b_destroy_func;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	gee_future_do_zip_finish (_tmp0_);
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda4_ (self, source_object, res);
	block8_data_unref (self);
}


static GeeFuture* gee_future_real_zip (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second) {
	GeeFuture* result = NULL;
	Block8Data* _data8_;
	GeePromise* promise = NULL;
	GeePromise* _tmp0_ = NULL;
	GeeFutureZipFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GDestroyNotify _tmp1__target_destroy_notify = NULL;
	GeeFuture* _tmp2_ = NULL;
	GeeFuture* _tmp3_ = NULL;
	GeeFuture* _tmp4_ = NULL;
	GeeFuture* _tmp5_ = NULL;
	g_return_val_if_fail (second != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->a_type = a_type;
	_data8_->a_dup_func = a_dup_func;
	_data8_->a_destroy_func = a_destroy_func;
	_data8_->b_type = b_type;
	_data8_->b_dup_func = b_dup_func;
	_data8_->b_destroy_func = b_destroy_func;
	_tmp0_ = gee_promise_new (b_type, (GBoxedCopyFunc) b_dup_func, b_destroy_func);
	promise = _tmp0_;
	_tmp1_ = zip_func;
	_tmp1__target = zip_func_target;
	_tmp1__target_destroy_notify = NULL;
	_tmp2_ = second;
	gee_future_do_zip (GEE_FUTURE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_FUTURE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_FUTURE_GET_INTERFACE (self)->get_g_destroy_func (self), a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, b_type, (GBoxedCopyFunc) b_dup_func, b_destroy_func, _tmp1_, _tmp1__target, self, _tmp2_, promise, ___lambda4__gasync_ready_callback, block8_data_ref (_data8_));
	_tmp3_ = gee_promise_get_future (promise);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	_gee_promise_unref0 (promise);
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}


GeeFuture* gee_future_zip (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->zip (self, a_type, a_dup_func, a_destroy_func, b_type, b_dup_func, b_destroy_func, zip_func, zip_func_target, second);
}


static void gee_future_do_zip_data_free (gpointer _data) {
	GeeFutureDoZipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->first);
	_g_object_unref0 (_data_->second);
	_gee_promise_unref0 (_data_->_result_);
	g_slice_free (GeeFutureDoZipData, _data_);
}


static gpointer _gee_promise_ref0 (gpointer self) {
	return self ? gee_promise_ref (self) : NULL;
}


static void gee_future_do_zip (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GType c_type, GBoxedCopyFunc c_dup_func, GDestroyNotify c_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* first, GeeFuture* second, GeePromise* _result_, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GeeFutureDoZipData* _data_;
	GeeFuture* _tmp0_ = NULL;
	GeeFuture* _tmp1_ = NULL;
	GeeFuture* _tmp2_ = NULL;
	GeeFuture* _tmp3_ = NULL;
	GeePromise* _tmp4_ = NULL;
	GeePromise* _tmp5_ = NULL;
	_data_ = g_slice_new0 (GeeFutureDoZipData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gee_future_do_zip);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gee_future_do_zip_data_free);
	_data_->zip_func = zip_func;
	_data_->zip_func_target = zip_func_target;
	_tmp0_ = first;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->first);
	_data_->first = _tmp1_;
	_tmp2_ = second;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->second);
	_data_->second = _tmp3_;
	_tmp4_ = _result_;
	_tmp5_ = _gee_promise_ref0 (_tmp4_);
	_gee_promise_unref0 (_data_->_result_);
	_data_->_result_ = _tmp5_;
	_data_->a_type = a_type;
	_data_->a_dup_func = a_dup_func;
	_data_->a_destroy_func = a_destroy_func;
	_data_->b_type = b_type;
	_data_->b_dup_func = b_dup_func;
	_data_->b_destroy_func = b_destroy_func;
	_data_->c_type = c_type;
	_data_->c_dup_func = c_dup_func;
	_data_->c_destroy_func = c_destroy_func;
	gee_future_do_zip_co (_data_);
}


static void gee_future_do_zip_finish (GAsyncResult* _res_) {
	GeeFutureDoZipData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void gee_future_do_zip_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GeeFutureDoZipData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gee_future_do_zip_co (_data_);
}


static gboolean gee_future_do_zip_co (GeeFutureDoZipData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->first;
		_data_->_state_ = 1;
		gee_future_wait_async (_data_->_tmp0_, gee_future_do_zip_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = gee_future_wait_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = ((_data_->_tmp1_ != NULL) && (_data_->a_dup_func != NULL)) ? _data_->a_dup_func ((gpointer) _data_->_tmp1_) : ((gpointer) _data_->_tmp1_);
		_data_->left = _data_->_tmp2_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->second;
		_data_->_state_ = 2;
		gee_future_wait_async (_data_->_tmp3_, gee_future_do_zip_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = gee_future_wait_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = ((_data_->_tmp4_ != NULL) && (_data_->b_dup_func != NULL)) ? _data_->b_dup_func ((gpointer) _data_->_tmp4_) : ((gpointer) _data_->_tmp4_);
		_data_->right = _data_->_tmp5_;
		if (_data_->_inner_error_ != NULL) {
			((_data_->left == NULL) || (_data_->a_destroy_func == NULL)) ? NULL : (_data_->left = (_data_->a_destroy_func (_data_->left), NULL));
			goto __catch1_g_error;
		}
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_result_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7__target = NULL;
		_data_->_tmp7_ = _data_->zip_func;
		_data_->_tmp7__target = _data_->zip_func_target;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->left;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->right;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp7_ (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp7__target);
		gee_promise_set_value (_data_->_tmp6_, _data_->_tmp10_);
		((_data_->right == NULL) || (_data_->b_destroy_func == NULL)) ? NULL : (_data_->right = (_data_->b_destroy_func (_data_->right), NULL));
		((_data_->left == NULL) || (_data_->a_destroy_func == NULL)) ? NULL : (_data_->left = (_data_->a_destroy_func (_data_->left), NULL));
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->ex = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_result_;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->ex;
		_data_->ex = NULL;
		gee_promise_set_exception (_data_->_tmp11_, _data_->_tmp12_);
		_g_error_free0 (_data_->ex);
	}
	__finally1:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
 * Maps a future value to another future value which is returned (call does not block).
 *
 * @param func Function applied to {@link value}
 * @returns Value of a future returned by function
 *
 * @see map
 *
 * Note: As time taken by function does not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to put the
 *   larger computation inside the returned future for example by
 *   {@link task}
 */
static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		GeeFuture* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data9_->self;
		a_type = _data9_->a_type;
		a_dup_func = _data9_->a_dup_func;
		a_destroy_func = _data9_->a_destroy_func;
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void __lambda5_ (Block9Data* _data9_, GObject* obj, GAsyncResult* res) {
	GeeFuture* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GAsyncResult* _tmp0_ = NULL;
	self = _data9_->self;
	a_type = _data9_->a_type;
	a_dup_func = _data9_->a_dup_func;
	a_destroy_func = _data9_->a_destroy_func;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	gee_future_do_flat_map_finish (_tmp0_);
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda5_ (self, source_object, res);
	block9_data_unref (self);
}


static GeeFuture* gee_future_real_flat_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	GeeFuture* result = NULL;
	Block9Data* _data9_;
	GeePromise* promise = NULL;
	GeePromise* _tmp0_ = NULL;
	GeeFutureFlatMapFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GDestroyNotify _tmp1__target_destroy_notify = NULL;
	GeeFuture* _tmp2_ = NULL;
	GeeFuture* _tmp3_ = NULL;
	GeeFuture* _tmp4_ = NULL;
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->a_type = a_type;
	_data9_->a_dup_func = a_dup_func;
	_data9_->a_destroy_func = a_destroy_func;
	_tmp0_ = gee_promise_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func);
	promise = _tmp0_;
	_tmp1_ = func;
	_tmp1__target = func_target;
	_tmp1__target_destroy_notify = func_target_destroy_notify;
	func_target_destroy_notify = NULL;
	gee_future_do_flat_map (GEE_FUTURE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_FUTURE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_FUTURE_GET_INTERFACE (self)->get_g_destroy_func (self), a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify, self, promise, ___lambda5__gasync_ready_callback, block9_data_ref (_data9_));
	_tmp2_ = gee_promise_get_future (promise);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	_gee_promise_unref0 (promise);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
	return result;
}


GeeFuture* gee_future_flat_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->flat_map (self, a_type, a_dup_func, a_destroy_func, func, func_target, func_target_destroy_notify);
}


static void gee_future_do_flat_map_data_free (gpointer _data) {
	GeeFutureDoFlatMapData* _data_;
	_data_ = _data;
	(_data_->func_target_destroy_notify == NULL) ? NULL : (_data_->func_target_destroy_notify (_data_->func_target), NULL);
	_data_->func = NULL;
	_data_->func_target = NULL;
	_data_->func_target_destroy_notify = NULL;
	_g_object_unref0 (_data_->future);
	_gee_promise_unref0 (_data_->promise);
	g_slice_free (GeeFutureDoFlatMapData, _data_);
}


static void gee_future_do_flat_map (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, GeeFuture* future, GeePromise* promise, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GeeFutureDoFlatMapData* _data_;
	GeeFuture* _tmp0_ = NULL;
	GeeFuture* _tmp1_ = NULL;
	GeePromise* _tmp2_ = NULL;
	GeePromise* _tmp3_ = NULL;
	_data_ = g_slice_new0 (GeeFutureDoFlatMapData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gee_future_do_flat_map);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gee_future_do_flat_map_data_free);
	(_data_->func_target_destroy_notify == NULL) ? NULL : (_data_->func_target_destroy_notify (_data_->func_target), NULL);
	_data_->func = NULL;
	_data_->func_target = NULL;
	_data_->func_target_destroy_notify = NULL;
	_data_->func = func;
	_data_->func_target = func_target;
	_data_->func_target_destroy_notify = func_target_destroy_notify;
	_tmp0_ = future;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->future);
	_data_->future = _tmp1_;
	_tmp2_ = promise;
	_tmp3_ = _gee_promise_ref0 (_tmp2_);
	_gee_promise_unref0 (_data_->promise);
	_data_->promise = _tmp3_;
	_data_->a_type = a_type;
	_data_->a_dup_func = a_dup_func;
	_data_->a_destroy_func = a_destroy_func;
	_data_->b_type = b_type;
	_data_->b_dup_func = b_dup_func;
	_data_->b_destroy_func = b_destroy_func;
	gee_future_do_flat_map_co (_data_);
}


static void gee_future_do_flat_map_finish (GAsyncResult* _res_) {
	GeeFutureDoFlatMapData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void gee_future_do_flat_map_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GeeFutureDoFlatMapData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gee_future_do_flat_map_co (_data_);
}


static gboolean gee_future_do_flat_map_co (GeeFutureDoFlatMapData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->future;
		_data_->_state_ = 1;
		gee_future_wait_async (_data_->_tmp0_, gee_future_do_flat_map_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = gee_future_wait_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = ((_data_->_tmp1_ != NULL) && (_data_->a_dup_func != NULL)) ? _data_->a_dup_func ((gpointer) _data_->_tmp1_) : ((gpointer) _data_->_tmp1_);
		_data_->input = _data_->_tmp2_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3__target = NULL;
		_data_->_tmp3_ = _data_->func;
		_data_->_tmp3__target = _data_->func_target;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->input;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp3_ (_data_->_tmp4_, _data_->_tmp3__target);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 2;
		gee_future_wait_async (_data_->_tmp6_, gee_future_do_flat_map_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = gee_future_wait_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = ((_data_->_tmp7_ != NULL) && (_data_->b_dup_func != NULL)) ? _data_->b_dup_func ((gpointer) _data_->_tmp7_) : ((gpointer) _data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_;
		_g_object_unref0 (_data_->_tmp6_);
		_data_->output = _data_->_tmp9_;
		if (_data_->_inner_error_ != NULL) {
			((_data_->input == NULL) || (_data_->a_destroy_func == NULL)) ? NULL : (_data_->input = (_data_->a_destroy_func (_data_->input), NULL));
			goto __catch2_g_error;
		}
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->promise;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->output;
		_data_->output = NULL;
		gee_promise_set_value (_data_->_tmp10_, _data_->_tmp11_);
		((_data_->output == NULL) || (_data_->b_destroy_func == NULL)) ? NULL : (_data_->output = (_data_->b_destroy_func (_data_->output), NULL));
		((_data_->input == NULL) || (_data_->a_destroy_func == NULL)) ? NULL : (_data_->input = (_data_->a_destroy_func (_data_->input), NULL));
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->ex = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->promise;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->ex;
		_data_->ex = NULL;
		gee_promise_set_exception (_data_->_tmp12_, _data_->_tmp13_);
		_g_error_free0 (_data_->ex);
	}
	__finally2:
	if (_data_->_inner_error_ != NULL) {
		(_data_->func_target_destroy_notify == NULL) ? NULL : (_data_->func_target_destroy_notify (_data_->func_target), NULL);
		_data_->func = NULL;
		_data_->func_target = NULL;
		_data_->func_target_destroy_notify = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	(_data_->func_target_destroy_notify == NULL) ? NULL : (_data_->func_target_destroy_notify (_data_->func_target), NULL);
	_data_->func = NULL;
	_data_->func_target = NULL;
	_data_->func_target_destroy_notify = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gconstpointer gee_future_get_value (GeeFuture* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->get_value (self);
}


static gconstpointer gee_future_real_get_value (GeeFuture* base) {
	gconstpointer result;
	GeeFuture* self;
	GError * _inner_error_ = NULL;
	self = base;
	{
		gconstpointer _tmp0_ = NULL;
		gconstpointer _tmp1_ = NULL;
		_tmp1_ = gee_future_wait (self, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GEE_FUTURE_ERROR) {
				goto __catch3_gee_future_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally3;
	__catch3_gee_future_error:
	{
		GError* ex = NULL;
		ex = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (ex);
		return result;
	}
	__finally3:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


gboolean gee_future_get_ready (GeeFuture* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_FUTURE_GET_INTERFACE (self)->get_ready (self);
}


GError* gee_future_get_exception (GeeFuture* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_FUTURE_GET_INTERFACE (self)->get_exception (self);
}


void gee_future_source_func_array_element_init (GeeFutureSourceFuncArrayElement *self, GSourceFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GDestroyNotify _tmp0__target_destroy_notify = NULL;
	memset (self, 0, sizeof (GeeFutureSourceFuncArrayElement));
	_tmp0_ = func;
	_tmp0__target = func_target;
	_tmp0__target_destroy_notify = func_target_destroy_notify;
	func_target_destroy_notify = NULL;
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
	(*self).func = _tmp0_;
	(*self).func_target = _tmp0__target;
	(*self).func_target_destroy_notify = _tmp0__target_destroy_notify;
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
}


void gee_future_source_func_array_element_copy (const GeeFutureSourceFuncArrayElement* self, GeeFutureSourceFuncArrayElement* dest) {
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = (*self).func;
	_tmp0__target = (*self).func_target;
	((*dest).func_target_destroy_notify == NULL) ? NULL : ((*dest).func_target_destroy_notify ((*dest).func_target), NULL);
	(*dest).func = NULL;
	(*dest).func_target = NULL;
	(*dest).func_target_destroy_notify = NULL;
	(*dest).func = _tmp0_;
	(*dest).func_target = _tmp0__target;
	(*dest).func_target_destroy_notify = NULL;
}


void gee_future_source_func_array_element_destroy (GeeFutureSourceFuncArrayElement* self) {
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
}


GeeFutureSourceFuncArrayElement* gee_future_source_func_array_element_dup (const GeeFutureSourceFuncArrayElement* self) {
	GeeFutureSourceFuncArrayElement* dup;
	dup = g_new0 (GeeFutureSourceFuncArrayElement, 1);
	gee_future_source_func_array_element_copy (self, dup);
	return dup;
}


void gee_future_source_func_array_element_free (GeeFutureSourceFuncArrayElement* self) {
	gee_future_source_func_array_element_destroy (self);
	g_free (self);
}


GType gee_future_source_func_array_element_get_type (void) {
	static volatile gsize gee_future_source_func_array_element_type_id__volatile = 0;
	if (g_once_init_enter (&gee_future_source_func_array_element_type_id__volatile)) {
		GType gee_future_source_func_array_element_type_id;
		gee_future_source_func_array_element_type_id = g_boxed_type_register_static ("GeeFutureSourceFuncArrayElement", (GBoxedCopyFunc) gee_future_source_func_array_element_dup, (GBoxedFreeFunc) gee_future_source_func_array_element_free);
		g_once_init_leave (&gee_future_source_func_array_element_type_id__volatile, gee_future_source_func_array_element_type_id);
	}
	return gee_future_source_func_array_element_type_id__volatile;
}


static void gee_future_base_init (GeeFutureIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		 * Checks if value is ready. If it is calls to {@link wait} and
		 * {@link wait_until} will not block and value is returned immidiatly.
		 */
		g_object_interface_install_property (iface, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		 * Checks the exception that have been set. I.e. if the computation
		 * has thrown the exception it should be set here and the {@link wait},
		 * {@link wait_until} and {@link wait_async} should throw
		 * {@link FutureError.EXCEPTION}.
		 *
		 * @since 0.11.5
		 */
		g_object_interface_install_property (iface, g_param_spec_pointer ("exception", "exception", "exception", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		iface->map = gee_future_real_map;
		iface->light_map_fixed = gee_future_real_light_map;
		iface->light_map = gee_future_real_light_map_broken;
		iface->zip = gee_future_real_zip;
		iface->flat_map = gee_future_real_flat_map;
		iface->get_value = gee_future_real_get_value;
	}
}


/**
 * Future is a value which might not yet be computed - for example it is calculated
 * in different thread or depends on I/O value.
 *
 * All methods can be called from many threads as part of interface.
 *
 * @see Promise
 * @see Lazy
 * @see task
 * @see async_task
 * @since 0.11.0
 *
 * Note: Statement that call does not block does not mean that it is lock-free.
 *   Internally the implementation is allowed to take mutex but it should guarantee
 *   that it is not for a long time (including blocking on anything else, I/O calls
 *   or callbacks).
 */
GType gee_future_get_type (void) {
	static volatile gsize gee_future_type_id__volatile = 0;
	if (g_once_init_enter (&gee_future_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeFutureIface), (GBaseInitFunc) gee_future_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_future_type_id;
		gee_future_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeFuture", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_future_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_future_type_id__volatile, gee_future_type_id);
	}
	return gee_future_type_id__volatile;
}


GQuark gee_future_error_quark (void) {
	return g_quark_from_static_string ("gee_future_error-quark");
}



