/* linkedlist.c generated by valac, the Vala compiler
 * generated from linkedlist.vala, do not modify */

/* linkedlist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Mark Lee, Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Mark Lee <marklee@src.gnome.org>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_DEQUE (gee_deque_get_type ())
#define GEE_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_DEQUE, GeeDeque))
#define GEE_IS_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_DEQUE))
#define GEE_DEQUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_DEQUE, GeeDequeIface))

typedef struct _GeeDeque GeeDeque;
typedef struct _GeeDequeIface GeeDequeIface;

#define GEE_TYPE_LINKED_LIST (gee_linked_list_get_type ())
#define GEE_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedList))
#define GEE_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))
#define GEE_IS_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LINKED_LIST))
#define GEE_IS_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LINKED_LIST))
#define GEE_LINKED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))

typedef struct _GeeLinkedList GeeLinkedList;
typedef struct _GeeLinkedListClass GeeLinkedListClass;
typedef struct _GeeLinkedListPrivate GeeLinkedListPrivate;

#define GEE_LINKED_LIST_TYPE_NODE (gee_linked_list_node_get_type ())
#define GEE_LINKED_LIST_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_LINKED_LIST_TYPE_NODE, GeeLinkedListNode))
#define GEE_LINKED_LIST_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_LINKED_LIST_TYPE_NODE, GeeLinkedListNodeClass))
#define GEE_LINKED_LIST_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_LINKED_LIST_TYPE_NODE))
#define GEE_LINKED_LIST_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_LINKED_LIST_TYPE_NODE))
#define GEE_LINKED_LIST_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_LINKED_LIST_TYPE_NODE, GeeLinkedListNodeClass))

typedef struct _GeeLinkedListNode GeeLinkedListNode;
typedef struct _GeeLinkedListNodeClass GeeLinkedListNodeClass;
#define _gee_linked_list_node_unref0(var) ((var == NULL) ? NULL : (var = (gee_linked_list_node_unref (var), NULL)))

#define GEE_LINKED_LIST_TYPE_ITERATOR (gee_linked_list_iterator_get_type ())
#define GEE_LINKED_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator))
#define GEE_LINKED_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))
#define GEE_LINKED_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))

typedef struct _GeeLinkedListIterator GeeLinkedListIterator;
typedef struct _GeeLinkedListIteratorClass GeeLinkedListIteratorClass;
typedef struct _GeeLinkedListNodePrivate GeeLinkedListNodePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeeLinkedListParamSpecNode GeeLinkedListParamSpecNode;
typedef struct _GeeLinkedListIteratorPrivate GeeLinkedListIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*insert) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareFunc compare_func);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeDequeIface {
	GTypeInterface parent_iface;
	gboolean (*offer_head) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_head) (GeeDeque* self);
	gpointer (*poll_head) (GeeDeque* self);
	gint (*drain_head) (GeeDeque* self, GeeCollection* recipient, gint amount);
	gboolean (*offer_tail) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_tail) (GeeDeque* self);
	gpointer (*poll_tail) (GeeDeque* self);
	gint (*drain_tail) (GeeDeque* self, GeeCollection* recipient, gint amount);
};

struct _GeeLinkedList {
	GeeAbstractList parent_instance;
	GeeLinkedListPrivate * priv;
};

struct _GeeLinkedListClass {
	GeeAbstractListClass parent_class;
};

struct _GeeLinkedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _size;
	gint _stamp;
	GeeLinkedListNode* _head;
	GeeLinkedListNode* _tail;
	GEqualFunc _equal_func;
};

struct _GeeLinkedListNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeLinkedListNodePrivate * priv;
	gpointer data;
	GeeLinkedListNode* prev;
	GeeLinkedListNode* next;
};

struct _GeeLinkedListNodeClass {
	GTypeClass parent_class;
	void (*finalize) (GeeLinkedListNode *self);
};

struct _GeeLinkedListNodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeLinkedListParamSpecNode {
	GParamSpec parent_instance;
};

struct _GeeLinkedListIterator {
	GObject parent_instance;
	GeeLinkedListIteratorPrivate * priv;
};

struct _GeeLinkedListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeLinkedListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gboolean started;
	gboolean removed;
	GeeLinkedListNode* position;
	gint _stamp;
	GeeLinkedList* _list;
	gint _index;
};


static gpointer gee_linked_list_node_parent_class = NULL;
static gpointer gee_linked_list_iterator_parent_class = NULL;
static GeeIteratorIface* gee_linked_list_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_linked_list_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeListIteratorIface* gee_linked_list_iterator_gee_list_iterator_parent_iface = NULL;
static gpointer gee_linked_list_parent_class = NULL;
static GeeQueueIface* gee_linked_list_gee_queue_parent_iface = NULL;
static GeeDequeIface* gee_linked_list_gee_deque_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_deque_get_type (void) G_GNUC_CONST;
GType gee_linked_list_get_type (void) G_GNUC_CONST;
static gpointer gee_linked_list_node_ref (gpointer instance);
static void gee_linked_list_node_unref (gpointer instance);
static GParamSpec* gee_linked_list_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gee_linked_list_value_set_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gee_linked_list_value_take_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gee_linked_list_value_get_node (const GValue* value) G_GNUC_UNUSED;
static GType gee_linked_list_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GEE_LINKED_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_LINKED_LIST, GeeLinkedListPrivate))
enum  {
	GEE_LINKED_LIST_DUMMY_PROPERTY,
	GEE_LINKED_LIST_EQUAL_FUNC,
	GEE_LINKED_LIST_SIZE,
	GEE_LINKED_LIST_CAPACITY,
	GEE_LINKED_LIST_REMAINING_CAPACITY,
	GEE_LINKED_LIST_IS_FULL,
	GEE_LINKED_LIST_G_TYPE,
	GEE_LINKED_LIST_G_DUP_FUNC,
	GEE_LINKED_LIST_G_DESTROY_FUNC
};
GeeAbstractList* gee_abstract_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GEqualFunc gee_functions_get_equal_func_for (GType t);
static void gee_linked_list_set_equal_func (GeeLinkedList* self, GEqualFunc value);
GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GType gee_linked_list_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base);
static GeeListIterator* gee_linked_list_real_list_iterator (GeeAbstractList* base);
gint gee_abstract_list_index_of (GeeAbstractList* self, gconstpointer item);
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item);
static GeeLinkedListNode* gee_linked_list_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static GeeLinkedListNode* gee_linked_list_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item);
GEqualFunc gee_linked_list_get_equal_func (GeeLinkedList* self);
static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* n);
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_linked_list_real_clear (GeeAbstractCollection* base);
static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index);
static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index);
static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item);
static gpointer gee_linked_list_real_remove_at (GeeAbstractList* base, gint index);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop);
static gpointer gee_linked_list_real_first (GeeAbstractList* base);
static gpointer gee_linked_list_real_last (GeeAbstractList* base);
gboolean gee_deque_offer_tail (GeeDeque* self, gconstpointer element);
static gboolean gee_linked_list_real_offer (GeeQueue* base, gconstpointer element);
gpointer gee_deque_peek_head (GeeDeque* self);
static gpointer gee_linked_list_real_peek (GeeQueue* base);
gpointer gee_deque_poll_head (GeeDeque* self);
static gpointer gee_linked_list_real_poll (GeeQueue* base);
gint gee_deque_drain_head (GeeDeque* self, GeeCollection* recipient, gint amount);
static gint gee_linked_list_real_drain (GeeQueue* base, GeeCollection* recipient, gint amount);
void gee_abstract_list_insert (GeeAbstractList* self, gint index, gconstpointer item);
static gboolean gee_linked_list_real_offer_head (GeeDeque* base, gconstpointer element);
gpointer gee_abstract_list_get (GeeAbstractList* self, gint index);
static gpointer gee_linked_list_real_peek_head (GeeDeque* base);
gpointer gee_abstract_list_remove_at (GeeAbstractList* self, gint index);
static gpointer gee_linked_list_real_poll_head (GeeDeque* base);
static gint gee_linked_list_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount);
static gboolean gee_linked_list_real_offer_tail (GeeDeque* base, gconstpointer element);
static gpointer gee_linked_list_real_peek_tail (GeeDeque* base);
static gpointer gee_linked_list_real_poll_tail (GeeDeque* base);
static gint gee_linked_list_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
#define GEE_LINKED_LIST_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_LINKED_LIST_TYPE_NODE, GeeLinkedListNodePrivate))
enum  {
	GEE_LINKED_LIST_NODE_DUMMY_PROPERTY
};
static void gee_linked_list_node_finalize (GeeLinkedListNode* obj);
#define GEE_LINKED_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorPrivate))
enum  {
	GEE_LINKED_LIST_ITERATOR_DUMMY_PROPERTY,
	GEE_LINKED_LIST_ITERATOR_G_TYPE,
	GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC,
	GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_linked_list_iterator_real_next (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_has_next (GeeIterator* base);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static gboolean gee_linked_list_iterator_real_first (GeeIterator* base);
static gpointer gee_linked_list_iterator_real_get (GeeIterator* base);
static void gee_linked_list_iterator_real_remove (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_last (GeeBidirIterator* base);
static void gee_linked_list_iterator_real_set (GeeListIterator* base, gconstpointer item);
static void gee_linked_list_iterator_real_insert (GeeListIterator* base, gconstpointer item);
static void gee_linked_list_iterator_real_add (GeeListIterator* base, gconstpointer item);
static gint gee_linked_list_iterator_real_index (GeeListIterator* base);
static void gee_linked_list_iterator_finalize (GObject* obj);
static void gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_linked_list_finalize (GObject* obj);
gint gee_queue_get_capacity (GeeQueue* self);
gint gee_queue_get_remaining_capacity (GeeQueue* self);
gboolean gee_queue_get_is_full (GeeQueue* self);
static void gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * Constructs a new, empty linked list.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
#line 54 "linkedlist.vala"
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
#line 491 "linkedlist.c"
	GeeLinkedList * self;
#line 54 "linkedlist.vala"
	self = (GeeLinkedList*) gee_abstract_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 54 "linkedlist.vala"
	self->priv->g_type = g_type;
#line 54 "linkedlist.vala"
	self->priv->g_dup_func = g_dup_func;
#line 54 "linkedlist.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 55 "linkedlist.vala"
	if (equal_func == NULL) {
#line 56 "linkedlist.vala"
		equal_func = gee_functions_get_equal_func_for (g_type);
#line 505 "linkedlist.c"
	}
#line 58 "linkedlist.vala"
	gee_linked_list_set_equal_func (self, equal_func);
#line 509 "linkedlist.c"
	return self;
}


#line 54 "linkedlist.vala"
GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
#line 54 "linkedlist.vala"
	return gee_linked_list_construct (GEE_TYPE_LINKED_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
#line 518 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 64 "linkedlist.vala"
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base) {
#line 527 "linkedlist.c"
	GeeLinkedList * self;
	GeeIterator* result = NULL;
	self = (GeeLinkedList*) base;
	result = (GeeIterator*) gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 65 "linkedlist.vala"
	return result;
#line 534 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 71 "linkedlist.vala"
static GeeListIterator* gee_linked_list_real_list_iterator (GeeAbstractList* base) {
#line 543 "linkedlist.c"
	GeeLinkedList * self;
	GeeListIterator* result = NULL;
	self = (GeeLinkedList*) base;
	result = (GeeListIterator*) gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 72 "linkedlist.vala"
	return result;
#line 550 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 85 "linkedlist.vala"
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item) {
#line 559 "linkedlist.c"
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	result = gee_abstract_list_index_of ((GeeAbstractList*) self, item) != (-1);
#line 86 "linkedlist.vala"
	return result;
#line 566 "linkedlist.c"
}


static gpointer _gee_linked_list_node_ref0 (gpointer self) {
	return self ? gee_linked_list_node_ref (self) : NULL;
}


/**
 * {@inheritDoc}
 */
#line 92 "linkedlist.vala"
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item) {
#line 580 "linkedlist.c"
	GeeLinkedList * self;
	gboolean result = FALSE;
	GeeLinkedListNode* n;
	gboolean _tmp0_ = FALSE;
	self = (GeeLinkedList*) base;
#line 93 "linkedlist.vala"
	n = gee_linked_list_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, item);
#line 94 "linkedlist.vala"
	if (self->priv->_head == NULL) {
#line 94 "linkedlist.vala"
		_tmp0_ = self->priv->_tail == NULL;
#line 592 "linkedlist.c"
	} else {
#line 94 "linkedlist.vala"
		_tmp0_ = FALSE;
#line 596 "linkedlist.c"
	}
#line 94 "linkedlist.vala"
	if (_tmp0_) {
#line 600 "linkedlist.c"
		GeeLinkedListNode* _tmp2_;
		GeeLinkedListNode* _tmp1_;
#line 95 "linkedlist.vala"
		self->priv->_head = (_tmp2_ = _gee_linked_list_node_ref0 (self->priv->_tail = (_tmp1_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_tail), _tmp1_)), _gee_linked_list_node_unref0 (self->priv->_head), _tmp2_);
#line 605 "linkedlist.c"
	} else {
		GeeLinkedListNode* _tmp3_;
		GeeLinkedListNode* _tmp4_;
		GeeLinkedListNode* _tmp5_;
#line 97 "linkedlist.vala"
		self->priv->_tail->next = (_tmp3_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_tail->next), _tmp3_);
#line 98 "linkedlist.vala"
		n->prev = (_tmp4_ = _gee_linked_list_node_ref0 (self->priv->_tail), _gee_linked_list_node_unref0 (n->prev), _tmp4_);
#line 99 "linkedlist.vala"
		self->priv->_tail = (_tmp5_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_tail), _tmp5_);
#line 616 "linkedlist.c"
	}
#line 105 "linkedlist.vala"
	self->priv->_size++;
#line 620 "linkedlist.c"
	result = TRUE;
	_gee_linked_list_node_unref0 (n);
#line 106 "linkedlist.vala"
	return result;
#line 625 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 112 "linkedlist.vala"
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item) {
#line 634 "linkedlist.c"
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	{
		GeeLinkedListNode* n;
#line 113 "linkedlist.vala"
		n = _gee_linked_list_node_ref0 (self->priv->_head);
#line 642 "linkedlist.c"
		{
			gboolean _tmp0_;
#line 113 "linkedlist.vala"
			_tmp0_ = TRUE;
#line 113 "linkedlist.vala"
			while (TRUE) {
#line 113 "linkedlist.vala"
				if (!_tmp0_) {
#line 651 "linkedlist.c"
					GeeLinkedListNode* _tmp1_;
#line 113 "linkedlist.vala"
					n = (_tmp1_ = _gee_linked_list_node_ref0 (n->next), _gee_linked_list_node_unref0 (n), _tmp1_);
#line 655 "linkedlist.c"
				}
#line 113 "linkedlist.vala"
				_tmp0_ = FALSE;
#line 113 "linkedlist.vala"
				if (!(n != NULL)) {
#line 113 "linkedlist.vala"
					break;
#line 663 "linkedlist.c"
				}
#line 114 "linkedlist.vala"
				if (gee_linked_list_get_equal_func (self) (item, n->data)) {
#line 115 "linkedlist.vala"
					_gee_linked_list_remove_node (self, _gee_linked_list_node_ref0 (n));
#line 669 "linkedlist.c"
					result = TRUE;
					_gee_linked_list_node_unref0 (n);
#line 116 "linkedlist.vala"
					return result;
#line 674 "linkedlist.c"
				}
			}
		}
		_gee_linked_list_node_unref0 (n);
	}
	result = FALSE;
#line 119 "linkedlist.vala"
	return result;
#line 683 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 125 "linkedlist.vala"
static void gee_linked_list_real_clear (GeeAbstractCollection* base) {
#line 692 "linkedlist.c"
	GeeLinkedList * self;
	GeeLinkedListNode* _tmp1_;
	GeeLinkedListNode* _tmp0_;
	self = (GeeLinkedList*) base;
#line 126 "linkedlist.vala"
	self->priv->_stamp = self->priv->_stamp + 1;
#line 127 "linkedlist.vala"
	self->priv->_head = (_tmp1_ = _gee_linked_list_node_ref0 (self->priv->_tail = (_tmp0_ = NULL, _gee_linked_list_node_unref0 (self->priv->_tail), _tmp0_)), _gee_linked_list_node_unref0 (self->priv->_head), _tmp1_);
#line 128 "linkedlist.vala"
	self->priv->_size = 0;
#line 703 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 134 "linkedlist.vala"
static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index) {
#line 712 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	GeeLinkedListNode* n;
	gconstpointer _tmp0_;
	self = (GeeLinkedList*) base;
#line 135 "linkedlist.vala"
	g_assert (index >= 0);
#line 136 "linkedlist.vala"
	g_assert (index < self->priv->_size);
#line 138 "linkedlist.vala"
	n = _gee_linked_list_get_node_at (self, index);
#line 139 "linkedlist.vala"
	g_assert (n != NULL);
#line 726 "linkedlist.c"
	result = (_tmp0_ = n->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 140 "linkedlist.vala"
	return result;
#line 730 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 146 "linkedlist.vala"
static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item) {
#line 739 "linkedlist.c"
	GeeLinkedList * self;
	GeeLinkedListNode* n;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeeLinkedList*) base;
#line 147 "linkedlist.vala"
	g_assert (index >= 0);
#line 148 "linkedlist.vala"
	g_assert (index < self->priv->_size);
#line 150 "linkedlist.vala"
	n = _gee_linked_list_get_node_at (self, index);
#line 151 "linkedlist.vala"
	g_return_if_fail (n != NULL);
#line 152 "linkedlist.vala"
	n->data = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((n->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (n->data = (self->priv->g_destroy_func (n->data), NULL)), _tmp1_);
#line 755 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 158 "linkedlist.vala"
static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item) {
#line 764 "linkedlist.c"
	GeeLinkedList * self;
	gint result = 0;
	gint _result_;
	gint idx;
	self = (GeeLinkedList*) base;
#line 159 "linkedlist.vala"
	_result_ = -1;
#line 160 "linkedlist.vala"
	idx = 0;
#line 774 "linkedlist.c"
	{
		GeeIterator* _node_item_it;
#line 161 "linkedlist.vala"
		_node_item_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
#line 161 "linkedlist.vala"
		while (TRUE) {
#line 781 "linkedlist.c"
			gpointer node_item;
#line 161 "linkedlist.vala"
			if (!gee_iterator_next (_node_item_it)) {
#line 161 "linkedlist.vala"
				break;
#line 787 "linkedlist.c"
			}
#line 161 "linkedlist.vala"
			node_item = gee_iterator_get (_node_item_it);
#line 162 "linkedlist.vala"
			if (gee_linked_list_get_equal_func (self) (item, node_item)) {
#line 163 "linkedlist.vala"
				_result_ = idx;
#line 795 "linkedlist.c"
				((node_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node_item = (self->priv->g_destroy_func (node_item), NULL));
#line 164 "linkedlist.vala"
				break;
#line 799 "linkedlist.c"
			} else {
#line 166 "linkedlist.vala"
				idx++;
#line 803 "linkedlist.c"
			}
			((node_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node_item = (self->priv->g_destroy_func (node_item), NULL));
		}
		_g_object_unref0 (_node_item_it);
	}
	result = _result_;
#line 169 "linkedlist.vala"
	return result;
#line 812 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 175 "linkedlist.vala"
static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item) {
#line 821 "linkedlist.c"
	GeeLinkedList * self;
	self = (GeeLinkedList*) base;
#line 176 "linkedlist.vala"
	g_assert (index >= 0);
#line 177 "linkedlist.vala"
	g_assert (index <= self->priv->_size);
#line 179 "linkedlist.vala"
	if (index == self->priv->_size) {
#line 180 "linkedlist.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) self, item);
#line 832 "linkedlist.c"
	} else {
		GeeLinkedListNode* n;
#line 182 "linkedlist.vala"
		n = gee_linked_list_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, item);
#line 183 "linkedlist.vala"
		if (index == 0) {
#line 839 "linkedlist.c"
			GeeLinkedListNode* _tmp0_;
			GeeLinkedListNode* _tmp1_;
			GeeLinkedListNode* _tmp3_;
			GeeLinkedListNode* _tmp2_;
#line 184 "linkedlist.vala"
			n->next = (_tmp0_ = _gee_linked_list_node_ref0 (self->priv->_head), _gee_linked_list_node_unref0 (n->next), _tmp0_);
#line 185 "linkedlist.vala"
			self->priv->_head->prev = (_tmp1_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_head->prev), _tmp1_);
#line 186 "linkedlist.vala"
			self->priv->_head = (_tmp3_ = (_tmp2_ = n, n = NULL, _tmp2_), _gee_linked_list_node_unref0 (self->priv->_head), _tmp3_);
#line 850 "linkedlist.c"
		} else {
			GeeLinkedListNode* prev;
			GeeLinkedListNode* _tmp6_;
			GeeLinkedListNode* _tmp7_;
			GeeLinkedListNode* _tmp8_;
			GeeLinkedListNode* _tmp9_;
#line 188 "linkedlist.vala"
			prev = _gee_linked_list_node_ref0 (self->priv->_head);
#line 859 "linkedlist.c"
			{
				gint i;
#line 189 "linkedlist.vala"
				i = 0;
#line 864 "linkedlist.c"
				{
					gboolean _tmp4_;
#line 189 "linkedlist.vala"
					_tmp4_ = TRUE;
#line 189 "linkedlist.vala"
					while (TRUE) {
#line 871 "linkedlist.c"
						GeeLinkedListNode* _tmp5_;
#line 189 "linkedlist.vala"
						if (!_tmp4_) {
#line 189 "linkedlist.vala"
							i++;
#line 877 "linkedlist.c"
						}
#line 189 "linkedlist.vala"
						_tmp4_ = FALSE;
#line 189 "linkedlist.vala"
						if (!(i < (index - 1))) {
#line 189 "linkedlist.vala"
							break;
#line 885 "linkedlist.c"
						}
#line 190 "linkedlist.vala"
						prev = (_tmp5_ = _gee_linked_list_node_ref0 (prev->next), _gee_linked_list_node_unref0 (prev), _tmp5_);
#line 889 "linkedlist.c"
					}
				}
			}
#line 192 "linkedlist.vala"
			n->prev = (_tmp6_ = _gee_linked_list_node_ref0 (prev), _gee_linked_list_node_unref0 (n->prev), _tmp6_);
#line 193 "linkedlist.vala"
			n->next = (_tmp7_ = _gee_linked_list_node_ref0 (prev->next), _gee_linked_list_node_unref0 (n->next), _tmp7_);
#line 194 "linkedlist.vala"
			n->next->prev = (_tmp8_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (n->next->prev), _tmp8_);
#line 195 "linkedlist.vala"
			prev->next = (_tmp9_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (prev->next), _tmp9_);
#line 901 "linkedlist.c"
			_gee_linked_list_node_unref0 (prev);
		}
#line 201 "linkedlist.vala"
		self->priv->_size++;
#line 906 "linkedlist.c"
		_gee_linked_list_node_unref0 (n);
	}
}


/**
 * {@inheritDoc}
 */
#line 208 "linkedlist.vala"
static gpointer gee_linked_list_real_remove_at (GeeAbstractList* base, gint index) {
#line 917 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	GeeLinkedListNode* n;
	gconstpointer _tmp0_;
	gpointer element;
	self = (GeeLinkedList*) base;
#line 209 "linkedlist.vala"
	g_assert (index >= 0);
#line 210 "linkedlist.vala"
	g_assert (index < self->priv->_size);
#line 212 "linkedlist.vala"
	n = _gee_linked_list_get_node_at (self, index);
#line 213 "linkedlist.vala"
	g_return_if_fail (n != NULL);
#line 214 "linkedlist.vala"
	element = (_tmp0_ = n->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 215 "linkedlist.vala"
	_gee_linked_list_remove_node (self, _gee_linked_list_node_ref0 (n));
#line 936 "linkedlist.c"
	result = element;
#line 216 "linkedlist.vala"
	return result;
#line 940 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 222 "linkedlist.vala"
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop) {
#line 949 "linkedlist.c"
	GeeLinkedList * self;
	GeeList* result = NULL;
	GeeList* slice;
	GeeLinkedListNode* n;
	self = (GeeLinkedList*) base;
#line 223 "linkedlist.vala"
	g_return_val_if_fail (start <= stop, NULL);
#line 224 "linkedlist.vala"
	g_return_val_if_fail (start >= 0, NULL);
#line 225 "linkedlist.vala"
	g_return_val_if_fail (stop <= self->priv->_size, NULL);
#line 227 "linkedlist.vala"
	slice = (GeeList*) gee_linked_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, gee_linked_list_get_equal_func (self));
#line 228 "linkedlist.vala"
	n = _gee_linked_list_node_ref0 (_gee_linked_list_get_node_at (self, start));
#line 965 "linkedlist.c"
	{
		gint i;
#line 229 "linkedlist.vala"
		i = start;
#line 970 "linkedlist.c"
		{
			gboolean _tmp0_;
#line 229 "linkedlist.vala"
			_tmp0_ = TRUE;
#line 229 "linkedlist.vala"
			while (TRUE) {
#line 977 "linkedlist.c"
				GeeLinkedListNode* _tmp1_;
#line 229 "linkedlist.vala"
				if (!_tmp0_) {
#line 229 "linkedlist.vala"
					i++;
#line 983 "linkedlist.c"
				}
#line 229 "linkedlist.vala"
				_tmp0_ = FALSE;
#line 229 "linkedlist.vala"
				if (!(i < stop)) {
#line 229 "linkedlist.vala"
					break;
#line 991 "linkedlist.c"
				}
#line 230 "linkedlist.vala"
				gee_collection_add ((GeeCollection*) slice, n->data);
#line 231 "linkedlist.vala"
				n = (_tmp1_ = _gee_linked_list_node_ref0 (n->next), _gee_linked_list_node_unref0 (n), _tmp1_);
#line 997 "linkedlist.c"
			}
		}
	}
	result = slice;
	_gee_linked_list_node_unref0 (n);
#line 234 "linkedlist.vala"
	return result;
#line 1005 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 240 "linkedlist.vala"
static gpointer gee_linked_list_real_first (GeeAbstractList* base) {
#line 1014 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeLinkedList*) base;
#line 241 "linkedlist.vala"
	g_assert (self->priv->_size > 0);
#line 1021 "linkedlist.c"
	result = (_tmp0_ = self->priv->_head->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 242 "linkedlist.vala"
	return result;
#line 1025 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 248 "linkedlist.vala"
static gpointer gee_linked_list_real_last (GeeAbstractList* base) {
#line 1034 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeLinkedList*) base;
#line 249 "linkedlist.vala"
	g_assert (self->priv->_size > 0);
#line 1041 "linkedlist.c"
	result = (_tmp0_ = self->priv->_tail->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 250 "linkedlist.vala"
	return result;
#line 1045 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 277 "linkedlist.vala"
static gboolean gee_linked_list_real_offer (GeeQueue* base, gconstpointer element) {
#line 1054 "linkedlist.c"
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	result = gee_deque_offer_tail ((GeeDeque*) self, element);
#line 278 "linkedlist.vala"
	return result;
#line 1061 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 284 "linkedlist.vala"
static gpointer gee_linked_list_real_peek (GeeQueue* base) {
#line 1070 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
	result = gee_deque_peek_head ((GeeDeque*) self);
#line 285 "linkedlist.vala"
	return result;
#line 1077 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 291 "linkedlist.vala"
static gpointer gee_linked_list_real_poll (GeeQueue* base) {
#line 1086 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
	result = gee_deque_poll_head ((GeeDeque*) self);
#line 292 "linkedlist.vala"
	return result;
#line 1093 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 298 "linkedlist.vala"
static gint gee_linked_list_real_drain (GeeQueue* base, GeeCollection* recipient, gint amount) {
#line 1102 "linkedlist.c"
	GeeLinkedList * self;
	gint result = 0;
	self = (GeeLinkedList*) base;
#line 298 "linkedlist.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 1108 "linkedlist.c"
	result = gee_deque_drain_head ((GeeDeque*) self, recipient, amount);
#line 299 "linkedlist.vala"
	return result;
#line 1112 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 305 "linkedlist.vala"
static gboolean gee_linked_list_real_offer_head (GeeDeque* base, gconstpointer element) {
#line 1121 "linkedlist.c"
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
#line 306 "linkedlist.vala"
	gee_abstract_list_insert ((GeeAbstractList*) self, 0, element);
#line 1127 "linkedlist.c"
	result = TRUE;
#line 307 "linkedlist.vala"
	return result;
#line 1131 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 313 "linkedlist.vala"
static gpointer gee_linked_list_real_peek_head (GeeDeque* base) {
#line 1140 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
#line 314 "linkedlist.vala"
	if (self->priv->_size == 0) {
#line 1146 "linkedlist.c"
		result = NULL;
#line 315 "linkedlist.vala"
		return result;
#line 1150 "linkedlist.c"
	}
	result = gee_abstract_list_get ((GeeAbstractList*) self, 0);
#line 317 "linkedlist.vala"
	return result;
#line 1155 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 323 "linkedlist.vala"
static gpointer gee_linked_list_real_poll_head (GeeDeque* base) {
#line 1164 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
#line 324 "linkedlist.vala"
	if (self->priv->_size == 0) {
#line 1170 "linkedlist.c"
		result = NULL;
#line 325 "linkedlist.vala"
		return result;
#line 1174 "linkedlist.c"
	}
	result = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0);
#line 327 "linkedlist.vala"
	return result;
#line 1179 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 333 "linkedlist.vala"
static gint gee_linked_list_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount) {
#line 1188 "linkedlist.c"
	GeeLinkedList * self;
	gint result = 0;
	self = (GeeLinkedList*) base;
#line 333 "linkedlist.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 334 "linkedlist.vala"
	if (amount == (-1)) {
#line 335 "linkedlist.vala"
		amount = self->priv->_size;
#line 1198 "linkedlist.c"
	}
	{
		gint i;
#line 337 "linkedlist.vala"
		i = 0;
#line 1204 "linkedlist.c"
		{
			gboolean _tmp0_;
#line 337 "linkedlist.vala"
			_tmp0_ = TRUE;
#line 337 "linkedlist.vala"
			while (TRUE) {
#line 1211 "linkedlist.c"
				gpointer _tmp1_;
#line 337 "linkedlist.vala"
				if (!_tmp0_) {
#line 337 "linkedlist.vala"
					i++;
#line 1217 "linkedlist.c"
				}
#line 337 "linkedlist.vala"
				_tmp0_ = FALSE;
#line 337 "linkedlist.vala"
				if (!(i < amount)) {
#line 337 "linkedlist.vala"
					break;
#line 1225 "linkedlist.c"
				}
#line 338 "linkedlist.vala"
				if (self->priv->_size == 0) {
#line 1229 "linkedlist.c"
					result = i;
#line 339 "linkedlist.vala"
					return result;
#line 1233 "linkedlist.c"
				}
#line 341 "linkedlist.vala"
				gee_collection_add (recipient, _tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0));
#line 1237 "linkedlist.c"
				((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
			}
		}
	}
	result = amount;
#line 343 "linkedlist.vala"
	return result;
#line 1245 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 349 "linkedlist.vala"
static gboolean gee_linked_list_real_offer_tail (GeeDeque* base, gconstpointer element) {
#line 1254 "linkedlist.c"
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	result = gee_abstract_collection_add ((GeeAbstractCollection*) self, element);
#line 350 "linkedlist.vala"
	return result;
#line 1261 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 356 "linkedlist.vala"
static gpointer gee_linked_list_real_peek_tail (GeeDeque* base) {
#line 1270 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
#line 357 "linkedlist.vala"
	if (self->priv->_size == 0) {
#line 1276 "linkedlist.c"
		result = NULL;
#line 358 "linkedlist.vala"
		return result;
#line 1280 "linkedlist.c"
	}
	result = gee_abstract_list_get ((GeeAbstractList*) self, self->priv->_size - 1);
#line 360 "linkedlist.vala"
	return result;
#line 1285 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 366 "linkedlist.vala"
static gpointer gee_linked_list_real_poll_tail (GeeDeque* base) {
#line 1294 "linkedlist.c"
	GeeLinkedList * self;
	gpointer result = NULL;
	self = (GeeLinkedList*) base;
#line 367 "linkedlist.vala"
	if (self->priv->_size == 0) {
#line 1300 "linkedlist.c"
		result = NULL;
#line 368 "linkedlist.vala"
		return result;
#line 1304 "linkedlist.c"
	}
	result = gee_abstract_list_remove_at ((GeeAbstractList*) self, self->priv->_size - 1);
#line 370 "linkedlist.vala"
	return result;
#line 1309 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
#line 376 "linkedlist.vala"
static gint gee_linked_list_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount) {
#line 1318 "linkedlist.c"
	GeeLinkedList * self;
	gint result = 0;
	self = (GeeLinkedList*) base;
#line 376 "linkedlist.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 377 "linkedlist.vala"
	if (amount == (-1)) {
#line 378 "linkedlist.vala"
		amount = self->priv->_size;
#line 1328 "linkedlist.c"
	}
	{
		gint i;
#line 380 "linkedlist.vala"
		i = 0;
#line 1334 "linkedlist.c"
		{
			gboolean _tmp0_;
#line 380 "linkedlist.vala"
			_tmp0_ = TRUE;
#line 380 "linkedlist.vala"
			while (TRUE) {
#line 1341 "linkedlist.c"
				gpointer _tmp1_;
#line 380 "linkedlist.vala"
				if (!_tmp0_) {
#line 380 "linkedlist.vala"
					i++;
#line 1347 "linkedlist.c"
				}
#line 380 "linkedlist.vala"
				_tmp0_ = FALSE;
#line 380 "linkedlist.vala"
				if (!(i < amount)) {
#line 380 "linkedlist.vala"
					break;
#line 1355 "linkedlist.c"
				}
#line 381 "linkedlist.vala"
				if (self->priv->_size == 0) {
#line 1359 "linkedlist.c"
					result = i;
#line 382 "linkedlist.vala"
					return result;
#line 1363 "linkedlist.c"
				}
#line 384 "linkedlist.vala"
				gee_collection_add (recipient, _tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, self->priv->_size - 1));
#line 1367 "linkedlist.c"
				((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
			}
		}
	}
	result = amount;
#line 386 "linkedlist.vala"
	return result;
#line 1375 "linkedlist.c"
}


#line 567 "linkedlist.vala"
static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index) {
#line 1381 "linkedlist.c"
	GeeLinkedListNode* result = NULL;
	GeeLinkedListNode* n;
#line 567 "linkedlist.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 568 "linkedlist.vala"
	n = NULL;
#line 1388 "linkedlist.c"
	;
#line 569 "linkedlist.vala"
	if (index == 0) {
#line 570 "linkedlist.vala"
		n = self->priv->_head;
#line 1394 "linkedlist.c"
	} else {
#line 571 "linkedlist.vala"
		if (index == (self->priv->_size - 1)) {
#line 572 "linkedlist.vala"
			n = self->priv->_tail;
#line 1400 "linkedlist.c"
		} else {
#line 573 "linkedlist.vala"
			if (index <= (self->priv->_size / 2)) {
#line 574 "linkedlist.vala"
				n = self->priv->_head;
#line 1406 "linkedlist.c"
				{
					gint i;
#line 575 "linkedlist.vala"
					i = 0;
#line 1411 "linkedlist.c"
					{
						gboolean _tmp0_;
#line 575 "linkedlist.vala"
						_tmp0_ = TRUE;
#line 575 "linkedlist.vala"
						while (TRUE) {
#line 575 "linkedlist.vala"
							if (!_tmp0_) {
#line 575 "linkedlist.vala"
								i++;
#line 1422 "linkedlist.c"
							}
#line 575 "linkedlist.vala"
							_tmp0_ = FALSE;
#line 575 "linkedlist.vala"
							if (!(index != i)) {
#line 575 "linkedlist.vala"
								break;
#line 1430 "linkedlist.c"
							}
#line 576 "linkedlist.vala"
							n = n->next;
#line 1434 "linkedlist.c"
						}
					}
				}
			} else {
#line 579 "linkedlist.vala"
				n = self->priv->_tail;
#line 1441 "linkedlist.c"
				{
					gint i;
#line 580 "linkedlist.vala"
					i = self->priv->_size - 1;
#line 1446 "linkedlist.c"
					{
						gboolean _tmp1_;
#line 580 "linkedlist.vala"
						_tmp1_ = TRUE;
#line 580 "linkedlist.vala"
						while (TRUE) {
#line 580 "linkedlist.vala"
							if (!_tmp1_) {
#line 580 "linkedlist.vala"
								i--;
#line 1457 "linkedlist.c"
							}
#line 580 "linkedlist.vala"
							_tmp1_ = FALSE;
#line 580 "linkedlist.vala"
							if (!(index != i)) {
#line 580 "linkedlist.vala"
								break;
#line 1465 "linkedlist.c"
							}
#line 581 "linkedlist.vala"
							n = n->prev;
#line 1469 "linkedlist.c"
						}
					}
				}
			}
		}
	}
	result = n;
#line 584 "linkedlist.vala"
	return result;
#line 1479 "linkedlist.c"
}


#line 587 "linkedlist.vala"
static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* n) {
#line 1485 "linkedlist.c"
	GeeLinkedListNode* _tmp4_;
	GeeLinkedListNode* _tmp5_;
#line 587 "linkedlist.vala"
	g_return_if_fail (self != NULL);
#line 587 "linkedlist.vala"
	g_return_if_fail (n != NULL);
#line 588 "linkedlist.vala"
	if (n == self->priv->_head) {
#line 1494 "linkedlist.c"
		GeeLinkedListNode* _tmp0_;
#line 589 "linkedlist.vala"
		self->priv->_head = (_tmp0_ = _gee_linked_list_node_ref0 (n->next), _gee_linked_list_node_unref0 (self->priv->_head), _tmp0_);
#line 1498 "linkedlist.c"
	}
#line 591 "linkedlist.vala"
	if (n == self->priv->_tail) {
#line 1502 "linkedlist.c"
		GeeLinkedListNode* _tmp1_;
#line 592 "linkedlist.vala"
		self->priv->_tail = (_tmp1_ = _gee_linked_list_node_ref0 (n->prev), _gee_linked_list_node_unref0 (self->priv->_tail), _tmp1_);
#line 1506 "linkedlist.c"
	}
#line 594 "linkedlist.vala"
	if (n->prev != NULL) {
#line 1510 "linkedlist.c"
		GeeLinkedListNode* _tmp2_;
#line 595 "linkedlist.vala"
		n->prev->next = (_tmp2_ = _gee_linked_list_node_ref0 (n->next), _gee_linked_list_node_unref0 (n->prev->next), _tmp2_);
#line 1514 "linkedlist.c"
	}
#line 597 "linkedlist.vala"
	if (n->next != NULL) {
#line 1518 "linkedlist.c"
		GeeLinkedListNode* _tmp3_;
#line 598 "linkedlist.vala"
		n->next->prev = (_tmp3_ = _gee_linked_list_node_ref0 (n->prev), _gee_linked_list_node_unref0 (n->next->prev), _tmp3_);
#line 1522 "linkedlist.c"
	}
#line 600 "linkedlist.vala"
	n->prev = (_tmp4_ = NULL, _gee_linked_list_node_unref0 (n->prev), _tmp4_);
#line 601 "linkedlist.vala"
	n->next = (_tmp5_ = NULL, _gee_linked_list_node_unref0 (n->next), _tmp5_);
#line 602 "linkedlist.vala"
	self->priv->_stamp = self->priv->_stamp + 1;
#line 603 "linkedlist.vala"
	self->priv->_size--;
#line 1532 "linkedlist.c"
	_gee_linked_list_node_unref0 (n);
}


GEqualFunc gee_linked_list_get_equal_func (GeeLinkedList* self) {
	GEqualFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_equal_func;
#line 44 "linkedlist.vala"
	return result;
#line 1543 "linkedlist.c"
}


static void gee_linked_list_set_equal_func (GeeLinkedList* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_equal_func = value;
	g_object_notify ((GObject *) self, "equal-func");
}


static gint gee_linked_list_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = self->priv->_size;
#line 79 "linkedlist.vala"
	return result;
#line 1561 "linkedlist.c"
}


static gint gee_linked_list_real_get_capacity (GeeQueue* base) {
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 257 "linkedlist.vala"
	return result;
#line 1572 "linkedlist.c"
}


static gint gee_linked_list_real_get_remaining_capacity (GeeQueue* base) {
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 264 "linkedlist.vala"
	return result;
#line 1583 "linkedlist.c"
}


static gboolean gee_linked_list_real_get_is_full (GeeQueue* base) {
	gboolean result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = FALSE;
#line 271 "linkedlist.vala"
	return result;
#line 1594 "linkedlist.c"
}


#line 393 "linkedlist.vala"
static GeeLinkedListNode* gee_linked_list_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
#line 1600 "linkedlist.c"
	GeeLinkedListNode* self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeeLinkedListNode*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
#line 394 "linkedlist.vala"
	self->data = (_tmp1_ = (_tmp0_ = data, ((_tmp0_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp0_) : g_dup_func ((gpointer) _tmp0_)), _g_destroy_func0 (self->data), _tmp1_);
#line 1610 "linkedlist.c"
	return self;
}


#line 393 "linkedlist.vala"
static GeeLinkedListNode* gee_linked_list_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
#line 393 "linkedlist.vala"
	return gee_linked_list_node_construct (GEE_LINKED_LIST_TYPE_NODE, g_type, g_dup_func, g_destroy_func, data);
#line 1619 "linkedlist.c"
}


static void gee_linked_list_value_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gee_linked_list_value_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gee_linked_list_node_unref (value->data[0].v_pointer);
	}
}


static void gee_linked_list_value_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_linked_list_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gee_linked_list_value_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gee_linked_list_value_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeeLinkedListNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_linked_list_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gee_linked_list_value_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeeLinkedListNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_linked_list_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gee_linked_list_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GeeLinkedListParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_LINKED_LIST_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gee_linked_list_value_get_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_LINKED_LIST_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}


static void gee_linked_list_value_set_node (GValue* value, gpointer v_object) {
	GeeLinkedListNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_LINKED_LIST_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_LINKED_LIST_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_linked_list_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_linked_list_node_unref (old);
	}
}


static void gee_linked_list_value_take_node (GValue* value, gpointer v_object) {
	GeeLinkedListNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_LINKED_LIST_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_LINKED_LIST_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_linked_list_node_unref (old);
	}
}


static void gee_linked_list_node_class_init (GeeLinkedListNodeClass * klass) {
	gee_linked_list_node_parent_class = g_type_class_peek_parent (klass);
	GEE_LINKED_LIST_NODE_CLASS (klass)->finalize = gee_linked_list_node_finalize;
	g_type_class_add_private (klass, sizeof (GeeLinkedListNodePrivate));
}


static void gee_linked_list_node_instance_init (GeeLinkedListNode * self) {
	self->priv = GEE_LINKED_LIST_NODE_GET_PRIVATE (self);
	self->prev = NULL;
	self->next = NULL;
	self->ref_count = 1;
}


static void gee_linked_list_node_finalize (GeeLinkedListNode* obj) {
	GeeLinkedListNode * self;
	self = GEE_LINKED_LIST_NODE (obj);
	((self->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->data = (self->priv->g_destroy_func (self->data), NULL));
	_gee_linked_list_node_unref0 (self->prev);
	_gee_linked_list_node_unref0 (self->next);
}


static GType gee_linked_list_node_get_type (void) {
	static volatile gsize gee_linked_list_node_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_linked_list_value_node_init, gee_linked_list_value_node_free_value, gee_linked_list_value_node_copy_value, gee_linked_list_value_node_peek_pointer, "p", gee_linked_list_value_node_collect_value, "p", gee_linked_list_value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedListNode), 0, (GInstanceInitFunc) gee_linked_list_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_linked_list_node_type_id;
		gee_linked_list_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeeLinkedListNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gee_linked_list_node_type_id__volatile, gee_linked_list_node_type_id);
	}
	return gee_linked_list_node_type_id__volatile;
}


static gpointer gee_linked_list_node_ref (gpointer instance) {
	GeeLinkedListNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gee_linked_list_node_unref (gpointer instance) {
	GeeLinkedListNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_LINKED_LIST_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 406 "linkedlist.vala"
static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
#line 1796 "linkedlist.c"
	GeeLinkedListIterator * self;
	GeeLinkedList* _tmp0_;
#line 406 "linkedlist.vala"
	g_return_val_if_fail (list != NULL, NULL);
#line 406 "linkedlist.vala"
	self = (GeeLinkedListIterator*) g_object_new (object_type, NULL);
#line 406 "linkedlist.vala"
	self->priv->g_type = g_type;
#line 406 "linkedlist.vala"
	self->priv->g_dup_func = g_dup_func;
#line 406 "linkedlist.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 407 "linkedlist.vala"
	self->priv->_list = (_tmp0_ = _g_object_ref0 (list), _g_object_unref0 (self->priv->_list), _tmp0_);
#line 408 "linkedlist.vala"
	self->priv->position = NULL;
#line 409 "linkedlist.vala"
	self->priv->_index = -1;
#line 410 "linkedlist.vala"
	self->priv->_stamp = list->priv->_stamp;
#line 1817 "linkedlist.c"
	return self;
}


#line 406 "linkedlist.vala"
static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
#line 406 "linkedlist.vala"
	return gee_linked_list_iterator_construct (GEE_LINKED_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
#line 1826 "linkedlist.c"
}


#line 413 "linkedlist.vala"
static gboolean gee_linked_list_iterator_real_next (GeeIterator* base) {
#line 1832 "linkedlist.c"
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (GeeLinkedListIterator*) base;
#line 414 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 416 "linkedlist.vala"
	if (self->priv->removed) {
#line 416 "linkedlist.vala"
		_tmp0_ = self->priv->position != NULL;
#line 1843 "linkedlist.c"
	} else {
#line 416 "linkedlist.vala"
		_tmp0_ = FALSE;
#line 1847 "linkedlist.c"
	}
#line 416 "linkedlist.vala"
	if (_tmp0_) {
#line 417 "linkedlist.vala"
		self->priv->removed = FALSE;
#line 1853 "linkedlist.c"
		result = TRUE;
#line 418 "linkedlist.vala"
		return result;
#line 1857 "linkedlist.c"
	} else {
		gboolean _tmp1_ = FALSE;
#line 419 "linkedlist.vala"
		if (!self->priv->started) {
#line 419 "linkedlist.vala"
			_tmp1_ = self->priv->_list->priv->_head != NULL;
#line 1864 "linkedlist.c"
		} else {
#line 419 "linkedlist.vala"
			_tmp1_ = FALSE;
#line 1868 "linkedlist.c"
		}
#line 419 "linkedlist.vala"
		if (_tmp1_) {
#line 420 "linkedlist.vala"
			self->priv->started = TRUE;
#line 421 "linkedlist.vala"
			self->priv->position = self->priv->_list->priv->_head;
#line 422 "linkedlist.vala"
			self->priv->_index++;
#line 1878 "linkedlist.c"
			result = TRUE;
#line 423 "linkedlist.vala"
			return result;
#line 1882 "linkedlist.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 424 "linkedlist.vala"
			if (self->priv->position != NULL) {
#line 424 "linkedlist.vala"
				_tmp2_ = self->priv->position->next != NULL;
#line 1889 "linkedlist.c"
			} else {
#line 424 "linkedlist.vala"
				_tmp2_ = FALSE;
#line 1893 "linkedlist.c"
			}
#line 424 "linkedlist.vala"
			if (_tmp2_) {
#line 425 "linkedlist.vala"
				self->priv->position = self->priv->position->next;
#line 426 "linkedlist.vala"
				self->priv->_index++;
#line 1901 "linkedlist.c"
				result = TRUE;
#line 427 "linkedlist.vala"
				return result;
#line 1905 "linkedlist.c"
			}
		}
	}
	result = FALSE;
#line 429 "linkedlist.vala"
	return result;
#line 1912 "linkedlist.c"
}


#line 432 "linkedlist.vala"
static gboolean gee_linked_list_iterator_real_has_next (GeeIterator* base) {
#line 1918 "linkedlist.c"
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
#line 433 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 435 "linkedlist.vala"
	if (self->priv->removed) {
#line 1926 "linkedlist.c"
		result = self->priv->position != NULL;
#line 436 "linkedlist.vala"
		return result;
#line 1930 "linkedlist.c"
	} else {
#line 437 "linkedlist.vala"
		if (!self->priv->started) {
#line 1934 "linkedlist.c"
			result = self->priv->_list->priv->_head != NULL;
#line 438 "linkedlist.vala"
			return result;
#line 1938 "linkedlist.c"
		} else {
#line 439 "linkedlist.vala"
			if (self->priv->position != NULL) {
#line 1942 "linkedlist.c"
				result = self->priv->position->next != NULL;
#line 440 "linkedlist.vala"
				return result;
#line 1946 "linkedlist.c"
			}
		}
	}
	result = FALSE;
#line 442 "linkedlist.vala"
	return result;
#line 1953 "linkedlist.c"
}


#line 445 "linkedlist.vala"
static gboolean gee_linked_list_iterator_real_first (GeeIterator* base) {
#line 1959 "linkedlist.c"
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
#line 446 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 447 "linkedlist.vala"
	if (gee_collection_get_size ((GeeCollection*) self->priv->_list) == 0) {
#line 1967 "linkedlist.c"
		result = FALSE;
#line 448 "linkedlist.vala"
		return result;
#line 1971 "linkedlist.c"
	}
#line 450 "linkedlist.vala"
	self->priv->position = self->priv->_list->priv->_head;
#line 451 "linkedlist.vala"
	self->priv->started = TRUE;
#line 452 "linkedlist.vala"
	self->priv->_index = 0;
#line 453 "linkedlist.vala"
	self->priv->removed = FALSE;
#line 1981 "linkedlist.c"
	result = self->priv->position != NULL;
#line 454 "linkedlist.vala"
	return result;
#line 1985 "linkedlist.c"
}


#line 457 "linkedlist.vala"
static gpointer gee_linked_list_iterator_real_get (GeeIterator* base) {
#line 1991 "linkedlist.c"
	GeeLinkedListIterator * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeLinkedListIterator*) base;
#line 458 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 459 "linkedlist.vala"
	g_assert (self->priv->position != NULL);
#line 2000 "linkedlist.c"
	result = (_tmp0_ = self->priv->position->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 461 "linkedlist.vala"
	return result;
#line 2004 "linkedlist.c"
}


#line 464 "linkedlist.vala"
static void gee_linked_list_iterator_real_remove (GeeIterator* base) {
#line 2010 "linkedlist.c"
	GeeLinkedListIterator * self;
	GeeLinkedListNode* new_position;
	self = (GeeLinkedListIterator*) base;
#line 465 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 466 "linkedlist.vala"
	g_assert (self->priv->position != NULL);
#line 468 "linkedlist.vala"
	new_position = self->priv->position->next;
#line 469 "linkedlist.vala"
	if (new_position == NULL) {
#line 470 "linkedlist.vala"
		self->priv->started = FALSE;
#line 2024 "linkedlist.c"
	}
#line 472 "linkedlist.vala"
	_gee_linked_list_remove_node (self->priv->_list, _gee_linked_list_node_ref0 (self->priv->position));
#line 473 "linkedlist.vala"
	self->priv->position = new_position;
#line 474 "linkedlist.vala"
	self->priv->removed = TRUE;
#line 475 "linkedlist.vala"
	self->priv->_stamp = self->priv->_list->priv->_stamp;
#line 2034 "linkedlist.c"
}


#line 478 "linkedlist.vala"
static gboolean gee_linked_list_iterator_real_previous (GeeBidirIterator* base) {
#line 2040 "linkedlist.c"
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
#line 479 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 481 "linkedlist.vala"
	if (!self->priv->started) {
#line 482 "linkedlist.vala"
		self->priv->position = NULL;
#line 2050 "linkedlist.c"
		result = FALSE;
#line 483 "linkedlist.vala"
		return result;
#line 2054 "linkedlist.c"
	} else {
		gboolean _tmp0_ = FALSE;
#line 484 "linkedlist.vala"
		if (self->priv->position != NULL) {
#line 484 "linkedlist.vala"
			_tmp0_ = self->priv->position->prev != NULL;
#line 2061 "linkedlist.c"
		} else {
#line 484 "linkedlist.vala"
			_tmp0_ = FALSE;
#line 2065 "linkedlist.c"
		}
#line 484 "linkedlist.vala"
		if (_tmp0_) {
#line 485 "linkedlist.vala"
			self->priv->position = self->priv->position->prev;
#line 486 "linkedlist.vala"
			self->priv->_index--;
#line 2073 "linkedlist.c"
			result = TRUE;
#line 487 "linkedlist.vala"
			return result;
#line 2077 "linkedlist.c"
		}
	}
	result = FALSE;
#line 489 "linkedlist.vala"
	return result;
#line 2083 "linkedlist.c"
}


#line 492 "linkedlist.vala"
static gboolean gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base) {
#line 2089 "linkedlist.c"
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
#line 493 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 495 "linkedlist.vala"
	if (!self->priv->started) {
#line 2097 "linkedlist.c"
		result = FALSE;
#line 496 "linkedlist.vala"
		return result;
#line 2101 "linkedlist.c"
	} else {
#line 497 "linkedlist.vala"
		if (self->priv->position != NULL) {
#line 2105 "linkedlist.c"
			result = self->priv->position->prev != NULL;
#line 498 "linkedlist.vala"
			return result;
#line 2109 "linkedlist.c"
		}
	}
	result = FALSE;
#line 500 "linkedlist.vala"
	return result;
#line 2115 "linkedlist.c"
}


#line 503 "linkedlist.vala"
static gboolean gee_linked_list_iterator_real_last (GeeBidirIterator* base) {
#line 2121 "linkedlist.c"
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	self = (GeeLinkedListIterator*) base;
#line 504 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 506 "linkedlist.vala"
	if (gee_collection_get_size ((GeeCollection*) self->priv->_list) == 0) {
#line 2129 "linkedlist.c"
		result = FALSE;
#line 507 "linkedlist.vala"
		return result;
#line 2133 "linkedlist.c"
	}
#line 509 "linkedlist.vala"
	self->priv->position = self->priv->_list->priv->_tail;
#line 510 "linkedlist.vala"
	self->priv->started = TRUE;
#line 511 "linkedlist.vala"
	self->priv->_index = self->priv->_list->priv->_size - 1;
#line 2141 "linkedlist.c"
	result = self->priv->position != NULL;
#line 512 "linkedlist.vala"
	return result;
#line 2145 "linkedlist.c"
}


#line 515 "linkedlist.vala"
static void gee_linked_list_iterator_real_set (GeeListIterator* base, gconstpointer item) {
#line 2151 "linkedlist.c"
	GeeLinkedListIterator * self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeeLinkedListIterator*) base;
#line 516 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 517 "linkedlist.vala"
	g_assert (self->priv->position != NULL);
#line 519 "linkedlist.vala"
	self->priv->position->data = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((self->priv->position->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->position->data = (self->priv->g_destroy_func (self->priv->position->data), NULL)), _tmp1_);
#line 2162 "linkedlist.c"
}


#line 522 "linkedlist.vala"
static void gee_linked_list_iterator_real_insert (GeeListIterator* base, gconstpointer item) {
#line 2168 "linkedlist.c"
	GeeLinkedListIterator * self;
	GeeLinkedListNode* n;
	GeeLinkedListNode* _tmp3_;
	GeeLinkedListNode* _tmp4_;
	self = (GeeLinkedListIterator*) base;
#line 523 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 524 "linkedlist.vala"
	g_assert (self->priv->position != NULL);
#line 526 "linkedlist.vala"
	n = gee_linked_list_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, item);
#line 527 "linkedlist.vala"
	if (self->priv->position->prev != NULL) {
#line 2182 "linkedlist.c"
		GeeLinkedListNode* _tmp0_;
		GeeLinkedListNode* _tmp1_;
#line 528 "linkedlist.vala"
		self->priv->position->prev->next = (_tmp0_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->position->prev->next), _tmp0_);
#line 529 "linkedlist.vala"
		n->prev = (_tmp1_ = _gee_linked_list_node_ref0 (self->priv->position->prev), _gee_linked_list_node_unref0 (n->prev), _tmp1_);
#line 2189 "linkedlist.c"
	} else {
		GeeLinkedListNode* _tmp2_;
#line 531 "linkedlist.vala"
		self->priv->_list->priv->_head = (_tmp2_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_list->priv->_head), _tmp2_);
#line 2194 "linkedlist.c"
	}
#line 533 "linkedlist.vala"
	self->priv->position->prev = (_tmp3_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->position->prev), _tmp3_);
#line 534 "linkedlist.vala"
	n->next = (_tmp4_ = _gee_linked_list_node_ref0 (self->priv->position), _gee_linked_list_node_unref0 (n->next), _tmp4_);
#line 535 "linkedlist.vala"
	self->priv->_list->priv->_size++;
#line 536 "linkedlist.vala"
	self->priv->_index++;
#line 537 "linkedlist.vala"
	self->priv->_stamp = self->priv->_list->priv->_stamp;
#line 2206 "linkedlist.c"
	_gee_linked_list_node_unref0 (n);
}


#line 540 "linkedlist.vala"
static void gee_linked_list_iterator_real_add (GeeListIterator* base, gconstpointer item) {
#line 2213 "linkedlist.c"
	GeeLinkedListIterator * self;
	GeeLinkedListNode* n;
	GeeLinkedListNode* _tmp3_;
	GeeLinkedListNode* _tmp4_;
	self = (GeeLinkedListIterator*) base;
#line 541 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 542 "linkedlist.vala"
	g_assert (self->priv->position != NULL);
#line 544 "linkedlist.vala"
	n = gee_linked_list_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, item);
#line 545 "linkedlist.vala"
	if (self->priv->position->next != NULL) {
#line 2227 "linkedlist.c"
		GeeLinkedListNode* _tmp0_;
		GeeLinkedListNode* _tmp1_;
#line 546 "linkedlist.vala"
		self->priv->position->next->prev = (_tmp0_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->position->next->prev), _tmp0_);
#line 547 "linkedlist.vala"
		n->next = (_tmp1_ = _gee_linked_list_node_ref0 (self->priv->position->next), _gee_linked_list_node_unref0 (n->next), _tmp1_);
#line 2234 "linkedlist.c"
	} else {
		GeeLinkedListNode* _tmp2_;
#line 549 "linkedlist.vala"
		self->priv->_list->priv->_tail = (_tmp2_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->_list->priv->_tail), _tmp2_);
#line 2239 "linkedlist.c"
	}
#line 551 "linkedlist.vala"
	self->priv->position->next = (_tmp3_ = _gee_linked_list_node_ref0 (n), _gee_linked_list_node_unref0 (self->priv->position->next), _tmp3_);
#line 552 "linkedlist.vala"
	n->prev = (_tmp4_ = _gee_linked_list_node_ref0 (self->priv->position), _gee_linked_list_node_unref0 (n->prev), _tmp4_);
#line 553 "linkedlist.vala"
	self->priv->position = n;
#line 554 "linkedlist.vala"
	self->priv->_list->priv->_size++;
#line 555 "linkedlist.vala"
	self->priv->_index++;
#line 556 "linkedlist.vala"
	self->priv->_stamp = self->priv->_list->priv->_stamp;
#line 2253 "linkedlist.c"
	_gee_linked_list_node_unref0 (n);
}


#line 559 "linkedlist.vala"
static gint gee_linked_list_iterator_real_index (GeeListIterator* base) {
#line 2260 "linkedlist.c"
	GeeLinkedListIterator * self;
	gint result = 0;
	self = (GeeLinkedListIterator*) base;
#line 560 "linkedlist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 561 "linkedlist.vala"
	g_assert (self->priv->position != NULL);
#line 2268 "linkedlist.c"
	result = self->priv->_index;
#line 563 "linkedlist.vala"
	return result;
#line 2272 "linkedlist.c"
}


static void gee_linked_list_iterator_class_init (GeeLinkedListIteratorClass * klass) {
	gee_linked_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeLinkedListIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_linked_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_linked_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_linked_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_linked_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_linked_list_iterator_real_next;
	iface->has_next = gee_linked_list_iterator_real_has_next;
	iface->first = gee_linked_list_iterator_real_first;
	iface->get = gee_linked_list_iterator_real_get;
	iface->remove = gee_linked_list_iterator_real_remove;
}


static void gee_linked_list_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_linked_list_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = gee_linked_list_iterator_real_previous;
	iface->has_previous = gee_linked_list_iterator_real_has_previous;
	iface->last = gee_linked_list_iterator_real_last;
}


static void gee_linked_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface) {
	gee_linked_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->set = gee_linked_list_iterator_real_set;
	iface->insert = gee_linked_list_iterator_real_insert;
	iface->add = gee_linked_list_iterator_real_add;
	iface->index = gee_linked_list_iterator_real_index;
}


static void gee_linked_list_iterator_instance_init (GeeLinkedListIterator * self) {
	self->priv = GEE_LINKED_LIST_ITERATOR_GET_PRIVATE (self);
	self->priv->started = FALSE;
	self->priv->removed = FALSE;
}


static void gee_linked_list_iterator_finalize (GObject* obj) {
	GeeLinkedListIterator * self;
	self = GEE_LINKED_LIST_ITERATOR (obj);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (gee_linked_list_iterator_parent_class)->finalize (obj);
}


static GType gee_linked_list_iterator_get_type (void) {
	static volatile gsize gee_linked_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedListIterator), 0, (GInstanceInitFunc) gee_linked_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_iterator_type_id;
		gee_linked_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeLinkedListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
		g_once_init_leave (&gee_linked_list_iterator_type_id__volatile, gee_linked_list_iterator_type_id);
	}
	return gee_linked_list_iterator_type_id__volatile;
}


static void gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = GEE_LINKED_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = GEE_LINKED_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_linked_list_class_init (GeeLinkedListClass * klass) {
	gee_linked_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeLinkedListPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_linked_list_real_iterator;
	GEE_ABSTRACT_LIST_CLASS (klass)->list_iterator = gee_linked_list_real_list_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_linked_list_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_linked_list_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_linked_list_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_linked_list_real_clear;
	GEE_ABSTRACT_LIST_CLASS (klass)->get = gee_linked_list_real_get;
	GEE_ABSTRACT_LIST_CLASS (klass)->set = gee_linked_list_real_set;
	GEE_ABSTRACT_LIST_CLASS (klass)->index_of = gee_linked_list_real_index_of;
	GEE_ABSTRACT_LIST_CLASS (klass)->insert = gee_linked_list_real_insert;
	GEE_ABSTRACT_LIST_CLASS (klass)->remove_at = gee_linked_list_real_remove_at;
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = gee_linked_list_real_slice;
	GEE_ABSTRACT_LIST_CLASS (klass)->first = gee_linked_list_real_first;
	GEE_ABSTRACT_LIST_CLASS (klass)->last = gee_linked_list_real_last;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_linked_list_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_linked_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_linked_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The elements' equality testing function.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_EQUAL_FUNC, g_param_spec_pointer ("equal-func", "equal-func", "equal-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_SIZE, "size");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_CAPACITY, "capacity");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_REMAINING_CAPACITY, "remaining-capacity");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_IS_FULL, "is-full");
}


static void gee_linked_list_gee_queue_interface_init (GeeQueueIface * iface) {
	gee_linked_list_gee_queue_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer = gee_linked_list_real_offer;
	iface->peek = gee_linked_list_real_peek;
	iface->poll = gee_linked_list_real_poll;
	iface->drain = gee_linked_list_real_drain;
	iface->get_capacity = gee_linked_list_real_get_capacity;
	iface->get_remaining_capacity = gee_linked_list_real_get_remaining_capacity;
	iface->get_is_full = gee_linked_list_real_get_is_full;
}


static void gee_linked_list_gee_deque_interface_init (GeeDequeIface * iface) {
	gee_linked_list_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer_head = gee_linked_list_real_offer_head;
	iface->peek_head = gee_linked_list_real_peek_head;
	iface->poll_head = gee_linked_list_real_poll_head;
	iface->drain_head = gee_linked_list_real_drain_head;
	iface->offer_tail = gee_linked_list_real_offer_tail;
	iface->peek_tail = gee_linked_list_real_peek_tail;
	iface->poll_tail = gee_linked_list_real_poll_tail;
	iface->drain_tail = gee_linked_list_real_drain_tail;
}


static void gee_linked_list_instance_init (GeeLinkedList * self) {
	self->priv = GEE_LINKED_LIST_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->_stamp = 0;
	self->priv->_head = NULL;
	self->priv->_tail = NULL;
}


static void gee_linked_list_finalize (GObject* obj) {
	GeeLinkedList * self;
	self = GEE_LINKED_LIST (obj);
	_gee_linked_list_node_unref0 (self->priv->_head);
	_gee_linked_list_node_unref0 (self->priv->_tail);
	G_OBJECT_CLASS (gee_linked_list_parent_class)->finalize (obj);
}


/**
 * Doubly-linked list implementation of the {@link List} interface.
 *
 * This implementation is pretty well designed for highly mutable data. When
 * indexed access is privileged prefer using {@link ArrayList}.
 *
 * @see ArrayList
 */
GType gee_linked_list_get_type (void) {
	static volatile gsize gee_linked_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedList), 0, (GInstanceInitFunc) gee_linked_list_instance_init, NULL };
		static const GInterfaceInfo gee_queue_info = { (GInterfaceInitFunc) gee_linked_list_gee_queue_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_linked_list_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_type_id;
		gee_linked_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_LIST, "GeeLinkedList", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_QUEUE, &gee_queue_info);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
		g_once_init_leave (&gee_linked_list_type_id__volatile, gee_linked_list_type_id);
	}
	return gee_linked_list_type_id__volatile;
}


static void gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = GEE_LINKED_LIST (object);
	switch (property_id) {
		case GEE_LINKED_LIST_EQUAL_FUNC:
		g_value_set_pointer (value, gee_linked_list_get_equal_func (self));
		break;
		case GEE_LINKED_LIST_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_LINKED_LIST_CAPACITY:
		g_value_set_int (value, gee_queue_get_capacity ((GeeQueue*) self));
		break;
		case GEE_LINKED_LIST_REMAINING_CAPACITY:
		g_value_set_int (value, gee_queue_get_remaining_capacity ((GeeQueue*) self));
		break;
		case GEE_LINKED_LIST_IS_FULL:
		g_value_set_boolean (value, gee_queue_get_is_full ((GeeQueue*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = GEE_LINKED_LIST (object);
	switch (property_id) {
		case GEE_LINKED_LIST_EQUAL_FUNC:
		gee_linked_list_set_equal_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_LINKED_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}




