/* testlist.c generated by valac, the Vala compiler
 * generated from testlist.vala, do not modify */

/* testlist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_LIST_TESTS (list_tests_get_type ())
#define LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_TESTS, ListTests))
#define LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_TESTS, ListTestsClass))
#define IS_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_TESTS))
#define IS_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_TESTS))
#define LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_TESTS, ListTestsClass))

typedef struct _ListTests ListTests;
typedef struct _ListTestsClass ListTestsClass;
typedef struct _ListTestsPrivate ListTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _ListTests {
	CollectionTests parent_instance;
	ListTestsPrivate * priv;
};

struct _ListTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_retained) (ListTests* self);
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer list_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType list_tests_get_type (void) G_GNUC_CONST;
enum  {
	LIST_TESTS_DUMMY_PROPERTY
};
CollectionTests* collection_tests_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void list_tests_test_iterator_is_ordered (ListTests* self);
static void _list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self);
void list_tests_test_list_iterator (ListTests* self);
static void _list_tests_test_list_iterator_gee_test_case_test_method (gpointer self);
void list_tests_test_duplicates_are_retained (ListTests* self);
static void _list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self);
void list_tests_test_get (ListTests* self);
static void _list_tests_test_get_gee_test_case_test_method (gpointer self);
void list_tests_test_set (ListTests* self);
static void _list_tests_test_set_gee_test_case_test_method (gpointer self);
void list_tests_test_insert (ListTests* self);
static void _list_tests_test_insert_gee_test_case_test_method (gpointer self);
void list_tests_test_remove_at (ListTests* self);
static void _list_tests_test_remove_at_gee_test_case_test_method (gpointer self);
void list_tests_test_index_of (ListTests* self);
static void _list_tests_test_index_of_gee_test_case_test_method (gpointer self);
void list_tests_test_first (ListTests* self);
static void _list_tests_test_first_gee_test_case_test_method (gpointer self);
void list_tests_test_last (ListTests* self);
static void _list_tests_test_last_gee_test_case_test_method (gpointer self);
void list_tests_test_insert_all (ListTests* self);
static void _list_tests_test_insert_all_gee_test_case_test_method (gpointer self);
void list_tests_test_slice (ListTests* self);
static void _list_tests_test_slice_gee_test_case_test_method (gpointer self);
ListTests* list_tests_construct (GType object_type, const char* name);
static void list_tests_real_test_duplicates_are_retained (ListTests* self);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self) {
	list_tests_test_iterator_is_ordered (self);
}


static void _list_tests_test_list_iterator_gee_test_case_test_method (gpointer self) {
	list_tests_test_list_iterator (self);
}


static void _list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self) {
	list_tests_test_duplicates_are_retained (self);
}


static void _list_tests_test_get_gee_test_case_test_method (gpointer self) {
	list_tests_test_get (self);
}


static void _list_tests_test_set_gee_test_case_test_method (gpointer self) {
	list_tests_test_set (self);
}


static void _list_tests_test_insert_gee_test_case_test_method (gpointer self) {
	list_tests_test_insert (self);
}


static void _list_tests_test_remove_at_gee_test_case_test_method (gpointer self) {
	list_tests_test_remove_at (self);
}


static void _list_tests_test_index_of_gee_test_case_test_method (gpointer self) {
	list_tests_test_index_of (self);
}


static void _list_tests_test_first_gee_test_case_test_method (gpointer self) {
	list_tests_test_first (self);
}


static void _list_tests_test_last_gee_test_case_test_method (gpointer self) {
	list_tests_test_last (self);
}


static void _list_tests_test_insert_all_gee_test_case_test_method (gpointer self) {
	list_tests_test_insert_all (self);
}


static void _list_tests_test_slice_gee_test_case_test_method (gpointer self) {
	list_tests_test_slice (self);
}


ListTests* list_tests_construct (GType object_type, const char* name) {
	ListTests * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ListTests*) collection_tests_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] iterator is ordered", _list_tests_test_iterator_is_ordered_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] list iterator", _list_tests_test_list_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] duplicates are retained", _list_tests_test_duplicates_are_retained_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] get", _list_tests_test_get_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] set", _list_tests_test_set_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert", _list_tests_test_insert_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] remove_at", _list_tests_test_remove_at_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] index_of", _list_tests_test_index_of_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] first", _list_tests_test_first_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] last", _list_tests_test_last_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert_all", _list_tests_test_insert_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] slice", _list_tests_test_slice_gee_test_case_test_method, self);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void list_tests_test_iterator_is_ordered (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	GeeIterator* iterator;
	GeeIterator* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	iterator = gee_iterable_iterator ((GeeIterable*) test_list);
	g_assert (!gee_iterator_next (iterator));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	iterator = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) test_list), _g_object_unref0 (iterator), _tmp1_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_iterator_get (iterator), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_iterator_get (iterator), "two") == 0);
	_g_free0 (_tmp3_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_iterator_get (iterator), "three") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_iterator_get (iterator), "one") == 0);
	_g_free0 (_tmp5_);
	g_assert (!gee_iterator_next (iterator));
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}


void list_tests_test_list_iterator (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	GeeListIterator* iterator;
	GeeListIterator* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	iterator = gee_list_list_iterator (test_list);
	g_assert (!gee_iterator_has_next ((GeeIterator*) iterator));
	g_assert (!gee_iterator_next ((GeeIterator*) iterator));
	g_assert (!gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator));
	g_assert (!gee_bidir_iterator_previous ((GeeBidirIterator*) iterator));
	g_assert (!gee_iterator_first ((GeeIterator*) iterator));
	g_assert (!gee_bidir_iterator_last ((GeeBidirIterator*) iterator));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "three"));
	iterator = (_tmp1_ = gee_list_list_iterator (test_list), _g_object_unref0 (iterator), _tmp1_);
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	gee_list_iterator_set (iterator, "new one");
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "two") == 0);
	_g_free0 (_tmp3_);
	g_assert (gee_list_iterator_index (iterator) == 1);
	gee_list_iterator_set (iterator, "new two");
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 3);
	g_assert (gee_list_iterator_index (iterator) == 1);
	gee_list_iterator_insert (iterator, "before two");
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 4);
	g_assert (gee_list_iterator_index (iterator) == 2);
	gee_list_iterator_add (iterator, "after two");
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 5);
	g_assert (gee_list_iterator_index (iterator) == 3);
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "three") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_list_iterator_index (iterator) == 4);
	gee_list_iterator_set (iterator, "new three");
	g_assert (!gee_iterator_has_next ((GeeIterator*) iterator));
	g_assert (!gee_iterator_next ((GeeIterator*) iterator));
	g_assert (gee_iterator_first ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "new one") == 0);
	_g_free0 (_tmp5_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	g_assert (!gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator));
	g_assert (!gee_bidir_iterator_previous ((GeeBidirIterator*) iterator));
	g_assert (gee_bidir_iterator_last ((GeeBidirIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "new three") == 0);
	_g_free0 (_tmp6_);
	g_assert (gee_list_iterator_index (iterator) == 4);
	g_assert (!gee_iterator_has_next ((GeeIterator*) iterator));
	g_assert (!gee_iterator_next ((GeeIterator*) iterator));
	g_assert (gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator));
	g_assert (gee_bidir_iterator_previous ((GeeBidirIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "after two") == 0);
	_g_free0 (_tmp7_);
	g_assert (gee_list_iterator_index (iterator) == 3);
	g_assert (gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator));
	g_assert (gee_bidir_iterator_previous ((GeeBidirIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "new two") == 0);
	_g_free0 (_tmp8_);
	g_assert (gee_list_iterator_index (iterator) == 2);
	g_assert (gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator));
	g_assert (gee_bidir_iterator_previous ((GeeBidirIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "before two") == 0);
	_g_free0 (_tmp9_);
	g_assert (gee_list_iterator_index (iterator) == 1);
	g_assert (gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator));
	g_assert (gee_bidir_iterator_previous ((GeeBidirIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "new one") == 0);
	_g_free0 (_tmp10_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}


static void list_tests_real_test_duplicates_are_retained (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_contains ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 1);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_contains ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 2);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_contains ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 3);
	g_assert (gee_collection_remove ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_contains ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 2);
	g_assert (gee_collection_remove ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_contains ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 1);
	g_assert (gee_collection_remove ((GeeCollection*) test_list, "one"));
	g_assert (!gee_collection_contains ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 0);
	_g_object_unref0 (test_list);
}


void list_tests_test_duplicates_are_retained (ListTests* self) {
	LIST_TESTS_GET_CLASS (self)->test_duplicates_are_retained (self);
}


void list_tests_test_get (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	char* _tmp2_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp1_;
		_tmp1_ = (char*) gee_list_get (test_list, 0);
		_g_free0 (_tmp1_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (test_list, 0), "one") == 0);
	_g_free0 (_tmp2_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp3_;
		_tmp3_ = (char*) gee_list_get (test_list, 1);
		_g_free0 (_tmp3_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp4_;
		_tmp4_ = (char*) gee_list_get (test_list, -1);
		_g_free0 (_tmp4_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "three"));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (test_list, 0), "one") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (test_list, 1), "two") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_get (test_list, 2), "three") == 0);
	_g_free0 (_tmp7_);
	gee_collection_clear ((GeeCollection*) test_list);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp8_;
		_tmp8_ = (char*) gee_list_get (test_list, 0);
		_g_free0 (_tmp8_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_set (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 0);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_set (test_list, 0, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 0);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 1);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_list_get (test_list, 0), "one") == 0);
	_g_free0 (_tmp1_);
	gee_list_set (test_list, 0, "two");
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 1);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (test_list, 0), "two") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 1);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_set (test_list, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 1);
	_g_object_unref0 (test_list);
}


void list_tests_test_insert (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_insert (test_list, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 0);
	gee_list_insert (test_list, 0, "one");
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 1);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_list_get (test_list, 0), "one") == 0);
	_g_free0 (_tmp1_);
	gee_list_insert (test_list, 0, "two");
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (test_list, 0), "two") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (test_list, 1), "one") == 0);
	_g_free0 (_tmp3_);
	gee_list_insert (test_list, 1, "three");
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_get (test_list, 0), "two") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (test_list, 1), "three") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (test_list, 2), "one") == 0);
	_g_free0 (_tmp6_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_insert (test_list, 4, "four");
		exit (0);
	}
	g_test_trap_assert_failed ();
	gee_list_insert (test_list, 3, "four");
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_get (test_list, 0), "two") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_list_get (test_list, 1), "three") == 0);
	_g_free0 (_tmp8_);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_list_get (test_list, 2), "one") == 0);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_list_get (test_list, 3), "four") == 0);
	_g_free0 (_tmp10_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_insert (test_list, -1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_remove_at (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp1_;
		_tmp1_ = (char*) gee_list_remove_at (test_list, 0);
		_g_free0 (_tmp1_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp2_;
		_tmp2_ = (char*) gee_list_remove_at (test_list, 1);
		_g_free0 (_tmp2_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "five"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 5);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_remove_at (test_list, 0), "one") == 0);
	_g_free0 (_tmp3_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 4);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_get (test_list, 0), "two") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (test_list, 1), "three") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (test_list, 2), "four") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_get (test_list, 3), "five") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_list_remove_at (test_list, 3), "five") == 0);
	_g_free0 (_tmp8_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 3);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_list_get (test_list, 0), "two") == 0);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_list_get (test_list, 1), "three") == 0);
	_g_free0 (_tmp10_);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_list_get (test_list, 2), "four") == 0);
	_g_free0 (_tmp11_);
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_list_remove_at (test_list, 1), "three") == 0);
	_g_free0 (_tmp12_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 2);
	g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_list_get (test_list, 0), "two") == 0);
	_g_free0 (_tmp13_);
	g_assert (_vala_strcmp0 (_tmp14_ = (char*) gee_list_get (test_list, 1), "four") == 0);
	_g_free0 (_tmp14_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp15_;
		_tmp15_ = (char*) gee_list_remove_at (test_list, 2);
		_g_free0 (_tmp15_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp16_;
		_tmp16_ = (char*) gee_list_remove_at (test_list, -1);
		_g_free0 (_tmp16_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_index_of (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	g_assert (gee_list_index_of (test_list, "one") == (-1));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_list_index_of (test_list, "one") == 0);
	g_assert (gee_list_index_of (test_list, "two") == (-1));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "four"));
	g_assert (gee_list_index_of (test_list, "one") == 0);
	g_assert (gee_list_index_of (test_list, "two") == 1);
	g_assert (gee_list_index_of (test_list, "three") == 2);
	g_assert (gee_list_index_of (test_list, "four") == 3);
	g_assert (gee_list_index_of (test_list, "five") == (-1));
	_g_object_unref0 (test_list);
}


void list_tests_test_first (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	char* _tmp2_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp5_;
	char* _tmp7_;
	char* _tmp6_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp1_;
		_tmp1_ = (char*) gee_list_first (test_list);
		_g_free0 (_tmp1_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_first (test_list), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_first (test_list), _tmp4_ = (char*) gee_list_get (test_list, 0)) == 0);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "three"));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_first (test_list), "one") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_first (test_list), _tmp7_ = (char*) gee_list_get (test_list, 0)) == 0);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	gee_collection_clear ((GeeCollection*) test_list);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp8_;
		_tmp8_ = (char*) gee_list_first (test_list);
		_g_free0 (_tmp8_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_last (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	char* _tmp2_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp5_;
	char* _tmp7_;
	char* _tmp6_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp1_;
		_tmp1_ = (char*) gee_list_last (test_list);
		_g_free0 (_tmp1_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_last (test_list), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_last (test_list), _tmp4_ = (char*) gee_list_get (test_list, gee_collection_get_size ((GeeCollection*) test_list) - 1)) == 0);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "three"));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_last (test_list), "three") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_last (test_list), _tmp7_ = (char*) gee_list_get (test_list, gee_collection_get_size ((GeeCollection*) test_list) - 1)) == 0);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	gee_collection_clear ((GeeCollection*) test_list);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp8_;
		_tmp8_ = (char*) gee_list_last (test_list);
		_g_free0 (_tmp8_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_insert_all (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	GeeArrayList* dummy;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	char* _tmp17_;
	char* _tmp18_;
	char* _tmp19_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	dummy = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "zero"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 3);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy));
	gee_list_insert_all (test_list, 0, (GeeCollection*) dummy);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 3);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy));
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "zero"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "one"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "two"));
	g_assert (gee_collection_get_is_empty ((GeeCollection*) test_list));
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	gee_list_insert_all (test_list, 0, (GeeCollection*) dummy);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "zero"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "one"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "two"));
	g_assert (gee_collection_get_is_empty ((GeeCollection*) test_list));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_insert_all (test_list, 1, (GeeCollection*) dummy);
		exit (0);
	}
	g_test_trap_assert_failed ();
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "five"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "zero"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "one"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "two"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	gee_list_insert_all (test_list, 0, (GeeCollection*) dummy);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 6);
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_list_get (test_list, 0), "zero") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (test_list, 1), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (test_list, 2), "two") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_get (test_list, 3), "three") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (test_list, 4), "four") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (test_list, 5), "five") == 0);
	_g_free0 (_tmp6_);
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "zero"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "six"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "two"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "three"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "four"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 4);
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	gee_list_insert_all (test_list, 2, (GeeCollection*) dummy);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 7);
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_get (test_list, 0), "zero") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_list_get (test_list, 1), "one") == 0);
	_g_free0 (_tmp8_);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_list_get (test_list, 2), "two") == 0);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_list_get (test_list, 3), "three") == 0);
	_g_free0 (_tmp10_);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_list_get (test_list, 4), "four") == 0);
	_g_free0 (_tmp11_);
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_list_get (test_list, 5), "five") == 0);
	_g_free0 (_tmp12_);
	g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_list_get (test_list, 6), "six") == 0);
	_g_free0 (_tmp13_);
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "zero"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "three"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "four"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "five"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	gee_list_insert_all (test_list, 3, (GeeCollection*) dummy);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 6);
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (_vala_strcmp0 (_tmp14_ = (char*) gee_list_get (test_list, 0), "zero") == 0);
	_g_free0 (_tmp14_);
	g_assert (_vala_strcmp0 (_tmp15_ = (char*) gee_list_get (test_list, 1), "one") == 0);
	_g_free0 (_tmp15_);
	g_assert (_vala_strcmp0 (_tmp16_ = (char*) gee_list_get (test_list, 2), "two") == 0);
	_g_free0 (_tmp16_);
	g_assert (_vala_strcmp0 (_tmp17_ = (char*) gee_list_get (test_list, 3), "three") == 0);
	_g_free0 (_tmp17_);
	g_assert (_vala_strcmp0 (_tmp18_ = (char*) gee_list_get (test_list, 4), "four") == 0);
	_g_free0 (_tmp18_);
	g_assert (_vala_strcmp0 (_tmp19_ = (char*) gee_list_get (test_list, 5), "five") == 0);
	_g_free0 (_tmp19_);
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}


void list_tests_test_slice (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	GeeList* dummy;
	GeeList* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	dummy = NULL;
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp1_;
		dummy = (_tmp1_ = gee_list_slice (test_list, 1, 4), _g_object_unref0 (dummy), _tmp1_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_add ((GeeCollection*) test_list, "zero"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "five"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 6);
	dummy = (_tmp2_ = gee_list_slice (test_list, 1, 4), _g_object_unref0 (dummy), _tmp2_);
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) test_list) == 6);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (dummy, 0), "one") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_get (dummy, 1), "two") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (dummy, 2), "three") == 0);
	_g_free0 (_tmp5_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		GeeList* _tmp6_;
		dummy = (_tmp6_ = gee_list_slice (test_list, 0, 9), _g_object_unref0 (dummy), _tmp6_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}


static void list_tests_class_init (ListTestsClass * klass) {
	list_tests_parent_class = g_type_class_peek_parent (klass);
	LIST_TESTS_CLASS (klass)->test_duplicates_are_retained = list_tests_real_test_duplicates_are_retained;
}


static void list_tests_instance_init (ListTests * self) {
}


GType list_tests_get_type (void) {
	static volatile gsize list_tests_type_id__volatile = 0;
	if (g_once_init_enter (&list_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListTests), 0, (GInstanceInitFunc) list_tests_instance_init, NULL };
		GType list_tests_type_id;
		list_tests_type_id = g_type_register_static (TYPE_COLLECTION_TESTS, "ListTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&list_tests_type_id__volatile, list_tests_type_id);
	}
	return list_tests_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




